#include "vaxmhs_subs.h"

/*
  Mail ermitteln. Aus der Zugriffsliste wird eine Mail ermittelt, die
  so gefuellt ist, dass ein folgendes 'isendmb_' den richtigen Empfaenger
  trifft. Dazu wird je nach Position des Empfaenger lokal oder in einem
  anderen Rechner der Empfaengerexchange auf den direkten Wert oder den
  'netxid' gesetzt. Diverse Felder der neuen Mail werden auf Default-
  werte gesetzt.
*/
icalcmb_(mp,accl)
int *mp;
struct accesslist *accl;
{
 int err,com = NM_COM;
 struct mailbox *mbox;

 if ( !accl->addr[0] && bcmp(&accl->com,&com,4) ) return ERRARG;
 if ( err = IGETMB(mp,&com) ) return err;
 mbox = vaxmhs_data.vd_boxes+*mp;
 if ( !accl->addr[0] )
  {
   LONG(&accl->xid,&mbox->mbrxid);
   mbox->mbrnet[0] = 0;
  }
 else
  {
   mbox->mbrxid = vaxmhs_data.netxid;
   bcopy(accl->addr,mbox->mbrnet,sizeof(mbox->mbrnet));
   LONG(&accl->com,&mbox->mbicom);
   LONG(&accl->xid,&mbox->mbixid);
  }
 mbox->mbcode = mbox->mbexpd = mbox->mblen = mbox->mbres = mbox->mbstatus = 0;
 return 0;
}
