#include <stdio.h>

#ifdef vms
#include "vm:vaxmhs_data.h"
#else
#include "vaxmhs_data.h"
#endif

#define ERR(m)		{ fprintf(stderr,"%s\n",m); exit(1); }


main(argc,argv)
int argc;
char **argv;
{
 int val,null = 0,opt,err,mb,wait = 100,ix,pref = 0x88005650,list[4];
 struct mailbox *mbox;
 short code = 49,len = 6,addr;

 VMEINI();
 VMELOG(list,"BRIDGE  ",&null,&opt,&err);
 if ( err ) ERR("no logical address");
 if ( (argc > 1) && ((val = atoi(argv[1])) > 0) && (val < 16) )
  {
   addr = 0x6f00+16*val;
   SLONG(&pref,list+0);
   SWORD(&addr,list+1);
  }
 if ( ICALCMB(&mb,list) ) ERR("got no mail");  
 mbox = vaxmhs_data.vd_boxes+mb;
 SWORD(&code,&mbox->mbcode);
#ifdef vms
 mbox->mbstatus.wrbit = mbox->mbstatus.erbit = 1;
#else
 mbox->mbstatus |= WRBIT|ERBIT;
#endif
 SWORD(&len,&mbox->mblen);
 for ( ix = 0 ; ix < 6 ; ix++ ) mbox->mbdata[ix] = 0; 
 SNDMAIL(&mb,&err,&wait);
 if ( err ) ERR("got no answer");
 mbox = vaxmhs_data.vd_boxes+mb;
 SWORD(mbox->mbtnet+2,&addr);
 printf("Bridge %04X\n",addr);
 if ( addr&16 )
  {
   display("VAX-Seite",mbox->mbdata+0);
   display("VIP-Seite",mbox->mbdata+51);
  }
 else
  {
   display("VAX-Seite",mbox->mbdata+51);
   display("VIP-Seite",mbox->mbdata+0);
  }
 IADDMB(&mb);
 UNLOAD();
}

struct bdata
       {
        unsigned int	cpin;
	unsigned int	cpout;
	unsigned short	cmerr;
	unsigned int	cmiss;
	unsigned int	cbabl;
	unsigned short	ccerr;
	unsigned short	ccrc;
	unsigned short	coflo;
	unsigned int	cbuff;
	unsigned short	clcol;
	unsigned short	clcar;
	unsigned int	crtry;
	unsigned int	cindef;
	unsigned short	caddr[4];
	unsigned short	cinit;
       };

char *was[8] = { "EVEN","STAT","ERRO","TEST","RESE","MUON","????","VNET" };

display(seite,daten)
char *seite,*daten;
{
 int acnt = 4,ix;
 struct bdata br;
 short help;

 SLONG(daten+1,&br.cpin);
 SLONG(daten+5,&br.cpout);
 SWORD(daten+9,&br.cmerr);
 SLONG(daten+11,&br.cmiss);
 SLONG(daten+15,&br.cbabl);
 SWORD(daten+19,&br.ccerr);
 SWORD(daten+21,&br.ccrc);
 SWORD(daten+23,&br.coflo);
 SLONG(daten+25,&br.cbuff);
 SWORD(daten+29,&br.clcol);
 SWORD(daten+31,&br.clcar);
 SLONG(daten+33,&br.crtry);
 SLONG(daten+37,&br.cindef);
 SWARR(daten+41,br.caddr,&acnt);
 SWORD(daten+49,&br.cinit);
 help = daten[0];
 printf("\n%s\n Transparent: ",seite);
 for ( ix = 0 ; ix < 8 ; ix++ )
  if ( help&(1<<ix) )
   printf("%s ",was[ix]);
 printf("\n Empfangen: %11u - Gesendet: %11u - Adressen:%4u+%3u+%3u (%6u)\n\n",
        br.cpin,br.cpout,br.caddr[1],br.caddr[2],br.caddr[3],br.caddr[0]);
 printf(" Missed:%10u     -   BABL:%10u     - Retry:%10u\n",
        br.cmiss,br.cbabl,br.crtry);
 printf("   MERR:%10u     - O/UFLO:%10u     -  BUFF:%10u\n",
        br.cmerr,br.coflo,br.cbuff);
 printf("   CERR:%10u     -   LCOL:%10u     -  LCAR:%10u\n",
	br.ccerr,br.clcol,br.clcar);
 printf("    CRC:%10u          ; Sonstige Fehler:%10u\n",br.ccrc,br.cindef);
 printf("\n Der LANCE wurde %5umal initialisiert.\n",br.cinit);  
}
