#!/sbin/sh

#
# yesno(message,default)
#
yesno()
{
 key="."
 while [ "$key" = "." ]
 do
   if [ "$2" = "" ] ; then
     echo "$1 \c"
   else
     echo "$1 [$2] \c"
   fi
   read key
   if [ "$key" = "" ] ; then
     key="$2"
   fi
   case $key in
     "y"|"Y"|"yes"|"YES"|"Yes") return 0;;
     "n"|"N"|"no"|"NO"|"No")    return 1;;
     *)				key=".";;
   esac
 done
}

#
# not(expr)
#
not()
{
 if "$@" 
 then
   return 1
 else
   return 0
 fi
}

#
# verify_name(message,default)
#
verify_name()
{
 loop=1
 while [ "$loop" = "1" ]
 do
   loop=0
   if [ "$2" = "" ] ; then 
     echo "$1: \c"
   else
     echo "$1 [$2]: \c"
   fi
   reply=""
   read reply
   if [ "$reply" = "" ] ; then
     if [ "$2" = "" ] ; then
       loop=1
     else
       reply="$2"
     fi
   fi
   if [ "$loop" = "0" ] ; then
     loop=1
     if yesno "[$reply] correct ? " y ; then
       loop=0
     fi
   fi
 done
}

#
# check_delete(file)
#
check_delete()
{
 if [ -f "$1" ] ; then
   if yesno "$1 already exists. Delete it ? " n ; then
     rm -f "$1"
   fi
 fi
}

#
# editor()
#
editor()
{
 while [ "$EDITOR" = "" ]
 do
   verify_name "\nEnter the name of your preferred editor" "$DEFAULT_EDITOR"
   if [ -x "$reply" ] ; then
     EDITOR=$reply
   else
     echo "\nNo such program ${reply}"
     EDITOR=""
   fi
 done
}

#
# check_edit(file)
#
check_edit()
{
 if yesno "\nDo you want to configure your local $1 file" n ; then
   editor
   $EDITOR "$1"
 fi
}

#
# from_proto(file)
#
from_proto()
{
 if [ ! -f "$1" ] ; then
   if [ -f "$1".proto ] ; then
     echo creating "$1" from prototype
     cp "$1".proto "$1"
   else
     echo "$1" not found and no prototype file
     exit 1
   fi
 fi
}

#
# enter_DCL_tool(tool)
#
enter_DCL_tool()
{
 startup="$DCLDIR"/init/startup.com

 line1=`grep -n '$!TOOLS_START' "$startup" | cut -d: -f1`
 line2=`grep -n '$!TOOLS_END' "$startup" | cut -d: -f1`
 if [ -z "$line1" ] ; then
   return 1
 fi
 if [ -z "$line2" ] ; then
   return 1
 fi
 line1=`expr $line1 + 1`

 while [ $line1 -lt $line2 ]
 do
   cur=`head -$line1 "$startup" | tail -1 | sed -n 's/^[^]:]*[]:]\([^	 ]*\)[	]*.*$/\1/p'`
   if [ "$1" = "$cur" ] ; then
     return 0
   fi
   line1=`expr $line1 + 1`
 done

 dollar='$'
 sed $line2"i\\
$dollar @sys${dollar}manager:$1" "$DCLDIR"/init/startup.com > "$DCLDIR"/init/startup.$$
 mv "$DCLDIR"/init/startup.$$ "$DCLDIR"/init/startup.com

 return 0
}

#
# replace_authunix(host,dir)
#
replace_authunix()
{
 cd /tmp
 rm -f libc.a auth_unix.o
 rcp "$1":/usr/lib/"$2"libc.a libc.a
 ar xv libc.a auth_unix.o
 ar rv /usr/lib/"$2"libc.a auth_unix.o
 rm -f libc.a auth_unix.o
}

#
# install_dcl()
#
install_dcl()
{
#
# check for prototype files
#
 initdir="$DCLDIR"/init
 from_proto "$initdir"/startup
 from_proto "$initdir"/startup.com
 from_proto "$initdir"/startup_local.com
 from_proto "$initdir"/sylogin.com

#
# edit startup_local.com
#
 cat <<EOF

 - You may want to setup your local DCL environment e.g. disk and tape logical
 - names in your startup_local.com file. If you are to install the queue
 - manager BOSS for SAPHIR you should not edit your startup_local.com now.
EOF
 check_edit "$initdir"/startup_local.com

#
# edit sylogin.com
#
 cat <<EOF

 - The command file sylogin.com will be executed each time a user actives the
 - DCL shell before his or her personal login.com will be executed. 
EOF
 check_edit "$initdir"/sylogin.com
}

#
# install_queue(level)
#
install_queue()
{
#
# setup DCL command file from prototype
#
 from_proto "$DCLDIR"/init/bossqueue.com

#
# localize bossqueue.com
#
 cat <<EOF

 - You may want to enter the name of your queue manager dispatcher host,
 - which will be installed as a SERVER host later on. To this modify the
 - logical names in bossqueue.com.
EOF
 check_edit "$DCLDIR"/init/bossqueue.com

#
# enter bossqueue.com to startup.com
#
 if enter_DCL_tool bossqueue
 then
   cat <<EOF

   - Your primary DCL startup command file startup.com has been modified to
   - call the bossqueue.com command file in its tools initialization area.
   - You may choose to correct the order of initialization of the tools.
EOF
   check_edit "$DCLDIR"/init/startup.com
 fi
}

#
# install_boss()
#
install_boss()
{
#
# DCL command file directory
#
 initdir="$DCLDIR"/init

#
# create and/or modify startup_local_devices.com
#
 from_proto "$initdir"/startup_local_devices.com
 cat <<EOF

 - Your local startup_local_devices.com file includes logical names for all
 - root directories of the BOSS hosts. Normally the file system installation
 - script will adapt it to your needs. So you should not edit that file until
 - you know what you are doing.
EOF
 check_edit "$initdir"/startup_local_devices.com

#
# create and/or modify startup_local.com
#
 cat <<EOF

 - If your startup_local.com is not yet configured you may want it to be 
 - created from the BOSS/SAPHIR prototype file which will supersede the
 - prototype from the DCL setup.
EOF
 if yesno "\nDo you want to supersede your startup_local.com file" n ; then
   if [ ! -f "$initdir"/startup_local_boss.com.proto ] ; then
     echo BOSS/SAPHIR prototype file does not exists
     exit 1
   fi   
   cp "$initdir"/startup_local_boss.com.proto "$initdir"/startup_local.com
 fi

#
# edit startup_local.com
#
 cat <<EOF

 - You may want to setup your local BOSS/SAPHIR environment e.g. disk and 
 - tape logical names in your startup_local.com file. 
EOF
 check_edit "$initdir"/startup_local.com
}

#
# install_usr()
#
install_usr()
{
#
# Copy libraries with corrected 'auth_unix.o'
#
 cat <<EOF

 - The current version of SUNs RPC library includes an error in the routine
 - authunix_validate which is used with UNIX authentication. You may want
 - it to be replaced in your /usr/lib/libc.a and /usr/lib/libp/libc.a
 - libraries from another BOSS host. If you do not want to do so enter
 - none (all lowercase) to the following question. rcp must be working to
 - do this installation.
EOF
 verify_name "\nEnter the name of the host with a correct libc.a" none
 if [ "$reply" != "none" ] ; then
   replace_authunix "$reply"
   replace_authunix "$reply" libp/ 
 fi

#
# Install Motif Window Manager default file
#
 mwmfile="${usr}/opt/X11/lib/system.mwmrc"
 mwmboss="${usr}/opt/X11/lib/boss.mwmrc"
 if [ -f "$mwmfile" ] ; then
   if yesno "\nShould I overwrite the MWM default file" n ; then
     if yesno "Should I save the current MWM default file" y ; then
       cp "$mwmfile" "$mwmfile"~
     fi
   else
     mwmboss=
   fi
 fi
 if [ ! -z "$mwmboss" ] ; then
   echo "installing ${mwmfile} from prototype ${mwmboss}"
   cp "$mwmboss" "$mwmfile"
 fi

#
# Install /usr/local and /usr/global
#
 echo "creating links /usr/local and /usr/global"
 if [ -h "${usr}/local" ] ; then
   rm -f "${usr}/local"
 fi
 ln -s "$project"/files/usr/local "${usr}/local"
 if [ -h "${usr}/global" ] ; then
   rm -f "${usr}/global"
 fi
 ln -s local/../global "${usr}/global"
}

#
# install_protection()
#
install_protection()
{
#
# Change group and protection of the following files
#
 verify_name "\nEnter group name for all utility files" saphadm
 group="$reply"
 cat <<EOF | while read line ; do
bin/CDU
bin/DCL
bin/QMan
bin/cli
bin/dcl
bin/f77
bin/getserventd
bin/gt
bin/lnmd
bin/pdl
bin/telnet1
bin/telnet2
bin/tn3270
bin/whoisd
catman/S_man
converter
dcl
etc/master.d/boss
games
gnu
include/saphir
lib/libDCL.a
lib/libmhs.a
lib/libsaphir.a
lib/X11/uid/QMan.uid
mhs
rpc.startup
tables
EOF
   protection "$group" `find "${usr}/$line" -print`
 done
 cat <<EOF | while read line ; do
contrib/saphir/src/queue/queue_root.csh
gnu
EOF
   protection "$group" `find "${usr}/opt/$line" -print`
 done
}

#
# protection(group,list)
#
protection()
{
 togrp="$1"
 shift
 while [ ! -z "$1" ] ; do
   chgrp "$togrp" "$1"
   chmod g+w,o-w "$1"
   shift
 done
}

#
# saphir.do rootdir usrdir
#
if [ $# -ge 2 ] ; then
  root="$1"
  usr="$2"
else
  root=/
  usr=/usr
fi

#
# setup for environments
#
BINDIR="${usr}/bin"
LIBDIR="${usr}/lib"
INCDIR="${usr}/include"

TABDIR="${usr}/tables"
PORTABLE=portable

DIRDEF=saphir
INCDEF=modules
DCLDIR="${usr}/dcl"
MHSDIR="${usr}/mhs"
CONDIR="${usr}/converter"
DEVLIB="${usr}/src/uts/aviion/lb/boss.a"

RPCDIR="${usr}/rpc.startup"

export BINDIR LIBDIR INCDIR TABDIR PORTABLE DIRDEF INCDEF DCLDIR MHSDIR DEVDIR
export CONDIR RPCDIR

#
# Bad umask from caller
#
umask 002

#
# setup variables
#
EDITOR="" ; DEFAULT_EDITOR="${usr}/bin/vi"

#
# check project files
#
project="${usr}/opt/contrib/$DIRDEF"
if [ ! -d $project ] ; then
   echo "\nProject directory $project does not exist"
   exit 1
fi

#
# check installation files
#
source="$project/src"
if [ ! -d $source ] ; then
   echo "\nProject installation tree $source does not exist"
   exit 1
fi

#
# installations
#
install_dcl
install_queue user
install_boss
install_usr
install_protection
