#!/sbin/sh

#
# yesno(message,default)
#
yesno()
{
 key="."
 while [ "$key" = "." ]
 do
   if [ "$2" = "" ] ; then
     echo "$1 \c"
   else
     echo "$1 [$2] \c"
   fi
   read key
   if [ "$key" = "" ] ; then
     key="$2"
   fi
   case $key in
     "y"|"Y"|"yes"|"YES"|"Yes") return 0;;
     "n"|"N"|"no"|"NO"|"No")    return 1;;
     *)				key=".";;
   esac
 done
}

#
# not(expr)
#
not()
{
 if "$@" 
 then
   return 1
 else
   return 0
 fi
}

#
# verify_name(message,default)
#
verify_name()
{
 loop=1
 while [ "$loop" = "1" ]
 do
   loop=0
   if [ "$2" = "" ] ; then 
     echo "$1: \c"
   else
     echo "$1 [$2]: \c"
   fi
   reply=""
   read reply
   if [ "$reply" = "" ] ; then
     if [ "$2" = "" ] ; then
       loop=1
     else
       reply="$2"
     fi
   fi
   if [ "$loop" = "0" ] ; then
     loop=1
     if yesno "[$reply] correct ? " y ; then
       loop=0
     fi
   fi
 done
}

#
# check_delete(file)
#
check_delete()
{
 if [ -f "$1" ] ; then
   if yesno "$1 already exists. Delete it ? " n ; then
     rm -f "$1"
   fi
 fi
}

#
# editor()
#
editor()
{
 while [ "$EDITOR" = "" ]
 do
   verify_name "\nEnter the name of your preferred editor" "$DEFAULT_EDITOR"
   if [ -x "$reply" ] ; then
     EDITOR=$reply
   else
     echo "\nNo such program ${reply}"
     EDITOR=""
   fi
 done
}

#
# check_edit(file)
#
check_edit()
{
 if yesno "\nDo you want to configure your local $1 file" n ; then
   editor
   $EDITOR "$1"
 fi
}

#
# from_proto(file)
#
from_proto()
{
 if [ ! -f "$1" ] ; then
   if [ -f "$1".proto ] ; then
     echo creating "$1" from prototype
     cp "$1".proto "$1"
   else
     echo "$1" not found and no prototype file
     exit 1
   fi
 fi
}

#
# enter_DCL_tool(tool)
#
enter_DCL_tool()
{
 startup="$DCLDIR"/init/startup.com

 line1=`grep -n '$!TOOLS_START' "$startup" | cut -d: -f1`
 line2=`grep -n '$!TOOLS_END' "$startup" | cut -d: -f1`
 if [ -z "$line1" ] ; then
   return 1
 fi
 if [ -z "$line2" ] ; then
   return 1
 fi
 line1=`expr $line1 + 1`

 while [ $line1 -lt $line2 ]
 do
   cur=`head -$line1 "$startup" | tail -1 | sed -n 's/^[^]:]*[]:]\([^	 ]*\)[	]*.*$/\1/p'`
   if [ "$1" = "$cur" ] ; then
     return 0
   fi
   line1=`expr $line1 + 1`
 done

 dollar='$'
 sed $line2"i\\
$dollar @sys${dollar}manager:$1" "$DCLDIR"/init/startup.com > "$DCLDIR"/init/startup.$$
 mv "$DCLDIR"/init/startup.$$ "$DCLDIR"/init/startup.com

 return 0
}

#
# install_parser()
#
install_parser()
{
#
# set parser directory
#
 parser="$source/parser"
   
#
# check files
#
 if [ ! -d $parser ] ; then
    echo "\nParser subdirectory $parser does not exist"
    exit 1
 fi
 cd $parser
 if [ ! -d $PORTABLE ] ; then
   echo "\nPorting directory $parser/$PORTABLE does not exist"
   exit 1
 fi
 if [ ! -r PortParse.csh ] ; then
   echo "\nInstallation utility PortParse.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for parser 2.2"
 csh PortParse.csh use $DIRDEF $INCDEF
}

#
# install_cld(level)
#
install_cld()
{
#
# get name
#
 cld="$source/cld"
   
#
# check files
#
 if [ ! -d $cld ] ; then
    echo "\nCommand language definition subdirectory $cld does not exist"
    exit 1
 fi
 cd $cld
 if [ ! -r cld.csh ] ; then
   echo "\nInstallation utility cld.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for command language definition 1.4"
 csh cld.csh $1 $DIRDEF $INCDEF
}

#
# install_modules()
#
install_modules()
{
#
# get name
#
 modules="$source/modules"
   
#
# check files
#
 if [ ! -d $modules ] ; then
    echo "\nCommand language definition modules subdirectory $modules does not exist"
    exit 1
 fi
 cd $modules
 if [ ! -r modules.csh ] ; then
   echo "\nInstallation utility modules.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for command language definition modules 1.1"
 csh modules.csh $DIRDEF $INCDEF
}

#
# install_vms(directory)
#
install_vms()
{
#
# get name
#
 vms="$source/$1"
   
#
# check files
#
 if [ ! -d $vms ] ; then
    echo "\nVMS library subdirectory $vms does not exist"
    exit 1
 fi
 cd $vms
 if [ ! -r vms.csh ] ; then
   echo "\nInstallation utility vms.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for VMS library $1"
 csh vms.csh $DIRDEF
}

#
# install_utilities()
#
install_utilities()
{
#
# get name
#
 utilities="$source/utilities"
   
#
# check files
#
 if [ ! -d $utilities ] ; then
    echo "\nUtilities subdirectory $utilities does not exist"
    exit 1
 fi
 cd $utilities
 if [ ! -r util.csh ] ; then
   echo "\nInstallation utility utilities.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for utilities 1.1"
 csh util.csh $DIRDEF
}

#
# install_lnm(level)
#
install_lnm()
{
#
# get name
#
 lnm="$source/lnm"
   
#
# check files
#
 if [ ! -d $lnm ] ; then
    echo "\nLogical name support subdirectory $lnm does not exist"
    exit 1
 fi
 cd $lnm
 if [ ! -r lnm.csh ] ; then
   echo "\nInstallation utility lnm.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for logical name support 1.1"
 csh lnm.csh $1 $DIRDEF
}

#
# install_cdu()
#
install_cdu()
{
#
# get name
#
 cdu="$source/cdu"
   
#
# check files
#
 if [ ! -d $cdu ] ; then
    echo "\nCommand definition utility subdirectory $cdu does not exist"
    exit 1
 fi
 cd $cdu
 if [ ! -r cdu.csh ] ; then
   echo "\nInstallation utility cdu.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for command definition utility 1.4"
 csh cdu.csh $DIRDEF
}

#
# install_dcl()
#
install_dcl()
{
#
# get name
#
 dcl="$source/dcl"
   
#
# check files
#
 if [ ! -d $dcl ] ; then
    echo "\ndigital command language subdirectory $dcl does not exist"
    exit 1
 fi
 cd $dcl
 if [ ! -r DCL_user.csh ] ; then
   echo "\nInstallation utility DCL_user.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for digital command language 1.4"
 csh DCL_user.csh $DIRDEF $DCLDIR
}

#
# install_sos()
#
install_sos()
{
#
# get name
#
 sos="$source/sos"
   
#
# check files
#
 if [ ! -d $sos ] ; then
    echo "\npSOS mail handling system subdirectory $sos does not exist"
    exit 1
 fi
 cd $sos
 if [ ! -r mhs.csh ] ; then
   echo "\nInstallation utility mhs.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for SOS mail handling system IV.5"
 csh mhs.csh $DIRDEF $MHSDIR $DEVLIB
}

#
# install_parallel()
#
install_parallel()
{
#
# get name
#
 parallel="$source/parallel"
   
#
# check files
#
 if [ ! -d $parallel ] ; then
    echo "\nparallel driver subdirectory $parallel does not exist"
    exit 1
 fi
 cd $parallel
 if [ ! -r parallel.csh ] ; then
   echo "\nInstallation utility parallel.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning installation for paralleldriver 1.1"
 csh parallel.csh $DIRDEF $DEVLIB
}

#
# install_queue(level)
#
install_queue()
{
#
# get name
#
 queue="$source/queue"
   
#
# check files
#
 if [ ! -d $queue ] ; then
    echo "\nBOSS queue subdirectory $queue does not exist"
    exit 1
 fi
 cd $queue
 if [ ! -r queue_$1.csh ] ; then
   echo "\nInstallation utility queue_$1.csh does not exist"
   exit 1
 fi

#
# complete installation
#
 echo "\n\nrunning $1 installation for BOSS queue 4.14"
 csh queue_$1.csh $DIRDEF $CONDIR $MHSDIR $DCLDIR $RPCDIR
}

#
# install_boss()
#
install_boss()
{
#
# get name
#
 boss_init="$source/init"

#
# check files
#
 if [ ! -d $boss_init ] ; then
    echo "\nBOSS/SAPHIR installation subdirectory $boss_init does not exist"
    exit 1
 fi
 cd $boss_init
 if [ ! -d "$DCLDIR"/init ] ; then
   echo "\ndirectory ${DCLDIR}/init for DCL startup command files does not exist"
   exit 1
 fi
   
#
# complete installation
#
 echo "\n\nrunning installation for BOSS/SAPHIR 1.1"
 cp *.proto "$DCLDIR"/init
 echo "+++ BOSS/SAPHIR installation complete"
}

#
# saphir.do rootdir usrdir
#
if [ $# -ge 2 ] ; then
  root="$1"
  usr="$2"
else
  root=/
  usr=/usr
fi

#
# setup for environments
#
BINDIR="${usr}/bin"
LIBDIR="${usr}/lib"
INCDIR="${usr}/include"

TABDIR="${usr}/tables"
PORTABLE=portable

DIRDEF=saphir
INCDEF=modules
DCLDIR="${usr}/dcl"
MHSDIR="${usr}/mhs"
CONDIR="${usr}/converter"
DEVLIB="${usr}/src/uts/aviion/lb/boss.a"

RPCDIR="${usr}/rpc.startup"

export BINDIR LIBDIR INCDIR TABDIR PORTABLE DIRDEF INCDEF DCLDIR MHSDIR DEVDIR
export CONDIR RPCDIR

#
# Bad umask from caller
#
umask 002

#
# setup variables
#
EDITOR="" ; DEFAULT_EDITOR="${usr}/bin/vi"

#
# check project files
#
project="${usr}/opt/contrib/$DIRDEF"
if [ ! -d $project ] ; then
   echo "\nProject directory $project does not exist"
   exit 1
fi

#
# perhaps files from tape must not be rebuilt
#
if yesno "Do really want to install project $DIRDEF from sources ?" n ; then
   echo "\nInstalling project from sources"
else
   echo "\nUsing project files from tape"
   exit 0
fi

#
# check installation files
#
source="$project/src"
if [ ! -d $source ] ; then
   echo "\nProject installation tree $source does not exist"
   exit 1
fi

#
# installations
#
install_parser
install_utilities
install_cld header
install_modules
install_cld objects
install_lnm header
install_vms vmssupport
install_lnm objects
install_vms vmslib
install_cdu
install_dcl
install_sos
install_parallel
install_queue user
install_boss
