#!/sbin/sh

#
# not(expr)
#
not()
{
 if "$@" 
 then
   return 1
 else
   return 0
 fi
}

#
# yesno(message,default)
#
yesno()
{
 key="."
 while [ "$key" = "." ]
 do
   if [ "$2" = "" ] ; then
     echo "$1 \c"
   else
     echo "$1 [$2] \c"
   fi
   read key
   if [ "$key" = "" ] ; then
     key="$2"
   fi
   case $key in
     "y"|"Y"|"yes"|"YES"|"Yes") return 0;;
     "n"|"N"|"no"|"NO"|"No")    return 1;;
     *)				key=".";;
   esac
 done
}

#
# verify_name(message,default)
#
verify_name()
{
 loop=1
 while [ "$loop" = "1" ]
 do
   loop=0
   if [ "$2" = "" ] ; then 
     echo "$1: \c"
   else
     echo "$1 [$2]: \c"
   fi
   reply=""
   read reply
   if [ "$reply" = "" ] ; then
     if [ "$2" = "" ] ; then
       loop=1
     else
       reply="$2"
     fi
   fi
   if [ "$loop" = "0" ] ; then
     if not yesno "[$reply] correct ? " y
     then
       loop=1
     fi
   fi
 done
}

#
# protection(group,list)
#
protection()
{
 togrp="$1"
 shift
 while [ ! -z "$1" ] ; do
   chgrp "$togrp" "$1"
   chmod g+w,o-w "$1"
   shift
 done
}

#
# saphir.src.do rootdir usrdir
#
if [ $# -ge 2 ] ; then
  root="$1"
  usr="$2"
fi

#
# Bad umask from caller
#
umask 002

#
# Message only
#
cat <<EOF
  
 - You may decide to overwrite your YP masters /etc/yp/Makefile with the
 - BOSS/SAPHIR default /etc/yp/Makefile.boss. If not and you set up the
 - YP databanks with a domain name server don't forget to modify the
 - INTERDOMAIN switch to -b.
EOF

#
# Change group and protection of the following files
#
verify_name "\nEnter group name for all utility files" saphadm
group="$reply"
cat <<EOF | while read line ; do
contrib/saphir/src
contrib/saphir/files/usr/global
contrib/saphir/files/usr/local/bin
contrib/saphir/files/usr/local/lib
contrib/saphir/files/usr/local/catman
EOF
  protection "$group" `find "${usr}/opt/$line" -print`
done


