#!/sbin/sh

#
# yesno(message,default)
#
yesno()
{
 key="."
 while [ "$key" = "." ]
 do
   if [ "$2" = "" ] ; then
     echo "$1 \c"
   else
     echo "$1 [$2] \c"
   fi
   read key
   if [ "$key" = "" ] ; then
     key="$2"
   fi
   case $key in
     "y"|"Y"|"yes"|"YES"|"Yes") return 0;;
     "n"|"N"|"no"|"NO"|"No")    return 1;;
     *)				key=".";;
   esac
 done
}

#
# not(expr)
#
not()
{
 if "$@" 
 then
   return 1
 else
   return 0
 fi
}

#
# verify_name(message,default)
#
verify_name()
{
 loop=1
 while [ "$loop" = "1" ]
 do
   loop=0
   if [ "$2" = "" ] ; then 
     echo "$1: \c"
   else
     echo "$1 [$2]: \c"
   fi
   reply=""
   read reply
   if [ "$reply" = "" ] ; then
     if [ "$2" = "" ] ; then
       loop=1
     else
       reply="$2"
     fi
   fi
   if [ "$loop" = "0" ] ; then
     if not yesno "[$reply] correct ? " y
     then
       loop=1
     fi
   fi
 done
}

#
# check_delete(file)
#
check_delete()
{
 if [ -f "$1" ] ; then
   if yesno "$1 already exists. Delete it ? " n ; then
     rm -f "$1"
   fi
 fi
}

#
# editor()
#
editor()
{
 while [ "$EDITOR" = "" ]
 do
   verify_name "\nEnter the name of your preferred editor" "$DEFAULT_EDITOR"
   if [ -x "$reply" ] ; then
     EDITOR=$reply
   else
     echo "\nNo such program ${reply}"
     EDITOR=""
   fi
 done
}

#
# check_edit(file)
#
check_edit()
{
 if yesno "\nDo you want to configure your local $1 file" n ; then
   editor
   $EDITOR "$1"
 fi
}

#
# from_proto(file)
#
from_proto()
{
 if [ ! -f "$1" ] ; then
   if [ -f "$1".proto ] ; then
     echo creating "$1" from prototype
     cp "$1".proto "$1"
   else
     echo "$1" not found and no prototype file
     exit 1
   fi
 fi
}

#
# enter_DCL_tool(tool)
#
enter_DCL_tool()
{
 startup="$DCLDIR"/init/startup.com

 line1=`grep -n '$!TOOLS_START' "$startup" | cut -d: -f1`
 line2=`grep -n '$!TOOLS_END' "$startup" | cut -d: -f1`
 if [ -z "$line1" ] ; then
   return 1
 fi
 if [ -z "$line2" ] ; then
   return 1
 fi
 line1=`expr $line1 + 1`

 while [ $line1 -lt $line2 ]
 do
   cur=`head -$line1 "$startup" | tail -1 | sed -n 's/^[^]:]*[]:]\([^	 ]*\)[	]*.*$/\1/p'`
   if [ "$1" = "$cur" ] ; then
     return 0
   fi
   line1=`expr $line1 + 1`
 done

 dollar='$'
 sed $line2"i\\
$dollar @sys${dollar}manager:$1" "$DCLDIR"/init/startup.com > "$DCLDIR"/init/startup.$$
 mv "$DCLDIR"/init/startup.$$ "$DCLDIR"/init/startup.com

 return 0
}

#
# create_hostlist(file)
#
create_hostlist()
{
 file="$root$1"
 if yesno "\nCreate $1 from hostlist" y ; then
   echo "+\c"
   if [ ! -f "$file" ] ; then
     echo "\c" > "$file"
   fi
   set -- `echo $hosts | tr ",:" "  "`
   while [ ! -z "$1" ] ; do
     echo ".\c"
     grep > /dev/null "$1" "$file"
     if [ $? -ne 0 ] ; then
       echo "$1" >> "$file"
     fi
     shift
   done
   echo
 fi
}

#
# add_fstab(fsline)
#
add_fstab()
{
 grep "^[^#]" "${root}/etc/fstab" | grep > /dev/null "[ 	]$2[ 	]"
 if [ $? -ne 0 ] ; then
   echo Adding entry for "$2" to /etc/fstab
   echo "$*" >> "${root}/etc/fstab"
   echo $2 | grep > /dev/null "^/usr/" 
   if [ $? -eq 0 ] ; then
     if [ "$OSMODE" = CLIENT ] ; then
       return
     fi
     dir="$usr`echo $2 | cut -c 4-`"
   else
     dir="$root$2"
   fi
   if [ ! -d "$dir" ] ; then
     echo Creating control point directory "$2"
     set -- `echo $dir | tr / " "`
     cd /
     while [ ! -z "$1" ] ; do
       if [ ! -d "$1" ] ; then
	 mkdir "$1"
       fi
       cd "$1"
       shift
     done 
   fi
 fi
}

#
# add_server(list)
#
add_server()
{
 host="$1"
 shift
 if [ "$host" != "$MYNAME" ] ; then
   add_fstab "$host":/ /"$host"/root nfs ro,soft,bg x 0
   add_fstab "$host":/usr /"$host"/usr nfs ro,soft,bg x 0
   add_fstab "$host":/usr/opt/X11 /"$host"/X11 nfs ro,soft,bg x 0
 fi
 while [ ! -z "$1" ] ; do
   if [ "$1" != "$MYNAME" ] ; then
     if [ ! -d "${root}/$1" ] ; then
       mkdir "${root}/$1"
     fi
     cd "${root}/$1"
     rm > /dev/null 2> /dev/null -f root usr X11
     if [ "$host" = "$MYNAME" ] ; then
       ln -s /srv/release/PRIMARY/root/"$1" "${root}/${1}/root"
     else
       add_fstab "$host":/srv/release/PRIMARY/root/"$1" "/${1}/root" nfs ro,soft,bg x 0
     fi
     ln -s "/${host}/usr" "${root}/${1}/usr"
     ln -s "/${host}/X11" "${root}/${1}/X11"
   fi
   shift
 done
}

#
# add_access(list)
#
add_access()
{
 while [ ! -z "$1" ] ; do
   echo $hostlist | egrep > /dev/null :$1:'|':$1'$|^'$1:'|^'$1'$'
   if [ $? -ne 0 ] ; then
     add2="$add2:$1"
   fi
   shift
 done
}

#
# install_queue(level)
#
install_queue()
{
#
# get name
#
 queue="$source/queue"
   
#
# check files
#
 if [ ! -d $queue ] ; then
    echo "\nBOSS queue subdirectory $queue does not exist"
    exit 1
 fi
 cd $queue
 if [ ! -r queue_$1.csh ] ; then
   echo "\nInstallation utility queue.csh does not exist"
   exit 1
 fi

#
# request for host operation mode
#
  cat << EOF

 - You must now decide whether this host will be the queue manager dispatcher
 - or only one of the queue executer servers. The dispatcher will automatically
 - become an executer, too. Valid host kinds are SERVER and EXECUTER.
EOF
  MODE=""
  while [ "$MODE" = "" ] 
  do
    verify_name "\nWhat kind of queue manager host will this host be" "EXECUTER"
    if [ "$reply" = "SERVER" ] ; then
      MODE="$reply"
    else
      if [ "$reply" = "EXECUTER" ] ; then
        MODE="$reply"
      fi
    fi
  done

#
# complete installation
#
 echo "\n\nrunning $1 installation for BOSS queue 4.14"
 if not csh queue_$1.csh $MODE $RPCDIR
 then
   exit 1
 fi

#
# check for old queue backupfiles
#
 check_delete "$BAKDIR"/bossgeneric.bak
 check_delete "$BAKDIR"/bossexec.bak


#
# check for local setup
#
 if [ "$MODE" = "SERVER" ] ; then
#
# customize netgroups
#
   cat <<EOF
 
 - The queue manager dispatcher will only use executer servers in a given
 - netgroup. You have to built up this netgroup correctly for the queue 
 - management system to work properly. Enter each executer host and the
 - dispatcher as (host,,domain) in the netgroup data file. You may have
 - to do these changes on the YP MASTER host if this host isn't the YP 
 - master server for the netgroup map.
EOF
   verify_name "\nName of the netgroup data file" "$root"/netgroup
   check_edit "$reply"
   check_edit "$RPCDIR"/bossgeneric
 fi
 check_edit "$RPCDIR"/bossexec
}

#
# install_boss()
#
install_boss()
{
#
# DCL command file directory
#
 initdir="$DCLDIR"/init

#
# create `hostname`.com
#
 verify_name "\nEnter the TCP/IP name of the host to be set up"
 MYNAME="$reply"
 hostfile="$initdir"/"$MYNAME".com
 protofile="$initdir"/hostname.com.proto
 if [ ! -f "$hostfile" ] ; then
   if [ -f "$protofile" ] ; then
     echo creating "$hostfile" from prototype
     cp "$protofile" "$hostfile"
   else
     echo "$hostfile" not found and no prototype file
     exit 1
   fi
 fi

#
# customize `hostname`.com
#
 cat <<EOF

 - You may want to localize your hosts own setup file.
EOF
 check_edit "$hostfile"
}

#
# install_root()
#
install_root()
{
#
# Read server client list
#
 cat <<EOF

 - I will now need a configuration list of your BOSS hosts. This will help me
 - to set up you various client/server files correctly. You may need to update
 - the following files when you install more hosts:
 -- every host:
    /etc/X0.hosts        add every new host
    /etc/fstab           add directories of every new server
    /etc/hosts.equiv     add every new host
    /etc/pmttapetab      add tapes of every new server
 -- every server:
    /etc/exports         modify access lists for new hosts and servers
 - In addition some YP setup must be done on the YP master host. If you want
 - you can rerun this installation script you should rename saphir__.1.done to
 - saphir__.1.do in every servers /sbin/setup.d/root directory. Then sysadm
 - setuppackage will recognize it.

 - To end one of the following input modes answer with end.
EOF

 hosts=
 while [ true ] ; do
   verify_name "\nEnter the name of another BOSS server host" end
   if [ "$reply" = "end" ] ; then
     break
   fi
   hosts="$hosts,$reply"
   server="$reply"
   while [ true ] ; do
     verify_name " Enter the name of a client of host $server" end
     if [ "$reply" = "end" ] ; then
       break
     fi
     hosts="$hosts":"$reply"
   done
 done
 hosts="$hosts,"

#
# Verify my own name
#
 set -- `echo $hosts | tr ",:" "  "`
 while [ ! -z "$1" ] ; do
   if [ "$1" = "$MYNAME" ] ; then
     break
   fi
   shift
 done
 if [ -z "$1" ] ; then
   echo "\nHost name $MYNAME not found in list of hostnames"
   exit 1
 fi

#
# Get my operation mode
#
 if [ "`echo $hosts | sed -n 's/^.*\([:,]\)'$MYNAME'[:,].*$/\1/p'`" = "," ] ; then
   OSMODE=SERVER
 else
   OSMODE=CLIENT
 fi
 osmode=`echo $OSMODE | tr '[A-Z]' '[a-z]'`
 cat <<EOF

 - This host can be an operating system SERVER or bootnode for one or more
 - operating system CLIENTs or satellite. From the hosts TCP/IP name and
 - the host name list I decided that it should be a $OSMODE.
EOF
 if not yesno "\nIs this host really an operating system $osmode" y ; then
   echo "\nPlease rerun the configuration with the correct answers"
   exit 1
 fi

#
# Create /etc/X0.hosts and /etc/hosts.equiv
#
 create_hostlist /etc/X0.hosts
 create_hostlist /etc/hosts.equiv

#
# Set up startup scripts 
#
 echo
 rclinks="${usr}/sbin/init.d/rc.links"
 linktab="${root}/etc/rclinktab.boss_os_$osmode"
 "$rclinks" -rm -r "$root" -u "$usr" "${root}/etc/rclinktab.boss_os_server"
 "$rclinks" -ln -r "$root" -u "$usr" "$linktab"

#
# Modify /etc/dgux.param
#
 cat <<EOF

 - Normally the BOSS/SAPHIR environment is set up with the accounting system
 - being started while booting. If you want to do this you should edit your
 - /etc/dgux.params file now and set account_START to true.
EOF
 check_edit "${root}/etc/dgux.params"

#
# Modify /etc/nfs.params
#
 cat <<EOF

 - Since BOSS hosts make intensive use of NFS it should be preferable to have
 - more NFS daemons than the default for AViiONs is. If you will make this
 - change you should add your /etc/nfs.params now and correct the values
 - of biod_ARG and nfsd_ARG to 8.
EOF
 check_edit "${root}/etc/nfs.params"
#
# Modify /etc/tcpip.params
#
 cat <<EOF

 - You may want to edit your local /etc/tcpip.params file to enter one or 
 - more INTERnet gateways with a ROUTE_TYPE of 'net', ROUTE_DESTINATION 
 - 'default' and ROUTE_METRIC '1'. The default gateway and domain name 
 - server for BOSS/SAPHIR is 'intergate.uni-bonn.de' (131.220.221.4).
EOF
 check_edit "${root}/etc/tcpip.params"

#
# Modify /etc/inittab
#
 echo "\nsetting up /etc/inittab for BOSS/SAPHIR startup"
 sed -e s/xdm:3/xdm:a/ -e s/def:s/def:3/ "${root}/etc/inittab" > /tmp/inittab
 cp /tmp/inittab "${root}/etc/inittab"
 rm -f /tmp/inittab

#
# /admin/sysmails and /var/mail (DG/UX links /usr/mail to /var/mail)
# 
 echo "\nsetting up mail environment"
 sysmails="${root}/admin/sysmails"
 if [ ! -f "$sysmails" ] ; then
   echo > "$sysmails" "\c"
   chgrp mail "$sysmails"
   chmod u=rw,g=rw,o= "$sysmails"
 fi
 maildir="${root}/var/mail"
 rm -rf "$maildir"
 ln -s /home/mail "$maildir"

#
# Line printer default script
#
 echo "\nsetting up lineprinter environment"
 lpscript="${root}/var/spool/lp/model/remshlp"
 lpboss="${lpscript}.boss"
 if [ -f "$lpscript" ] ; then
   if yesno "\nShould I overwrite the lineprinter default script" n ; then
     if yesno "Should I save the current lineprinter default script" y ; then
       cp "$lpscript" "$lpscript".dgux
     fi
   else
     lpboss=
   fi
 fi
 if [ ! -z "$lpboss" ] ; then
   echo "installing ${lpscript} from prototype ${lpboss}"
   cp "$lpboss" "$lpscript"
 fi

#
# Set up /etc/fstab from prototype list /etc/fstab.boss
#
 echo
 fstab="${root}/etc/fstab"
 grep "^[^#]" "$fstab".boss | while read line ; do
   host=`expr "$line" : '\([^:]*\):.*'`
   if [ "$host" != "$MYNAME" ] ; then
     add_fstab $line
   fi
 done

#
# Create all interconnect directories and server entries
# 
 echo "\ncreating BOSS directory environment"
 if [ ! -d "${root}/$MYNAME" ] ; then
   mkdir "${root}/$MYNAME"
 fi
 cd "${root}/$MYNAME"
 set -- root / usr /usr X11 /usr/opt/X11
 while [ ! -z "$1" ] ; do
   rm > /dev/null -f "$1"
   ln -s "$2" "$1"
   shift 2
 done
 set -- `echo $hosts | tr "," " "`
 while [ ! -z "$1" ] ; do
   add_server `echo $1 | tr ":" " "`
   shift
 done

#
# Client will need a /usr/opt/X11 from its server
#
 if [ "$OSMODE" = CLIENT ] ; then
   host=`echo $hosts | sed -n 's/^.*,\([^:]*\)[^,]*:'$MYNAME'[:,].*$/\1/p'`
   add_fstab "$host":/usr/opt/X11 /usr/opt/X11 nfs ro x 0
 fi

#
# Update list of local devices for DCL
#
 echo "\nupdating /usr/dcl/init/startup_local_devices.com"
 locdev="${usr}/dcl/init/startup_local_devices.com"
 set -- `echo $hosts | tr ",:" "  "`
 while [ ! -z "$1" ] ; do   
   grep > /dev/null -i "[ 	]$1"'$root[	 ]' "$locdev"
   if [ $? -ne 0 ] ; then
     echo >> "$locdev" '$ define/system/exec '$1'$root		"/'$1'"/trans=terminal'
   fi
   shift
 done
}

#
# install_server()
#
install_server()
{
#
# SERVER only
#
 if [ "$OSMODE" = CLIENT ] ; then
   return
 fi

#
# Set up /etc/exports
#
 echo "\nupdating /etc/exports"
 hostlist=`echo $hosts | tr "," ":" | sed 's/^:\(.*\):$/\1/'`
 sed -e '/^\/[ 	]/d' -e '/^\/usr[ 	]/d' \
     -e '/^\/usr\/opt\/X11[ 	]/d' \
     -e '/^\/srv\/release\/PRIMARY\/root\/boss[1-9][0-9]*[ 	]/d' \
     "${root}/etc/exports" > /tmp/exports
 echo "/\n/usr\n/usr/opt/X11" | while read line ; do
   found=`grep "^$line[ 	]" "${root}/etc/exports"`
   add1=""
   add2=""
   if [ ! -z "$found" ] ; then
     set -- $found
     shift
     if [ "`echo $1 | cut -c1`" = "-" ] ; then
       set -- `echo $1 | cut -c2- | tr "," " "`
       while [ ! -z "$1" ] ; do
	 option=`echo $1 | sed 's/^\([^=]*\)=.*$/\1/'`
	 value=`echo $1 | sed 's/^[^=]*=\(.*\)$/\1/'`
	 if [ "$option" = access ] ; then
	   add_access `echo $value | tr ":" " "`
	 else
	   add2="$add2,$1"
	 fi
  	 shift
       done
     fi
   fi
   echo >> /tmp/exports "${line}	-access=$hostlist$add1$add2"
 done
 grep "^/srv/release/PRIMARY/root/boss[1-9][0-9]*[ 	]" "${root}/etc/exports" | while read found ; do
   add1=""
   add2=""
   set -- $found
   line="$1"
   shift
   if [ "`echo $1 | cut -c1`" = "-" ] ; then
     set -- `echo $1 | cut -c2- | tr "," " "`
     while [ ! -z "$1" ] ; do
       option=`echo $1 | sed 's/^\([^=]*\)=.*$/\1/'`
       value=`echo $1 | sed 's/^[^=]*=\(.*\)$/\1/'`
       if [ "$option" = access ] ; then
	 add_access `echo $value | tr ":" " "`
       else
	 add2="$add2,$1"
       fi
       shift
     done
   fi
   echo >> /tmp/exports "${line}	-access=$hostlist$add1$add2"
 done
 cp /tmp/exports "${root}/etc/exports" 
 rm -f /tmp/exports

#
# Set up the system configuration files
#
 cat <<EOF
  
 - BOSS/SAPHIR needs some drivers to be bind into the operating systems
 - kernel. You should make the following changes to your local system
 - configuration file:
 -          sos()          # SOS mail handling driver
 -          parallel()     # BOSS TCP/IP channel to file name mapper
 -          MAXEXCHANGES   20
 -          MAXPARCHAN     64
 - You should create the new kernel configuration file from the existing
 - one.
EOF
 check_edit "${usr}/src/uts/aviion/Build/system.boss"
 check_edit "${usr}/src/uts/aviion/Build/system.boss.diskless"

}

#
# install_protection()
#
install_protection()
{
#
# Change group and protection of the following files
#
 verify_name "\nEnter group name for all utility files" saphadm
 group="$reply"
 cat <<EOF | while read line ; do
etc/rpc.boss
local/tools
EOF
   protection "$group" `find "${root}/$line" -print`
 done
}

#
# protection(group,list)
#
protection()
{
 togrp="$1"
 shift
 while [ ! -z "$1" ] ; do
   chgrp "$togrp" "$1"
   chmod g+w,o-w "$1"
   shift
 done
}

#
# saphir.do rootdir usrdir
#
if [ $# -ge 2 ] ; then
  root="$1"
  usr="$2"
fi

#
# setup for environments
#
BINDIR="${usr}/bin"
LIBDIR="${usr}/lib"
INCDIR="${usr}/include"

TABDIR="${usr}/tables"
PORTABLE=portable

DIRDEF=saphir
INCDEF=modules
DCLDIR="${usr}/dcl"
MHSDIR="${usr}/mhs"
CONDIR="${usr}/converter"
DEVLIB="${usr}/src/uts/aviion/lb/boss.a"

RPCDIR="${usr}/rpc.startup"
BAKDIR="${root}/etc/log"

export BINDIR LIBDIR INCDIR TABDIR PORTABLE DIRDEF INCDEF DCLDIR MHSDIR DEVDIR
export CONDIR RPCDIR BAKDIR

#
# Bad umask from caller
#
umask 002

#
# setup variables
#
EDITOR="" ; DEFAULT_EDITOR="${usr}/bin/vi"

#
# check project files
#
project="${usr}/opt/contrib/$DIRDEF"
if [ ! -d $project ] ; then
   echo "\nProject directory $project does not exist"
   exit 1
fi

#
# check installation files
#
source="$project/src"
if [ ! -d $source ] ; then
   echo "\nProject installation tree $source does not exist"
   exit 1
fi

#
# installations
#
install_queue root
install_boss
install_root
install_server
install_protection
