#include <stdio.h>
#include <netdb.h>

#ifdef vms
#include "vm:vaxmhs_data.h"
#else
#include <saphir/vaxmhs_data.h>
#endif

main(argc,argv)
int argc;
char **argv;
{
 int logname[2],tmp,accl[4],null = 0,opt,err,mb,ticks = 500;
 struct hostent *hent;
 short code,len = 0;
 char *up;
 
 /* Anzahl der Parameter testen */
 if ( argc != 4 ) usage(*argv);
 /* Befehl auswerten */
 for ( up = argv[1] ; *up ; up++ )
  if ( (*up >= 'a') && (*up <= 'z') )
   *up += 'A'-'a';
 if ( !strcmp(argv[1],"STOP") )
  code = 0;
 else if ( !strcmp(argv[1],"SUSPEND") )
  code = 1;
 else if ( !strcmp(argv[1],"RESUME") )
  code = 2;
 else
  usage(*argv);
 /* Host suchen */
 if ( (logname[0] = inet_addr(argv[2])) == 0xffffffff )
  if ( hent = gethostbyname(argv[2]) )
   logname[0] = *(long *)hent->h_addr;
  else
   {
    fprintf(stderr,"No such host %s\n",argv[2]);
    exit(1);
   }
 /* Prozesskennung ermitteln */
 tmp = atoi(argv[3]);
 SLONG(&tmp,logname+1);
 /* Logischen Namen suchen */
 VMEINI();
 VMEGET(accl,logname,&null,&opt,&err);
 if ( err )
  {
   fprintf(stderr,"SOS_IN converter not found\n");
   exit(1);
  }
 /* Mail aufbauen */
 if ( err = ICALCMB(&mb,accl) )
  {
   fprintf(stderr,"Got no mail to SOS_IN converter\n");
   exit(1);
  }
 SWORD(&code,&vaxmhs_data.vd_boxes[mb].mbcode);
#ifdef vms
 vaxmhs_data.vd_boxes[mb].mbstatus.erbit = 1;
#else
 vaxmhs_data.vd_boxes[mb].mbstatus |= ERBIT;
#endif
 /* Befehl abschicken */
 SNDMAIL(&mb,&err,&ticks);
 if ( err ) 
  {
   fprintf(stderr,"SOS_IN converter has not accepted command\n");
   exit(1);
  }
 /* Fertig */
 IADDMB(&mb);
}

/*
  So aber nicht.
*/
static usage(pname)
char *pname;
{
 fprintf(stderr,"USAGE: %s (STOP|SUSPEND|RESUME) hostname processidentifier\n",pname);
 exit(1);
}
