#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
if ( ($#argv >= 2) && ("$2" != "") ) then
  set CONDIR = "$2"
else if ( ! $?CONDIR ) then
  set CONDIR = /usr/converter
endif
if ( ($#argv >= 3) && ("$3" != "") ) then
  set MHSDIR = "$3"
else if ( ! $?MHSDIR ) then
  set MHSDIR = "/usr/mhs"
endif
if ( ($#argv >= 4) && ("$4" != "") ) then
  set DCLDIR = "$4"
else if ( ! $?DCLDIR ) then
  set DCLDIR = "/usr/dcl"
endif
if ( ($#argv >= 5) && ("$5" != "") ) then
  set RPCDIR = "$5"
else if ( ! $?RPCDIR ) then
  set RPCDIR = "/usr/rpc.startup"
endif
  
#
# queue_user.csh [(DIRDEF|"") [(CONDIR|"") [(MHSDIR|"") [(DCLDIR|"") [RPCDIR]]]]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 [(DIRDEF|"") [(CONDIR|"") [(MHSDIR|"") [(DCLDIR|"") [RPCDIR]]]]]
*** 
***    DIRDEF is the name of the project (saphir)
***    CONDIR is the name of the converter directory (/usr/converter)
***    MHSDIR is the root of all SOS executables (/usr/mhs)
***    DCLDIR is the root of all DCL files (/usr/dcl)
***    RPCDIR is the name of the RPC startup directory (/usr/rpc.startup)
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set LIBDIR2 = "$LIBDIR1"/converter
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
set MHSLIB = "$LIBDIR"/libmhs.a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++
+++  converter include directory    =   $LIBDIR2
+++  converter directory            =   $CONDIR
+++
+++  SOS mail handling directory    =   $MHSDIR
+++  SOS mail handling library      =   $MHSLIB
+++
+++  DCL support directory          =   $DCLDIR
+++
+++  RPC startup directory          =   $RPCDIR
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif
if ( ! -d "$DCLDIR"/init ) then
  error directory "$DCLDIR"/init for DCL startup command files does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating project include directory "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif
if ( ! -d "$LIBDIR2" ) then
  action creating converter include directory "$LIBDIR2"
  check mkdir "$LIBDIR2"
endif
if ( ! -d "$CONDIR" ) then
  action creating converter directory "$CONDIR"
  check mkdir "$CONDIR"
endif
foreach dir (monadic dyadic)
  if ( ! -d "$CONDIR"/"$dir" ) then
    action creating "$CONDIR"/"$dir"
    check mkdir "$CONDIR"/"$dir"
  endif
end
if ( ! -d "$MHSDIR" ) then
  action creating "$MHSDIR"
  check mkdir "$MHSDIR"
endif
if ( ! -d "$RPCDIR" ) then
  action creating "$RPCDIR"
  check mkdir "$RPCDIR"
endif

#
# Protoypdateien kopieren
#
action copying prototyp files
check cp init/*.proto "$DCLDIR"/init

#
# Aufraeumen
#
action cleaning up
foreach dir (exec generic cld parallel converter doc)
  (cd $dir ; make clean)
end
(cd utilities ; rm -f sos_ctrl)

#
# Headerfiles
#
action copying header files
(cd converter ; check make update EXECDIR="../exec" INCDIR="$LIBDIR2")

#
# EXEC-Server 
#
action creating execution server
(cd exec ; check make sexec OBJLIB="$OBJLIB")

#
# NOTIFY-Server
#
action creating notify server
(cd exec ; check make snotify OBJLIB="$OBJLIB")

#
# GEN-Queue
#
action creating queue server
(cd generic ; check make sgen OBJLIB="$OBJLIB")

#
# Queuemanager
#
action creating queue manager
(cd cld ; check make queman QMan.uid OBJLIB="$OBJLIB")

#
# Parallelinterpreter
#
action creating parallel interpreter
(cd parallel ; check make parallel OBJLIB="$OBJLIB")

#
# Einseitig Konverter
#
set MONADIC = "tape_in sos_in hstore_out"
action creating monadic converters
(cd converter ; check make $MONADIC OBJLIB="$OBJLIB")

#
# Zweiseitig Konverter
#
set DYADIC = "fortran zfast vax_variable hstore ascii file"
action creating dyadic converters
(cd converter ; check make $DYADIC OBJLIB="$OBJLIB")

#
# SOS Steuerung
#
action creating SOS control
(cd utilities ; check cc -O sos_ctrl.c -o sos_ctrl "$MHSLIB")

#
# Dateien kopieren
#
action copying servers
check cp exec/sexec "$RPCDIR"/bossexec.HLP
check cp exec/snotify "$RPCDIR"/bossnotify
check cp generic/sgen "$RPCDIR"/bossgeneric.HLP
action copying queue manager
check cp cld/queman "$BINDIR"/QMan
check ln -s QMan "$BINDIR"/qman
check cp cld/QMan.uid "$LIBDIR"/X11/QMan.uid
action copying parallel interpreter
check cp parallel/parallel "$BINDIR"/pdl
action copying monadic converters
(cd converter ; check cp $MONADIC "$CONDIR"/monadic)
action copying dyadic converters
(cd converter ; check cp $DYADIC "$CONDIR"/dyadic)

#
# Aufraeumen
#
action cleaning up
foreach dir (exec generic cld parallel converter doc)
  (cd $dir ; make clean)
end
(cd utilities ; rm -f sos_ctrl)

#
# Fertig
#
action queue manager user installation complete

