#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ($#argv >= 2) && ("$2" != "") ) then
  set RPCDIR = "$2"
else if ( ! $?RPCDIR ) then
  set RPCDIR = /usr/rpc.startup
endif
  
#
# queue_root.csh SERVER|EXECUTER [RPCDIR]
#
#
# Kurze Erklaerung
#
if ( ("$1" != "SERVER") && ("$1" != "EXECUTER") ) then
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 SERVER|EXECUTER [RPCDIR]
***
***    SERVER   sets up the queuemanager in addition to EXECUTER
***    EXECUTER sets up the host as an executer only
***    RPCDIR   is the name of the RPC startup directory (/usr/rpc.startup)
*** 
EOF
  exit 1
endif

#
# Informationen anzeigen
#
cat << EOF
+++
+++  RPC startup directory          =   $RPCDIR
+++
+++  host operation mode            =   $1
+++
EOF

#
# Systemdirectories erzeugen
#
if ( ! -d "$RPCDIR" ) then
  action creating RPC startup directory "$RPCDIR"
  check mkdir "$RPCDIR"
endif

#
# Kommandodateien kopieren
#
foreach bin (bossgeneric bossexec)
  set cur = "$RPCDIR"/"$bin"
  if ( ! -f "$cur" ) then
    if ( -f "$cur".proto ) then
      action creating "$cur" from prototype
      check cp "$cur".proto "$cur"
    else
      error "$cur" not found and no prototype file
      exit 1
    endif
  endif
end

#
# Fertig
#
action queue manager root installation complete

