h15378
s 00002/00016/02195
d D 5.8 91/08/16 09:12:03 jochen 21 20
c fileToName from support.h used
e
s 00004/00004/02207
d D 5.7 91/08/15 13:29:20 jochen 20 19
c Output for CPU time beautified
e
s 00294/00178/01917
d D 5.6 91/08/15 11:57:12 jochen 19 18
c CPU statistics added
e
s 00013/00003/02082
d D 5.5 91/07/23 13:32:20 jochen 18 17
c Output now unbuffered; default directory
e
s 00034/00028/02051
d D 5.4 91/07/23 13:09:43 jochen 17 16
c Double kill avoided; start while delete pending now possible
e
s 00001/00001/02078
d D 5.3 91/07/22 17:30:25 jochen 16 15
c Counting of delete-pending incarnations corrected
e
s 00005/00005/02074
d D 5.2 91/07/05 13:01:08 jochen 15 14
c FILENAME expanded to FILENAMES - not yet completed
e
s 00000/00000/02079
d D 5.1 91/07/04 13:48:32 jochen 14 13
c New version for X11/Motif support created
e
s 00002/00002/02077
d D 4.11 91/05/29 08:34:21 jochen 13 12
c RMS_RMSFILE used
e
s 00164/00065/01915
d D 4.10 91/05/02 08:54:12 jochen 12 11
c Multiprogram channels added
e
s 00022/00021/01958
d D 4.9 91/04/30 09:03:52 jochen 11 10
c /LOG now uses /NAME
e
s 00006/00006/01973
d D 4.8 91/04/18 17:59:46 jochen 10 9
c Problem with pointer and 'unit' list reallocation solved
e
s 00002/00002/01977
d D 4.7 91/03/20 10:11:09 jochen 9 8
c VERSION output corrected
e
s 00001/00001/01978
d D 4.6 91/03/15 18:03:13 jochen 8 7
c Typing corrected
e
s 00006/00003/01973
d D 4.5 91/03/11 11:56:07 jochen 7 6
c Counting of incarnations corrected
e
s 00001/00001/01975
d D 4.4 91/03/09 12:08:05 jochen 6 5
c Routine name corrected
e
s 00011/00000/01965
d D 4.3 91/03/09 12:05:58 jochen 5 4
c VERSION command added
e
s 00001/00001/01964
d D 4.2 91/03/09 10:58:13 jochen 4 3
c Modification of jobname corrected
e
s 00000/00000/01965
d D 4.1 91/03/07 14:50:15 jochen 3 2
c Fundamental version for Queuemanager Version 4
e
s 01621/00165/00344
d D 3.2 91/03/07 14:49:27 jochen 2 1
c Contruction of PDL interpreter completed
e
s 00509/00000/00000
d D 3.1 91/02/13 17:16:52 jochen 1 0
c SCCS version for queue manager version 3 created
e
u
U
t
T
I 1
/*
D 9
  %W% 91/02/08 Parallel support for batch queue user interface for UNIX and VMS
E 9
I 9
  %W% 91/02/08 Parallel support for batch queue user interface for UNIX 
E 9
*/

#ifdef SCCSIDS
static char sccs_parallel_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

#include <errno.h>
#include <fcntl.h>
I 2
#include <float.h>
E 2
#include <stdio.h>
I 2
#include <limits.h>
E 2

#include <rpc/rpc.h>

I 2
#include <sys/socket.h>

E 2
#include <saphir/CLI.h>

#include "../generic/sgen.h"
D 2
#include "../library/vms_support.h"
E 2
I 2
#include "../library/support.h"
E 2

/*
  Strukturen
*/
D 2
struct extra_channel
E 2
I 2
struct extra
E 2
      {
       char	*name;
       int	unit;
       int	max;
I 2
       int	link;
E 2
      };

D 2
struct extra
E 2
I 2
/*
  Verwaltungseinheit: CONVERTER oder PROGRAM
*/
struct unit
E 2
       {
D 2
	struct extra_channel input;
	struct extra_channel output;
E 2
I 2
	submit			job;		/* Jobkontrollstruktur			*/
	long			host;		/* IP-Adresse der EXEC-Queue		*/
	int			nchan;		/* Zahl der Spezialkanaele		*/
I 12
	int			ninp;		/* Zahl der Eingangskanaele		*/
	int			nout;		/* Zahl der Ausgangskanaele		*/
E 12
	struct extra		*chan;		/* Spezialkanaele			*/
	anychan			info;		/* Statistik				*/
	int			child;		/* Untergeordnete Strukturen		*/
	int			num;		/* Laufende Nummer			*/
	int			inc;		/* Inkarnationszaehler			*/
	int			run;		/* Aktive Kindprozesse			*/
I 7
	int			delp;		/* Warten auf Entfernung		*/
E 7
	int			max;		/* Maximale Zahl von Programmen 	*/
	int			last;		/* Letzte Aktion			*/
	double			opt;		/* Optimierungsparameter		*/
I 19
	double			cpu;		/* Gesammelte CPU-Zeit			*/
E 19
E 2
       };
I 2
#define ufor			anychan_u.pchans
#define lfor			ufor.parchans_len
#define vfor			ufor.parchans_val
#define ucon(i)			anychan_u.cchans[i]
#define lcon(i)			ucon(i).converterchans_len
#define vcon(i)			ucon(i).converterchans_val
#define outc			inc
E 2

I 2
#define index1(l)		(((short *)(&(l)))[0])
#define index2(l)		(((short *)(&(l)))[1])
E 2

I 2
#define UFREE			-2
#define UCANCEL			-3

#define LNONE			0
#define LCREATE			1
#define LDELETE			2


E 2
/*
  Globale und externe Variablen.
*/
D 2
static int nconv = 0,nprog = 0,ctlen;
static char where[100],clitemp[256],*defdir;
E 2
I 2
D 19
#define STDBUFSIZE		256
E 19
I 19
typedef char stdBuffer[256];
#define STDBUFSIZE		sizeof(stdBuffer)
E 19
E 2

I 2
static int nconv = 0,nprog = 0,ctlen,aunit = 0,verify = 0,debug = 0;
static long rpcprog = -1,rpcvers = -1,rpcverf = 0,*hlist;
D 19
static char where[100],clitemp[STDBUFSIZE];
E 19
I 19
static double tostart = 10/100.0,tostop = 30/100.0;
E 19
static int nhint,ahint,nopt,aopt = 0,*opt;
static struct in_addr rpcaddr;
static struct unit *unit = 0;
I 19
static stdBuffer clitemp;
E 19
static CLIENT *gen = 0;
I 19
static char where[100];
E 19

E 2
extern char parallelcld_[];


/*
  Externe und lokale Funktionen
*/
extern int lib$get_input_(),cli$dcl_parse_(),cli$dispatch_();
D 2
extern char *calloc(),*strdup();
E 2
I 2
D 19
extern char *calloc(),*strdup(),*strchr();
E 19
I 19
extern char *calloc(),*strdup(),*strchr(),*strrchr();
E 19
extern struct in_addr inet_addr();
E 2

I 19
static double getratio(),findCPU();
E 19
D 2
static submit *analyze_job();
E 2
I 2
static struct unit *analyze_job();
static parctrl *findID();
D 19
static double getratio();
E 19
static char *action();
E 2


/*
  MACROs
*/
#define MALLOC(t,n)		((t *)calloc(n,sizeof(t)))

#define NOSTR                   ((char *)0)
#define NOFCT                   ((int (*))0)

#define PRESENT(n)              cli$present_(n,sizeof(n)-1)
D 12
#define VALUE(n,o,r)		cli$get_value_(n,o,r,sizeof(n)-1,sizeof(o)-1)
E 12
I 12
#define VALUE(n,o,r)		cli$get_value_(n,o,r,strlen(n),sizeof(o)-1)
#define CVALUE(n)		VALUE(n,clitemp,&ctlen)
E 12

D 2
#define EXTRA(j)		((struct extra *)((j)->hold))
#define EXTRAPROGRAM		((struct extra *)0)
#define EXTRAPRIMARY		((struct extra *)-1)
E 2
I 2
#define GETMEM(v,t,n)		getmem((v) = MALLOC(t,n))
#define GETSTRUCT(v,t)		GETMEM(v,t,1)
#define GETSTRING(v,s)		getmem((v) = strdup(s))
E 2

I 2
#define PDLshort(m)		PDLerror(m,"","")
E 2

I 2
#define NULLDEVICE		"/dev/null"

I 12
#define isinput(f)		(index2((f)->index) < unit[index1((f)->index)].ninp)
E 12

I 12
 
E 12
E 2
/*
D 2
  Parallel definition language interpreter: <prog> <QMan-IP> <PDL-file>
E 2
I 2
D 19
  Grenzen fuer Start und Stop von Parallelteiljobs.
E 2
*/
I 2
#define TOSTART			(10/100.0)
#define TOSTOP			(30/100.0)


/*
E 19
  Parallel definition language interpreter: <prog> <PDL-File> <QMan-IP>
*/
E 2
main(argc,argv)
int argc;
char **argv;
{
D 2
 char *pdlname,*cip; 
E 2
I 2
D 19
 int cupd,pupd,cans,pans;
E 19
I 19
 int cupd,pupd,cans,pans,i;
E 19
D 18
 char *pdlname; 
E 18
I 18
 char *pdlname,*fstart; 
I 19
 struct unit *cur;
E 19
E 18
E 2

 /* Zahl der Parameter ueberpruefen */
 if ( argc < 3 ) 
  {
D 2
   fprintf(stderr,"USAGE: %s <QMan-IP> <PDL-file>\n",*argv);
   exit(1);
E 2
I 2
D 19
   fprintf(stderr,"USAGE: %s <PDL-file> <QMan-ID>\n",*argv);
E 19
I 19
   printf("USAGE: %s <PDL-file> <QMan-ID>\n",*argv);
E 19
   exit(EINVAL);
E 2
  }
D 2
 /* Initialisierung */
 getmem(defdir = strdup("/scratch"));
 /* IP-Adresse ermitteln */
 cip = *++argv;
E 2
I 2
D 18
 /* Initialisieren */
 chdir("/tmp");
E 18
I 18
 /* Ausgabebuffer abschalten */
 setbuf(stdout,(char *)0);
E 18
E 2
 /* Als Standardeingabekanal */
 close(0);
 /* Datei oeffnen, eventuell Endung anhaengen */
 if ( open(pdlname = *++argv,O_RDONLY) == -1 )
  {
   /* Endung PDL anhaengen */
D 2
   getmem(pdlname = MALLOC(char,strlen(pdlname)+5));
E 2
I 2
   GETMEM(pdlname,char,strlen(pdlname)+5);
E 2
   strcpy(pdlname,*argv);
   strcat(pdlname,".pdl");
   /* Datei oeffnen */
   if ( open(pdlname,O_RDONLY) == -1 )
    {
D 19
     fprintf(stderr,"Could not open file %s\n",*argv);
E 19
I 19
     printf("Could not open file %s\n",*argv);
E 19
D 2
     exit(1);
E 2
I 2
     exit(ENOENT);
E 2
    }
I 18
  }
 /* Defaultverzeichnis setzen */
D 19
 for ( fstart = pdlname+strlen(pdlname) ; (fstart-- > pdlname) && (*fstart != '/') ; );
 if ( fstart >= pdlname )
E 19
I 19
 if ( fstart = strrchr(pdlname,'/') )
E 19
  {
   char ch = *++fstart;

   *fstart = '\0';
   chdir(pdlname);
   *fstart = ch;
E 18
  }
I 2
 /* QMan-ID zerlegen */
 analyze_id(*++argv);
E 2
 /* Analysieren */
 analyze_pdl();
I 2
 if ( !nconv && !nprog ) CLIerror("no programs or converters defined");
 /* VERIFY beachten */
 if ( verify )
  {
D 19
   fprintf(stderr,"Input file %s successfully parsed\n",pdlname);
   fprintf(stderr,"Found %d converter(s) and %d program(s)\n\n",nconv,nprog);
E 19
I 19
   printf("Input file %s successfully parsed\n",pdlname);
   printf("Found %d converter(s) and %d program(s)\n\n",nconv,nprog);
E 19
  }
 /* Referenzen aufloesen */
 resolve_pdl();
 /* RPC/IP Informationen ausgeben */
 if ( verify )
  {
D 19
   fprintf(stderr,"Contacting GEN-Queue at IP %s\n",inet_ntoa(rpcaddr));
   fprintf(stderr,"Using RPC-Program %d Version %d\n",rpcprog,rpcvers);
   fprintf(stderr,"Paralleljob Identifier is %d\n\n",rpcverf);
E 19
I 19
   printf("Contacting GEN-Queue at IP %s\n",inet_ntoa(rpcaddr));
   printf("Using RPC-Program %d Version %d\n",rpcprog,rpcvers);
   printf("Paralleljob Identifier is %d\n\n",rpcverf);
E 19
  }
 /* Alle Konverter starten */
 start_converters();
 /* Informationen einsammeln */
 for ( ; ; )
  {
   /* Informationen ermitteln */
   update(&cans,&cupd,&pans,&pupd);
   /* Konsistenztest */
   if ( cans != nconv ) PDLshort("converter died before execution");
   /* Nur aufhoeren, wenn alle Informationen vorhanden */
   if ( cupd == cans ) break;
   /* Spaeter noch einmal probieren */
   sleep(10);
  }
 /* Informationsbloecke der Programme mit den IP-Adressen versehen */
 resolve_converter();
 /* Programme erstmalig starten */
 start_programs();
 /* Die ewige Schleife bis zum bitteren Ende */
 for ( ; ; )
  {
   /* Intervall abwarten */
   sleep(60);
   /* Neue Informationen einlesen */
   update(&cans,&cupd,&pans,&pupd);
   if ( !cans && !pans ) break;
   /* Programm neu starten oder stoppen */
   if ( !parallel_create() ) parallel_kill();
  }
I 19
 /* Statistik herausschreiben */
 puts("\nDyadic Converters:");
 puts("\tCPU time\t\tJobname");
 for ( cur = unit, i = 0 ; i++ < aunit ; cur++ )
  if ( (cur->child != UFREE) && (cur->job.Jinfo.kind == skCONVERTER) )
D 20
   printf("%16.2f\t\t%s\n",cur->cpu,cur->job.name);
E 20
I 20
   printf("%15.2fs\t\t%s\n",cur->cpu,cur->job.name);
E 20
 puts("\nMonadic Converters and Programs:");
 puts("\tCPU time\tIncarnations\tAverage\t    Jobname");
 for ( cur = unit, i = 0 ; i++ < aunit ; cur++ )
  if ( (cur->child != UFREE) && (cur->job.Jinfo.kind == skPARALLEL) && cur->num )
D 20
   printf("%16.2f\t%8d%15.2f\t    %s\n",
E 20
I 20
   printf("%15.2fs\t%8d%14.2fs\t    %s\n",
E 20
	  cur->cpu,cur->inc,cur->inc ? cur->cpu/cur->inc : 0.0,cur->job.name);
E 19
 /* Sauber beendet */
D 19
 fprintf(stderr,"Paralleljob completed normally\n\n");
E 19
I 19
 puts("\nParalleljob completed normally\n");
E 19
 exit(0);
E 2
}

/*
  Speicher ist vielleicht aufgebraucht, keine Chance mehr.
*/
static getmem(expr)
char *expr;
{
 /* Hat es doch noch geklappt */
 if ( expr ) return;
 /* Nein, vorbei */
D 19
 fprintf(stderr,"PDL Interpreter out of memory\n");
E 19
I 19
 puts("PDL Interpreter out of memory");
E 19
D 2
 exit(2);
E 2
I 2
 exit(ENOMEM);
E 2
}

/*
I 2
  Feld der Verwaltungsstrukturen vergroessern.
*/
static extend_units()
{
 struct unit *nu;
 int i;

 /* Freies Element suchen */
 for ( i = 0 ; (i < aunit) && (unit[i].child != UFREE) ; i++ );
 if ( i < aunit ) return i;
 /* Feld erweitern */
 GETMEM(nu,struct unit,aunit+10);
 /* Alte Daten kopieren */
 if ( aunit )
  {
   memmove(nu,unit,aunit*sizeof(nu[0]));
   free(unit);
  }
 /* Zeiger aktualisieren */
 aunit += 10;
 unit = nu;
 /* Feld initialisieren */
 for ( i = 10 ; i ; ) unit[aunit-i--].child = UFREE;
 /* Ergebnis melden */
 return (aunit-10);
}

/*
E 2
  Parserfehler
*/
static CLIerror(msg)
char *msg;
{  
 /* Fehler ausgeben */
D 2
 fprintf(stderr,msg);
E 2
I 2
D 19
 fprintf(stderr,"Error in PDL-file %s: %s\n",where,msg);
E 19
I 19
 printf("Error in PDL-file %s: %s\n",where,msg);
E 19
E 2
 /* Eventuell aufhoeren */
D 2
 exit(3);
E 2
I 2
 exit(EINVAL);
E 2
}

/*
I 2
  Fehler in den Parametern
*/
static IDerror(msg)
char *msg;
{
 /* Fehler ausgeben */
D 19
 fprintf(stderr,"Error in QMan-ID: %s\n",msg);
E 19
I 19
 printf("Error in QMan-ID: %s\n",msg);
E 19
 /* Fertig */
 exit(EINVAL);
}

/*
  Fehler beim Arbeiten mit dem Queuemanager
*/
static PDLerror(p1,p2,p3)
char *p1,*p2,*p3;
{
 /* Fehler ausgeben */
D 19
 fprintf(stderr,"Error while dispatching: %s%s%s\n",p1,p2,p3);
E 19
I 19
 printf("Error while dispatching: %s%s%s\n",p1,p2,p3);
E 19
 /* Fertig */
 exit(EFAULT);
}

/*
  Kennung der GEN-Queue zerlegen:
  	IP,RPCPROG,RPCVERS,JOBID
*/
static analyze_id(id)
char *id;
{
 char *ip = id,*rp,*rv,*ji;

 /* Zerlegen */
 if ( !(rp = strchr(id,',')) ) IDerror("RPC Programnumber missing");
 *rp++ = '\0';
 if ( !(rv = strchr(rp,',')) ) IDerror("RPC Versionnumber missing");
 *rv++ = '\0';
 if ( !(ji = strchr(rv,',')) ) IDerror("Paralleljob Identifier missing");
 *ji++ = '\0';
 /* Umwandeln */
 rpcaddr = inet_addr(ip);
 /* Konsistenztests */
 if ( !strlen(ip) || (rpcaddr.s_addr == INADDR_NULL) ) IDerror("IP-Address not valid");
 if ( !parval(&rpcprog,rp) ) IDerror("RPC Programnumber not valid");
 if ( !parval(&rpcvers,rv) ) IDerror("RPC Versionnumber not valid");
 if ( !parval(&rpcverf,ji) ) IDerror("Paralleljob Identifier not valid");
}

/*
  Parameterwert umsetzen
*/
static parval(ip,str)
int *ip;
char *str;
{
 char *more;

 errno = 0;
 return ((((*ip = strtoul(str,&more,0)) != -1) || !errno) && more && !*more && (more != str));
}

/*
E 2
  Datei Zeile fuer Zeile einlesen und analysieren.
*/
static analyze_pdl()
{
 int res;

 /* Fehlermeldung initialisieren */
D 2
 sprintf(where,"before first definition");
E 2
I 2
 strcpy(where,"before first definition");
E 2
 /* Zeilen einlesen */
 while ( ((res = cli$dcl_parse_(NOSTR,parallelcld_,NOFCT,lib$get_input_,NOSTR))&1) &&
D 2
	 ((res = cli$dispatch_(0))) ) ;
E 2
I 2
	 ((res = cli$dispatch_(0))&1) ) ;
E 2
 /* Ende der Datei auswerten */
 if ( res != CLI$_EOF )
  {
D 2
   fprintf(stderr,"Error in PDL-file %s\n",where);
   exit(3);
E 2
I 2
D 19
   fprintf(stderr,"Syntax error in PDL-file %s\n",where);
E 19
I 19
   printf("Syntax error in PDL-file %s\n",where);
E 19
   exit(EINVAL);
E 2
  }
}

/*
 Auswertung der Jobinformationen einer Definition:
D 2
 P1
E 2
I 2
 	P1(FILENAME)
E 2
 	/CPUTIME=sekunden
 	/DATASIZE=kilobytes
I 2
	/KEEP
E 2
 	/LOG_FILE=filename
 	/MEMORYSIZE=kilobytes
 	/NAME=programname
 	/PARAMETERS=LIST(string)
I 2
        /PRINTER=printername
E 2
 	/PRIORITY=prio
 	/QUEUE=name
 	/STACKSIZE=kilobytes
*/
D 2
static submit *analyze_job(pdef,nolog)
E 2
I 2
D 19
static struct unit *analyze_job(pdef,nolog,kind)
E 19
I 19
static struct unit *analyze_job(pdef,kind)
E 19
E 2
char *pdef;
D 19
int nolog;
E 19
I 2
subkind kind;
E 2
{ 
D 2
 static char buf[256],jbuf[sizeof(clitemp)];
 int jlen,apar = 0,res;
 char *scan,*jp0,*jp1;
E 2
I 2
D 19
 static char buf[STDBUFSIZE],jbuf[STDBUFSIZE];
 int jlen,apar = 0,res,log;
E 19
I 19
 static stdBuffer buf,jbuf,pbuf;
 int jlen,apar = 0,res,log,deflog = !pdef;
E 19
 struct unit *nu;
D 21
 char *jp0,*jp1;
E 21
E 2
 submit *nj;
D 2
 param *np;
E 2
I 2
 text *np;
E 2

D 2
 /* Speicher allokatieren */
 if ( !(nj = MALLOC(submit,1)) ) return 0;
E 2
I 2
 /* Speicher allokatieren und initalisieren */
 nj = &(nu = unit+extend_units())->job;
D 7
 nu->nchan = nu->outc = nu->run = 0;
E 7
I 7
D 12
 nu->nchan = nu->outc = nu->run = nu->delp = 0;
E 12
I 12
 nu->nchan = nu->ninp = nu->nout = nu->outc = nu->run = nu->delp = 0;
E 12
E 7
 nu->info.kind = skNORMAL;
 nu->host = INADDR_ANY;
 nu->max = INT_MAX;
 nu->last = LNONE;
 nu->child = -1;
I 19
 nu->cpu = 0.0;
E 19
 nu->chan = 0;
I 19
 /* CLI */
 if ( !pdef )
  {
   if ( !string("CLI") ) CLIerror("expected value for CLI not found");
   GETSTRING(nj->Jinfo.shell,clitemp);
   /* - Defaultendung einsetzen */
   *(pdef = pbuf) = '.';
   if ( !strcmp("DCL",clitemp) )
    strcpy(pdef+1,"COM");
   else
    strcpy(pdef+1,clitemp);
  }
E 19
E 2
 /* P1 */
D 2
 if ( !string("P1") ) CLIerror("Expected value for file name not found\n");
 if ( !makedfile(clitemp,pdef,buf,sizeof(buf)) ) CLIerror("Could not analyze file name\n");
 getmem(nj->Jinfo.script = strdup(buf));
 /* Name fuer spaeter festhalten */
E 2
I 2
 if ( !string("P1") ) CLIerror("expected value for file name not found");
E 2
 strcpy(jbuf,clitemp);
I 2
 if ( !makefile(clitemp,pdef,buf,sizeof(buf)) ) CLIerror("could not analyze file name");
 GETSTRING(nj->Jinfo.script,buf);
E 2
 /* CPUTIME */
D 2
 if ( !number("CPUTIME",&nj->Jinfo.cpu,-1,0,50*366*24*60*60) )
  CLIerror("Value for CPUTIME qualifier out of range\n");
E 2
I 2
 if ( !number("CPUTIME",&nj->Jinfo.cpu,-1,1,50*366*24*60*60) )
  CLIerror("value for CPUTIME qualifier out of range");
E 2
 /* DATASIZE */
 if ( !number("DATASIZE",&nj->Jinfo.data,-1,10,1024*1024) )
D 2
  CLIerror("Value for DATASIZE qualifier out of range\n");
E 2
I 2
  CLIerror("value for DATASIZE qualifier out of range");
E 2
D 11
 /* LOG_FILE */
D 2
 if ( PRESENT("LOG_FILE") == CLI$_NEGATED )
E 2
I 2
 if ( (log = PRESENT("LOG_FILE")) == CLI$_NEGATED )
E 2
  /* Keine Datei benutzen */
D 2
  nj->Jinfo.log = "";
E 2
I 2
  GETSTRING(nj->Jinfo.log,"");
E 2
 else if ( string("LOG_FILE") ) 
  {
   /* Defaultendung anhaengen */
D 2
   if ( !makefile(clitemp,".log",buf,sizeof(buf)) ) CLIerror("Invalid LOG_FILE\n");
   getmem(nj->Jinfo.log = strdup(buf));
E 2
I 2
   if ( !makefile(clitemp,".log",buf,sizeof(buf)) ) CLIerror("invalid LOG_FILE");
   GETSTRING(nj->Jinfo.log,buf);
E 2
  }
D 2
 else if ( nolog )
  /* Keine Datei benutzen */
  nj->Jinfo.log = "";
 else
E 2
I 2
 else if ( (log == CLI$_PRESENT) || !nolog )
E 2
  {
   /* Jobname mit ersetzter Endung */
D 2
   strcpy(buf,nj->Jinfo.script);
   /* Endung ermitteln */
   jlen = strlen(buf);
   for ( scan = buf+jlen ; (scan-- > buf) && (*scan != '/') && (*scan != '.') ; );
   if ( (scan < buf) || (*scan == '/') ) scan = buf+jlen;
   *scan = '\0';
   /* Endung anhaengen */
   getmem(nj->Jinfo.log = MALLOC(char,strlen(buf)+5));
   strcpy(nj->Jinfo.log,buf);
   strcat(nj->Jinfo.log,".log");
E 2
I 2
   strcpy(buf,".log");
   if ( !makefile(buf,jbuf,buf,sizeof(buf)) ) 
    CLIerror("LOG_FILE could not be built from file name");
   GETSTRING(nj->Jinfo.log,buf);
E 2
  }
I 2
 else 
  /* Keine Datei benutzen */
  GETSTRING(nj->Jinfo.log,"");
E 11
E 2
 /* MEMORYSIZE */
 if ( !number("MEMORYSIZE",&nj->Jinfo.memory,-1,10,1024*1024) )
D 2
  CLIerror("Value for MEMORYSIZE qualifier out of range\n");
E 2
I 2
  CLIerror("value for MEMORYSIZE qualifier out of range");
E 2
 /* NAME */
 if ( !string("NAME") )
D 21
  {
   /* Name aus Jobname ermitteln */
D 2
   jp0 = jbuf+strlen(jbuf);
E 2
I 2
   jp0 = nj->Jinfo.script+strlen(nj->Jinfo.script);
E 2
   /* Anfang suchen */
D 2
   while ( (jp0-- > jbuf) && (*jp0 != ':') && (*jp0 != ']') && (*jp0 != '/') );
E 2
I 2
   while ( (jp0-- > nj->Jinfo.script) && (*jp0 != '/') && (*jp0 != ']') && (*jp0 != ':') );
E 2
   /* Ende suchen */
   for ( jp1 = buf ; *++jp0 && (*jp0 != '.') && (*jp0 != ';') ; )
    if ( (*jp0 >= 'a') && (*jp0 <= 'z') )
     *jp1++ = *jp0+'A'-'a';
    else
     *jp1++ = *jp0;
   *jp1++ = '\0';   
   /* Kopieren des modifizierten Namens */
D 2
   getmem(nj->name = strdup(buf));
E 2
I 2
   GETSTRING(nj->name,buf);
E 2
  }
E 21
I 21
  /* Name aus Jobname ermitteln */
  getmem(nj->name = fileToName(nj->Jinfo.script));
E 21
 else 
D 2
  getmem(nj->name = strdup(clitemp));
E 2
I 2
  GETSTRING(nj->name,clitemp);
I 11
 /* LOG_FILE */
 if ( (log = PRESENT("LOG_FILE")) == CLI$_NEGATED )
  /* Keine Datei benutzen */
  GETSTRING(nj->Jinfo.log,"");
 else if ( string("LOG_FILE") ) 
  {
   /* Defaultendung anhaengen */
   if ( !makefile(clitemp,".log",buf,sizeof(buf)) ) CLIerror("invalid LOG_FILE");
   GETSTRING(nj->Jinfo.log,buf);
  }
D 19
 else if ( (log == CLI$_PRESENT) || !nolog )
E 19
I 19
 else if ( (log == CLI$_PRESENT) || deflog )
E 19
  {
   /* Jobname mit ersetzter Endung */
   strcpy(buf,nj->name);
   strcat(buf,".log");
   if ( !makefile(buf,jbuf,buf,sizeof(buf)) ) 
    CLIerror("LOG_FILE could not be built from file name");
   GETSTRING(nj->Jinfo.log,buf);
  }
 else 
  /* Keine Datei benutzen */
  GETSTRING(nj->Jinfo.log,"");
E 11
 /* Vorgegebene Parameter */
 nj->Jinfo.param.param_len = (kind == skPARALLEL) ? 1 : 2;
E 2
 /* PARAMETERS */
D 2
 nj->Jinfo.param.param_len = 0;
E 2
 do
  {
   /* Speicherplatz bereitstellen */
D 2
   if ( nj->Jinfo.param.param_len == apar )
E 2
I 2
   if ( nj->Jinfo.param.param_len >= apar )
E 2
    {
     /* Speicher allokatieren */
D 2
     getmem(np = MALLOC(param,apar+10));
E 2
I 2
     GETMEM(np,text,apar+10);
E 2
     /* Alten Speicher kopieren und freigeben */
     if ( apar )
      {
       memmove(np,nj->Jinfo.param.param_val,apar*sizeof(np[0]));
       free(nj->Jinfo.param.param_val);
      }
     /* Variablen aktualisieren */
     apar += 10;
     nj->Jinfo.param.param_val = np;
    }
   /* Parameter einlesen */
D 12
   if ( (res = VALUE("PARAMETERS",clitemp,&ctlen)) == CLI$_ABSENT ) break;
E 12
I 12
   if ( (res = CVALUE("PARAMETERS")) == CLI$_ABSENT ) break;
E 12
D 2
   if ( !(res&1) && (res != CLI$_COMMA) ) CLIerror("Error parsing PARAMETERS\n");
E 2
I 2
   if ( !(res&1) && (res != CLI$_COMMA) ) CLIerror("getting value for PARAMETERS");
E 2
   /* Parameter einsetzen */
   clitemp[ctlen] = '\0';
D 2
   getmem(nj->Jinfo.param.param_val[nj->Jinfo.param.param_len++] = strdup(clitemp));
E 2
I 2
   GETSTRING(nj->Jinfo.param.param_val[nj->Jinfo.param.param_len++],clitemp);
E 2
  }
 while ( res == CLI$_COMMA );
I 2
 /* PRINTER=printername */
 if ( PRESENT("PRINTER") == CLI$_NEGATED )
  {
   /* Nicht ausdrucken, /KEEP ist Default */
   GETSTRING(nj->Jinfo.print,"");
   nj->Jinfo.dellog = 0;
  }
 else if ( !string("PRINTER") )
  CLIerror("expected value for PRINTER not found");
 else if ( !makelogical(clitemp,buf,sizeof(buf)) )
  CLIerror("could not calculate value of PRINTER");
 else
  {
   /* Ausdrucken, /NOKEEP ist default */
   GETSTRING(nj->Jinfo.print,buf);
   nj->Jinfo.dellog = 1;
  }
 /* KEEP */
 if ( (res = PRESENT("KEEP")) == CLI$_PRESENT )
  nj->Jinfo.dellog = 0;
 else if ( res == CLI$_NEGATED )
  nj->Jinfo.dellog = 1;
E 2
 /* PRIORITY */
 if ( !number("PRIORITY",&nj->Jinfo.nice,-1,0,255) )
D 2
  CLIerror("Value for PRIORITY qualifier out of range\n"); 
E 2
I 2
  CLIerror("value for PRIORITY qualifier out of range"); 
E 2
 /* QUEUE */
D 2
 if ( !string("QUEUE") ) CLIerror("Expected value for QUEUE not found\n");
E 2
I 2
 if ( !string("QUEUE") ) CLIerror("expected value for QUEUE not found");
E 2
 if ( !makelogical(clitemp,buf,sizeof(buf)) ) 
D 2
  CLIerror("Could not calculate value of QUEUE parameter\n");
 getmem(nj->Qinfo.queue = strdup(buf));
E 2
I 2
  CLIerror("could not calculate value of QUEUE parameter");
 GETSTRING(nj->Qinfo.queue,buf);
E 2
 /* STACKSIZE */
 if ( !number("STACKSIZE",&nj->Jinfo.stack,-1,10,1024*1024) )
D 2
  CLIerror("Value for STACKSIZE qualifier out of range\n");
E 2
I 2
  CLIerror("value for STACKSIZE qualifier out of range");
E 2
 /* Initialisierung beenden */
I 2
 nj->hold = nj->at = nj->restart = 0;
E 2
 nj->Kind = sSUBMIT;
D 2
 nj->restart = nj->hold = nj->at = 0;
 nj->Qinfo.host = nj->Qinfo.user = nj->Qinfo.requeue = "";
E 2
I 2
 nj->Qinfo.host = INADDR_ANY;
 GETSTRING(nj->Qinfo.user,"");
 GETSTRING(nj->Qinfo.requeue,"");
 nj->Jinfo.requestID = -1;
E 2
 nj->Jinfo.rmsfile = 0;
 nj->Jinfo.uid = getuid();
 nj->Jinfo.gid = getgid();
D 2
 nj->Jinfo.kind = skNORMAL;
E 2
I 2
 nj->Jinfo.kind = kind;
 nj->Jinfo.delcom = 0;
E 2
 /* Fertig */
D 2
 return nj;
E 2
I 2
 return nu;
E 2
}

/*
  Kanalstrukturen einlesen:
  	/INPUT=converterio
	/OUTPUT=converterio
*/
D 2
static analyze_extra(sub)
submit *sub;
E 2
I 2
static analyze_extra(un)
struct unit *un;
E 2
{
I 19
 char *str;

E 19
D 12
 /* Speicher allokatieren */
D 2
 getmem(EXTRA(sub) = MALLOC(struct extra,1));
E 2
I 2
 un->nchan = 2;
 GETMEM(un->chan,struct extra,2);
E 2
 /* Beide Parameter einlesen */
D 2
 analyze_extra_channel(&EXTRA(sub)->input,"INPUT");
 analyze_extra_channel(&EXTRA(sub)->output,"OUTPUT");
E 2
I 2
 analyze_extra_channel(un->chan+0,"INPUT",un->job.Jinfo.param.param_val+0);
 analyze_extra_channel(un->chan+1,"OUTPUT",un->job.Jinfo.param.param_val+1);
E 12
I 12
 /* Eingabekanaele einlesen */
 analyze_extra_channel(un,"INPUT",un->job.Jinfo.param.param_val+0);
 un->ninp = un->nchan;
 /* Ausgabekanaele einlesen */
 analyze_extra_channel(un,"OUTPUT",un->job.Jinfo.param.param_val+1);
 un->nout = un->nchan-un->ninp;
I 19
 /* Kontrolltest */
 str = un->job.Jinfo.param.param_val[1];
 if ( (*str == 'F') && strchr(str,',') ) CLIerror("Multiple OUTPUT FILENAMES not allowed");
E 19
E 12
E 2
}

/*
I 12
  Kanalstruktur in die Liste eines Konverters eintragen.
*/
static add_extra_channel(un,ech)
struct unit *un;
struct extra *ech;
{
 struct extra *nch;
 int n;

 /* Struktur vergroessern */
 GETMEM(nch,struct extra,un->nchan+1);
 /* Alten Bereich kopieren */
 if ( un->chan )
  {
   memmove(nch,un->chan,un->nchan*sizeof(nch[0]));
   /* Zeiger auf die Namen duerfen nicht freigegeben werden */
   free(un->chan);
  }
 /* Daten uebernehmen */
 (un->chan = nch)[un->nchan++] = *ech;
}

/*
E 12
D 2
  Eine Kanalstruktur einlesen:
  a) NOxxxx
  b) xxxx=(FILENAME=filename)
  c) xxxx=(PROGRAM=programname[,UNIT=NUMBER][,MAXCHANNELS=NUMBER])
E 2
I 2
  Eine Kanalstruktur einlesen und Konverterparameter erzeugen:
  a) NOxxxx								N
D 15
  b) xxxx=(FILENAME=filename)						Ffilename
E 15
I 15
  b) xxxx=(FILENAMES=(filename[,...])					Ffilename,...
E 15
D 12
  c) xxxx=(PROGRAM=programname[,UNIT=NUMBER][,MAXCHANNELS=NUMBER])	Pmaxchannels
E 12
I 12
  c) xxxx=(PROGRAMS=(programname[,...])
           [,UNITS=(NUMBER[,...])]
	   [,MAXCHANNELS=(NUMBER[,...])]				Pmaxchannels
E 12
E 2
*/
D 2
static analyze_extra_channel(ech,what)
struct extra_channel *ech;
char *what;
E 2
I 2
D 12
static analyze_extra_channel(ech,what,store)
struct extra *ech;
E 12
I 12
static analyze_extra_channel(un,what,store)
struct unit *un;
E 12
char *what,**store;
E 2
{
D 2
 static char key[32],buf[256];
E 2
I 2
D 19
 static char key[32],buf[STDBUFSIZE];
E 2
D 12
 int len = strlen(what);
 
I 2
 /* Kanal initialisieren */
 index1(ech->link) = -1;
E 12
I 12
 int len = strlen(what),res,start,ix,max;
E 19
I 19
 static char key[32],*bufp;
 static stdBuffer buf;
 int len = strlen(what),res,start,ix,max,xlen,nlen = 0,alen = 0;
E 19
 struct extra ech,*pch;
I 19
 char *nbuf;
E 19

E 12
E 2
 /* NOwhat */
D 2
 if ( cli$present_(what,strlen(what)) == CLI$_NEGATED )
E 2
I 2
 if ( cli$present_(what,strlen(what)) != CLI$_PRESENT )
E 2
  {
D 2
   /* Das absolute nichts */
E 2
I 2
   /* Das absolute Nichts */
E 2
D 12
   ech->name = 0;   
   ech->unit = ech->max = 0;
E 12
I 12
   ech.name = 0;   
   ech.unit = ech.max = 0;
   index1(ech.link) = -1;
E 12
D 2
   return;
E 2
I 2
   /* Bleibt nichts */
   strcpy(buf,"N");
I 12
   /* Eintrag uebernehmen */
   add_extra_channel(un,&ech);
E 12
E 2
  }
D 2
 /* Prefix ermitteln */
 strcpy(key,what);
 /* what=(FILENAME=filename) */
 strcpy(key+len,".FILENAME");
 if ( string(key) )
E 2
I 2
 else
E 2
  {
D 2
   if ( !makedfile(clitemp,defdir,buf,sizeof(buf)) ) CLIerror("Could not analyze FILENAME\n");
   getmem(ech->name = strdup(buf));
   /* Fertig */
   ech->unit = ech->max = 0;
   return;
E 2
I 2
   /* Prefix ermitteln */
   strcpy(key,what);
D 15
   /* what=(FILENAME=filename) */
   strcpy(key+len,".FILENAME");
E 15
I 15
   /* what=(FILENAMES=filename[,...]) */
   strcpy(key+len,".FILENAMES");
E 15
D 19
   if ( string(key) )
E 19
I 19
   if ( cli$present_(key,strlen(key)) == CLI$_PRESENT )
E 19
    {
D 15
     if ( !makefile(clitemp,NOSTR,buf,sizeof(buf)) ) CLIerror("could not analyze FILENAME");
E 15
I 15
D 19
     if ( !makefile(clitemp,NOSTR,buf,sizeof(buf)) ) CLIerror("could not analyze FILENAMES");
E 15
D 12
     GETSTRING(ech->name,buf);
E 12
I 12
     GETSTRING(ech.name,buf);
E 19
E 12
     /* Initialisieren */
D 12
     ech->unit = ech->max = 0;
E 12
I 12
     ech.unit = ech.max = 0;
     index1(ech.link) = -1;
E 12
D 19
     /* Dateiname festhalten */
D 12
     sprintf(buf,"F%s",ech->name);
E 12
I 12
     sprintf(buf,"F%s",ech.name);
     /* Eintrag uebernehmen */
     add_extra_channel(un,&ech);
E 12
    }
   else
    {
D 12
     /* what=(PROGRAM=programname[...]) */
     strcpy(key+len,".PROGRAM");
     if ( !string(key) ) CLIerror("expected value for PROGRAM not found");
     GETSTRING(ech->name,clitemp);
     /* MAXCHANNELS=NUMBER */
E 12
I 12
     /* Liste von Programmnamen erzeugen */
     start = un->nchan;
     max = 0;
     /* Defaultwerte eintragen */
     ech.unit = 10;
     ech.max = 255;
     index1(ech.link) = -1;
     /* what=(PROGRAMS=(programname[,...])) */
     strcpy(key+len,".PROGRAMS");
E 19
I 19
     /* Durchgehen aller Namen */
E 19
     do
      {
D 19
       /* Name auslesen */
E 19
       if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) ) 
D 19
	CLIerror("expected value for PROGRAMS not found");
       /* Name eintragen */
E 19
I 19
	CLIerror("expected value for FILENAMES not found");
       /* Name uebersetzen */
E 19
       clitemp[ctlen] = '\0';
D 19
       GETSTRING(ech.name,clitemp);
E 19
I 19
       if ( !makefile(clitemp,NOSTR,buf,sizeof(buf)) ) CLIerror("could not analyze FILENAMES");
       GETSTRING(ech.name,buf);
E 19
       /* Kanal eintragen */
       add_extra_channel(un,&ech);
D 19
       /* Zaehler erweitern */
       max += ech.max;
E 19
I 19
       /* Dateiname festhalten */
       if ( (nlen+1+(xlen = strlen(ech.name))+1) > alen )
	{
	 /* Reservieren */
	 GETMEM(nbuf,char,alen+xlen+100);
	 /* Kopieren */
	 if ( alen )
	  {
	   memmove(nbuf,bufp,nlen);
	   free(bufp);
	  }
	 /* Merken */
	 alen += xlen+100;
	 bufp = nbuf;
	}
       bufp[nlen] = nlen ? ',' : 'F';
       strcpy(bufp+nlen+1,ech.name);
       nlen += 1+xlen;
E 19
      }
     while ( res != CLI$_NORMAL );
D 19
     /* UNITS=(NUMBER[,...]) */
     strcpy(key+len,".UNITS");
     if ( cli$present_(key,strlen(key)) == CLI$_PRESENT )
      for ( pch = un->chan+(ix = start) ; ix++ < un->nchan ; pch++ )
       {
	/* Zahl auslesen und Konsistenz ueberpruefen */
	if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
	 CLIerror("could not read value for UNITS");
	if ( (res == CLI$_NORMAL) != (ix == un->nchan) )
	 CLIerror("number of UNITS does not match number of PROGRAMS");
	/* Zahl umwandeln */
	clitemp[ctlen] = '\0';
	if ( ((pch->unit = atoi(clitemp)) < 1) || (pch->unit > 999) )
         CLIerror("value for UNITS out of range"); 
       }
     /* MAXCHANNELS=(NUMBER[,...]) */
E 12
     strcpy(key+len,".MAXCHANNELS");
D 12
     if ( !number(key,&ech->max,255,1,255) ) CLIerror("value for MAXCHANNELS out of range");
     /* UNIT=NUMBER */
     strcpy(key+len,".UNIT");
     if ( !number(key,&ech->unit,10,1,999) ) CLIerror("value for UNIT out of range");
E 12
I 12
     if ( cli$present_(key,strlen(key)) == CLI$_PRESENT )
      for ( pch = un->chan+(ix = start) ; ix++ < un->nchan ; pch++ )
       {
	/* Zahl auslesen und Konsistenz ueberpruefen */
	if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
	 CLIerror("could not read value for MAXCHANNELS");
	if ( (res == CLI$_NORMAL) != (ix == un->nchan) )
	 CLIerror("number of MAXCHANNELS does not match number of PROGRAMS");
	/* Zaehler korrigieren */
	max -= pch->max;
	/* Zahl umwandeln */
	clitemp[ctlen] = '\0';
	if ( ((pch->max = atoi(clitemp)) < 1) || (pch->max > 255) )
         CLIerror("value for MAXCHANNELS out of range"); 
	/* Zaehler korrigieren */
	max += pch->max;
       }
E 12
     /* Kanalzahl festhalten */
D 12
     sprintf(buf,"P%d",ech->max);
E 12
I 12
     sprintf(buf,"P%d",max);
E 19
I 19
     /* Ergebnis melden */
     *store = bufp;
     /* Fertig */
     return;
E 19
E 12
    }
I 19
   /* Liste von Programmnamen erzeugen */
   start = un->nchan;
   max = 0;
   /* Defaultwerte eintragen */
   ech.unit = 10;
   ech.max = 255;
   index1(ech.link) = -1;
   /* what=(PROGRAMS=(programname[,...])) */
   strcpy(key+len,".PROGRAMS");
   do
    {
     /* Name auslesen */
     if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) ) 
      CLIerror("expected value for PROGRAMS not found");
     /* Name eintragen */
     clitemp[ctlen] = '\0';
     GETSTRING(ech.name,clitemp);
     /* Kanal eintragen */
     add_extra_channel(un,&ech);
     /* Zaehler erweitern */
     max += ech.max;
    }
   while ( res != CLI$_NORMAL );
   /* UNITS=(NUMBER[,...]) */
   strcpy(key+len,".UNITS");
   if ( cli$present_(key,strlen(key)) == CLI$_PRESENT )
    for ( pch = un->chan+(ix = start) ; ix++ < un->nchan ; pch++ )
     {
      /* Zahl auslesen und Konsistenz ueberpruefen */
      if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
       CLIerror("could not read value for UNITS");
      if ( (res == CLI$_NORMAL) != (ix == un->nchan) )
       CLIerror("number of UNITS does not match number of PROGRAMS");
      /* Zahl umwandeln */
      clitemp[ctlen] = '\0';
      if ( ((pch->unit = atoi(clitemp)) < 1) || (pch->unit > 999) )
       CLIerror("value for UNITS out of range"); 
     }
   /* MAXCHANNELS=(NUMBER[,...]) */
   strcpy(key+len,".MAXCHANNELS");
   if ( cli$present_(key,strlen(key)) == CLI$_PRESENT )
    for ( pch = un->chan+(ix = start) ; ix++ < un->nchan ; pch++ )
     {
      /* Zahl auslesen und Konsistenz ueberpruefen */
      if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
       CLIerror("could not read value for MAXCHANNELS");
      if ( (res == CLI$_NORMAL) != (ix == un->nchan) )
       CLIerror("number of MAXCHANNELS does not match number of PROGRAMS");
      /* Zaehler korrigieren */
      max -= pch->max;
      /* Zahl umwandeln */
      clitemp[ctlen] = '\0';
      if ( ((pch->max = atoi(clitemp)) < 1) || (pch->max > 255) )
       CLIerror("value for MAXCHANNELS out of range"); 
      /* Zaehler korrigieren */
      max += pch->max;
     }
   /* Kanalzahl festhalten */
   sprintf(buf,"P%d",max);
E 19
E 2
  }
D 2
 /* what=(PROGRAM=programname[...]) */
 strcpy(key+len,".PROGRAM");
 if ( !string(key) ) CLIerror("Expected value for PROGRAM not found\n");
 getmem(ech->name = strdup(clitemp));
 /* MAXCHANNELS=NUMBER */
 strcpy(key+len,".MAXCHANNELS");
 if ( !number(key,&ech->max,255,1,255) ) CLIerror("Value for MAXCHANNELS out of range\n");
 /* UNIT=NUMBER */
 strcpy(key+len,".UNIT");
 if ( !number(key,&ech->unit,10,1,99) ) CLIerror("Value for UNIT out of range\n");
E 2
I 2
 /* Parameter aktualisieren */
 GETSTRING(*store,buf);
E 2
}

/*
  Parameter einlesen
*/
static string(what)
char *what;
{
 /* Parameter einlesen */
D 12
 if ( !(cli$get_value_(what,clitemp,&ctlen,strlen(what),sizeof(clitemp)-1)&1) ) return 0;
E 12
I 12
 if ( !(CVALUE(what)&1) ) return 0;
E 12
 /* In das C-Format bringen */
 clitemp[ctlen] = '\0';
 /* Fertig */
 return 1;
}

/*
  Zahl einlesen.
*/
static number(what,num,def,min,max)
char *what;
int *num,def,min,max;
{
 /* Defaultwert setzen */
 *num = def;
 /* Parameter ermitteln */
D 2
 if ( !(cli$get_value_(what,clitemp,&ctlen,strlen(what),sizeof(clitemp)-1)&1) ) return 1;
 clitemp[ctlen] = '\0';
E 2
I 2
 if ( !string(what) ) return 1;
E 2
 /* Parameter umwandeln */
 return (((*num = atoi(clitemp)) >= min) && (*num <= max));
}

/*
D 2
  Dateiname umwandeln und mit Defaultdirectory versehen
E 2
I 2
  Ausgabe der Informationen eines Jobs
E 2
*/
D 2
static makedfile(fname,dir,res,rlen)
char *fname,*dir,*res;
int rlen;
E 2
I 2
static view_job(un)
struct unit *un;
E 2
{
D 2
 int len1,len2;
E 2
I 2
 submit *j = &un->job;
 int n;
E 2

D 2
 /* Name umwandeln */
 if ( !(fname = translate_vms(fname)) || (fname == (char *)-1) ) return 0;
 /* Arbeitsdirectory suchen, falls noetig */
 if ( *fname == '/' )
  *res = '\0';
 else 
  strcpy(res,dir);
 /* Laengen ermitteln */
 len1 = strlen(res);
 len2 = strlen(fname);
 if ( len1 && (res[len1-1] != '/') ) res[len1++] = '/';
 /* Konsistenztest */
 if ( (len1+len2+1) > rlen ) return 0;
 /* Ergebnis zusammenstellen und Erfolg melden */
 strcpy(res+len1,fname);
 return 1;
E 2
I 2
 /* Art und Datei */
 if ( j->Jinfo.kind == skCONVERTER )
D 19
  fprintf(stderr,"CONVERTER #%d %s",un->num,j->Jinfo.script);
E 19
I 19
  printf("CONVERTER #%d %s",un->num,j->Jinfo.script);
E 19
 else
D 19
  fprintf(stderr,"PROGRAM #%d [%s] %s",un->num,j->Jinfo.shell,j->Jinfo.script);
E 19
I 19
  printf("PROGRAM #%d [%s] %s",un->num,j->Jinfo.shell,j->Jinfo.script);
E 19
 /* Parameter */
 for ( n = 0 ; n < j->Jinfo.param.param_len ; n++ )
D 19
  fprintf(stderr," %s",j->Jinfo.param.param_val[n]);
 fprintf(stderr,"\n");
E 19
I 19
  printf(" %s",j->Jinfo.param.param_val[n]);
 puts("");
E 19
 /* Feste Optionen */
D 19
 fprintf(stderr,"\t/NAME=%s/QUEUE=%s\n",j->name,j->Qinfo.queue);
E 19
I 19
 printf("\t/NAME=%s/QUEUE=%s\n",j->name,j->Qinfo.queue);
E 19
 /* Variable Optionen */
D 19
 if ( j->Jinfo.nice > 0 ) fprintf(stderr,"\t/PRIORITY=%d\n",j->Jinfo.nice);
 if ( j->Jinfo.cpu > 0 ) fprintf(stderr,"\t/CPUTIME=%d\n",j->Jinfo.cpu);
 if ( j->Jinfo.data > 0 ) fprintf(stderr,"\t/DATASIZE=%d\n",j->Jinfo.data);
 if ( j->Jinfo.stack > 0 ) fprintf(stderr,"\t/STACKSIZE=%d\n",j->Jinfo.stack);
 if ( j->Jinfo.memory > 0 ) fprintf(stderr,"\t/MEMORYSIZE=%d\n",j->Jinfo.memory);
D 13
 if ( j->Jinfo.rmsfile ) fprintf(stderr,"\t/RMS_FILE\n");
E 13
I 13
 if ( j->Jinfo.rmsfile&RMS_RMSFILE ) fprintf(stderr,"\t/RMS_FILE\n");
E 19
I 19
 if ( j->Jinfo.nice > 0 ) printf("\t/PRIORITY=%d\n",j->Jinfo.nice);
 if ( j->Jinfo.cpu > 0 ) printf("\t/CPUTIME=%d\n",j->Jinfo.cpu);
 if ( j->Jinfo.data > 0 ) printf("\t/DATASIZE=%d\n",j->Jinfo.data);
 if ( j->Jinfo.stack > 0 ) printf("\t/STACKSIZE=%d\n",j->Jinfo.stack);
 if ( j->Jinfo.memory > 0 ) printf("\t/MEMORYSIZE=%d\n",j->Jinfo.memory);
 if ( j->Jinfo.rmsfile&RMS_RMSFILE ) puts("\t/RMS_FILE");
E 19
E 13
 /* Drucker */
 if ( *j->Jinfo.print )
  {
D 19
   fprintf(stderr,"\t/PRINTER=%s\n",j->Jinfo.print);
   if ( !j->Jinfo.dellog ) fprintf(stderr,"\t/KEEP\n");
E 19
I 19
   printf("\t/PRINTER=%s\n",j->Jinfo.print);
   if ( !j->Jinfo.dellog ) puts("\t/KEEP");
E 19
  }
 else
  {
D 19
   fprintf(stderr,"\t/NOPRINTER\n");
   if ( j->Jinfo.dellog ) fprintf(stderr,"\t/NOKEEP\n");
E 19
I 19
   puts("\t/NOPRINTER");
   if ( j->Jinfo.dellog ) puts("\t/NOKEEP");
E 19
  }
 /* Logdatei */
 if ( !*j->Jinfo.log )
D 19
  fprintf(stderr,"\t/NOLOG_FILE\n\n");
E 19
I 19
  puts("\t/NOLOG_FILE\n");
E 19
 else
D 19
  fprintf(stderr,"\t/LOG_FILE=%s\n\n",j->Jinfo.log);
E 19
I 19
  printf("\t/LOG_FILE=%s\n\n",j->Jinfo.log);
E 19
E 2
}

/*
 Auswertung einer CLD-Konverterinstruktion:
  	CONVERTER p1
	* /CPUTIME=sekunden
	* /DATASIZE=kilobytes
	  /INPUT=programconnection
I 2
	* /KEEP
E 2
	* /LOG_FILE=filename
	* /MEMORYSIZE=kilobytes
	* /NAME=convertername
	  /OUTPUT=programconnection
	* /PARAMETERS=LIST(string)
I 2
	* /PRINTER=printername
E 2
	* /PRIORITY=prio
 	* /QUEUE=name
	* /STACKSIZE=kilobytes
*/
pj_converter_()
{
D 2
 submit *newc;
E 2
I 2
 struct unit *newu;
E 2

 /* Fehlercode setzen */
D 2
 sprintf(where,"after CONVERTER definition %d",++nconv);
E 2
I 2
 sprintf(where,"after CONVERTER #%d",++nconv);
E 2
 /* Jobkontrollstruktur einlesen */
D 2
 newc = analyze_job("/usr/converter/dyadic/");
E 2
I 2
D 19
 newu = analyze_job("boss$usr:[converter.dyadic]",1,skCONVERTER);
E 19
I 19
 newu = analyze_job("boss$usr:[converter.dyadic]",skCONVERTER);
E 19
 /* Initialisierung beenden */
 GETSTRING(newu->job.Jinfo.shell,newu->job.Jinfo.script);
 newu->num = nconv;
E 2
 /* Kanaele einlesen */
D 2
 analyze_extra(newc);
E 2
I 2
 analyze_extra(newu);
 /* Verify beachten */
 if ( verify ) view_job(newu);
E 2
}

/*
 Auswertung einer CLD-Programminstruktion:
  	PROGRAM p1
	  /CLI=shellname
	* /CPUTIME=sekunden
	* /DATASIZE=kilobytes
I 2
	* /KEEP
E 2
	* /LOG_FILE=filename
	* /MEMORYSIZE=kilobytes
	* /NAME=programname
	* /PARAMETERS=LIST(string)
          /PRIMARY_FILE=filename
I 2
	* /PRINTER=printername
E 2
	* /PRIORITY=prio
 	* /QUEUE=name
	  /RMS_FILE
	* /STACKSIZE=kilobytes
*/
pj_program_()
{
D 2
 static char buf[256];
 submit *newp;
E 2
I 2
D 19
 static char buf[STDBUFSIZE];
E 19
I 19
 static stdBuffer buf;
E 19
 struct unit *newu;
 submit *nj;
E 2
 int conv;

 /* Fehlercode setzen */
D 2
 sprintf(where,"after PROGRAM definition %d",++nprog);
E 2
I 2
 sprintf(where,"after PROGRAM #%d",++nprog);
E 2
 /* PRIMARY_FILE */
 conv = (PRESENT("PRIMARY_FILE") == CLI$_PRESENT);
 /* Jobkontrollstruktur einlesen */
D 2
 newp = analyze_job(conv ? "/usr/converter/monadic/" : defdir,conv);
E 2
I 2
D 19
 newu = analyze_job(conv ? "boss$usr:[converter.monadic]" : NOSTR,conv,skPARALLEL);
E 19
I 19
 newu = analyze_job(conv ? "boss$usr:[converter.monadic]" : NOSTR,skPARALLEL);
E 19
 nj = &newu->job;
E 2
 /* PRIMARY_FILE */
 if ( conv )
  {
D 2
   if ( !string("PRIMARY_FILE") ) CLIerror("Expected value for PRIMARY_FILE not found\n");
   if ( !makedfile(clitemp,defdir,buf,sizeof(buf)) ) CLIerror("Invalid PRIMARY_FILE name\n");
E 2
I 2
   if ( !string("PRIMARY_FILE") ) CLIerror("expected value for PRIMARY_FILE not found");
   if ( !makefile(clitemp,NOSTR,buf,sizeof(buf)) ) CLIerror("invalid PRIMARY_FILE name");
E 2
   /* Ein bisschen vertauschen */
D 2
   newp->Jinfo.shell = newp->Jinfo.script;
   getmem(newp->Jinfo.script = strdup(buf));
E 2
I 2
   nj->Jinfo.shell = nj->Jinfo.script;
   GETSTRING(nj->Jinfo.script,buf);
   /* Und eine Spezialstruktur aufbauen */
   newu->nchan = 1;
   GETSTRUCT(newu->chan,struct extra);
   GETSTRING(newu->chan->name,nj->Jinfo.script);
   newu->chan->max = newu->chan->unit = 0;
   index1(newu->chan->link) = -1;
   /* Dieses Programm kann es maximal einmal geben */
   newu->max = 1;
E 2
  }
 else
D 19
  {
   /* CLI */
D 2
   if ( !string("CLI") ) CLIerror("Expected value for CLI not found\n");
   if ( !makelogical(clitemp,buf,sizeof(buf)) ) CLIerror("Could not use value for CLI\n");
   getmem(newp->Jinfo.shell = strdup(buf));
E 2
I 2
   if ( !string("CLI") ) CLIerror("expected value for CLI not found");
   GETSTRING(nj->Jinfo.shell,clitemp);
E 2
  }
 /* RMS_FILE */
D 2
 if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) newp->Jinfo.rmsfile = 1;
E 2
I 2
D 13
 if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) nj->Jinfo.rmsfile = 1;
E 13
I 13
 if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) nj->Jinfo.rmsfile = RMS_RMSFILE;
E 19
I 19
  /* RMS_FILE */
  if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) nj->Jinfo.rmsfile = RMS_RMSFILE;
E 19
E 13
E 2
 /* Fertig initialisieren */
D 2
 EXTRA(newp) = conv ? EXTRAPRIMARY : EXTRAPROGRAM;
E 2
I 2
 nj->Jinfo.param.param_val[0] = "{<IP,port,unit>}";
 newu->info.kind = skPARALLEL;
 newu->num = nprog;
 newu->info.lfor = 0;
 newu->info.vfor = 0;
 /* VERIFY beachten */
 if ( verify ) view_job(newu);
E 2
}

/*
  Defaultdirectory setzen:
  	SET DEFAULT P2
*/
pj_set_default_()
{
D 2
 static char buf[256];
E 2
I 2
D 19
 static char buf[STDBUFSIZE];
E 19
I 19
 static stdBuffer buf;
E 19
E 2

 /* Parameter einlesen */
D 2
 if ( !string("P2") ) CLIerror("Could not get directory name\n");
 /* Name umwandeln */
 if ( !makedfile(clitemp,defdir,buf,sizeof(buf)) ) CLIerror("Invalid directory name\n");
 /* Neuen Wert merken */
 free(defdir);
 getmem(defdir = strdup(buf));
E 2
I 2
 if ( !string("P2") ) CLIerror("could not get directory name");
 /* VERIFY beachten */
D 19
 if ( verify ) fprintf(stderr,"SET DEFAULT %s\n\n",clitemp);
E 19
I 19
 if ( verify ) printf("SET DEFAULT %s\n\n",clitemp);
E 19
 /* Umrechnen in Directory */
 if ( !makefile(clitemp,NOSTR,buf,sizeof(buf)) ) CLIerror("invalid DEFAULT specification");
 /* Neuen Wert benutzen */
 if ( chdir(buf) == -1 ) CLIerror("DEFAULT directory not found");
E 2
}

/*
I 2
  Listoption an oder abschalten:
  	SET [NO]VERIFY
*/
pj_set_verify_()
{
 /* Option einlesen */
 switch (PRESENT("VERIFY"))
  {
   case CLI$_NEGATED : /* Abschalten */
D 19
     		       if ( verify ) fprintf(stderr,"SET NOVERIFY\n");
E 19
I 19
     		       if ( verify ) puts("SET NOVERIFY");
E 19
     		       verify = 0;
     		       break;
   case CLI$_PRESENT : /* Anschalten */
D 19
    		       if ( verify ) fprintf(stderr,"SET VERIFY\n");
E 19
I 19
    		       if ( verify ) puts("SET VERIFY");
E 19
     		       verify = 1;
     		       break;
  }
}

/*
  Debugoption an oder abschalten:
  	SET [NO]DEBUG
*/
pj_set_debug_()
{
 /* Option einlesen */
 switch (PRESENT("DEBUG"))
  {
   case CLI$_NEGATED : /* Abschalten */
D 19
     		       if ( verify ) fprintf(stderr,"SET NODEBUG\n");
E 19
I 19
     		       if ( verify ) puts("SET NODEBUG");
E 19
     		       debug = 0;
     		       break;
   case CLI$_PRESENT : /* Anschalten */
D 19
    		       if ( verify ) fprintf(stderr,"SET DEBUG\n");
E 19
I 19
    		       if ( verify ) puts("SET DEBUG");
E 19
     		       debug = 1;
     		       break;
  }
}

/*
I 19
  Schwellen zum Starten und Stoppen setzen.
  	SET THRESHOLD=(CREATE=NUMBER,DELETE=NUMBER)
*/
pj_set_threshold_()
{
 double create = tostart,delete = tostop;
 int num;
 
 /* CREATE */
 if ( !number("CREATE",&num,-1,0,100) ) CLIerror("value for CREATE out of range");
 if ( num != -1 ) create = num/100.0;
 /* DELETE */
 if ( !number("DELETE",&num,-1,0,100) ) CLIerror("value for DELETE out of range");
 if ( num != -1 ) delete = num/100.0;
 /* Einsetzen */
 if ( create > delete ) CLIerror("value for CREATE must be less than value for DELETE");
 tostart = create;
 tostop = delete;
 /* Ausgeben */
 if ( verify ) pj_show_threshold_();
}

/*
E 19
E 2
  Keine Aktion starten
*/
pj_nothing_()
{
 /* Gibt eine Warnung */
D 2
 CLIerror("Invalid use of SET DEFAULT <directory>\n");
E 2
I 2
 CLIerror("internal CLD mismatch");
}

/*
I 5
  SCCS Versionsnummer ausgeben:
D 12
  	VERSION
E 12
I 12
D 19
  	[SHOW] VERSION
E 19
I 19
  	SHOW VERSION
E 19
E 12
*/
D 6
pj_version()
E 6
I 6
D 19
pj_version_()
E 19
I 19
pj_show_version_()
E 19
E 6
{
 /* Version ausgeben */
D 9
 fprintf(stderr,"VMS/UNIX Parallelinterpreter Version %I% by Jochen Manns (%E% %U%)\n");
E 9
I 9
D 19
 fprintf(stderr,"BOSS/UNIX Parallelinterpreter Version %I% by Jochen Manns (%E% %U%)\n");
E 19
I 19
 puts("BOSS/UNIX Parallelinterpreter Version %I% by Jochen Manns (%E% %U%)");
E 19
E 9
}

I 19
/*
  Aktuelles Verhaeltnis ausgeben:
  	SHOW THRESHOLD
*/
pj_show_threshold_()
{
 /* Ausgeben */
 puts("Channel idle time");
 printf("\t< %3d percent may start a new job\n",(int)(100.0*tostart));
 printf("\t> %3d percent may terminate a job\n",(int)(100.0*tostop));
}
E 19

/*
E 5
  Aufloesen der Referenzen und Verifizieren des Paralleljobs.
  Phase I
  -------
  	Zu jeder CONVERTER-Seite muss eine passende Verbindung gefunden werden.
	Ist ein CONVERTER auf beiden Seiten NICHT mit einem Programm verbunden,
	so darf nur dieser eine CONVERTER definiert sein (Kopierjob). Gleich-
	zeitig wird sichergestellt, dass Programmnamen eindeutig sind.
  Phase II
  --------
	Jedes PROGRAM muss mit mindestens einem Konverter verbunden sein. Ist
	keinerlei Verbindung vorhanden, so kann das PROGRAM nicht im Rahmen eines
	Paralleljobs ablaufen.
*/
static resolve_pdl()
{
 struct unit *cur;
 int i,j;

 /* Phase I: Alle Konverter durchgehen */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skCONVERTER )
D 12
   if ( (cur->chan[0].name && cur->chan[0].max) || (cur->chan[1].name && cur->chan[1].max) )
    {
     /* Programme zuordnen */
     resolve_extra(cur,0);
     resolve_extra(cur,1);
    }
E 12
I 12
   if ( (cur->chan[0].name && cur->chan[0].max) || 
	(cur->chan[cur->ninp].name && cur->chan[cur->ninp].max) )
    /* Programme zuordnen */
    for ( j = cur->nchan ; j-- ; resolve_extra(cur,j) );
E 12
   else if ( (nconv != 1) || nprog )
    {
D 19
     fprintf(stderr,"CONVERTER #%d has no valid connections\n",cur->num);
E 19
I 19
     printf("CONVERTER #%d has no valid connections\n",cur->num);
E 19
     exit(EINVAL);
    }
 /* Phase II: Nicht zugeordnete Programm absuchen */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skPARALLEL )
   if ( cur->info.lfor )
    {
     /* VERIFY beachten */
D 19
     if ( verify ) fprintf(stderr,"PROGRAM #%d max=%d\n",cur->num,cur->max);
E 19
I 19
     if ( verify ) printf("PROGRAM #%d max=%d\n",cur->num,cur->max);
E 19
     /* Eventuell ausgeben */
     for ( j = 0 ; (j < cur->info.lfor) && (index1(cur->info.vfor[j].index) != -1) ; j++ )
      {
       /* Ausgabekanaele zaehlen */
D 12
       if ( !index2(cur->info.vfor[j].index) ) cur->outc++;
E 12
I 12
       if ( isinput(cur->info.vfor+j) ) cur->outc++;
E 12
       /* VERIFY beachten */
       if ( verify )
        {
D 19
         fprintf(stderr,"\tFOR%03d ",cur->info.vfor[j].FORunit);
D 12
         fprintf(stderr,index2(cur->info.vfor[j].index) ? "<--" : "-->");
E 12
I 12
         fprintf(stderr,isinput(cur->info.vfor+j) ? "-->" : "<--");
E 12
         fprintf(stderr," CONVERTER #%d\n",unit[index1(cur->info.vfor[j].index)].num);
E 19
I 19
         printf("\tFOR%03d ",cur->info.vfor[j].FORunit);
         printf(isinput(cur->info.vfor+j) ? "-->" : "<--");
         printf(" CONVERTER #%d\n",unit[index1(cur->info.vfor[j].index)].num);
E 19
        }
      } 
     /* VERIFY beachten */
D 12
     if ( verify ) fprintf(stderr,"\n");    
E 12
I 12
D 19
     if ( verify ) fprintf(stderr,"\n");
E 19
I 19
     if ( verify ) puts("");
E 19
E 12
     /* Exakte Zahl der Kanaele vermerken */
     cur->info.lfor = j;
    }
   else
    {
D 19
     fprintf(stderr,"PROGRAM #%d has no I/O channels\n",cur->num);
E 19
I 19
     printf("PROGRAM #%d has no I/O channels\n",cur->num);
E 19
     exit(EINVAL);
D 12
    }     
E 12
I 12
    }  
E 12
}

/*
  Nach Vorgabe eines Spezialkanals zugehoeriges Programm suchen.
*/
static resolve_extra(cv,n)
struct unit *cv;
int n;
{
 struct extra *ech = cv->chan+n;
 struct unit *prog = 0,*cur;
 parchan *np;
 int i,ins;

 /* Nur, wenn es sein muss */
 if ( !ech->name || !ech->max ) return;
 /* Wer suchet, der findet */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skPARALLEL )
   if ( !strcmp(cur->job.name,ech->name) )
    if ( !prog )
     prog = cur;
    else
     {
D 19
      fprintf(stderr,"Name %s used by PROGRAMs #%d and #%d\n",
	             cur->job.name,prog->num,cur->num);
E 19
I 19
      printf("Name %s used by PROGRAMs #%d and #%d\n",cur->job.name,prog->num,cur->num);
E 19
      exit(EINVAL);
     }
 /* War die Suche erfolgreich */
 if ( !prog )
  {
D 19
   fprintf(stderr,"CONVERTER #%d could not find PROGRAM %s\n",cv->num,ech->name);
E 19
I 19
   printf("CONVERTER #%d could not find PROGRAM %s\n",cv->num,ech->name);
E 19
   exit(EINVAL);  
  }
 /* Nachsehen, ob die FORTRAN-Unit noch frei ist */
 for ( i = prog->info.lfor, ins = -1 ; i-- ; )
  if ( index1(prog->info.vfor[i].index) == -1 )
   ins = i;
  else if ( prog->info.vfor[i].FORunit == ech->unit )
   {
D 19
    fprintf(stderr,"FORTRAN unit %d doubly defined for PROGRAM #%d\n",ech->unit,prog->num);
E 19
I 19
    printf("FORTRAN unit %d doubly defined for PROGRAM #%d\n",ech->unit,prog->num);
E 19
    exit(EINVAL);
   }
 /* Weiteren Eintrag erzeugen */
 if ( ins == -1 )
  {
   /* Speicher reservieren */
   GETMEM(np,parchan,prog->info.lfor+10);
   /* Alte Daten kopieren */
   if ( prog->info.lfor )
    {
     memmove(np,prog->info.vfor,prog->info.lfor*sizeof(np[0]));
     free(prog->info.vfor);
    }
   /* Zeiger aktualiseren */
   prog->info.lfor += 10;
   prog->info.vfor = np;
   /* Neuen Bereich initialisieren */
   for ( i = 10 ; i ; ) index1(prog->info.vfor[prog->info.lfor-i--].index) = -1;
   /* Variable setzen */
   ins = prog->info.lfor-10;
  }
 /* Und auffuellen */
 prog->info.vfor[ins].IPaddr = INADDR_ANY;
 prog->info.vfor[ins].IPport = 0;
 prog->info.vfor[ins].FORunit = ech->unit;
 /* Verketten in die eine Richtung */
 index1(prog->info.vfor[ins].index) = cv-unit;
 index2(prog->info.vfor[ins].index) = n;
 /* Sowie in die andere Richtung */
 index1(ech->link) = prog-unit;
 index2(ech->link) = ins;
 /* Zaehler aktualisieren */
 if ( prog->max > ech->max ) prog->max = ech->max;
}

/*
  Starten aller CONVERTER.
*/
static start_converters()
{
 struct unit *cur,*done = 0;
 int i;

 /* Alle Konverter suchen */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skCONVERTER )
   {
    /* Eile mit Weile zur korrekten Synchronistation mit der GEN-Queue */   
    if ( done ) sleep(5);
    /* Starten */
    start_converter(done = cur);
   }
}

/*
  Starten eines CONVERTERs in der angegebenen Queue. Dabei ergibt sich die entsprechende
D 15
  HINT-Liste aus eventuell verwendeten Dateiname (FILENAME=filename).
E 15
I 15
  HINT-Liste aus eventuell verwendeten Dateiname (FILENAMES=filename).
E 15
*/
static start_converter(cv)
struct unit *cv;
{
 char *msg;
 long now;

 /* Hintliste loeschen */
 nhint = ahint = 0;
 hlist = 0;
 /* Eingabedatei in die Liste einfuegen */
 if ( cv->chan[0].name && !cv->chan[0].max ) filehint(cv->chan[0].name);
 /* Ausgabedatei in die Liste einfuegen */
D 12
 if ( cv->chan[1].name && !cv->chan[1].max ) filehint(cv->chan[1].name);
E 12
I 12
 if ( cv->chan[cv->ninp].name && !cv->chan[cv->ninp].max ) filehint(cv->chan[cv->ninp].name);
E 12
 /* An die Jobstruktur anhaengen */
 cv->job.leader = rpcverf;
 cv->job.hosts.hints_len = nhint;
 cv->job.hosts.hints_val = hlist;
 cv->job.nopend = 0;
 /* Eindeutige Kennung erzeugen */
 cv->job.Qinfo.requestID = newconnection();
 /* Job abschicken und Antwort abwarten */
D 19
 fprintf(stderr,"Starting CONVERTER #%d: ",cv->num);
E 19
I 19
 printf("Starting CONVERTER #%d: ",cv->num);
E 19
 msg = *(text *)action(genjobaction_1,&cv->job);
 time(&now);
D 19
 fprintf(stderr,"%s at %s",msg,ctime(&now));
E 19
I 19
 printf("%s at %s",msg,ctime(&now));
E 19
 /* Jobnummer ermitteln */
 if ( (cv->job.Jinfo.requestID = jobnumber(msg)) <= 0 ) PDLshort("could not find job number");
 /* Speicher freigeben */
 free(msg);
}

/*
  Alle Programme erstmalig starten.
*/
static start_programs()
{
 static int cmpoutc();
 struct unit *cur;
 int *list,i,nl;

 /* Muss nicht immer sein */
 if ( !nprog ) return;
 /* Sortieren der Programme nach der Zahl der Ausgabekanaele */
 GETMEM(list,int,nprog);
 for ( cur = unit, i = nl = 0 ; i++ < aunit ; cur++ )
  if ( (cur->child != UCANCEL) && (cur->job.Jinfo.kind == skPARALLEL) )
   list[nl++] = i-1;
 /* Konistenztest */
 if ( nl != nprog ) PDLshort("internal PDL counter mismatch");
 /* Sortieren */
 qsort(list,nl,sizeof(list[0]),cmpoutc);
 /* Starten */
 for ( cur = 0 ; nl-- ; )
  {
   /* Eventuell etwas warten */
   if ( cur ) sleep(5);
   cur = unit+list[nl];
   /* Inkarnationszaehler setzen */
   cur->inc = 0;
   /* Programm starten */
D 10
   start_program(cur,0);
E 10
I 10
   start_program(list[nl],0);
E 10
  }
 /* Speicher freigeben */
 free(list);
} 

/*
  Vergleich zweier ganzer Zahlen.
*/
static cmpoutc(ip1,ip2)
int *ip1,*ip2;
{
 return unit[*ip2].outc-unit[*ip1].outc;
}

/*
  Starten eines Programms. Dazu wird von einem definierten PROGRAM eine Inkarnation
  (Template) erzeugt und gestartet.
*/
D 10
static start_program(par,startIF)
struct unit *par;
int startIF;
E 10
I 10
static start_program(parix,startIF)
int parix,startIF;
E 10
{
 static char ibuf[20];
 int i,jlen,ilen,res = 1;
D 10
 struct unit *new;
E 10
I 10
 struct unit *new,*par;
E 10
 long now;
 char *nn;

 /* Neuen Eintrag erzeugen */
 new = unit+extend_units();
 /* Duplikat erzeugen */
I 10
 par = unit+parix;
E 10
 par->run++;
 /* - Allgemeines */
 new->host = INADDR_ANY;
 new->num = 0;
 new->inc = ++par->inc;
 new->last = LNONE;
 /* - Jobkontrollblock */
 new->job = par->job;
 /* -- Allgemeine Informationen */
 GETSTRING(new->job.Qinfo.queue,par->job.Qinfo.queue);
 GETSTRING(new->job.Qinfo.user,par->job.Qinfo.user);
 GETSTRING(new->job.Qinfo.requeue,par->job.Qinfo.requeue);
 /* -- Name wird aus der Inkarnationsnummer ermittelt */
D 4
 if ( new->max == 1 )
E 4
I 4
 if ( par->max == 1 )
E 4
  *ibuf = '\0';
 else
  sprintf(ibuf,"_%d",new->inc);
 GETMEM(new->job.name,char,strlen(par->job.name)+(ilen = strlen(ibuf))+1);
 strcpy(new->job.name,par->job.name);
 strcat(new->job.name,ibuf);
 /* -- Shell, Dateiname und Printqueue*/
 GETSTRING(new->job.Jinfo.shell,par->job.Jinfo.shell);
 GETSTRING(new->job.Jinfo.script,par->job.Jinfo.script);
 GETSTRING(new->job.Jinfo.print,par->job.Jinfo.print);
 /* -- Parameter */
 if ( i = par->job.Jinfo.param.param_len )
  { 
   /* Zeigerliste */
   GETMEM(new->job.Jinfo.param.param_val,text,i);
   /* Zeiger selbst */
   while ( i-- ) 
    GETSTRING(new->job.Jinfo.param.param_val[i],par->job.Jinfo.param.param_val[i]);
  }
 /* -- Logdatei wird aus der Inkarnationsnummer ermitteln */
 if ( !*par->job.Jinfo.log )
  GETSTRING(new->job.Jinfo.log,"");
 else
  {
   /* Speicher erweitern */
   GETMEM(new->job.Jinfo.log,char,(jlen = strlen(par->job.Jinfo.log))+ilen+1);
   /* Name kopieren */
   strcpy(new->job.Jinfo.log,par->job.Jinfo.log);
   /* Endung suchen */
   for ( nn = new->job.Jinfo.log+jlen ; nn-- > new->job.Jinfo.log ; )
    if ( (*nn == '.') || (*nn == '/') || (*nn == ':') || (*nn == ']') )
     break;
   /* Name modifizieren */
   if ( (nn < new->job.Jinfo.log) || (*nn != '.') )
    strcat(new->job.Jinfo.log,ibuf);
   else
    {
     strcpy(nn,ibuf);
     strcat(new->job.Jinfo.log,par->job.Jinfo.log+(nn-new->job.Jinfo.log));
    }
  }
 /* - Extrakanaele */
 if ( i = (new->nchan = par->nchan) )
  {
   /* Speicher allokatieren */
   GETMEM(new->chan,struct extra,new->nchan);
   while ( i-- )
    {
     /* Eventuell Speicher fuer den Namen */
     new->chan[i] = par->chan[i];
     if ( par->chan[i].name ) GETSTRING(new->chan[i].name,par->chan[i].name);
    }
  }
 else
  new->chan = 0;
 /* - Kanalinformationen */
 new->info = par->info;
 GETMEM(new->info.vfor,parchan,new->info.lfor);
 memmove(new->info.vfor,par->info.vfor,new->info.lfor*sizeof(new->info.vfor[0]));
 /* Verketten */
 new->child = par->child;
 par->child = new-unit;
 /* Hintliste ermitteln */
 ahint = nhint = 0;
 hlist = 0;
 /* Primaerer Kanal */
 if ( new->nchan ) filehint(new->chan->name);
 addhint(IPnone);
 /* Eingabekanaele */
 for ( i = 0 ; i < new->info.lfor ; i++ )
D 12
  if ( index2(new->info.vfor[i].index) )
E 12
I 12
  if ( !isinput(new->info.vfor+i) )
E 12
   addhint(new->info.vfor[i].IPaddr);
 addhint(IPnone);
 /* Ausgabekanaele */
 for ( i = 0 ; i < new->info.lfor ; i++ )
D 12
  if ( !index2(new->info.vfor[i].index) )
E 12
I 12
  if ( isinput(new->info.vfor+i) )
E 12
   addhint(new->info.vfor[i].IPaddr);
 /* Initialisierung beenden */
 new->job.leader = rpcverf;
 new->job.hosts.hints_len = nhint;
 new->job.hosts.hints_val = hlist;
 new->job.nopend = startIF;
 /* Eindeutige Kennung erzeugen */
 new->job.Qinfo.requestID = newconnection();
 /* Job abschicken und Antwort abwarten */
D 8
 fprintf(stderr,"Starting PROGARM #%d incarnation #%d: ",par->num,new->inc);
E 8
I 8
D 19
 fprintf(stderr,"Starting PROGRAM #%d incarnation #%d: ",par->num,new->inc);
E 19
I 19
 printf("Starting PROGRAM #%d incarnation #%d: ",par->num,new->inc);
E 19
E 8
 nn = *(text *)action(genjobaction_1,&new->job);
 time(&now);
D 19
 fprintf(stderr,"%s at %s",nn,ctime(&now));
E 19
I 19
 printf("%s at %s",nn,ctime(&now));
E 19
 /* Jobnummer ermitteln */
 if ( startIF && !memcmp(nn,"Job not started",15) )
  {
   /* Aus der Verwaltung entfernen */
   par->child = new->child;
   par->inc--;
   par->run--;
   /* Aufraeumen */
   delete_unit(new);
   /* Misserfolg melden */
   res = 0;
  }
 else if ( (new->job.Jinfo.requestID = jobnumber(nn)) <= 0 ) 
  PDLshort("could not find job number");
 else
  par->last = LCREATE;
 /* Speicher freigeben */
 free(nn);
 /* Ergebnis melden */
 return res;
}

/*
  Dateihinweis in die HINT-Liste einfuegen. Dazu wird festgestellt, zu welchem
  Knoten die Datei lokal ist und dessen IP-Adresse in die Liste eingetragen.
*/
static filehint(name)
char *name;
{
 long ip;

 /* Adresse ermitteln */
 if ( strcmp(name,NULLDEVICE) && ((ip = getfilehost(name)) != -1) ) addhint(ip);
}

/*
  Liste der HINTs erweitern.
*/
static addhint(item)
long item;
{
 long *hbuf;

 /* Platz schaffen */
 if ( nhint == ahint )
  {
   /* Speicher reservieren */
   GETMEM(hbuf,long,ahint+10);
   /* Kopieren */
   if ( ahint )
    {
     memmove(hbuf,hlist,ahint*sizeof(hbuf[0]));
     free(hlist);
    }
   /* Variablen aktualisieren */
   ahint += 10;
   hlist = hbuf;
  }
 /* Eintragen */
 hlist[nhint++] = item;
}

/*
  Jobnummer aus einem GEN-Queue Antwortstring dekodieren:
  	Job %d ...
*/
static jobnumber(str)
char *str;
{ 
 char *scan = "Job ";
 int res;

 /* Prefix */
 while ( *scan )
  if ( *str++ != *scan++ )
   return -1;
 /* Zahl */
 for ( scan = str ; (*scan >= '0') && (*scan <= '9') ; scan++ );
 if ( *scan != ' ' ) return -1;
 *scan = '\0';
 /* Und nun die Zahl */
 return (parval(&res,str) ? res : -1);
}

/*
  Informationen ueber die Subprozesse eines Paralleljobs bei der GEN-Queue erfragen
*/
static update(cans,cupd,pans,pupd)
int *cans,*cupd,*pans,*pupd;
{
 struct unit *cur;
 parctrls *info;
 parctrl *cinfo;
 long now;
 int i;

 /* Uhrzeit ausgeben */
 if ( verify )
  {
   time(&now);
D 19
   fprintf(stderr,"Update cycle at %s",ctime(&now));
E 19
I 19
   printf("Update cycle at %s",ctime(&now));
E 19
  }
 /* Initialisieren */
 *cans = *pans = *cupd = *pupd = 0;
 /* Informationen holen */
 info = (parctrls *)action(genparallelinfo_1,&rpcverf);
 /* Alle Eintraege durchgehen */ 
 for ( cur = unit, i = 0 ; i++ < aunit ; cur++ )
  if ( cur->child > UFREE )
   if ( cur->job.Jinfo.kind == skCONVERTER )
    if ( cinfo = findID(cur->job.Jinfo.requestID,info) ) 
     {
      (*cans)++;
      if ( update_unit(cur,cinfo,0,cur) ) (*cupd)++;
     }
    else
     {
I 19
      /* CPU Zeit ermitteln */
      cur->cpu = findCPU(cur->job.Jinfo.requestID,info);
E 19
      /* Gibt es nicht mehr */
D 19
      fprintf(stderr,"CONVERTER #%d terminated\n",cur->num);
E 19
I 19
D 20
      printf("CONVERTER #%d terminated (%.2f CPU secs)\n",cur->num,cur->cpu);
E 20
I 20
      printf("CONVERTER #%d terminated (CPU time %.2fs)\n",cur->num,cur->cpu);
E 20
E 19
      /* Speicher freigeben */
      delete_unit(cur);
     }
   else if ( cur->num )
    update_programs(cur,info,pans,pupd);
 /* Speicher freigeben */
 xdr_free(xdr_parctrls,info);
}

/*
  CONVERTER/PROGRAM Informationen uebernehmen
*/
static update_unit(cv,ci,prog,par)
struct unit *cv,*par;
parctrl *ci;
int prog;
{
 static char *what[2] = { "CONVERTER", "PROGRAM" };
 converterchan *cc;
 parchan *pc;
 long addr;
 int i,j;

 /* Knoten ueberpruefen */
 if ( ci->IPaddr != IPnone )
  if ( cv->host == INADDR_ANY )
   {
    addr = htonl(cv->host = ci->IPaddr);
    /* VERIFY beachten */
    if ( verify )
     {
D 19
      fprintf(stderr,"%s #%d ",what[prog],par->num);
      if ( prog ) fprintf(stderr,"incarnation #%d ",cv->inc);
      fprintf(stderr,"started on IP %s\n",INET_NTOA(addr));
E 19
I 19
      printf("%s #%d ",what[prog],par->num);
      if ( prog ) printf("incarnation #%d ",cv->inc);
      printf("started on IP %s\n",INET_NTOA(addr));
E 19
     }
   }
  else if ( cv->host != ci->IPaddr )
   PDLerror(what[prog]," transfered from one host to another","");
 /* Informationen anzeigen */
 if ( debug )
  {
   /* Art des Teiljobs */
D 19
   fprintf(stderr,"%s #%d ",what[prog],par->num);
   if ( prog ) fprintf(stderr,"incarnation #%d ",cv->inc);
   fprintf(stderr,"informations:\n");
E 19
I 19
   printf("%s #%d ",what[prog],par->num);
   if ( prog ) printf("incarnation #%d ",cv->inc);
   puts("informations:");
E 19
   /* Informationen ausgeben */
   if ( ci->channels.kind == skCONVERTER )
    {
     for ( i = 0 ; i < 2 ; i++ )
      {
       /* Art der Information */
D 19
       fprintf(stderr,"\t%s channel statistics:\n",i ? "New" : "Old");
E 19
I 19
       printf("\t%s channel statistics:\n",i ? "New" : "Old");
E 19
       /* Kanaele */
       for ( j = 0 ; j < ci->channels.lcon(i) ; j++ )
	{
	 /* Aktueller Kanal */
	 cc = ci->channels.vcon(i)+j;
	 /* Ausgeben */
D 19
	 fprintf(stderr,"\t %08x,%5d%20.0f%20.0f%20.2f\n",
		        cc->IPaddr,cc->IPport,cc->events,cc->bytes,cc->idleT);
E 19
I 19
	 printf("\t %08x,%5d%20.0f%20.0f%20.2f\n",
		cc->IPaddr,cc->IPport,cc->events,cc->bytes,cc->idleT);
E 19
	}
      }
    }
   else if ( ci->channels.kind == skPARALLEL )
    {
     /* Art der Information */
D 19
     fprintf(stderr,"\tParallelchannel information:\n");
E 19
I 19
     puts("\tParallelchannel information:");
E 19
     /* Kanaele */
     for ( j = 0 ; j < ci->channels.lfor ; j++ )
      {
       /* Aktueller Kanal */
       pc = ci->channels.vfor+j;
       /* Ausgeben */
D 19
       fprintf(stderr,"\t %08x,%5d FOR%03d\n",pc->IPaddr,pc->IPport,pc->FORunit);
E 19
I 19
       printf("\t %08x,%5d FOR%03d\n",pc->IPaddr,pc->IPport,pc->FORunit);
E 19
      }
    }
  }
 /* Gibt es ueberhaupt Informationen */
 if ( ci->channels.kind == (prog ? skCONVERTER : skPARALLEL) ) 
  PDLerror(what[prog]," has changed to ",what[1-prog]);
 if ( ci->channels.kind == skNORMAL ) return 0;
 /* Informationen uebernehmen */
 xdr_free(xdr_anychan,&cv->info);
 cv->info = ci->channels;
 /* Struktur zerstoeren */
 ci->job = 0;
 ci->channels.kind = skNORMAL;
 /* Melden, ob Informationen jetzt vorhanden */
 if ( !prog ) return cv->info.lcon(1);
 /* Anzahl der Eintraege verifizieren */
 if ( ci->channels.lfor != par->info.lfor ) PDLshort("PROGRAM has incompatible informations");
 /* Indexfelder korrekt zuordnen */
 for ( i = cv->info.lfor ; i-- ; )
  {
   /* Adresse festhalten */
   pc = cv->info.vfor+i;
   /* Partner suchen */
D 12
   for ( j = par->info.lfor ; j-- && (pc->FORunit != par->info.vfor[j].FORunit) ; )
E 12
I 12
   for ( j = par->info.lfor ; j-- && (pc->FORunit != par->info.vfor[j].FORunit) ; );
E 12
   /* Fehler melden */
   if ( j < 0 ) PDLshort("PROGRAM information does not met declaration");
   /* Indexfeld uebertragen */
   pc->index = par->info.vfor[j].index;
  }
 /* Ergebnis melden */ 
 return cv->info.lfor;
}

/*
  Programinformationen uebernehmen. Zuerst einmal in einer Schleife alle
  zu einem Prototyp gestarteten echten Programme durchgehen.
*/
static update_programs(cv,pc,pans,pupd)
struct unit *cv;
parctrls *pc;
int *pans,*pupd;
{
 struct unit *prev,*cur;
 parctrl *cinfo;
 int i;

 /* Alle Eintraege durchgehen */ 
 for ( prev = cv ; (i = prev->child) >= 0 ; )
  {
   /* Adresse ermitteln */
   cur = unit+i;
   /* Informationen suchen */
   if ( cinfo = findID(cur->job.Jinfo.requestID,pc) ) 
    {
     (*pans)++;
     if ( update_unit(prev = cur,cinfo,1,cv) ) (*pupd)++;
    }
   else
    {
I 19
     /* Zugehoerige CPU-Zeit suchen */
     cv->cpu += (cur->cpu = findCPU(cur->job.Jinfo.requestID,pc));
E 19
     /* Gibt es nicht mehr */
D 19
     fprintf(stderr,"PROGRAM #%d incarnation #%d terminated\n",cv->num,cur->inc);
E 19
I 19
D 20
     printf("PROGRAM #%d incarnation #%d terminated (%.2f CPU secs)\n",cv->num,cur->inc,cur->cpu);
E 20
I 20
     printf("PROGRAM #%d incarnation #%d terminated (CPU time %.2fs)\n",cv->num,cur->inc,cur->cpu);
E 20
E 19
     /* Inkarnationszaehler aktualisieren */
     cv->run--;
I 7
D 16
     if ( cur->last == LDELETE ) cv->delp--;
E 16
I 16
     if ( cv->delp > 0 ) cv->delp--;
E 16
E 7
     /* Speicher freigeben */
     prev->child = cur->child;
     delete_unit(cur);
    }
  }
}

/*
  Speicher fuer eine Verwaltungseinheit freigeben 
*/
static delete_unit(cv)
struct unit *cv;
{
D 19
 int i;

 /* Speicherteile freigeben */
 xdr_free(xdr_submit,&cv->job);
 xdr_free(xdr_anychan,&cv->info);
D 12
 if ( i = cv->nchan )
  {
   while ( i-- )
    if ( cv->chan[i].name )
     free(cv->chan[i].name);
   free(cv->chan);
  }
E 12
I 12
 cfree(cv);

E 12
 /* Als frei markieren */
 cv->child = (cv->job.Jinfo.kind == skCONVERTER) ? UCANCEL : UFREE;
E 19
I 19
 /* Konverter bleiben erhalten */
 if (cv->job.Jinfo.kind == skCONVERTER) 
  cv->child = UCANCEL;
 else
  {
   /* Speicherteile freigeben */
   xdr_free(xdr_submit,&cv->job);
   xdr_free(xdr_anychan,&cv->info);
   cfree(cv);
   /* Als frei markieren */
   cv->child = UFREE;
  }
E 19
}

/*
I 12
  Liste von Spezialkanaelen freigeben.
*/
static cfree(un)
struct unit *un;
{
 int i;

 /* Nur wenn eine Liste vorhanden ist */
 if ( !(i = un->nchan) ) return;

 /* Liste durchgehen und Namen freigeben */
 while ( i-- )
  if ( un->chan[i].name )
   free(un->chan[i].name);

 /* Liste selbst freigebe */
 free(un->chan);
}

/*
E 12
  Job suchen
*/
static parctrl *findID(job,list)
ID job;
parctrls *list;
{
 int i;

 /* Suchen */
 for ( i = list->parctrls_len ; i-- ; )
  if ( list->parctrls_val[i].job == job )
   return (list->parctrls_val+i);
 /* Nichts gefunden */
 return 0;
}

/*
I 19
  CPU-Zeit zu einem Job suchen
*/
static double findCPU(job,list)
ID job;
parctrls *list;
{
 int i,j;

 /* Suchen */
 for ( i = list->parctrls_len ; i-- ; )
  if ( !list->parctrls_val[i].job )
   {
    /* Liste ermitteln */
    if ( list->parctrls_val[i].channels.kind == skPARALLEL )
     /* Liste durchgehen */
     for ( j = list->parctrls_val[i].channels.lfor ; j-- ; )
      /* Prozess suchen */
      if ( list->parctrls_val[i].channels.vfor[j].PARchild == job )
       return (list->parctrls_val[i].channels.vfor[j].PARsecs+
	       list->parctrls_val[i].channels.vfor[j].PARusecs*1E-6);
    /* Nicht gefunden */
    return 0.0;
   }
 /* Nichts gefunden */
 return 0.0;
}

/*
E 19
  Zuordnen der Parallelkanaele zu tatsachlichen TCP/IP Kanaelen
*/
static resolve_converter()
{
 struct unit *cur;
 int i;
 
 /* Alle CONVERTER durchgehen und Kanaele zuordnen */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skCONVERTER )
D 12
   resolve_verify(cur->chan+1,&cur->info,resolve_verify(cur->chan+0,&cur->info,0));
E 12
I 12
   resolve_verify(cur->chan+cur->ninp,cur->nout,&cur->info,
		  resolve_verify(cur->chan+0,cur->ninp,&cur->info,0));
E 12
 /* Alle Programme durchgehen und den ersten Parameter erstellen */
 for ( cur = unit, i = 0 ; (i++ < aunit) && (cur->child != UFREE) ; cur++ )
  if ( cur->job.Jinfo.kind == skPARALLEL )
   resolve_make(cur);
}

/*
  Kanalseite ueberpruefen und Programmkanaele zuordnen.
*/
D 12
static resolve_verify(ech,ci,ix)
E 12
I 12
static resolve_verify(ech,nch,ci,ix)
E 12
struct extra *ech;
I 12
int nch,ix;
E 12
anychan *ci;
D 12
int ix;
E 12
{
 converterchan *cc;
 parchan *pc;

 /* Informationen muessen da sein */
 if ( ci->kind != skCONVERTER ) PDLshort("CONVERTER information not found");
 /* Es muessen genug Informationen da sein */
 if ( ix >= ci->lcon(1) ) PDLshort("CONVERTER information incomplete");
 /* Eintrag ermitteln */
 cc = ci->vcon(1)+ix;
 ix += 1+cc->IPchans;
 /* Offener Kanal */
 if ( !ech->name )
  {
   if ( cc->IPaddr != IPnone ) PDLshort("CONVERTER unused channel type mismatch");
  }
 /* Datei */
 else if ( !ech->max )
  {
   if ( cc->IPaddr != IPfile ) PDLshort("CONVERTER file channel type mismatch");
  }
 /* TCP/IP Kanal */
 else
  {
D 12
   /* Konistenztest */
   if ( cc->IPmax != ech->max ) PDLshort("CONVERTER TCP/IP channel type mismatch");
   /* Adresse uebernehmen und an das jeweilige Programm weitergeben */
   pc = unit[index1(ech->link)].info.vfor+index2(ech->link);
   pc->IPaddr = cc->IPaddr;
   pc->IPport = cc->IPport;
E 12
I 12
   if ( (cc->IPaddr == IPnone) || (cc->IPaddr == IPfile) )
    PDLshort("CONVERTER parallel channel type mismatch");
   /* Adresse uebernehmen und an die jeweiligen Programme weitergeben */
   for ( ; nch-- ; ech++ )
    {
     pc = unit[index1(ech->link)].info.vfor+index2(ech->link);
     pc->IPaddr = cc->IPaddr;
     pc->IPport = cc->IPport;
    }
E 12
  }
 /* Fertig */ 
 return ix;
}

/*
  Erstellen der <IP,port,unit>-Liste fuer die Parallelprogramme.
*/
static resolve_make(cp)
struct unit *cp;
{
 static char buf[30];
 int atmp = 0,ntmp = 0,nlen,na,ilen,plen,i;
 char *tmp = 0,*ibuf,*nt;
 parchan *cur;
 long addr;

 /* Alle Kanaele durchgehen */
 for ( cur = cp->info.vfor, i = 0 ; i++ < cp->info.lfor ; cur++ )
  {
   /* Teile des Strings ermitteln */
   addr = htonl(cur->IPaddr);
   getmem(ibuf = INET_NTOA(addr));
   sprintf(buf,",%d,%d",cur->IPport,cur->FORunit);
   /* Laenge feststellen */
   nlen = 1+(ilen = strlen(ibuf))+(plen = strlen(buf))+1;
   /* Platz schaffen */
   if ( (ntmp+nlen) > atmp )
    {
     /* Speicher allokatieren */
     na = ntmp+nlen+1000;
     GETMEM(nt,char,na);
     /* Eventuell kopieren */
     if ( atmp )
      {
       memmove(nt,tmp,ntmp);
       free(tmp);
      }
     /* Variablen aktualisieren */
     atmp = na;
     tmp = nt;
    }
   /* String vervollstaendigen */
   if ( ntmp ) tmp[ntmp++] = ':';
   strcpy(tmp+ntmp,ibuf);
   strcpy(tmp+(ntmp += ilen),buf);
   ntmp += plen;
  }  
 /* String uebernehmen */
 cp->job.Jinfo.param.param_val[0] = tmp;
}

/*******************************************************************************
*									       *
* Parallelteiljobs ueberwachen						       *
*									       *
*******************************************************************************/

/*
  Fuer alle Programme wird ueberprueft, ob ein Start einer neuen Inkarnation
  moeglich und sinnvoll ist. Dabei werden folgende Kriterien angewendet:
  1. Im letzten Durchgang wurde keine Inkarnation des Programms eleminiert
  2. Das Programm darf prinzipiell noch einmal gestartet werden
  3. Die Kanalauslastung aller Kanaele aller Inkarnationen ist groesser als
     1.0-TOSTART
  Danach werden die Kandidaten nach Eignung sortiert, wobei in der folgenden
  Prioritaet zwei Parameter eine Rolle spielen:
  1. Programme, die im letzten Durchgang nicht gestartet wurden, werden bevorzugt
  2. Die minimale Kanalauslastung aller Kanaele aller Inkarnationen wird maximiert
*/
static parallel_create()
{
 struct unit *cur,*cld;
 double ratio;
 int i,j,n;

 /* Alle Programme durchgehen */
 for ( cur = unit, i = nopt = 0 ;  i++ < aunit; cur++ )  
  /* - Nicht Starten, wenn alle Inkarnationen beendet sind oder wenn die Zahl der */
  /*   aktiven Inkarnationen bereits maximal ist oder zuletzt eine Inkarnation    */
  /*   eleminiert wurde							   	  */
  if ( (cur->child > UFREE) && (cur->job.Jinfo.kind == skPARALLEL) && cur->num &&
D 7
       cur->run && (cur->run < cur->max) && (cur->last != LDELETE) )
E 7
I 7
       (cur->run > cur->delp) && (cur->run < cur->max) && (cur->last != LDELETE) )
E 7
   {
    /* - Kanalauslastung aller Inkarnationen ueberpruefen und Optimierungswert ermitteln */
    cur->opt = 0.0;
    /* - Alle Inkarnationen durchgehen */
    for ( cld = cur, ratio = -1.0 ; cld->child != -1 ; )
     {
      /* -- Struktur ermitteln */
      cld = unit+cld->child;
I 17
      /* -- Falls schon geloescht, naechstes Kind */
      if ( cld->last == LDELETE ) continue;
E 17
      /* -- Alle Kanaele untersuchen */
      for ( j = cld->info.lfor ; j-- ; )
       if ( (ratio = getratio(cld->info.vfor+j)) < 0.0 )
        break;
       else if ( ratio > cur->opt )
        cur->opt = ratio;
      /* -- Eventuell aufhoeren */
D 19
      if ( (ratio < 0.0) || (ratio > TOSTART) ) break;
E 19
I 19
      if ( (ratio < 0.0) || (ratio > tostart) ) break;
E 19
     }
    /* - Programm bei Bedarf eintragen */
D 19
    if ( (ratio >= 0.0) && (ratio <= TOSTART) ) 
E 19
I 19
    if ( (ratio >= 0.0) && (ratio <= tostart) ) 
E 19
     {
      /* -- Korrekten Optimierungsparameter ermitteln */
      if ( cur->last == LCREATE ) cur->opt += 2.0;
      /* -- In die Optimierungsliste eintragen */
      addopt(cur-unit);
      if ( debug ) 
D 19
       fprintf(stderr,"Added PROGRAM #%d for creation, value = %f\n",cur->num,cur->opt);
E 19
I 19
       printf("Added PROGRAM #%d for creation, value = %f\n",cur->num,cur->opt);
E 19
     }
   }
 /* Aufhoeren, falls nichts gefunden */
 if ( !nopt ) return 0;
 /* Optimieren */
 sortopt();
 /* Programme starten, geeignetste zuerst */
 for ( i = 0 ; i < nopt ; i++ )
  {
   /* - Eventuell dem Queuemanager etwas Zeit geben */
   if ( i ) sleep(5);
   /* - Programm starten */
D 10
   if ( !start_program(unit+opt[i],1) )
E 10
I 10
   if ( !start_program(opt[i],1) )
E 10
    {
     /* -- Aufraeumen fuer das naechste Mal */
     if ( i )
      for ( cur = unit, n = 0 ; n < aunit ; n++, cur++ )
       if ( (cur->child > UFREE) && (cur->job.Jinfo.kind == skPARALLEL) && cur->num )
        {
	 /* --- Testen, ob bereits bearbeitet */
	 for ( j = 0 ; (j < i) && (opt[j] != n) ; j++ );
	 /* --- Austragen */
	 if ( j >= i ) cur->last = LNONE;
        }
     /* -- Aufhoeren */
     break;
    }
  }
 /* Das hat geklappt */
 return i;
}

/*
  Kanalauslastung ermitteln. Der uebergebene Wert ist in der Tat die relative Zeit,
  in der der Kanal nicht benutzt wurde.
*/
static double getratio(pc)
parchan *pc;
{
 double ot,nt,oi,ni;
 struct unit *cv;

 /* Zugehoerigen Konverter suchen */
 if ( (cv = unit+index1(pc->index))->child == UCANCEL ) return -1.0;
 /* Zugehoerige Statistik suchen */
 if ( !findstat(&ot,&oi,&cv->info,0,pc) || !findstat(&nt,&ni,&cv->info,1,pc) ) return -1.0;
 /* Verhaeltnis berechnen */
 if ( (nt -= ot) < 0.01 ) return -1.0;
 return ((ni-oi)/nt);
}

/*
  Suchen einer Kanalstatistik im Statistikblock eines Konverters.
*/
static findstat(total,idle,ci,ix,pc)
double *total,*idle;
anychan *ci;
int ix;
parchan *pc;
{
 converterchan *cc;
 int pos = 0,n;

 /* Nachsehen, ob Informationen generell vorhanden sind */
 if ( ci->kind != skCONVERTER ) return 0;
 /* Header suchen */
D 12
 if ( index2(pc->index) )
E 12
I 12
 if ( !isinput(pc) )
E 12
  {
   /* - Ist ueberhaupt etwas da ? */
   if ( pos >= ci->lcon(ix) ) return 0;
   /* - Ueberspringen */
   pos += 1+ci->vcon(ix)[pos].IPchans;
  }
 /* Datenkopf verifizieren */
 if ( pos >= ci->lcon(ix) ) return 0;
 cc = ci->vcon(ix)+pos;
 /* Absolute Zeit festhalten */
 *total = cc->totalT;
 /* Kanal des Programms suchen */
 for ( n = cc->IPchans ; (n-- > 0) && (++pos < ci->lcon(ix)) ; )
  {
   /* - Vergleichen */
   if ( ((++cc)->IPaddr == pc->IPaddr) && (cc->IPport == pc->IPport) )
    {
     /* - Zeit festhalten */
     *idle = cc->idleT;
     /* - Erfolg melden */
     return 1;
    }
  }
 /* Nicht gefunden */
 return 0;
}

/*
  Programmindex in die Optimierungsliste eintragen.
*/
static addopt(ix)
int ix;
{
 int *no;

 /* Feldelement freimachen */
 if ( nopt == aopt )
  {
   /* Speicher reservieren */
   GETMEM(no,int,aopt+10);
   /* Alte Daten kopieren */
   if ( aopt )
    {
     memmove(no,opt,aopt*sizeof(no[0]));
     free(opt);
    }
   /* Parameter festhalten */
   aopt += 10;
   opt = no;
  }
 /* Eintragen */
 opt[nopt++] = ix;
}

/*
  Optimierungsliste sortieren.
*/
static sortopt()
{
 static int cmpopt();

 /* Sortieren */
 qsort(opt,nopt,sizeof(opt[0]),cmpopt);
}

/*
  Vergleich zweier Zahlen.
*/
static cmpopt(i1,i2)
int *i1,*i2;
{
 return (unit[*i1].opt-unit[*i2].opt);
}

/*
  Fuer alle laufenden Inkarnationen wird ueberprueft, ob sie nicht eigentlich
  uneffizient arbeiten und damit ueberfluessig sind. Die Kriterien sind:
  1. Im letzten Durchgang wurde keine Inkarnation des gleichen Programms gestartet
  2. Das Programm laeuft mehr als einmal
  3. Es wurde bisher noch nicht versucht, diese spezielle Inkarnation zu loeschen
  4. Mindestens auf einem Kanal der Inkarnation ist die Auslastung kleiner als
     1.0-TOSTOP
  Pro Durchgang wird maximal eine Inkarnation gestoppt. Die Eignung wird nach 
  folgenden Parametern festgestellt.
  1. Inkarnationen von Programmen, die im letzten Durchgang keine eleminierten
     Inkarnationen haben, werden bevorzugt
  2. Die minimale Kanalauslastung aller Kanaele der Inkarnation wird maximiert.
*/
static parallel_kill()
{
 struct unit *cur,*cld,*opt = 0,*popt;
 int i,j,n,err;
 submit killit;
 double ratio;
 parchan *pc;
 char *msg;
 long now;

 /* Alle Programme durchgehen */
D 17
 for ( cur = unit, i = 0 ;  i++ < aunit; (cur++)->last = LNONE )  
E 17
I 17
 for ( cur = unit, i = 0 ; i++ < aunit; cur++ )  
E 17
  /* - Nicht Loeschen, wenn nur noch eine Inkarnation laeuft oder zuletzt eine */
  /*   Inkarnation gestartet wurde					       */
D 17
  if ( (cur->child > UFREE) && (cur->job.Jinfo.kind == skPARALLEL) && cur->num &&
D 7
       (cur->run > 1) && (cur->last != LCREATE) )
E 7
I 7
       ((cur->run-cur->delp) > 1) && (cur->last != LCREATE) )
E 17
I 17
  if ( (cur->child > UFREE) && (cur->job.Jinfo.kind == skPARALLEL) && cur->num )
E 17
E 7
   {
D 17
    /* - Kanalauslastung aller Inkarnationen ueberpruefen und optimale Inkarnation */
    for ( cld = cur ; cld->child != -1 ; )
E 17
I 17
    if ( ((cur->run-cur->delp) > 1) && (cur->last != LCREATE) )
E 17
     {
D 17
      /* -- Struktur ermitteln */
      cld = unit+cld->child;
      /* -- Inkarnation muss normal laufen */
      if ( cld->last == LDELETE ) continue;
      /* -- Alle Kanaele untersuchen */
      for ( j = cld->info.lfor, cld->opt = ratio = -1.0 ; j-- ; )
       if ( (ratio = getratio(cld->info.vfor+j)) < 0.0 )
        break;
       else if ( ratio > cld->opt )
        cld->opt = ratio;
      /* -- Bei Fehlern oder unterhalb der kritischen Rate einfach weitermachen */
      if ( (ratio < 0.0) || (cld->opt < TOSTOP) ) continue;
      /* -- Korrektur nach dem letzten Druchgang */
      if ( cur->last == LNONE ) cld->opt += 2.0;
      /* --- Information anzeigen */
      if ( debug ) 
       fprintf(stderr,"PROGRAM #%d incarnation #%d has kill ratio = %f\n",
		      cur->num,cld->inc,cld->opt);
      /* -- Optimimale Inkarnationen vermerken */
      if ( !opt || (cld->opt > opt->opt) )
E 17
I 17
      /* - Kanalauslastung aller Inkarnationen ueberpruefen und optimale Inkarnation */
      for ( cld = cur ; cld->child != -1 ; )
E 17
       {
D 17
	/* --- Inkarnation merken */
	popt = cur;
	opt = cld;
E 17
I 17
	/* -- Struktur ermitteln */
	cld = unit+cld->child;
	/* -- Inkarnation muss normal laufen */
	if ( cld->last == LDELETE ) continue;
	/* -- Alle Kanaele untersuchen */
	for ( j = cld->info.lfor, cld->opt = ratio = -1.0 ; j-- ; )
	 if ( (ratio = getratio(cld->info.vfor+j)) < 0.0 )
	  break;
	 else if ( ratio > cld->opt )
	  cld->opt = ratio;
	/* -- Bei Fehlern oder unterhalb der kritischen Rate einfach weitermachen */
D 19
	if ( (ratio < 0.0) || (cld->opt < TOSTOP) ) continue;
E 19
I 19
	if ( (ratio < 0.0) || (cld->opt < tostop) ) continue;
E 19
	/* -- Korrektur nach dem letzten Druchgang */
	if ( cur->last == LNONE ) cld->opt += 2.0;
	/* --- Information anzeigen */
	if ( debug ) 
D 19
	 fprintf(stderr,"PROGRAM #%d incarnation #%d has kill ratio = %f\n",
			cur->num,cld->inc,cld->opt);
E 19
I 19
	 printf("PROGRAM #%d incarnation #%d has kill ratio = %f\n",cur->num,cld->inc,cld->opt);
E 19
	/* -- Optimimale Inkarnationen vermerken */
	if ( !opt || (cld->opt > opt->opt) )
	 {
	  /* --- Inkarnation merken */
	  popt = cur;
	  opt = cld;
	 }
E 17
       }
     }
I 17
    /* Mit diesem Programm wurde nicht gearbeitet */
    cur->last = LNONE;
E 17
   }
 /* Inkarnation loeschen */
 if ( !opt ) return;
 time(&now);
D 19
 fprintf(stderr,"Deleting PROGRAM #%d incarnation #%d at %s",popt->num,opt->inc,ctime(&now));
E 19
I 19
 printf("Deleting PROGRAM #%d incarnation #%d at %s",popt->num,opt->inc,ctime(&now));
E 19
 /* Struktur an den Queuemanager aufsetzen */
 killit.Qinfo.queue = killit.Qinfo.user = killit.Qinfo.requeue = "";
 killit.Qinfo.host = INADDR_ANY;
 killit.name = "";
 killit.restart = killit.hold = killit.at = killit.hosts.hints_len = killit.nopend = 0;
 killit.hosts.hints_val = 0;
 killit.leader = rpcverf;
 killit.Kind = sCONVERTER;
 /* Jeden Eingabekanal der Inkarnation freigeben */
 for ( i = opt->info.lfor ; i-- ; )
  {
   /* - Aktueller Kanal */
   pc = opt->info.vfor+i;
   /* - Muss ein Eingabekanal sein */
D 12
   if ( !index2(pc->index) ) continue;
E 12
I 12
   if ( isinput(pc) ) continue;
E 12
   /* - Struktur vollenden */
   killit.Qinfo.requestID = newconnection();
   killit.info.jkinfo_u.cinfo.requestID = unit[index1(pc->index)].job.Jinfo.requestID;
   killit.info.jkinfo_u.cinfo.IPaddr = pc->IPaddr;
   killit.info.jkinfo_u.cinfo.IPport = pc->IPport;
   /* - Befehl ausfuehren */
   msg = *(text *)action(genjobaction_1,&killit);
D 19
   if ( *msg ) fprintf(stderr,"\tWARNING: %s\n",msg);
E 19
I 19
   if ( *msg ) printf("\tWARNING: %s\n",msg);
E 19
   /* - Speicher freigeben */
   free(msg);
  }
 /* Aktionen vermerken */
 popt->last = opt->last = LDELETE;
I 7
 popt->delp++;
E 7
}


/*******************************************************************************
*									       *
* Schnittstelle zur GEN-Queue						       *
*									       *
*******************************************************************************/

/*
  RPC-Handle erzeugen, falls noch keiner existiert. Das Protokoll mit der GEN-Queue
  wird mit der Standardauthorisierung UNIX gefahren.
*/
static createHandle()
{
 struct sockaddr_in rem;
 int s = RPC_ANYSOCK;

 /* Handle erzeugen */
 if ( gen ) return 1;
 /* TCP/IP Information erzeugen */
 rem.sin_family = AF_INET;
 rem.sin_addr = rpcaddr;
 rem.sin_port = htons(0);
 /* Handle erzeugen */
 if ( !(gen = clnttcp_create(&rem,rpcprog,rpcvers,&s,0,0)) ) return 0;
 /* Handle initialisieren */
 makeauth(gen);
 /* Erfolg melden */
 return 1;
}

/*
  Kennung fuer naechten Befehl ermitteln. Damit wird der GEN-Queue geholfe, Befehle
  eindeutig zu halten und Doppelausfuehrungen zu vermeiden.
*/
static ID newconnection()
{
 /* Eindeutige Kennung ermitteln */
 return *(ID *)action(genuniqueid_1,(void *)0);
}

/*
  RPC-Funktion aufrufen. Der Parallelinterpreter wartet dabei in jedem Fall so lange,
  bis die GEN-Queue sich meldet.
*/
static char *action(func,in)
char *(*func)(),*in;
{
 int slp = 1;
 char *res;
 long now;

 /* Mehrmals versuchen */
 for ( ; ; )
  {
   /* Handle ermitteln */
   if ( createHandle() ) 
    {
     /* Befehl durchfuehren */
     if ( res = (*func)(in,gen) ) return res;
     /* Handle zerstoeren, falls ein Fehler aufgetren ist */
     clnt_destroy(gen);
     gen = 0;
    }
   /* Eventuell mal etwas warten */
   if ( slp = !slp )
    {
     time(&now);
D 19
     fprintf(stderr,"WARNING: sleeping to synchronize with Queuemanager at %s",ctime(&now));
E 19
I 19
     printf("WARNING: sleeping to synchronize with Queuemanager at %s",ctime(&now));
E 19
     sleep(120);
    }
  }
E 2
}
E 1
