/*
  Die Konstanten und Routinen in dieser Datei werden gemeinsam von ../cld/queexec.c und
  ../parallel/parallel.c genutzt.
*/

/*
  Abkuerzungen fuer die RPC-Strukturen.
*/
#define Qinfo		qinfo
#define Kind		info.kind
#define Jinfo		info.jkinfo_u.jinfo
#define Kinfo		info.jkinfo_u.kinfo
#define execReq		request.Jinfo
#define execSig		request.Kinfo
#define genReq		request.qinfo
#define jgen		Jgen.genptr_u.ptr
#define jexec		Jexec.execptr_u.ptr
#define jobID		execReq.requestID

/*
  Hilfsmacros fuer die Nuztung von Speicher.
*/
#define MALLOC(t,n)	((t *)calloc(n,sizeof(t)))
#define SALLOC(t)	MALLOC(t,1)
#define MEMMOVE(d,s,n)	memmove((char *)(d),(char *)(s),(n)*sizeof(*d))

/*
  Externe Routinen.
*/
#define INET_NTOA(i)	inet_ntoa(*(struct in_addr *)&(i))

extern char *translate_vms(),*translate_vms_default(),*inet_ntoa(),*calloc();
extern char *strdup(),*strchr();
extern char *getwd();


/*
  Lokale Routinen.
*/
char *fileToName();

#ifndef NO_SUPPORT_CODE

#ifndef vms
/*
  UNIX-Authorisierungsstruktur fuer UNIX erzeugen. Im Gegensatz zu VAX/VMS sind hier
  alle Defaultwerte korrekt.
*/
static makeauth(gen)
CLIENT *gen;
{
 /* UNIX-Authorisierung fuer den Handle aufsetzen */
 auth_destroy(gen->cl_auth);
 gen->cl_auth = authunix_create_default();
}
#endif

/*
  Logischen Namen von der VAX/VMS- in die UNIX-Konvention umsetzen. Nullstrings fuehren 
  zu Leerstrings. Es werden die Routinen aus der BOSSLIB verwendet, die auch auf der VAX 
  zur Verfuegung stehen.
*/
makelogical(lstr,buf,bsize)
char *lstr,*buf;
int bsize;
{
 /* Nullstring in Leerstring uebersetzen */
 if ( !lstr )
  {
   *buf = '\0';
   /* Erfolg melden */
   return 1;
  }
 /* Logischen Name umwandeln und Misserfolg melden */
 if ( !(lstr = translate_vms(lstr)) || (lstr == (char *)-1) || (strlen(lstr) >= bsize) )
  return 0;
 /* Kopieren und Erfolg melden */
 strcpy(buf,lstr);
 return 1;
}

/*
  Dateiname unter Vorgabe eines VAX/VMS Defaultnamens von VAX/VMS- in UNIX-Konvention 
  umsetzen. Neben den Aktionen, die auch 'makelogical' unternimmt, wird hier noch ein
  Default beruecksichtigt.
*/
makefile(fname,def,res,rlen)
char *fname,*def,*res;
int rlen;
{
 int len1,len2;

 /* Logischen Name unter Beruecksichtigung des Defaults umwandeln und Misserfolg melden */
 if ( !(fname = translate_vms_default(fname,def)) || (fname == (char *)-1) ) return 0;
 /* Unter UNIX Arbeitsdirectory suchen, falls noetig. Auf der VAX ist der Dateiname im */
 /* vorliegenden Stadium komplett.						       */
#ifndef vms
 if ( *fname == '/' )
#endif
  *res = '\0';
#ifndef vms
 /* UNIX-Defaultdirectory suchen und Misserfolg melden */
 else if ( !getwd(res) )
  return 0;
#endif
 /* Laengen ermitteln */
 len1 = strlen(res);
 len2 = strlen(fname);
#ifdef vms
 /* Versionsnummer auf der VAX beruecksichtigen */
 if ( len2 && (fname[len2-1] == ';') ) fname[--len2] = '\0';
#else
 /* Directorytrennzeichen unter UNIX beruecksichtigen */
 if ( len1 && (res[len1-1] != '/') ) res[len1++] = '/';
#endif
 /* Konsistenztest auf die Groesse des Buffers */
 if ( (len1+len2+1) > rlen ) return 0;
 /* Ergebnis zusammenstellen und Erfolg melden */
 strcpy(res+len1,fname);
 return 1;
}

/*
  Programmname aus dem Dateinamen ermitteln.
*/
char *fileToName(file)
char *file;
{
 static char buf[256];
 char *jp0,*jp1;

 /* Ende des Namens */
 jp0 = file+strlen(file);
 /* Anfang suchen */
 while ( (jp0-- > file) && (*jp0 != '/') && (*jp0 != ']') && (*jp0 != ':') );
 /* Ende suchen und in Grossbuchstaben umwandeln */
 for ( jp1 = buf ; *++jp0 && (*jp0 != '.') && (*jp0 != ';') ; )
  if ( (*jp0 >= 'a') && (*jp0 <= 'z') )
   *jp1++ = *jp0+('A'-'a');
  else
   *jp1++ = *jp0;
 *jp1++ = '\0';
 /* Ergebnis melden */
 return strdup(buf);
}

#endif
