h08037
s 00001/00001/00413
d D 5.1 91/08/15 08:59:23 jochen 11 10
c Delay to EXEC reduced to 5 seconds
e
s 00049/00035/00365
d D 4.6 91/06/05 08:54:55 jochen 10 9
c Job allocation algorithm added
e
s 00047/00000/00353
d D 4.5 91/05/28 18:16:00 jochen 9 8
c Prepared for job counter table
e
s 00006/00000/00347
d D 4.4 91/04/29 17:51:23 jochen 8 7
c Linger option added to RPC/TCP channels
e
s 00005/00002/00342
d D 4.3 91/02/26 17:26:17 jochen 7 6
c 'jobon' routine corrected for jobs without a EXEC-link
e
s 00152/00002/00192
d D 4.2 91/02/26 11:36:01 jochen 6 5
c Minor correction for QMan
e
s 00000/00000/00194
d D 4.1 91/02/20 13:26:46 jochen 5 4
c RPC number 390326 now reserved by SUN
e
s 00003/00002/00191
d D 3.3 91/02/20 13:03:12 jochen 4 3
c free_jobctrl extended with freeing statistics
e
s 00004/00002/00189
d D 3.2 91/01/15 15:26:37 jochen 3 2
c usage of SCCSIDS corrected
e
s 00001/00001/00190
d D 3.1 91/01/08 09:54:47 jochen 2 1
c IP address handling modified
e
s 00191/00000/00000
d D 2.1 91/01/02 15:26:56 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 3
I 3
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
I 4
static char sccsid_sgen_util_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
E 3
#endif

#define SGEN_UTIL

#include "sgen_hdr.h"

/*
  Ausgabe einer Information ueber eine EXEC-Queue.
*/
epinfo(what,info)
char *what;
statusinfo *info;
{
D 2
 lprintf("%s BOSSexec at IP %s on %s\n",what,INET_NTOA(info->IPaddr),info->name);
E 2
I 2
D 3
 lprintf("%s BOSSexec at IP %s on %s\n",what,INET_NTOA(htonl(info->IPaddr)),info->name);
E 3
I 3
 long ad = htonl(info->IPaddr);

 lprintf("%s BOSSexec at IP %s on %s\n",what,INET_NTOA(ad),info->name);
E 3
E 2
}
 
/*
  Ausgabe einer Dispatch Information.
*/
dqinfo(gen,lev)
genctrl *gen;
I 6
int lev;
E 6
{
 lprintf("Dispatched on queue %s at level %d.%d\n",gen->name,gen->algo,lev);
}

/*
  Ausgabe einer Job Information.
*/
jpinfo(job,msg,buf)
jobctrl *job;
char *msg,*buf;
{
 sprintf(buf,"Job %d %s on queue %s_%s",
	     job->jobID,msg,job->jgen->name,job->jexec->status.name);
 lprintf("%s\n",buf);
}

/*
  Ausgabe einer Job Information.
*/
char *jobon(job)
jobctrl *job;
{
 static char buf[128];

D 7
 sprintf(buf,"Job %d on queue %s_%s ",job->jobID,job->jgen->name,job->jexec->status.name);
E 7
I 7
 if ( job->jexec )
  sprintf(buf,"Job %d on queue %s_%s ",job->jobID,job->jgen->name,job->jexec->status.name);
 else
  sprintf(buf,"Job %d on queue %s ",job->jobID,job->jgen->name);
E 7
 return buf;
}

/*
  Job nicht gefunden.
*/
notfound(msg,jID,queue)
char *msg,*queue;
ID jID;
{
 if ( *queue )
  sprintf(msg,"Job %d not found in queue %s",jID,queue);
 else
  sprintf(msg,"Job %d not found in any queue",jID);
}

/*
  Eine Zeile in einen Logfile schreiben.
*/
lprintf(va_alist)
va_dcl
{
 static char line[256];
 va_list args;
 char *fmt;
  
 /* Nur falls eine Logdatei angelegt wurde */
D 4
 if ( logf < 0 ) return;
E 4
I 4
 if ( logf == -1 ) return;
E 4
 /* Bearbeitung der variablen Liste starten */
 va_start(args);
 /* Format einlesen */
 fmt = va_arg(args,char *);
 /* Zeichenkette zusammensetzen */
 vsprintf(line,fmt,args);
 /* Bearbeitung der variablen Liste beenden */
 va_end(args);
 /* Datei beschreiben */
 while ( (write(logf,line,strlen(line)) == -1) && (errno == EINTR) );
}

/*
  Authorisierung eines Benutzers ueberpruefen.
*/
authorized(msg,uid)
struct svc_req *msg;
int uid;
{
 struct authunix_parms *au;

 return ((msg->rq_cred.oa_flavor == AUTH_UNIX) &&
         (au = (struct authunix_parms *)msg->rq_clntcred) &&
         (!au->aup_uid || (au->aup_uid == uid) || has_privilege(au->aup_uid,"OPER")));
}

/*
  Jobverwaltungsstruktur an das Ende einer Kette von Jobs anhaengen.
*/
addTail(queue,job)
jobctrl **queue,*job;
{
 /* Ende der Liste ermitteln */
 while ( *queue ) queue = &(*queue)->next;
 /* Element eintragen */
 job->next = 0;
 *queue = job;
 /* Und neue Nummer vergeben */
 job->backID = ++backCnt;
}

/*
  Queuename in ein Paar (GEN-Queue,EXEC-Queue) umsetzen.
*/
findpair(name,genp,exep,msg)
char *name,*msg;
genctrl **genp;
execctrl **exep;
{
 execctrl *escan = 0;
 genctrl *scan;
 char *ename;

 /* Name der Queue ermitteln */
 if ( ename = strchr(name,'_') ) *ename++ = '\0';
 /* GEN-Queue ermitteln */
 for ( scan = Gqueues ; scan && strcmpi(scan->name,name) ; scan = scan->next );
D 6
 /* Name restaurieren */
 if ( ename ) ename[-1] = '_';
E 6
 /* Fehler bearbeiten */
 if ( !scan )
  {
   if ( msg ) sprintf(msg,"No generic queue %s found",name);
I 6
   /* Name restaurieren */
   if ( ename ) ename[-1] = '_';
E 6
   return 0;
  }
I 6
 /* Name restaurieren */
 if ( ename ) ename[-1] = '_';
E 6
 /* Ermitteln der EXEC-Queue, falls noetig */
 if ( ename )
  {
   /* EXEC-Queue in der Liste suchen */
   for ( escan = Equeues ; escan && strcmpi(escan->status.name,ename) ; escan = escan->next );
   if ( !escan )
    {
     if ( msg ) sprintf(msg,"No queue %s found",name);
     return 0;
    }
  }
 /* Ergebnis uebertragen */
 *genp = scan;
 *exep = escan;
 return 1;
}

/*
  Speicherbereich einer Jobverwaltungsstruktur freigeben.
*/
free_jobctrl(jc)
jobctrl *jc;
{
 xdr_free(xdr_submit,&jc->request);
I 4
 xdr_free(xdr_anychan,&jc->channels);
E 4
 free(jc);
}

/*
I 6
  Bearbeiten des SHELL-Namens eines Jobs:
  Phase I
  -------
  	Ist die zugehoerige Genericqueue eine Parallelqueue, so wird deren
	Parallelinterpreter als Shell uebernommen. Ansonsten wird dem Shell-
	namen eine Defaultdirectory vorweggehaengt, falls er nicht absolut
	ist.
  Phase II
  --------
	Der Name der Shell wird in Kleinbuchstaben umgewandelt.
*/
makeshell(sub,gen)
submit *sub;
genctrl *gen;
{
 char *str;

 /* Nachsehen, ob es sich um eine Parallelqueue handelt */
 if ( *gen->pdl )
  str = strdup(gen->pdl);
 else if ( *sub->Jinfo.shell == '/' )
  return 1;
 else if ( str = MALLOC(char,strlen(sub->Jinfo.shell)+sizeof(DEFPATH)) )
  {
   /* Name zusammensetzen */
   strcpy(str,DEFPATH);
   strcpy(str+sizeof(DEFPATH)-1,sub->Jinfo.shell);
  }
 /* Neuen Zeiger verwenden */
 if ( !str ) return 0;
 free(sub->Jinfo.shell);
 sub->Jinfo.shell = str;
 /* Umwandeln in Kleinschreibung */
 strlower(sub->Jinfo.shell);
 /* Fertig */
 return 1;
}

/*
  Bearbeiten des Druckernamens eines Jobs:
  Phase I
  -------
	Der Name des Druckers wird in Kleinbuchstaben umgewandelt.
*/
makeprint(sub,gen)
submit *sub;
genctrl *gen;
{
 /* Umwandeln in Kleinschreibung */
 strlower(sub->Jinfo.print);
 /* Fertig */
 return 1;
}

/*
  Falls der Job ein Paralleljob ist (->leader != 0) wird ein spezieller Parameter
  als neuer nullter Parameter erzeugt.
*/
makeparallel(sub,leader)
submit *sub;
int leader;
{
 static char pbuf[64];
 char *str;
 long addr;
 text *np;

 /* Zeile zusammensetzen */
 addr = htonl(master.addr);
 sprintf(pbuf,"%s,%d,%d,%d",INET_NTOA(addr),GENPROG,GENVERS,leader);
 /* Zeile duplizieren und Feld erweitern */
 if ( !(str = strdup(pbuf)) || !(np = MALLOC(text,sub->Jinfo.param.param_len+1)) )
  {
   /* Speicher freigeben */
   if ( str ) free(str);
   /* Fehler melden */
   return 0;
  }
 /* Umkopieren und vorherigen Speicher freigeben */
 if ( sub->Jinfo.param.param_val )
  {
D 7
   memmove(np+1,sub->Jinfo.param.param_val,sub->Jinfo.param.param_len*sizeof(np[0]));
E 7
I 7
   MEMMOVE(np+1,sub->Jinfo.param.param_val,sub->Jinfo.param.param_len);
E 7
   free(sub->Jinfo.param.param_val);
  }
 /* Neue Werte eintragen */
 sub->Jinfo.param.param_len++;
 (sub->Jinfo.param.param_val = np)[0] = str;
 /* Alles in Ordung */
 return 1;
}

/*
E 6
  Vergleich zweier Strings ohne Ruecksicht auf Gross- und Kleinschreibung.
*/
strcmpi(s1,s2)
unsigned char *s1,*s2;
{
 unsigned char c1,c2;
 int d;

 do
  {
   /* Zeichen ermitteln und umwandeln */
   if ( ((c1 = *s1++) >= 'a') && (c1 <= 'z') ) c1 += 'A'-'a';
   if ( ((c2 = *s2++) >= 'a') && (c2 <= 'z') ) c2 += 'A'-'a';
   /* Vergleichen */
   if ( d = c1-c2 ) return d;
  }
 while ( c1 );
 /* Gleicher geht es nicht */
I 6
 return 0;
}

/*
  String in Kleinshcreibung umwandeln.
*/
strlower(str)
char *str;
{
 char ch;

 /* Alle Zeichen */
 while ( ch = *str++ )
  if ( (ch >= 'A') && (ch <= 'Z') )
   str[-1] += 'a'-'A';
}

/*
  RPC-Handle erzeugen und Befehl ausfuehren.
*/
callHandle(clp,addr,code,inp,in,outp,out)
CLIENT **clp;
long addr;
int code;
xdrproc_t inp,outp;
char *in,*out;
{
D 11
 static struct timeval total = { 20,0 };
E 11
I 11
 static struct timeval total = { 5, 0 };
E 11
 struct sockaddr_in rem;
I 8
 struct linger ling;
E 8
 int sock,i;

 /* Maximal zwei Versuche, je nach Wert des Handles */
 for ( i = *clp ? 2 : 1 ; i-- ; )
  {
   /* RPC-Handle nur einmal erzeugen */
   if ( !*clp )
    {
     /* Adresse des Partners aufsetzen */
     rem.sin_family = AF_INET;
     rem.sin_addr.s_addr = htonl(addr);
     rem.sin_port = htons(0);
     /* Handle erzeugen */
     sock = RPC_ANYSOCK;
     if ( !(*clp = clnttcp_create(&rem,master.EXECprog,master.EXECvers,&sock,0,0)) ) return 0;
I 8
     /* Socket umschalten um bei Rechnerabstuerzen sicher zu sein */
     ling.l_onoff = 1;
     ling.l_linger = 0;
     if ( setsockopt(sock,SOL_SOCKET,SO_LINGER,&ling,sizeof(ling)) == -1 )
      lprintf("Could not set linger for exec server %s\n",inet_ntoa(rem.sin_addr));
E 8
     /* Authorisierungsstruktur aufsetzen */
     auth_destroy((*clp)->cl_auth);
     (*clp)->cl_auth = authunix_create_default();
    }
   /* Befehl ausfuehren */
   if ( clnt_call(*clp,code,inp,in,outp,out,total) == RPC_SUCCESS ) return 1;
   /* Fehler bearbeiten */
   clnt_destroy(*clp);
   *clp = 0;
  }
 /* Fehler melden */
E 6
 return 0;
}
I 9

/*
D 10
  Jobnummer allokatieren und wieder freigeben.
E 10
I 10
  Jobnummer allokatieren.
E 10
*/
D 10
#define MAXJOB		(2*1024)
E 10
I 10
#define MAXJOB		(8*1024)
E 10

D 10
#define JOBINDEX(n)	((n)/32)
#define JOBMASK(n)	(1L<<((n)%32))
#define JOBPTR(n)	alljob[JOBINDEX(n)]
E 10
I 10
allocJob()
{
 /* Suchen und hoffen, dass nicht alle Jobnummern belegt sind */
 do 
  jobCnt = (jobCnt%MAXJOB)+1;
 while ( jobexists(jobCnt) );
 /* Fertig */
 return jobCnt;
}
E 10

D 10
static unsigned long alljob[JOBINDEX(MAXJOB)] = { 0 };
static int lastall = -1;
E 10
I 10
/* 
  Nachsehen, ob bereits ein Job mit der Nummer existiert.
*/
static jobexists(jno)
int jno;
{
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;
E 10

D 10
allocJob(num)
int num;
{ 
 /* Nummer korrigieren */
 if ( (num < 0) || (num >= MAXJOB) ) num = -1;
 /* Erste freie Nummer */
 if ( num == -1 )
E 10
I 10
 /* Alle laufenden und wartenden Jobs */
 for ( gen = Gqueues ; gen ; gen = gen->next )
E 10
  {
D 10
   /* Hinter 'lastall' beginnt die Suche */
   num = lastall;
   /* Einer wird wohl frei sein (hope for the best - forget the rest) */
   do
    {
     if ( ++num == MAXJOB ) num = 0;
    }
   while ( JOBPTR(num)&JOBMASK(num) );
E 10
I 10
   for ( job = gen->Rjobs ; job ; job = job->next )
    if ( hasjobno(job,jno) )
     return 1;
   for ( job = gen->Pjobs ; job ; job = job->next )
    if ( hasjobno(job,jno) )
     return 1;
E 10
  }
D 10
 /* Belegen */
 JOBPTR(num) |= JOBMASK(num);
 /* Ergebnis melden */
 return (lastall = num);
E 10
I 10
 /* Alle durch RPC-Fehler wartenden Jobs */
 for ( exe = Equeues ; exe ; exe = exe->next )
  for ( job = exe->Ejobs ; job ; job = job->next )
   if ( hasjobno(job,jno) )
    return 1;
 /* Alles in Ordung, die Nummer gibt es noch nicht */
 return 0;
E 10
}

D 10
freeJob(num)
E 10
I 10
/* 
  Diese Job hat die Jobnummer.
*/
static hasjobno(jc,job)
jobctrl *jc;
int job;
E 10
{
D 10
 /* Testen und freigeben */
 if ( (num >= 0) && (num < MAXJOB) ) JOBPTR(num) &= ~JOBMASK(num);
}

clearJobs()
{
 /* Alles freigeben */
 memset(alljob,0,sizeof(alljob));
E 10
I 10
 /* Je nach Art der Kontrollstruktur verfahren */
 switch (jc->Kind)
  {
   case sCONVERTER : return (job == -jc->execConv.requestID);
   case sSUBMIT    : return (job == jc->execReq.requestID);
   case sCANCEL    : return (job == -jc->execSig.requestID);
   default         : return 0;
  }
E 10
}
E 9
E 1
