h09549
s 00001/00001/00426
d D 5.1 91/08/15 08:58:37 jochen 9 8
c TRANSFERSIZE is now dynamic and initialized from the environment
e
s 00001/00001/00426
d D 4.4 91/07/25 09:16:21 jochen 8 7
c TRANSFERSIZE reduced to 10000 Bytes (from 100000 Bytes)
e
s 00003/00001/00424
d D 4.3 91/03/18 09:56:59 jochen 7 6
c Dump creation corrected
e
s 00015/00016/00410
d D 4.2 91/02/26 11:35:58 jochen 6 5
c Minor correction for QMan
e
s 00000/00000/00426
d D 4.1 91/02/20 13:26:43 jochen 5 4
c RPC number 390326 now reserved by SUN
e
s 00103/00000/00323
d D 3.3 91/02/20 13:19:45 jochen 4 3
c Parallel support and TCP performance measurement added
e
s 00065/00019/00258
d D 3.2 91/02/19 15:01:29 jochen 3 2
c Parallel queues supported
e
s 00001/00001/00276
d D 3.1 91/01/15 15:27:27 jochen 2 1
c RPC version 3 created
e
s 00277/00000/00000
d D 2.1 91/01/02 15:26:55 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_sgen_queue_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_QUEUE

#include "sgen_hdr.h"

struct valinfo
       {
	char *name;
	int  def;
	int  min;
	int  max;
       };

static struct valinfo vals[] =
       {
	{ "priority",        10, 0, 	 19 },
	{ "cputime",         -1, 1, INT_MAX },
	{ "algorithm",        1, 1, 	  0 },
	{ "joblimit",         0, 1, 	255 },
	{ "minidle",	      0, 0, 	100 },
	{ "pagefaults", INT_MAX, 0,   99999 },
	{ "stacksize",       -1, 1, INT_MAX },
	{ "datasize",        -1, 1, INT_MAX },
	{ "memorysize",      -1, 1, INT_MAX },
       };

#define VPRIO		0
#define VCPU		1
#define VALGO		2
#define VJOBS		3
#define VMINIDLE	4
#define VFAULTS		5
#define VSTACK		6
#define VDATA		7
#define VMEM		8

static char *get_value(),*get_range();


/*
  Queuedefinition einlesen.
*/
char *get_queue(def,minID)
char *def;
ID minID;
{
 static char errmess[128];
 char *next,*mess;
 genctrl *nq;
  
 /* Name einlesen */
 next = def;
 if ( def = strchr(def,':') ) *def++ = '\0';
 if ( !*next )
  {
   strcpy(errmess,"queue has no name");
   return errmess;
  }
 /* Name validieren */
 if ( strchr(next,'_') )
  {
   strcpy(errmess,"queue name must not contain a _ character");
   return errmess;
  }
 /* Name suchen */
 for ( nq = Gqueues ; nq ; nq = nq->next )
  if ( !strcmpi(next,nq->name) )
   if ( nq->genID <= minID )
    {
     lprintf("Generic queue %s restored, not overwritten by definition\n",nq->name);
     return 0;
    }
   else
    {
     strcpy(errmess,"duplicate queue name");
     return errmess;
    }
 /* Datenbereich erzeugen */
D 6
 if ( !(nq = MALLOC(genctrl,1)) || !(nq->name = strdup(next)) ) 
E 6
I 6
 if ( !(nq = SALLOC(genctrl)) || !(nq->name = strdup(next)) ) 
E 6
  {
   if ( nq ) free(nq);
   strcpy(errmess,"out of memory");
   return errmess;
  }
I 3
 nq->pdl = 0;
E 3
 /* Initialisierung vervollstaendigen */
 vals[VALGO].max = NALGO;
 /* Parameter einlesen */
 if ( !(mess = get_value(&def,&nq->prio,vals+VPRIO)) &&
      !(mess = get_value(&def,&nq->cpu,vals+VCPU)) &&
      !(mess = get_value(&def,&nq->algo,vals+VALGO)) )
  {
D 3
   vals[VJOBS].def = (int)ALGO(Ajobdef,nq,NOSTR);
E 3
I 3
   vals[VJOBS].def = (int)ALGO(Ajobdef,nq,(execctrl *)0,(hints *)0);
E 3
   if ( !(mess = get_value(&def,&nq->jobs,vals+VJOBS)) &&
        !(mess = get_value(&def,&nq->minidle,vals+VMINIDLE)) &&
        !(mess = get_value(&def,&nq->faults,vals+VFAULTS)) &&
        !(mess = get_range(&def,&nq->stack,vals+VSTACK)) &&
D 3
        !(mess = get_range(&def,&nq->data,vals+VDATA)) )
    mess = get_range(&def,&nq->mem,vals+VMEM);
E 3
I 3
        !(mess = get_range(&def,&nq->data,vals+VDATA)) &&
        !(mess = get_range(&def,&nq->mem,vals+VMEM)) )
    /* Paralleljobinterpreter */
    if ( !(nq->pdl = strdup(def ? def : "")) )
     strcpy(mess = errmess,"out of memory");
    else if ( *nq->pdl )
     if ( *nq->pdl != '/' )
      strcpy(mess = errmess,"pathname of parallel interpreter must be absolute");
     else if ( access(nq->pdl,X_OK) == -1 )
      strcpy(mess = errmess,"parallel interpreter is not executable");
E 3
  }
 /* Fehler bearbeiten */
 if ( mess )
  {
I 3
   if ( nq->pdl ) free(nq->pdl);
E 3
   free(nq->name);
   free(nq);
   return mess;
  }
 /* GEN-Queue in die Liste einbinden */
 nq->Rjobs = nq->Pjobs = 0;
 nq->genID = ++genCnt;
 nq->genaddr = (int)nq;
 nq->state = qNORMAL;
 nq->back.pos = -1;
 nq->next = Gqueues;
 Gqueues = nq;
 /* Erfolg melden */
D 3
 lprintf("Queue %s successfully added\n",nq->name);
 lprintf(" PRIO=%d CPU=%dsecs JOBS=%d MINIDLE=%d FAULTS=%d ALGO=%d\n",
E 3
I 3
 lprintf("Queue %s successfully added",nq->name);
 if ( *nq->pdl ) lprintf(", PARALLELSHELL=%s",nq->pdl);
 lprintf("\n PRIO=%d CPU=%dsecs JOBS=%d MINIDLE=%d FAULTS=%d ALGO=%d\n",
E 3
	 nq->prio,nq->cpu,nq->jobs,nq->minidle,nq->faults,nq->algo);
 lprintf(" STACK=(%d,%d) DATA=(%d,%d) MEM=(%d,%d) KiloBytes\n",
	 nq->stack.def,nq->stack.max,nq->data.def,nq->data.max,nq->mem.def,nq->mem.max);
 return 0;
}
 
/*
  String analyzieren und Wert einlesen.
*/
static char *get_value(sp,vp,vi)
char **sp;
int *vp;
struct valinfo *vi;
{
 static char errmess[64];
 char *item = sp[0],*more;
  
 /* Wert einsetzen */
 *vp = vi->def;
 /* Elementende suchen */
 if ( sp[0] && (sp[0] = strchr(sp[0],':')) ) *sp[0]++ = '\0';
 if ( !item || !*item ) return 0;
 /* Element umwandeln */
 errno = 0;
 if ( (((*vp = strtoul(item,&more,0)) == -1) && errno) || !more || *more || (more == item) )
  {
   sprintf(errmess,"invalid value for %s",vi->name);
   return errmess;
  }
 /* Bereichsgrenzen ueberpruefen */
 if ( (*vp < vi->min) || (*vp > vi->max) )
  {
   sprintf(errmess,"value for %s out of range",vi->name);
   return errmess;
  }
 /* Alles in Ordung */
 return 0;
}
 
/*
  String analyzieren und Wertepaar einlesen.
*/
static char *get_range(sp,rp,vi)
char **sp;
range *rp;
struct valinfo *vi;
{
 static char errmess[64];
 char *item = sp[0],*mess,*def,*mark1,*mark2;
  
 /* Wert einsetzen */
 rp->def = rp->max = -1;
 /* Elementende suchen */
 if ( sp[0] && (sp[0] = strchr(sp[0],':')) ) *sp[0]++ = '\0';
 if ( !item || !*item ) return 0;
 /* String weiter zerlegen */
 mark1 = def = item;
 if ( mark2 = item = strchr(item,',') ) *item++ = '\0';
 /* Werte einlesen */
 if ( (mess = get_value(&def,&rp->def,vi)) || (mess = get_value(&item,&rp->max,vi)) )
  return mess;
 /* Kontrolltest */
 if ( !mark2 ) return 0;
 if ( !*mark1 )
  rp->def = rp->max;
 else if ( !mark2[1] )
  rp->max = rp->def;
 else if ( rp->def > rp->max )
  {
   sprintf(errmess,"%s default must not be greater than maximum",vi->name);
   return errmess;
  }
 /* Alles in Ordung */
 return 0;
}

/*
  Die Angaben einer Queue mit Defaultwerten versehen. Vorgegebenen Werte muessen
  in den durch den Queuemanager definierten Grenzen liegen.
*/
fillgen(gen,src,mask,msg)
genctrl *gen,*src;
int mask;
char *msg;
{
 int create;
I 3
 char *pdl;
E 3

 /* Defaultwerte ermitteln */
 if ( create = !src ) src = gen;
 /* Initialisierung beenden */
 vals[VALGO].max = NALGO;
 /* Alle Parameter durchgehen */
 if ( !fill_value(mask&ifPRIORITY,create,&gen->prio,src->prio,vals+VPRIO,msg) ||
      !fill_value(mask&ifCPUMAXIMUM,create,&gen->cpu,src->cpu,vals+VCPU,msg) ||
      !fill_value(mask&ifALGORITHM,create,&gen->algo,src->algo,vals+VALGO,msg) )
  return 0;
D 3
 vals[VJOBS].def = (int)ALGO(Ajobdef,gen,NOSTR);
 return (fill_value(mask&ifJOBLIMIT,create,&gen->jobs,src->jobs,vals+VJOBS,msg) &&
         fill_value(mask&ifMINIDLE,create,&gen->minidle,src->minidle,vals+VMINIDLE,msg) &&
         fill_value(mask&ifFAULTLIMIT,create,&gen->faults,src->faults,vals+VFAULTS,msg) &&
         fill_value(mask&ifSTACKMAX,create,&gen->stack.max,src->stack.max,vals+VSTACK,msg) &&
         fill_value(mask&ifSTACKDEF,create,&gen->stack.def,src->stack.def,vals+VSTACK,msg) &&
         fill_value(mask&ifDATAMAX,create,&gen->data.max,src->data.max,vals+VDATA,msg) &&
         fill_value(mask&ifDATADEF,create,&gen->data.def,src->data.def,vals+VDATA,msg) &&
         fill_value(mask&ifMEMORYMAX,create,&gen->mem.max,src->mem.max,vals+VMEM,msg) &&
         fill_value(mask&ifMEMORYDEF,create,&gen->mem.def,src->mem.def,vals+VMEM,msg) &&
	 fill_range(mask&ifSTACKMAX,mask&ifSTACKDEF,create,&gen->stack,vals+VSTACK,msg) &&
	 fill_range(mask&ifDATAMAX,mask&ifDATADEF,create,&gen->data,vals+VDATA,msg) &&
	 fill_range(mask&ifMEMORYMAX,mask&ifMEMORYDEF,create,&gen->mem,vals+VMEM,msg));
E 3
I 3
 vals[VJOBS].def = (int)ALGO(Ajobdef,gen,(execctrl *)0,(hints *)0);
 if ( !fill_value(mask&ifJOBLIMIT,create,&gen->jobs,src->jobs,vals+VJOBS,msg) ||
      !fill_value(mask&ifMINIDLE,create,&gen->minidle,src->minidle,vals+VMINIDLE,msg) ||
      !fill_value(mask&ifFAULTLIMIT,create,&gen->faults,src->faults,vals+VFAULTS,msg) ||
      !fill_value(mask&ifSTACKMAX,create,&gen->stack.max,src->stack.max,vals+VSTACK,msg) ||
      !fill_value(mask&ifSTACKDEF,create,&gen->stack.def,src->stack.def,vals+VSTACK,msg) ||
      !fill_value(mask&ifDATAMAX,create,&gen->data.max,src->data.max,vals+VDATA,msg) ||
      !fill_value(mask&ifDATADEF,create,&gen->data.def,src->data.def,vals+VDATA,msg) ||
      !fill_value(mask&ifMEMORYMAX,create,&gen->mem.max,src->mem.max,vals+VMEM,msg) ||
      !fill_value(mask&ifMEMORYDEF,create,&gen->mem.def,src->mem.def,vals+VMEM,msg) ||
      !fill_range(mask&ifSTACKMAX,mask&ifSTACKDEF,create,&gen->stack,vals+VSTACK,msg) ||
      !fill_range(mask&ifDATAMAX,mask&ifDATADEF,create,&gen->data,vals+VDATA,msg) ||
      !fill_range(mask&ifMEMORYMAX,mask&ifMEMORYDEF,create,&gen->mem,vals+VMEM,msg) )
  return 0;
 /* Parallelinterpreter */
 if ( !(mask&ifPDL) )
  {
   /* Defaultname ermitteln */
   if ( !(pdl = strdup(create ? "" : src->pdl)) ) 
    {
     strcpy(msg,"out of memory while processing parallel interpreter");
     return 0;
    }
   /* Defaultname eintragen */
   free(gen->pdl);
   gen->pdl = pdl;
   /* Fertig */
   return 1;
  }
 /* Test der Datei */
 if ( *gen->pdl )
  {
   /* Dateiname */
   if ( *gen->pdl != '/' )
    {
     strcpy(msg,"parallel interpreter file name must be absolute");
     return 0;
    }
   /* Zugriff auf die Datei selbst */
   if ( access(gen->pdl,X_OK) == -1 )
    {
     strcpy(msg,"could not access parallel interpreter");
     return 0;
    }
  }
 /* Alles in Ordnung */
 return 1;
E 3
}

/*
  Ueberpruefung eines Parameter einer GEN-Queue.
*/
static fill_value(doit,create,val,def,vi,msg)
int doit,create,*val,def;
struct valinfo *vi;
char *msg;
{
 /* Defaultwert uebertragen */
 if ( !doit )
  *val = create ? vi->def : def;
 else if ( (*val < vi->min) || (*val > vi->max) )
  {
   sprintf(msg,"value for %s is out of range",vi->name);
   return 0;
  }
 /* Erfolg melden */
 return 1;
}

/*
  Bereichsgrenzen ueberpruefen.
*/
static fill_range(gotmax,gotdef,create,rp,vi,msg)
int gotmax,gotdef,create;
range *rp;
struct valinfo *vi;
char *msg;
{
 /* Defaultwert einsetzen */
 if ( create && !gotdef ) rp->def = rp->max;
 /* Grenzen ueberpruefen */
D 6
 if ( rp->max != -1 )
  if ( rp->def > rp->max )
   if ( !create && !gotdef && gotmax )
    rp->def = rp->max;
   else
    {
     sprintf(msg,"default of %s must not be greater than maximum",vi->name);
     return 0;
    }
E 6
I 6
 if ( (rp->max != -1) && (rp->def > rp->max) )
  if ( !create && !gotdef && gotmax )
   rp->def = rp->max;
  else
   {
    sprintf(msg,"default of %s must not be greater than maximum",vi->name);
    return 0;
   }
E 6
 /* Alles in Ordnung */
 return 1;
}
I 4

/*
  Informationen ueber eine Queue in dem Format in eine Datei schreiben, in dem
  die Initialisierungsroutine es erwartet.
*/
qprintf(f,gen)
FILE *f;
genctrl *gen;
{
 /* Parameter nach und nach rausschreiben */
 fprintf(f,"%s:%d:",gen->name,gen->prio);
D 6
 if ( gen->cpu > 0 ) fprintf("%d",gen->cpu);
 fprintf(":%d:%d:%d:%d:",gen->algo,gen->jobs,gen->minidle,gen->faults);
E 6
I 6
 if ( gen->cpu > 0 ) fprintf(f,"%d",gen->cpu);
D 7
 fprintf(f,":%d:%d:%d:%d:",gen->algo,gen->jobs,gen->minidle,gen->faults);
E 7
I 7
 fprintf(f,":%d:",gen->algo);
 if ( gen->jobs != INT_MAX ) fprintf(f,"%d",gen->jobs);
 fprintf(f,":%d:%d:",gen->minidle,gen->faults);
E 7
E 6
 qprintr(f,&gen->stack);
 qprintr(f,&gen->data);
 qprintr(f,&gen->mem);
D 6
 fprintf("%s",gen->pdl);
E 6
I 6
 fprintf(f,"%s",gen->pdl);
E 6
}

/* 
  Bereich anzeigen.
*/
static qprintr(f,r)
FILE *f;
range *r;
{ 
 /* Siehe dazu 'get_range' */
 if ( r->def > 0 ) fprintf(f,"%d",r->def);
D 6
 if ( r->max > 0 ) fprintf(f,",%d",r->def,r->max);
E 6
I 6
 if ( r->max > 0 ) fprintf(f,",%d",r->max);
E 6
 /* Trennzeichen */
 fprintf(f,":");
}

/*
  Periodisch Transfermessungen starten.
*/
dotransfer()
{
 static transinfo ti = { 0, 0, { 0, 0 } };
 static int api = 0;
 execctrl *exe,*rem;
 statusinfo info;
 long now,del;
 parchan *np;
 int res;

 /* Ist es mal wieder Zeit fuer einen neuen Durchlauf ? */
 if ( --transtick ) return;
 transtick = TRANSTIME/INTERVALL;
 /* Alle EXEC-Queues durchsuchen */
 time(&now);
 for ( exe = Equeues ; exe ; exe = exe->next )
  if ( exe->transid != transcur )
   if ( !exe->status.queueID || (exe->retry <= 0) )
    transtick = 60/INTERVALL;
   else
    {
     /* Nur, wenn die Daten schon alt sind */
     if ( ((del = now-exe->tcpstamp) >= 0) && (del <= TRANSTIME) ) 
      {
       exe->transid = transcur;
       continue;
      }
     /* Speicherfeld aufbauen */    
     ti.tripel.parchans_len = 0;
     for ( rem = Equeues ; rem ; rem = rem->next )
      if ( rem->status.EaterPort > 0 )
       {
	/* Speicher bereitstellen */
	if ( ti.tripel.parchans_len == api )
	 {
	  /* Neuen Speicherbereich */
	  if ( !(np = MALLOC(parchan,api+10)) ) break;
	  /* Alten Bereich retten */
	  if ( api )
	   {
	    memmove(np,ti.tripel.parchans_val,api*sizeof(np[0]));
	    free(ti.tripel.parchans_val);
	   }
	  /* Zeiger aktualisieren */
	  api += 10;
	  ti.tripel.parchans_val = np;
	 }
	/* Eintrag fuellen */
	np = ti.tripel.parchans_val+ti.tripel.parchans_len++;
	np->IPaddr = rem->status.IPaddr;
	np->IPport = rem->status.EaterPort;
D 6
	np->IPbytes = 1000000;
E 6
I 6
D 8
	np->IPbytes = 100000;
E 8
I 8
D 9
	np->IPbytes = TRANSFERSIZE;
E 9
I 9
	np->IPbytes = transfersize;
E 9
E 8
E 6
       }
     /* Abschicken */
     ti.queueID = exe->status.queueID;
     ti.requestID = exe->transid = transcur;
D 6
     if ( transfer(&exe->cl,exe->status.IPaddr,&res) )
E 6
I 6
     if ( transfer(&exe->cl,exe->status.IPaddr,&ti,&res) )
E 6
      exe->retry = RETRY0;
     else
      exe->retry--;
     /* Die anderen spaeter bearbeiten */
     transtick = (5*60)/INTERVALL;  
     return;
    }
 /* Keine Bearbeitung durchgefuehrt */
 if ( transtick == (TRANSTIME/INTERVALL) ) transcur++;
}
E 4
E 1
