h04679
s 00001/00001/01072
d D 5.3 91/08/15 10:25:19 jochen 21 20
c Rounding of CPU time corrected
e
s 00013/00014/01060
d D 5.2 91/08/15 09:23:50 jochen 20 19
c CPU time forwarding corrected
e
s 00079/00001/00995
d D 5.1 91/08/15 09:00:18 jochen 19 18
c CPU time from EXEC forwarded to parallel control job
e
s 00003/00003/00993
d D 4.15 91/06/05 08:46:56 jochen 18 17
c Jobnummer allocation routine called
e
s 00002/00002/00994
d D 4.14 91/05/28 11:55:10 jochen 17 16
c rmsfile refernce corrected
e
s 00002/00000/00994
d D 4.13 91/05/28 11:51:09 jochen 16 15
c RESTART environment variable used
e
s 00001/00001/00993
d D 4.12 91/03/15 17:41:35 jochen 15 14
c Error in killconverter corrected
e
s 00001/00001/00993
d D 4.11 91/03/15 17:24:59 jochen 14 13
c Error in sendkill corrected
e
s 00007/00015/00987
d D 4.10 91/03/15 17:03:26 jochen 13 12
c SUSPEND/RESUME now using unique requestIDs for EXEC-Queues
e
s 00001/00001/01001
d D 4.9 91/03/15 11:11:02 jochen 12 11
c Jobstate handling corrected
e
s 00029/00009/00973
d D 4.8 91/03/15 11:00:35 jochen 11 10
c Support for SET ENTRY/[NO]SUSPEND added
e
s 00002/00001/00980
d D 4.7 91/03/09 13:44:51 jochen 10 9
c Valid 'hints' used for algo_transfer
e
s 00008/00004/00973
d D 4.6 91/03/05 12:41:34 jochen 9 8
c Further corrections to parallel job controller search
e
s 00006/00002/00971
d D 4.5 91/03/05 12:34:45 jochen 8 7
c Check for parallel control job corrected
e
s 00005/00002/00968
d D 4.4 91/02/27 15:04:35 jochen 7 6
c Notification name set to uid name for jobs started from VAX/VMS
e
s 00033/00025/00937
d D 4.3 91/02/26 17:25:32 jochen 6 5
c Jobkind now checked for jobs from EXEC-Queue
e
s 00135/00124/00827
d D 4.2 91/02/26 11:35:52 jochen 5 4
c Minor correction for QMan
e
s 00000/00000/00951
d D 4.1 91/02/20 13:26:39 jochen 4 3
c RPC number 390326 now reserved by SUN
e
s 00223/00021/00728
d D 3.2 91/02/20 13:23:11 jochen 3 2
c Support for parallel jobs added and submit functionality enhanced
e
s 00017/00017/00732
d D 3.1 91/01/15 15:28:52 jochen 2 1
c RPC version 3 created and EXEC-Queue version 3 constants used
e
s 00749/00000/00000
d D 2.1 91/01/02 15:26:53 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_sgen_job_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_JOB

#include "sgen_hdr.h"

/*
  Bearbeitung einer SUBMIT-Anfrage des Benutzers.
*/
submitjob(gen,job,msg,uexe)
genctrl *gen;
submit *job;
char *msg;
execctrl *uexe;
{
I 3
D 5
 char *str,ch,pbuf[40];
E 3
 jobctrl *jobc,*pjob;
 execctrl *exec;
D 3
 char *str,ch;
 long now;
E 3
I 3
 long now,ad;
 param *np;
E 3
 int len;
E 5
I 5
 jobctrl *jobc = 0,*pjob;
 execctrl *exec,*sexe;
 int leader = 0;
 genctrl *sgen;
 char *err = 0;
 long now;
E 5

 /* Uhrzeit ermitteln */
 time(&now);
 /* Und in die Grenzen packen */
D 5
 cutjob(job,gen,-1);
 /* Commanddatei suchen */
 if ( *job->Jinfo.shell != '/' )
E 5
I 5
 cutjob(job,gen,-1,0);
 /* SHELL- und Druckername anpassen */
 if ( !makeshell(job,gen) || !makeprint(job,gen) ) return;
 /* Parameterliste bei Parallelkontrolljobs erweitern */
 if ( *gen->pdl )
E 5
  {
D 5
   /* Name der Shell um eine Directory erweitern */
   len = strlen(job->Jinfo.shell);
   if ( !(str = MALLOC(char,len+sizeof(DEFPATH))) ) return;
   strcpy(str,DEFPATH);
   strcpy(str+sizeof(DEFPATH)-1,job->Jinfo.shell);
   /* In die Struktur einsetzen */
   free(job->Jinfo.shell);
   job->Jinfo.shell = str;
E 5
I 5
   /* Ein Parallelteiljob darf nicht in eine Parallelqueue geschickt werden */
   if ( job->leader )
    strcpy(err = msg,"Can't start parallel subjob in parallel queue");
   /* Spezialparameter fuer einen Paralleljob als ersten Paramter hinzunehmen */
D 6
   else if ( !makeparallel(jobc,leader = ++parCnt) )
E 6
I 6
   else if ( !makeparallel(job,leader = ++parCnt) )
E 6
    err = msg;
E 5
  }
D 5
 /* Umwandeln der Commanddatei in Kleinschreibung */
 for ( str = job->Jinfo.shell ; ch = *str++ ; )
  if ( (ch >= 'A') && (ch <= 'Z') )
   str[-1] += 'a'-'A';
I 3
 /* Umwandeln der Printerqueue in Kleinschreibung */
 for ( str = job->Jinfo.print ; ch = *str++ ; )
  if ( (ch >= 'A') && (ch <= 'Z') )
   str[-1] += 'a'-'A';
E 5
I 5
 /* Parallelkennung bei Parallelteiljobs verifizieren */
 else if ( job->leader )
  {
   /* Alle Genericueues durchgehen */
   for ( sgen = Gqueues ; sgen ; sgen = sgen->next )
D 8
    /* Laufende Jobs */
    for ( jobc = sgen->Rjobs ; jobc && (jobc->leader != job->leader) ; jobc = jobc->next );
E 8
I 8
    {
     /* Laufende Jobs */
     for ( jobc = sgen->Rjobs ; jobc && (jobc->leader != job->leader) ; jobc = jobc->next );
     /* Nur bis der Job gefunden wurde */
     if ( jobc ) break;
    }
E 8
   /* Mit RPC-Fehler wartende Jobs */
   if ( !jobc )
    for ( sexe = Equeues ; sexe ; sexe = sexe->next )
D 9
     /* Laufende Jobs */
D 6
     for ( jobc = sexe->Ejobs ; jobc && (jobc->leader != job->leader) ; jobc = jobc->next );  
E 6
I 6
     for ( jobc = sexe->Ejobs ; jobc ; jobc = jobc->next )
      if ( ISSUBMIT(jobc) && (jobc->leader == job->leader) )
       break;
E 9
I 9
     {
      /* Laufende Jobs */
      for ( jobc = sexe->Ejobs ; jobc ; jobc = jobc->next )
       if ( ISSUBMIT(jobc) && (jobc->leader == job->leader) )
        break;
      /* Nur bis der Job gefunden wurde */
      if ( jobc ) break;
     }
E 9
E 6
   /* Haben wir den Vaterprozess gefunden */
   if ( !jobc ) strcpy(err = msg,"Parallel control job of partial parallel job missing");
  }
 /* Fehler bearbeiten */
 if ( err )
  {
   /* Aufhoeren */
   addID(job->qinfo.requestID,msg);
   return;
  }
E 5
E 3
 /* Jobsteuerstruktur erzeugen */
 if ( !(jobc = makejob(gen,job)) ) return;
 jobc->submit = now;
I 5
 jobc->leader = leader;
E 5
 /* Wartende Jobs kontrollieren */
 for ( ctrlCnt++, pjob = gen->Pjobs ; pjob ; pjob = pjob->next )
  if ( (pjob->request.hold != 1) && (pjob->request.hold || (pjob->request.at <= now)) )
   if ( !pjob->jexec )
    break;
   else
    pjob->jexec->ctrl = ctrlCnt;
I 3
D 5
 /* Parameterliste bei Parallelkontrolljobs erweitern */
 if ( job->leader )
  if ( jobc->leader )
   {
    /* Fehlermeldung setzen */
    strcpy(msg,"Can't start parallel subjob in parallel queue");
    /* Aufraeumen */
    free_jobctrl(jobc);
    /* Aufhoeren */
    addID(job->qinfo.requestID,msg);
    return;
   } 
  else
   {
    /* Zeile zusammensetzen */
    ad = htonl(master.addr);
    sprintf(pbuf,"%s,%d,%d,%d",INET_NTOA(ad),GENPROG,GENVERS,job->leader);
    /* Feld erweitern */
    if ( !(str = strdup(pbuf)) || !(np = MALLOC(param,job->Jinfo.param.param_len+1)) )
     {
      /* Speicher freigeben */
      if ( str ) free(str);
      free_jobctrl(jobc);
      /* Aufhoeren */
      addID(job->qinfo.requestID,msg);
      return;
     }
    /* Umkopieren */
    memmove(np+1,job->Jinfo.param.param_val,job->Jinfo.param.param_len*sizeof(np[0]));
    free(job->Jinfo.param.param_val);
    /* Neue Werte eintragen */
    job->Jinfo.param.param_len++;
    (job->Jinfo.param.param_val = np)[0] = str;
   }
E 5
E 3
 /* Prozess abschicken */
D 3
 if ( pjob || job->hold || (job->at > now) || !(exec = ALGO(Adispatch,gen,uexe)) )
  {
   /* Job konnte nicht gestartet werden, da alle Rechner ausgelastet sind */
   jobc->state = jPENDING;
   addTail(&gen->Pjobs,jobc);
   /* Eventuell soll dieser Job spaeter einer EXEC-Queue fest zugeordnet werden */
   if ( jobc->jexec = uexe )
    sprintf(msg,"Job %d pending on queue %s_%s",jobc->jobID,gen->name,uexe->status.name);
   else
    sprintf(msg,"Job %d pending on generic queue %s",jobc->jobID,gen->name);
   lprintf("%s\n",msg);
   /* In die Backupdatei uebertragen */
   backjob(jobc,1);
  }
E 3
I 3
D 10
 if ( pjob || job->hold || (job->at > now) || !(exec = ALGO(Adispatch,gen,uexe,&job->hosts)) )
E 10
I 10
 if ( pjob || job->hold || (job->at > now) || 
      !(exec = ALGO(Adispatch,gen,uexe,&jobc->request.hosts)) )
E 10
D 5
  if ( !jobc->jexec && job->nopend )
E 5
I 5
D 6
  if ( uexe && job->nopend )
E 6
I 6
  if ( !uexe && job->nopend )
E 6
E 5
   {
    /* Speicher freigeben */
    free_jobctrl(jobc);
    /* Fehler melden */
    strcpy(msg,"Job not started because of insufficient cpu resources");
   }
  else
   {
    /* Job konnte nicht gestartet werden, da alle Rechner ausgelastet sind */
    jobc->state = jPENDING;
    addTail(&gen->Pjobs,jobc);
    /* Eventuell soll dieser Job spaeter einer EXEC-Queue fest zugeordnet werden */
    if ( jobc->jexec = uexe )
     sprintf(msg,"Job %d pending on queue %s_%s",jobc->jobID,gen->name,uexe->status.name);
    else
     sprintf(msg,"Job %d pending on generic queue %s",jobc->jobID,gen->name);
    lprintf("%s\n",msg);
    /* In die Backupdatei uebertragen */
    backjob(jobc,1);
   }
E 3
 else if ( !exec->Ejobs && !exec->ack_len && !startjob(exec,jobc,msg) )
  /* Speicher freigeben */
  free_jobctrl(jobc);
 else
  {
   /* Job mit der EXEC-Queue assoziieren */
   jobc->jexec = exec;
   exec->jobs++;
   /* Uhrzeit eintragen */
   jobc->dispatch = now;
   /* Moegliche Faelle bearbeiten */
   if ( jobc->pid < 0 )
    {
     /* Job warted in einer EXEC-Queue */
     addTail(&exec->Ejobs,jobc);
     jpinfo(jobc,"pending",msg);
    }
   else
    {
     /* Job wird auf einer EXEC-Queue gestartet */   
     addTail(&gen->Rjobs,jobc);
     jpinfo(jobc,"started",msg);
    }
   /* In die Backupdatei uebertragen */
   backjob(jobc,1);
  }
 /* Eintrag vermerken */
 addID(job->qinfo.requestID,msg);
}

/*
  Parameter des Jobs an die GEN-Queue anpassen.
*/
D 5
cutjob(job,gen,mask)
E 5
I 5
cutjob(job,gen,mask,reset)
E 5
submit *job;
genctrl *gen;
D 5
int mask;
E 5
I 5
int mask,reset;
E 5
{
I 5
 /* Parameter in den Urzustand versetzen */
 if ( reset )
  {
   /* Offsets korrigieren */
   if ( mask&ufPRIORITY ) job->Jinfo.nice -= gen->prio;
   /* Faktoren korrigieren */
   if ( (mask&ufDATA) && (job->Jinfo.data > 0) ) job->Jinfo.data /= 1024;
   if ( (mask&ufSTACK) && (job->Jinfo.stack > 0) ) job->Jinfo.stack /= 1024;
   if ( (mask&ufMEMORY) && (job->Jinfo.memory > 0) ) job->Jinfo.memory /= 1024;
   return;
  }
 /* Parameter ueberpruefen */
E 5
 if ( mask&ufPRIORITY )
  if ( job->Jinfo.nice < 0 )
   job->Jinfo.nice = gen->prio;
  else if ( (job->Jinfo.nice > 100) || ((job->Jinfo.nice += gen->prio) > 19) )
   job->Jinfo.nice = 19;
 if ( mask&ufCPUTIME ) cut_value(&job->Jinfo.cpu,gen->cpu,gen->cpu,1);
 if ( mask&ufDATA ) cut_value(&job->Jinfo.data,gen->data.def,gen->data.max,1024);
 if ( mask&ufSTACK ) cut_value(&job->Jinfo.stack,gen->stack.def,gen->stack.max,1024);
 if ( mask&ufMEMORY ) cut_value(&job->Jinfo.memory,gen->mem.def,gen->mem.max,1024);
}

/*
  Nachdem ein Job einen der Verteilungsalgorithmen durchlaufen hat, muss er auf einer
  der EXEC-Queues gestartet werden. Sollte dabei ein RPC-Fehler auftreten, wird der
  Job in die Warteschlange eingeordnet.
*/
static startjob(exe,job,msg)
execctrl *exe;
jobctrl *job;
char *msg;
{
 /* Verwaltungsstruktur aufsetzen */
 job->execReq.queueID = exe->status.queueID;
 /* Versuch, den Job zu starten */
 if ( !jobstart(&exe->cl,exe->status.IPaddr,&job->execReq,&job->pid) )
  {
   /* Fehler im RPC-Aufruf */
   exe->retry--;
   /* Zeiten aktualisieren */
   exe->stamp = 0;
   time(&exe->lastjob);
   /* Fehler melden */
   job->pid = -100;
   return 1;
  }
 /* RPC-Aufruf hat funktioniert */
 exe->retry = RETRY0;
 if ( job->pid > 0 )
  {
   /* Zeiten aktualisieren und Erfolg melden */
   exe->stamp = 0;
   time(&exe->lastjob);
   return 1;
  }
 /* Fehler bearbeiten */
 switch (job->pid)
  {
D 2
   case -4 : sprintf(msg,"No user %d found",job->execReq.uid);
    	     break;     
   case -3 : strcpy(msg,"Queue manager not attached to local job controller");
       	     break;
   case -2 : strcpy(msg,"Queue manager not authorized to start job");
       	     break;
   case -1 : strcpy(msg,"Job could not be started due to error in fork");
	     break;
   case  0 : strcpy(msg,"Out if memory during job dispatch");
	     break;
   default : strcpy(msg,"Local job controll will not accept job");
E 2
I 2
   case ERRSTART_NOUSER      : sprintf(msg,"No user %d found",job->execReq.uid);
    	     		       break;     
   case ERRSTART_NOTATTACHED : strcpy(msg,"Queue manager not attached to job controller");
    	     		       break;     
   case ERRSTART_NOTROOT     : strcpy(msg,"Queue manager not authorized to start job");
    	     		       break;     
   case ERRSTART_NOFORK      : strcpy(msg,"Job could not be started due to error in fork");
    	     		       break;     
   case ERRSTART_NOMEM       : strcpy(msg,"Out if memory during job dispatch");
    	     		       break;     
   default                   : strcpy(msg,"Local job controll will not accept job");
E 2
  }
 return 0;
}

/*
  Zum Entfernen eines Jobs wird der zugehoerige Prozess auf der EXEC-Queue
  einfach mit einem SIGKILL versorgt. Alles andere laeuft dann asynchron
  praktisch von selbst ab.
*/
D 5
killjob(job,msg)
E 5
I 5
D 11
static killjob(job,msg)
E 11
I 11
static killjob(job,msg,flags)
E 11
E 5
jobctrl *job;
char *msg;
I 11
int flags;
E 11
{
I 11
 int (*rout)(),jobkill(),jobsuspend(),jobresume();
E 11
 execctrl *exe = job->jexec;
 killinfo kill;
 PID pid;

 /* Verwaltungsstruktur aufsetzen */
D 6
 if ( job->Kind == sSUBMIT )
E 6
I 6
 if ( ISSUBMIT(job) )
E 6
  {
   kill.requestID = -job->jobID;
   kill.pid = job->pid;
  }
 else
  kill = job->execSig;
I 11
 /* Routine ermitteln und Kennung modifizieren */
 if ( flags == ufSUSPEND )
D 13
  {
   if ( ISSUBMIT(job) ) kill.requestID -= 0x40000000;
   rout = jobsuspend;
  }
E 13
I 13
  rout = jobsuspend;
E 13
 else if ( flags == ufRESUME )
D 13
  {
   if ( ISSUBMIT(job) ) kill.requestID -= 0x20000000;
   rout = jobresume;
  }
E 13
I 13
  rout = jobresume;
E 13
 else
  rout = jobkill;
E 11
 /* Kennung der EXEC-Queue einsetzen */
 kill.queueID = exe->status.queueID;
 /* Versuch, den Job zu vernichten */
D 11
 if ( !jobkill(&exe->cl,exe->status.IPaddr,&kill,&pid) )
E 11
I 11
 if ( !(*rout)(&exe->cl,exe->status.IPaddr,&kill,&pid) )
E 11
  {
   /* Fehler im RPC-Aufruf */
   exe->retry--;
   exe->stamp = 0;
   /* Fehler melden */
   return 0;
  }
 /* RPC-Aufruf hat funktioniert */
 exe->retry = RETRY0;
 /* Kontrollinformationen egalisieren und Erfolg melden */
 if ( pid > 0 ) return 1;
 /* Fehler bearbeiten */
 switch (pid)
  {
D 2
   case -1 : strcpy(msg,"Queue manager not authorized to start job");
       	     break;
   case -2 : strcpy(msg,"Queue manager not attached to local job controller");
   case -3 : break;
   default : strcpy(msg,"Local job controll will not kill job");
E 2
I 2
   case ERRSIGNAL_NOTROOT     : strcpy(msg,"Queue manager not authorized to start job");
       	     		        break;
   case ERRSIGNAL_NOTATTACHED : strcpy(msg,"Queue manager not attached to job controller");
   case ERRSIGNAL_NOTPID      : break;
   default                    : strcpy(msg,"Local job controll will not kill job");
E 2
  }
 return 1;
}

/*
I 3
  Nachricht ueber eine EXEC-Queue an einen Konverter zum Schliessen eines
  Ausgabekanals geben.
*/
D 5
killconverter(sub,exe,msg)
E 5
I 5
static killconverter(sub,exe,msg)
E 5
submit *sub;
execctrl *exe;
char *msg;
{
 PID pid;

 /* Kennung der EXEC-Queue einsetzen */
 sub->Cinfo.queueID = exe->status.queueID;
 /* Versuch, den Job zu vernichten */
 if ( !convkill(&exe->cl,exe->status.IPaddr,&sub->Cinfo,&pid) )
  {
   /* Fehler im RPC-Aufruf */
   exe->retry--;
   exe->stamp = 0;
   /* Fehler melden */
   return 0;
  }
 /* RPC-Aufruf hat funktioniert */
 exe->retry = RETRY0;
 /* Kontrollinformationen egalisieren und Erfolg melden */
 if ( pid >= 0 ) return 1;
 /* Fehler bearbeiten */
 switch (pid)
  {
   case ERRCONVERTER_NOTROOT      : strcpy(msg,"Queue manager not authorized to start job");
       	     		            break;
   case ERRCONVERTER_NOTATTACHED  : strcpy(msg,"Queue manager not attached to job controller");
   case ERRCONVERTER_NOTPID       : break;
   case ERRCONVERTER_NOTCONVERTER : strcpy(msg,"Jobprocess is not a converter");
				    break;
   case ERRCONVERTER_NOMEM        : strcpy(msg,"Out of memory during channel shutdown");
				    break;
   default                        : strcpy(msg,"Local job controll will not kill job");
  }
 return 1;
}

/*
E 3
  Ein Job wurde beendet, was einerseits der EXEC-Queue bestaetigt werden muss,
  andererseits dem Benutzer gemeldet werden sollte.
*/
jobctrl **findjob(exe,jobs,not,del)
execctrl *exe;
jobctrl **jobs;
jobdone *not;
int del;
{
I 20
 char *mess,*seppos;
E 20
 jobctrl *jobc;
D 20
 char *mess;
E 20
I 20
 double cpu;
E 20
 int len;

 /* Job suchen */
 for ( ; jobc = *jobs ; jobs = &jobc->next )
  /* Entscheidende Parameter vergleichen */
D 6
  if ( (jobc->Kind == sSUBMIT) && (jobc->jobID == not->job) &&
E 6
I 6
  if ( ISSUBMIT(jobc) && (jobc->jobID == not->job) &&
E 6
       (!del || ((jobc->pid == not->pid) && (jobc->jexec == exe))) )
   {
    /* Eventuell nicht loeschen, nur melden */
D 5
    if ( !del ) return jobs;
E 5
I 5
    if ( del != 1 ) return jobs;
E 5
    /* Benutzer benachrichtigen */
D 5
    if ( !requeuejob(jobs,1) ) remjob(jobs,jobon(jobc),not->text);
E 5
I 5
D 19
    if ( !requeuejob(jobs,1) ) remjob(jobs,jobon(jobc),not->jdText);
E 19
I 19
    if ( !requeuejob(jobs,1) ) 
     {
I 20
      /* CPU-Zeit abtrennen */
      if ( seppos = strchr(not->jdText,'#') ) 
       {
	/* Nachricht abschliessen */
	*seppos++ = '\0';
	/* Text umwandeln */
	if ( ((cpu = atof(seppos)) < 0.0) || (cpu > INT_MAX) ) seppos = 0;
       }
E 20
      /* Zugehoerigen Kontrolljob suchen */
D 20
      if ( !jobc->leader && jobc->request.leader)
E 20
I 20
      if ( seppos && !jobc->leader && jobc->request.leader)
E 20
       {
	jobctrl *jobl = 0;
        execctrl *exec;
        genctrl *gen;
D 20
        char *seppos;
	double cpu;
E 20

	/* Suchen in den laufenden Jobs */	
	for ( gen = Gqueues ; gen && !jobl ; gen = gen->next )
	 for ( jobl = gen->Rjobs ; jobl ; jobl = jobl->next )
	  if ( jobl->leader == jobc->request.leader )
	   break;
	/* In den RPC-Fehlerwarteschlangen stehende Jobs */
	if ( !jobl )
	 for ( exec = Equeues ; exec ; exec = exec->next )
	  for ( jobl = exec->Ejobs ; jobl ; jobl = jobl->next )
	   if ( ISSUBMIT(jobl) && (jobl->leader == jobc->request.leader) )
	     break;
D 20
        /* CPU-Zeit abtrennen */
        if ( jobl && (seppos = strchr(not->jdText,'#')) ) 
         {
	  /* Nachricht abschliessen */
	  *seppos++ = '\0';
	  /* Text umwandeln */
	  if ( ((cpu = atof(seppos)) < 0.0) || (cpu > INT_MAX) )
           /* Parallelkontrolljob benachrichtigen */
           toleader(jobl,jobc->jobID,cpu);
	 }
E 20
I 20
	/* Parallelkontrolljob benachrichtigen */
        if ( jobl ) toleader(jobl,jobc->jobID,cpu);
E 20
       }
      /* Job entfernen */
      remjob(jobs,jobon(jobc),not->jdText);
     }
E 19
E 5
    /* Job gefunden */
    return jobs;
   }
 /* Nichts gefunden */
 return 0;
}

/*
  Loeschen aller zu einer EXEC-Queue gehoerigen Jobs. Zusaetzlich Loeschen aller
  noch ausstehender Acknowledgenachrichten.
*/
deljobs(exe,cause,clr)
execctrl *exe;
char *cause;
int clr;
{
 jobctrl *jobc,**jobs;
 genctrl *gen;

 /* Alle GEN-Queues durchsuchen */
 for ( gen = Gqueues ; gen ; gen = gen->next )
  /* Jobliste abarbeiten */
  for ( jobs = &gen->Rjobs ; jobc = *jobs ; )
   /* Entscheidenden Parameter vergleichen */
   if ( jobc->jexec != exe )
    jobs = &jobc->next;
   else if ( !requeuejob(jobs,0) )
    lostjob(jobs,cause);
 /* EXEC-Queue absuchen */
 for ( jobs = &exe->Ejobs ; jobc = *jobs ; )
D 6
  if ( jobc->Kind != sSUBMIT )
E 6
I 6
  if ( !ISSUBMIT(jobc) )
E 6
   {
    /* Aus der Backupdatei entfernen */
    backjob(jobc,-1);
    /* Ohne Meldung freigeben */
    *jobs = jobc->next;
    free_jobctrl(jobc);
   }
  else if ( !requeuejob(jobs,0) )
   lostjob(jobs,cause);
 /* Ausstehende Acknowledgemeldungen loeschen und in der Backupdatei vermerken */
 if ( clr )
  {
   exe->ack_len = 0;
   backexec(exe,0);
  }
}

/*
  Ein Job muss aus einer Liste entfernt und der Benutzer benachrichtigt werden.
*/
remjob(jp,mess1,mess2)
jobctrl **jp;
char *mess1,*mess2;
{
 jobctrl *jobc = *jp;
I 7
 struct passwd *usr;
 char *mess,*name;
E 7
I 3
D 5
 int leader;
E 5
I 5
 execctrl *exe;
E 5
E 3
D 7
 char *mess;
E 7

 /* Speicher bereitstellen */
 if ( mess = MALLOC(char,strlen(mess1)+strlen(mess2)+1) )
  {
   /* Text erstellen */
   strcpy(mess,mess1);
   strcat(mess,mess2);
   /* Logdatei fuellen */
   lprintf("%s\n",mess);
   /* Benutzer benachrichtigen */
D 5
   if ( *jobc->genReq.user && notify_user(jobc->genReq.host,jobc->genReq.user,mess) )
    jobc->genReq.host = jobc->genReq.user = 0;
   else
    free(mess);
E 5
I 5
   if ( *jobc->genReq.user ) 
    {
     /* Zuerst an die Maschine, von der der Befehl kam */
     notify_user(jobc->genReq.host,jobc->genReq.user,mess);
I 7
     /* Korrekten Benutzernamen verwenden */
     name = (usr = getpwuid(jobc->execReq.uid)) ? usr->pw_name : jobc->genReq.user;
E 7
     /* Dann an alle bekannten EXEC-Queues */
     for ( exe = Equeues ; exe ; exe = exe->next )
      if ( exe->status.IPaddr != jobc->genReq.host )
D 7
       notify_user(exe->status.IPaddr,jobc->genReq.user,mess);
E 7
I 7
       notify_user(exe->status.IPaddr,name,mess);
E 7
    }
   /* Aufraeumen */
   free(mess);
E 5
  }
 /* Zaehler korrigieren */
D 5
 if ( (jobc->state != jPENDING) && jobc->jexec ) 
  {
   jobc->jexec->jobs--;
   backexec(jobc->jexec,0);
  }
E 5
I 5
D 6
 if ( (jobc->state != jPENDING) && jobc->jexec ) jobc->jexec->jobs--;
E 6
I 6
 if ( !ISPENDING(jobc) && jobc->jexec ) jobc->jexec->jobs--;
E 6
 /* Alle Teiljobs eines Paralleljobs loeschen */
 rempar(jobc->leader);
E 5
 /* Aus der Backupdatei entfernen */
 backjob(jobc,-1);
I 3
D 5
 /* Parallelkontrolljob merken */
 leader = jobc->leader;
E 5
E 3
 /* Struktur loeschen */
 *jp = jobc->next;
 free_jobctrl(jobc);
I 3
D 5
 /* Alle Teiljobs eines Paralleljobs loeschen */
 rempar(leader);
E 5
E 3
}

/*
  Eine EXEC-Queue meldet sich nicht mehr, daher sind alle Jobs mit entsprechender
  Fehlermeldung zu eleminieren.
*/
lostjob(jp,cause)
jobctrl **jp;
char *cause;
{
 static char prebuf[128];

 /* Text fuer den Benutzer erzeugen */
 sprintf(prebuf,"%slost due to queue ",jobon(*jp));
 /* Meldung machen und Verwaltungsstruktur entfernen */
 remjob(jp,prebuf,cause);
I 19
}

/*
  Eintragen der verbrauchten CPU-Zeit eines Parallelteiljobs in die Liste des Paralleljobs.
*/
static toleader(parj,num,cpu)
jobctrl *parj;
ID num;
double cpu;
{
 parchan *newpar;
 long sec,usec;
 int anz;

 /* Platz schaffen */
 if ( parj->channels.kind == skNORMAL )
  {
   /* Leeres Element vom Typ 'parchans' */
   parj->channels.anychan_u.pchans.parchans_len = 0;
   parj->channels.anychan_u.pchans.parchans_val = 0;
  }
 /* Speicher reservieren */
 if ( !(newpar = MALLOC(parchan,(anz = parj->channels.anychan_u.pchans.parchans_len)+1)) ) return;
 /* Umkopieren */
 MEMMOVE(newpar,parj->channels.anychan_u.pchans.parchans_val,anz);
 /* Speicher freigeben */
 xdr_free(xdr_anychan,&parj->channels);
 /* Speicher uebernehmen */
 parj->channels.kind = skPARALLEL;
 parj->channels.anychan_u.pchans.parchans_len = anz+1;
 parj->channels.anychan_u.pchans.parchans_val = newpar;
 /* Zeiten ermitteln */
D 21
 if ( (usec = 1E+6*(cpu-(sec = cpu)+0.5)) >= 1000000 )
E 21
I 21
 if ( (usec = 1E+6*(cpu-(sec = cpu))+0.5) >= 1000000 )
E 21
  {
   sec++;
   usec -= 1000000;
  }
 /* Initialisieren */
 parj->channels.anychan_u.pchans.parchans_val[anz].PARchild = num;
 parj->channels.anychan_u.pchans.parchans_val[anz].PARsecs = sec;
 parj->channels.anychan_u.pchans.parchans_val[anz].PARusecs = usec;
 /* Veraenderung festhalten */
 backjob(parj,0);
E 19
}

/*
I 3
  Alle Subprozesse eines Paralleljobs abbrechen.
*/
static rempar(leader)
int leader;
{
 execctrl *exe;
 jobctrl *jobc;
 genctrl *gen;
 control ctrl;

 /* Nur, wenn es sich um einen Paralleljob handelt */
 if ( !leader ) return;
 /* Initialisieren */
 ctrl.next = 0;
 /* In den Genericqueues */
 for ( gen = Gqueues ; gen ; gen = gen->next )
  {
   /* Laufende Jobs */
   for ( jobc = gen->Rjobs ; jobc ; jobc = jobc->next )
    if ( jobc->request.leader == leader )
D 5
     abortjob(jobc,'P',&ctrl);
E 5
I 5
     abortjob(jobc,'R',&ctrl);
E 5
   /* Wartende Jobs */
   for ( jobc = gen->Pjobs ; jobc ; jobc = jobc->next )
    if ( jobc->request.leader == leader )
D 5
     abortjob(jobc,'R',&ctrl);
E 5
I 5
     abortjob(jobc,'P',&ctrl);
E 5
  }
 /* In den RPC-Fehlerwarteschlangen stehende Jobs */
 for ( exe = Equeues ; exe ; exe = exe->next )
  for ( jobc = exe->Ejobs ; jobc ; jobc = jobc->next )
D 6
   if ( jobc->request.leader == leader )
E 6
I 6
   if ( ISSUBMIT(jobc) && (jobc->request.leader == leader) )
E 6
    abortjob(jobc,'E',&ctrl);
}

/*
E 3
  Struktur fuer einen Job erzeugen und initialisieren.
*/
jobctrl *makejob(gen,job)
genctrl *gen;
submit *job;
{
 jobctrl *jobc;

 /* Speicher allokatieren */
D 3
 if ( !(jobc = MALLOC(jobctrl,1)) ) return 0;
E 3
I 3
 if ( !(jobc = SALLOC(jobctrl)) ) return 0;
E 3
 /* Struktur initialisieren */
 jobc->request = *job;
I 16
D 17
 jobc->request.rmsfile &= ~RMS_RESTART;
E 17
I 17
 jobc->execReq.rmsfile &= ~RMS_RESTART;
E 17
E 16
 jobc->genReq.requeue[0] = '\0';
 jobc->next = 0;
 jobc->state = jNORMAL;
 jobc->back.pos = -1;
 jobc->Jexec.hide = jobc->Jgen.hide = TRUE;
 jobc->jexec = 0;
 jobc->jgen = gen;
I 3
 jobc->leader = 0;
 jobc->channels.kind = skNORMAL;
E 3
 /* Uebergabestruktur aufraeumen */ 
D 5
 job->qinfo.queue = job->qinfo.host = job->qinfo.user = job->qinfo.requeue = job->name = 0;
E 5
I 5
 job->qinfo.queue = job->qinfo.user = job->qinfo.requeue = job->name = 0;
 job->hosts.hints_len = 0;
 job->hosts.hints_val = 0;
E 5
D 3
 if ( job->info.kind != sCANCEL )
E 3
I 3
D 6
 if ( (job->info.kind != sCANCEL) && (job->info.kind != sCONVERTER) )
E 6
I 6
 if ( ISSUBMIT(jobc) )
E 6
E 3
  {
D 5
   job->Jinfo.shell = job->Jinfo.script = job->Jinfo.log = 0;
E 5
I 5
   job->Jinfo.shell = job->Jinfo.script = job->Jinfo.log = job->Jinfo.print = 0;
E 5
   job->Jinfo.param.param_len = 0;
   job->Jinfo.param.param_val = 0;
   /* Neuen Job nummerieren */
   jobc->pid = -100;
D 18
   jobc->jobID = ++jobCnt;
E 18
I 18
   jobc->jobID = allocJob();
E 18
I 3
D 5
   /* Jobleader in Parallelqueues erzeugen */
   if ( *gen->pdl ) jobc->leader = ++parCnt;
E 5
E 3
  }
I 6
 else
  jobc->request.leader = 0;
E 6
 /* Ergebnis melden */
 return jobc;
}

/*
  Alle Queues durchgehen und wartende Jobs bearbeiten. Dabei werden zuerst die Jobs
  der RPC-Fehlerqueue (Ejobs), dann die wirklich wartenden Jobs (Pjobs) bearbeitet.
*/
dojobs()
{
 static prebuf[128],mess[128];
 jobctrl *jobc,**jp,*zero = 0,*nj;
 statusinfo info;
 execctrl *exec;
 genctrl *gen;
 long now;

 /* Alle RPC-Fehler in den EXEC-Queues */
 for ( ctrlCnt++, exec = Equeues ; exec ; exec = exec->next )
  {
   /* Nachsehen, ob die Queue noch lebt */
   info.name = 0;
D 6
   if ( exec->jobs && !exec->Ejobs && (exec->status.queueID && (exec->retry > 0)) )
E 6
I 6
   if ( exec->jobs && !exec->Ejobs && exec->status.queueID && (exec->retry > 0) )
E 6
    if ( !status(&exec->cl,exec->status.IPaddr,&info) )
     {
      /* Erneuter RPC-Fehler */
      exec->retry--;
      exec->ctrl = ctrlCnt;
     }
    else
     {
      /* Hat sich zumindest gemeldet */
      exec->retry = RETRY0;
      free(info.name);
     }
   /* Fehlerhafte RPC-Auftraege erneut verschicken */
   for ( jp = &exec->Ejobs ; jobc = *jp ; )
    if ( !exec->status.queueID || (exec->retry <= 0) )
     break;
    else if ( jobc->Kind == sSUBMIT )
     if ( jobc->state == jABORTING )
      {
       /* Job soll eleminiert werden */
       *mess = '\0';
D 11
       if ( !killjob(jobc,mess) )
E 11
I 11
       if ( !killjob(jobc,mess,0) )
E 11
	{
         exec->ctrl = ctrlCnt;
	 break;
        }
       /* Job laeuft jetzt in jedem Fall */
       *jp = jobc->next;
       addTail(&jobc->jgen->Rjobs,jobc);
       /* Es koennen noch Fehler aufgetreten sein */
       if ( *mess ) jobc->state = jNORMAL;
       /* In der Backupdatei aendern */
       backjob(jobc,0);
      }
     else if ( !startjob(exec,jobc,mess) )
      {
       /* Job wurde bearbeitet, konnte aber nicht gestartet werden */
       sprintf(prebuf,"%snot started: ",jobon(jobc));
       remjob(jp,prebuf,mess);
      }
     else if ( jobc->pid < 0 )
      {
       exec->ctrl = ctrlCnt;
       break;
      }
     else if ( jobc->state == jABORTPENDING )
      {
       /* Job wird etwas aufgewertet */
       jobc->state = jABORTING;
       /* In der Backupdatei aendern */
       backjob(jobc,0);
       continue;
      }
     else
      {
       /* Job laeuft jetzt */
       *jp = jobc->next;
       addTail(&jobc->jgen->Rjobs,jobc);
       /* In der Backupdatei aendern */
       backjob(jobc,0);
      }
I 3
    else if ( jobc->Kind == sCONVERTER )
     {
I 5
      /* Eventuell Prozesskennung zuordnen */
      if ( jobc->request.Cinfo.pid < 0 )
       /* Alle Queues nach dem Job absuchen */
       for ( gen = Gqueues ; gen ; gen = gen->next )
	for ( nj = gen->Rjobs ; nj ; nj = nj->next )
	 if ( nj->jobID == -jobc->request.Cinfo.pid )
	  {
	   jobc->request.Cinfo.pid = nj->pid;
	   break;
	  }
E 5
      /* Konverterkanal soll geschlossen werden */
      *mess = '\0';
D 5
      if ( !killconverter(&jobc->request,exec,mess) )
E 5
I 5
      if ( (jobc->request.Cinfo.pid > 0) && !killconverter(&jobc->request,exec,mess) )
E 5
       {
        exec->ctrl = ctrlCnt;
	break;
       }
      /* Aus der Backupdatei entfernen */
      backjob(jobc,-1);
      /* Kontrollinformationen werden nicht mehr benoetigt */
      *jp = jobc->next;
      free_jobctrl(jobc);
     }
E 3
    else
     {
      /* Job soll eleminiert werden */
      *mess = '\0';
D 11
      if ( !killjob(jobc,mess) )
E 11
I 11
      if ( !killjob(jobc,mess,jobc->request.at) )
E 11
       {
        exec->ctrl = ctrlCnt;
	break;
       }
      /* Bei Fehler eventuell Informationen korrigieren */
D 11
      if ( *mess )
E 11
I 11
      if ( *mess && !jobc->request.at )
E 11
       for ( nj = jobc->jgen->Rjobs ; nj ; nj = nj->next )
        if ( nj->jobID == -jobc->execSig.requestID )
         {
          nj->state = jNORMAL;
          /* In der Backupdatei aendern */
          backjob(nj,0);
          break;
         }
      /* Aus der Backupdatei entfernen */
      backjob(jobc,-1);
      /* Kontrollinformationen werden nicht mehr benoetigt */
      *jp = jobc->next;
      free_jobctrl(jobc);
     }    
   /* Ist die EXEC-Queue nicht mehr funktionsfaehig, werden alle Jobs eleminiert */
   if ( !exec->status.queueID || (exec->retry <= 0) ) deljobs(exec,"stalled",0);
  }
 /* Uhrzeit ermitteln */
 time(&now);
 /* Alle wartenden Jobs bearbeiten */
 for ( gen = Gqueues ; gen ; gen = gen->next )
D 5
  if ( !master.stopped && (gen->state != qSTOPPED) )
   for ( jp = &gen->Pjobs ; jobc = *jp ; )
E 5
I 5
  for ( jp = &gen->Pjobs ; jobc = *jp ; )
   if ( jobc->state == jPENDINGABORT )
D 6
    {
     /* Korrekte Meldung aufsetzen und Job entfernen */
     if ( jobc->jexec )
      strcpy(mess,jobon(jobc));
     else
      sprintf(mess,"Job %d on queue %s ",jobc->jobID,gen->name);
     remjob(jp,mess,"aborted before execution");
    }
   else if ( !master.stopped && (gen->state != qSTOPPED) )
E 6
I 6
    /* Job entfernen */
    remjob(jp,jobon(jobc),"aborted before execution");
   else if ( master.stopped || (gen->state == qSTOPPED) )
    jp = &jobc->next;
   else
E 6
E 5
    if ( (jobc->request.hold == 1) || (!jobc->request.hold && (jobc->request.at > now)) )
     jp = &jobc->next;
D 3
    else if ( !(exec = ALGO(Adispatch,gen,jobc->jexec)) )
E 3
I 3
    else if ( !(exec = ALGO(Adispatch,gen,jobc->jexec,&jobc->request.hosts)) )
E 3
     if ( !jobc->jexec )
      break;
     else
      {
       jobc->jexec->ctrl = ctrlCnt;
       jp = &jobc->next;
      }
    else if ( !exec->Ejobs && !exec->ack_len && !startjob(exec,jobc,mess) )
     {
      /* Job wurde bearbeitet, konnte aber nicht gestartet werden */
      sprintf(prebuf,"%snot started: ",jobon(jobc));
      remjob(jp,prebuf,mess);
     }
    else
     {
      /* Job aus der Warteschlange entfernen */
      *jp = jobc->next;
      jobc->state = jNORMAL;
      /* Strukturen fuellen */
      jobc->jexec = exec;
      exec->jobs++;
      /* Startzeit eintragen */
      jobc->dispatch = now;
      /* Und in die richtige Liste einhaengen */
      if ( jobc->pid < 0 )
       {
	/* RPC-Fehler aufgetreten */
	addTail(&exec->Ejobs,jobc);
	jpinfo(jobc,"pending",mess);
       }
      else
       {
	/* Job wurde wirklich gestartet */
	addTail(&gen->Rjobs,jobc);
	jpinfo(jobc,"started",mess);
       }
      /* Und in der Backupdatei aendern */
      backjob(jobc,0);
     }
}

/*
  Zustand eines Jobs ermitteln.
*/
jobkind(jpp,jID,gen,exe)
jobctrl ***jpp;
ID jID;
genctrl *gen;
execctrl *exe;
{
 jobctrl *jobc;
 execctrl *ex;
 jobdone done;

 /* Suche durch alle Queues */
 if ( !gen )
  {
   /* Alle GEN-Queues */
   for ( gen = Gqueues ; gen ; gen = gen->next )
    {
     /* Laufende Jobs */
     for ( *jpp = &gen->Rjobs ; jobc = **jpp ; *jpp = &jobc->next )
      if ( jobc->jobID == jID )
       return 'R';
     /* Wartende Jobs */
     for ( *jpp = &gen->Pjobs ; jobc = **jpp ; *jpp = &jobc->next )
      if ( jobc->jobID == jID )
       return 'P';
    }
   /* Alle EXEC-Queue */
   for ( exe = Equeues ; exe ; exe = exe->next )
    for ( *jpp = &exe->Ejobs ; jobc = **jpp ; *jpp = &jobc->next )
D 6
     if ( jobc->jobID == jID )
E 6
I 6
     if ( ISSUBMIT(jobc) && (jobc->jobID == jID) )
E 6
      return 'E';
   /* Nichts gefunden */
   return 0;
  }
 /* Kontrollstruktur aufsetzen */
 done.job = jID;
 /* Wartende Jobs durchsuchen */
 if ( (*jpp = findjob((execctrl *)0,&gen->Pjobs,&done,0)) && ((jobc = **jpp)->jexec == exe) )
  return 'P';
 /* Normal laufende Jobs durchsuchen */
 if ( (*jpp = findjob((execctrl *)0,&gen->Rjobs,&done,0)) &&
      (((jobc = **jpp)->jexec == exe) || !exe) )
  return 'R';
 /* Fehlerhafte Jobs durchsuchen */
 for ( ex = Equeues ; ex && !(*jpp = findjob(ex,&ex->Ejobs,&done,0)) ; ex = ex->next );
 if ( ex && ((jobc = **jpp)->jgen == gen) && ((jobc->jexec == exe) || !exe) ) return 'E';
 /* Nicht vorhanden */
 return 0;
}

/*
  Testen eines Wertes gegen eine Grenze unter etwaiger Benutzung eines Defaultwertes.
*/
static cut_value(vp,def,max,fact)
int *vp,def,max,fact;
{
 if ( *vp <= 0 )
  *vp = def;
 else if ( (max > 0) && (*vp > max) )
  *vp = max;
 if ( *vp > 0 ) *vp *= fact;
}

/*
  Liste von Jobs mit stoppen und eventuell in einer anderen Queue neu starten.
*/
abortjobs(jobl,kind,ctrl)
jobctrl *jobl;
int kind;
control *ctrl;
{
 /* Alle Jobs einzeln bearbeiten */
 for ( ; jobl ; jobl = jobl->next ) abortjob(jobl,kind,ctrl);
}

/*
  Job stoppen und je nach Benutzerwunsch spaeter in einer anderen Queue neu
  starten.
*/
abortjob(job,kind,ctrl)
jobctrl *job;
int kind;
control *ctrl;
{
 static char mess[256];
 char *nq;

 /* Bei STOP/QUEUE/NEXT erfolgt keine Beeinflussung der Jobs */
D 5
 if ( ctrl->next == 1 ) return;
E 5
I 5
D 6
 if ( (kind != 'P') && (ctrl->next == 1) ) return;
E 6
I 6
 if ( ISSUBMIT(job) && (kind != 'P') && (ctrl->next == 1) ) return;
E 6
E 5
 /* Ansonsten wird der Job erst einmal gestopped */
D 11
 sendkill(job,kind,mess,(submit *)0);
E 11
I 11
 sendkill(job,kind,mess,(submit *)0,0);
E 11
D 5
 /* STOP/QUEUE ist erfordert niemals einen Neustart */
 if ( *mess || !ctrl->next || !job->request.restart ) return;
E 5
I 5
 /* STOP/QUEUE erfordert niemals einen Neustart */
D 6
 if ( *mess || (ctrl->next == 1) || !ctrl->next || !job->request.restart ) return;
E 6
I 6
 if ( *mess || (kind == 'P') || !ctrl->next || !job->request.restart ) return;
E 6
E 5
 /* Name der neuen Queue ermitteln */
 if ( !(nq = strdup(*ctrl->requeue ? ctrl->requeue : job->genReq.queue)) ) return;
 /* Name der neuen Queue uebertragen */
 free(job->genReq.requeue);
 job->genReq.requeue = nq;
 /* Eventuell Parameter aendern */
 if ( ctrl->hold == 1 ) job->request.hold = 1;
 if ( ctrl->prio >= 0 )
  {
   job->execReq.nice = ctrl->prio;
D 5
   cutjob(&job->request,job->jgen,ufPRIORITY);
E 5
I 5
   cutjob(&job->request,job->jgen,ufPRIORITY,0);
E 5
  }
 /* Und in der Backupdatei vermerken */
 backjob(job,0);
}

/*
  Signal zum Stoppen eines Jobs an eine EXEC-Queue schicken.
*/
D 11
sendkill(job,kind,msg,sub)
E 11
I 11
sendkill(job,kind,msg,sub,flags)
E 11
jobctrl *job;
D 11
int kind;
E 11
I 11
int kind,flags;
E 11
char *msg;
submit *sub;
{
 static submit sbuf;
 jobctrl *nj;

 /* Fehlermeldung initialisieren */
 *msg = '\0';
 if ( kind == 'R' )
  {
   /* Laufender Job */
D 11
   if ( job->jexec->Ejobs || job->jexec->ack_len || !killjob(job,msg) )
E 11
I 11
D 13
   if ( job->jexec->Ejobs || job->jexec->ack_len || !killjob(job,msg,flags) )
E 13
I 13
   if ( job->jexec->Ejobs || job->jexec->ack_len || flags || !killjob(job,msg,flags) )
E 13
E 11
    {
     /* Kontrollstruktur erzeugen, falls noetig */
     if ( !sub )
      {
       /* Speicher reservieren */
       sbuf.qinfo.queue = strdup("");
D 5
       sbuf.qinfo.host = strdup("");
E 5
I 5
       sbuf.qinfo.host = ntohl(INADDR_ANY);
E 5
       sbuf.qinfo.user = strdup("");
       sbuf.qinfo.requeue = strdup("");
       sbuf.name = strdup("");
D 5
       if ( sbuf.qinfo.queue && sbuf.qinfo.host && sbuf.qinfo.user && 
	    sbuf.qinfo.requeue && sbuf.name )
E 5
I 5
       sbuf.hosts.hints_len = 0;
       sbuf.hosts.hints_val = 0;
       if ( sbuf.qinfo.queue && sbuf.qinfo.user && sbuf.qinfo.requeue && sbuf.name )
E 5
        (sub = &sbuf)->info.kind = sCANCEL;
       else
        xdr_free(xdr_submit,&sbuf);
      }
     /* Befehl in die RPC-Fehlerliste haengen */
     if ( !sub || !(nj = makejob(job->jgen,sub)) )
      strcpy(msg,"Out of memory during abortion");
     else
      {
       /* Struktur auffuellen und anhaengen */
       nj->jexec = job->jexec;
       nj->execSig.pid = nj->pid = job->pid;
D 13
       nj->execSig.requestID = -job->jobID;
I 11
       nj->request.at = flags;
       if ( flags == ufSUSPEND )
	nj->execSig.requestID -= 0x40000000;
       else if ( flags == ufRESUME )
	nj->execSig.requestID -= 0x20000000;
E 13
I 13
       if ( nj->request.at = flags )
D 18
	nj->execSig.requestID = -(++jobCnt);
E 18
I 18
	nj->execSig.requestID = -allocJob();
E 18
       else
        nj->execSig.requestID = -job->jobID;
E 13
E 11
D 14
       addTail(&job->jexec->Ejobs,&nj);
E 14
I 14
       addTail(&job->jexec->Ejobs,nj);
E 14
       /* In die Backupdatei eintragen */
       backjob(nj,1);
      }
     /* Speicher freigeben */
     if ( sub == &sbuf ) xdr_free(xdr_submit,&sbuf);
    }
   /* Job markieren */
D 12
   if ( !*msg ) 
E 12
I 12
   if ( !*msg && !flags ) 
E 12
    {
     job->state = jABORTING;
     /* In der Backupdatei vermerken */
     backjob(job,0);
    }
  }
 else if ( kind == 'E' )
  {
   /* Job in der RPC-Fehlerliste einer EXEC-Queue */
   job->state = jABORTPENDING;
   /* In der Backupdatei vermekrne */
   backjob(job,0);
  }
I 5
 else if ( kind == 'P' )
  {
   /* Job in der Warteschlange demnaechst entfernen */
   job->state = jPENDINGABORT;
   /* In der Backupdatei vermekrne */
   backjob(job,0);
  }
E 5
}

/*
I 3
  Nachricht an einen Konverter schicken, um einen Kanal zu elemenieren. Als Folge davon
  wird das angeschlossenen Parallelteilprogramm sauber beendet.
*/
sendconverter(jobc,msg,sub)
jobctrl *jobc;
char *msg;
submit *sub;
{
 jobctrl *nj;

 /* Initialisierung */
 *msg = '\0';
 /* Eindeutige Kennung erzeugen */
D 18
 sub->Cinfo.requestID = -(++jobCnt);
E 18
I 18
 sub->Cinfo.requestID = -allocJob();
E 18
 /* Befehl abschicken */
 if ( jobc->jexec->Ejobs || jobc->jexec->ack_len || !killconverter(sub,jobc->jexec,msg) )
  /* Befehl in die RPC-Fehlerliste haengen */
  if ( !(nj = makejob(jobc->jgen,sub)) )
D 5
   strcpy(msg,"Out of memory during killing converter channel");
E 5
I 5
   strcpy(msg,"Out of memory while killing converter channel");
E 5
  else
   {
    /* Struktur auffuellen und anhaengen */
    nj->jexec = jobc->jexec;
    nj->execConv = sub->Cinfo;
D 15
    addTail(&jobc->jexec->Ejobs,&nj);
E 15
I 15
    addTail(&jobc->jexec->Ejobs,nj);
E 15
    /* In die Backupdatei eintragen */
    backjob(nj,1);
   }
}

/*
E 3
  Fertigen oder abgebrochenen Job in einer eventuell anderen Queue neu starten.
*/
requeuejob(jp,really)
jobctrl **jp;
int really;
{
I 3
D 5
 static char buf[256];
E 5
E 3
 jobctrl *jobc = *jp;
 execctrl *exe;
 genctrl *gen;
I 6
 char *swap;
E 6
I 3
D 5
 long addr;
 char *np;
E 5
E 3

 /* Nur unter bestimmten Umstaenden */
D 3
 if ( !jobc->request.restart || (really && !*jobc->genReq.requeue) ) return 0;
E 3
I 3
 if ( !jobc->request.restart || (really && !*jobc->genReq.requeue) || jobc->request.leader )
  return 0;
E 3
 /* Neue Queue ermitteln */
 if ( !findpair(really ? jobc->genReq.requeue : jobc->genReq.queue,&gen,&exe,(char *)0) )
  return 0;
D 5
 /* EXEC-Queue aktualisieren */
 if ( (jobc->state != jPENDING) && jobc->jexec )
E 5
I 5
 /* Paralleljobs duerfen nicht in normale Queues und umgekehrt */
 if ( (*jobc->jgen->pdl == '\0') != (*gen->pdl == '\0') ) return 0;
 /* Shell eventuell aendern */
 if ( !makeshell(&jobc->request,gen) ) return 0;
 /* Parallelinformationen aktualisieren */
 if ( jobc->leader )
E 5
  {
D 5
   jobc->jexec->jobs--;
   backexec(jobc->jexec,0);
E 5
I 5
   /* Alte Teiljobs entfernen */
   rempar(jobc->leader);
   /* Ein bisschen aufraeumen */
I 6
   free(jobc->Param_val[0]);
E 6
   MEMMOVE(jobc->Param_val+0,jobc->Param_val+1,--jobc->Param_len);
   /* Neuen Parallelidentifier vergeben */
   if ( !makeparallel(&jobc->request,jobc->leader = ++parCnt) ) return 0;
E 5
  }
I 5
 /* EXEC-Queue aktualisieren */
D 6
 if ( (jobc->state != jPENDING) && jobc->jexec ) jobc->jexec->jobs--;
E 6
I 6
 if ( !ISPENDING(jobc) && jobc->jexec ) jobc->jexec->jobs--;
E 6
 /* Parameter anpassen */
I 16
D 17
 jobc->request.rmsfile |= RMS_RESTART;
E 17
I 17
 jobc->execReq.rmsfile |= RMS_RESTART;
E 17
E 16
D 6
 cutjob(&jobc->request,jobc->jgen,1);
E 6
I 6
 cutjob(&jobc->request,jobc->jgen,-1,1);
E 6
 cutjob(&jobc->request,gen,-1,0);
I 6
 /* Name der neuen Queue einsetzen */
 if ( really )
  {
   swap = jobc->genReq.queue;
   jobc->genReq.queue = jobc->genReq.requeue;
   *(jobc->genReq.requeue = swap) = '\0';
  }
E 6
E 5
 /* Job aus seiner Queue entfernen und in der anderen vermerken */
 *jp = jobc->next;
D 6
 jobc->genReq.requeue[0] = '\0';
E 6
 jobc->jgen = gen;
 jobc->jexec = exe;
 jobc->state = jPENDING;
 jobc->pid = -100;
 addTail(&gen->Pjobs,jobc);
I 3
D 5
 /* Parallelinformationen aktualisieren */
 if ( jobc->leader )
  {
   /* Alte Teiljobs entfernen */
   rempar(jobc->leader);
   /* Neuen Parallelidentifier vergeben */
   jobc->leader = ++parCnt;
   /* Neuen ersten Parameter erzeugen */
   addr = htonl(master.addr);
   sprintf(buf,"%s,%d,%d,%d",INET_NTOA(addr),GENPROG,GENVERS,jobc->leader);
   if ( !(np = strdup(buf)) ) 
    {
     /* Fehler anzeigen */
     lprintf("Out of memory during restart, job %d not restarted\n",jobc->jobID);
     return 0;
    }
   /* Parameter eintragen */
   free(jobc->execReq.param.param_val[0]);
   jobc->execReq.param.param_val[0] = np;
  }
E 5
E 3
 /* In der Backupdatei vermerken */
 backjob(jobc,0);
 /* Erfolg melden */
 return 1;
}
E 1
