h42085
s 00004/00000/00257
d D 5.1 91/08/15 08:58:51 jochen 9 8
c TRANSFERSIZE is now dynamic and initialized from the environment
e
s 00003/00000/00254
d D 4.3 91/04/02 14:44:25 jochen 8 7
c Only EXEC-Servers in NETGROUP accepted
e
s 00040/00037/00214
d D 4.2 91/02/26 11:35:48 jochen 7 6
c Minor correction for QMan
e
s 00000/00000/00251
d D 4.1 91/02/20 13:26:36 jochen 6 5
c RPC number 390326 now reserved by SUN
e
s 00014/00011/00237
d D 3.3 91/02/20 13:19:57 jochen 5 4
c Parallel support added
e
s 00001/00001/00247
d D 3.2 91/01/15 15:26:33 jochen 4 3
c usage of SCCSIDS corrected
e
s 00001/00001/00247
d D 3.1 91/01/08 09:54:43 jochen 3 2
c IP address handling modified
e
s 00004/00001/00244
d D 2.2 91/01/04 11:05:35 jochen 2 1
c keep track of 'errno' in SIGNAL-handler
e
s 00245/00000/00000
d D 2.1 91/01/02 15:26:51 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 4
I 4
D 5
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 5
I 5
static char sccsid_sgen_init_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 5
E 4
#endif

#define SGEN_INIT

#include "sgen_hdr.h"

static int disabled = 0;
static void (*genprog)() = 0;


/*
  Diese Initialisierungsroutine wird aufgerufen, bevor das Programm in
  den Servermode uebergeht. Hier findet die Inititialisierung aller
  globaler Variablen sowie ein etwaiges Nachladen von Informationen
  statt.
*/
void initialize()
{
 static int periodic();
 char *param,*qname,*qdef,*mess;
I 7
 struct itimerval tim;
E 7
 ID genCnt0;
 int now;

 /* Generelle Initialisierung */
 reinit(0);
 /* Uhrzeit bestimmen */
 uniqueCnt = time(&now);
 /* Logdatei oeffnen */
D 5
 if ( param = getenv("LOGFILE") )
  if ( !strcmp(param,"stderr") )
E 5
I 5
 if ( logfile = getenv("LOGFILE") )
  if ( !strcmp(logfile,"stderr") )
E 5
   logf = 2;
D 5
  else if ( !strcmp(param,"stdout") )
E 5
I 5
  else if ( !strcmp(logfile,"stdout") )
E 5
   logf = 1;
  else
D 5
   logf = open(param,O_WRONLY|O_CREAT|O_APPEND,0755);
E 5
I 5
   logf = open(logfile,O_WRONLY|O_CREAT|O_APPEND,0755);
E 5
 /* Start melden */
 lprintf("%s started at %s",VERSION,ctime(&now));
I 8
 /* Netzwerkgruppe ermitteln */
 if ( !(netgroup = getenv("NETGROUP")) ) netgroup = NETGROUP;
 lprintf("Using netgroup %s\n",netgroup);
E 8
 /* Parameter der EXEC-Server ermitteln */
D 7
 get_envnum(&progexec,"EXECPROG");
 get_envnum(&versexec,"EXECVERS");
 lprintf("Contacting EXEC-Server via RPC (0x%08X,%u)\n",progexec,versexec);
E 7
I 7
 get_envnum(&master.EXECprog,"EXECPROG");
 get_envnum(&master.EXECvers,"EXECVERS");
 lprintf("Contacting EXEC-Server via RPC (%d,%u)\n",master.EXECprog,master.EXECvers);
E 7
 /* Parameter der NOTIFY-Server ermitteln */
D 7
 get_envnum(&prognotify,"NOTIFYPROG");
 get_envnum(&versnotify,"NOTIFYVERS");
 lprintf("Contacting NOTIFY-Server via RPC (0x%08X,%u)\n",prognotify,versnotify);
E 7
I 7
 get_envnum(&master.NOTIFYprog,"NOTIFYPROG");
 get_envnum(&master.NOTIFYvers,"NOTIFYVERS");
 lprintf("Contacting NOTIFY-Server via RPC (%d,%u)\n",master.NOTIFYprog,master.NOTIFYvers);
I 9
 /* Transfergroesse einlesen */
 get_envnum(&transfersize,"TRANSFERSIZE");
 lprintf("Using TRANSFERSIZE of %d bytes\n",transfersize);
E 9
E 7
 /* Backupdatei oeffnen, falls gewuenscht */
D 5
 if ( param = getenv("BACKUPFILE") )
E 5
I 5
 if ( backupfile = getenv("BACKUPFILE") )
E 5
  {
   /* Eventuell alten Zustand einlesen */
D 5
   if ( (bakf = open(param,O_RDONLY)) > 0 )
E 5
I 5
D 7
   if ( (bakf = open(backupfile,O_RDONLY)) >= 0 )
E 7
I 7
   if ( (bakf = open(backupfile,O_RDONLY)) != -1 )
E 7
E 5
    {
     if ( restall() )
D 5
      lprintf("Information successfully restored from BACKUPFILE=%s\n",param);
E 5
I 5
      lprintf("Information successfully restored from BACKUPFILE=%s\n",backupfile);
E 5
     else
      {
D 5
       lprintf("Could not restore from BACKUPFILE=%s\n",param);
E 5
I 5
       lprintf("Could not restore from BACKUPFILE=%s\n",backupfile);
E 5
       reinit(1);
      }
     close(bakf);
    }
   /* Datei zum Schreiben oeffnen */
D 5
   bakf = open(param,O_RDWR|O_CREAT|O_TRUNC,0755);
E 5
I 5
   bakf = open(backupfile,O_RDWR|O_CREAT|O_TRUNC,0755);
E 5
  }
 /* Alle Queues ermitteln und die zugehoreigen Parameter einlesen */
 if ( !(param = getenv("QUEUES")) )
  {
   lprintf("No QUEUES definition found\n");
   exit(1);
  }
 /* Alle GEN-Queues ermitteln und definieren */
 genCnt0 = genCnt;
D 7
 do
  {
   /* Aktueller Name */
   qname = param;
   /* Trennzeichen suchen */
   if ( param = strchr(param,':') ) *param++ = '\0';
   /* Environmentvariable ermitteln */
   if ( !*qname )
    {
     lprintf("Empty field in QUEUES definition\n");
     exit(1);
    }
   if ( !(qdef = getenv(qname)) ) 
    {
     lprintf("No further information on queue %s\n",qname);
     exit(1);
    }
   /* Definitionsblock aufbauen */
   if ( mess = get_queue(qdef,genCnt0) )
    {
     lprintf("Queue %s definition error: %s\n",qname,mess);
     exit(1);
    }
  }
 while ( param ); 
E 7
I 7
 if ( *param )
  do
   {
    /* Aktueller Name */
    qname = param;
    /* Trennzeichen suchen */
    if ( param = strchr(param,':') ) *param++ = '\0';
    /* Environmentvariable ermitteln */
    if ( !*qname )
     {
      lprintf("Empty field in QUEUES definition\n");
      exit(1);
     }
    if ( !(qdef = getenv(qname)) ) 
     {
      lprintf("No further information on queue %s\n",qname);
      exit(1);
     }
    /* Definitionsblock aufbauen */
    if ( mess = get_queue(qdef,genCnt0) )
     {
      lprintf("Queue %s definition error: %s\n",qname,mess);
      exit(1);
     }
   }
  while ( param ); 
E 7
 /* Nebenprozess zum Suchen der EXEC-Server installieren */
 signal(SIGALRM,SIG_IGN);
 switch (epid = fork())
  {
D 7
   case  0 : executers();
E 7
I 7
   case  0 : executers(master.EXECprog,master.EXECvers);
E 7
   case -1 : lprintf("Could not start broadcaster\n");
     	     exit(1);
   default : lprintf("Started broadcaster process %d\n",epid);
  }
 /* Backupdatei beschreiben */
 backall();
 /* Zeittakt starten */
 signal(SIGALRM,periodic);
D 7
 periodic();
E 7
I 7
 tim.it_interval.tv_sec = tim.it_value.tv_sec = 1;
 tim.it_interval.tv_usec = tim.it_value.tv_usec = 0;
 setitimer(ITIMER_REAL,&tim,(struct itimerval *)0);
E 7
 /* Servermode aktivieren */
 return svc_run();
}

/*
  Initialisierung einiger genereller Parameter.
*/
reinit(really)
int really;
{
 static char me[MAXHOSTNAMELEN];

 /* Alle Listen und Zaehler loeschen */
D 5
 backCnt = genCnt = execCnt = jobCnt = ctrlCnt = turn = 0;
E 5
I 5
 backCnt = genCnt = execCnt = jobCnt = ctrlCnt = parCnt = turn = 0;
 transtick = transcur = 1;
E 5
 Equeues = 0;
 Gqueues = 0;
 todo = 0;
 IDs = 0;
 if ( really ) return;
 /* Maschineninformationen aufsetzen */
 gethostname(me,sizeof(me));
 master.name = me;
D 3
 master.addr = gethostid();
E 3
I 3
 master.addr = ntohl(gethostid());
E 3
 master.stopped = 0;
 /* Restliche globale Variablen initialisieren */
D 7
 logf = bakf = progexec = versexec = prognotify = versnotify = -1;
E 7
I 7
 master.EXECprog = master.EXECvers = master.NOTIFYprog = master.NOTIFYvers = -1;
I 9
 transfersize = TRANSFERSIZE;
E 9
 logf = bakf = -1;
E 7
 bball = ball = 0;
 disabled = 0;
 bfree = 0;
 bbuf = 0;
}

/*
  RPC-Programm anmelden und spaetere Umlenkung des Aufrufs vorbereiten.
*/
doregister(xprt,prognum,versnum,dispatch,protocol)
SVCXPRT *xprt;
u_long prognum,versnum,protocol;
void (*dispatch)();
{
 static void dolock();

 /* Kontrolltest */
 if ( !dispatch || (genprog && (genprog != dispatch)) )
  {
   fprintf(stderr,"svc_register redirection did not work\n");
   exit(1);
  }
 /* Information vermerken */
 genprog = dispatch;
 /* Und umgelenkten RPC-Server anmelden */
 return svc_register(xprt,prognum,versnum,dolock,protocol);
}

/*
  Lese eine Environmentvariable und wandele das Ergebnis in eine Zahl um, falls
  das moeglich ist.
*/
static get_envnum(np,ename)
int *np;
char *ename;
{
 char *env,*more = 0;
 
 /* Variable suchen */
 if ( !(env = getenv(ename)) )
  {
   lprintf("No value for %s found\n",ename);
   exit(1);
  }
 /* Nummer einlesen */
 errno = 0;
 if ( (((*np = strtoul(env,&more,0)) == -1) && errno) || !more || *more || (more == env) )
  {
   lprintf("Invalid value %s for %s\n",env,ename);
   exit(1);
  }
}
 
/*
  Abarbeitung gewisser periodischer Aufgaben.
*/
static periodic()
{
 static int ticks = 1;
I 2
 int keeperr = errno;
E 2

 /* Intervall abtesten */
 if ( !--ticks )
  if ( disabled )
   /* Zeit so genau wie moeglich halten */
   ticks = 1;
  else
   {
    /* EXEC-Queues benachrichtigen */
    doAck();
    /* Benutzer benachrichtigen */
    donotify();
    /* Jobs in den diversen Warteschlangen benachrichtigen */
    dojobs();
    /* Schliesslich noch die Liste eindeutiger IDs */
    dounique();
I 5
    /* Und die Transfermessungen */
    dotransfer();
E 5
    /* Intervallzaehler erneuern */
    ticks = INTERVALL;
   }
D 7
 /* Neu aktivieren */
 alarm(1);
E 7
I 2
 /* Fehlercode uebernehmen */
 errno = keeperr;
E 2
}

/*
  RPC-Server Aktion unter Sperren der Queues durchfuehren. Das ist noetig,
  damit beim Auslesen der Informationen der GEN-Queue ueber die 'master'
  Struktur nicht waehrend des Transfers innerhalb der RPC/XDR-Library
  durch Aktionen von 'periodic' Strukturen verschwinden oder Zeiger
D 2
  veraendert werden. Aenhliche Probleme treten bei praktischen allen
E 2
I 2
  veraendert werden. Aehnliche Probleme treten bei praktischen allen
E 2
  RPC-Routinen auf.
*/
static void dolock(rqstp,transp)
struct svc_req *rqstp;
SVCXPRT *transp;
{
 /* Kontrollabfrage */
 if ( !genprog )
  {
   lprintf("No RPC servers registerred, could not dispatch\n");
   exit(1);
  }
 /* Aufruf im gesperrten Zustand durchfuehren */
 disabled = 1;
 (*genprog)(rqstp,transp);
 disabled = 0;
}
E 1
