h15202
s 00000/00000/00798
d D 5.1 91/08/15 08:57:28 jochen 7 6
c New version 5.1 created
e
s 00002/00002/00796
d D 4.3 91/02/26 17:25:28 jochen 6 5
c Jobkind now checked for jobs from EXEC-Queue
e
s 00040/00033/00758
d D 4.2 91/02/26 11:35:40 jochen 5 4
c Minor correction for QMan
e
s 00000/00000/00791
d D 4.1 91/02/20 13:26:30 jochen 4 3
c RPC number 390326 now reserved by SUN
e
s 00091/00038/00700
d D 3.2 91/02/20 13:10:11 jochen 3 2
c Structures expanded for parallel support
e
s 00004/00001/00734
d D 3.1 91/01/15 15:27:23 jochen 2 1
c RPC version 3 created
e
s 00735/00000/00000
d D 2.1 91/01/02 15:26:48 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_sgen_backup_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_BACKUP

#include "sgen_hdr.h"

D 3
#define BUNIT			64
E 3
I 3
#define BUNIT			256
E 3
#define BFILELIMIT		(300*512)
#define BRATIO			50

#define bsize(s)		((((s)+BUNIT-1)/BUNIT)*BUNIT)
#define code_char(s)		{if ( !any_char(&(s)) ) return 0;}
#define code_item(i)		{if ( !any_item(&(i),sizeof(i)) ) return 0;}
I 3
#define code_variable(v)	{if ( !any_var(&(v),sizeof(v[0])) ) return 0;}
E 3

static int decode;

static struct notctrl *code_notify();
static struct unique *code_ID();
static execctrl *code_exec();
static genctrl *code_gen();
static jobctrl *code_job();


/*
  Schreibe einen Eintrag in die Backupdatei.
*/
backit(item,data,info)
int item;
char *data;
backup *info;
{
 static long none[2] = { BAK_NONE, BUNIT };

 /* Nur falls es ueberhaupt eine Backupdatei gibt */
D 5
 if ( bakf < 0 ) return;
E 5
I 5
 if ( bakf == -1 ) return;
E 5
 /* Eintrag freigeben ? */
 if ( item == BAK_NONE )
  {
   /* Ist der Eintrag schon frei ? */
D 5
   if ( info->pos < 0 ) return;
E 5
I 5
   if ( info->pos == -1 ) return;
E 5
   /* Eintrag freigeben */
   freeback(info);
   /* In der Datei vermerken */
   while ( info->size )
    {
     /* Kennung loeschen */
     bwrite(info->pos,none,sizeof(none));
     /* Struktur aktualisieren */
     info->pos += BUNIT;
     info->size -= BUNIT;
    }
   /* Fertig */
   info->pos = -1;
   return;
  }
 /* Backupposition invalidieren */
 info->pos = -1;
 /* Buffer initialisieren */
 bbbyt = 0;
 allocbuf(none,sizeof(none));
 /* Fehler bearbeiten */
 if ( !bbbyt ) return;
 /* Selektion nach Operationscode */
 decode = -1;
 switch (item)
  {
   case BAK_GEN    : code_gen(data);
     		     break;
   case BAK_EXEC   : code_exec(data);
     		     break;
   case BAK_JOB    : code_job(data);
     		     break;
   case BAK_ID     : code_ID(data);
     	             break;
   case BAK_NOTIFY : code_notify(data);
     		     break;
   default         : return;
  }
 /* Fehler bearbeiten */
 if ( !bbbyt ) return;
 /* Platz in der Backupdatei allokatieren */
D 3
 info->size = bsize(bbbyt);
 info->pos = allocback(info->size);
E 3
I 3
 info->pos = allocback(info->size = bsize(bbbyt));
E 3
 /* Bufferkontrollinformationen fuellen */
 memmove(bbuf+0,(char *)&item,sizeof(item));
 memmove(bbuf+sizeof(item),(char *)&info->size,sizeof(info->size));
 /* Daten in die Datei schreiben */
 bwrite(info->pos,bbuf,info->size);
}

/*
  Eine 'genctrl' Struktur in einen Backuprecord umwandeln oder daraus lesen.
*/
static genctrl *code_gen(gen)
genctrl *gen;
{
 /* Eventuell Speicher bereitstellen */
D 5
 if ( (decode >= 0) && !(gen = MALLOC(genctrl,1)) ) return 0;
E 5
I 5
 if ( (decode != -1) && !(gen = SALLOC(genctrl)) ) return 0;
E 5
 /* Parameter in der Backupdatei */
 code_item(gen->genID);
 code_item(gen->state);
 code_char(gen->name);
 code_item(gen->prio);
 code_item(gen->cpu);
 code_item(gen->algo);
 code_item(gen->jobs);
 code_item(gen->faults);
 code_item(gen->minidle);
 code_item(gen->stack.def);
 code_item(gen->stack.max);
 code_item(gen->data.def);
 code_item(gen->data.max);
 code_item(gen->mem.def);
 code_item(gen->mem.max);
I 3
 code_char(gen->pdl);
E 3
 /* Restliche Felder initialisieren */
D 5
 if ( decode < 0 ) return gen;
E 5
I 5
 if ( decode == -1 ) return gen;
E 5
 gen->next = 0;
 gen->genaddr = (int)gen;
 gen->back.pos = -1;
 gen->Rjobs = gen->Pjobs = 0;
 /* Zaehler aktualisieren */
 if ( gen->genID > genCnt ) genCnt = gen->genID;
 /* Fertig */
 return gen;
}

/*
  Eine 'execctrl' Struktur ver- oder entschluesseln.
*/
static execctrl *code_exec(exe)
execctrl *exe;
{
 int len;

 /* Eventuell Speicher allokatieren */
D 5
 if ( (decode >= 0) && !(exe = MALLOC(execctrl,1)) ) return 0;
E 5
I 5
 if ( (decode != -1) && !(exe = SALLOC(execctrl)) ) return 0;
E 5
 /* Parameter aus der Backupdatei */
 code_item(exe->execID);
 code_item(exe->state);
 code_char(exe->status.name);
 code_item(exe->status.queueID);
 code_item(exe->status.IPaddr);
I 2
 code_item(exe->status.EaterPort);
D 5
 code_item(exe->status.trans);
E 5
I 5
 code_item(exe->transid);
E 5
I 3
 code_variable(exe->trans_val);
E 3
E 2
 code_item(exe->ack_len);
 /* Feld variabler Laenge */
 len = exe->ack_len*sizeof(exe->ack_IDs[0]);
 /* Verschluesseln */
D 5
 if ( decode < 0 )
E 5
I 5
 if ( decode == -1 )
E 5
  {
   allocbuf(exe->ack_IDs,len);
   return bbbyt ? exe : 0;
  }
D 3
 /* Entschluesseln */
 if ( (decode+len) > bbbyt )
  {
   bbbyt = 0;
   return 0;
  }
 if ( !(exe->ack_IDs = MALLOC(ID,++exe->ack_len)) ) return 0;
E 3
I 3
 /* Nachsehen, ob noch genuegend Bytes vorhanden sind */
 if ( ((decode+len) > bbbyt) || !(exe->ack_IDs = MALLOC(ID,++exe->ack_len)) ) return 0;
 /* Speicher kopieren */
E 3
 exe->ack_IDs[0] = 0;
 memmove((char *)(exe->ack_IDs+1),bbuf+decode,len);
 decode += len;
 /* Restliche Parameter */
 exe->next = 0;
 exe->execaddr = (int)exe;
 exe->back.pos = -1;
 exe->cl = 0;
 exe->retry = RETRY0;
 exe->status.perf = exe->status.idle = exe->status.faults = 0.0;
D 3
 exe->jobs = exe->lastjob = exe->ctrl = exe->stamp = 0;
E 3
I 3
D 5
 exe->jobs = exe->lastjob = exe->ctrl = exe->stamp = exe->transid = exe->tcpstamp = 0;
E 5
I 5
 exe->jobs = exe->lastjob = exe->ctrl = exe->stamp = exe->tcpstamp = 0;
E 5
 if ( exe->trans_len ) time(&exe->tcpstamp);
E 3
 exe->all = exe->ack_len;
 exe->Ejobs = 0;
 /* Zaehler aktualisieren */
 if ( exe->execID > execCnt ) execCnt = exe->execID;
I 5
 if ( (exe->transid+1) > transcur ) transcur = exe->transid+1;
E 5
 /* Erfolg melden */
 return exe;
}

/*
  Ver- oder Entschluesseln einer 'jobctrl' Struktur.
*/
static jobctrl *code_job(job)
jobctrl *job;
{
 ID eID = 0,gID = 0,jID;
 int n;

 /* Eventuell Speicher allokatieren */
D 5
 if ( (decode >= 0) && !(job = MALLOC(jobctrl,1)) ) return 0;
E 5
I 5
 if ( (decode != -1) && !(job = SALLOC(jobctrl)) ) return 0;
E 5
 /* Parameter aus der Datei */
 code_item(job->backID);
 code_item(job->state);
D 5
 if ( decode < 0 )
E 5
I 5
 if ( decode == -1 )
E 5
  {
   if ( job->jgen ) gID = job->jgen->genID;
   if ( job->jexec ) eID = job->jexec->execID;
  }
 code_item(gID);
 code_item(eID);
 code_item(job->submit);
 code_item(job->dispatch);
 code_item(job->pid);
I 3
 code_item(job->leader);
 code_item(job->channels.kind);
 switch (job->channels.kind)
  {
   case skPARALLEL  : code_variable(job->channels.anychan_u.pchans.parchans_val);
		      break;
   case skCONVERTER : code_variable(job->channels.anychan_u.cchans[0].converterchans_val);
		      code_variable(job->channels.anychan_u.cchans[1].converterchans_val);
     		      break;
  }
E 3
 code_item(job->genReq.requestID);
 code_char(job->genReq.queue);
D 5
 code_char(job->genReq.host);
E 5
I 5
 code_item(job->genReq.host);
E 5
 code_char(job->genReq.user);
 code_char(job->genReq.requeue);
 code_char(job->request.name);
 code_item(job->request.restart);
 code_item(job->request.hold);
 code_item(job->request.at);
I 3
 code_item(job->request.leader);
 code_item(job->request.nopend);
 code_variable(job->request.hosts.hints_val);
E 3
 code_item(job->Kind);
 switch (job->Kind)
  {
D 3
   case sSUBMIT : code_item(job->execReq.requestID);
I 2
     		  code_item(job->execReq.kind);
E 2
		  code_item(job->execReq.gid);
		  code_item(job->execReq.uid);
		  code_item(job->execReq.nice);
		  code_item(job->execReq.cpu);
		  code_item(job->execReq.data);
		  code_item(job->execReq.stack);
		  code_item(job->execReq.memory);
     		  code_item(job->execReq.rmsfile);
     		  code_char(job->execReq.shell);
      		  code_char(job->execReq.script);
     		  code_char(job->execReq.log);
     		  code_item(job->execReq.param.param_len);
     		  /* Feld variabler Laenge */
     		  n = job->execReq.param.param_len;
     		  if ( (decode >= 0) && !(job->execReq.param.param_val = MALLOC(char *,n)) )
		   return 0;
		  while ( n-- ) code_char(job->execReq.param.param_val[n]);
     		  jID = job->execReq.requestID;
     		  break;
   case sCANCEL : code_item(job->execSig.requestID);
     		  code_item(job->execSig.pid);
     		  jID = -job->execSig.requestID;
     		  break;
   default      : return 0;
E 3
I 3
   case sCONVERTER : code_item(job->execConv.requestID);
     		     code_item(job->execConv.pid);
     		     code_item(job->execConv.IPaddr);
     		     code_item(job->execConv.IPport);
		     jID = -job->execConv.requestID;
		     break;
   case sSUBMIT    : code_item(job->execReq.requestID);
		     code_item(job->execReq.kind);
		     code_item(job->execReq.gid);
		     code_item(job->execReq.uid);
		     code_item(job->execReq.nice);
		     code_item(job->execReq.cpu);
		     code_item(job->execReq.data);
		     code_item(job->execReq.stack);
		     code_item(job->execReq.memory);
		     code_item(job->execReq.rmsfile);
		     code_char(job->execReq.shell);
		     code_char(job->execReq.script);
		     code_char(job->execReq.log);
     		     code_item(job->execReq.delcom);
     		     code_item(job->execReq.dellog);
		     code_char(job->execReq.print);
		     code_item(job->execReq.param.param_len);
		     /* Feld variabler Laenge */
		     n = job->execReq.param.param_len;
D 5
		     if ( (decode >= 0) && !(job->execReq.param.param_val = MALLOC(char *,n)) )
E 5
I 5
		     if ( (decode != -1) && 
			  !(job->execReq.param.param_val = MALLOC(text,n)) )
E 5
		      return 0;
		     while ( n-- ) code_char(job->execReq.param.param_val[n]);
		     jID = job->execReq.requestID;
		     break;
   case sCANCEL    : code_item(job->execSig.requestID);
		     code_item(job->execSig.pid);
		     jID = -job->execSig.requestID;
		     break;
D 5
   default         : if ( decode < 0 ) bbbyt = 0;
E 5
I 5
   default         : if ( decode == -1 ) bbbyt = 0;
E 5
     		     return 0;
E 3
  }
 /* Allgemeine Parameter */
D 5
 if ( decode < 0 ) return job;
E 5
I 5
 if ( decode == -1 ) return job;
E 5
 job->next = 0;
 job->Jgen.hide = job->Jexec.hide = 1;
 job->jgen = (genctrl *)gID;
D 5
 job->jexec = (execctrl *)eID;;
E 5
I 5
 job->jexec = (execctrl *)eID;
E 5
 job->back.pos = -1;
 /* Zaehler aktualisieren */
 if ( jID > jobCnt ) jobCnt = jID;
I 3
 if ( job->leader > parCnt ) parCnt = job->leader; 
 if ( job->request.leader > parCnt )
  parCnt = job->request.leader; 
E 3
 /* Fertig */
 return job;
}

/*
  Ver- oder Entschluesseln einer 'struct unique'.
*/
static struct unique *code_ID(uid)
struct unique *uid;
{
 /* Eventuell Speicher allokatieren */
D 5
 if ( (decode >= 0) && !(uid = MALLOC(struct unique,1)) ) return 0;
E 5
I 5
 if ( (decode != -1) && !(uid = SALLOC(struct unique)) ) return 0;
E 5
 /* Parameter aus der Backupdatei */
 code_item(uid->uniqueID);
 code_char(uid->answer);
 /* Allgemeine Parameter */
D 5
 if ( decode < 0 ) return uid;
E 5
I 5
 if ( decode == -1 ) return uid;
E 5
 uid->next = 0;
 uid->back.pos = -1;
 time(&uid->when);
 /* Zaehler aktualisieren */
 if ( uid->uniqueID > uniqueCnt ) uniqueCnt = uid->uniqueID;
 /* Fertig */
 return uid; 
}

/*
  Ver- oder Entschluesseln einer 'struct notctrl'.
*/
static struct notctrl *code_notify(not)
struct notctrl *not;
{
 int n;

 /* Eventuell Speicher allokatieren */
D 5
 if ( (decode >= 0) && !(not = MALLOC(struct notctrl,1)) ) return 0;
E 5
I 5
 if ( (decode != -1) && !(not = SALLOC(struct notctrl)) ) return 0;
E 5
 /* Parameter aus der Backupdatei */
D 5
 code_char(not->host);
E 5
I 5
 code_item(not->host);
E 5
 code_char(not->mess.user);
 code_item(not->mess.text.text_len);
 n = not->mess.text.text_len;
D 5
 if ( (decode >= 0) && !(not->mess.text.text_val = MALLOC(char *,n)) ) 
E 5
I 5
 if ( (decode != -1) && !(not->mess.text.text_val = MALLOC(char *,n)) ) 
E 5
  return 0;
 while ( n-- ) code_char(not->mess.text.text_val[n]);
 /* Allgemeine Parameter */
D 5
 if ( decode < 0 ) return not;
E 5
I 5
 if ( decode == -1 ) return not;
E 5
 not->next = 0;
I 5
 not->turn = 0;
E 5
 not->back.pos = -1;
 /* Fertig */
 return not; 
}

/* 
  Ver- oder Entschluesseln einer Zeichenkette.
*/
static any_char(sp)
char **sp;
{
 int pos;

D 5
 if ( decode < 0 )
E 5
I 5
 if ( decode == -1 )
E 5
  /* Verschluesseln */
  allocbuf(*sp,strlen(*sp)+1);
 else
  {
   /* Entschluesseln */
   pos = decode;
   while ( (decode < bbbyt) && bbuf[decode] ) decode++;
   if ( (decode >= bbbyt) || !(*sp = strdup(bbuf+pos)) )
    bbbyt = 0;
   else
    decode++;
  }
 /* Fertig */
 return bbbyt;
}

/*
  Ver- oder Entschluesseln eines Wertes.
*/
static any_item(ip,size)
char *ip;
int size;
{
D 5
 if ( decode < 0 )
E 5
I 5
 if ( decode == -1 )
E 5
  /* Verschluesseln */
  allocbuf(ip,size);
 else if ( (decode+size) > bbbyt )
  bbbyt = 0;
 else
  {
   /* Entschluesseln */
   memmove(ip,bbuf+decode,size);
   decode += size;
  } 
 /* Fertig */
I 3
 return bbbyt;
}

/*
  Ver- oder Entschluessln eines Feldes variabler Laenge.
*/
static any_var(vpp,elsize)
int *vpp,elsize;
{
 int len;

 /* Zahl der Eintraege */
 code_item(vpp[-1]);
 /* Laenge in Bytes */
 len = vpp[-1]*elsize;
 /* Verschluesseln */
D 5
 if ( decode < 0 )
E 5
I 5
 if ( decode == -1 )
E 5
  allocbuf(vpp[0],len);
 else if ( ((decode+len) > bbbyt) || !(vpp[0] = (int)MALLOC(char,len)) )
  bbbyt = 0;
 else
  {
   /* Speicher kopieren */
   memmove(vpp[0],bbuf+decode,len);
   /* Zaehler aktualisieren */
   decode += len;
  }
 /* Alles in Ordung */
E 3
 return bbbyt;
}

/* 
  Etwas in die Backupdatei schreiben.
*/
static bwrite(pos,data,len)
int pos,len;
char *data;
{
 /* Positionieren */
D 5
 if ( lseek(bakf,pos,SEEK_SET) < 0 ) return;
E 5
I 5
 if ( lseek(bakf,pos,SEEK_SET) == -1 ) return;
E 5
 /* Und Daten herausschreiben */
 while ( (write(bakf,data,len) == -1) && (errno == EINTR) );
}

/*
  Position im Backupfile freigeben. Man beachte, dass ausser bei der
  Initialisierung 'bnum' immer groesser als Null ist. Der Eintrag
  'bfree[bnum-1]' enthaelt als Position den ersten freien Eintrag
  in der Datei.
*/
static freeback(info)
backup *info;
{
 backup *nf;
 int n,i;

 /* Erste groessere Position suchen */
 for ( n = 0 ; n < bnum ; n++ )
  if ( bfree[n].pos > info->pos ) 
   break;
 /* Nachsehen, ob eine Verbindung moeglich ist */
 if ( n && (bfree[n-1].pos+bfree[n-1].size == info->pos) )
  bfree[n-1].size += info->size;
 else if ( bnum && (bfree[n].pos == info->pos+info->size) )
  {
   bfree[n].pos = info->pos;
   bfree[n].size += info->size;
  }
 else
  {
   /* Platz fuer ein weiteres Element schaffen */
   if ( bnum == ball )
    {
     /* Speicher reservieren */
     if ( !(nf = MALLOC(backup,ball+10)) ) return;
     /* Eventuell alten Inhalt uebertragen */
     if ( ball )
      {
D 5
       memmove((char *)nf,(char *)bfree,ball*sizeof(bfree[0]));
E 5
I 5
       memmove((char *)nf,(char *)bfree,ball*sizeof(nf[0]));
E 5
       free(bfree);
      }
     /* Speicherbereich uebernehmen */
     ball += 10;
     bfree = nf;
    }
   /* Luecke fuer das neue Element schaffen */
   for ( i = bnum++ ; i-- > n ; bfree[i+1] = bfree[i] );
   /* Element einbauen */
   bfree[n] = *info;
  }
 /* Eventuell Verbindung bereits vorhandener Eintraege */
 if ( n && (bfree[n-1].pos+bfree[n-1].size == bfree[n].pos) )
  {
   bfree[n-1].size += bfree[n].size;
   bnum--;
   for ( i = n ; i < bnum ; i++ ) bfree[i] = bfree[i+1];
  }
}

/*
  Geeigneten Bereich suchen. Wie bei 'freeback' kann 'bnum' niemals 0 sein.
*/
static allocback(size)
int size;
{
 int n,mark = bnum-1,del,best = INT_MAX,pos;

 /* Guenstigsten Bereich aussuchen */
 for ( n = 0 ; n < bnum ; n++ )
  if ( ((del = bfree[n].size-size) >= 0) && (del < best) )
   {
    mark = n;
    best = del;
   }
 /* Irgendwas wird immer gefunden */
 pos = bfree[mark].pos;
 if ( best )
  {
   /* Leider etwas zu gross */
   bfree[mark].pos += size;
   bfree[mark].size -= size;
  }
 else
  {
   /* Element kann vollstaendig eleminiert werden */
   bnum--;
   for ( n = mark ; n < bnum ; n++ ) bfree[n] = bfree[n+1];
  }
 /* Ergebnis melden */
 return pos;
}

/*
  Eintrag in den Backupbuffer 'bbuf'.
*/
static allocbuf(data,len)
char *data;
int len;
{
 char *nb;
 int nall;
 
 /* Platz schaffen */
 if ( (bbbyt+len) > bball )
  {
   /* In groesseren Portionen allokatieren */
D 5
   nall = (bbbyt+len+1023)&~1023;
E 5
I 5
   nall = bsize(bbbyt+len+1000);
E 5
   /* Speicher reservieren */
   if ( !(nb = MALLOC(char,nall)) )
    {
     /* Fehler melden */
     lprintf("Out of memory during backup\n");
     bbbyt = 0;
     return;
    }
   /* Alte Daten uebernehmen */
   if ( bball )
    {
     memmove(nb,bbuf,bball);
     free(bbuf);
    }
   /* Speicher festsetzen */
   bball = nall;
   bbuf = nb;
  }
 /* Daten uebernehmen */
 if ( data ) memmove(bbuf+bbbyt,data,len);
 bbbyt += len;
}


/*
  Periodisch die Dateigroesse ueberpruefen.
*/
dobackup()
{
 int n,sum = 0;

 /* Genereller Test */
D 5
 if ( (bakf < 0) || (bfree[bnum-1].pos < BFILELIMIT) ) return 0;
E 5
I 5
 if ( (bakf == -1) || (bfree[bnum-1].pos < BFILELIMIT) ) return 0;
E 5
 /* Freie Bereiche zusammenrechnen */
 for ( n = bnum-1 ; n-- ; sum += bfree[n].size );
 /* Verhaeltnis beachten */
 if ( 100*sum <= BRATIO*bfree[bnum-1].pos ) return 0;
 /* Backupdatei muss voellig neu erstellt werden */ 
 backall();
}

/*
  Saemtliche Strukturen in die Backupdatei schreiben oder belegten Speicher freigeben.
*/
backall()
{
 struct notctrl *not;
 struct unique *uid;
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;

 /* Gibt es ueberhaupt eine Backupdatei */
D 5
 if ( bakf < 0 ) return;
E 5
I 5
 if ( bakf == -1 ) return;
E 5
 /* Backupdatei loeschen */
 initbackup();
 /* Alle GEN-Queues */
 for ( gen = Gqueues ; gen ; gen = gen->next ) backgen(gen,1);
 /* Alle EXEC-Queue */
 for ( exe = Equeues ; exe ; exe = exe->next ) backexec(exe,1);
 /* Alle laufenden und wartenden Jobs */
 for ( gen = Gqueues ; gen ; gen = gen->next )
  {
   for ( job = gen->Rjobs ; job ; job = job->next ) backjob(job,1);
   for ( job = gen->Pjobs ; job ; job = job->next ) backjob(job,1);
  }
 /* Alle durch RPC-Fehler wartenden Jobs */
 for ( exe = Equeues ; exe ; exe = exe->next )
  for ( job = exe->Ejobs ; job ; job = job->next )
   backjob(job,1);
 /* Und die Benutzerzugriffe */
 for ( uid = IDs ; uid ; uid = uid->next ) backit(BAK_ID,uid,&uid->back);
 /* Zuletzt die Benutzernachrichten */
 for ( not = todo ; not ; not = not->next ) backit(BAK_NOTIFY,not,&not->back);
}

/*
  Backupdatei loeschen.
*/
static initbackup()
{
 long code = CONTROL;
 backup null;

 /* Kennung schreiben */
 bwrite(0,&code,sizeof(code));
 /* Datei abschliessen, damit es zu keinen Missverstaendnissen kommt */
 while ( (ftruncate(bakf,sizeof(code)) == -1) && (errno == EINTR) );
 /* Verwaltungsvariablen initialisieren */
 null.pos = sizeof(code);
 null.size = INT_MAX;
 bnum = 0;
 freeback(&null);
 /* Kontrollabfrage */
 if ( bnum ) return;
 /* Kann nur beim ersten Aufruf moeglich */
 lprintf("Out of memory during initialisation\n");
 exit(1);
}

/*
  Backupdatei einlesen und alle Strukturen aufbauen.
*/
restall()
{
 static int cmpjob();
 jobctrl *job,**jl = 0,**njl;
 int len,jall = 0,jnum = 0;
 struct notctrl *not;
 struct unique *uid;
 long code,items[2];
 execctrl *exe;
 genctrl *gen;

 /* Kennung ueberpruefen */
D 5
 if ( lseek(bakf,0,SEEK_SET) < 0 ) return 0;
E 5
I 5
 if ( lseek(bakf,0,SEEK_SET) == -1 ) return 0;
E 5
 while ( ((len = read(bakf,&code,sizeof(code))) == -1) && (errno == EINTR) );
 if ( (len != sizeof(code)) || (code != CONTROL) ) return 0;
 /* Erster Durchgang: Datei einlesen */
 for ( ; ; )
  {
   /* Block einlesen */
   if ( (len = bread(items)) == -1 ) return 0;
   if ( !len ) break;
   /* Daten bearbeiten */
   decode = 0;
   switch (items[0])
    {
     case BAK_GEN    : if ( !(gen = code_gen((genctrl *)0)) ) return 0;
       		       gen->next = Gqueues;
       		       Gqueues = gen;
       		       break;
     case BAK_EXEC   : if ( !(exe = code_exec((execctrl *)0)) ) return 0;
   		       exe->next = Equeues;
   		       Equeues = exe;
   		       break;
     case BAK_JOB    : if ( !(job = code_job((jobctrl *)0)) ) return 0;
		       /* Platz in der Liste schaffen */
		       if ( jnum == jall )
			{
			 /* Speicher allokatieren */
			 if ( !(njl = MALLOC(jobctrl *,jall+10)) ) return 0;
			 /* Eventuell alte Daten retten */
			 if ( jall )
			  {
D 5
			   memmove((char *)njl,(char *)jl,jall*sizeof(jl[0]));
E 5
I 5
			   memmove((char *)njl,(char *)jl,jall*sizeof(njl[0]));
E 5
			   free(jl);
			  }
			 /* Variablen aktualisieren */
			 jall += 10;
			 jl = njl;
			}
		       /* In die Liste eintragen */
		       jl[jnum++] = job; 
       		       break;
     case BAK_ID     : if ( !(uid = code_ID((struct unique *)0)) ) return 0;
   		       uid->next = IDs;
   		       IDs = uid;
   		       break;
     case BAK_NOTIFY : if ( !(not = code_notify((struct notctrl *)0)) ) return 0;
   		       not->next = todo;
   		       todo = not;
   		       break;
    }
  }
 /* Zweiter Durchgang: Jobs im Speicher den Queues zuordnen */
 qsort(jl,jnum,sizeof(jl[0]),cmpjob);
 /* Der Reihe nach den Queues zuordnen */
 while ( jnum-- )
  {
   /* Queues suchen */
   job = jl[jnum];
   for ( gen = Gqueues ; gen && (gen->genID != (ID)job->jgen) ; gen = gen->next );
   for ( exe = Equeues ; exe && (exe->execID != (ID)job->jexec) ; exe = exe->next );
   if ( !gen || (job->jexec && !exe) ) return 0;
   /* Job in eine der Joblisten einbauen */
   job->jgen = gen;
   if ( !(job->jexec = exe) )
    addTail(&job->jgen->Pjobs,job);
I 5
D 6
   else if ( (job->state == jPENDING) || (job->state == jPENDINGABORT) )
E 6
I 6
   else if ( ISPENDING(job) )
E 6
    addTail(&job->jgen->Pjobs,job);
E 5
D 6
   else if ( job->Kind != sSUBMIT )
E 6
I 6
   else if ( !ISSUBMIT(job) )
E 6
    addTail(&job->jexec->Ejobs,job);
   else
    {
     job->jexec->jobs++;
     if ( job->pid > 0  )
      addTail(&job->jgen->Rjobs,job);
     else
      addTail(&job->jexec->Ejobs,job);
    }
  }
I 5
 /* Speicher freigeben */
 free(jl);
E 5
 /* Erfolg melden */
 return 1;
}

/*
  Element aus der Backupdatei in den Buffer einlesen.
*/
static bread(items)
long items[2];
{
 int len,is = 2*sizeof(long);

 /* Leere Eintraege ueberspringen */
 for ( ; ; )
  {
   /* Kontrollinformationen einlesen */
   while ( ((len = read(bakf,items,is)) == -1) && (errno == EINTR) );
   if ( !len ) return 0;
   if ( (len != is) || (items[1] <= 0) || (items[1]%BUNIT) ||
        (items[0] < BAK_NONE) || (items[0] > BAK_NOTIFY) )
    return -1;
   /* Leeren Eintrag ueberspringen */
   if ( items[0] != BAK_NONE ) break;
D 5
   if ( lseek(bakf,items[1]-is,SEEK_CUR) < 0 ) return -1;
E 5
I 5
   if ( lseek(bakf,items[1]-is,SEEK_CUR) == -1 ) return -1;
E 5
  }
 /* Speicher reservieren */
 bbbyt = 0;
D 5
 allocbuf((char *)0,items[1]-is);
E 5
I 5
 allocbuf(NOSTR,items[1]-is);
E 5
 if ( !bbbyt ) return -1;
 /* Daten einlesen */
 while ( ((len = read(bakf,bbuf,bbbyt)) == -1) && (errno == EINTR) );
 if ( len != bbbyt ) return -1;
 /* Erfolg melden */
 return bbbyt; 
}

/*
  Vergleich zweicher Jobs nach ihrer Backupnummer.
*/
static cmpjob(jp1,jp2)
jobctrl **jp1,**jp2;
{
 return (*jp2)->backID-(*jp1)->backID;
}

/*
  Backup einer 'jobctrl' Struktur, eventuell nach Loeschen.
*/
backjob(job,op)
jobctrl *job;
int op;
{
 if ( op <= 0 ) backit(BAK_NONE,job,&job->back);
 if ( op >= 0 ) backit(BAK_JOB,job,&job->back);
}

/*
  Backup einer 'execctrl' Struktur, eventuell nach Loeschen.
*/
backexec(exe,op)
execctrl *exe;
int op;
{
 if ( op <= 0 ) backit(BAK_NONE,exe,&exe->back);
 if ( op >= 0 ) backit(BAK_EXEC,exe,&exe->back);
}

/*
  Backup einer 'genctrl' Struktur, eventuell nach Loeschen.
*/
backgen(gen,op)
genctrl *gen;
int op;
{
 if ( op <= 0 ) backit(BAK_NONE,gen,&gen->back);
 if ( op >= 0 ) backit(BAK_GEN,gen,&gen->back);
}

E 1
