h32692
s 00000/00000/00386
d D 5.1 91/08/15 08:57:21 jochen 7 6
c New version 5.1 created
e
s 00001/00001/00385
d D 4.3 91/03/09 14:13:24 jochen 6 5
c Error in algo_transfer loop control corrected
e
s 00002/00001/00384
d D 4.2 91/02/26 11:35:36 jochen 5 4
c Minor correction for QMan
e
s 00000/00000/00385
d D 4.1 91/02/20 13:26:28 jochen 4 3
c RPC number 390326 now reserved by SUN
e
s 00111/00019/00274
d D 3.2 91/02/20 13:24:32 jochen 3 2
c Hintlists and transferperformance added
e
s 00001/00001/00292
d D 3.1 91/01/15 15:27:20 jochen 2 1
c RPC version 3 created
e
s 00293/00000/00000
d D 2.1 91/01/02 15:26:47 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_sgen_algo_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_ALGO

#include "sgen_hdr.h"

D 3
#define CUT(n,g,p)	cut(cuts[n],g,p)
E 3
I 3
#define CUT(n,g,p,h)	cut(cuts[n],g,p,h)
E 3
#define NCUT		(sizeof(cuts)/sizeof(cuts[0]))

D 3
static int algo_general(),algo_ratio(),algo_faults(),algo_jobs();
E 3
I 3
static int algo_general(),algo_hints(),algo_transfer(),algo_ratio(),algo_faults(),algo_jobs();
E 3
static execctrl *cut(),*cutall(),*algo_1(),*algo_2();

D 3
static int (*cuts[])() = { algo_general, algo_ratio, algo_faults, algo_jobs };
E 3
I 3
static int (*cuts[])() = 
       { 
	algo_general, algo_hints, algo_transfer, algo_ratio, algo_faults, algo_jobs
       };
E 3
static execctrl *(*algos[])() = { algo_1, algo_2 };


/*
  Zahl der zur Verfuegung stehenden Algorithmen.
*/
nalgo()
{
 return (sizeof(algos)/sizeof(algos[0]));
}

/*
  Algorithmus aufrufen.
*/
D 3
execctrl *algo(code,gen,pref)
E 3
I 3
execctrl *algo(code,gen,pref,hosts)
E 3
int code;
genctrl *gen;
execctrl *pref;
I 3
hints *hosts;
E 3
{
D 3
 return (*algos[gen->algo-1])(code,gen,pref);
E 3
I 3
 return (*algos[gen->algo-1])(code,gen,pref,hosts);
E 3
}

/*
  Algorithmen zur Verteilung der Jobs auf die Queues.
    1) Minimierung nach freier Rechenleistung
    2) Verteilung nach Jobs pro EXEC-Queue
*/
D 3
static execctrl *algo_1(code,gen,pref)
E 3
I 3
static execctrl *algo_1(code,gen,pref,hosts)
E 3
int code;
genctrl *gen;
execctrl *pref;
I 3
hints *hosts;
E 3
{
 execctrl *scan;

 /* Funktion selektieren */
 if ( code == Ajobdef ) return (execctrl *)INT_MAX;
 if ( code != Adispatch ) return (execctrl *)-1;
 /* Aktualisierung aller Daten aller EXEC-Queues und Schnitte setzen */
D 3
 if ( !prepare() || !(scan = cutall(gen,1.0,pref)) ) return 0;
E 3
I 3
 if ( !prepare() || !(scan = cutall(gen,1.0,pref,hosts)) ) return 0;
E 3
 /* Ergebnis melden */
 return scan;
}
 
D 3
static execctrl *algo_2(code,gen,pref)
E 3
I 3
static execctrl *algo_2(code,gen,pref,hosts)
E 3
int code;
genctrl *gen;
execctrl *pref;
I 3
hints *hosts;
E 3
{
 execctrl *scan;

 /* Funktion selektieren */
 if ( code == Ajobdef ) return (execctrl *)1;
 if ( code != Adispatch ) return (execctrl *)-1;
 /* Aktualisierung aller Daten aller EXEC-Queues und Schnitte setzen */
D 3
 if ( !prepare() || !(scan = cutall(gen,0.0,pref)) ) return 0;
E 3
I 3
 if ( !prepare() || !(scan = cutall(gen,0.0,pref,hosts)) ) return 0;
E 3
 /* Ergebnis melden */
 return scan;
}

/*
  Vorbereitung zum Setzen der Schnitte in der Menge der moeglichen EXEC-Queues.
  Dazu muessen zuerst einmal alle Informationen aktualisiert werden.
*/
static prepare()
{
 double maxR = -DBL_MAX;
 statusinfo info;
 int neq = 0,new;
 execctrl *scan;
 time_t now;
 
 /* Zeitnullpunkt bestimmen */
 time(&now);
 for ( scan = Equeues ; scan ; scan = scan->next )
  if ( (scan->ctrl == ctrlCnt) || (scan->state == qSTOPPED) || 
       !scan->status.queueID || (scan->retry <= 0) || ((now-scan->lastjob) < 3) )
   scan->ratio = -1.0;
  else
   {
    /* Alte Informationen erneuern */
    info.name = 0;
    if ( (now-scan->stamp) > 1 )
     /* Neue Informationen besorgen */
     if ( !status(&scan->cl,scan->status.IPaddr,&info) )
      {
       /* Fehler beim RPC-Aufruf */
       scan->retry--;
       scan->ctrl = ctrlCnt;
       return 0;
      }
     else if ( info.queueID != scan->status.queueID )
      {
       /* EXEC-Queue hat ihren Status geaendert */
       scan->retry = RETRY0;
I 5
       scan->ratio = -1.0;
E 5
       free(info.name);
       continue;
      }
     else
      {
       /* RPC-Aufruf hat funktioniert */
       scan->retry = RETRY0;
       /* Eventuell in der Backupdatei aendern */
       new = strcmpi(info.name,scan->status.name);
       /* Informationen uebertragen und Speicher kontrolliert freigeben */
       free(scan->status.name);
       info.IPaddr = scan->status.IPaddr;
       scan->status = info;
       time(&scan->stamp);
       /* Was ist nun mit der Backupdatei */
       if ( new ) backexec(scan,0);
      }
   /* Relative CPU-Auslastung */
   if ( scan->status.perf > 0.0 )
    scan->ratio = scan->status.idle/scan->status.perf;
   else
    scan->ratio = -2.0;
   /* Extremwerte berechnen */
   if ( scan->status.perf > maxR ) maxR = scan->status.perf;
   /* EXEC-Queues durchzaehlen */
   neq++;
  }
 /* Nur weitermachen, falls ueberhaupt EXEC-Queues gefunden */
 if ( !neq ) return 0;
 /* Relative CPU-Auslastung setzen */
 if ( maxR <= 0.0 ) maxR = 1.0;
 for ( scan = Equeues ; scan ; scan = scan->next )
  if ( scan->ratio == -2.0 )
   scan->ratio = scan->status.idle/maxR;
 /* Ergebnis melden */
 return neq;
}

/*
  Alle eingebauten Schnitte bis zum bitteren Ende durchfuehren.
*/
D 3
static execctrl *cutall(gen,par,pref)
E 3
I 3
static execctrl *cutall(gen,par,pref,hosts)
E 3
genctrl *gen;
double par;
execctrl *pref;
I 3
hints *hosts;
E 3
{
 execctrl *scan;
 int n;

 /* Schnitte der Reihe nach durchfuehren */
 for ( n = 0 ; n < NCUT ; )
  {
   /* Schnitt durchfuehren und bei Fehler aufhoeren */
D 3
   if ( (scan = CUT(n,gen,par)) == (execctrl *)-1 ) return 0;
E 3
I 3
   if ( (scan = CUT(n,gen,par,hosts)) == (execctrl *)-1 ) return 0;
E 3
   /* Spezielle Beruecksichtigung eines Benutzerwunsches */
   if ( !n++ && pref )
    {
     /* Nachsehen, ob die gewueschte Queue betriebsbereit ist */
     if ( pref->ratio == -1.0 )
      pref = 0;
     else
      dqinfo(gen,NCUT+2);
     return pref;
    }
   /* Falls noch mehrere EXEC-Queues im Rennen sind weitersuchen */
   if ( !scan ) continue;
   /* Falls eine eindeutige EXEC-Queue ermittelt wurde aufhoeren */
   dqinfo(gen,n);
   return scan;
  }
 /* Irgendeine EXEC-Queue aus dem Rest auswaehlen */
 for ( scan = Equeues ; scan && (scan->ratio == -1.0) ; scan = scan->next );
 dqinfo(gen,NCUT+1);
 /* Ergebnis melden */
 return scan;
}

/*
  Schnitte in die Menge aller moeglichen EXEC-Queues setzen.
*/
D 3
static execctrl *cut(algo,gen,par)
E 3
I 3
static execctrl *cut(algo,gen,par,hosts)
E 3
int (*algo)();
genctrl *gen;
double par;
I 3
hints *hosts;
E 3
{
 execctrl *scan,*found = (execctrl *)-1;
 double max = -DBL_MAX;

 /* Alle EXEC-Queues absuchen */
 /* - Maximum bestimmen */
 for ( scan = Equeues ; scan ; scan = scan->next )
  if ( scan->ratio != -1.0 )
D 3
   if ( !(*algo)(gen,scan,par,0) )
E 3
I 3
   if ( !(*algo)(gen,scan,par,0,max,hosts) )
E 3
    scan->ratio = -1.0;
   else if ( scan->val > max )
    max = scan->val;
 /* - Geeignete EXEC-Queue auswaehlen */
 for ( scan = Equeues ; scan ; scan->val = 0.0, scan = scan->next )
  if ( scan->ratio != -1.0 )
D 3
   if ( !(*algo)(gen,scan,par,1,max) )
E 3
I 3
   if ( !(*algo)(gen,scan,par,1,max,hosts) )
E 3
    scan->ratio = -1.0;
   else if ( found == (execctrl *)-1 )
    found = scan;
   else
    found = 0;     
 /* Ergebnis melden */
 return found;
}

/*
  Schnitte setzen:
  1. Grenzbelastung
     algo_general 	        (CPU<BUSYLIMIT) && (FAULTS<MAXFAULTS) && (JOBS<JOBLIMIT)
D 3
  2. Load Balancing
     algo_ratio			ABS(RATIO-MIN(RATIO)) < DELTA
E 3
I 3
  2. Benutzerhinweise
     algo_hints			Element of HINTS
  3. Load Balancing
     algo_transfer		ABS(TRANSSUM-MIN(TRANSSUM)) < DELTA
     algo_ratio			ABS(RATIO-MAX(RATIO)) < DELTA
E 3
     algo_faults		ABS(FAULT-MIN(FAULT)) < DELTA
     algo_jobs 			ABS(JOBS-MIN(JOBS)) == 0
*/
static algo_general(gen,exe,par,lev,max)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
{
 /* Wert berechnen */
 if ( (exe->jobs >= gen->jobs) || ((par != 0.0) &&
      ((exe->status.idle <= 0.01*gen->minidle) || (exe->status.faults > gen->faults))) )
  return 0;
 /* Ergebnis melden */
 exe->val = 1.0;
 return 1;
}

I 3
static algo_hints(gen,exe,par,lev,max,hosts)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
hints *hosts;
{
 int n;

 /* Nachsehen, ob diese EXEC-Queue im primaeren Teil der Hintliste ist. */
 if ( lev ) return (exe->val == max);
 /* Suchen */
 exe->val = 0.0;
 if ( !hosts ) return 1;
 /* Alle primaeren Eintraege durchgehen */
 for ( n = 0 ; (n < hosts->hints_len) && (hosts->hints_val[n] != IPnone) ; )
  if ( hosts->hints_val[n++] == exe->status.IPaddr )
   {
    exe->val = 1.0;
    break;
   }
 /* Auf jeden Fall weiter beachten */
 return 1;
}

static algo_transfer(gen,exe,par,lev,max,hosts)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
hints *hosts;
{
 execctrl *rem;
 int n,i,sum;
 double add;

 /* Summe der Transferraten ermitteln */
 if ( lev ) return ((max-exe->val) <= (-0.1*max));
 /* Suchen */
 exe->val = 0.0;
 if ( !hosts ) return 1;
 /* Primaere Hinweise ueberspringen */
 for ( n = sum = 0 ; (n < hosts->hints_len) && (hosts->hints_val[n++] != IPnone) ; );
 /* Eingabekanaele */
 while ( (n < hosts->hints_len) && (hosts->hints_val[n++] != IPnone) )
D 6
  for ( rem = Equeues ; rem ; rem->next )
E 6
I 6
  for ( rem = Equeues ; rem ; rem = rem->next )
E 6
   if ( hosts->hints_val[n-1] == rem->status.IPaddr )
    {
     /* Transferrate suchen */
     for ( i = rem->trans_len ; i-- ; )
      if ( (rem->trans_val[i].IPaddr == exe->status.IPaddr) )
       {
        if ( (add = rem->trans_val[i].IPsecs+1.0E-6*rem->trans_val[i].IPusecs) > 0.0 )
         {
          exe->val += add;
          sum++;
         }   
        break;
       }
     /* Naechste EXEC-Queue */
     break;
    }
 /* Ausgabekanaele */
 while ( (n < hosts->hints_len) && (hosts->hints_val[n++] != IPnone) ) 
  /* Transferrate suchen */
  for ( i = exe->trans_len ; i-- ; )
   if ( hosts->hints_val[n-1] == exe->trans_val[i].IPaddr )
    {
     if ( (add = exe->trans_val[i].IPsecs+1.0E-6*exe->trans_val[i].IPusecs) > 0.0 )
      {
       exe->val += add;
       sum++;
      }   
     break;
    }
 /* Ergebnis */
 if ( sum ) exe->val = -exe->val/sum;
 /* Auf jeden Fall weiter beachten */
 return 1;
}

E 3
static algo_ratio(gen,exe,par,lev,max)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
{
 /* Maximalwert ermitteln */
 if ( !lev )
  {
   exe->val = exe->ratio;
   return 1;
  }
 /* Eignung der EXEC-Queue ermitteln */
D 3
 return ((max-exe->ratio) < (0.1*max));
E 3
I 3
 return ((max-exe->ratio) <= (0.1*max));
E 3
}

static algo_faults(gen,exe,par,lev,max)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
{
 /* Maximalwert ermitteln */
 if ( !lev )
  {
   exe->val = -exe->status.faults;
   return 1;
  }
 /* Eignung der EXEC-Queue ermitteln */
D 3
 return ((exe->status.faults+max) < 2.0);
E 3
I 3
D 5
 return ((exe->status.faults+max) <= 2.0);
E 5
I 5
 return ((max+exe->status.faults) <= 2.0);
E 5
E 3
}

static algo_jobs(gen,exe,par,lev,max)
genctrl *gen;
execctrl *exe;
double par,max;
int lev;
{
 /* Maximalwert ermitteln */
 if ( !lev )
  {
   exe->val = -exe->jobs;
   return 1;
  }
 /* Eignung der EXEC-Queue ermitteln */
 return (exe->jobs == -max);
}


E 1
