h36188
s 00000/00000/00077
d D 5.1 91/08/15 08:57:12 jochen 6 5
c New version 5.1 created
e
s 00001/00001/00076
d D 4.2 91/02/26 11:35:33 jochen 5 4
c Minor correction for QMan
e
s 00000/00000/00077
d D 4.1 91/02/20 13:26:25 jochen 4 3
c RPC number 390326 now reserved by SUN
e
s 00001/00001/00076
d D 3.2 91/02/20 13:07:53 jochen 3 2
c Parallel support added
e
s 00001/00001/00076
d D 3.1 91/01/15 15:27:16 jochen 2 1
c RPC version 3 created
e
s 00077/00000/00000
d D 2.1 91/01/02 15:26:46 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_sgen_ack_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_ACK

#include "sgen_hdr.h"

/*
  Acknowledgeinformation an einer EXEC-Queue verankern.
*/
addAck(exe,ackID)
execctrl *exe;
ID ackID;
{
 ID *na;
 int i;

 /* Nachsehen, ob es das schon gibt */
 for ( i = exe->ack_len ; i-- ; )
  if ( ackID == exe->ack_IDs[i] )
   return doAck();
 /* Platz sichern */
 if ( exe->all == exe->ack_len )
  {
   /* Speicher reservieren */
   if ( !(na = MALLOC(ID,exe->all+10)) )
    {
     lprintf("Out of memory during acknowledge\n");
     return doAck();
    }
   /* Alte Werte uebernehmen */
   if ( exe->all )
    {
D 5
     memcpy((char *)na,(char *)exe->ack_IDs,sizeof(ID)*exe->all);
E 5
I 5
     memmove((char *)na,(char *)exe->ack_IDs,sizeof(ID)*exe->all);
E 5
     free(exe->ack_IDs);
    }
   /* Neue Werte eintragen */
   exe->all += 10;
   exe->ack_IDs = na;
  }
 /* Element eintragen */
 exe->ack_IDs[exe->ack_len++] = ackID;
 /* In der Backupdatei aendern */
 backexec(exe,0);
 /* Und EXEC-Queue benachrichtigen */
 doAck();
}

/*
  EXEC-Queues benachrichtigen.
*/
doAck()
{
 execctrl *exe;

 /* Alle EXEC-Queues durchgehen */
 for ( exe = Equeues ; exe ; exe = exe->next )
  if ( exe->status.queueID && (exe->retry > 0) && exe->ack_len )
   {
    /* RPC-Befehl ausfuehren */
    exe->ack.queueID = exe->status.queueID;
    if ( !ack(&exe->cl,exe->status.IPaddr,&exe->ack) )
     exe->retry--;
    else
     {
      exe->retry = RETRY0;
      exe->ack_len = 0;
      /* In der Backupdatei vermerken */
      backexec(exe,0);
     }
   }
}


E 1
