h21486
s 00000/00000/00300
d D 5.1 91/08/15 08:56:52 jochen 12 11
c New version 5.1 created
e
s 00002/00000/00298
d D 4.4 91/03/15 10:35:18 jochen 11 10
c SUSPEND and RESUME flags added
e
s 00016/00017/00282
d D 4.3 91/02/26 11:35:26 jochen 10 9
c Minor correction for QMan
e
s 00018/00015/00281
d D 4.2 91/02/20 14:42:31 jochen 9 8
c Flags for new 'jobinfo' elements added
e
s 00002/00004/00294
d D 4.1 91/02/20 13:26:19 jochen 8 7
c RPC number 390326 now reserved by SUN
e
s 00056/00025/00242
d D 3.4 91/02/20 13:20:39 jochen 7 6
c Parallel support entries and structures added
e
s 00012/00007/00255
d D 3.3 91/01/15 15:44:28 jochen 6 5
c SCCS addapted for common use
e
s 00033/00035/00229
d D 3.2 91/01/15 14:58:33 jochen 5 4
c modified to connect to EXEC-Queue version 3
e
s 00001/00001/00263
d D 3.1 91/01/08 17:31:21 jochen 4 3
c RPC version 3 created
e
s 00002/00002/00262
d D 2.3 91/01/02 18:10:35 jochen 3 2
c restored use of sexec.x snotify.x
e
s 00002/00002/00262
d D 2.2 91/01/02 18:05:20 jochen 2 1
c corrected for SCCS usage of sexec.x and snotify.x
e
s 00264/00000/00000
d D 2.1 91/01/02 15:26:42 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

D 6
#ifdef SCCSIDS
D 5
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 5
I 5
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 6
I 6
#ifndef RPC_HDR
%#ifdef SCCSIDS
D 7
%static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 7
I 7
%static char sccsid_sgen_x[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 7
%#endif
E 6
E 5
#endif

#define GENERIC
D 2
#include "../exec/sexec.x"
#include "../exec/snotify.x"
E 2
I 2
D 3
#include "sexec.x"
#include "snotify.x"
E 3
I 3
#include "../exec/sexec.x"
#include "../exec/snotify.x"
E 3
E 2

/*
  Umlenken der RPC-Aufrufe zum Sperren der Listen.
*/
#ifdef RPC_SVC
%#ifndef svc_register
%#define svc_register doregister
%#endif
#endif

/*
  Konstanten fuer die Queue- und Job-Zustaende.
*/
enum Qstate { qNORMAL, qSTOPPED };
D 10
enum Jstate { jNORMAL, jPENDING, jABORTPENDING, jABORTING, jNONE };
E 10
I 10
enum Jstate { jNORMAL, jPENDING, jABORTPENDING, jABORTING, jPENDINGABORT, jNONE };
E 10

D 5
#ifdef RPC_HDR
%#define uflags		info.jkinfo_u.jinfo.uid
%#define ufAFTER	0x0001
%#define ufCLI		0x0002
%#define ufCPUTIME	0x0004
%#define ufHOLD		0x0008
%#define ufLOGFILE	0x0010
%#define ufNAME		0x0020
%#define ufNOTIFY	0x0040
%#define ufPARAMETERS	0x0080
%#define ufPRIORITY	0x0100
%#define ufREQUEUE	0x0200
%#define ufRESTART	0x0400
%#define ufRMSFILE	0x0800
%#define ufSTACK	0x1000
%#define ufDATA		0x2000
%#define ufMEMORY	0x4000

%#define iflags		gen.genID
%#define ifSTART	0x0001
%#define ifSTOP		0x0002
%#define ifPRIORITY	0x0010
%#define ifCPUMAXIMUM	0x0020
%#define ifALGORITHM	0x0040
%#define ifJOBLIMIT	0x0080
%#define ifMINIDLE	0x0100
%#define ifFAULTLIMIT	0x0200
%#define ifSTACKDEF	0x0400
%#define ifSTACKMAX	0x0800
%#define ifDATADEF	0x1000
%#define ifDATAMAX	0x2000
%#define ifMEMORYDEF	0x4000
%#define ifMEMORYMAX	0x8000
#endif
E 5
I 5
D 6
const uflags 		= info.jkinfo_u.jinfo.uid;
E 6
I 6
#ifdef RPC_HDR
%#define uflags		info.jkinfo_u.jinfo.uid
%#define iflags		gen.genID
#endif

E 6
D 9
const ufAFTER 		= 0x0001;
const ufCLI 		= 0x0002;
const ufCPUTIME 	= 0x0004;
const ufHOLD 		= 0x0008;
const ufLOGFILE 	= 0x0010;
const ufNAME 		= 0x0020;
const ufNOTIFY 		= 0x0040;
const ufPARAMETERS 	= 0x0080;
const ufPRIORITY 	= 0x0100;
const ufREQUEUE 	= 0x0200;
const ufRESTART 	= 0x0400;
const ufRMSFILE 	= 0x0800;
const ufSTACK 		= 0x1000;
const ufDATA 		= 0x2000;
D 6
const ufMEMORY 		= 0x4000
;
const iflags 		= gen.genID;
E 6
I 6
const ufMEMORY 		= 0x4000;
E 9
I 9
const ufAFTER 		= 0x00001;
const ufCLI 		= 0x00002;
const ufCPUTIME 	= 0x00004;
const ufHOLD 		= 0x00008;
const ufLOGFILE 	= 0x00010;
const ufNAME 		= 0x00020;
const ufNOTIFY 		= 0x00040;
const ufPARAMETERS 	= 0x00080;
const ufPRIORITY 	= 0x00100;
const ufREQUEUE 	= 0x00200;
const ufRESTART 	= 0x00400;
const ufRMSFILE 	= 0x00800;
const ufSTACK 		= 0x01000;
const ufDATA 		= 0x02000;
const ufMEMORY 		= 0x04000;
const ufDELCOM		= 0x08000;
const ufDELLOG		= 0x10000;
const ufPRINT		= 0x20000;
I 11
const ufSUSPEND		= 0x40000;
const ufRESUME		= 0x80000;
E 11
E 9

E 6
D 7
const ifSTART 		= 0x0001;
const ifSTOP 		= 0x0002;
const ifPRIORITY 	= 0x0010;
const ifCPUMAXIMUM 	= 0x0020;
const ifALGORITHM 	= 0x0040;
const ifJOBLIMIT 	= 0x0080;
const ifMINIDLE 	= 0x0100;
const ifFAULTLIMIT 	= 0x0200;
const ifSTACKDEF 	= 0x0400;
const ifSTACKMAX 	= 0x0800;
const ifDATADEF 	= 0x1000;
const ifDATAMAX 	= 0x2000;
const ifMEMORYDEF 	= 0x4000;
D 6
const ifMEMORYMAX 	= 0x8000
E 6
I 6
const ifMEMORYMAX 	= 0x8000;
E 7
I 7
const ifSTART 		= 0x00001;
const ifSTOP 		= 0x00002;
const ifPRIORITY 	= 0x00010;
const ifCPUMAXIMUM 	= 0x00020;
const ifALGORITHM 	= 0x00040;
const ifJOBLIMIT 	= 0x00080;
const ifMINIDLE 	= 0x00100;
const ifFAULTLIMIT 	= 0x00200;
const ifSTACKDEF 	= 0x00400;
const ifSTACKMAX 	= 0x00800;
const ifDATADEF 	= 0x01000;
const ifDATAMAX 	= 0x02000;
const ifMEMORYDEF 	= 0x04000;
const ifMEMORYMAX 	= 0x08000;
const ifPDL		= 0x10000;
E 7
E 6
E 5

/*
  Alle Aktionen mit Jobs sind in einer einzigen RPC-Routine GENJOBACTION zusammen-
  gefasst. Dazu wird eine Struktur uebertragen, die einen statischen und einen
  dynamischen Teil enthaelt. Im statischen Teil werden allgemeine Informationen
  uebermittelt, z.B. wohin ein NOTIFY bei komplettieren des Jobs geschickt werden
  soll. Der dynamische Teil besteht dann aus Strukturen, die direkt an die EXEC-
  Queues weitergereicht werden koennen. Ein Selektor unterscheidet dann zwischen
  den vom Benutzer gewuenschten Operationen.
*/
D 7
enum Skind { sSUBMIT, sCANCEL, sMODIFY, sSTOP };
E 7
I 7
enum Skind { sSUBMIT, sCANCEL, sMODIFY, sSTOP, sCONVERTER };
E 7

struct general
       {
	ID	requestID;		/* Kontrollnummer			*/
D 10
	string	queue<>;		/* Name der zu benutzenden Queue	*/
	string  host<>;			/* Name des NOTIFY-Servers		*/
	string	user<>;			/* Benutzername (REMOTE)		*/
	string	requeue<>;		/* Neue Queue				*/
E 10
I 10
	text	queue;			/* Name der zu benutzenden Queue	*/
	long  	host;			/* Name des NOTIFY-Servers		*/
	text	user;			/* Benutzername (REMOTE)		*/
	text	requeue;		/* Neue Queue				*/
E 10
       };

union jkinfo switch (Skind kind)
      {
D 7
       case sSUBMIT : jobinfo  jinfo;	/* Starten eines Jobs			*/
       case sMODIFY : jobinfo  minfo;	/* Aendern eines Jobs			*/
       case sSTOP   : jobinfo  sinfo;   /* Neustart eines Jobs			*/
       case sCANCEL : killinfo kinfo;	/* Vorzeitiges Beenden eines Jobs	*/
E 7
I 7
       case sSUBMIT    : jobinfo  jinfo;/* Starten eines Jobs			*/
       case sMODIFY    : jobinfo  minfo;/* Aendern eines Jobs			*/
       case sSTOP      : jobinfo  sinfo;/* Neustart eines Jobs			*/
       case sCANCEL    : killinfo kinfo;/* Vorzeitiges Beenden eines Jobs	*/
       case sCONVERTER : convinfo cinfo;/* Entfernen eines Konverterkanals	*/
E 7
      };

I 7
typedef long hints<>;

E 7
struct submit
       {
	general qinfo;			/* Allgemeine Informationen		*/
D 10
	string	name<>;			/* Name des Jobs			*/
E 10
I 10
	text	name;			/* Name des Jobs			*/
E 10
	int	restart;		/* Darf neu gestartet werden		*/
	int	hold;			/* Erst einmal nicht starten		*/
	long	at;			/* Gewuenschter Startzeitpunkt		*/
	jkinfo  info;			/* Kontrollstruktur der EXEC-Queue	*/
I 7
	ID	leader;			/* Zugehoeriger Paralleljob		*/
	hints	hosts;			/* Liste von IP-Addressen		*/
	int	nopend;			/* Darf nicht warten			*/
E 7
       };

/*
  Nun folgen die einzelnen Verwaltungseinheiten. Die Zeiger muessen eventuell
  bei Anlegen der Strukturen gegenueber XDR mittels des 'hide' Selektors ge-
  sperrt werden. Prinzipiell werden nur Vorwaertszeiger offengehalten und die
  Rueckwaertszeiger 'gen' und 'exec' der 'struct jobctrl' gesperrt. Daher werden
  im Augenblick auch nur dort die 'union's benutzt.
*/

struct backup
       {
	int		pos;		/* Position in der Backupdatei		*/
	int		size;		/* Groesse in der Backupdatei		*/
       };

struct execctrl
       {
	execctrl	*next;		/* Naechste EXEC-Queue			*/
	ID		execID;		/* Laufende Nummer			*/
	int		execaddr;	/* Eigene Adresse fuer 'geninfo'	*/
	Qstate		state;		/* Zustand der EXEC-Queue		*/
	backup   	back;		/* Position im Backupfile		*/
	int		ctrl;		/* Kontrollzaehler			*/
	double		ratio;		/* Relative CPU-Performance		*/
	double		val;		/* Temporaerer Wert			*/
	long		cl;		/* RPC-Handle				*/
	int		retry;		/* RPC-Wiederholungsanweisung		*/
	statusinfo	status;		/* Aktuelleste Informationen		*/
	long		stamp;		/* Letzte Aktualisierung		*/
	long		lastjob;	/* Uhrzeit des letzen Jobstarts		*/
	struct jobctrl	*Ejobs;		/* Durch RPC-Fehler wartende Jobs	*/
	int		jobs;		/* Laufende Prozesse			*/
	int		all;		/* Groesse des allokatierten ID-Feldes	*/
	acknowledge	ack;		/* Liste der noch aktiven Acknowledges  */
I 7
	int		transid;	/* Transferkennung			*/
	long		tcpstamp;	/* Wann wurde das gefuellt		*/
	parchans	tcpinfo;	/* Uebertragungsraten			*/
E 7
       };

struct range
       {
	int		def;		/* Defaultwert				*/
	int		max;		/* Maximalwert				*/
       };

struct genctrl
       {
	genctrl		*next;		/* Naechste GEN-Queue			*/
	ID		genID;		/* Laufende Nummer dieser GEN-Queue	*/
	int		genaddr;	/* Eigene Adresse fuer 'geninfo'	*/
	Qstate		state;		/* Zustand der GEN-Queue		*/
	backup   	back;		/* Position im Backupfile		*/
D 10
	string		name<>;		/* Name 				*/
E 10
I 10
	text		name;		/* Name 				*/
E 10
	int		prio;		/* Prioritaet				*/
	int		cpu;		/* CPU-Zeit in Sekunden			*/
	int		algo;		/* Verteilungalgorithmus		*/
	int		jobs;		/* Joblimit				*/
	int		faults;		/* Pagefaultlimit			*/
	int		minidle;	/* Maximal erlaubte Auslastung		*/
	range		stack;		/* Stackbereich				*/
	range		data;		/* Datenbereich				*/
	range		mem;		/* Speicherbereich			*/
	struct jobctrl	*Rjobs;		/* Laufende Jobs			*/
	struct jobctrl	*Pjobs;		/* Wartende Jobs			*/
I 7
D 10
	string		pdl<>;		/* Parallelinterpreter			*/
E 10
I 10
	text		pdl;		/* Parallelinterpreter			*/
E 10
E 7
       };

/*
  Der Benutzer hat jederzeit die Moeglichkeit, alle relevanten Informationen der
  GEN-Queue auszulesen. Da aber die verwendeten Strukturen zum Teil redundante
  Rueckwaertszeiger enthalten, muss mit einem besonderen Trick sichergestellt
  werden, dass die XDR-Library sich beim Abschicken der Daten nicht totlaeuft.
*/
union execptr switch(bool hide)
      {
       case TRUE  : int	     hptr;	/* Pointer wird in XDR nicht verfolgt	*/
       case FALSE : execctrl *ptr;	/* Pointer wird dereferenziert		*/
      };

union genptr switch(bool hide)
      {
       case TRUE  : int	    hptr;	/* Pointer wird in XDR nicht verfolgt	*/
       case FALSE : genctrl *ptr;	/* Pointer wird dereferenziert		*/
      };

I 7
union anychan switch(subkind kind)
      {
       case skNORMAL    : void;				/* Nichts uebertragen	*/
       case skPARALLEL  : parchans       pchans;	/* FORTRAN Kanaele	*/
       case skCONVERTER : converterchans cchans[2];	/* Konverterkanaele	*/
      };

E 7
struct jobctrl
       {
	jobctrl		*next;		/* Verkettung der Jobs			*/
	genptr          Jgen;		/* Zugehoerige GEN-Queue		*/
	execptr		Jexec;		/* Zugehoerige EXEC-Queue		*/
	ID		backID;		/* Laufende Nummer			*/
	Jstate		state;		/* Zustand des Jobs			*/
	backup   	back;		/* Position im Backupfile		*/
	long		submit;		/* Zeitpunkt des Jobrequests		*/
	long		dispatch;	/* Zeitpunkt des Jobstarts		*/
	PID		pid;		/* Prozessnummer in der EXEC-Queue	*/
	submit		request;	/* Informationsblock des Benutzers	*/
I 7
	ID		leader;		/* Jobleader Kennung			*/
	anychan		channels;	/* Sonderinformationen und Statistik	*/
E 7
       };

/*
  Alle Operationen mit Queues werden aehnlich wie bei den Jobs mit einem einzigen
  RPC-Befehl durchgefuehrt. Eine Selektionsvariable entscheidet dann, welche
  Operation im Detail durchzufuehren ist.
*/
enum Ckind { cINIT, cMODIFY, cDELETE };

struct control
       {
	Ckind		kind;		/* Art der Operation			*/
	ID		requestID;	/* Zugriffsnummer			*/
	int		next;		/* Qualifier /NEXT oder /RESET benutzt  */
	int		prio;		/* Qualifier /PRIORITY benutzt		*/
	int		hold;		/* Qualifier /HOLD benutzt		*/
D 10
	string		requeue<>;	/* Qualifier /REQUEUE benutzt		*/
E 10
I 10
	text		requeue;	/* Qualifier /REQUEUE benutzt		*/
E 10
	genctrl		gen;		/* Informationen zu der Queue		*/
       };

/*
  Synchronisierung mit einem bestimmten Job.
*/
struct syncctrl
       {
D 10
	string		queue<>;	/* Name der Queue			*/
	string		name<>;		/* Name des Jobs			*/
E 10
I 10
	text		queue;		/* Name der Queue			*/
	text		name;		/* Name des Jobs			*/
E 10
	ID		jID;		/* Kennung des Jobs			*/
       };


/*
  Die folgende Struktur enthaelt nun alle Informationen ueber die GEN-Queue und
  ihre Jobs, die der Benutzer abfragen kann.
*/
struct masterctrl
       {
D 10
	string		name<>;		/* Name des Hosts			*/
E 10
I 10
	text		name;		/* Name des Hosts			*/
E 10
	long		addr;		/* IP-Adresse des Hosts			*/
	int		stopped;	/* STOP/QUEUE/MANAGER			*/
	genctrl		*gens;		/* GEN-Queues				*/
	execctrl	*execs;		/* EXEC-Queues				*/
I 10
	long		EXECprog;	/* RPC-Nummer der EXEC-Queues		*/
	long		EXECvers;	/* Versionsnummer der EXEC-Queue	*/
	long		NOTIFYprog;	/* RPC-Nummer des NOTIFY-Servers	*/
	long		NOTIFYvers;	/* Versionsnummer des NOTIFY-Servers	*/
E 10
       };
D 10

/*
  Antwort mit einem einfachen Text.
*/
typedef string text<>;
E 10

/*
  Befehle zur Steuerung des Queuemanagers selbst.
*/
enum qmCommand { qmSTOP, qmSTART, qmNEWVERSION };

/*
I 7
  Informationen ueber alle Teiljobs eines Paralleljobs uebermitteln.
*/
struct parctrl
       {
	ID		job;		/* Nummer des Jobs			*/
	long		IPaddr;		/* EXEC-Queue, in der er laeuft		*/
	anychan		channels;	/* Sonderinformationen und Statistik	*/
       };
typedef parctrl parctrls<>;

/*
E 7
  Letzlich die Definition der RPC-Einsprungpunkte des GEN-Servers.
*/
program GENPROG {
        version GENVERS {
D 7
		/* Intern */
E 7
I 7
		/* RPC Version 1 */
D 8
		/* RPC Version 2 */
E 8
E 7
		void GENNOTIFY(jobdone) = 1;
		int GENNEWEXEC(statusinfo) = 2;
D 7
		/* Allgemeines */
E 7
		ID GENUNIQUEID(void) = 3;
D 7
		/* Jobbefehle */
E 7
		text GENJOBACTION(submit) = 4;
		Jstate GENSYNCHRONIZE(syncctrl) = 5;
D 7
		/* Queuebefehle */
E 7
		masterctrl GENINFO(void) = 6;
		text GENQUEUEACTION(control) = 7;
D 7
		/* Managerbefehle */
E 7
		text GENMANAGERACTION(qmCommand) = 8;
I 7
D 8
		/* RPC Version 3 */
E 8
		int GENDUMPSTARTUP(void) = 9;
		parctrls GENPARALLELINFO(ID) = 10;
E 7
D 4
        } = 2;
E 4
I 4
D 8
        } = 3;
E 4
} = 0x20000304;
E 8
I 8
        } = 1;
} = 390326;
E 8
E 1
