h35374
s 00018/00008/00887
d D 5.1 91/08/15 09:00:05 jochen 21 20
c CPU time from EXEC forwarded to parallel control job
e
s 00001/00001/00894
d D 4.14 91/07/09 17:04:07 jochen 20 19
c output for CREATE/STARTUP beautyfied
e
s 00003/00000/00892
d D 4.13 91/07/09 16:56:14 jochen 19 18
c bossgeneric 'multiBOSSyfied'
e
s 00001/00001/00891
d D 4.12 91/06/10 12:41:11 jochen 18 17
c /usr/rpc.startup used
e
s 00004/00002/00888
d D 4.11 91/05/31 09:14:41 jochen 17 16
c TRANSFER_TIME calculation corrected
e
s 00019/00001/00871
d D 4.10 91/04/29 17:52:01 jochen 16 15
c Transfertime calculated as average of current and last one
e
s 00002/00001/00870
d D 4.9 91/04/02 14:44:16 jochen 15 14
c Only EXEC-Servers in NETGROUP accepted
e
s 00005/00002/00866
d D 4.8 91/03/15 11:56:28 jochen 14 13
c Error messages corrected
e
s 00015/00004/00853
d D 4.7 91/03/15 11:00:29 jochen 13 12
c Support for SET ENTRY/[NO]SUSPEND added
e
s 00001/00003/00856
d D 4.6 91/03/04 14:30:44 jochen 12 11
c SET QUEUE and START/QUEUE /PARALLELSHELL Handling modified
e
s 00009/00002/00850
d D 4.5 91/02/28 14:53:50 jochen 11 10
c SET QUEUE changes from parallel to non-parallel restricted
e
s 00012/00009/00840
d D 4.4 91/02/26 17:25:37 jochen 10 9
c Jobkind now checked for jobs from EXEC-Queue
e
s 00128/00124/00721
d D 4.3 91/02/26 11:35:21 jochen 9 8
c Minor correction for QMan
e
s 00008/00000/00837
d D 4.2 91/02/20 14:42:26 jochen 8 7
c Flags for new 'jobinfo' elements added
e
s 00010/00010/00827
d D 4.1 91/02/20 13:26:14 jochen 7 6
c RPC number 390326 now reserved by SUN
e
s 00358/00158/00479
d D 3.5 91/02/20 13:20:12 jochen 6 5
c Functionality for parallel queues added
e
s 00001/00001/00636
d D 3.4 91/01/15 15:44:19 jochen 5 4
c SCCS addapted for common use
e
s 00010/00006/00627
d D 3.3 91/01/15 14:58:28 jochen 4 3
c modified to connect to EXEC-Queue version 3
e
s 00008/00008/00625
d D 3.2 91/01/08 17:31:44 jochen 3 2
c routine names corrected for RPC version 3
e
s 00001/00001/00632
d D 3.1 91/01/08 09:54:39 jochen 2 1
c IP address handling modified
e
s 00633/00000/00000
d D 2.1 91/01/02 15:26:41 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 4
I 4
D 6
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 6
I 6
static char sccsid_sgen_main_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 6
E 4
#endif

#define SGEN_MAIN

#define DEF
#include "sgen_hdr.h"

/*
  Asynchrone Bestaetigung einer EXEC-Queue.
*/
D 3
void *gennotify_2(not,msg)
E 3
I 3
D 7
void *gennotify_3(not,msg)
E 7
I 7
void *gennotify_1(not,msg)
E 7
E 3
jobdone *not;
struct svc_req *msg;
{
D 2
 long IPaddr = msg->rq_xprt->xp_raddr.sin_addr.s_addr;
E 2
I 2
 long IPaddr = ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr);
I 6
 subkind expected = skCONVERTER;
 jobctrl **prev,*job;
I 16
 parchan *pi,*pj;
 int del = -1,i,j;
E 16
E 6
E 2
 execctrl *scan;
 genctrl *gen;
I 17
 double tmp;
E 17
I 6
D 9
 int del = 0;
E 9
I 9
D 16
 int del = -1;
E 16
E 9
E 6

 /* Restart der EXEC-Queue bearbeiten */
D 4
 if ( not->pid == -1 )
E 4
I 4
D 6
 switch (not->pid)
E 6
I 6
D 9
 if ( not->pid == RESTARTPID )
E 9
I 9
 if ( not->info.kind == nkRESTART )
E 9
E 6
E 4
  {
D 4
   /* Broadcaster benachrichtigen */
   kill(epid,SIGALRM);
   /* Keine Antwort noetig */
   return (void *)0;
E 4
I 4
D 6
   case RESTARTPID   : /* Broadcaster benachrichtigen */
   		       kill(epid,SIGALRM);
   case TRANSDONEPID :
   case PARALLELPID  :
   case FILTERPID    : /* Keine Antwort noetig */
   		       return (void *)0;
E 6
I 6
   /* Broadcaster benachrichtigen */
   kill(epid,SIGALRM);
   /* Keine Antwort noetig */
   return (void *)0;
E 6
E 4
  }
 /* Zugehoerige EXEC-Queue suchen */
 for ( scan = Equeues ; scan && (scan->status.IPaddr != IPaddr) ; scan = scan->next );
 /* Kennung der EXEC-Queue muss stimmen */
 if ( scan )
  {
   if ( scan->status.queueID == not->queueID )
D 6
    /* Job suchen */ 
    if ( !findjob(scan,&scan->Ejobs,not,1) )
     for ( gen = Gqueues ; gen ; gen = gen->next )
      if ( findjob(scan,&gen->Rjobs,not,1) )
       break;
E 6
I 6
D 9
    if ( not->pid == TRANSDONEPID )
E 9
I 9
    if ( not->info.kind == nkTRANSDONE )
E 9
     {
I 16
      /* Mittelwerte berechnen um starke Schwankungen auszugleichen */
      for ( i = scan->trans_len, pi = scan->trans_val ; i-- ; pi++ )
       for ( j = not->jdTrans.parchans_len, pj = not->jdTrans.parchans_val ; j-- ; pj++ )
	if ( pi->IPaddr == pj->IPaddr )
	 if ( (pj->IPsecs < 0) || (pj->IPusecs < 0) )
	  {
	   pj->IPsecs = pi->IPsecs;
	   pj->IPusecs = pi->IPusecs; 
	  }
         else if ( (pi->IPsecs >= 0) && (pi->IPusecs >= 0) )
	  {
	   /* Mittelwert ermitteln */
D 17
	   pj->IPsecs = (pi->IPsecs+pj->IPsecs+1)/2;
	   pj->IPusecs = (pi->IPusecs+pj->IPusecs+1)/2;
E 17
I 17
	   tmp = ((pi->IPsecs+pj->IPsecs)*1E6+(pi->IPusecs+pj->IPusecs+1))/2;
	   pj->IPsecs = tmp/1E6;
	   pj->IPusecs = tmp-pj->IPsecs*1E6;
E 17
	   /* Naechten Eintrag */
	   break;
	  }
E 16
      /* Alte Informationen loeschen */
      xdr_free(xdr_parchans,&scan->tcpinfo);
      /* Neue Informationen uebernehmen */
      time(&scan->tcpstamp);
D 9
      scan->tcpinfo = not->conn;
E 9
I 9
      scan->tcpinfo = not->jdTrans;
E 9
      /* Und sicherstellen, dass sie vom RPC/XDR nicht geloescht werden */
D 9
      not->conn.parchans_len = 0;
      not->conn.parchans_val = 0;
E 9
I 9
      not->jdTrans.parchans_len = 0;
      not->jdTrans.parchans_val = 0;
E 9
      /* Naechste EXEC-Queue belaestigen */
      scan->transid = transcur;
      transtick = 1;
     }
    else 
     {
      /* Was ist zu tun */
D 9
      if ( not->pid == PARALLELPID )
E 9
I 9
      if ( not->info.kind == nkPARALLEL )
E 9
       expected = skPARALLEL;
D 9
      else if ( not->pid != CONVERTERPID )
E 9
I 9
      else if ( not->info.kind != nkCONVERTER )
E 9
       del = 1;
      /* Job suchen */ 
      if ( !(prev = findjob(scan,&scan->Ejobs,not,del)) )
       for ( gen = Gqueues ; gen ; gen = gen->next )
        if ( (prev = findjob(scan,&gen->Rjobs,not,del)) )
         break;
      /* Job bearbeiten */
D 10
      if ( !del && prev && ((job = *prev)->execReq.kind == expected) )
E 10
I 10
      if ( (del == -1) && prev && ((job = *prev)->execReq.kind == expected) )
E 10
       if ( expected == skPARALLEL )
	{
	 /* Alte Informationen loeschen */
	 xdr_free(xdr_anychan,&job->channels);
	 /* Neue Informationen uebernehmen */
	 job->channels.kind = skPARALLEL;
D 9
	 job->channels.anychan_u.pchans = not->conn;
E 9
I 9
	 job->channels.anychan_u.pchans = not->jdUnits;
E 9
	 /* Und sichern */
D 9
	 not->conn.parchans_len = 0;
	 not->conn.parchans_val = 0;
E 9
I 9
	 not->jdUnits.parchans_len = 0;
	 not->jdUnits.parchans_val = 0;
E 9
	}
       else
	{
	 /* Alte Informationen sichern */
	 if ( job->channels.kind == skNORMAL )
	  {
	   job->channels.anychan_u.cchans[0].converterchans_len = 0;
	   job->channels.anychan_u.cchans[0].converterchans_val = 0;
	  }
	 else
	  {
	   xdr_free(xdr_converterchans,job->channels.anychan_u.cchans+0);
	   job->channels.anychan_u.cchans[0] = job->channels.anychan_u.cchans[1];
	  }
	 /* Neue Informationen uebernehmen */
	 job->channels.kind = skCONVERTER;
D 9
	 job->channels.anychan_u.cchans[1] = not->perf;
E 9
I 9
	 job->channels.anychan_u.cchans[1] = not->jdChans;
E 9
	 /* Und sichern */
D 9
	 not->perf.converterchans_len = 0;
	 not->perf.converterchans_val = 0;
E 9
I 9
	 not->jdChans.converterchans_len = 0;
	 not->jdChans.converterchans_val = 0;
E 9
	}
     }
E 6
   /* EXEC-Kennung vermerken */
   addAck(scan,not->ackID);
  }
 /* Niemals beantworten */
 return (void *)0; 
}

/*
  Eindeutige Nummer verteilen.
*/
D 3
ID *genuniqueid_2(null,msg)
E 3
I 3
D 7
ID *genuniqueid_3(null,msg)
E 7
I 7
ID *genuniqueid_1(null,msg)
E 7
E 3
void (*null)();
struct svc_req *msg;
{
 static ID res;

 /* Ergebnis melden */
 res = ++uniqueCnt;
 return &res; 
}

/*
  Der Nebenprozess hat eine neue EXEC-Queue gefunden.
*/
D 3
int *gennewexec_2(info,msg)
E 3
I 3
D 7
int *gennewexec_3(info,msg)
E 7
I 7
int *gennewexec_1(info,msg)
E 7
E 3
statusinfo *info;
struct svc_req *msg;
{
I 6
 execctrl *scan,*exe;
E 6
 static int added;
D 6
 execctrl *scan;
E 6
 hostinfo gen;
 ID qID,oldID;
 int new;
 
 /* Rueckgabewert initialisieren */
 added = 0;
 /* Nachsehen, ob diese EXEC-Queue bereits bekannt ist */
 for ( scan = Equeues ; scan ; scan = scan->next )
  if ( scan->status.IPaddr == info->IPaddr )
   {
    /* Eventuell in der Backupdatei vermerken */
    new = strcmpi(info->name,scan->status.name);
    /* Vorherigen Speicher freigeben */
D 10
    free(scan->status.name);
E 10
I 10
    xdr_free(xdr_statusinfo,&scan->status);
E 10
    /* Aktuelle Informationen uebertragen */
    oldID = scan->status.queueID;
    scan->status = *info;
    time(&scan->stamp);
    /* Eingabestruktur aufraeumen */
    info->name = 0;
    /* In der Backupdatei vermerken */
    if ( new ) backexec(scan,0);
    /* Erfolg notieren und Suche beenden */
    scan->retry = RETRY0;
    break;
   }
 /* Nun mal sehen, was zu tun ist */
 if ( info->queueID && scan && (info->queueID == oldID) )
  added = 1;
 else
  {
   /* Neue Verwaltungsstruktur fuer eine weitere EXEC-Queue erzeugen */
   if ( !scan )
    {
     /* Nachsehen, ob es eine Queue mit diesem Namen schon gibt */
     for ( scan = Equeues ; scan ; scan = scan->next )
      if ( !strcmpi(scan->status.name,info->name) )
       {
	lprintf("Duplicate EXEC-Queue %s found, please reconfigure InterNet\n",info->name);
	return &added;
       }
     /* Speicher reservieren */
D 9
     if ( !(scan = MALLOC(execctrl,1)) )
E 9
I 9
     if ( !(scan = SALLOC(execctrl)) )
E 9
      {
       lprintf("Out of memory while processing new EXEC-Queue\n");
       return &added;
      }
     /* Initialisieren */
     scan->execID = ++execCnt;
     scan->execaddr = (int)scan;
     scan->state = qNORMAL;
     scan->back.pos = -1;
     scan->Ejobs = 0;
     scan->cl = 0;
D 10
     scan->ctrl = scan->all = scan->ack_len = scan->jobs = scan->lastjob = 0;
I 6
     scan->trans_len = scan->transid = 0;
E 10
I 10
     scan->ctrl = scan->all = scan->ack_len = scan->jobs = scan->lastjob = scan->trans_len = 0;
     scan->ratio = scan->val = 0.0;
     scan->transid = transcur;
E 10
     scan->trans_val = 0;
E 6
     scan->ack_IDs = 0;
     /* Information uebertragen und Informationsstruktur aufraeumen */
     scan->status = *info;
     time(&scan->stamp);
     info->name = 0;
     /* Verketten */
     scan->next = Equeues;
     Equeues = scan;
     /* Vermerken */
     epinfo("Added",&scan->status);
     added = 1;
     /* In die Backupdatei eintragen */
     backexec(scan,1);
I 9
     /* Demnaechst neue Performancemessung veranstalten */
     for ( exe = Equeues ; exe ; exe = exe->next ) exe->tcpstamp = 0;
     transtick = 1;
     transcur++;
E 9
    }
I 6
D 9
   /* Demnaechst neue Performancemessung veranstalten */
   for ( exe = Equeues ; exe ; exe = exe->next ) exe->tcpstamp = 0;
   transtick = 1;
   transcur++;
E 9
E 6
   /* Initialisierung globaler Parameter */
   scan->status.queueID = 0;
   scan->retry = RETRY0;
   /* Aenderung in der Backupdatei vermerken */
   backexec(scan,0);
   /* Alle zugehoerigen Jobs freigeben */
   deljobs(scan,"state transition",1);
   /* Weitere Aktionen durchfuehren */
   if ( info->queueID )
    {
     /* EXEC-Queue von der vorherigen GEN-Queue loesen */
     if ( !detach(&scan->cl,info->IPaddr,&info->queueID) )
      {
       scan->retry--;
       epinfo("Detaching",&scan->status);
       added = 0;
       return &added;
      }
     /* Losloesung hat funktioniert */
     epinfo("Detached",&scan->status);
    }
   /* EXEC-Queue an diese GEN-Queue binden */
   gen.prog = GENPROG;
   gen.vers = GENVERS;
   if ( !attach(&scan->cl,info->IPaddr,&gen,&qID) )
    {
     scan->retry--;
     added = 0;
    }
   else
    {
     scan->status.queueID = qID;
     epinfo("Attached",&scan->status);
     /* Aenderung in der Backupdatei vermerken */
     backexec(scan,0);
    }
  }
 /* Fertig */
 return &added;
}

/*
  Neuen Job in einer Generic-Queue starten.
*/
D 3
text *genjobaction_2(job,msg)
E 3
I 3
D 7
text *genjobaction_3(job,msg)
E 7
I 7
text *genjobaction_1(job,msg)
E 7
E 3
submit *job;
struct svc_req *msg;
{
 static char mess[256];
 static text res = mess;
 execctrl *exec = 0,*rexec;
 jobctrl **jp,*jobc,*nj;
 genctrl *gen = 0,*rgen;
 struct unique *uID;
 control ctrl;
 int jk,n;

 /* Nachsehen, ob der Manager gestoppt ist */
 if ( master.stopped )
  {
   strcpy(mess,"Queue manager is stopped");
   return &res;
  }
 /* Name der Queue umsetzen */
 if ( ((job->info.kind == sSUBMIT) || *job->qinfo.queue) &&
      !findpair(job->qinfo.queue,&gen,&exec,mess) )
  return &res;
 /* Initialisieren */
I 9
 rgen = gen;
 rexec = exec;
E 9
 strcpy(mess,"Not authorized for attempted operation");
 /* Nachsehen, ob diese Anfrage bereits getaetigt wurde */
 if ( uID = findID(job->qinfo.requestID) )
  strcpy(mess,uID->answer);
 else
  /* Selektieren */
  switch (job->info.kind)
   {
D 6
    case sSUBMIT : /* Queue ueberpruefen */
      		   if ( (gen->state == qSTOPPED) || (exec && (exec->state == qSTOPPED)) )
		    {
		     sprintf(mess,"Queue %s is stopped",job->qinfo.queue);
		     break;
		    }
      		   /* Authorisierung ueberpruefen */
		   if ( !authorized(msg,job->Jinfo.uid) ) break;
		   /* Initialisieren */
		   strcpy(mess,"Out of memory");
I 4
		   /* Art des Jobs festhalten */
D 5
		   job->kind = skNORMAL;
E 5
I 5
		   job->Jinfo.kind = skNORMAL;
E 5
E 4
		   /* Aktion durchfuehren */
		   submitjob(gen,job,mess,exec);
		   break;
    case sSTOP   : /* Job neu starten */
      		   if ( !(jk = jobkind(&jp,job->Jinfo.requestID,gen,exec)) )
		    notfound(mess,job->Kinfo.requestID,job->qinfo.queue);
		   else if ( !authorized(msg,(jobc = *jp)->execReq.uid) )
		    jk = 0;
		   else if ( (jk == 'R') || (jk == 'E') )
		    {
		     ctrl.next = -2;
		     ctrl.requeue = job->qinfo.requeue;
		     ctrl.hold = job->hold;
		     ctrl.prio = job->Jinfo.nice;
		     abortjob(jobc,jk,&ctrl);
		     /* Alles in Ordung */
		     *mess = '\0';
		    }
		   /* Nur bei Jobs, die nicht in der Warteschlange sind */
		   if ( jp != 'P' )
		    {
		     /* Logdatei fuellen */
		     if ( *mess ) lprintf("%s\n",mess);
		     /* Information eintragen */
		     addID(job->qinfo.requestID,mess);
		     break;
		    }
    case sMODIFY : /* Job suchen */
      		   if ( !(jk = jobkind(&jp,job->Jinfo.requestID,gen,exec)) )
		    notfound(mess,job->Jinfo.requestID,job->qinfo.queue);
		   else if ( authorized(msg,(jobc = *jp)->execReq.uid) )
		    if ( jk != 'P' )
		     sprintf(mess,"Job %d already executing",jobc->jobID);
		    else if ( !(job->uflags&ufREQUEUE) || 
			      findpair(job->qinfo.requeue,&rgen,&rexec,mess) )
		     {
		      /* Normale Parameter uebernehmen und anpassen */
		      if ( job->uflags&ufCPUTIME ) jobc->execReq.cpu = job->Jinfo.cpu;
		      if ( job->uflags&ufPRIORITY ) jobc->execReq.nice = job->Jinfo.nice;
		      if ( job->uflags&ufDATA ) jobc->execReq.data = job->Jinfo.data;
		      if ( job->uflags&ufSTACK ) jobc->execReq.stack = job->Jinfo.stack;
		      if ( job->uflags&ufMEMORY ) jobc->execReq.memory = job->Jinfo.memory;
		      cutjob(&jobc->request,gen,job->uflags);
		      /* Parameter uebernehmen */
		      if ( job->uflags&ufAFTER ) jobc->request.at = job->at;
		      if ( job->uflags&ufHOLD ) jobc->request.hold = job->hold;
		      if ( job->uflags&ufRESTART ) jobc->request.restart = job->restart;
		      if ( job->uflags&ufRMSFILE )
		       jobc->execReq.rmsfile = job->Jinfo.rmsfile;
		      /* Parameter uebernehmen mit Loeschen */
		      if ( job->uflags&ufNOTIFY )
E 6
I 6
    case sSUBMIT    : /* Queue ueberpruefen */
		      if ( (gen->state == qSTOPPED) || (exec && (exec->state == qSTOPPED)) )
E 6
		       {
D 6
			free(jobc->genReq.user);
			free(jobc->genReq.host);
			jobc->genReq.user = job->qinfo.user;
			jobc->genReq.host = job->qinfo.host;
			job->qinfo.user = job->qinfo.host = 0;
E 6
I 6
			sprintf(mess,"Queue %s is stopped",job->qinfo.queue);
			break;
E 6
		       }
D 6
		      if ( job->uflags&ufCLI )
E 6
I 6
		      /* Authorisierung ueberpruefen */
		      if ( !authorized(msg,job->Jinfo.uid) ) break;
		      /* Initialisieren */
		      strcpy(mess,"Out of memory");
		      /* Aktion durchfuehren */
		      submitjob(gen,job,mess,exec);
		      break;
    case sSTOP      : /* Job neu starten */
		      if ( !(jk = jobkind(&jp,job->Jinfo.requestID,gen,exec)) )
		       notfound(mess,job->Kinfo.requestID,job->qinfo.queue);
		      else if ( !authorized(msg,(jobc = *jp)->execReq.uid) ||
			        jobc->request.leader )
		       jk = 0;
		      else if ( (jk == 'R') || (jk == 'E') )
E 6
		       {
D 6
			free(jobc->execReq.shell);
			jobc->execReq.shell = job->Jinfo.shell;
			job->Jinfo.shell = 0;
E 6
I 6
			ctrl.next = -2;
			ctrl.requeue = job->qinfo.requeue;
			ctrl.hold = job->hold;
			ctrl.prio = job->Jinfo.nice;
			abortjob(jobc,jk,&ctrl);
			/* Alles in Ordung */
			*mess = '\0';
E 6
		       }
D 6
		      if ( job->uflags&ufLOGFILE )
E 6
I 6
		      /* Nur bei Jobs, die nicht in der Warteschlange sind */
		      if ( jk != 'P' )
E 6
		       {
D 6
			free(jobc->execReq.log);
			jobc->execReq.log = job->Jinfo.log;
			job->Jinfo.log = 0;
E 6
I 6
			/* Logdatei fuellen */
			if ( *mess ) lprintf("%s\n",mess);
			/* Information eintragen */
			addID(job->qinfo.requestID,mess);
			break;
E 6
		       }
D 6
		      if ( job->uflags&ufNAME )
		       {
			free(jobc->request.name);
			jobc->request.name = job->name;
			job->name = 0;
		       }
		      if ( job->uflags&ufPARAMETERS )
		       {
			if ( jobc->execReq.param.param_val )
			 {
			  for ( n = jobc->execReq.param.param_len ; n-- ; )
			   free(jobc->execReq.param.param_val[n]);
			  free(jobc->execReq.param.param_val);
			 }
			jobc->execReq.param = job->Jinfo.param;
			job->Jinfo.param.param_len = 0;
			job->Jinfo.param.param_val = 0;
		       }
		      /* REQUEUE bearbeiten */
		      if ( job->uflags&ufREQUEUE )
		       {
			/* In der neuen GEN-Queue einnisten */
			*jp = jobc->next;
			addTail(&rgen->Pjobs,jobc);
			/* Referenzen setzen */
			jobc->jgen = rgen;
			jobc->jexec = rexec;
			/* Name der Queue uebertragen */
			free(jobc->genReq.queue);
			jobc->genReq.queue = job->qinfo.requeue;
			job->qinfo.requeue = 0;
			*jobc->genReq.requeue = '\0';
		       }
		      /* Informationen updaten */
		      backjob(jobc,0);
		      /* Alles in Ordnung */
		      *mess = '\0';
		     }
		   /* Information eintragen */
		   addID(job->qinfo.requestID,mess);
		   break;		   
    case sCANCEL : /* Job suchen */
      		   if ( !(jk = jobkind(&jp,job->Kinfo.requestID,gen,exec)) )
		    notfound(mess,job->Kinfo.requestID,job->qinfo.queue);
		   else if ( authorized(msg,(jobc = *jp)->execReq.uid) )
		    /* Aktionen je nach Jobzustand durchfuehren */
		    switch (jk)
		     {
		      case 'P' : if ( jobc->jexec )
				  strcpy(mess,jobon(jobc));
				 else
				  sprintf(mess,"Job %d on queue %s ",
					       jobc->jobID,jobc->jgen->name);
				 remjob(jp,mess,"aborted before execution");
				 *mess = '\0';
				 break;
		      case 'R' :
		      case 'E' : sendkill(jobc,jk,mess,job);
				 break;
		     }
		   /* Logdatei fuellen */
		   if ( *mess ) lprintf("%s\n",mess);
		   /* Information eintragen */
		   addID(job->qinfo.requestID,mess);
		   break;
    default      : /* Fehler melden */
		   strcpy(mess,"Unimplemented operation");
E 6
I 6
    case sMODIFY    : /* Job suchen */
		      if ( !(jk = jobkind(&jp,job->Jinfo.requestID,gen,exec)) )
		       notfound(mess,job->Jinfo.requestID,job->qinfo.queue);
D 13
		      else if ( authorized(msg,(jobc = *jp)->execReq.uid) && 
				!jobc->request.leader )
		       if ( jk != 'P' )
E 13
I 13
		      else if ( authorized(msg,(jobc = *jp)->execReq.uid) )
		       if ( jobc->request.leader )
			{
			 /* Parallelteilprogramm anhalten oder fortsetzen */
D 14
			 if ( (jk == 'R') && 
			      ((job->uflags == ufSUSPEND) || (job->uflags == ufRESUME)) )
E 14
I 14
			 if ( jk != 'R' )
			  sprintf(mess,"Job %d is not running",jobc->jobID);
			 else if ( (job->uflags == ufSUSPEND) || (job->uflags == ufRESUME) )
E 14
			  {
		           /* Aktionen je nach Jobzustand durchfuehren */
		           sendkill(jobc,jk,mess,(submit *)0,job->uflags);
		           /* Logdatei fuellen */
		           if ( *mess ) lprintf("%s\n",mess);
			  }
			}
I 14
		       else if ( (job->uflags == ufSUSPEND) || (job->uflags == ufRESUME) )
			sprintf(mess,"Job %d is not a partial parallel job",jobc->jobID);
E 14
		       else if ( jk != 'P' )
E 13
			sprintf(mess,"Job %d already executing",jobc->jobID);
		       else if ( !(job->uflags&ufREQUEUE) || 
				 findpair(job->qinfo.requeue,&rgen,&rexec,mess) )
D 9
			{
			 /* Normale Parameter uebernehmen und anpassen */
			 if ( job->uflags&ufCPUTIME ) jobc->execReq.cpu = job->Jinfo.cpu;
			 if ( job->uflags&ufPRIORITY ) jobc->execReq.nice = job->Jinfo.nice;
			 if ( job->uflags&ufDATA ) jobc->execReq.data = job->Jinfo.data;
			 if ( job->uflags&ufSTACK ) jobc->execReq.stack = job->Jinfo.stack;
			 if ( job->uflags&ufMEMORY ) jobc->execReq.memory = job->Jinfo.memory;
			 cutjob(&jobc->request,gen,job->uflags);
			 /* Parameter uebernehmen */
			 if ( job->uflags&ufAFTER ) jobc->request.at = job->at;
			 if ( job->uflags&ufHOLD ) jobc->request.hold = job->hold;
			 if ( job->uflags&ufRESTART ) jobc->request.restart = job->restart;
			 if ( job->uflags&ufRMSFILE )
			  jobc->execReq.rmsfile = job->Jinfo.rmsfile;
I 8
			 if ( job->uflags&ufDELCOM ) jobc->execReq.delcom = job->Jinfo.delcom;
			 if ( job->uflags&ufDELLOG ) jobc->execReq.dellog = job->Jinfo.dellog;
E 8
			 /* Parameter uebernehmen mit Loeschen */
			 if ( job->uflags&ufNOTIFY )
			  {
			   free(jobc->genReq.user);
			   free(jobc->genReq.host);
			   jobc->genReq.user = job->qinfo.user;
			   jobc->genReq.host = job->qinfo.host;
			   job->qinfo.user = job->qinfo.host = 0;
			  }
			 if ( job->uflags&ufCLI )
			  {
			   free(jobc->execReq.shell);
			   jobc->execReq.shell = job->Jinfo.shell;
			   job->Jinfo.shell = 0;
			  }
			 if ( job->uflags&ufLOGFILE )
			  {
			   free(jobc->execReq.log);
			   jobc->execReq.log = job->Jinfo.log;
			   job->Jinfo.log = 0;
			  }
			 if ( job->uflags&ufNAME )
			  {
			   free(jobc->request.name);
			   jobc->request.name = job->name;
			   job->name = 0;
I 8
			  }
			 if ( job->uflags&ufPRINT )
			  {
			   free(jobc->execReq.print);
			   jobc->execReq.print = job->Jinfo.print;
			   job->Jinfo.print = 0;
E 8
			  }
			 if ( job->uflags&ufPARAMETERS )
			  {
			   if ( jobc->execReq.param.param_val )
			    {
			     for ( n = jobc->execReq.param.param_len ; n-- ; )
			      free(jobc->execReq.param.param_val[n]);
			     free(jobc->execReq.param.param_val);
			    }
			   jobc->execReq.param = job->Jinfo.param;
			   job->Jinfo.param.param_len = 0;
			   job->Jinfo.param.param_val = 0;
			  }
			 /* REQUEUE bearbeiten */
			 if ( job->uflags&ufREQUEUE )
			  {
			   /* In der neuen GEN-Queue einnisten */
			   *jp = jobc->next;
			   addTail(&rgen->Pjobs,jobc);
			   /* Referenzen setzen */
			   jobc->jgen = rgen;
			   jobc->jexec = rexec;
			   /* Name der Queue uebertragen */
			   free(jobc->genReq.queue);
			   jobc->genReq.queue = job->qinfo.requeue;
			   job->qinfo.requeue = 0;
			   *jobc->genReq.requeue = '\0';
			  }
			 /* Informationen updaten */
			 backjob(jobc,0);
			 /* Alles in Ordnung */
			 *mess = '\0';
			}
E 9
I 9
			if ( (*(gen = gen ? gen : jobc->jgen)->pdl == '\0') !=
			     (*(rgen = rgen ? rgen : gen)->pdl == '\0') )
			 if ( *gen->pdl )
			  sprintf(mess,"Job %d is a parallel job",jobc->jobID);
		         else
			  sprintf(mess,"Job %d is not a parallel job",jobc->jobID);
		        else if ( !makeshell(job,rgen) )
			 sprintf(mess,"Could not create correct value for shell path");
		        else if ( !makeprint(job,rgen) )
			 sprintf(mess,"Could not create correct value for printer name");
			else if ( (job->uflags&ufPARAMETERS) && jobc->leader &&
				  !makeparallel(job,jobc->leader) )
			 sprintf(mess,"Could not create parallel context");
			else
			 {
			  /* Normale Parameter uebernehmen und anpassen */
			  if ( job->uflags&ufCPUTIME ) jobc->execReq.cpu = job->Jinfo.cpu;
			  if ( job->uflags&ufPRIORITY ) jobc->execReq.nice = job->Jinfo.nice;
			  if ( job->uflags&ufDATA ) jobc->execReq.data = job->Jinfo.data;
			  if ( job->uflags&ufSTACK ) jobc->execReq.stack = job->Jinfo.stack;
			  if ( job->uflags&ufMEMORY ) jobc->execReq.memory = job->Jinfo.memory;
			  cutjob(&jobc->request,gen,job->uflags,0);
			  /* Parameter uebernehmen */
			  if ( job->uflags&ufAFTER ) jobc->request.at = job->at;
			  if ( job->uflags&ufHOLD ) jobc->request.hold = job->hold;
			  if ( job->uflags&ufRESTART ) jobc->request.restart = job->restart;
			  if ( job->uflags&ufRMSFILE )
			   jobc->execReq.rmsfile = job->Jinfo.rmsfile;
			  if ( job->uflags&ufDELCOM ) jobc->execReq.delcom = job->Jinfo.delcom;
			  if ( job->uflags&ufDELLOG ) jobc->execReq.dellog = job->Jinfo.dellog;
			  /* Parameter uebernehmen mit Loeschen */
			  if ( job->uflags&ufNOTIFY )
			   {
			    free(jobc->genReq.user);
			    jobc->genReq.user = job->qinfo.user;
			    jobc->genReq.host = job->qinfo.host;
			    job->qinfo.user = 0;
			   }
			  if ( (job->uflags&ufCLI) || *rgen->pdl ) 
			   {
			    free(jobc->execReq.shell);
			    jobc->execReq.shell = job->Jinfo.shell;
			    job->Jinfo.shell = 0;
			   }
			  if ( job->uflags&ufLOGFILE )
			   {
			    free(jobc->execReq.log);
			    jobc->execReq.log = job->Jinfo.log;
			    job->Jinfo.log = 0;
			   }
			  if ( job->uflags&ufNAME )
			   {
			    free(jobc->request.name);
			    jobc->request.name = job->name;
			    job->name = 0;
			   }
			  if ( job->uflags&ufPRINT )
			   {
			    free(jobc->execReq.print);
			    jobc->execReq.print = job->Jinfo.print;
			    job->Jinfo.print = 0;
			   }
			  if ( job->uflags&ufPARAMETERS )
			   {
			    if ( jobc->Param_val )
			     {
			      for ( n = jobc->Param_len ; n-- ; ) free(jobc->Param_val[n]);
			      free(jobc->Param_val);
			     }
			    jobc->execReq.param = job->Jinfo.param;
			    job->Jinfo.param.param_len = 0;
			    job->Jinfo.param.param_val = 0;
			   }
			  /* REQUEUE bearbeiten */
			  if ( job->uflags&ufREQUEUE )
			   {
			    /* Parameter an die neue Queue anpassen */
			    cutjob(&jobc->request,gen,-1,1);
			    cutjob(&jobc->request,rgen,-1,0);
			    /* In der neuen GEN-Queue einnisten */
			    *jp = jobc->next;
			    addTail(&rgen->Pjobs,jobc);
			    /* Referenzen setzen */
			    jobc->jgen = rgen;
			    jobc->jexec = rexec;
			    /* Name der Queue uebertragen */
			    free(jobc->genReq.queue);
			    jobc->genReq.queue = job->qinfo.requeue;
			    job->qinfo.requeue = 0;
			    *jobc->genReq.requeue = '\0';
			   }
			  /* Informationen updaten */
			  backjob(jobc,0);
			  /* Alles in Ordnung */
			  *mess = '\0';
			 }
E 9
		      /* Information eintragen */
		      addID(job->qinfo.requestID,mess);
		      break;		   
    case sCANCEL    : /* Job suchen */
		      if ( !(jk = jobkind(&jp,job->Kinfo.requestID,gen,exec)) )
		       notfound(mess,job->Kinfo.requestID,job->qinfo.queue);
		      else if ( authorized(msg,(jobc = *jp)->execReq.uid) &&
				!jobc->request.leader )
		       /* Aktionen je nach Jobzustand durchfuehren */
D 9
		       switch (jk)
			{
			 case 'P' : if ( jobc->jexec )
				     strcpy(mess,jobon(jobc));
				    else
				     sprintf(mess,"Job %d on queue %s ",
						  jobc->jobID,jobc->jgen->name);
				    remjob(jp,mess,"aborted before execution");
				    *mess = '\0';
				    break;
			 case 'R' :
			 case 'E' : sendkill(jobc,jk,mess,job);
				    break;
			}
E 9
I 9
D 13
		       sendkill(jobc,jk,mess,job);
E 13
I 13
		       sendkill(jobc,jk,mess,job,0);
E 13
E 9
		      /* Logdatei fuellen */
		      if ( *mess ) lprintf("%s\n",mess);
		      /* Information eintragen */
		      addID(job->qinfo.requestID,mess);
		      break;
    case sCONVERTER : /* Job suchen */
		      if ( !(jk = jobkind(&jp,job->Cinfo.requestID,gen,exec)) )
		       notfound(mess,job->Cinfo.requestID,job->qinfo.queue);
		      else if ( authorized(msg,(jobc = *jp)->execReq.uid) &&
				jobc->request.leader && (jobc->execReq.kind == skCONVERTER) )
		       /* Aktion je nach Jobzustand durchfuehren */
D 9
		       if ( jk == 'R' )
E 9
I 9
		       if ( (jk == 'R') || (jk == 'E') )
E 9
			{
			 /* Informationen vervollstaendigen */
D 9
			 job->Cinfo.pid = jobc->pid;
E 9
I 9
			 job->Cinfo.pid = (jk == 'R') ? jobc->pid : -jobc->jobID;
E 9
			 /* Und abschicken */
			 sendconverter(jobc,mess,job);
			}
D 9
		       else
E 9
I 9
		       else 
E 9
			sprintf(mess,"%s is not running ",jobon(jobc));
		      /* Logdatei fuellen */
		      if ( *mess ) lprintf("%s\n",mess);
		      /* Information eintragen */
		      addID(job->qinfo.requestID,mess);
		      break;
    default         : /* Fehler melden */
		      strcpy(mess,"Unimplemented operation");
E 6
   }
 /* Erfolg melden */
 return &res;
}

/*
  Zustand eines Jobs abfragen.
*/
D 3
Jstate *gensynchronize_2(sync,msg)
E 3
I 3
D 7
Jstate *gensynchronize_3(sync,msg)
E 7
I 7
Jstate *gensynchronize_1(sync,msg)
E 7
E 3
syncctrl *sync;
struct svc_msg *msg;
{
 static Jstate res;
 struct jobctrl **jp,*jc = 0,*jc0 = 0;
 struct genctrl *gen = 0,*sg;
 struct execctrl *exe;
 int nj = 0;

 /* Ergebnis initialisieren */
 res = jNONE;
 /* Nachsehen, ob der Manager gestoppt ist */
 if ( master.stopped ) return &res;
 /* Queue suchen */
 if ( *sync->queue && !findpair(sync->queue,&gen,&exe,(char *)0) ) return &res;
 /* Job suchen */
 if ( *sync->name )
  {
   /* Per Namen suchen */
   for ( sg = Gqueues ; sg ; sg = sg->next )
    {
     /* Wartende Jobs */
     for ( jc = sg->Pjobs ; jc ; jc = jc->next )
      if ( !strcmpi(jc->request.name,sync->name) )
       {
        jc0 = jc;
        nj++;
       }
     /* Laufende Jobs */
     for ( jc = sg->Rjobs ; jc ; jc = jc->next )
      if ( !strcmpi(jc->request.name,sync->name) )
       {
        jc0 = jc;
        nj++;
       }
    }
   for ( exe = Equeues ; exe ; exe = exe->next )
    /* oder fehlerhafte Jobs */
    for ( jc = exe->Ejobs ; jc ; jc = jc->next )
D 10
     if ( !strcmpi(jc->request.name,sync->name) )
E 10
I 10
     if ( ISSUBMIT(jc) && !strcmpi(jc->request.name,sync->name) )
E 10
      {
       jc0 = jc;
       nj++;
      }
   /* Der Name muss eindeutig sein */
   if ( (nj == 1) && (!gen || ((jc0->jgen == gen) && (!exe || (jc0->jexec == exe)))) )
    jc = jc0;
  }
 else if ( jobkind(&jp,sync->jID,gen,exe) )
  jc = *jp;
 /* Authorisierung ueberpruefen */
 if ( jc && authorized(msg,jc->execReq.uid) ) res = jc->state;
 /* Fertig */
 return &res;
}

/*
  Alle Informationen des GEN-Queue Servers auslesen.
*/
D 3
masterctrl *geninfo_2(null)
E 3
I 3
D 7
masterctrl *geninfo_3(null)
E 7
I 7
masterctrl *geninfo_1(null)
E 7
E 3
void (*null)();
{
 /* Nichts einfacher als das */
 return &master;
}

/*
  Aktionen mit einer GEN-Queue durchfuehren.
*/
D 3
text *genqueueaction_2(ctrl,msg)
E 3
I 3
D 7
text *genqueueaction_3(ctrl,msg)
E 7
I 7
text *genqueueaction_1(ctrl,msg)
E 7
E 3
control *ctrl;
struct svc_req *msg;
{
 static char mess[256];
 static text res = mess;
 struct genctrl *gen,**gp,*rgen;
 struct execctrl *exe,*rexe;
 struct jobctrl *job;
 struct unique *uID;

 /* Nachsehen, ob Manager angehalten ist */
 if ( master.stopped )
  {
   strcpy(mess,"Queue manager is stopped");
   return &res;
  }
 /* Authorisierung ueberpruefen */
 if ( !authorized(msg,0) )
  {
   strcpy(mess,"operation requires OPER privilege on remote host");
   return &res;
  }
 /* Nachsehen, ob diese Anfrage bereits getaetigt wurde */
 if ( uID = findID(ctrl->requestID) )
  {
   strcpy(mess,uID->answer);
   return &res;
  }
 /* /REQUEUE-Parameter beachten */
 if ( *ctrl->requeue && !findpair(ctrl->requeue,&rgen,&rexe,mess) ) return &res;
 /* Nachricht initialisieren */
 *mess = '\0';
 /* Name muss zu einer GEN-Queue passen */
 if ( strchr(ctrl->gen.name,'_') )
  if ( (ctrl->kind != cMODIFY) || ((ctrl->iflags != ifSTART) && (ctrl->iflags != ifSTOP)) )
   {
    sprintf(mess,"'%s' is not legal name for a generic queue",ctrl->gen.name);
    return &res;
   }
  else
   {
    /* Ansonsten ist nur START und STOP erlaubt */
    if ( findpair(ctrl->gen.name,&gen,&exe,mess) )
     {
      if ( ctrl->iflags == ifSTART )
       exe->state = qNORMAL;
      else
       {
        if ( ctrl->next != -2 ) exe->state = qSTOPPED;
        /* Jobs entfernen */
        for ( gen = Gqueues ; gen ; gen = gen->next )
	 for ( job = gen->Rjobs ; job ; job = job->next )
	  if ( job->jexec == exe )
	   abortjob(job,'R',ctrl);
        abortjobs(exe->Ejobs,'E',ctrl);
       }
      /* Zustand in der Backupdatei vermerken */
      backexec(exe,0);
     }
    /* Fertig */
    addID(ctrl->requestID,mess);
    return &res;
   }
 /* Name einer neu erzeugten Queue muss eindeutig sein */
 for ( gp = &Gqueues ; gen = *gp ; gp = &gen->next )
  if ( !strcmpi(ctrl->gen.name,gen->name) )
   if ( ctrl->kind == cINIT )
    {
     sprintf(mess,"queue '%s' already exists",ctrl->gen.name);
     return &res;
    }
   else
    break;
 /* Nur existierende Queues koennen modifiziert werden */
 if ( !gen && (ctrl->kind != cINIT) )
  {
   sprintf(mess,"queue '%s' not found",ctrl->gen.name);
   return &res;
  }
D 11
 /* Queue loeschen */
 if ( ctrl->kind == cDELETE )
E 11
I 11
 /* Bei DELETE/QUEUE und Aendern einer Queue von Parallelqueue in normale Queue und */
 /* umgekehrt duerfen keine Jobs in dieser Queue vorhanden sein.		    */
D 12
 if ( (ctrl->kind == cDELETE) || 
      ((ctrl->kind == cMODIFY) && (ctrl->iflags&ifPDL) &&
       (*gen->pdl == '\0') != (*ctrl->gen.pdl == '\0')) )
E 12
I 12
 if ( (ctrl->kind == cDELETE) || ((ctrl->kind == cMODIFY) && (ctrl->iflags&ifPDL)) )
E 12
E 11
  {
   /* Jobs suchen */
   for ( exe = Equeues ; exe ; exe = exe->next )
    {
D 10
     for ( job = exe->Ejobs ; job && (job->jgen != gen) ; job = job->next );
E 10
I 10
     for ( job = exe->Ejobs ; job ; job = job->next )
      if ( ISSUBMIT(job) && (job->jgen == gen) )
       break;
E 10
     if ( job ) break;
    }
   /* Duerfen keine mehr vorhanden sein */
   if ( exe || gen->Pjobs || gen->Rjobs )
    {
     sprintf(mess,"there are still jobs on queue '%s'",gen->name);
     return &res;
    }
I 11
  }
 /* Queue loeschen */
 if ( ctrl->kind == cDELETE )
  {
E 11
   /* Entfernen */
   backgen(gen,-1);
   *gp = gen->next;
   /* Speicher freigeben */
I 6
   free(gen->pdl);
E 6
   free(gen->name);
   free(gen);
   /* Antwort aufheben und schon sind wir fertig */
   addID(ctrl->requestID,mess);
   return &res;
  }
 /* Informationen validieren */
 if ( fillgen(&ctrl->gen,gen,ctrl->iflags,mess) )
  if ( !gen )
   {
    /* Neue GEN-Queue erzeugen */
D 9
    if ( !(gen = MALLOC(genctrl,1)) )
E 9
I 9
    if ( !(gen = SALLOC(genctrl)) )
E 9
     {
      strcpy(mess,"out of memory during queue creation");
      return &res;
     }
    /* Initialisieren */
    *gen = ctrl->gen;
    gen->genID = ++genCnt;
    gen->genaddr = (int)gen;
    gen->state = (ctrl->iflags&ifSTART) ? qNORMAL : qSTOPPED;
    gen->back.pos = -1;
    gen->Rjobs = gen->Pjobs = 0;
D 6
    ctrl->gen.name = 0;
E 6
I 6
    ctrl->gen.name = ctrl->gen.pdl = 0;
E 6
    /* Verketten und in die Backupdatei schreiben */
    gen->next = Gqueues;
    Gqueues = gen;
    backgen(gen,1);
   }
  else
   {
    /* Parameter der GEN-Queue veraendern */
    if ( ctrl->iflags&ifSTART )
     gen->state = qNORMAL;
    else if ( ctrl->iflags&ifSTOP )
     {
      if ( ctrl->next != -2 ) gen->state = qSTOPPED;
      /* Jobs abtoeten */
      abortjobs(gen->Rjobs,'R',ctrl);
      for ( exe = Equeues ; exe ; exe = exe->next )
       for ( job = exe->Ejobs ; job ; job = job->next )
D 10
	if ( job->jgen == gen )
E 10
I 10
	if ( ISSUBMIT(job) && (job->jgen == gen) )
E 10
         abortjob(job,'E',ctrl);
     }
    gen->prio = ctrl->gen.prio;
    gen->cpu = ctrl->gen.cpu;
    gen->algo = ctrl->gen.algo;
    gen->jobs = ctrl->gen.jobs;
    gen->faults = ctrl->gen.faults;
    gen->minidle = ctrl->gen.minidle;
    gen->stack = ctrl->gen.stack;
    gen->data = ctrl->gen.data;
    gen->mem = ctrl->gen.mem;
I 6
    free(gen->pdl);
    gen->pdl = ctrl->gen.pdl;
    ctrl->gen.pdl = 0;
E 6
    /* Backupdatei auffrischen */
    backgen(gen,0);
   }
 /* Erfolgsmeldung in die Liste eintragen */
 addID(ctrl->requestID,mess);
 /* Fertig */
 return &res; 
}

/*
  Queuemanager stoppen oder starten.
*/
D 3
text *genmanageraction_2(cmd,msg)
E 3
I 3
D 7
text *genmanageraction_3(cmd,msg)
E 7
I 7
text *genmanageraction_1(cmd,msg)
E 7
E 3
qmCommand *cmd;
struct svc_req *msg;
{
 static char mess[256];
 static text res = mess;

 /* Zugriffsrecht ueberpruefen */
 if ( !authorized(msg,0) )
  {
   strcpy(mess,"operation requires OPER privilege on remote host");
   return &res;
  }
 /* Zustand veraenderm */
 *mess = '\0';
 switch (*cmd)
  {
   case qmSTOP       : master.stopped = 1;
     		       break;
   case qmNEWVERSION : backall();
   case qmSTART      : master.stopped = 0;
     		       break;
   default           : strcpy(mess,"Invalid command");
  }
 /* Fertig */
 return &res;
}

I 6
/*
  Ausgabe aller zum Neustart der GEN-Queue notwendigen Informationen
  in eine Datei. Die Datei heisst immer '/tmp/bossgeneric.startup'.
*/
D 7
bool_t *gendumpstartup_3(null)
E 7
I 7
bool_t *gendumpstartup_1(null)
E 7
void (*null)();
{
 static bool_t res;
 genctrl *gen;
 FILE *sf;

 /* Fehler ist aufgetreten */
 res = FALSE;
 /* Datei oeffnen */
 if ( !(sf = fopen("/tmp/bossgeneric.startup","w")) ) return &res;
 /* Daten schreiben */
 fprintf(sf,"#!/sbin/sh\n");
I 19
 fprintf(sf,"if [ \"`cli -tv 'BOSSQUEUE$HOST'`\" != \"1,`hostname`\" ] ; then\n");
 fprintf(sf,"  exit 0\n");
D 20
 fprintf(sf,"fi\n");
E 20
I 20
 fprintf(sf,"fi\n\n");
E 20
E 19
 if ( logfile ) fprintf(sf,"LOGFILE=%s ; export LOGFILE\n",logfile);
D 9
 if ( backupfile ) fprintf(sf,"BACKUPFILE=%s ; export BACKUPFILE\n\n",backupfile);
 fprintf(sf,"EXECPROG=%d ; export EXECPROG\n",progexec);
 fprintf(sf,"EXECVERS=%d ; export EXECVERS\n",versexec);
 fprintf(sf,"NOTIFYPROG=%d ; export NOTIFYPROG\n",prognotify);
 fprintf(sf,"NOTIFYVERS=%d ; export NOTIFYVERS\n\n",versnotify); 
E 9
I 9
 if ( backupfile ) fprintf(sf,"BACKUPFILE=%s ; export BACKUPFILE\n",backupfile);
D 15
 fprintf(sf,"\nEXECPROG=%d ; export EXECPROG\n",master.EXECprog);
E 15
I 15
 fprintf(sf,"\nNETGROUP=%s ; export NETGROUP\n",netgroup);
 fprintf(sf,"EXECPROG=%d ; export EXECPROG\n",master.EXECprog);
E 15
 fprintf(sf,"EXECVERS=%d ; export EXECVERS\n",master.EXECvers);
 fprintf(sf,"NOTIFYPROG=%d ; export NOTIFYPROG\n",master.NOTIFYprog);
 fprintf(sf,"NOTIFYVERS=%d ; export NOTIFYVERS\n\n",master.NOTIFYvers); 
I 21
 fprintf(sf,"TRANSFERSIZE=%d ; export TRANSFERSIZE\n\n",transfersize);
E 21
E 9
 /* Alle Genericqueues durchgehen und ausgeben */
 fprintf(sf,"QUEUES=");
 for ( gen = Gqueues ; gen ; gen = gen->next )
  {
   if ( gen != Gqueues ) fprintf(sf,":");
D 9
   fprintf(sf,"QUEUE%d\n",gen->genID);
E 9
I 9
   fprintf(sf,"QUEUE%d",gen->genID);
E 9
  }
 fprintf(sf," ; export QUEUES\n");
 for ( gen = Gqueues ; gen ; gen = gen->next )
  {
   fprintf(sf,"QUEUE%d=",gen->genID);
   qprintf(sf,gen); 
   fprintf(sf," ; export QUEUE%d\n",gen->genID);
  }
D 18
 fprintf(sf,"\nexec /etc/startup/bossgeneric.HLP\n");
E 18
I 18
 fprintf(sf,"\nexec /usr/rpc.startup/bossgeneric.HLP\n");
E 18
 fclose(sf);
 /* Fertig */
 res = TRUE;
 return &res;
}

/*
  Informationen ueber alle Subjobs eines Paralleljobs sammeln.
*/
D 7
parctrls *genparallelinfo_3(leader)
E 7
I 7
parctrls *genparallelinfo_1(leader)
E 7
ID *leader;
{
 static parctrls pc = { 0, 0 };
 static int apc = 0;
 execctrl *exe;
 jobctrl *job;
 genctrl *gen;

 /* Initialisieren */
 pc.parctrls_len = 0;
 if ( !*leader ) return &pc;
 /* In den Genericqueues */
 for ( gen = Gqueues ; gen ; gen = gen->next )
  {
   /* Laufende Jobs */
   for ( job = gen->Rjobs ; job ; job = job->next )
D 21
    if ( (job->request.leader == *leader) && !addparctrl(&pc,&apc,job) )
E 21
I 21
    if ( job->request.leader == *leader ) 
     {
      if ( !addparctrl(&pc,&apc,job,1) ) return &pc;
     }
    else if ( ((job->leader == *leader) && !addparctrl(&pc,&apc,job,0)) )
E 21
     return &pc;
   /* Wartende Jobs */
   for ( job = gen->Pjobs ; job ; job = job->next )
D 21
    if ( (job->request.leader == *leader) && !addparctrl(&pc,&apc,job) )
     return &pc;   
E 21
I 21
    if ( (job->request.leader == *leader) && !addparctrl(&pc,&apc,job,1) )
     return &pc;
E 21
  }
 /* In den RPC-Fehlerwarteschlangen stehende Jobs */
 for ( exe = Equeues ; exe ; exe = exe->next )
  for ( job = exe->Ejobs ; job ; job = job->next )
D 10
   if ( (job->request.leader == *leader) && !addparctrl(&pc,&apc,job) )
E 10
I 10
D 21
   if ( ISSUBMIT(job) && (job->request.leader == *leader) && !addparctrl(&pc,&apc,job) )
E 10
    return &pc;
E 21
I 21
   if ( ISSUBMIT(job) )
    if ( job->request.leader == *leader ) 
     {
      if ( !addparctrl(&pc,&apc,job,1) ) return &pc;
     }
    else if ( ((job->leader == *leader) && !addparctrl(&pc,&apc,job,0)) )
     return &pc;
E 21
 /* Fertig */
 return &pc;
}

/*
  Einen einzelnen Eintrag an die Liste der Subjobs anhaengen.
*/
D 21
static addparctrl(pc,ap,jp)
E 21
I 21
static addparctrl(pc,ap,jp,fact)
E 21
parctrls *pc;
D 21
int *ap;
E 21
I 21
int *ap,fact;
E 21
jobctrl *jp;
{
 parctrl *np;

 /* Bereich erweitern */
 if ( pc->parctrls_len == *ap )
  {
   /* Speicher reservieren */
   if ( !(np = MALLOC(parctrl,*ap+10)) ) return 0;
   /* Alten Bereich kopieren */
   if ( *ap )
    {
D 10
     memmove(np,pc->parctrls_val,*ap*sizeof(np[0]));
E 10
I 10
     MEMMOVE(np,pc->parctrls_val,*ap);
E 10
     free(pc->parctrls_val);
    }
   /* Werte uebernehmen */
   *ap += 10;
   pc->parctrls_val = np;
  }
 /* Informationen eintragen */
 np = pc->parctrls_val+pc->parctrls_len++;
D 21
 np->job = jp->jobID;
E 21
I 21
 np->job = fact*jp->jobID;
E 21
 np->IPaddr = jp->jexec ? jp->jexec->status.IPaddr : IPnone;
 np->channels = jp->channels;
 /* Alles in Ordung */
 return 1;
}
E 6
E 1
