h42110
s 00000/00000/00159
d D 5.1 91/08/15 08:56:43 jochen 7 6
c New version 5.1 created
e
s 00014/00003/00145
d D 4.3 91/04/29 17:51:40 jochen 6 5
c Linger option added to RPC/TCP channels
e
s 00044/00034/00104
d D 4.2 91/02/26 11:35:17 jochen 5 4
c Minor correction for QMan
e
s 00000/00000/00138
d D 4.1 91/02/20 13:26:11 jochen 4 3
c RPC number 390326 now reserved by SUN
e
s 00001/00001/00137
d D 3.2 91/02/20 13:06:47 jochen 3 2
c Parallel support added
e
s 00001/00001/00137
d D 3.1 91/01/15 14:32:17 jochen 2 1
c RPC version 3 created
e
s 00138/00000/00000
d D 2.1 91/01/02 15:26:39 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
I 3
static char sccsid_inter_notify_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 3
E 2
#endif

#define SGEN_INTER_NOTIFY

#include "sgen_hdr.h"


/*
  Nachricht an einen Benutzer absetzen.
*/
notify_user(host,user,line)
D 5
char *host,*user,*line;
E 5
I 5
long host;
char *user,*line;
E 5
{
 struct notctrl *not,*scan;

 /* Speicher reservieren */
D 5
 if ( !(not = MALLOC(struct notctrl,1))  ) return 0;
E 5
I 5
 if ( !(not = SALLOC(struct notctrl))  ) return 0;
E 5
 /* Speicher initialisieren */
 not->next = 0;
 not->back.pos = -1;
 not->host = host;
 not->turn = 0;
D 5
 not->mess.user = user;
E 5
 /* Informationsfelder reservieren */
D 5
 if ( !(not->mess.text.text_val = MALLOC(mess,1)) )
E 5
I 5
 if ( !(not->mess.text.text_val = SALLOC(mess)) || 
      !(not->mess.user = strdup(user)) || !(not->mess.text.text_val[0] = strdup(line)))
E 5
  {
   /* Speicher freigeben */
I 5
   if ( not->mess.text.text_val ) 
    {
     if ( not->mess.user ) free(not->mess.user);
     free(not->mess.text.text_val);
    }
E 5
   free(not);
   /* Fehler melden */
   return 0;
  }
 /* Struktur vollenden */
 not->mess.text.text_len = 1;
D 5
 not->mess.text.text_val[0] = line;
 /* Struktue verketten */
E 5
I 5
 /* Struktur verketten */
E 5
 if ( !(scan = todo) )
  todo = not;
 else
  {
   while ( scan->next ) scan = scan->next;
   scan->next = not;
  }
 /* In der Backupdatei vermerken */
 backit(BAK_NOTIFY,not,&not->back);
 /* Und alle Eintraege bearbeiten */
 donotify();
 /* Erfolg melden */
 return 1;  
}

/*
  Eintrage in der Liste der Benutzerbenachrichtigungen bearbeiten.
*/
donotify()
{
 struct notctrl *not,**np;
D 5
 CLIENT *cl;
E 5
I 5
 struct sockaddr_in rem;
 int sock;
E 5

 /* Alle durchgehen */
 for ( turn++, np = &todo ; not = *np ; )
D 5
  if ( (not->turn != turn) && 
       !listnotify(clnt_create(not->host,prognotify,versnotify,"tcp"),np) )
E 5
I 5
  if ( not->turn == turn )
E 5
   np = &not->next;
I 5
  else
   {
    /* TCP/IP-Adresse aufsetzen */
    rem.sin_family = AF_INET;
    rem.sin_addr.s_addr = htonl(not->host);
    rem.sin_port = htons(0);
    sock = RPC_ANYSOCK;
    /* Handle erzeugen und Nachricht verschicken */
D 6
    if ( !listnotify(clnttcp_create(&rem,master.NOTIFYprog,master.NOTIFYvers,&sock,0,0),np) )
E 6
I 6
    if ( !listnotify(clnttcp_create(&rem,master.NOTIFYprog,master.NOTIFYvers,&sock,0,0),
		     np,&sock) )
E 6
     np = &not->next;
   }
E 5
}

/*
  Aktion auf einer ganzen Liste von Eintraegen durchfuehren.
*/
D 6
static listnotify(cl,notp)
E 6
I 6
static listnotify(cl,notp,sp)
E 6
CLIENT *cl;
struct notctrl **notp;
I 6
int *sp;
E 6
{
 struct notctrl **first = notp,*not = *notp;
 struct timeval total = { 5, 0 };
D 5
 char *host = not->host;
E 5
I 5
D 6
 long host = not->host;
E 6
I 6
 long host = not->host,nhost;
 struct linger ling;
E 6
E 5
 int done = 0,res;

 if ( !cl )
  {
   /* Alle zu gleichen Host gehoerigen Eintraege loeschen */
   for ( notp = &not->next ; not = *notp ; )
D 5
    if ( strcmp(not->host,host) )
E 5
I 5
    if ( not->host != host )
E 5
     notp = &not->next;
    else
     remnotify(notp);
   /* Erstes Element loeschen */
   remnotify(first);
   /* Meldung machen */
   return 1;
I 6
  }
 /* Socket umschalten um bei Rechnerabstuerzen sicher zu sein */
 ling.l_onoff = 1;
 ling.l_linger = 0;
 if ( setsockopt(*sp,SOL_SOCKET,SO_LINGER,&ling,sizeof(ling)) == -1 )
  {
   nhost = htonl(host);
   lprintf("Could not set linger for notify server %s\n",INET_NTOA(nhost));
E 6
  }
D 5
 /* Benutzer benachrichtigen */
 if ( host = strdup(host) )
  {
   /* Alle Benutzer dieses Rechners benachrichtigen */
   while ( not = *notp )
    if ( strcmp(host,not->host) )
     notp = &not->next;
    else if ( clnt_call(cl,1,xdr_notinfo,&not->mess,xdr_int,&res,total) == RPC_SUCCESS )
     {
      remnotify(notp);
      done = 1;
     }
    else
     {
      /* Diesen Host erst im naechsten Durchlauf wieder bearbeiten */
      while ( not = not->next )
       if ( !strcmp(not->host,host) )
	not->turn = turn;
      break;
     }
   free(host);
  }
E 5
I 5
 /* Alle Benutzer dieses Rechners benachrichtigen */
 while ( not = *notp )
  if ( host != not->host )
   notp = &not->next;
  else if ( clnt_call(cl,1,xdr_notinfo,&not->mess,xdr_int,&res,total) == RPC_SUCCESS )
   {
    remnotify(notp);
    done = 1;
   }
  else
   {
    /* Diesen Host erst im naechsten Durchlauf wieder bearbeiten */
    while ( not = not->next )
     if ( not->host == host )
      not->turn = turn;
    break;
   }
E 5
 /* Aufraeumen */
 clnt_destroy(cl);
 return done;
}

/*
  Eintrag aus der Liste entfernen.
*/
static remnotify(notp)
struct notctrl **notp;
{
 struct notctrl *not = *notp;

 /* Aus der Liste entfernen */
 *notp = not->next;
 /* Aus der Backupdatei entfernen */
 backit(BAK_NONE,not,&not->back);
 /* Speicher ferigeben */
 xdr_free(xdr_notinfo,&not->mess);
D 5
 free(not->host);
E 5
 free(not);
}
E 1
