h22983
s 00000/00000/00197
d D 5.1 91/08/15 08:56:21 jochen 9 8
c New version 5.1 created
e
s 00004/00000/00193
d D 4.4 91/04/02 14:44:13 jochen 8 7
c Only EXEC-Servers in NETGROUP accepted
e
s 00024/00000/00169
d D 4.3 91/03/15 10:33:05 jochen 7 6
c jobsuspend and jobresume added
e
s 00005/00046/00164
d D 4.2 91/02/26 11:35:10 jochen 6 5
c Minor correction for QMan
e
s 00000/00000/00210
d D 4.1 91/02/20 13:26:06 jochen 5 4
c RPC number 390326 now reserved by SUN
e
s 00025/00001/00185
d D 3.3 91/02/20 13:06:02 jochen 4 3
c Parallel support functions of EXEC-Queue added
e
s 00002/00002/00184
d D 3.2 91/01/15 14:32:36 jochen 3 2
c RPC version 3 created using EXEC-Queue version 3 constants
e
s 00003/00003/00183
d D 3.1 91/01/08 09:54:35 jochen 2 1
c IP address handling modified
e
s 00186/00000/00000
d D 2.1 91/01/02 15:26:36 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue manager for UNIX */

#ifdef SCCSIDS
D 3
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 3
I 3
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
I 4
static char sccsid_inter_exec_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
E 3
#endif

#define _BSD_SIGNAL_FLAVOR

#include <errno.h>
#include <stdio.h>
#include <signal.h>

#include <rpc/rpc.h>

#include <sys/socket.h>

#include "../exec/sexec.h"

I 8
extern char *netgroup;

E 8
D 6
extern int progexec,versexec;

E 6
/*
  Nebenprozess der GEN-Queue zum asynchronen Suchen der EXEC-Queues.
*/
D 6
executers()
E 6
I 6
executers(prog,vers)
int prog,vers;
E 6
{
 static int gotexec(),gottime();
 statuscode code = stALL;
 statusinfo info;
 long t0,t1;
 
 /* Auf Antwort warten */
 for ( ; ; )
  {
D 6
   /* Periodisches Signal deaktivieren */
E 6
I 6
   /* Timer abschalten */
E 6
   alarm(0);
I 6
   /* Periodisches Signal deaktivieren */
E 6
   signal(SIGALRM,SIG_IGN);
   /* EXEC-Queues suchen */
   info.name = 0;
D 6
   clnt_broadcast(progexec,versexec,EXECSTATUS,
		  xdr_statuscode,&code,xdr_statusinfo,&info,gotexec);
E 6
I 6
   clnt_broadcast(prog,vers,EXECSTATUS,xdr_statuscode,&code,xdr_statusinfo,&info,gotexec);
E 6
   /* Schlafperiode einrichten */
   signal(SIGALRM,gottime);
   alarm(300);
   /* Abwarten */
   time(&t0);
   pause();
   time(&t1);
   /* Wartezeit melden */
   lprintf("Broadcaster waked up after %d seconds\n",t1-t0);
  }
}

static gottime()
{
}

/*
  Eine EXEC-Queue hat geantwortet.
*/
static gotexec(info,rem)
statusinfo *info;
struct sockaddr_in *rem;
{
I 8
 /* Der Rechner muss in der lokalen Netzwerkgruppe sein */
 if ( !innetgr(netgroup,info->name,(char *)0,(char *)0) ) return 0;
E 8
 /* IP Adresse ermitteln */
D 2
 info->IPaddr = rem->sin_addr.s_addr;
E 2
I 2
 info->IPaddr = ntohl(rem->sin_addr.s_addr);
E 2
 /* In der Liste suchen */
 newexec(info);
 /* Weitermachen */
 return 0;
}

/*
  Binden einer EXEC-Queue an die GEN-Queue.
*/
attach(clp,addr,hinfo,qptr)
CLIENT **clp;
long addr;
hostinfo *hinfo;
ID *qptr;
{
 return (callHandle(clp,addr,EXECATTACH,xdr_hostinfo,hinfo,xdr_ID,qptr) && 
D 3
	 *qptr && (*qptr != -1));
E 3
I 3
	 (*qptr != ERRATTACH_ATTACHED) && (*qptr != ERRATTACH_NOTROOT));
E 3
}

/*
  Losloesen einer EXEC-Queue von einer fremden GEN-Queue.
*/
detach(clp,addr,qptr)
CLIENT **clp;
long addr;
ID *qptr;
{
 int res;

 return (callHandle(clp,addr,EXECDETACH,xdr_ID,qptr,xdr_int,&res) && res);
}

/*
  Statusinformationen einer EXEC-Queue abfragen.
*/
status(clp,addr,iptr)
CLIENT **clp;
long addr;
statusinfo *iptr;
{
 statuscode sc = stALL;

 return callHandle(clp,addr,EXECSTATUS,xdr_statuscode,&sc,xdr_statusinfo,iptr);
}

/*
  Job in einer EXEC-Queue starten.
*/
jobstart(clp,addr,jptr,pptr)
CLIENT **clp;
long addr;
jobinfo *jptr;
PID *pptr;
{
 return callHandle(clp,addr,EXECSTART,xdr_jobinfo,jptr,xdr_PID,pptr);
}

/*
  Job aus einer EXEC-Queue entfernen.
*/
jobkill(clp,addr,kptr,pptr)
CLIENT **clp;
long addr;
killinfo *kptr;
PID *pptr;
{
 return callHandle(clp,addr,EXECKILL,xdr_killinfo,kptr,xdr_PID,pptr);
}

/*
I 7
  Job in einer EXEC-Queue anhalten.
*/
jobsuspend(clp,addr,sptr,pptr)
CLIENT **clp;
long addr;
killinfo *sptr;
PID *pptr;
{
 return callHandle(clp,addr,EXECSUSPEND,xdr_killinfo,sptr,xdr_PID,pptr);
}

/*
  Job in einer EXEC-Queue fortsetzen.
*/
jobresume(clp,addr,rptr,pptr)
CLIENT **clp;
long addr;
killinfo *rptr;
PID *pptr;
{
 return callHandle(clp,addr,EXECRESUME,xdr_killinfo,rptr,xdr_PID,pptr);
}

/*
E 7
  EXEC-Queue vom Empfang gewisser Nachrichten benachrichtigen.
*/
ack(clp,addr,aptr)
CLIENT **clp;
long addr;
acknowledge *aptr;
{
 int res;

 return callHandle(clp,addr,EXECACKNOWLEDGE,xdr_acknowledge,aptr,xdr_void,&res);
I 4
}

/*
  Konverterkanal schliessen.
*/
convkill(clp,addr,cptr,pptr)
CLIENT **clp;
long addr;
convinfo *cptr;
PID *pptr;
{
 return callHandle(clp,addr,EXECCONVERTER,xdr_convinfo,cptr,xdr_PID,pptr);
}

/*
  Konverterkanal schliessen.
*/
transfer(clp,addr,tptr,iptr)
CLIENT **clp;
long addr;
transinfo *tptr;
int *iptr;
{
 return callHandle(clp,addr,EXECTRANSFER,xdr_transinfo,tptr,xdr_int,iptr);
E 4
D 6
}

/*
  RPC-Handle fuer eine EXEC-Queue erzeugen und Befehl ausfuehren.
*/
static callHandle(clp,addr,code,inp,in,outp,out)
CLIENT **clp;
long addr;
int code;
xdrproc_t inp,outp;
char *in,*out;
{
 static struct timeval total = { 20,0 };
 int sock = RPC_ANYSOCK,i;
 struct sockaddr_in rem;

 /* Maximal zwei Versuche, je nach Wert des Handles */
 for ( i = *clp ? 2 : 1 ; i-- ; )
  {
   /* RPC-Handle nur einmal erzeugen */
   if ( !*clp )
    {
     /* Adresse des Partners aufsetzen */
     rem.sin_family = AF_INET;
D 2
     rem.sin_addr.s_addr = addr;
     rem.sin_port = 0;
E 2
I 2
     rem.sin_addr.s_addr = htonl(addr);
     rem.sin_port = htons(0);
E 2
     /* Handle erzeugen */
     if ( !(*clp = clnttcp_create(&rem,progexec,versexec,&sock,0,0)) ) return 0;
     /* Authorisierungsstruktur aufsetzen */
     auth_destroy((*clp)->cl_auth);
     (*clp)->cl_auth = authunix_create_default();
    }
   /* Befehl ausfuehren */
   if ( clnt_call(*clp,code,inp,in,outp,out,total) == RPC_SUCCESS ) return 1;
   /* Fehler bearbeiten */
   clnt_destroy(*clp);
   *clp = 0;
  }
 /* Fehler melden */
 return 0;
E 6
}
E 1
