h16055
s 00049/00017/00092
d D 5.1 91/08/13 17:12:25 jochen 5 4
c Notify under UNIX will now fork() to avoid bossgeneric locks
e
s 00001/00001/00108
d D 4.2 91/02/22 08:58:49 jochen 4 3
c SCCS header corrected for common use
e
s 00000/00000/00109
d D 4.1 91/02/18 11:52:46 jochen 3 2
c RPC number 390328 now reserved by SUN
e
s 00001/00001/00108
d D 2.2 91/01/11 15:04:01 jochen 2 1
c SCCS identifier corrected for #define SCCSIDS
e
s 00109/00000/00000
d D 2.1 91/01/02 17:51:32 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Message broadcaster for UNIX and VMS */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
I 4
static char sccsid_snotify_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
E 2
#endif

#ifdef vms
#include "sunrpc$dir:[rpc]rpc.h"
#else
#include <rpc/rpc.h>
#endif

#ifdef vms
D 5
#include descrip
E 5
#include brkdef
I 5
#include descrip
E 5
#else
D 5
#include <fcntl.h>
E 5
I 5
#define _BSD_SIGNAL_FLAVOR

E 5
#include <utmp.h>
I 5
#include <fcntl.h>

#include <sys/file.h>
#include <sys/wait.h>
#include <sys/signal.h>
E 5
#endif

#include "snotify.h"

/*
  Benutzer benachrichtigen.
*/
int *notify_1(notify)
notinfo *notify;
{
 static int n;
#ifdef vms
 $DESCRIPTOR(User,"");
 $DESCRIPTOR(Text,"");
 char *text,*malloc();
 short iosb[4];
 int i,len;
#else
I 5
 static int installed = 0,died();
E 5
 struct utmp *uent,*getutent();
#define USIZE	sizeof(uent->ut_user)
#define LSIZE	sizeof(uent->ut_line)
 char user[USIZE+1],line[5+LSIZE+1];
#endif

 n = 0;
#ifdef vms
 /* Laenge eines Zwischenspeichers ermitteln */
 for ( len = 1, i = notify->text.text_len ; i-- ; len += 2+strlen(notify->text.text_val[i]) );
 /* Speicher reservieren */
 if ( text = malloc(len+1) )
  {
   /* Nachricht zusammensetzen */
   strcpy(text,"\007");
   for ( i = 0 ; i < notify->text.text_len ; i++ )
    {
     strcat(text,"\012\015");
     strcat(text,notify->text.text_val[i]);
    }
   /* Descriptoren fertigstellen */
   User.dsc$a_pointer = notify->user;
   User.dsc$w_length = strlen(notify->user);
   Text.dsc$a_pointer = text;
   Text.dsc$w_length = len;
D 5
   /* Nachricht synchron an den Benutzer abschicken, maximale Wartezeit 4 Sekunden */
   if ( sys$brkthruw(0,&Text,&User,BRK$C_USERNAME,iosb,0,BRK$M_CLUSTER,BRK$C_QUEUE,4,0,0)&1 )
E 5
I 5
   /* Nachricht synchron an den Benutzer abschicken, maximale Wartezeit 2 Sekunden */
   if ( sys$brkthruw(0,&Text,&User,BRK$C_USERNAME,iosb,0,BRK$M_CLUSTER,BRK$C_QUEUE,2,0,0)&1 )
E 5
    if ( iosb[0]&1 )
     n = iosb[1];
   /* Speicher freigeben */
   free(text);
  }
#else
D 5
 setutent();
 while ( uent = getutent() )
  if ( uent->ut_type == USER_PROCESS )
   {
    strcpy(line,"/dev/");
    bcopy(uent->ut_user,user,USIZE);
    bcopy(uent->ut_line,line+5,LSIZE);
    user[USIZE] = line[5+LSIZE] = '\000';
    if ( !strcmp(user,notify->user) && !listtext(line,notify) ) n++;
   }
 endutent();
E 5
I 5
 /* Signalhandler aufsetzen */
 if ( !installed )
  {
   signal(SIGCHLD,died);
   installed = 1;
  }
 /* Die Arbeit uebernimmt ein Subprozess */
 if ( !fork() )
  {
   /* UTMP nach dem Benutzer absuchen */
   setutent();
   while ( uent = getutent() )
    /* Nur laufende Prozesse */
    if ( uent->ut_type == USER_PROCESS )
     {
      /* Kanal ermitteln */
      strcpy(line,"/dev/");
      bcopy(uent->ut_user,user,USIZE);
      bcopy(uent->ut_line,line+5,LSIZE);
      user[USIZE] = line[5+LSIZE] = '\000';
      /* Ausgeben */
      if ( !strcmp(user,notify->user) && !listtext(line,notify) ) n++;
     }
   endutent();
   /* Fertig */
   exit(1);
  }
E 5
#endif
 return &n;
}

#ifndef vms
/* 
  Hinausschreiben der Textzeilen in einen Terminalkanal.
*/
static listtext(term,notify)
char *term;
notinfo *notify;
{
 int fd,i;

D 5
 /* Terminalkanal oeffnen */
 if ( (fd = open(term,O_WRONLY)) < 0 ) return -1;
E 5
I 5
 /* Device muss existieren und beschreibbar sein */
 if ( (access(term,W_OK) == -1) || ((fd = open(term,O_WRONLY)) < 0) ) return -1;
E 5
 /* Informationen hinausschreiben */
 write(fd,"\007\n\r",3);
 for ( i = 0 ; i < notify->text.text_len ; i++ )
  {
   write(fd,notify->text.text_val[i],strlen(notify->text.text_val[i]));
   write(fd,"\n\r",2);
  } 
 /* Terminalkanal schliessen */
 close(fd);
 /* Kein Fehler aufgetreten */
 return 0;
I 5
}

/*
  Verstorbene Kinder bearbeiten.
*/
static died()
{
 /* Alle durchgehen */
 while ( wait3((int *)0,WNOHANG,(struct rusage *)0) > 0 );
E 5
}
#endif
E 1
