h47448
s 00004/00001/02360
d D 5.1 91/08/14 16:33:35 jochen 38 36
c CPU time added to completition string to queue manager
e
s 00000/00000/02361
d R 5.1 91/08/13 17:09:47 jochen 37 36
c Notify will now fork under UNIX to avoid bossgeneric locks
e
s 00023/00002/02338
d D 4.20 91/07/25 17:18:28 jochen 36 35
c Parallel device synchronized
e
s 00007/00004/02333
d D 4.19 91/06/19 17:39:34 jochen 35 34
c /etc/utmp period corrected
e
s 00001/00001/02336
d D 4.18 91/06/17 08:40:48 jochen 34 33
c /etc/utmp handling corrected
e
s 00001/00001/02336
d D 4.17 91/06/14 09:58:15 jochen 33 32
c RPC entry performance measurement does no longer modify utmp/wtmp
e
s 00036/00005/02301
d D 4.16 91/06/13 10:01:08 jochen 32 30
c cleanup for /etc/utmp added
e
s 00001/00001/02305
d R 4.16 91/06/12 11:19:08 jochen 31 30
c jobs 'who'-name modified to differentiate from tty's
e
s 00031/00004/02275
d D 4.15 91/06/12 11:09:45 jochen 30 29
c /etc/wtmp and /etc/utmp used for job accounting
e
s 00001/00001/02278
d D 4.14 91/06/10 12:40:30 jochen 29 28
c /usr/rpc.startup used
e
s 00002/00002/02277
d D 4.13 91/05/29 14:34:32 jochen 28 27
c RMS template file renamed to all lowercase
e
s 00002/00002/02277
d D 4.12 91/05/29 14:26:55 jochen 27 26
c RMS_FILE name modified to use with DCL
e
s 00001/00001/02278
d D 4.11 91/05/28 11:34:23 jochen 26 25
c RESTART corrected
e
s 00006/00003/02273
d D 4.10 91/05/28 11:19:32 jochen 25 24
c RESTART environment variable added, better solution next RPC version
e
s 00014/00008/02262
d D 4.9 91/05/03 14:39:50 jochen 24 23
c Modifications for DG/UX 4.32
e
s 00001/00001/02269
d D 4.8 91/04/29 13:29:01 jochen 23 22
c Using hard page fault counter
e
s 00002/00002/02268
d D 4.7 91/03/18 10:02:18 jochen 22 21
c Backupfile version upgraded to 4.1
e
s 00001/00001/02269
d D 4.6 91/03/11 09:16:07 jochen 21 20
c CORE limit set to infinite
e
s 00001/00001/02269
d D 4.5 91/03/07 09:22:50 jochen 20 19
c Converterinformations use 'double'
e
s 00003/00000/02267
d D 4.4 91/02/28 11:37:49 jochen 19 18
c SIGPIPE ignored
e
s 00048/00018/02219
d D 4.3 91/02/26 11:32:28 jochen 18 17
c Fileprotectionmask modified
e
s 00083/00071/02154
d D 4.2 91/02/22 15:41:50 jochen 17 16
c Job notification structure modified, now using enum definition
e
s 00018/00018/02207
d D 4.1 91/02/19 09:41:49 jochen 16 15
c RPC number 390327 now reserved by SUN
e
s 00368/00077/01857
d D 3.13 91/02/19 09:37:26 jochen 15 14
c Support for parallel queues completed and information query enhanced
e
s 00001/00011/01933
d D 3.12 91/02/05 10:52:11 jochen 14 13
c Converter interprocess definitions separated from sexec.c
e
s 00067/00047/01877
d D 3.11 91/02/04 17:54:59 jochen 13 12
c Converter (former Filter) data structures changed, stdin pipe added
e
s 00004/00002/01920
d D 3.10 91/01/18 09:42:02 jochen 12 11
c eventcounter added in filter information block
e
s 00002/00000/01920
d D 3.9 91/01/16 10:39:00 jochen 11 10
c creation of local logical name table for job included
e
s 00015/00010/01905
d D 3.8 91/01/15 14:27:28 jochen 10 9
c filter handling modified and variable definition corrected
e
s 00006/00005/01909
d D 3.7 91/01/15 10:40:31 jochen 9 8
c filter support enhanced
e
s 00165/00043/01749
d D 3.6 91/01/15 10:27:42 jochen 8 7
c support for filter processes and dedicated logging added
e
s 00330/00065/01462
d D 3.5 91/01/14 16:35:58 jochen 7 6
c support for parallel processes included
e
s 00051/00078/01476
d D 3.4 91/01/14 09:47:54 jochen 6 5
c Eater implementation and signal correction completed
e
s 00174/00069/01380
d D 3.3 91/01/12 18:51:50 jochen 5 4
c signal handling modified
e
s 00229/00052/01220
d D 3.2 91/01/08 17:28:39 jochen 4 3
c TCP eater process for performance measurement included
e
s 00106/00006/01166
d D 3.1 91/01/05 17:03:53 jochen 3 2
c Eater source code included
e
s 00006/00002/01166
d D 2.2 91/01/04 11:29:29 jochen 2 1
c keeping track on 'errno' in signal handlers
e
s 01168/00000/00000
d D 2.1 91/01/02 17:51:28 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue executer for UNIX */

#ifdef SCCSIDS
D 5
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 5
I 5
D 15
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 15
I 15
static char sccsid_sexec_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 15
E 5
#endif

D 3
/*
  JMS	10-23-90		First final version 2 release 1
  JMS   11-06-90		Testings of 2.1 completed, created release 2
  JMS	11-08-90		RMS_FILE qualifier added
*/

E 3
#define _BSD_SIGNAL_FLAVOR

#include <pwd.h>
I 18
#include <math.h>
E 18
#include <time.h>
I 30
#include <utmp.h>
E 30
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
I 7
#include <limits.h>
E 7
#include <signal.h>
I 5
#include <unistd.h>
I 7
#include <stropts.h>
E 7
E 5
#include <varargs.h>

#include <rpc/rpc.h>

I 5
#include <sys/uio.h>
I 7
#include <sys/stat.h>
E 7
E 5
#include <sys/wait.h>
I 3
#include <sys/ioctl.h>
E 3
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/resource.h>
I 7
#include <sys/sysmacros.h>
E 7
#include <sys/dg_sys_info.h>
I 15
#include <sys/dg_process_info.h>
E 15

I 7
#include <saphir/vmsdef.h>
#include <saphir/parallel.h>

E 7
#include "sexec.h"
I 14
#include "pipehead.h"
E 14


/*
  MACROs
I 32
    Putmp		/etc/utmp aufraeumen
E 32
    Pinteger		Performancemessung INTEGER
    Pfloat		Performancemessung FLOAT
    Pfield		Performancemessung FIELD

    allowed		Zugriffsberechtigung ueberpruefen	
    authorized		GENERIC-Queue ist 'root'
    duplicate		Zugriff ist schon bearbeitet.
I 6
    gett		Uhrzeit umrechnen
E 6

    lock		Queues sperren
    unlock		Queues freigeben 

    MALLOC		Speicher fuer einen Typen allokatieren
I 17
    SALLOC		Speicher fuer eine Struktur allokatieren
E 17
    PALLOC		Speicher fuer eine 'struct pidinfo' allokatieren

    CONTROL		Kennung einer Backupdatei    
    VERSION		Version der EXEC-Queue
    
    GENTICKS		Intervall fuer 'dowait'
    PERFTICKS		Intervall fuer 'doperformance'

    env_fmode		Environmentvariable 'VMSfmode'
    env_path		Environmentvariable 'PATH'

    TEMPLATE		Dateitemplate fuer temporaere Dateien
I 4

    MAX			Maximum zweier Werte
    MIN			Minimum zweier Werte

    TCPPIO		Prioritaet beim Messen der TCP/IP Performance
    TCPBUF		Buffergroesse beim Messen der TCP/IP Performance
I 7

    PARALLELNAME	Name des Paralleldevices
    TCPNAME		Name des zugrundeliegenden Netzwerkprotokolls
I 13
    NULLNAME		Name des Nulldevices
E 13

    LOGTABLE		Tabelle logischer Namen
    LOGNAME		Prefix fuer logische Namen
I 8

    LOGLEVEL		Initialer Loglevel
    LOGCODE		Code fuer Logdatei erzeugen
I 17

    NOSTR		Nullstring
E 17
E 8
E 7
E 4
*/
I 32
#define Putmp			-1
E 32
#define Pinteger		0
#define Pfloat	 		1
#define Pfield			2	

D 7
#define allowed(qID,rem)	(stat.queueID && (stat.queueID == (qID)))
E 7
I 7
#define allowed(qID,rem)	(state.queueID && (state.queueID == (qID)))
E 7
D 18
#define authorized(m)		(((m)->rq_cred.oa_flavor == AUTH_UNIX)&&((m)->rq_clntcred)&&\
				 !(((struct authunix_parms *)((m)->rq_clntcred))->aup_uid))
E 18
I 18

E 18
#define duplicate(rID)		((lastID == (rID)) && (lastPID != -1))
I 6
#define gett(tv)		((tv)->tv_sec+(tv)->tv_usec*1.0E-6)
E 6

D 5
#define lock()			(nosignal = 1)
#define unlock(r)		{nosignal = 0; if ( r ) raise(SIGCHLD);}
E 5
I 5
#define lock()			sigprocmask(SIG_BLOCK,&signals,(sigset_t *)0)
#define unlock()		sigprocmask(SIG_UNBLOCK,&signals,(sigset_t *)0)
E 5

#define MALLOC(t,n)		((t *)calloc(n,sizeof(t)))
D 17
#define PALLOC()		MALLOC(struct pidinfo,1)
E 17
I 17
#define SALLOC(t)		MALLOC(t,1)
#define PALLOC()		SALLOC(struct pidinfo)
E 17

D 4
#define CONTROL			'Be22'
#define VERSION			"BOSSexec V2.2"
E 4
I 4
D 22
#define CONTROL			'Be31'
#define VERSION			"BOSSexec V3.1"
E 22
I 22
#define CONTROL			'Be41'
#define VERSION			"BOSSexec V4.1"
E 22
E 4

#define GENTICKS		10
#define PERFTICKS		3600

#define env_fmode       	"VMSfmode=BATCH"
#define env_path		"PATH=.:/usr/bin:/usr/sbin:/usr/local/bin:/usr/global/bin"

D 27
#define TEMPLATE		"/tmp/RMS%08X[%d,%d].XXXXXX"
E 27
I 27
D 28
#define TEMPLATE		"/tmp/RMS%08x-%d-%d-XXXXXX"
E 28
I 28
#define TEMPLATE		"/tmp/rms%08x-%d-%d-XXXXXX"
E 28
E 27
#define TEMPMORE		((8-4)+2*(10-2))
I 15
#define TMPSIZE			(sizeof(TEMPLATE)+TEMPMORE)
E 15

I 24
#ifdef MIN
#undef MIN
#endif
#ifdef MAX
#undef MAX
#endif
E 24
I 4
#define MAX(a,b)		(((a) > (b)) ? (a) : (b))
#define MIN(a,b)		(((a) < (b)) ? (a) : (b))
E 4

I 4
#define TCPPRIO			-6
#define TCPBUF			(16*1024)

I 7
#define PARALLELNAME		"/dev/parallel"
#define TCPNAME			"/dev/tcp"
I 13
#define NULLNAME		"/dev/null"
E 13
E 7

I 7
#define LOGTABLE		"LNM$PROCESS_TABLE"
#define LOGNAME			"FOR%03d"
#define LOGMORE			(3-4)

I 8
#define LLFATAL			(1<<0)
#define LLERROR			(1<<1)
#define LLSTATUS		(1<<2)
#define LLJOB			(1<<3)
#define LLHANDLER		(1<<4)
#define LLROUTINE		(1<<5)
#define LLDUMP			(1<<6)
#define LOGLEVEL		(LLFATAL|LLERROR|LLSTATUS|LLJOB)
#define LOGCODE			1
E 8

I 17
#define NOSTR			((char *)0)


E 17
E 7
E 4
/*
D 15
  Verwaltungsstruktur fuer einen Job in dieser Queue.
E 15
I 15
  Verwaltungsstruktur fuer einen Job in dieser Queue. Unter anderem werden damit alle
  Prozesskennungen verwaltet und so sichergestellt, dass unter Benutzung der Privilegien
  der EXEC-Queue keine nicht von dieser gestarteten Prozesse beeinflusst werden koennen.
E 15
*/
struct pidinfo
       {
D 15
        struct pidinfo 	*next;
	ID		requestID;
	ID		queueID;
        PID     	pid;
	int		uid;
I 13
	int		infd;
E 13
	time_t		start;
	char		*log;
	char		tmp[sizeof(TEMPLATE)+TEMPMORE];
E 15
I 15
        struct pidinfo 	*next;			/* Verkettung in der Liste		*/
	ID		requestID;		/* Jobnummer				*/
	ID		queueID;		/* Queuekennnung			*/
        PID     	pid;			/* Prozesskennung			*/
	int		uid;			/* Benutzerkennung			*/
I 18
	int		gid;			/* Gruppenkennung			*/
E 18
	int		infd;			/* 'stdin' fuer Konverterprozesse	*/
	time_t		start;			/* Startzeit				*/
	char		*log;			/* Name der Logdatei			*/
	char		*com;			/* Name der zu loeschenden Scriptdatei	*/
	char		*print;			/* Druckername				*/
	int		dellog;			/* Loeschen				*/
	char		*cp;			/* Uebertragungsbuffer fuer 'infd'	*/
	int		acp;			/* Allokatierte Bytes in 'cp'		*/
	int		ncp;			/* Nicht uebertragene Bytes in 'cp'	*/
	char		tmp[TMPSIZE];		/* Temporaerer Dateiname		*/
I 30
	struct utmp	entry;			/* Eintrag fuer 'who'			*/
E 30
E 15
       };

/*
D 15
  Backupstruktur.
E 15
I 15
  Die Backupstruktur erlaubt bei einem Neustart der EXEC-Queue eine Resynchronisation
  mit der dort festgehaltenen GEN-Queue.
E 15
*/
struct backup
       {
D 15
	long		control;
	long		queueID;
	char		name[MAXHOSTNAMELEN];
	long		haddr;
	long		hprog;
	long		hvers;
E 15
I 15
	long		control;		/* Kontrollkennung und Version		*/
	long		queueID;		/* Queuekennung				*/
	char		name[MAXHOSTNAMELEN];	/* Name des Rechners (TCP/IP)		*/
	long		haddr;			/* TCP/IP Adresse der GEN-Queue (host)	*/
	long		hprog;			/* RPC-Programmnummer der GEN-Queue	*/
	long		hvers;			/* RPC-Versionsnummer der GEN-Queue	*/
E 15
       };

/*
  Verwaltungsstruktur fuer Nachrichten an die GEN-Queue.
*/
struct waiting
       {
	struct waiting  *next;
	jobdone		*data;
D 14
       };

I 5
/*
  Header bei Benutzung der internen Kommunikationsleitung.
*/
struct pipehead
       {
	PID		pid;
	PID		mpid;
	ID		reqID;
	int		items;
E 14
       };
E 5

I 7
/*
  Parameterliste fuer logische Namen.
*/
struct item_list_3
       {
	short   blen;
	short   code;
        char    *buf;
        short   *len;
       };
E 7
I 5

I 7

E 7
E 5
/*
  Globale Parameter.
*/
D 7
static char env_home[256],env_shell[SHELLNAMELEN+7],env_logname[64];
E 7
I 7
static char env_user[32],env_tz[32],*parname = PARALLELNAME,*tcpname = TCPNAME;
I 15
D 25
static char env_home[256],env_shell[256],env_logname[64],*logfile,*backupfile;
E 25
E 15
E 7
static double perf[3] = { 0.0, 0.0, 0.0 },times[3] = { -1.0, -1.0, -1.0 };
I 25
static char env_home[256],env_shell[256],env_logname[64],env_restart[20];
E 25
I 7
D 15
static char env_home[256],env_shell[SHELLNAMELEN+7],env_logname[64];
E 15
E 7
D 5
static int curperf,logf = -1,bakf = -1,nosignal = 0,npid = 0,euid;
E 5
D 4
static PID perfpid = -1,lastPID = -1;
E 4
I 4
static PID perfpid = -1,lastPID = -1,lastTrans = -1,epid = -1;
I 8
D 24
static int curperf,logf = -1,bakf = -1,loglevel = LOGLEVEL;
E 24
I 24
static int curperf,logfil = -1,bakf = -1,loglevel = LOGLEVEL;
E 24
E 8
I 5
static int npid = 0,euid,pfd[2] = { -1, -1 },notify = 1;
I 25
static char *logfile,*backupfile;
E 25
D 6
static int curperf,logf = -1,bakf = -1,slpcnt = 0;
E 6
I 6
D 8
static int curperf,logf = -1,bakf = -1;
E 8
E 6
E 5
E 4
D 7
static char env_user[32],env_tz[32];
E 7
static struct waiting *whead = 0;
static struct pidinfo *pids = 0;
I 5
static sigset_t signals;
E 5
static ID lastID,ackCnt;
I 7
static statusinfo state;
E 7
static CLIENT *gen = 0;
D 7
static statusinfo stat;
E 7

static char *env[] =
       {
  	env_home,  env_path, env_shell, env_logname, 
D 17
	env_fmode, env_tz,   env_user,  (char *)0
E 17
I 17
D 25
	env_fmode, env_tz,   env_user,  NOSTR
E 25
I 25
	env_fmode, env_tz,   env_user,  env_restart,
	NOSTR
E 25
E 17
       };


/*
  Unterprogramme.
*/
D 5
static int jobsignal(),doperiodic();
E 5
I 5
static void jobsignal(),doperiodic();
E 5
static struct pidinfo *rempid();
D 6
static double gett();
E 6
static PID *sigjob();

extern char *malloc(),*calloc(),*strdup(),*strerror(),*getenv(),*inet_ntoa(),*ctime();
D 7
extern char *translate_vms(),*translate_vms_default(),*mktemp();
E 7
I 7
extern char *translate_vms(),*translate_vms_default(),*mktemp(),*strchr();
extern struct in_addr inet_addr();
E 7
extern struct passwd *getpwuid();
extern time_t time();
I 4
D 5
extern PID fork();
E 5
E 4


/*
  Diese Initialisierungsroutine wird aufgerufen, bevor das Programm in
  den Servermode uebergeht. Hier findet die Inititialisierung aller
  globaler Variablen sowie ein etwaiges Nachladen von Informationen
  statt.
*/
void initialize()
{
 static char myself[MAXHOSTNAMELEN];
 static struct backup bdata;
I 5
 struct itimerval tim;
 struct sigaction sig;
D 8
 int nblk = 1;
E 8
I 8
 int nblk = 1,tmp;
E 8
E 5
 char *param;
 time_t now;

 /* Umgebung initialisieren */
D 18
 umask(0000);
E 18
I 18
 umask(0022);
E 18
 /* Generelle Variablen initialisieren */
 euid = geteuid();
D 4
 /* Sicherstellen, dass die Kennung der EXEC-Queue eindeutig bleiben */
E 4
I 4
 /* Sicherstellen, dass die Kennungen der EXEC-Queue eindeutig bleiben */
E 4
 sleep(2);
 /* Uhrzeit auslesen */
 ackCnt = time(&now);
 /* TCP/IP Information */
 gethostname(myself,MAXHOSTNAMELEN);
 /* Statusstruktur */
D 7
 stat.name = myself;
 stat.perf = 0.0;
 stat.idle = -1.0;
 stat.faults = -1.0;
I 3
 stat.EaterPort = -1;
I 4
 stat.trans = -1;
E 7
I 7
 state.name = myself;
 state.perf = 0.0;
 state.idle = -1.0;
 state.faults = -1.0;
 state.EaterPort = -1;
 state.trans = -1;
E 7
E 4
E 3
 /* Logdatei anlegen, falls gewuenscht */
D 15
 if ( param = getenv("LOGFILE") )
  if ( !strcmp(param,"stderr") )
E 15
I 15
 if ( logfile = getenv("LOGFILE") )
  if ( !strcmp(logfile,"stderr") )
E 15
D 24
   logf = 2;
E 24
I 24
   logfil = 2;
E 24
D 15
  else if ( !strcmp(param,"stdout") )
E 15
I 15
  else if ( !strcmp(logfile,"stdout") )
E 15
D 24
   logf = 1;
E 24
I 24
   logfil = 1;
E 24
  else
D 13
   logf = open(param,O_WRONLY|O_CREAT|O_APPEND,0755);
E 13
I 13
D 15
   logf = open(param,O_WRONLY|O_CREAT|O_APPEND,0744);
E 15
I 15
D 24
   logf = open(logfile,O_WRONLY|O_CREAT|O_APPEND,0744);
E 24
I 24
   logfil = open(logfile,O_WRONLY|O_CREAT|O_APPEND,0744);
E 24
E 15
E 13
 /* Start melden */
 lprintf("%s started at %s",VERSION,ctime(&now));
I 8
 /* Loglevel ermitteln */
 if ( param = getenv("LOGLEVEL") )
  if ( parval(&tmp,param,INT_MIN,INT_MAX) )
   loglevel = tmp;
  else if ( loglevel&LLERROR )
   lprintf("Could not read LOGLEVEL, using default\n");
E 8
I 7
 /* Name des Paralleldrivers ermitteln */
 if ( param = getenv("PARALLELNAME") )
  if ( param = strdup(param) )
   parname = param;
D 8
  else
E 8
I 8
  else if ( loglevel&LLERROR )
E 8
   lprintf("Could not allocate PARALLELNAME, using default\n");
 /* Name des Netzwerkprotokolls ermitteln */
 if ( param = getenv("TCPNAME") )
  if ( param = strdup(param) )
   tcpname = param;
D 8
  else
E 8
I 8
  else if ( loglevel&LLERROR )
E 8
   lprintf("Could not allocate TCPNAME, using default\n");
E 7
I 5
 /* Kommunikationskanal oeffnen */
 if ( pipe(pfd) == -1 )
  {
   lprintf("Could not create pipe\n");
   exit(1);
  }
 /* Kommunikationskanal entblocken */
 if ( ioctl(pfd[0],FIONBIO,&nblk) == -1 )
  {
   lprintf("Could not unblock pipe\n");
   exit(1);
  }
E 5
 /* Alte Informationen auslesen */
D 15
 if ( param = getenv("BACKUPFILE") )
E 15
I 15
 if ( backupfile = getenv("BACKUPFILE") )
E 15
  {
D 15
   if ( (bakf = open(param,O_RDONLY)) > 0 )
E 15
I 15
   if ( (bakf = open(backupfile,O_RDONLY)) != -1 )
E 15
    {
     if ( read(bakf,&bdata,sizeof(bdata)+1) == sizeof(bdata) )
      {
       /* Kontrolltests */
       if ( (bdata.control != CONTROL) || strcmp(bdata.name,myself) )
D 8
	lprintf("BACKUPFILE=%s has invalid format\n",param);
E 8
I 8
	{
D 15
         if ( loglevel&LLERROR ) lprintf("BACKUPFILE=%s has invalid format\n",param);
E 15
I 15
         if ( loglevel&LLERROR ) lprintf("BACKUPFILE=%s has invalid format\n",backupfile);
E 15
        }
E 8
       else if ( bdata.queueID )
	{
	 /* Informationen kopieren */
D 7
	 stat.queueID = bdata.queueID;
	 stat.haddr = bdata.haddr;
	 stat.hprog = bdata.hprog;
	 stat.hvers = bdata.hvers;
E 7
I 7
	 state.queueID = bdata.queueID;
	 state.haddr = bdata.haddr;
	 state.hprog = bdata.hprog;
	 state.hvers = bdata.hvers;
E 7
	}
      }
     close(bakf);
    }
   /* Neue Datei anlegen */
D 13
   bakf = open(param,O_WRONLY|O_CREAT|O_TRUNC,0755);
E 13
I 13
D 15
   bakf = open(param,O_WRONLY|O_CREAT|O_TRUNC,0744);
E 15
I 15
D 18
   bakf = open(backupfile,O_WRONLY|O_CREAT|O_TRUNC,0744);
E 18
I 18
   bakf = creat(backupfile,0744);
E 18
E 15
E 13
   /* Eventuell neue Situation melden */
D 7
   if ( stat.queueID ) 
E 7
I 7
   if ( state.queueID ) 
E 7
    {
     /* Neue, eindeutige Kennung erzeugen */
D 7
     time(&stat.queueID);
E 7
I 7
     time(&state.queueID);
E 7
     sleep(2);
     /* GEN-Queue benachrichtigen */
     attached(0);
    }
  }
 /* Backup erzeugen */
 backup();
D 5
 /* Prozessendkontrolle und Intervalltimer */
 signal(SIGALRM,doperiodic);
 signal(SIGCHLD,jobsignal);
E 5
I 5
 /* Benutzte Signale */
 sigemptyset(&signals);
 sigaddset(&signals,SIGALRM);
 sigaddset(&signals,SIGCHLD);
I 19
 /* Pipes generell ohne Signal bearbeiten */
 signal(SIGPIPE,SIG_IGN);
E 19
 /* Prozessendkontrolle und Intervalltimer mit Interlock */
 sig.sa_handler = doperiodic;
 sig.sa_flags = 0;
 sigemptyset(&sig.sa_mask);
 sigaddset(&sig.sa_mask,SIGCHLD);
 sigaction(SIGALRM,&sig,(struct sigaction *)0);
 sig.sa_handler = jobsignal;
 sig.sa_flags = 0;
 sigemptyset(&sig.sa_mask);
 sigaddset(&sig.sa_mask,SIGALRM);
 sigaction(SIGCHLD,&sig,(struct sigaction *)0);
E 5
 /* Performancemessung starten */
D 32
 doperformance(Pinteger,1);
E 32
I 32
 doperformance(Putmp,1);
E 32
 /* Systeminformationen periodische ermitteln */
D 5
 doperiodic();
E 5
I 5
 tim.it_interval.tv_sec = tim.it_value.tv_sec = 1;
 tim.it_interval.tv_usec = tim.it_value.tv_usec = 0;
 setitimer(ITIMER_REAL,&tim,(struct itimerval *)0);
E 5
I 4
 /* TCP Prozess starten */
 lock();
 Eater();
D 5
 unlock(1);
E 5
I 5
 unlock();
E 5
E 4
 /* Servermode aktivieren */
 return svc_run();
}

/*
  Ein vorher asynchron abgeschicktes NOTIFY an die GENERIC-Queue wird
  bestaetigt.
*/
D 4
void *execacknowledge_2(ack,msg)
E 4
I 4
D 16
void *execacknowledge_3(ack,msg)
E 16
I 16
void *execacknowledge_1(ack,msg)
E 16
E 4
acknowledge *ack;
struct svc_req *msg;
{
 struct waiting *wq,**pq;
 ID ackID;
 int n;

 /* Nur bearbeiten, falls der Zugriff legal ist */
D 4
 if ( !authorized(msg) || !allowed(ack->queueID,msg) ) return &execacknowledge_2;
E 4
I 4
D 16
 if ( !authorized(msg) || !allowed(ack->queueID,msg) ) return &execacknowledge_3;
E 16
I 16
 if ( !authorized(msg) || !allowed(ack->queueID,msg) ) return &execacknowledge_1;
E 16
E 4
 /* Bestaetigung bearbeiten */ 
 lock();
 for ( n = 0 ; n < ack->ackID.ackID_len ; )
  if ( !(ackID = ack->ackID.ackID_val[n++]) )
   {
I 8
#if LOGCODE
E 8
    /* Mitteilung in die Logdatei schreiben */
D 8
    lprintf("Synchronisation request received\n");
E 8
I 8
    if ( loglevel&LLSTATUS ) lprintf("Synchronisation request received\n");
#endif
E 8
    /* Eventuell veraenderte IP-Adresse vermerken */
D 4
    stat.haddr = msg->rq_xprt->xp_raddr.sin_addr.s_addr;
E 4
I 4
D 7
    stat.haddr = ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr);
E 7
I 7
    state.haddr = ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr);
E 7
E 4
    /* Reattach benoetigt neuen RPC-Handle */
D 6
    if ( gen ) clnt_destroy(gen);
    gen = 0;
E 6
I 6
    if ( gen )
     {
      clnt_destroy(gen);
      gen = 0;
     }
E 6
    /* Zugriffe vergessen */
D 4
    lastPID = -1;
E 4
I 4
    lastPID = lastTrans = -1;
E 4
   }
  else
   for ( pq = &whead ; wq = *pq ; pq = &wq->next )
    if ( wq->data->ackID == ackID )
     {
      remwait(pq);
      break;
     }
D 5
 unlock(1);
E 5
I 5
 unlock();
E 5
 /* Fertig */
D 4
 return &execacknowledge_2;
E 4
I 4
D 16
 return &execacknowledge_3;
E 16
I 16
 return &execacknowledge_1;
E 16
E 4
}

/*
  Uebermittle dem Benutzer eine Liste aller gestarteten und noch nicht
  beendeten Prozesse.
*/
D 4
pairs *execlist_2(queueID,msg)
E 4
I 4
D 16
pairs *execlist_3(queueID,msg)
E 16
I 16
pairs *execlist_1(queueID,msg)
E 16
E 4
ID *queueID;
struct svc_req *msg;
{
 static pair *idl = 0;
 static int all = 0;
 static pairs PIDs;
 struct pidinfo *prc;

 /* Uebergabewert initialisieren */
 PIDs.pairs_len = 0;
 PIDs.pairs_val = 0;
 /* Zugriffsrecht ueberpruefen */
 if ( !authorized(msg) || !allowed(*queueID,msg) ) return &PIDs;
 /* Speicher allokatieren */
 if ( npid > all )
  {
   /* Alten Speicher freigeben */
   if ( idl ) free(idl);
   all = 0;
   /* Neuen Speicher reservieren */
   if ( !(idl = MALLOC(pair,npid)) ) return &PIDs;
   all = npid;
  }
 /* Prozesskennungen uebertragen */
 lock();
 for ( prc = pids ; prc ; prc = prc->next )
D 7
  if ( prc->queueID == stat.queueID )
E 7
I 7
  if ( prc->queueID == state.queueID )
E 7
   {
    idl[PIDs.pairs_len].requestID = prc->requestID;
    idl[PIDs.pairs_len].pid = prc->pid;
    PIDs.pairs_len++;
   }
D 5
 unlock(1);
E 5
I 5
 unlock();
E 5
 /* Ergebnis melden */
 PIDs.pairs_val = idl;
 return &PIDs;
}
 
/*
  Einen Job in dieser EXEC-Queue starten. Dazu muss diese Queue von der
  Genericqueue allokatiert sein. Ein neuer Job wird dann in die Job-
  tabelle eingetragen und mit allen Parameter gestartet. Sollte der
  Logfile nicht zu oeffnen sein, wird das Programm trotzdem abgearbeitet.
  Fuer jeden Job wird eine eigene Session erzeugt, so dass alle von diesem
  Job aus direkt oder indirekt erzeugten Prozesse bei Elemintation des
  ersten Prozesses verschwinden. Um keine Kollisionen bei der Listen-
  verwaltung mit 'jobsignal' zu riskieren, wird die Prozessenderkennung
  zeitweise abgeschaltet.
*/
D 4
PID *execstart_2(job,msg)
E 4
I 4
D 16
PID *execstart_3(job,msg)
E 16
I 16
PID *execstart_1(job,msg)
E 16
E 4
jobinfo *job;
struct svc_req *msg;
{
D 9
 static unsigned char buf[1024];
E 9
I 9
D 10
 static unsigned char buf[1024],cfd[20],creq[20];
E 10
I 10
 static unsigned char buf[1024];
E 10
E 9
 static PID pid;
I 15
 int i,fd,fd2,len,rlen,cpend,cpoff,cvfd[2],nblk = 1,got;
E 15
I 10
D 17
 char *tz,*script,*log,*tmp,cfd[20],creq[20];
E 17
I 17
 char *tz,*script,*log,cfd[20],creq[20];
E 17
E 10
D 7
 char *tz,*script,*log,*tmp;
E 7
I 7
D 9
 char *tz,*script,*log,*tmp,cfd[20];
E 9
D 13
 int i,fd,fd2,len,rlen,cpend,cpoff;
E 13
I 13
D 15
 int i,fd,fd2,len,rlen,cpend,cpoff,cvfd[2];
E 15
E 13
I 9
D 10
 char *tz,*script,*log,*tmp;
E 10
E 9
E 7
 struct pidinfo *newpid;
D 7
 int i,fd,fd2,len,rlen;
E 7
 struct passwd *user;
 struct rlimit lim;
D 17
 param *params;
E 17
I 17
 text *params;
E 17
 time_t now;
D 4
 PID fork();
E 4

 /* Uhrzeit ermitteln */
 time(&now);
 /* Zugriffsberechtigung ueberpruefen */
D 6
 pid = -2;
E 6
I 6
 pid = ERRSTART_NOTROOT;
E 6
 if ( !authorized(msg) ) return &pid;
D 6
 pid = -3;
E 6
I 6
 pid = ERRSTART_NOTATTACHED;
E 6
 if ( !allowed(job->queueID,msg) ) return &pid;
 /* Benutzer feststellen */
D 6
 pid = -4;
E 6
I 6
 pid = ERRSTART_NOUSER;
E 6
 if ( !(user = getpwuid(job->uid)) ) return &pid;
 /* Doppelte Zugriffe sofort bearbeiten */
 if ( duplicate(job->requestID) ) return &lastPID;
 /* Speicher allokatieren */
D 6
 pid = 0;
E 6
I 6
 pid = ERRSTART_NOMEM;
E 6
D 7
 if ( !(params = MALLOC(param,job->param.param_len+3)) ) return &pid;
E 7
I 7
D 9
 if ( !(params = MALLOC(param,2+job->param.param_len+1+1)) ) return &pid;
E 9
I 9
D 10
 if ( !(params = MALLOC(param,2+job->param.param_len+2+1)) ) return &pid;
E 10
I 10
D 17
 if ( !(params = MALLOC(param,2+job->param.param_len+1+1)) ) return &pid;
E 17
I 17
 if ( !(params = MALLOC(text,2+job->param.param_len+1+1)) ) return &pid;
E 17
E 10
E 9
E 7
 if ( !(newpid = PALLOC()) )
  {
   free(params);
   return &pid;
  }
I 13
 /* Kanaele fur Konvertierer oeffnen */
 pid = ERRSTART_NOPIPE;
 if ( job->kind != skCONVERTER )
D 15
  newpid->infd = -1;
 else if ( pipe(cvfd) == -1 )
E 15
  {
D 15
   free(newpid);
   free(params);
   return &pid;
E 15
I 15
   /* 'stdin' nicht belegen */
   cvfd[0] = cvfd[1] = -1;
   /* Temporaere Datei anlegen */
   sprintf(newpid->tmp,TEMPLATE,now,job->gid,job->uid);
   if ( !mktemp(newpid->tmp) || ((fd = creat(newpid->tmp,0755)) == -1) )
    *newpid->tmp = '\0';
   else
    {
     close(fd);
     /* Benutzerkennung setzen */
     if ( chown(newpid->tmp,job->uid,job->gid) == -1 )
      {
       unlink(newpid->tmp);
       *newpid->tmp = '\0';
      }
    }
E 15
  }
E 13
D 15
 /* Temporaere Datei anlegen */
 sprintf(newpid->tmp,TEMPLATE,now,job->gid,job->uid);
 if ( !mktemp(newpid->tmp) || ((fd = creat(newpid->tmp,0755)) < 0) )
  *newpid->tmp = '\0';
 else
E 15
I 15
 /* Kanal oeffnen und Seite der EXEC-Queue auf nicht blockierend stellen */
 else if ( ((got = pipe(cvfd)) == -1) || (ioctl(cvfd[1],FIONBIO,&nblk) == -1) )
E 15
  {
D 15
   close(fd);
   /* Benutzerkennung setzen */
   if ( chown(newpid->tmp,job->uid,job->gid) == -1 )
E 15
I 15
   /* Bei einem Fehler aufraeumen */
   if ( got != -1 )
E 15
    {
D 15
     unlink(newpid->tmp);
     *newpid->tmp = '\0';
E 15
I 15
     close(cvfd[0]);
     close(cvfd[1]);
E 15
    }
I 15
   free(newpid);
   free(params);
   /* Und Fehler melden */
   return &pid;
E 15
  }
I 15
 else
  /* Keine temporaere Datei anlegen */
  *newpid->tmp = '\0';
E 15
 /* VAX/VMS-Dateinamen umrechnen in die UNIX-Notation */
 if ( (*(script = job->script) == '/') || 
      !(script = translate_vms(script)) || (script == (char *)-1) ||
      !(script = strdup(script)) )
  script = job->script;
 if ( !*(log = job->log) || (*log == '/') ||
      !(log = translate_vms(log)) || (log == (char *)-1) || !(log = strdup(log)) )
  log = job->log;
 /* Prozessenderkennung zur Synchronistation ausschalten */
 lock();
 /* Prozess erzeugen und Befehlsinterpreter starten. */
 if ( !(pid = fork()) )
  {
   /* Defaulteinstellung der Signale herstellen */
   signal(SIGALRM,SIG_DFL);
   signal(SIGCHLD,SIG_DFL);
I 19
   signal(SIGPIPE,SIG_DFL);
E 19
   /* Limits setzen */
   lim.rlim_cur = lim.rlim_max = job->cpu;
   setrlimit(RLIMIT_CPU,&lim);
   lim.rlim_cur = lim.rlim_max = job->data;
   setrlimit(RLIMIT_DATA,&lim);
   lim.rlim_cur = lim.rlim_max = job->stack;
   setrlimit(RLIMIT_STACK,&lim);
   lim.rlim_cur = lim.rlim_max = job->memory;
   setrlimit(RLIMIT_RSS,&lim);
D 21
   lim.rlim_cur = lim.rlim_max = 0;
E 21
I 21
   lim.rlim_cur = lim.rlim_max = -1;
E 21
   setrlimit(RLIMIT_CORE,&lim);
   /* Prioritaet setzen */
   nice(job->nice);
   /* Gruppenkennung uebernehmen */
   setgid(job->gid);
   initgroups(user->pw_name,job->gid);
   /* Benutzer setzen und Session erzeugen. */
   setuid(job->uid);
   setsid();
I 7
   /* Kontrollvariablen setzen */
   switch (job->kind)
    {
D 9
     case skFILTER   : /* $PIPE $1 $2 $3 ... $N */
E 9
I 9
D 13
     case skFILTER   : /* $PIPE $REQUEST_ID $1 $2 $3 ... $N */
E 9
D 10
       		       sprintf(params[2] = cfd,"%d",pfd[1]);
D 9
       		       cpoff = 3;
E 9
I 9
       		       sprintf(params[3] = creq,"%d",job->requestID);
       		       cpoff = 4;
E 10
I 10
       		       sprintf(params[1] = cfd,"%d",pfd[1]);
       		       sprintf(params[2] = creq,"%d",job->requestID);
       		       cpoff = 3;
E 10
E 9
		       cpend = 0;
		       break;
     case skPARALLEL : /* $2 $3 ... $N */
       		       cpoff = 2;
       		       cpend = 1;
		       break;
     default         : /* $1 $2 ... $N */
       		       cpoff = 2;
       		       cpend = 0;
E 13
I 13
     case skCONVERTER : /* $PIPE $REQUEST_ID $1 $2 $3 ... $N */
       		        sprintf(params[1] = cfd,"%d",pfd[1]);
       		        sprintf(params[2] = creq,"%d",job->requestID);
       		        cpoff = 3;
		        cpend = 0;
		        break;
     case skPARALLEL  : /* $2 $3 ... $N */
       		        cpoff = 2;
       		        cpend = 1;
		        break;
     default          : /* $1 $2 ... $N */
       		        cpoff = 2;
       		        cpend = 0;
E 13
    }
I 13
   /* Eingabekanal schliessen */
   close(0);
E 13
E 7
   /* Parameterliste aufsezten. */
D 10
   params[0] = job->shell;
   params[1] = script; 
E 10
I 10
D 13
   if ( job->kind == skFILTER )
    params[0] = script; 
E 13
I 13
   if ( job->kind == skCONVERTER )
    {
     params[0] = script; 
     /* Kontrollkanal auf Eingabekanal legen */
     dup2(cvfd[0],0);
    }
E 13
   else
    {
     params[0] = job->shell;
     params[1] = script; 
I 13
     /* Eingabekanal oeffnen */
     open(NULLNAME,O_RDONLY);
E 13
    }
E 10
D 7
   params[(i = job->param.param_len)+2] = (param)0;
   while ( i-- ) params[i+2] = job->param.param_val[i];
E 7
I 7
D 17
   params[(i = job->param.param_len)+(cpoff-cpend)] = (param)0;
E 17
I 17
   params[(i = job->param.param_len)+(cpoff-cpend)] = (text)0;
E 17
   while ( i-- > cpend ) params[i+(cpoff-cpend)] = job->param.param_val[i];
E 7
   /* Environment aufsetzen */
   strcpy(env_home,"HOME=");
   strcpy(env_home+5,user->pw_dir);
   strcpy(env_logname,"LOGNAME=");
   strcpy(env_logname+8,user->pw_name);
   strcpy(env_user,"USER=");
   strcpy(env_user+5,user->pw_name);
   strcpy(env_shell,"SHELL=");
D 10
   strcpy(env_shell+6,job->shell);
E 10
I 10
   strcpy(env_shell+6,params[0]);
E 10
   strcpy(env_tz,"TZ=");
   if ( tz = getenv("TZ") ) strcpy(env_tz+3,tz);
I 25
D 26
   sprintf(env_restart,"%sRESTART",(job->rmsfile&RMS_RESTART) ? "" : "NO");
E 26
I 26
   sprintf(env_restart,"%sRESTART=",(job->rmsfile&RMS_RESTART) ? "" : "NO");
E 26
E 25
   /* Directory setzen */
   chdir(user->pw_dir);
   /* Dateimaske loeschen */
   umask(0000);
I 5
   /* Ueberfluessige Dateikanaele schliessen */
D 6
   closeall(0,-1);
   if ( logf != -1 ) close(logf);
   if ( job->kind == skNORMAL ) close(pfd[1]);
E 6
I 6
   if ( job->kind == skNORMAL ) pfd[1] = -1;
D 13
   closeall(0,logf = -1);
E 6
E 5
   /* Dateikanaele oeffnen. STDIN darf nicht geschlossen sein. */
   if ( *log )
    unlink(log);
   else
    log = "/dev/null";
D 5
   close(0);
E 5
   open("/dev/null",O_WRONLY,0755);
D 5
   close(1);
E 5
   open(log,O_WRONLY|O_CREAT,0755);
E 13
I 13
D 24
   closeall(1,logf = -1);
E 24
I 24
   closeall(1,logfil = -1);
E 24
   /* Dateikanaele oeffnen */
   if ( creat(*log ? log : NULLNAME,0744) == -1 ) open(NULLNAME,O_WRONLY);
E 13
D 5
   close(2);
   dup(1);
E 5
I 5
   dup2(1,2);
E 5
   /* Eventuell Scriptfile konvertieren */
D 25
   if ( job->rmsfile && *newpid->tmp )
E 25
I 25
   if ( (job->rmsfile&RMS_RMSFILE) && *newpid->tmp )
E 25
    {
     /* Dateien oeffnen */
     fd = open(params[1],O_RDONLY);
     fd2 = creat(newpid->tmp,0755);
     /* Zeile fuer Zeile bearbeiten */
D 15
     if ( (fd >= 0) && (fd2 >= 0) )
E 15
I 15
     if ( (fd != -1) && (fd2 != -1) )
E 15
      {
       for ( ; ; )
	{
	 /* Zeilenlaenge einlesen */
	 while ( ((len = read(fd,buf,2)) == -1) && (errno == EINTR) );
	 /* Ende abfangen */
	 if ( !len )
	  {
	   params[1] = newpid->tmp;
	   break;
	  }
	 /* Fehler abfangen */
	 if ( len != 2 ) break;
	 /* Laenge ermitteln und auf Konsistenz ueberpruefen */
	 if ( (i = buf[0]+256*(int)buf[1]) > (sizeof(buf)-2) ) break;
	 rlen = (i+1)&~1;
	 if ( i )
          {
	   /* Buffer einlesen */
           while ( ((len = read(fd,buf,rlen)) == -1) && (errno == EINTR) );
	   /* Fehler bearbeiten */
	   if ( len != rlen ) break;
	  }
	 /* Buffer komplettieren und rausschreiben */
	 buf[i] = '\n';
	 while ( ((len = write(fd2,buf,i+1)) == -1) && (errno == EINTR) );
	 /* Fehler abfangen */
	 if ( len != i+1 ) break;
	}
      }
     /* Dateien schliessen */
     close(fd2);
     close(fd);
    }
I 11
   /* Prozesslokale Tabelle logischer Namen erzeugen */
   lnm$crelnt_();
E 11
I 7
D 13
   /* Parallleljobs vorbereiten */
E 13
I 13
   /* Paralleljobs vorbereiten */
E 13
   if ( job->kind == skPARALLEL )
    {
     /* Verteilungskanaele oeffnen */
     if ( job->param.param_len ) openparallel(job->param.param_val[0],job->requestID);
     /* Kommunikationskanal schliessen */
     close(pfd[1]);
    }
E 7
   /* Befehl ausfuehren. */
D 10
   execve(job->shell,params,env);
E 10
I 10
   execve(params[0],params,env);
E 10
   /* Fehlercode bei Misslingen. */
   exit(ENOENT);
  }
 /* Verkettung aufbauen oder Struktur wieder eleminieren */
D 6
 if ( pid == -1 )
E 6
I 6
D 7
 if ( pid ERRSTART_NOFORK )
E 7
I 7
 if ( pid == ERRSTART_NOFORK )
E 7
E 6
  {
   /* Temporaere Datei loeschen */
   if ( *newpid->tmp ) unlink(newpid->tmp);
   /* Speicher freigeben */
   free(newpid);
I 13
   /* Kontrollkanal schliessen */
   close(cvfd[1]);
E 13
I 8
#if LOGCODE
E 8
   /* Meldung machen */
D 8
   lprintf("Process not started due to error in fork()\n");
E 8
I 8
   if ( loglevel&LLJOB ) lprintf("Process not started due to error in fork()\n");
#endif
E 8
  }
 else
  {
   /* Neuen Prozess einbinden. */
   newpid->next = pids;
   newpid->requestID = lastID = job->requestID;
D 7
   newpid->queueID = stat.queueID;
E 7
I 7
   newpid->queueID = state.queueID;
E 7
   newpid->pid = lastPID = pid;
   newpid->uid = job->uid;
I 18
   newpid->gid = job->gid;
E 18
I 13
   newpid->infd = cvfd[1];
E 13
   newpid->log = *log ? strdup(log) : 0;
I 15
   newpid->com = job->delcom ? strdup(script) : 0;
   newpid->print = (newpid->log && *job->print) ? strdup(job->print) : 0;
   newpid->dellog = job->dellog;
E 15
   newpid->start = now;
I 15
   newpid->ncp = newpid->acp = 0;
I 30
   memmove(newpid->entry.ut_user,user->pw_name,sizeof(newpid->entry.ut_user));
   sprintf(buf,"%04X",job->requestID|0x8000);
   memmove(newpid->entry.ut_id,buf,sizeof(newpid->entry.ut_id));
   sprintf(newpid->entry.ut_line,"job%d",job->requestID);
   newpid->entry.ut_pid = pid;
   newpid->entry.ut_type = USER_PROCESS;
   newpid->entry.ut_exit.e_termination = newpid->entry.ut_exit.e_exit = 0;
   newpid->entry.ut_time = now;
   memmove(newpid->entry.ut_host,state.name);
E 30
E 15
   pids = newpid;
   npid++;
I 8
#if LOGCODE
E 8
   /* Meldung machen */
D 8
   lprintf("Process %d for %s started at %s",pid,user->pw_name,ctime(&now)); 
   lprintf(" SCRIPT=%s LOGFILE=%s\n",script,log);
E 8
I 8
   if ( loglevel&LLJOB )
    {
     lprintf("Process %d for %s started at %s",pid,user->pw_name,ctime(&now)); 
     lprintf(" SCRIPT=%s LOGFILE=%s\n",script,log);
    }
#endif
I 30
   /* Eintragen fuer 'who' */
   utmpname(WTMP_FILE);
   pututline(&newpid->entry);
   newpid->entry.ut_id[0] &= ~0x08;
   utmpname(UTMP_FILE);
   pututline(&newpid->entry);
E 30
E 8
  }
I 13
 /* Prozessenderkennung wieder aktivieren und testweise aufrufen */
 unlock();
E 13
 /* Speicher freigeben */
 if ( log != job->log ) free(log);
 if ( script != job->script ) free(script);
 free(params);
D 13
 /* Prozessenderkennung wieder aktivieren und testweise aufrufen */
D 5
 unlock(1);
E 5
I 5
 unlock();
E 13
I 13
 /* Kontrollkanal schliessen */
 close(cvfd[0]);
E 13
E 5
 /* Ergebnis melden */
 return &pid; 
}

/*
  Einen laufenden Job vernichten. Er muss dazu in der Liste der
  legalen Jobs eingetragen sein um zu verhindern, dass Benutzer
  wahllos Prozesse beenden koennen. Zum Loeschen wird daher der
  Prozess verifiziert und dann die ganze Session (Prozessgruppe)
  auf einen Schlag ausgeloescht. Man beachte, dass ein Job auch
  dann eleminiert werden darf, wenn seine Queuekennung nicht mit
  der aktuellen uebereinstimmt. Das ist die einzige Moeglichkeit,
  halbwegs legal Jobs von frueher zugeordneten Genericqueues los-
  zuwerden.
*/
D 4
PID *execkill_2(kil,msg)
E 4
I 4
D 16
PID *execkill_3(kil,msg)
E 16
I 16
PID *execkill_1(kil,msg)
E 16
E 4
killinfo *kil;
struct svc_req *msg;
{
 return sigjob(kil,msg,SIGKILL);
}

/*
  Job unterbrechen.
*/
D 4
PID *execsuspend_2(susp,msg)
E 4
I 4
D 16
PID *execsuspend_3(susp,msg)
E 16
I 16
PID *execsuspend_1(susp,msg)
E 16
E 4
killinfo *susp;
struct svc_req *msg;
{
 return sigjob(susp,msg,SIGSTOP);
}

/*
  Unterbrochenen Job fortsetzen.
*/
D 4
PID *execresume_2(res,msg)
E 4
I 4
D 16
PID *execresume_3(res,msg)
E 16
I 16
PID *execresume_1(res,msg)
E 16
E 4
killinfo *res;
struct svc_req *msg;
{
 return sigjob(res,msg,SIGCONT);
}

/*
  Diese EXEC-Queue einer bestimmten Genericqueue zuordnen. Beim
  ersten Aufruf werden verschiedenen zum Teil asynchron ablaufende
  Initialisierungen einmalig durchgefuehrt.
*/
D 4
ID *execattach_2(host,msg)
E 4
I 4
D 16
ID *execattach_3(host,msg)
E 16
I 16
ID *execattach_1(host,msg)
E 16
E 4
hostinfo *host;
struct svc_req *msg;
{
 static ID newatt;

 /* Zugriffsberechtigung ueberpruefen */
D 6
 newatt = -1;
E 6
I 6
 newatt = ERRATTACH_NOTROOT;
E 6
 if ( !authorized(msg) ) return &newatt;
 /* Fehlercode setzen */
D 6
 newatt = 0;
E 6
I 6
 newatt = ERRATTACH_ATTACHED;
E 6
D 7
 if ( stat.queueID )
E 7
I 7
 if ( state.queueID )
E 7
  /* Falls schon korrekt gebucht, Buchung bestaetigen */
D 4
  if ( (stat.haddr == msg->rq_xprt->xp_raddr.sin_addr.s_addr) &&
E 4
I 4
D 7
  if ( (stat.haddr == ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr)) &&
E 4
       (stat.hprog == host->prog) && (stat.hvers == host->vers) )
   return &stat.queueID;
E 7
I 7
  if ( (state.haddr == ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr)) &&
       (state.hprog == host->prog) && (state.hvers == host->vers) )
   return &state.queueID;
E 7
  else
   return &newatt;
 /* Genericqueue vermerken */
D 4
 stat.haddr = msg->rq_xprt->xp_raddr.sin_addr.s_addr;
E 4
I 4
D 7
 stat.haddr = ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr);
E 4
 stat.hprog = host->prog;
 stat.hvers = host->vers;
E 7
I 7
 state.haddr = ntohl(msg->rq_xprt->xp_raddr.sin_addr.s_addr);
 state.hprog = host->prog;
 state.hvers = host->vers;
E 7
 /* Queuekennnung ermitteln und uebertragen */
D 7
 newatt = time(&stat.queueID);
E 7
I 7
 newatt = time(&state.queueID);
E 7
 /* Attach melden und in der Backupdatei vermerken */
 attached(1);
 backup();
 /* Ergebnis melden */
 return &newatt;
}

/*
  EXEC-Queue von der zugeordneten Genericqueue loesen.
*/
D 4
int *execdetach_2(queueID,msg)
E 4
I 4
D 16
int *execdetach_3(queueID,msg)
E 16
I 16
int *execdetach_1(queueID,msg)
E 16
E 4
ID *queueID;
struct svc_req *msg;
{
 static int res;
D 5
 
E 5
I 5

E 5
 /* Zugriffsberechtigung ueberpruefen */
 res = FALSE;
D 4
 if ( !authorized(msg) ) return &res;
 if ( !stat.queueID || (*queueID != stat.queueID) ) return &res;
E 4
I 4
 if ( !authorized(msg) || !allowed(*queueID,msg) ) return &res;
E 4
 /* Queue freigeben */
D 7
 stat.queueID = 0;
E 7
I 7
 state.queueID = 0;
E 7
D 4
 lastPID = -1;
E 4
I 4
 lastPID = lastTrans = -1;
E 4
 /* RPC-Handle zerstoeren */
 if ( gen )
  {
   clnt_destroy(gen);
   gen = 0;
  }
I 8
#if LOGCODE
E 8
 /* Detach melden und in der Backupdatei vermerken */
D 8
 lprintf("%s detached\n",VERSION);
E 8
I 8
 if ( loglevel&LLSTATUS ) lprintf("%s detached\n",VERSION);
#endif
E 8
 backup();
 /* Sicherstellen, dass die Kennungen der EXEC-Queue eindeutig bleiben */
D 5
 sleep(2);
E 5
I 5
D 6
 slpcnt = 2;
 while ( slpcnt ) pause();
E 6
I 6
 while ( *queueID == time((time_t *)0) ) pause();
E 6
E 5
 /* Erfolg melden */
 res = TRUE;
 return &res; 
}

/*
  Statusinformationen abfragen. Dieser RPC-Einsprungpunkt wird
  im allgemeinen ueber UDP-Broadcast aufgerufen. Falls der Aufruf
  nur nicht zugeordnete Queues sucht und diese Queue bereits einer
  Genericqueue zugeordnet ist, erfolgt keine Antwort.
*/
D 4
statusinfo *execstatus_2(code,msg)
E 4
I 4
D 16
statusinfo *execstatus_3(code,msg)
E 16
I 16
D 17
statusinfo *execstatus_1(code,msg)
E 17
I 17
statusinfo *execstatus_1(code)
E 17
E 16
E 4
statuscode *code;
D 17
struct svc_req *msg;
E 17
{
D 7
 if ( (*code == stALL) || ((*code == stFREE) && !stat.queueID) )
  return &stat; 
E 7
I 7
 if ( (*code == stALL) || ((*code == stFREE) && !state.queueID) )
  return &state; 
E 7
 else
  return (statusinfo *)0;
}

/*
  Systemperformance neu messen.
*/
D 4
void *execperform_2(null,msg)
E 4
I 4
D 16
void *execperform_3(null,msg)
E 16
I 16
void *execperform_1(null,msg)
E 16
E 4
void (*null)();
struct svc_req *msg;
{
 /* Zugriffberechtigung ueberpruefen */
D 4
 if ( !authorized(msg) ) return &execperform_2;
E 4
I 4
D 16
 if ( !authorized(msg) ) return &execperform_3;
E 16
I 16
 if ( !authorized(msg) ) return &execperform_1;
E 16
E 4
 /* Messung starten */
D 7
 stat.perf = 0.0;
E 7
I 7
 state.perf = 0.0;
E 7
D 32
 doperformance(Pinteger,1);
E 32
I 32
D 33
 doperformance(Putmp,1);
E 33
I 33
 doperformance(Pinteger,1);
E 33
E 32
D 4
 return &execperform_2;
E 4
I 4
D 16
 return &execperform_3;
E 16
I 16
 return &execperform_1;
E 16
E 4
}
  
/*
I 4
  Transferverbindung zu anderen EXEC-Queues nachmessen.
*/
D 16
int *exectransfer_3(IPinfo,msg)
E 16
I 16
D 17
int *exectransfer_1(IPinfo,msg)
E 17
I 17
PID *exectransfer_1(IPinfo,msg)
E 17
E 16
transinfo *IPinfo;
struct svc_req *msg;
{
D 6
 static int res = -4;
E 6
I 6
D 17
 static int res = ERRTRANSFER_INTERNAL;
E 17
I 17
 static PID res = ERRTRANSFER_INTERNAL;
E 17
E 6
 int cnt;

 /* Zugriff vermerken */
D 7
 if ( (stat.trans != -1) && (IPinfo->requestID == lastTrans) ) return &res;
E 7
I 7
 if ( (state.trans != -1) && (IPinfo->requestID == lastTrans) ) return &res;
E 7
 lastTrans = IPinfo->requestID;
 /* Zugriff validieren */
D 6
 res = -2;
E 6
I 6
 res = ERRTRANSFER_NOTAUTHORIZED;
E 6
 if ( !authorized(msg) || !allowed(IPinfo->queueID,msg) ) return &res;
 /* Nachsehen, ob schon etwas laeuft */
D 6
 res = -3;
E 6
I 6
 res = ERRTRANSFER_NOTFREE;
E 6
D 7
 if ( stat.trans != -1 ) return &res;
E 7
I 7
 if ( state.trans != -1 ) return &res;
E 7
 /* Globale Daten sperren */
 lock();
 /* Prozess erzeugen */
D 7
 if ( res = (stat.trans = fork()) )
E 7
I 7
 if ( res = (state.trans = fork()) )
E 7
  {
   /* Gesperrten Variablen freigeben */
D 5
   unlock(1);
E 5
I 5
   unlock();
E 5
   /* Fertig */
   return &res;
  }
 /* Prioritaet erhoehen */
 nice(TCPPRIO);
 /* I/O-Kanaele schliessen */
 closeall(0,-1);
 /* Arbeit aufnehmen */
D 5
 for ( cnt = IPinfo->tripel.parchans_len ; cnt-- > 0 ; )
E 5
I 5
 for ( cnt = IPinfo->tripel.parchans_len ; cnt-- > 0 ; ) 
E 5
  transfer(IPinfo->tripel.parchans_val+cnt);
D 5
 /* GEN-Queue benachrichtigen, falls moeglich */
 whead = 0;
 gen = 0;
 GenericNotify(TRANSDONEPID,lastTrans,"Transfermeasurement completed",&IPinfo->tripel);
E 5
I 5
 /* Daten an die EXEC-Queue zum weiterleiten uebertragen */
D 17
 CreateNotify(TRANSDONEPID,lastTrans,&IPinfo->tripel);
E 17
I 17
 CreateNotify(nkTRANSDONE,lastTrans,&IPinfo->tripel);
E 17
E 5
 /* Fertig */
 exit(0);
}

I 15
/* 
  Konverterkanal abtoeten. Dazu wird sichergestellt, dass es sich
  bei dem gewuenschten Programm wirklich um einen Konverter handelt.
  Er erhaelt dann ueber seinen Standardeingabekanal die gewuenschten
  Daten als 'sockaddr_in' Struktur im Netzwerkformat. Damit sich
  die EXEC-Queue nicht aufhaengen kann, wird diese Aktion asynchron
  ueber die 'dowrite'-Routine ausgefuehrt.
*/
D 16
PID *execconverter_3(ci,msg)
E 16
I 16
PID *execconverter_1(ci,msg)
E 16
convinfo *ci;
struct svc_req *msg;
{
 static PID res;
 struct sockaddr_in sin;
 struct pidinfo *cp;
 char *nc;
 int ac;

 /* Zugriffsrecht verifizieren. */
 res = ERRCONVERTER_NOTROOT;
 if ( !authorized(msg) ) return &res;
 res = ERRCONVERTER_NOTATTACHED;
 if ( !allowed(ci->queueID,msg) ) return &res;
 /* Doppelte Zugriffe sofort beantworten */
 if ( duplicate(ci->requestID) ) return &lastPID;
 /* Prozess suchen. */
 lock();
 cp = rempid(ci->pid,0);
 /* Ergebnis auswerten */
 if ( !cp )
  {
   /* Diesen Prozess kennt die EXEC-Queue gar nicht */
   unlock();
   res = ERRCONVERTER_NOTPID;
   return &res;
  }
 else if ( cp->infd == -1 )
  {
   /* Der Prozess ist kein Konverter */
   unlock();
   res = ERRCONVERTER_NOTCONVERTER;
   return &res;
  }
 /* Speicher erzeugen */
 if ( (ac = cp->ncp+sizeof(sin)) > cp->acp )
  {
   /* Speicher allokatieren */
   if ( !(nc = MALLOC(char,ac)) ) 
    {
     /* Kein Speicher zu bekommen */
     unlock();
     /* Logdatei fuellen */
     if ( loglevel&LLERROR ) lprintf("Out of memory during converter notification\n");
     /* Fertig */
     res = ERRCONVERTER_NOMEM;
     return &res;
    }
   /* Alten Bereich kopieren */
   if ( cp->acp )
    {
     memmove(nc,cp->cp,cp->ncp);
     free(cp->cp);
    }
   /* Felder aktualisieren */
   cp->acp = ac;
   cp->cp = nc;
  }
 /* Bereich kopieren */
 sin.sin_family = AF_INET;
 sin.sin_addr.s_addr = htonl(ci->IPaddr);
 sin.sin_port = htons(ci->IPport);
 memmove(cp->cp+cp->ncp,&sin,sizeof(sin));
 cp->ncp += sizeof(sin);
 /* Sperre aufheben */
 unlock();
 /* Aktion festhalten */
 lastID = ci->requestID;
 lastPID = ci->pid;
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLJOB ) 
  lprintf("Sent kill request for IP %s,%d to process %d\n",
	  inet_ntoa(sin.sin_addr),ci->IPport,ci->pid);
#endif
 /* Ergebnis melden */
 res = 0;
 return &res; 
}

E 15
/*
I 15
  Abfragen der Informationen ueber einen Prozess und seine Kindprozesse.
*/
#define get_pinfo(s,k,i)	dg_process_info(DG_PROCESS_INFO_SELECTOR_PGRP,s,\
						DG_PROCESS_INFO_CMD_NAME_AND_ARGS,k,i,\
						DG_PROCESS_INFO_VERSION_0)

D 16
procinfos *execprocinfo_3(ppid)
E 16
I 16
procinfos *execprocinfo_1(ppid)
E 16
PID *ppid;
{
 static procinfos pi = { 0, 0 };
 static int api = 0;
 long keyp = DG_PROCESS_INFO_INITIAL_KEY;
 struct dg_process_info pinf;
 char *cmd = (char *)1;
 procinfo *np;
D 17
 int err,i;
E 17
I 17
 int err;
E 17

 /* Alten Speicher teilweise freigeben */
D 17
 while ( pi.procinfos_len > 0 ) free(pi.procinfos_val[--pi.procinfos_len].cmd);
E 17
I 17
 while ( pi.procinfos_len ) free(pi.procinfos_val[--pi.procinfos_len].cmd);
E 17
 /* Gibt es den Prozess ueberhaupt */
 lock();
 err = !rempid(*ppid,0);
 unlock();
 /* Alle Prozesse mit der selben Prozessgruppe durchgehen */
 if ( !err )
  while ( (get_pinfo(*ppid,&keyp,&pinf) == 1) && (cmd = strdup(pinf.cmd)) )
   {
    /* Speicher bereitstellen */
    if ( pi.procinfos_len == api )
     {
      /* Speicher allokatieren */
      if ( !(np = MALLOC(procinfo,api+10)) ) 
       {
	/* Speicher freigeben */
	free(cmd);
D 17
	cmd = (char *)0;
E 17
I 17
	cmd = NOSTR;
E 17
	/* Aufhoeren */
	break;
       }
      /* Alten Bereich kopieren */
      if ( api )
       {
	memmove(np,pi.procinfos_val,api*sizeof(np[0]));
	free(pi.procinfos_val);
       }
      /* Neue Werte einsetzen */
      api += 10;
      pi.procinfos_val = np;
     }
    /* Werte uebertragen */
    np = pi.procinfos_val+pi.procinfos_len++;
    np->state = pinf.state;
    np->uid = pinf.user_id;
    np->pid = pinf.process_id;
    np->ppid = pinf.parent_process_id;
    np->prio = pinf.priority;
    np->nice = pinf.nice_value;
    np->size = pinf.resident_process_size;
    if ( (np->start = gett(&pinf.start_time)) < 0.01 ) np->start = 0.0;
    if ( (np->cpu = gett(&pinf.system_time)+gett(&pinf.user_time)) < 0.01 ) np->cpu = 0.0;
    np->cmd = cmd;
   }
 /* Logdatei fuellen */
 if ( !cmd && (loglevel&LLERROR) ) lprintf("Out of memory during process info\n");
 /* Ergebnis melden */
 return &pi;
}

/*
  Ausgabe aller zum Neustart der EXEC-Queue notwendigen Informationen
  in eine Datei. Die Datei heisst immer '/tmp/bossexec.startup'.
*/
D 16
bool_t *execdumpstartup_3(null)
E 16
I 16
bool_t *execdumpstartup_1(null)
E 16
void (*null)();
{
 static bool_t res;
 FILE *sf;

 /* Fehler ist aufgetreten */
 res = FALSE;
 /* Datei oeffnen */
 if ( !(sf = fopen("/tmp/bossexec.startup","w")) ) return &res;
 /* Daten schreiben */
 fprintf(sf,"#!/sbin/sh\n");
 if ( logfile ) fprintf(sf,"LOGFILE=%s ; export LOGFILE\n",logfile);
 if ( backupfile ) fprintf(sf,"BACKUPFILE=%s ; export BACKUPFILE\n",backupfile);
D 18
 fprintf(sf,"LOGLEVEL=%d ; export LOGLEVEL\n",loglevel);
E 18
I 18
 fprintf(sf,"LOGLEVEL=0x%08x ; export LOGLEVEL\n",loglevel);
E 18
 fprintf(sf,"PARALLELNAME=%s ; export PARALLELNAME\n",parname);
 fprintf(sf,"TCPNAME=%s ; export TCPNAME\n\n",tcpname);
D 27
 fprintf(sf,"rm -f /tmp/RMS[0-9A-F][0-9A-F]*\\[[0-9][0-9]*,[0-9][0-9]*\\].*\n\n");
E 27
I 27
D 28
 fprintf(sf,"rm -f /tmp/RMS[0-9a-f][0-9a-f]*-[0-9][0-9]*-[0-9][0-9]*-*\n\n");
E 28
I 28
 fprintf(sf,"rm -f /tmp/rms[0-9a-f][0-9a-f]*-[0-9][0-9]*-[0-9][0-9]*-*\n\n");
E 28
E 27
D 29
 fprintf(sf,"exec /etc/startup/bossexec.HLP\n");
E 29
I 29
 fprintf(sf,"exec /usr/rpc.startup/bossexec.HLP\n");
E 29
 fclose(sf);
#if LOGCODE 
 /* Logdatei fuellen */
 if ( loglevel&LLSTATUS ) lprintf("Written /tmp/bossexec.startup\n");
#endif
 /* Fertig */
 res = TRUE;
 return &res;
}

/*
E 15
E 4
  Ein Job ist fertig bearbeitet. Sein Ergebnis wird der zugehoerigen
  Genericqueue mitgeteilt. Ist ein Performancemessprozess beendet
  worden, so werden seine Informationen entsprechend ausgwertet und
  in die Statuststruktur eingetragen. Ansonsten werden Informationen
  an den Logfile angehaengt und der Job aus der internen Tabelle
  entfernt. Zudem erhaelt die assoziierte Genericqueue eine Meldung,
  falls der Job von ihr gestartet wurde.
*/
D 5
static jobsignal()
E 5
I 5
static void jobsignal()
E 5
{
 static char line[512];
D 2
 int status,val,doperf = 0;
E 2
I 2
 int status,val,doperf = 0,keeperr = errno;
E 2
 static char *strsignal();
 struct pidinfo *oldpid;
 FILE *f,*fopen();
 struct rusage r;
 PID pid,wait3();
 double secs;
 char *cval;
 time_t now;

I 8
#if LOGCODE
 /* Logdatei beschreiben */
 if ( loglevel&LLHANDLER ) lprintf("Entered jobsignal()\n");
#endif
E 8
D 5
 /* Nur bearbeiten, falls erlaubt */
 if ( nosignal ) return;
 /* Signalhandler abschalten */
 lock();
E 5
 /* Alle verstorbenen Prozesse durchgehen */
 while ( (pid = wait3(&status,WNOHANG,&r)) > 0 )
  {
I 8
#if LOGCODE
   /* Logdatei fuellen */
   if ( loglevel&LLDUMP ) lprintf("Child %d terminated\n",pid);
#endif
   /* Transfertest ist beendet */
E 8
D 6
   secs = gett(&r.ru_utime)+gett(&r.ru_stime);
E 6
I 4
D 7
   if ( pid == stat.trans )
E 7
I 7
   if ( pid == state.trans )
E 7
    {
D 8
     /* Transfertest ist beendet */
E 8
D 7
     stat.trans = -1;
E 7
I 7
     state.trans = -1;
E 7
     continue;
    }
I 8
   /* TCP Prozess ist verstorben */
E 8
   if ( pid == epid )
    {
D 8
     /* TCP Prozess ist verstorben */
E 8
     epid = -1;
D 7
     stat.EaterPort = -1;
E 7
I 7
     state.EaterPort = -1;
E 7
     /* Neustart versuchen */
     Eater();
     continue;
    }
I 6
   /* Ab jetzt wird die Rechenzeit benoetigt */
   secs = gett(&r.ru_utime)+gett(&r.ru_stime);
I 8
   /* Performanceinformationen eintragen */
E 8
E 6
E 4
   if ( pid == perfpid )
    {
D 8
     /* Performanceinformationen eintragen */
E 8
     perfpid = -1;
D 32
     perf[curperf] = secs;
E 32
I 32
     if ( curperf != Putmp ) perf[curperf] = secs;
E 32
     /* Und naechsten Eintrag vornehmen */
     if ( ++curperf < (sizeof(perf)/sizeof(perf[0])) )
      doperf = 1;
     else if ( perf[Pinteger] && perf[Pfloat] && perf[Pfield] )
      {
D 7
       stat.perf = perf[Pinteger]+perf[Pfloat]+perf[Pfield];
E 7
I 7
       state.perf = perf[Pinteger]+perf[Pfloat]+perf[Pfield];
I 8
#if LOGCODE
E 8
E 7
       /* Ergebnisse ausgeben */
D 8
       lprintf("Performance measurement completed:\n ");
       lprintf(" INTEGER=%f, FLOAT=%f, FIELD=%f seconds\n",
	       perf[Pinteger],perf[Pfloat],perf[Pfield]);
E 8
I 8
       if ( loglevel&LLSTATUS )
	{
	 lprintf("Performance measurement completed:\n ");
D 18
         lprintf(" INTEGER=%f, FLOAT=%f, FIELD=%f seconds\n",
E 18
I 18
         lprintf(" INTEGER=%.2f, FLOAT=%.2f, FIELD=%.2f seconds\n",
E 18
	         perf[Pinteger],perf[Pfloat],perf[Pfield]);
        }
#endif
E 8
      }
     else
D 7
      stat.perf = 0.0;
E 7
I 7
      state.perf = 0.0;
E 7
I 4
     /* Prozesskennung loeschen */
E 4
     continue;
    }
   /* Statistische Daten in den Logfile eintragen */
   time(&now);
   if ( oldpid = rempid(pid,1) )
    {
     /* Ergebnistext zusammensetzen */
     cval = 0;
     if ( WIFEXITED(status) )
      {
D 30
       val = WEXITSTATUS(status);
E 30
I 30
       oldpid->entry.ut_exit.e_exit = val = WEXITSTATUS(status);
E 30
       if ( val ) cval = strerror(val);
       sprintf(line,"normal termination with exit code %d",val);
      }
     else if ( WIFSIGNALED(status) )
      {
D 30
       cval = strsignal(val = WTERMSIG(status));
E 30
I 30
       cval = strsignal(oldpid->entry.ut_exit.e_termination = val = WTERMSIG(status));
E 30
       sprintf(line,"terminated by signal %d",val);
      }
     else if ( WIFSTOPPED(status) )
      {
D 30
       cval = strsignal(val = WSTOPSIG(status));
E 30
I 30
       cval = strsignal(oldpid->entry.ut_exit.e_termination = val = WSTOPSIG(status));
E 30
       sprintf(line,"was stopped with signal %d",val);
      }
     else
D 30
      sprintf(line,"terminated improperly");
E 30
I 30
      {
       oldpid->entry.ut_exit.e_termination = oldpid->entry.ut_exit.e_exit = -1;
       sprintf(line,"terminated improperly");
      }
E 30
     if ( cval && *cval ) sprintf(line+strlen(line)," (%s)",cval);
I 30
     /* Eintrag fuer 'who' */
     oldpid->entry.ut_type = DEAD_PROCESS;
     oldpid->entry.ut_time = now;
     utmpname(WTMP_FILE);
     pututline(&oldpid->entry);
     utmpname(UTMP_FILE);
     pututline(&oldpid->entry);
E 30
     /* Prozesslokale Logdatei fuellen */
     if ( oldpid->log )
      {
I 15
       /* Benutzerkennung setzen */
E 15
       setreuid(-1,oldpid->uid);
       if ( f = fopen(oldpid->log,"a") )
	{
D 8
   	 fprintf(f,"\nJob %d %s\n     started: %s",oldpid->requestID,line,ctime(&oldpid->start));
E 8
I 8
   	 fprintf(f,"\nJob %d %s\n     started: %s",
		   oldpid->requestID,line,ctime(&oldpid->start));
E 8
	 fprintf(f,"   completed: %s",ctime(&now));
D 18
	 fprintf(f,"   CPU usage: %f secs,",secs);
E 18
I 18
	 fprintf(f,"   CPU usage: %.2f secs,",secs);
E 18
	 fprintf(f,"    Paging: %d faults,",r.ru_majflt);
	 fprintf(f,"    Disk I/O: %d\n",r.ru_inblock+r.ru_oublock);
	 fclose(f);
	}
I 15
       /* Ausdruck erzeugen */
       if ( oldpid->print )
	{
	 /* Datei ausdrucken und eventuell loeschen */
D 18
	 printlog(oldpid->log,oldpid->print,oldpid->dellog);
E 18
I 18
	 printlog(oldpid->gid,oldpid->uid,oldpid->log,oldpid->print,oldpid->dellog);
E 18
	 /* Nicht mehr loeschen, das macht der Kindprozess */
         free(oldpid->print);
	 oldpid->dellog = 0;
	}
       /* Logdatei loeschen */
       if ( oldpid->dellog ) unlink(oldpid->log);
       /* Zurueck in die normale Benutzerkennung */
E 15
       setreuid(-1,euid);
I 15
       /* Speicher freigeben */
E 15
       free(oldpid->log);
      }
I 8
#if LOGCODE
E 8
     /* Allgemeine Logdatei fuellen */
D 8
     lprintf("Process %d %s at %s",pid,line,ctime(&now));
E 8
I 8
     if ( loglevel&LLJOB ) lprintf("Process %d %s at %s",pid,line,ctime(&now));
#endif
E 8
     /* Genericqueue benachrichtigen */
D 4
     if ( oldpid->queueID == stat.queueID ) GenericNotify(pid,oldpid->requestID,line);
E 4
I 4
D 7
     if ( oldpid->queueID == stat.queueID ) 
E 7
I 7
     if ( oldpid->queueID == state.queueID ) 
E 7
D 8
      GenericNotify(pid,oldpid->requestID,line,(parchans *)0);
E 8
I 8
D 17
      GenericNotify(pid,oldpid->requestID,line,(char *)0);
E 17
I 17
D 38
      GenericNotify(nkNORMAL,pid,oldpid->requestID,line);
E 38
I 38
      {
       sprintf(line+strlen(line),"#%f",secs);
       GenericNotify(nkNORMAL,pid,oldpid->requestID,line);
      }
E 38
E 17
E 8
E 4
     /* Hilfsdatei loeschen */
     if ( *oldpid->tmp ) unlink(oldpid->tmp);
I 15
     /* Scriptdatei loeschen */
     if ( oldpid->com )
      {
       /* Als Benuzter loeschen */
       setreuid(-1,oldpid->uid);
       unlink(oldpid->com);
       setreuid(-1,euid);
       /* Speicher freigeben */
       free(oldpid->com);
      }
E 15
     /* Speicherstruktur freigeben */
I 13
     if ( oldpid->infd != -1 ) close(oldpid->infd);
I 15
     if ( oldpid->acp ) free(oldpid->cp);
E 15
E 13
     free(oldpid);
    }
  }
 /* Performancemessung fortsetzen, falls noetig */
D 5
 if ( doperf )
  doperformance(curperf,0);
 else
  unlock(0);
E 5
I 5
 if ( doperf ) doperformance(curperf,0);
E 5
I 2
 /* Fehlercode festhalten */
 errno = keeperr;
E 2
}

/*
  Einen Prozess aus der aktuellen Liste entfernen bzw. ihn nur suchen.
*/
static struct pidinfo *rempid(pid,remove)
PID pid;
int remove;
{
 struct pidinfo *act,**prev = &pids;

 for ( ; (act = *prev) && (act->pid != pid) ; prev = &act->next );
 if ( remove && act )
  {
   *prev = act->next;
   npid--;
  }
 return act;
}

/*
I 15
  Logdatei in einem Subprozess ausdrucken.
*/
D 18
static printlog(log,queue,dellog)
E 18
I 18
static printlog(gid,uid,log,queue,dellog)
int gid,uid,dellog;
E 18
char *log,*queue;
D 18
int dellog;
E 18
{
D 18
 static char syscall[256];
E 18
 char *real;
I 18
 FILE *sh;
E 18

 /* Subprozess erzeugen */
 if ( fork() ) return;
I 18
 /* Defaulteinstellung der Signale herstellen */
 signal(SIGALRM,SIG_DFL);
 signal(SIGCHLD,SIG_DFL);
 /* Ausgabekanaele schliessen */
 fclose(stdout);
 fclose(stderr);
 /* Alle Privilegien anschalten */
 setreuid(-1,euid);
 /* Benutzerkennung setzen */
 setgid(gid);
 setuid(uid);
E 18
 /* Name der Logdatei ermitteln */
 for ( real = log+strlen(log) ; (real-- > log) && (*real != '/') ; );
 if ( !*++real ) real = "logfile.log";
D 18
 /* Befehlszeile zusammensetzen */
 sprintf(syscall,"lp -c -d%s -o/BURST -t%s -s %s",queue,real,log);
 if ( dellog ) sprintf(syscall+strlen(syscall)," ; rm -f %s",log);
E 18
 /* Ausfuehren */
D 18
 system(syscall);
E 18
I 18
 if ( sh = popen("/bin/sh","w") )
  {
   /* Ausdrucken */
   fprintf(sh,"lp -c -d%s -o/FLAG/TRAILER -t%s -s %s\n",queue,real,log);
   /* Loeschen */
   if ( dellog ) fprintf(sh,"rm -f %s\n",log);
   /* Subprozess abschliessen */
   pclose(sh);
  }
E 18
 /* Fertig */
 exit(0);
}

/*
E 15
D 6
  Zeitpaar in Sekunden umrechnen.
*/
static double gett(tv)
struct timeval *tv;
{
 return tv->tv_sec+tv->tv_usec*1.0E-6;
}

/*
E 6
  Performancemessung starten. Die Messroutinen sind in FORTRAN codiert,
  um eine moeglichst genaue Aussage ueber das Verhalten der zu erwartenden
  Programme machen zu koennen. Die Performancemessung dauert etwa 3 Sekunden
  und wird daher in einem eigenen Prozess asynchron durchgefuehrt.
*/
static doperformance(state,dolock)
int state,dolock;
{
I 35
 static int acnt = 1;
E 35
D 4
 PID fork();
E 4
 double buf;

 /* Signalhandler abschalten */
 if ( dolock ) lock();
 /* Nur ausfuehren, wenn noch keine Messung laeuft */
 if ( perfpid == -1 )
  {
   /* Art der Messung vermerken */
   curperf = state;
I 35
   /* /etc/utmp nur alle 10 Stunden */
   if ( curperf == Putmp )
    if ( --acnt )
     curperf++;
    else
     acnt = 10;
E 35
   /* Messprozess erzeugen */
   if ( !(perfpid = fork()) )
    {
     /* Signalhandler ganz eleminieren */
     signal(SIGCHLD,SIG_DFL);
     signal(SIGALRM,SIG_DFL);
D 32
     /* Messung starten */
E 32
I 32
     /* Messung oder Utilitiy starten */
E 32
     switch (curperf)
      {
I 32
       case Putmp    : clean_utmp();
		       break;
E 32
       case Pinteger : integerperformance_(&buf);
     		       break;
       case Pfloat   : floatingperformance_(&buf);
     		       break;
       case Pfield   : fieldperformance_(&buf);
      }
     /* Messprozess beenden */
     exit(0);
    }
  }
 /* Periodisches Intervall wieder anschalten */
D 5
 unlock(dolock);
E 5
I 5
 if ( dolock ) unlock();
E 5
}

/*
I 32
  Alle aelteren 'job%d' aus einem dem /etc/utmp eleminieren.
*/
static clean_utmp()
{
 static char line[256];
D 35
 static int acnt = 1;
E 35
 long now = time((time_t *)0);
 FILE *rd = 0,*wr = 0;

D 35
 /* Alle 10 Stunden */
 if ( --acnt ) return;
 acnt = 10;
E 35
 /* Umkopieren */
 system("cp /etc/utmp /etc/qtmp");
 /* Auslesen der aktuellen Datei */
 if ( (rd = popen("/usr/lib/acct/fwtmp < /etc/qtmp","r")) &&
      (wr = popen("/usr/lib/acct/fwtmp -ic > /etc/utmp","w")) )
  while ( fgets(line,sizeof(line),rd) ) 
   if ( memcmp(line+14,"job",3) || (line[34] != '8') || (now-atoi(line+46) < 24*3600) )
    fprintf(wr,"%s",line);
 /* Schliessen aller Pipes */
 if ( rd ) pclose(rd);
 if ( wr ) pclose(wr);
}

/*
E 32
  Periodisch Systeminformationen ermitteln. Diese Informationen werden
  dann in einem groesseren Zeitintervall an die Genericqueue verschickt,
  falls eine derartige vorhanden ist.
*/
#define pm_info(p)	dg_sys_info(p,DG_SYS_INFO_PM_INFO_TYPE,\
				      DG_SYS_INFO_PM_CURRENT_VERSION)
#define vm_info(v)	dg_sys_info(v,DG_SYS_INFO_VM_INFO_TYPE,\
				      DG_SYS_INFO_VM_CURRENT_VERSION)

D 5
static doperiodic()
E 5
I 5
static void doperiodic()
E 5
{
 static int ticks = GENTICKS,pticks = PERFTICKS;
 struct dg_sys_info_pm_info pi;
 struct dg_sys_info_vm_info vi;
 double ntimes[3],delta;
D 2
 int i;
E 2
I 2
 int i,keeperr = errno;
E 2
D 5
 
E 5
I 5

I 8
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLHANDLER ) lprintf("Entered doperiodic()\n");
#endif
E 8
E 5
 /* Systeminformationen auslesen */
 if ( !pm_info(&pi) && !vm_info(&vi) )
  {
   /* Zeiten und Werte ermitteln */
   ntimes[0] = gett(&pi.current_time);
   ntimes[1] = gett(&pi.idle_time);
D 23
   ntimes[2] = vi.num_user_page_faults;
E 23
I 23
   ntimes[2] = vi.num_hard_page_faults;
E 23
   /* Raten berechnen, falls moeglich */
D 15
   if ( (times[0] != -1.0) && ((delta = ntimes[0]-times[0]) > 1.0E-2) )
E 15
I 15
   if ( (times[0] != -1.0) && ((delta = ntimes[0]-times[0]) > 0.01) )
E 15
    {
D 7
     stat.idle = (ntimes[1]-times[1])/delta;
     stat.faults = (ntimes[2]-times[2])/delta;
     if ( stat.idle < 1.0E-6 ) stat.idle = 0.0;
     if ( stat.faults < 1.0E-6 ) stat.faults = 0.0; 
E 7
I 7
     state.idle = (ntimes[1]-times[1])/delta;
     state.faults = (ntimes[2]-times[2])/delta;
     if ( state.idle < 1.0E-6 ) state.idle = 0.0;
     if ( state.faults < 1.0E-6 ) state.faults = 0.0; 
E 7
    }
   /* Aktuellen Zustand vermerken */
   for ( i = 3 ; i-- ; times[i] = ntimes[i] );
  }
D 5
 /* Weiter Aktionen nur durchfuehren, falls erlaubt */
 if ( nosignal )
E 5
I 5
 /* Eventuell GEN-Queue benachrichtigen */
 if ( !--ticks )
E 5
  {
D 5
   /* Zaehler soweit wie moeglich aktuell halten */
   if ( ticks > 1 ) ticks--;
   if ( pticks > 1 ) pticks--;
E 5
I 5
   ticks = GENTICKS;
   /* Eventuell neue Informationen von Kindprozessen uebernehmen */
D 6
   notify = 0;
E 6
   dopipe();
I 15
   /* Eventuell Informationen an einen Kindprozess weitergeben */
   dowrite();
E 15
D 6
   notify = 1;
E 6
   /* Nur durchfuehren, wenn unbedingt noetig */
   if ( whead ) dowait();
E 5
  }
D 5
 else
  { 
   /* Eventuell GEN-Queue benachrichtigen */
   if ( !--ticks )
    {
     ticks = GENTICKS;
     /* Nur durchfuehren, wenn unbedingt noetig */
     if ( whead )
      {
       lock();
       dowait();
       unlock(1);
      }
    }
   /* Performancemessung etwa jede halbe Stunde wiederholen */
   if ( !--pticks )
    {
     pticks = PERFTICKS;
     doperformance(Pinteger,1);
    }
E 5
I 5
D 32
 /* Performancemessung etwa jede halbe Stunde wiederholen */
E 32
I 32
 /* Performancemessung etwa jede Stunde wiederholen */
E 32
 if ( !--pticks )
  {
I 32
   /* Performancemessung starten */
E 32
   pticks = PERFTICKS;
D 34
   doperformance(Pinteger,0);
E 34
I 34
   doperformance(Putmp,0);
E 34
E 5
  }
D 5
 /* Intervalltakt neu setzen */
 alarm(1);
E 5
I 5
D 6
 /* Hauptprozess schlaeft */
 if ( slpcnt ) slpcnt--;
 /* Nur keine Signale verlieren */
 jobsignal();
E 6
E 5
I 2
 /* Fehlercode wieder herstellen */
 errno = keeperr;
E 2
}

/*
  Signal an einen Job schicken.
*/
static PID *sigjob(ki,msg,sig)
killinfo *ki;
struct svc_req *msg;
int sig;
{
 static PID pid;
 int err;

 /* Zugriffsrecht verifizieren. */
D 6
 pid = -1;
E 6
I 6
 pid = ERRSIGNAL_NOTROOT;
E 6
 if ( !authorized(msg) ) return &pid;
D 6
 pid = -2;
E 6
I 6
 pid = ERRSIGNAL_NOTATTACHED;
E 6
 if ( !allowed(ki->queueID,msg) ) return &pid;
 /* Doppelte Zugriffe sofort beantworten */
 if ( duplicate(ki->requestID) )return &lastPID;
 /* Prozess suchen. */
 lock();
 err = !rempid(ki->pid,0);
D 5
 unlock(1);
E 5
I 5
 unlock();
E 5
 /* Ergebnis auswerten */
D 6
 pid = -3;
E 6
I 6
 pid = ERRSIGNAL_NOTPID;
E 6
 if ( err ) return &pid;
 /* Signal der ganzen Session mitteilen */
 kill(-(pid = ki->pid),sig);
 /* Zugriff vermerken */
 lastID = ki->requestID;
 lastPID = pid;
I 8
#if LOGCODE
E 8
 /* Meldung machen */
D 8
 lprintf("Signal %d (%s) sent to process %d\n",sig,strsignal(sig),pid);
E 8
I 8
 if ( loglevel&LLJOB ) lprintf("Signal %d (%s) sent to process %d\n",sig,strsignal(sig),pid);
#endif
E 8
 /* Ergebnis melden */
 return &pid; 
}

/*
  Signalnummer in einen Text umwandeln.
*/
static char *strsignal(sig)
int sig;
{
 switch (sig)
  {
   case SIGNULL	  : return "null signal";
   case SIGHUP	  : return "hangup";
   case SIGINT	  : return "keyboard interrupt";
   case SIGQUIT	  : return "keyboard termination signal";
   case SIGILL	  : return "illegal instruction";
   case SIGTRAP	  : return "trace trap";
   case SIGABRT	  : return "abnormal termination";
   case SIGEMT	  : return "EMT instruction";
   case SIGPOLL	  : return "pollable event occurred";
   case SIGFPE	  : return "floating point exception";
   case SIGKILL	  : return "kill";
   case SIGBUS	  : return "bus error";
   case SIGSEGV	  : return "segmentation violation";
   case SIGSYS	  : return "bad argument to a system call";
   case SIGPIPE	  : return "write on a pipe with no one to read it";
   case SIGALRM	  : return "alarm clock";
   case SIGTERM	  : return "software termination signal";
   case SIGUSR1	  : return "user defined signal 1";
   case SIGUSR2	  : return "user defined signal 2";
   case SIGCLD	  : return "child terminated or stopped";
   case SIGPWR	  : return "power-fail restart";
   case SIGSTOP	  : return "stop";
   case SIGTSTP	  : return "stop signal generated from keyboard";
   case SIGCONT	  : return "continue after stop";
   case SIGTTIN	  : return "background read attempted from control terminal";
   case SIGTTOU	  : return "background write attempted to control terminal";
   case SIGWINCH  : return "window size change";
   case SIGXCPU	  : return "cpu time limit expired";
   case SIGXFSZ	  : return "file size limit exceeded";
   case SIGURG	  : return "urgent data available on socket";
   case SIGVTALRM : return "virtual timer alarm";
   case SIGPROF	  : return "profiling timer alarm";
   case SIGIO	  : return "i/o is possible on a descriptor";
   case SIGLOST	  : return "file record locks revoked";
   default	  : return 0;
  }
}

/*
  Eine Zeile in einen Logfile schreiben.
*/
static lprintf(va_alist)
va_dcl
{
 static char line[256];
 va_list args;
 char *fmt;

 /* Nur falls eine Logdatei angelegt wurde */
D 15
 if ( logf < 0 ) return;
E 15
I 15
D 24
 if ( logf == -1 ) return;
E 24
I 24
 if ( logfil == -1 ) return;
E 24
E 15
 /* Bearbeitung der variablen Liste starten */
 va_start(args);
 /* Format einlesen */
 fmt = va_arg(args,char *);
 /* Zeichenkette zusammensetzen */
 vsprintf(line,fmt,args);
 /* Bearbeitung der variablen Liste beenden */
 va_end(args);
 /* Datei beschreiben */
D 24
 while ( (write(logf,line,strlen(line)) == -1) && (errno == EINTR) );
E 24
I 24
 while ( (write(logfil,line,strlen(line)) == -1) && (errno == EINTR) );
E 24
}

/*
  Neue Genericqueue wurde akzeptiert.
*/
static attached(really)
int really;
{
 char *pref = really ? "" : "re",*net;
 struct in_addr ia;

I 8
#if LOGCODE
E 8
 /* Adresse eintragen */
D 6
 ia.s_addr = stat.haddr;
E 6
I 6
D 7
 ia.s_addr = htonl(stat.haddr);
E 7
I 7
 ia.s_addr = htonl(state.haddr);
E 7
E 6
 if ( !(net = inet_ntoa(ia)) ) net = "InterNET";
 /* Neue Situation ausgeben */
D 7
 lprintf("%s %sattached to %s via RPC (0x%08X,%u)\n",VERSION,pref,net,stat.hprog,stat.hvers);
E 7
I 7
D 8
 lprintf("%s %sattached to %s via RPC (0x%08X,%u)\n",VERSION,pref,net,state.hprog,state.hvers);
E 8
I 8
 if ( loglevel&LLSTATUS )
D 18
  lprintf("%s %sattached to %s via RPC (0x%08X,%u)\n",
	  VERSION,pref,net,state.hprog,state.hvers);
E 18
I 18
  lprintf("%s %sattached to %s via RPC (%d,%u)\n",VERSION,pref,net,state.hprog,state.hvers);
E 18
#endif
E 8
E 7
 /* Und Mitteilung machen */
D 4
 if ( !really ) GenericNotify(-1,0,"BOSSexec restarted");
E 4
I 4
D 8
 if ( !really ) GenericNotify(RESTARTPID,0,"BOSSexec restarted",(parchans *)0);
E 8
I 8
D 17
 if ( !really ) GenericNotify(RESTARTPID,0,"BOSSexec restarted",(char *)0);
E 17
I 17
 if ( !really ) GenericNotify(nkRESTART,0,0,NOSTR);
E 17
E 8
E 4
}

/*
  Ausgabe in die Backupdatei erzeugen.
*/
backup()
{
 struct backup bdata;

 /* Nur falls eine Backupdatei beschrieben wird */
D 15
 if ( bakf < 0 ) return;
E 15
I 15
 if ( bakf == -1 ) return;
E 15
 /* Daten zusammensetzen */
 bdata.control = CONTROL;
D 7
 strcpy(bdata.name,stat.name);
 if ( bdata.queueID = stat.queueID )
E 7
I 7
 strcpy(bdata.name,state.name);
 if ( bdata.queueID = state.queueID )
E 7
  {
D 7
   bdata.haddr = stat.haddr;
   bdata.hprog = stat.hprog;
   bdata.hvers = stat.hvers;
E 7
I 7
   bdata.haddr = state.haddr;
   bdata.hprog = state.hprog;
   bdata.hvers = state.hvers;
E 7
  }
 /* Daten an den Anfang der Datei schreiben */
 lseek(bakf,0,SEEK_SET);
 while ( (write(bakf,&bdata,sizeof(bdata)) == -1) && (errno == EINTR) );
}

/*
  Aktionen an die Genericqueue.
*/
D 4
static GenericNotify(pid,reqID,mess)
E 4
I 4
D 17
static GenericNotify(pid,reqID,mess,conn)
E 17
I 17
static GenericNotify(kind,pid,reqID,data)
Dkind kind;
E 17
E 4
PID pid;
ID reqID;
D 8
char *mess;
I 4
parchans *conn;
E 8
I 8
D 17
char *mess,*conn;
E 17
I 17
char *data;
E 17
E 8
E 4
{
 struct waiting *nw,*sw;
I 15
 int i;
E 15

I 8
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLROUTINE ) lprintf("Entered GenericNotify()\n");
D 17
 if ( loglevel&LLDUMP ) lprintf(" pid=%d reqID=%08x mess=<%s>\n",pid,reqID,mess);
E 17
I 17
 if ( loglevel&LLDUMP ) lprintf(" kind=%d pid=%d reqID=%08x\n",kind,pid,reqID);
E 17
#endif
E 8
 /* Speicher bereitstellen */
D 17
 if ( !(nw = MALLOC(struct waiting,1)) || !(nw->data = MALLOC(jobdone,1)) ||
      !(nw->data->text = strdup(mess)) )
E 17
I 17
 if ( !(nw = SALLOC(struct waiting)) || !(nw->data = SALLOC(jobdone)) ) return nomem(nw);
 /* Je nach Art der Uebertragung verfahren */
 switch (nw->data->info.kind = kind)
E 17
  {
D 17
   /* Speicher aufraeumen */
   if ( nw )
    {
     if ( nw->data ) free(nw->data);
     free(nw);
    }
   /* Fehler melden */
D 8
   lprintf("Out of memory during notification\n");
E 8
I 8
   if ( loglevel&LLERROR ) lprintf("Out of memory during notification\n");
E 8
   return;
  }
E 17
I 17
   case nkNORMAL    : /* Speicher fuer den Text duplizieren */
		      if ( !(nw->data->jdText = strdup(data)) ) return nomem(nw);
   case nkRESTART   : /* Keine weiteren Informationen */
		      break;
   case nkTRANSDONE : /* Abgearbeitetet Kanaele */
   case nkPARALLEL  : /* Verbundene Kanaele */
     		      nw->data->jdTrans = *(parchans *)data;
#if LOGCODE
		      /* Logdatei fuellen */
		      if ( loglevel&LLDUMP )
		       for ( i = 0 ; i < nw->data->jdTrans.parchans_len ; i++ )
			lprintf(" %08x%11d%11d\n",nw->data->jdTrans.parchans_val[i].IPaddr,
						  nw->data->jdTrans.parchans_val[i].IPport,
						  nw->data->jdTrans.parchans_val[i].FORunit);
#endif
		      break;
   case nkCONVERTER : /* Kanalstatistik eines Konverters */
		      nw->data->jdChans = *(converterchans *)data;
#if LOGCODE
		      /* Logdatei fuellen */
		      if ( loglevel&LLDUMP )
		       for ( i = 0 ; i < nw->data->jdChans.converterchans_len ; i++ )
D 18
			lprintf(" %08x%6d: e=%d b=%d ti=%f\n",
E 18
I 18
D 20
			lprintf(" %08x%6d: e=%d b=%d ti=%.2f\n",
E 20
I 20
			lprintf(" %08x%6d: e=%.0f b=%.0f ti=%.2f\n",
E 20
E 18
				nw->data->jdChans.converterchans_val[i].IPaddr,
				nw->data->jdChans.converterchans_val[i].IPport,
				nw->data->jdChans.converterchans_val[i].events,
				nw->data->jdChans.converterchans_val[i].bytes,
				nw->data->jdChans.converterchans_val[i].idleT);
#endif
  } 
E 17
 /* Speicher initialisieren */
 nw->data->ackID = ackCnt++;
D 7
 nw->data->queueID = stat.queueID;
E 7
I 7
 nw->data->queueID = state.queueID;
E 7
 nw->data->pid = pid;
 nw->data->job = reqID;
I 8
D 17
 nw->data->conn.parchans_len = 0;
 nw->data->conn.parchans_val = 0;
D 13
 nw->data->perf.filterchans_len = 0;
 nw->data->perf.filterchans_val = 0;
E 13
I 13
 nw->data->perf.converterchans_len = 0;
 nw->data->perf.converterchans_val = 0;
E 13
E 8
I 4
 if ( conn )
D 8
  nw->data->conn = *conn;
 else
  {
   nw->data->conn.parchans_len = 0;
   nw->data->conn.parchans_val = 0;
  }
E 8
I 8
D 13
  if ( pid == FILTERPID )
E 13
I 13
  if ( pid == CONVERTERPID )
E 13
   {
D 13
    nw->data->perf = *(filterchans *)conn;   
E 13
I 13
    nw->data->perf = *(converterchans *)conn;   
E 13
#if LOGCODE
    /* Logdatei fuellen */
    if ( loglevel&LLDUMP )
D 15
     {
      int i;

D 13
      for ( i = 0 ; i < nw->data->perf.filterchans_len ; i++ )
D 12
       lprintf(" %08x%6d: b=%d ti=%f tt=%f tb=%f\n",
E 12
I 12
       lprintf(" %08x%6d: e=%d b=%d ti=%f tt=%f tb=%f\n",
E 12
	       nw->data->perf.filterchans_val[i].IPaddr,
	       nw->data->perf.filterchans_val[i].IPport,
I 12
	       nw->data->perf.filterchans_val[i].events,
E 12
	       nw->data->perf.filterchans_val[i].bytes,
	       nw->data->perf.filterchans_val[i].idleT,
	       nw->data->perf.filterchans_val[i].transT,
	       nw->data->perf.filterchans_val[i].busyT);
E 13
I 13
      for ( i = 0 ; i < nw->data->perf.converterchans_len ; i++ )
       lprintf(" %08x%6d: e=%d b=%d ti=%f\n",
	       nw->data->perf.converterchans_val[i].IPaddr,
	       nw->data->perf.converterchans_val[i].IPport,
	       nw->data->perf.converterchans_val[i].events,
	       nw->data->perf.converterchans_val[i].bytes,
	       nw->data->perf.converterchans_val[i].idleT);
E 13
     }
E 15
I 15
     for ( i = 0 ; i < nw->data->perf.converterchans_len ; i++ )
      lprintf(" %08x%6d: e=%d b=%d ti=%f\n",
              nw->data->perf.converterchans_val[i].IPaddr,
              nw->data->perf.converterchans_val[i].IPport,
              nw->data->perf.converterchans_val[i].events,
              nw->data->perf.converterchans_val[i].bytes,
     	      nw->data->perf.converterchans_val[i].idleT);
E 15
#endif
   }
  else
   {
    nw->data->conn = *(parchans *)conn;
#if LOGCODE
    /* Logdatei fuellen */
    if ( loglevel&LLDUMP )
D 15
     {
      int i;

      for ( i = 0 ; i < nw->data->conn.parchans_len ; i++ )
       lprintf(" %08x%11d%11d\n",nw->data->conn.parchans_val[i].IPaddr,
 	       		         nw->data->conn.parchans_val[i].IPport,
	       		         nw->data->conn.parchans_val[i].FORunit);
     }
E 15
I 15
     for ( i = 0 ; i < nw->data->conn.parchans_len ; i++ )
      lprintf(" %08x%11d%11d\n",nw->data->conn.parchans_val[i].IPaddr,
              		        nw->data->conn.parchans_val[i].IPport,
              		        nw->data->conn.parchans_val[i].FORunit);
E 15
#endif
   }
E 17
E 8
E 4
 /* Struktur verketten */
 nw->next = 0;
 if ( !(sw = whead) )
  whead = nw;
 else
  {
   while ( sw->next ) sw = sw->next;
   sw->next = nw;
  }
 /* GEN-Queue benachrichtigen */
 dowait();
}

/*
I 17
  Kein Speicher mehr zu bekommen in 'GenericNotify'.
*/
static nomem(wi)
struct waiting *wi;
{
 /* Allokatierten Speicher freigeben */
 if ( wi )
  {
   if ( wi->data ) free(wi->data);
   free(wi);
  }
 /* Fehler melden */
 if ( loglevel&LLERROR ) lprintf("Out of memory during notification\n");
}

/*
E 17
I 5
  Daten ueber die Kommunikationsleitung zum Hauptprogramm uebertragen.
*/
D 17
static CreateNotify(pid,reqID,data)
PID pid;
E 17
I 17
static CreateNotify(kind,reqID,data)
Dkind kind;
E 17
ID reqID;
parchans *data;
{
 struct pipehead ph;
 struct iovec io[2];
D 6
 int len,ilen;
E 6
I 6
 int ilen;
E 6

I 8
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLROUTINE ) lprintf("Entered CreateNotify()\n");
D 17
 if ( loglevel&LLDUMP ) lprintf(" pid=%d reqID=%08x\n",pid,reqID);
E 17
I 17
 if ( loglevel&LLDUMP ) lprintf(" kind=%d pid=%d reqID=%08x\n",kind,getpid(),reqID);
E 17
#endif
E 8
 /* Header aufbauen */
D 17
 ph.pid = pid;
E 17
I 17
 ph.kind = kind;
E 17
 ph.mpid = getpid();
 ph.reqID = reqID;
 ph.items = data->parchans_len;
 /* Paketkopf */
 io[0].iov_base = (char *)&ph;
 io[0].iov_len = sizeof(ph);
 /* Die Daten selbst */
 io[1].iov_base = (char *)data->parchans_val;
 io[1].iov_len = ph.items*sizeof(data->parchans_val[0]);
 /* Kontrolle */
 if ( (ilen = io[0].iov_len+io[1].iov_len) > fpathconf(pfd[1],_PC_PIPE_BUF) )
  {
   lprintf("Packet length exceeds PIPE_BUF, please reconfigure\n");
   return;
  }
D 6
 /* Abschicken */
 while ( ((len = writev(pfd[1],io,2)) == -1) && (errno == EAGAIN) );
 /* Fehler melden */
 if ( len != ilen ) lprintf("Could not write to pipe\n");
E 6
I 6
 /* Abschicken und Fehler melden */
D 8
 if ( writev(pfd[1],io,2) != ilen ) lprintf("Could not write to pipe\n");
E 8
I 8
 if ( (writev(pfd[1],io,2) != ilen) && (loglevel&LLERROR) )
  lprintf("Could not write to pipe\n");
E 8
E 6
}

/*
E 5
  Information an die GEN-Queue abschicken.
*/
static dowait()
{
 static struct timeval retry = { 5, 0 },total = { 0, 0 };
 int sock = RPC_ANYSOCK,res;
 struct waiting *wq,**pq;
 struct sockaddr_in rem;

I 8
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLROUTINE ) lprintf("Entered dowait()\n");
#endif
E 8
D 5
 /* Nur bei aktiver GEN-Queue */
 if ( !stat.queueID ) return;
E 5
I 5
 /* Nur bei aktiver GEN-Queue und ausserhalb eines AddNotifys */
D 7
 if ( !notify || !stat.queueID ) return;
E 7
I 7
 if ( !notify || !state.queueID ) return;
E 7
E 5
 /* RPC-Handle initialisieren */
 if ( !gen )
  {
   /* IP-Adresse des Partners aufsetzen */
   rem.sin_family = AF_INET;
D 4
   rem.sin_addr.s_addr = stat.haddr;
   rem.sin_port = 0;
E 4
I 4
D 7
   rem.sin_addr.s_addr = htonl(stat.haddr);
E 7
I 7
   rem.sin_addr.s_addr = htonl(state.haddr);
E 7
   rem.sin_port = htons(0);
E 4
   /* RPC-Handle erzeugen */
D 7
   if ( !(gen = clntudp_create(&rem,stat.hprog,stat.hvers,retry,&sock)) ) return;
E 7
I 7
   if ( !(gen = clntudp_create(&rem,state.hprog,state.hvers,retry,&sock)) ) return;
E 7
   /* Authorisierungsstruktur aufsetzen */
   auth_destroy(gen->cl_auth);
   gen->cl_auth = authunix_create_default();
  }
 /* Alle Eintraege durchgehen */
 for ( pq = &whead ; wq = *pq ; )
D 7
  if ( wq->data->queueID != stat.queueID )
E 7
I 7
  if ( wq->data->queueID != state.queueID )
E 7
   remwait(pq);
  else
   {
    /* Befehl abschicken */
    if ( clnt_call(gen,1,xdr_jobdone,wq->data,xdr_void,&res,total) != RPC_TIMEDOUT )
     {
      /* RPC-Handle zerstoeren und in GENTICKS Sekunden nochmal nachsehen */
      clnt_destroy(gen);
      gen = 0;
      return;
     }
    /* Naechstes Element */
    pq = &wq->next;
   }
}

/*
  Element nach Bearbeitung aus der Warteliste entfernen.
*/
D 17
static struct waiting *remwait(elp)
E 17
I 17
static remwait(elp)
E 17
struct waiting **elp;
{
 struct waiting *el = *elp;

 /* Verkettung aufloesen */
 *elp = el->next;
 /* Seicher freigeben */
D 4
 free(el->data->text);
E 4
I 4
 xdr_free(xdr_jobdone,el->data);
E 4
 free(el->data);
 free(el);
}
I 3

/*
I 5
  Ueber den Kommunikationskanal 'pfd' koennen die Kindprozesse der EXEC-Queue
  Eintraege in der Warteliste erzeugen, die dann ueber den gewohnten Acknowledge-
D 8
  mechanismus an die GEN-Queue weitergegeben werden.
E 8
I 8
D 13
  mechanismus an die GEN-Queue weitergegeben werden. Filterdaten werden prinzipiell
E 13
I 13
  mechanismus an die GEN-Queue weitergegeben werden. Konverterdaten werden prinzipiell
E 13
  nur von Kindprozessen verschickt, daher ist eine Vorbereitung in CreateNotify
  nicht notwendig.
E 8
*/
static dopipe()
{
 static struct pipehead ph;
 static parchans pc;
 static int ix = 0,len = sizeof(ph),kill = 0;
 static char *cur = (char *)&ph,ch;
 int nlen;

I 8
#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLROUTINE ) lprintf("Entered dopipe()\n");
#endif
E 8
 /* Nachsehen, ob Daten angekommen sind */
 while ( (nlen = read(pfd[0],kill ? &ch : (cur+ix),kill ? 1 : (len-ix))) > 0 )
  /* Nachsehen, ob Daten komplett sind */
  if ( (ix += nlen) == len )
   if ( cur == (char *)&ph )
    {
D 8
     /* Laenge ermitteln */
     len = (pc.parchans_len = ph.items)*sizeof(pc.parchans_val[0]);
E 8
I 8
D 13
     /* Laenge ermitteln, bei Filterdaten einfach die Laenge veraendern */
     if ( ph.pid == FILTERPID )
      len = (pc.parchans_len = ph.items)*sizeof(filterchan);
E 13
I 13
     /* Laenge ermitteln, bei Konverterdaten einfach die Laenge veraendern */
D 17
     if ( ph.pid == CONVERTERPID )
E 17
I 17
     if ( ph.kind == nkCONVERTER )
E 17
      len = (pc.parchans_len = ph.items)*sizeof(converterchan);
E 13
     else
      len = (pc.parchans_len = ph.items)*sizeof(parchan);
E 8
     /* Speicher reservieren */
D 15
     if ( !(cur = malloc(len)) )
E 15
I 15
     if ( !(cur = MALLOC(char,len)) )
E 15
      {
D 8
       lprintf("Out of memory during pipe read\n");
E 8
I 8
       if ( loglevel&LLERROR ) lprintf("Out of memory during pipe read\n");
E 8
       kill = 1;
      } 
     else
      pc.parchans_val = (parchan *)cur;
     /* Daten lesen */
     ix = 0;
    }
   else
    {
     /* Alles komplett */
D 6
     if ( !kill ) GenericNotify(ph.pid,ph.reqID,"Subnotification",&pc);
E 6
I 6
     if ( !kill )
      {
       notify = 0;
D 8
       GenericNotify(ph.pid,ph.reqID,"Subnotification",&pc);
E 8
I 8
D 17
       GenericNotify(ph.pid,ph.reqID,"Subnotification",(char *)&pc);
E 17
I 17
       GenericNotify(ph.kind,ph.mpid,ph.reqID,&pc);
E 17
E 8
       notify = 1;
      }
E 6
     /* Naechsten Header einlesen */
     cur = (char *)&ph;
     len = sizeof(ph);
     ix = kill = 0;
    }
}

/*
I 15
  Nachsehen, an welchen Konverterprozess noch Daten zu schicken sind.
*/
static dowrite()
{
 struct pidinfo *act;
 int wlen;

#if LOGCODE
 /* Logdatei fuellen */
 if ( loglevel&LLROUTINE ) lprintf("Entered dowrite()\n");
#endif
 /* Konverter mit offenen Daten suchen und Daten rausschreiben */
 for ( act = pids ; act ; act = act->next )
  if ( act->infd != -1 )
   while ( act->ncp && ((wlen = write(act->infd,act->cp,act->ncp)) > 0) )
    {
     if ( act->ncp -= wlen ) memmove(act->cp,act->cp+wlen,act->ncp);
#if LOGCODE
     /* Logdatei fuellen */
     if ( loglevel&LLDUMP ) 
      lprintf("Written %d bytes to converter process %d\n",wlen,act->pid);
#endif
    }
}

/*
E 15
E 5
  Hilfsprogramm fuer die EXEC-Queue. Zum Messen der Uebertragungsperformance
  zwischen Maschinen wird ein TCP-Kanal zu dieser Routine geoeffnet. Sie nimmt
  die Daten mit hoechstmoeglicher Geschwindigkeit entgegen. Der TCP-Port ist
D 4
  nicht festgelegt und wird beim binden vom System uebergeben.
E 4
I 4
  nicht festgelegt und wird beim Binden vom System uebergeben. Der Prozess
  laeuft mit erhoehter Prioritaet (TCPPRIO) damit die maximale Transferrate
  gemessen werden kann. Sie wird von der GEN-Queue benutzt, um Paralleljobs
  zu verteilen.
E 4
*/
I 6
D 8
#define FAILEATER(msg)		{ lprintf(msg); close(ms); return; }
E 8
I 8
#define FAILEATER(msg)		{ if ( loglevel&LLERROR ) lprintf(msg); close(ms); return; }
E 8

E 6
static Eater()
{
D 4
 static char buf[1024];
 int ms,ns,len,nblk = 1;
E 4
I 4
 static char buf[TCPBUF];
 static int per = 0;
 int ns,len,ms,nblk = 1;
E 4
 struct sockaddr_in me;
 fd_set all,reads,exs;

 /* TCP-Kanal oeffnen */
D 6
 if ( (ms = socket(AF_INET,SOCK_STREAM,0)) < 0 )
  {
   lprintf("Could not create TCP socket\n");
   return;
  }
E 6
I 6
D 15
 if ( (ms = socket(AF_INET,SOCK_STREAM,0)) < 0 ) FAILEATER("Could not create TCP socket\n");
E 15
I 15
 if ( (ms = socket(AF_INET,SOCK_STREAM,0)) == -1 ) FAILEATER("Could not create TCP socket\n");
E 15
E 6
 /* TCP-Verbindung aufbauen */
 me.sin_family = AF_INET;
D 4
 me.sin_addr.s_addr = INADDR_ANY;
 me.sin_port = 0;
E 4
I 4
D 15
 me.sin_addr.s_addr = htonl(INADDR_ANY);
E 15
I 15
 me.sin_addr.s_addr = INADDR_ANY;
E 15
 me.sin_port = htons(0);
E 4
D 6
 if ( bind(ms,&me,sizeof(me)) < 0 )
  {
   lprintf("Could not bind to any TCP socket\n");
I 4
   close(ms);
E 4
   return;
  }
E 6
I 6
D 15
 if ( bind(ms,&me,sizeof(me)) < 0 ) FAILEATER("Could not bind to any TCP socket\n");
E 15
I 15
 if ( bind(ms,&me,sizeof(me)) == -1 ) FAILEATER("Could not bind to any TCP socket\n");
E 15
E 6
D 4
 /* Nicht blockierend */
 ioctl(ms,FIONBIO,&nblk);
 /* TCP-Port auslesen */
E 4
I 4
 /* TCP Port auslesen */
E 4
 len = sizeof(me);
D 6
 if ( getsockname(ms,&me,&len) < 0 )
  {
   lprintf("Could not get my TCP port\n");
I 4
   close(ms);
E 4
   return;
  }
E 6
I 6
D 15
 if ( getsockname(ms,&me,&len) < 0 ) FAILEATER("Could not get my TCP port\n");
E 15
I 15
 if ( getsockname(ms,&me,&len) == -1 ) FAILEATER("Could not get my TCP port\n");
E 15
E 6
I 4
 /* Nicht blockierend */
D 6
 ioctl(ms,FIONBIO,&nblk);
E 6
I 6
 if ( ioctl(ms,FIONBIO,&nblk) == -1 ) FAILEATER("Could not unblock TCP socket\n");
E 6
E 4
 /* TCP-Verbindung abhorchen */
D 4
 if ( listen(ms,5) < 0 )
E 4
I 4
D 6
 if ( listen(ms,3) < 0 )
E 4
  {
D 4
   lprintf("Could not transition to listening\n");
E 4
I 4
   lprintf("Could not listen on TCP socket\n");
   close(ms);
E 4
   return;
  }
E 6
I 6
D 15
 if ( listen(ms,3) < 0 ) FAILEATER("Could not listen on TCP socket\n");
E 15
I 15
 if ( listen(ms,3) == -1 ) FAILEATER("Could not listen on TCP socket\n");
E 15
 /* Jedesmal laenger warten bis zum Neustart */
 per += 60;
E 6
D 4
 /* Ergebnis melden */
 lprintf("Eater is using TCP port %d\n",ntohs(me.sin_port));
E 4
I 4
 /* TCP Hilfsprozess erzeugen */
 if ( epid = fork() )
  {
   if ( epid == -1 )
D 8
    lprintf("Could not fork() TCP utility process\n");
E 8
I 8
    {
     if ( loglevel&LLERROR ) lprintf("Could not fork() TCP utility process\n");
    }
E 8
   else
D 7
    lprintf("Eater process %d uses TCP port %d\n",epid,stat.EaterPort = ntohs(me.sin_port));
E 7
I 7
D 8
    lprintf("Eater process %d uses TCP port %d\n",epid,state.EaterPort = ntohs(me.sin_port));
E 8
I 8
    {
     state.EaterPort = ntohs(me.sin_port);
#if LOGCODE
     if ( loglevel&LLSTATUS )
      lprintf("Eater process %d uses TCP port %d\n",epid,state.EaterPort);
#endif
    }
E 8
E 7
   /* Aufraeumen */
   close(ms);
   return;
  }
 /* Prioritaet erhoehen */
 nice(TCPPRIO);
E 4
 /* Descriptorfeld initialisieren */
 FD_ZERO(&all);
 FD_SET(ms,&all);
I 4
 /* Alle I/O-Kanaele schliessen, soweit noetig */
I 15
 pfd[1] = -1;
E 15
 closeall(0,ms);
 /* Und Operation starten */
E 4
 for ( ; ; )
  {
   /* Kanaele aufsetzen */
   reads = all;
   exs = all;
   /* Abwarten */
   if ( select(FD_SETSIZE,&reads,(fd_set *)0,&exs,(struct timeval *)0) <= 0 )
    {
D 8
     lprintf("Selection on TCP socket failed\n");
E 8
I 8
     if ( loglevel&LLERROR ) lprintf("Selection on TCP socket failed\n");
E 8
D 4
     return;
E 4
I 4
     break;
E 4
    }
   /* Schwere Fehler abfangen */
   if ( FD_ISSET(ms,&exs) )
    {
D 8
     lprintf("Exception on TCP socket\n");
E 8
I 8
     if ( loglevel&LLERROR ) lprintf("Exception on TCP socket\n");
E 8
D 4
     return;
E 4
I 4
     break;
E 4
    }
   /* Neue Verbindung aufbauen */
   if ( FD_ISSET(ms,&reads) )
    {
     /* Aus der Liste entfernen */
     FD_CLR(ms,&reads);
     /* Partner ermitteln */
     len = sizeof(me);
D 15
     if ( (ns = accept(ms,&me,&len)) >= 0 )
E 15
I 15
     if ( (ns = accept(ms,&me,&len)) != -1 )
E 15
D 6
      {
       /* Nicht blockierend */
       if ( ioctl(ns,FIONBIO,&nblk) < 0 )
D 4
        {
	 shutdown(ns,2);
	 close(ns);
        }
E 4
I 4
	close(ns);
E 4
       else
        /* Und einbauen */
        FD_SET(ns,&all);
     }
E 6
I 6
      /* Nicht blockierend */
D 7
      if ( ioctl(ns,FIONBIO,&nblk) < 0 )
E 7
I 7
      if ( ioctl(ns,FIONBIO,&nblk) == -1 )
E 7
       close(ns);
      else
       /* Und einbauen */
       FD_SET(ns,&all);
E 6
    }
   /* Verbindungen abtesten */
   for ( ns = FD_SETSIZE ; ns-- ; )
    {
     if ( !FD_ISSET(ns,&exs) )
      {
       if ( !FD_ISSET(ns,&reads) ) continue;
       /* Daten lesen */
       while ( (len = read(ns,buf,sizeof(buf))) > 0 );
D 15
       if ( (len < 0) && (errno == EAGAIN) ) continue;
E 15
I 15
       if ( (len == -1) && (errno == EAGAIN) ) continue;
E 15
      }
     /* Verbindung abbauen */
D 4
     shutdown(ns,2);
E 4
     close(ns);
     FD_CLR(ns,&all);
   }
  }
I 4
 /* Etwas warten bis zum Neustart */
D 6
 per += 60;
E 6
 sleep(per);
 /* Aufhoeren */
 exit(1);
E 4
}

I 4
/*
  Daten an einen anderen Eater schicken und Zeit messen.
*/
static transfer(ip)
parchan *ip;
{
 static char buf[TCPBUF];
 struct dg_sys_info_pm_info pi;
 struct sockaddr_in eater;
 long bytes = ip->IPbytes;
 struct timeval t0,t1;
 int tlen,ms;

 /* TCP/IP socket aufsetzen */
 eater.sin_family = AF_INET;
 eater.sin_addr.s_addr = htonl(ip->IPaddr);
 eater.sin_port = htons(ip->IPport);
 /* Zeit loeschen */
 ip->IPsecs = ip->IPusecs = -1;
 /* Kanal erzeugen */
D 15
 if ( (ms = socket(AF_INET,SOCK_STREAM,0)) < 0 ) return;
E 15
I 15
 if ( (ms = socket(AF_INET,SOCK_STREAM,0)) == -1 ) return;
E 15
 /* Mit dem Eater verbinden */
D 15
 if ( connect(ms,&eater,sizeof(eater)) < 0 )
E 15
I 15
 if ( connect(ms,&eater,sizeof(eater)) == -1 )
E 15
  {
   close(ms);
   return;
  }
 /* Systemzeit auslesen */
 if ( pm_info(&pi) )
  {
   close(ms);
   return;
  }
 t0 = pi.current_time;
 /* Daten uebertragen */
 for ( ; bytes > 0 ; bytes -= tlen )
  if ( (tlen = write(ms,buf,MIN(bytes,sizeof(buf)))) <= 0 )
   {
    close(ms);
    return;
   }
 /* Systemzeit auslesen */
 if ( pm_info(&pi) )
  {
   close(ms);
   return;
  }
 t1 = pi.current_time;
 /* Kanal schliessen */
 close(ms);
 /* Zeit ausrechenen */
 ip->IPsecs = t1.tv_sec-t0.tv_sec;
 if ( (ip->IPusecs = t1.tv_usec-t0.tv_usec) < 0 )
  {
   ip->IPsecs--;
   ip->IPusecs += 1000000;
  }
}

/*
  Schliessen aller Dateikanaele bis auf eine moegliche Ausnahme.
*/
static closeall(bound,excl)
int bound,excl;
{
 int fd;

 for ( fd = getdtablesize() ; fd-- > bound ; )
D 5
  if ( (fd != excl) && (fd != logf) )
E 5
I 5
D 24
  if ( (fd != excl) && (fd != logf) && (fd != pfd[1]) )
E 24
I 24
  if ( (fd != excl) && (fd != logfil) && (fd != pfd[1]) )
E 24
E 5
   close(fd);
I 7
}

/*
  Alle Parallelkanaele oeffnen und logische Namen definieren. Ein Kommandostring
  gibt in der Form:
  	IP ',' port ',' unit { ':' IP ',' port ',' unit }
  alle zu oeffnenden Verteilungskanaele <IP,port> mit den dazugehoerigen FORTRAN
  I/O-Units an.
*/
static openparallel(ips,reqID)
char *ips;
ID reqID;
{
I 36
 int err = 0,pall,parfd,tcpfd,acc,attr,ret,*fds = NULL,*fdn,n;
E 36
 static char lbuf[sizeof(LOGNAME)+LOGMORE],pbuf[50];
D 36
 int err = 0,pall,parfd,tcpfd,acc,attr,ret;
E 36
 char *cur,*intip,*ip,*port,*unit; 
 struct parallel_connect conn;
 struct item_list_3 item[3];
 struct strioctl str;
 struct in_addr ipa;
 struct stat parst;
 parchans all;
 parchan *np;

 /* Konistenztest */
 if ( (strlen(parname)+10) >= sizeof(pbuf) )
  {
   fprintf(stderr,"Parallel device name %s is too long\n",parname);
   exit(EINVAL);
  }
 /* Initialisieren */
 pall = all.parchans_len = 0;
 /* Zeichenkette duplizieren */
 if ( !(intip = strdup(ips)) )
  err = 1;
 else
  /* Alle durchgehen */
  while ( intip )
   {
    /* Feldelement reservieren */
    err = 1;
    if ( all.parchans_len == pall )
     {
      /* Neues Feld reservieren */
D 36
      if ( !(np = MALLOC(parchan,pall+10)) ) break;
E 36
I 36
      if ( !(np = MALLOC(parchan,pall+10)) || !(fdn = MALLOC(int,pall+10)) ) break;
E 36
      /* Altes Feld loeschen */
      if ( pall )
       {
	memmove(np,all.parchans_val,pall*sizeof(np[0]));
	free(all.parchans_val);
I 36
	memmove(fdn,fds,pall*sizeof(fdn[0]));
	free(fds);
E 36
       }
      /* Variablen aufsetzen */
      pall += 10;
      all.parchans_val = np;
I 36
      fds = fdn;
E 36
     }
    /* Element ermitteln */
    if ( (intip = strchr(cur = intip,':')) ) *intip++ = '\0';
    /* Zeichenkette zerlegen */
    err = 2;
    if ( !(cur = strchr(ip = cur,',')) ) break;
    *cur++ = '\0';
    if ( !(cur = strchr(port = cur,',')) ) break;
    *cur++ = '\0';
    unit = cur;
    /* IP-Adresse umrechnen */
    ipa = inet_addr(ip);
D 15
    if ( (all.parchans_val[all.parchans_len].IPaddr = ntohl(ipa.s_addr)) == -1 )
E 15
I 15
    if ( (all.parchans_val[all.parchans_len].IPaddr = ntohl(ipa.s_addr)) == INADDR_NULL )
E 15
     {
      fprintf(stderr,"Illegal IP-address <%s>\n",ip);
      exit(EINVAL);
     }
    /* IP-Port umrechnen */
    if ( !parval(&all.parchans_val[all.parchans_len].IPport,port,1,0x7fff) )
     {
      fprintf(stderr,"Illegal IP-port <%s>\n",port);
      exit(EINVAL);
     }
    /* FORTRAN-Unit umrechnen */
    if ( !parval(&all.parchans_val[all.parchans_len].FORunit,unit,1,999) )
     {
      fprintf(stderr,"Illegal FORTRAN-unit <%s>\n",unit);
      exit(EINVAL);
     }
    /* Parallelkanal oeffnen */
    if ( (parfd = open(parname,O_RDWR)) == -1 )
     {
      perror("Opening parallel device");
      exit(errno);
     } 
    /* Devicenummer ermitteln */
    if ( fstat(parfd,&parst) == -1 )
     {
      perror("Getting parallel device information");
      exit(errno);
     }
    if ( (parst.st_mode&S_IFMT) != S_IFCHR )
     {
      fprintf(stderr,"%s is not a parallel device\n",parname);
      exit(EINVAL);
     }
    /* Netzwerkprotokoll oeffnen */
    if ( (tcpfd = open(tcpname,O_RDWR)) == -1 )
     {
      perror("Opening network device");
      exit(errno);
     }
D 12
    /* Kanaele verbinden */
E 12
I 12
    /* Kanaele verbinden und unnoetige Descriptoren eleminieren */
E 12
    if ( ioctl(parfd,I_LINK,tcpfd) == -1 )
     {
      perror("Connecting parallel device to network device");
      exit(errno);
     }
I 12
    close(tcpfd);
E 12
    /* Partner suchen */
    conn.sin_family = AF_INET;
    conn.sin_addr.s_addr = htonl(all.parchans_val[all.parchans_len].IPaddr);
    conn.sin_port = htons(all.parchans_val[all.parchans_len].IPport);
    str.ic_cmd = PARALLEL_CONNECT;
    str.ic_timout = 20;
    str.ic_dp = (char *)&conn;
    str.ic_len = sizeof(conn);
    if ( ioctl(parfd,I_STR,&str) == -1 )
     {
D 13
      perror("Connecting to filter");
E 13
I 13
      perror("Connecting to converter");
E 13
      exit(errno);
     }
    /* Eigene Adresse ermitteln */
    if ( str.ic_len != sizeof(conn) )
     {
      fprintf(stderr,"Illegal response for connection\n");
      exit(EINVAL);
     }
    all.parchans_val[all.parchans_len].IPaddr = ntohl(conn.sin_addr.s_addr);
    all.parchans_val[all.parchans_len].IPport = ntohs(conn.sin_port);
I 36
    /* Kanalnummer zum saubern schliessen merken */
    fds[all.parchans_len] = parfd;
E 36
    /* Logischen Namen definieren */
    sprintf(lbuf,LOGNAME,all.parchans_val[all.parchans_len++].FORunit);
    sprintf(pbuf,"%s%d",parname,minor(parst.st_rdev));
    attr = LNM$M_TERMINAL;
    acc = PSL$C_USER;
    item[0].blen = sizeof(attr);
    item[0].code = LNM$_ATTRIBUTES;
    item[0].buf = (char *)&attr;
    item[0].len = 0;
    item[1].blen = strlen(pbuf);
    item[1].code = LNM$_STRING;
    item[1].buf = pbuf;
    item[1].len = 0;
    item[2].blen = item[2].code = 0;
    if ( !(sys$crelnm_((int *)0,LOGTABLE,lbuf,&acc,item,sizeof(LOGTABLE)-1,strlen(lbuf))&1) )
     {
      fprintf(stderr,"Could not define logical name\n");
      exit(EINVAL);
     }
    /* Kein Fehler soweit */
    err = 0;
   }
 /* Fehler in der Kanalbezeichnung */
 switch (err)
  {
   case 1 : fprintf(stderr,"Out of memory\n");
     	    exit(ENOMEM);
   case 2 : fprintf(stderr,"Invalid parallel connection string <%s>\n",ips);
            exit(EINVAL);
  }
 /* Subprozess erzeugen */
 switch (fork())
  {
   case -1 : perror("Creating parallel process");
     	     exit(errno);
   case  0 : closeall(3,pfd[1] = -1);
     	     return;
  }
 /* Ergebnis an die EXEC-Queue uebermitteln */
D 17
 CreateNotify(PARALLELPID,reqID,&all);
E 17
I 17
 CreateNotify(nkPARALLEL,reqID,&all);
E 17
 /* Ende des Kindprozesses abwarten */
 if ( wait(&ret) == -1 )
  {
   perror("Waiting for parallel process ending");
   exit(errno);
  }
I 36
 /* Alle Kanaele sauber schliessen */
 for ( n = all.parchans_len ; n-- ; )
  for ( ; ; )
   {
    /* STREAMS ioctl abschicken */
    str.ic_cmd = PARALLEL_SYNCHRONIZE;
    str.ic_timout = 3600;
    str.ic_dp = (char *)NULL;
    str.ic_len = 0;
    if ( ioctl(fds[n],I_STR,&str) != -1 ) break;
    if ( errno != ETIME )
     {
      perror("Synchronizing parallel data");
      break;
     }
   }
E 36
 /* Versuchen, den Returncode zu reproduzieren */
 exit(WIFEXITED(ret) ? WEXITSTATUS(ret) : EINVAL);
}

/*
  Text in Zahl umwandeln.
*/
static parval(ip,str,minv,maxv)
int *ip,minv,maxv;
char *str;
{
 char *more;

 /* Umwandeln und auf Grenzen testen */
 errno = 0;
D 8
 return ((((*ip = strtoul(str,&more,10)) != -1) || !errno) && 
E 8
I 8
 return ((((*ip = strtoul(str,&more,0)) != -1) || !errno) && 
E 8
	 more && !*more && (more != str) &&
         (*ip >= minv) && (*ip <= maxv));
I 18
}

/*
  Authorisierung des Benutzers ueberpruefen.
*/
authorized(msg)
struct svc_req *msg;
{
 struct authunix_parms *au;

 return ((msg->rq_cred.oa_flavor == AUTH_UNIX) &&
         (au = (struct authunix_parms *)msg->rq_clntcred) &&
         (!au->aup_uid || has_privilege(au->aup_uid,"OPER")));
E 18
E 7
}
E 4
E 3
E 1
