h18089
s 00000/00000/00168
d D 5.1 91/08/14 09:06:51 jochen 3 2
c New version to be compatible with versions of queue manager
e
s 00007/00002/00161
d D 4.2 91/06/12 18:17:05 jochen 2 1
c setup of zfast_magic done only once for all channels
e
s 00163/00000/00000
d D 4.1 91/06/12 17:12:02 jochen 1 0
c SCCS version of zfast dyadic converter created
e
u
U
t
T
I 1
/* %W% 91/06/12 ZFAST 1.10 data stream converter for UNIX parallel batch queue manager */

#ifdef SCCSIDS
static char sccsid_zfast_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  CONVERTER: ZFAST to ZFAST

  Struktur: header
  	    items
	    eof

  header: ffffffff:4
  	  08040201:4 (in dedicated byte order)
	  hostid:4
	  len:4 (number of longs following in dedicated byte order)
	  stuff:4*len
  item:   len:4 (number of longs following in dedicated byte order)
  	  stuff:4*len
  eof:    fffffffe:4 (in dedicated byte order)
  	  
*/
#define ZFBUFSIZE	4096
#define ZFPADBYTE	'\0'
#define ZFSIGBOF	0xffffffff
#define ZFMAGIC		0x08040201
#define ZFSIGEOF	0xfffffffe

static long zfast_hlen,zfast_bof = ZFSIGBOF,zfast_eof = ZFSIGEOF;
static char zfast_magic[4],*zfast_header = 0;
I 2
static int zfast_first = 1;
E 2

#define USERDATA	long xlen,dlen,magic,host; char mtemp[4]; mark_t loop;
#define BUFFERSIZE	100000

#define PAD(b,l,d)	zfast_pad(b,l,d)

#include <saphir/converter/definitions.h>

ROUTINE()
     OPEN()
D 2
       /* Konvertierpattern aufsetzen */
       zfast_setup(ZFMAGIC);
E 2
I 2
       /* Konvertierpattern einmal aufsetzen */
       if ( zfast_first )
	{
	 zfast_first = 0;
	 zfast_setup(ZFMAGIC);
	}
E 2
     ACTION()
       /* Schleife */
       MARK(&USER.loop);
	 /* Laenge oder Kennung einlesen */
	 READ(&USER.dlen,4);
	 USER.xlen = USER.dlen;
	 zfast_convert(&USER.xlen);
	 /* Header einlesen */
	 IF ( !zfast_header || (USER.xlen == ZFSIGBOF) )
	   /* Headerkennung verifizieren */
	   if ( USER.xlen != ZFSIGBOF )
	    {
	     printf("\nGot 0%08XH, need ZFSIGBOF(0%08XH)\n",USER.xlen,ZFSIGBOF);
	     return CONVERTER_CORRUPTED;
	    }
	   /* Neue Kontrollwort fuer INTEGER*4 einlesen */
	   memmove(USER.mtemp,zfast_magic,4);
	   READ(&USER.magic,4);
	   if ( !zfast_setup(USER.magic) ) 
	    {
	     printf("\nGot 0%08XH, need permutation of ZFMAGIC(0%08XH)\n",USER.magic,ZFMAGIC);
	     return CONVERTER_CORRUPTED;
	    }
	   if ( zfast_header && memcmp(zfast_magic,USER.mtemp,4) )
	    {
	     printf("\nMuliple file format mixing not allowed\n");
	     return CONVERTER_CORRUPTED;
	    }
	   /* CPU Kennung */
	   READ(&USER.host,4);
	   /* Headerlaenge */
	   READ(&USER.xlen,4);
	   zfast_hlen = USER.xlen;
	   zfast_convert(&zfast_hlen);
	   zfast_hlen = (4+zfast_hlen)*4;
	   if ( zfast_hlen < 16 ) return CONVERTER_CORRUPTED;
	   /* Speicher allokatieren */
	   if ( zfast_header ) free(zfast_header);
	   if ( !(zfast_header = MALLOC(char,zfast_hlen)) ) NOMEM();
	   /* Eintragen */
	   memmove(zfast_header+ 0,&zfast_bof,4);
	   memmove(zfast_header+ 4,&USER.magic,4);
	   memmove(zfast_header+ 8,&USER.host,4);
	   memmove(zfast_header+12,&USER.xlen,4);
	   /* Auslesen */
	   READ(zfast_header+16,zfast_hlen-16);
           /* Naechstes Event */
     	   RESET(&USER.loop);
	 ENDIF
       /* Dateiende */
       if ( USER.xlen == ZFSIGEOF ) return CONVERTER_DONE;
       /* Header uebertragen, wenn noetig */
       ATTACH();
       IF ( !OUTPUT(events) )
         WRITE(zfast_header,zfast_hlen);
       ENDIF
       /* Datenblock */
       USER.xlen *= 4;
       if ( USER.xlen < 0 ) return CONVERTER_CORRUPTED;
       WRITE(&USER.dlen,4);
       COPY(USER.xlen);
       /* Fertig */
       NEXTEVENT();
ENDROUTINE()

/*
  Umwandlungsroutine fuer INTEGER*4 Werte.
*/
static zfast_setup(magic)
long magic;
{
 int ix,iy;
 char find;

 /* Zuordnungstabelle aufsetzen */
 for ( find = 1, ix = 4 ; ix-- ; find += find )
  {
   /* Kennung suchen */
   for ( iy = 4 ; iy-- && (((char *)&magic)[iy] != find) ; );
   if ( iy == -1 ) return 0;
   /* Merken */
   zfast_magic[ix] = iy;
  }
 /* Hat funktioniert */
 return 1;
}

static zfast_convert(lp)
long *lp;
{
 long tmp = *lp;
 int i;

 /* Zusammenbauen */
 for ( i = 4 ; i-- ; ((char *)lp)[i] = ((char *)&tmp)[zfast_magic[i]] );
}

/*
  Aktionen beim Schliessen eines Ausgabekanals.
*/
static zfast_pad(buf,size,done)
char *buf;
int size;
double done;
{
 double fmod();
 long res;
 int i;

 /* ZFSIGEOF zusammenbauen */
 for ( i = 4 ; i-- ; ((char *)&res)[zfast_magic[i]] = ((char *)&zfast_eof)[i] );
 /* Groesse ermitteln */
 i = 4+(ZFBUFSIZE-(int)fmod(done+4.0,(double)ZFBUFSIZE));
 if ( i > size ) return -1;
 /* Buffer fuellen */
 memmove(buf,&res,4);
 memset(buf+4,ZFPADBYTE,i-4);
 return i;
}

E 1
