h44400
s 00217/00060/00752
d D 5.1 91/08/14 16:13:19 jochen 6 5
c OUTPUT=, FILENAME= and POSITION= added
e
s 00001/00001/00811
d D 4.5 91/04/16 17:06:07 jochen 5 4
c File counting corrected
e
s 00019/00010/00793
d D 4.4 91/03/15 15:00:20 jochen 4 3
c Usage of multiple tapes corrected
e
s 00009/00004/00794
d D 4.3 91/03/15 13:59:26 jochen 3 2
c Retrycount to operator message added
e
s 00385/00102/00413
d D 4.2 91/03/15 12:34:56 jochen 2 1
c First implementation completed
e
s 00515/00000/00000
d D 4.1 91/03/14 11:18:42 jochen 1 0
c SCCS version created
e
u
U
t
T
I 1
/* %W% 91/03/13 VAX/VMS ANSI tape single ended input converter */

#ifdef SCCSIDS
static char sccsid_tape_in_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  Headerdateien
*/
I 2
#include <pwd.h>
E 2
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <limits.h>
I 2
#include <signal.h>
E 2

#include <sys/ioctl.h>

/*
  Externe Groessen
*/
D 6
extern char *calloc(),*strdup(),*strchr();
E 6
I 6
extern char *calloc(),*strdup(),*strchr(),*strpbrk();
E 6

/*
  Lokale Variablen
*/
D 2
static char *buffer = 0,*tape,volume[8] = "",filename[100] = "",creator[14] = 0;
static int abuf = 0,nbuf = 0,bufs = 0,bufu = 0,tlen,tfd = -1,tapeno = 0,state;
static int tapes = 1,count = INT_MAX,skip = 0,info = 0,dorew = 1,vol = 0;
static int need3,need4,version;
E 2
I 2
D 6
static char *buffer = 0,*tape,volume[8] = "",filename[100] = "",creator[14] = 0,*ops = 0;
E 6
I 6
#define OUTPUT_VARIABLE		(1<<0)
#define OUTPUT_FIXED		(1<<1)
#define OUTPUT_DYNAMIC		(1<<2)
#define DYNAMIC_VARIABLE	(OUTPUT_DYNAMIC|OUTPUT_VARIABLE)
#define DYNAMIC_FIXED		(OUTPUT_DYNAMIC|OUTPUT_FIXED)

#define MODE_DYNAMIC		0
#define MODE_FILES		1
#define MODE_FILENAME		2
#define MODE_POSITION		3

static char *modenames[] = { "", "FILES", "FILENAME", "POSITION" };

static char *buffer = 0,*tape,volume[8] = "",filename[100] = "",creator[14] = 0,*ops = 0,**files;
static int nops = 0,aops = 0,useops = 0,mails = 3,nfiles = 0,afiles = 0,filemode = MODE_DYNAMIC;
static int tapes = 1,count = INT_MAX,skip = 0,dorew = 1,norew = 0,rcnt,ecnt = 0;
E 6
static int abuf = 0,nbuf = 0,bufs = 0,bufu = 0,tlen,tfd = -1,tapeno = 0,filen = 0,state;
static int need3,need4,version,fixed,bsize,rsize,offset,swap = 0,ofd = -1,retry = 5;
D 6
static int tapes = 1,count = INT_MAX,skip = 0,dorew = 1,norew = 0,rcnt,ecnt = 0;
E 6
static double nevents,nbytes,tevents = 0.0,tbytes = 0.0;
D 3
static int nops = 0,aops = 0,useops = 0;
E 3
I 3
D 6
static int nops = 0,aops = 0,useops = 0,mails = 3;
E 6
I 6
static int output = OUTPUT_DYNAMIC,skipon;
E 6
E 3
static char hname[256];
E 2
static time_t created;

static char labels[][4] =
       {
	"VOL1", "VOL2",
	"HDR1", "HDR2", "HDR3", "HDR4", 
	"EOF1", "EOV1", "EOF2", "EOV2", "EOF3", "EOV3", "EOF4", "EOV4",
       };

#define VOL1			0
#define VOL2			1
#define HDR1			2
#define HDR2			3
#define HDR3			4
#define HDR4			5
#define EOF1			6
#define EOV1		        7
#define EOF2			8
#define EOV2			9
#define EOF3			10
#define EOV3			11
#define EOF4			12
#define EOV4			13
#define DATA			14
#define EOFA			15
#define EOFB			16
#define EOFC			17

static char *checkmem();

/*
  Macros
*/
#define MALLOC(t,n)		((t *)checkmem(calloc(n,sizeof(t))))
#define SALLOC(t)		MALLOC(t,1)
D 2
#define MEMMOVE(d,s,n)		memmove((char *)(d),(char *)(s),(n)*sizeof(*d))
E 2
I 2
#define MEMMOVE(d,s,n)		memmove((char *)(d),(char *)(s),(n)*sizeof(*(d)))
E 2

D 2
#define PERROR(m)		{ fprintf(stderr,"#%d=",errno); perror(m); exit(errno); }
E 2
I 2
#define PERROR(m)		{ perror(m); exit(errno); }
E 2
D 6
#define FERROR(m,e)		{ fprintf(stderr,"%s\n",m); exit(e); }
E 6
I 6
#define FERROR(m,e)		{ puts(m); exit(e); }
E 6

#define STRDUP(s)		((char *)checkmem(strdup(s)))

I 2
#define MAILER			"/bin/mailx -s TAPE_IN"


E 2
/*
  Aufruf:

  TAPE_IN tapefile {parameter}
D 6
		   FILES=n			FILES=INT_MAX
I 3
		   MAILS=n			MAILS=3
E 6
I 6
  		   FILENAME=filename
		   FILES=n				FILES=INT_MAX
		   HELP
		   MAILS=n				MAILS=3
E 6
E 3
D 2
		   INFORMATIONS
		   MULTIVOLUME
E 2
		   NOREWIND			
D 2
		   OPERATOR=name[@host]		OPERATOR=logname
E 2
I 2
		   OPERATOR[=name[@host]]
D 3
		   RETRY=n			RETYR=5
E 3
I 3
D 6
		   RETRY=n			RETRY=5
E 3
E 2
  		   SKIP=n			SKIP=0
E 6
I 6
		   OUTPUT=VARIABLE|FIXED|DYNAMIC	OUTPUT=DYNAMIC
		   POSITION=filename
		   RETRY=n				RETRY=5
  		   SKIP=n				SKIP=0
E 6
I 2
		   SWAP
E 2
D 6
		   TAPES=n		        TAPES=1
E 6
I 6
		   TAPES=n		        	TAPES=1
E 6
*/
main(argc,argv)
int argc;
char **argv;
{
 static int exitter();
I 2
 struct passwd *me;
 char oname[256];
I 6
 int n;
E 6
E 2

I 6
 /* Ungebufferte Ausgabe */
 setbuf(stdout,(char *)0);
E 6
 /* Dateiname ermitteln */
 if ( argc < 2 ) FERROR("No name of tape given",EINVAL);
D 2
 if ( (tlen = strlen(*++argv)) < 2 ) FERROR("Invalid empty file name",EINVAL);
E 2
I 2
 if ( !(tlen = strlen(*++argv)) ) FERROR("Invalid empty file name",EINVAL);
E 2
 /* Vollen Namen ermitteln */
 tape = MALLOC(char,tlen+2);
 strcpy(tape,*argv);
 tape[tlen+1] = '\0';
I 2
 /* Operatornachricht vorbereiten */
 addop(MAILER,0);
E 2
 /* Parameter einlesen */
 while ( *++argv )
D 6
  if ( !memcmp(*argv,"FILES=",6) )
   count = number((*argv)+6,1,1);
E 6
I 6
  if ( !memcmp(*argv,"FILENAME=",9) )
   {
    checkmode(MODE_FILENAME);
    addfile((*argv)+9);
   }
  else if ( !memcmp(*argv,"FILES=",6) )
   {
    checkmode(MODE_FILES);
    count = number((*argv)+6,1,1);
   }
  else if ( !strcmp(*argv,"HELP") )
   {
    puts("Parameters for tape_in:");
    puts("\tFILENAME=filename");
    puts("\tFILES=n (default: INT_MAX)");
    puts("\tHELP");
    puts("\tMAILS=n (default: 3)");
    puts("\tNOREWIND");
    puts("\tOPERATOR[=name[@host]]");
    puts("\tOUTPUT=(VARIABLE|FIXED|DYNAMIC) (default: DYNAMIC)");
    puts("\tPOSITION=filename");
    puts("\tRETRY=n (default: 5)");
    puts("\tSKIP=n (default: 0)");
    puts("\tSWAP");
    puts("\tTAPES=n (default: 1)");
    exit(0);
   }
E 6
I 3
  else if ( !memcmp(*argv,"MAILS=",6) )
   mails = number((*argv)+6,0,1);
E 3
D 2
  else if ( !strcmp(*argv,"INFORMATIONS") )
   info = 1;
  else if ( !strcmp(*argv,"MULTIVOLUME") )
   vol = 1;
E 2
  else if ( !strcmp(*argv,"NOREWIND") )
   dorew = 0;
I 6
  else if ( !strcmp(*argv,"OUTPUT=VARIABLE") )
   output = OUTPUT_VARIABLE;
  else if ( !strcmp(*argv,"OUTPUT=FIXED") )
   output = OUTPUT_FIXED;
  else if ( !strcmp(*argv,"OUTPUT=DYNAMIC") )
   output = OUTPUT_DYNAMIC;
E 6
I 2
  else if ( !strcmp(*argv,"OPERATOR") )
   useops = 1;
E 2
  else if ( !memcmp(*argv,"OPERATOR=",9) )
D 2
   continue;
E 2
I 2
   addop((*argv)+9,1);
I 6
  else if ( !memcmp(*argv,"POSITION=",9) )
   {
    checkmode(MODE_POSITION);
    if ( nfiles ) FERROR("Only one POSITION argument allowed",EINVAL);
    addfile((*argv)+9);
   }
E 6
  else if ( !memcmp(*argv,"RETRY=",6) )
   retry = number((*argv)+6,0,1);
E 2
  else if ( !memcmp(*argv,"SKIP=",5) )
D 2
   skip = number((*argv)+5,0,1); 
E 2
I 2
D 6
   skip = number((*argv)+5,0,1);
E 6
I 6
   {
    checkmode(MODE_FILES);
    skip = number((*argv)+5,0,1);
   }
E 6
  else if ( !strcmp(*argv,"SWAP") )
   swap = 1; 
E 2
  else if ( !memcmp(*argv,"TAPES=",6) )
   tapes = number((*argv)+6,1,1);
  else
   {
D 6
    fprintf(stderr,"Invalid option: %s\n",*argv);
E 6
I 6
    printf("Invalid option: %s\n",*argv);
E 6
    exit(EINVAL);
   }
I 2
 /* OPERATOR festsetzen */
 if ( tapes > 1 ) useops = 1;
 if ( nops < sizeof(MAILER) )
  if ( me = getpwuid(getuid()) ) 
   addop(me->pw_name,0);
  else
   addop("root",0);
 else
  useops = 1;
E 2
 /* Parameter anzeigen */
D 2
 if ( info )
  {
   fprintf(stderr,"FILES=%d INFORMATIONS",count);
   if ( vol ) fprintf(stderr," MULTIVOLUME");
   if ( !dorew ) fprintf(stderr," NOREWIND");
   fprintf(stderr," SKIP=%d TAPES=%d\n",skip,tapes);
  }
E 2
I 2
D 3
 fprintf(stderr,"FILES=%d",count);
E 3
I 3
D 6
 fprintf(stderr,"FILES=%d MAILS=%d",count,mails);
E 3
 if ( !dorew ) fprintf(stderr," NOREWIND");
 fprintf(stderr," RETRY=%d SKIP=%d",rcnt = retry,skip);
 if ( swap ) fprintf(stderr," SWAP");
 fprintf(stderr," TAPES=%d\n",tapes);
E 6
I 6
 switch (filemode)
  {
   case MODE_DYNAMIC  : filemode = MODE_FILES;
   case MODE_FILES    : printf("FILES=%d SKIP=%d",count,skip);
     			break;
   case MODE_FILENAME : printf("FILENAME%s=",(nfiles == 1) ? "" : "S");
     			for ( n = 0 ; n < nfiles ; n++ )
			 printf("%s%s",n ? "," : "",files[n]);
     			break;
   case MODE_POSITION : printf("POSITION=%s",files[0]);
     			break;
  }
 printf(" MAILS=%d",mails);
 if ( !dorew ) printf(" NOREWIND");
 printf(" RETRY=%d",rcnt = retry);
 if ( swap ) printf(" SWAP");
 switch (output)
  {
   case OUTPUT_VARIABLE : printf(" OUTPUT=VARIABLE");
     			  break;
   case OUTPUT_FIXED    : printf(" OUTPUT=FIXED");
     			  break;
   case OUTPUT_DYNAMIC  : printf(" OUTPUT=DYNAMIC");
     			  break;
  }
 printf(" TAPES=%d\n",tapes);
E 6
 /* Operatoren anzeigen */
D 6
 if ( useops ) fprintf(stderr,"OPERATOR(S)=<%s>\n",ops+sizeof(MAILER));
E 6
I 6
 if ( useops ) printf("OPERATOR(S)=<%s>\n",ops+sizeof(MAILER));
E 6
 /* Ausgabedatei ermitteln */
 trnlnm_("FOR010",oname,6,sizeof(oname)-1);
 oname[sizeof(oname)-1] = ' ';
 *strchr(oname,' ') = '\0';
 /* Ausgabedatei oeffnen */
 if ( (ofd = creat(oname,0644)) == -1 ) PERROR("Could not open FOR010");
E 2
 /* Zurueckspulen */
 if ( dorew )
  {
D 2
   if ( info ) fprintf(stderr,"Trying to rewind tape\n");
E 2
I 2
D 6
   fprintf(stderr,"Trying to rewind tape\n");
E 6
I 6
   puts("Trying to rewind tape");
E 6
E 2
   if ( (tfd = open(tape,O_RDONLY)) == -1 ) PERROR("Could not open tape");
   close(tfd);
   tfd = -1;
  }
 /* Exithandler installieren */
 atexit(exitter);
 /* Tape oeffnen */
I 2
 gethostname(hname,sizeof(hname));
E 2
 tapeopen(1);
 /* Buffer anlegen */
D 2
 tapebuffer(80);
E 2
I 2
 tapebuffer(80,0);
E 2
 /* Einlesen */
 while ( taperead() );
D 2
 /* Aufrauemen */
 if ( !dorew )
E 2
I 2
 /* Fertig */
 tapedone();
}

/*
  Operator einbauen.
*/
static addop(name,lower)
char *name;
int lower;
{
 int len = strlen(name);
 char *no;

 /* Konsistenztest */
 if ( !len ) FERROR("OPERATOR name must not be empty",EINVAL);
 /* Feld vergroessern */
 if ( (1+nops+len+1) > aops )
E 2
  {
D 2
   close(tfd);
   tfd = -1;
E 2
I 2
   /* Neues Feld bereitstellen */
   no = MALLOC(char,aops = nops+len+1000);
   /* Alte Daten kopieren */
   if ( ops ) 
    {
     strcpy(no,ops);
     free(ops);
    }
   /* Variablen aufsetzen */
   ops = no;
E 2
  }
I 2
 /* Trennzeichen */
 if ( nops ) ops[nops++] = ' ';
 /* Anhaengen */
 strcpy(ops+nops,name);
 nops += len;
 /* In Kleinschreibung umwandeln */
 if ( lower )
  for ( name = ops+nops ; len-- ; )
   if ( (*--name >= 'A') && (*name <= 'Z') )
    *name += 'a'-'A';
}

/*
I 6
  Datei in die Liste eintragen.
*/
static addfile(name)
char *name;
{
 char **new;

 /* Platz schaffen */
 if ( nfiles == afiles )
  {
   /* Speicher reservieren */
   new = MALLOC(char *,afiles+10);
   /* Kopieren */
   if ( afiles )
    {
     MEMMOVE(new,files,afiles);
     free(files);
    }
   /* Aufsetzen */
   afiles += 10;
   files = new;
  }
 /* Eintragen */
 files[nfiles++] = name;
}

/*
  Selektionsmode aendern.
*/
static checkmode(new)
int new;
{
 /* Nachsehen, ob das erlaubt ist */
 if ( filemode == MODE_DYNAMIC )
  filemode = new;
 else if ( filemode != new )
  {
   /* So geht das aber nicht */
   printf("%s can not be used together with %s\n",modenames[new],modenames[filemode]);
   exit(1);
  }
}

/*
E 6
  Fertig.
*/
static tapedone()
{
 /* Tape sauber schliessen */
 norew = !dorew;
E 2
 /* Fertig */
 exit(0);
}

/*
  Speicherallokation verifizieren.
*/
static char *checkmem(all)
char *all;
{
 /* Alles in Ordnung */
 if ( all ) return all;
 /* Fehler melden */
 FERROR("Out of memory",ENOMEM);
}

/*
  Tape zurueckspulen.
*/
static int exitter()
{
 /* Zurueckspulen */
 if ( tfd != -1 )
  {
   /* Schliessen */
   close(tfd);
   /* Zurueckspulen */
D 2
   if ( info ) fprintf(stderr,"Trying to rewind tape\n");
   if ( (tfd = open(tape,O_RDONLY)) != -1 ) close(tfd);
E 2
I 2
   if ( !norew )
    {
D 6
     fprintf(stderr,"Trying to rewind tape\n");
E 6
I 6
     puts("Trying to rewind tape");
E 6
     if ( (tfd = open(tape,O_RDONLY)) != -1 ) close(tfd);
    }
E 2
  }
I 2
 /* Ausgabedatei schliessen */
 if ( ofd != -1 )
  {
   owrite((char *)0,0);
   close(ofd);
  }
 /* Statistik ausgeben */
D 6
 fprintf(stderr,"%.0f Event(s) with %.0f Byte(s) processed\n",tevents,tbytes);
 fprintf(stderr,"%.0f Byte(s) transferred\n",tbytes+8*tevents);
 if ( ecnt ) fprintf(stderr,"%d block read error(s)\n",ecnt);
E 6
I 6
 printf("%.0f Event(s) with %.0f Byte(s) processed\n",tevents,tbytes);
 printf("%.0f Byte(s) transferred\n",tbytes+8*tevents);
 if ( ecnt ) printf("%d block read error(s)\n",ecnt);
E 6
E 2
}

/*
  Tape oeffnen
*/
static tapeopen(newtape)
int newtape;
D 2
{
E 2
I 2
{ 
I 4
 int retr,act = (!newtape || !tapeno || !useops || !mails);
E 4
 FILE *mail;
I 3
D 4
 int retr;
E 4
E 3

 /* Nur eine gewisse Zahl von Tapes bearbeiten */
 if ( newtape && !tapes-- )
  {
D 6
   fprintf(stderr,"All tapes processed\n");
E 6
I 6
   puts("All tapes processed");
E 6
   /* Aufhoeren */
   tapedone();
  }
E 2
 /* Dateiname mit Endung fuer 'no-rewind-on-close' */
D 2
 if ( info ) fprintf(stderr,"Trying to open tape\n");
 if ( tfd != -1 ) close(tfd);
 tape[tlen] = 'n';
 tfd = open(tape,O_RDONLY);
 tape[tlen] = '\0';
 /* Fehler bearbeiten */
 if ( tfd == -1 ) 
E 2
I 2
D 3
 for ( ; ; ) 
E 3
I 3
D 4
 for ( retr = mails ; ; ) 
E 4
I 4
 for ( retr = mails ; ; act = 1 ) 
E 4
E 3
E 2
  {
D 2
   if ( info ) fprintf(stderr,"Open failed\n");
   PERROR("open tape");
E 2
I 2
D 4
   fprintf(stderr,"Trying to open tape\n");
   if ( tfd != -1 ) close(tfd);
   tape[tlen] = 'n';
   tfd = open(tape,O_RDONLY);
   tape[tlen] = '\0';
   /* Fehler bearbeiten */
   if ( tfd != -1 ) break;
   perror("Open failed");
E 4
I 4
   if ( tfd != -1 )
    {
     close(tfd);
     tfd = -1;
    }
   /* Neues Band einlegen */
   if ( act )
    {
D 6
     fprintf(stderr,"Trying to open tape\n");
E 6
I 6
     puts("Trying to open tape");
E 6
     tape[tlen] = 'n';
     tfd = open(tape,O_RDONLY);
     tape[tlen] = '\0';
     /* Fehler bearbeiten */
     if ( tfd != -1 ) break;
     perror("Open failed");
    }
   /* Flags testen */
E 4
   if ( !useops ) exit(errno);
I 3
   if ( !retr-- ) FERROR("Could not open tape, giving up\n",errno);
E 3
   /* Operator benachrichtigen */
D 6
   fprintf(stderr,"Notifying operator(s)\n");
E 6
I 6
   puts("Notifying operator(s)");
E 6
   if ( !(mail = popen(ops,"w")) ) PERROR("Could not notify operator(s)");
   fprintf(mail,"\nPlease insert tape number %d in tapeunit %s\n",tapeno+1,tape);
   fprintf(mail,"\nAnd then wake me (PID=%d@%s) up using SET ENTRY/NOSUSPEND\n\n",
	   	getpid(),hname);
   pclose(mail);  
   /* Schlafen legen */
   kill(getpid(),SIGSTOP);
E 2
  }
 /* Tapenummer zaehlen */
 if ( newtape ) 
  {
   tapeno++;
D 2
   if ( info ) fprintf(stderr,"Processing tape number %d\n",tapeno);
E 2
I 2
D 6
   fprintf(stderr,"Processing tape number %d\n",tapeno);
E 6
I 6
   printf("Processing tape number %d\n",tapeno);
E 6
E 2
   /* Neuer Zustand */
   state = VOL1;
  }
 /* Alles in Ordnung */
 return 1;
}

/*
  Zahl einlesen.
*/
static number(num,min,ex)
char *num;
int min,ex;
{
 char *more;
 int res;

 /* Zahl einlesen */
 errno = 0;
 if ( (((res = strtoul(num,&more,10)) == -1) && errno) || 
      !more || *more || (more == num) || (res < min) )
  {
   if ( !ex ) return (min-1);
D 6
   fprintf(stderr,"Invalid number %s\n",num);
E 6
I 6
   printf("Invalid number %s\n",num);
E 6
   exit(EINVAL);
  }
 /* Ergebnis melden */
 return res;
}

/*
  Zahl dekodieren.
*/
static decode(num,len)
char *num;
int len;
{
 char buf[20];

 /* Terminieren */
 memmove(buf,num,len);
 buf[len] = '\0';
 /* Umrechnen */
 return number(buf,0,0);
}

/*
  Buffer anlegen.
*/
D 2
static tapebuffer(size)
int size;
E 2
I 2
static tapebuffer(size,off)
int size,off;
E 2
{
 /* Buffer vergroessert anlegen */
 if ( size > bufs )
  {
   /* Alten Speicher freigeben */
   if ( bufs ) free(buffer);
   /* Neuen Speicher allokatieren */
   buffer = MALLOC(char,bufs = size);
  }
 /* Benutzbare Groesse nutzen */
 bufu = size;
I 2
 offset = off;
E 2
}

/*
  Naechsten Block einlesen.
*/
static taperead()
{
 char id[80];

 /* Daten einlesen */
D 2
 tread(id,4);
 if ( state != DATA )
E 2
I 2
 if ( ((state != DATA) || (nbuf == abuf)) && tread(id,80) && (state != DATA) )
E 2
  {
D 2
   /* Rest einlesen */
   tread(id+4,76);
   {
    char x[81];
    memmove(x,id,80);
    x[80] = '\0';
    puts(x);
   }
E 2
   /* Behandlung optionaler Labels */
   if ( (state == VOL2) && !label(id,labels[VOL2],0) )
    state = HDR1;
   else if ( (state == HDR3) && !label(id,labels[HDR3],0) )
    state = HDR4;
   else if ( (state == EOF1) && !label(id,labels[EOF1],0) )
    state = EOV1;
   else if ( (state == EOF3) && !label(id,labels[EOF3],0) )
    {
     if ( need3 ) tapeerror("EOF3");
     state = EOF4;
    }
   else if ( (state == EOV3) && !label(id,labels[EOV3],0) )
    {
     if ( need3 ) tapeerror("EOV3");
     state = EOV4;
    }
   /* Das muss es aber jetzt sein */
   label(id,labels[state],1);
   /* Und der naechste Schritt */
   switch (state)
    {
     case VOL1 : processVOL1(id);
       	 	 state = VOL2; 
       		 break;
     case VOL2 : state = HDR1;
       		 break;
     case HDR1 : processHDR1(id);
       		 state = HDR2;
       		 break;
     case HDR2 : processHDR2(id);
		 state = HDR3;
       		 need3 = need4 = 0;
       		 break;
     case HDR3 : state = HDR4;
       		 need3 = 1;
      		 break;
     case HDR4 : processHDR4(id);
       		 state = EOFA;
       		 need4 = 1;
       		 break;
D 2
     case EOF1 : state = EOF2;
E 2
I 2
     case EOF1 : processEOX1(id);
       		 state = EOF2;
E 2
       		 break;
D 2
     case EOV1 : state = EOV2;
E 2
I 2
     case EOV1 : processEOX1(id);
       		 state = EOV2;
E 2
       		 break;
     case EOF2 : state = EOF3;
       		 break;
     case EOV2 : state = EOV3;
       		 break;
     case EOF3 : state = EOF4;
       		 break;
     case EOV3 : state = EOV4;
       		 break;
     case EOF4 : state = EOFB;
       		 break;
     case EOV4 : state = EOFC;
       		 break;
    }
   /* Das ist genug */
   return 1;
  }
D 2
 /* Fertig */
E 2
I 2
 /* Daten bearbeiten */
 return (fixed ? tapefixed() : tapevariable());
}

/*
  Bearbeiten von FIXED SIZED RECORDS.
*/
static tapefixed()
{
 char *scan;
 int n;

 /* Nachsehen, ob noch Platz vorhanden ist */
 if ( (abuf-nbuf) < rsize ) tapeerror("fixed sized record");
 /* Auswerten */
 for ( scan = buffer+nbuf, n = rsize ; n-- ; )
  if ( *scan++ != '^' )
   return tapeevent(buffer+((nbuf += rsize)-rsize),rsize);
 /* Padrecord, naechsten Record lesen */
 nbuf = abuf;
E 2
 return 1;
}

/*
I 2
  Bearbeiten von VARIABLE SIZED RECORD.
*/
static tapevariable()
{
 int len;

 /* Padding beachten */
 if ( buffer[nbuf] == '^' )
  {
   nbuf = abuf;
   return 1;
  }
 /* Einlesen */
 if ( (abuf-nbuf) < 4 ) tapeerror("variable record length");
 if ( (len = decode(buffer+nbuf,4)) < 4 ) tapeerror("valid record length");
 /* Konsistenztest */
 if ( (abuf-nbuf) < len ) tapeerror("variable sized record");
 /* Daten bearbeiten */
 return tapeevent(buffer+(((nbuf += len)-len)+4),len-4);
}

/*
  Event bearbeiten.
*/
static tapeevent(buf,size)
char *buf;
int size;
{
 /* Daten in der Datei zaehlen */
 nevents += 1.0;
 nbytes += size;
 /* Ueberspringen */
D 6
 if ( skip ) return 1;
E 6
I 6
 if ( skipon ) return 1;
E 6
 /* Daten insgesamt zaehlen */
 tevents += 1.0;
 tbytes += size;
 /* Eventuell swappen */
 if ( swap ) swab(buf,size);
 /* Ausgeben */
D 6
 owrite(&size,4);
E 6
I 6
 if ( output&OUTPUT_VARIABLE ) owrite(&size,4);
E 6
 owrite(buf,size);
D 6
 owrite(&size,4);
E 6
I 6
 if ( output&OUTPUT_VARIABLE ) owrite(&size,4);
E 6
 /* Erfolg melden */
 return 1;
}

/*
E 2
  Daten aus dem Buffer kopieren, eventuell Buffer neu fuellen.
*/
static tread(buf,size)
char *buf;
int size;
{
D 2
 int tsize;

 while ( size > 0 )
E 2
I 2
 /* Platz bereitstellen */
 while ( nbuf == abuf )
E 2
  {
D 2
   /* Platz bereitstellen */
   while ( !(tsize = abuf-nbuf) )
E 2
I 2
   /* Neuen Block einlesen */
   switch (abuf = read(tfd,buffer,bufu))
E 2
    {
D 2
     /* Neuen Block einlesen */
     switch (abuf = read(tfd,buffer,bufu))
      {
       case -1 : PERROR("Tape read error");
       case  0 : tapeeof();
       default : /* Besondere Zustaende verlangen ein Dateiende */
	 	 if ( (state >= EOFA) && (state <= EOFC) )
		  {
		   fprintf(stderr,"Tape corrupted, tape mark missing\n");
		   exit(EIO);
		  }
	 	 nbuf = 0;
      }
E 2
I 2
     case -1 : /* Fehler bearbeiten */
	       perror("Tape read error");
	       if ( (errno != EIO) || (state != DATA) ) exit(errno);
	       /* Mehrmals versuchen */
	       ecnt++;
	       if ( rcnt-- )
		{
		 /* Einfach noch einmal probieren */
		 nbuf = abuf = 0;
		 continue;
		}
	       /* Naechste Datei bearbeiten, falls moeglich */
D 6
	       fprintf(stderr,"Too many errors in this file, trying next one\n");
E 6
I 6
	       puts("Too many errors in this file, trying next one");
E 6
     case  0 : tapeeof();
     default : /* Besondere Zustaende verlangen ein Dateiende */
 	       if ( (state >= EOFA) && (state <= EOFC) )
	        {
D 6
	         fprintf(stderr,"Tape corrupted, tape mark missing\n");
E 6
I 6
	         puts("Tape corrupted, tape mark missing");
E 6
	         exit(EIO);
	        }
	       /* Offset setzen */
	       if ( (nbuf = offset) > abuf )
	        {
D 6
	         fprintf(stderr,"Tape corrupted, offset smaller than blocksize\n");
E 6
I 6
	         puts("Tape corrupted, offset smaller than blocksize");
E 6
	         exit(EIO);
	        }
	       /* Fehlerzaehler setzen */
	       rcnt = retry;
E 2
    }
D 2
   /* Daten kopieren */
   if ( tsize > size ) tsize = size;
   memmove(buf,buffer+nbuf,tsize);
   /* Werte aktualisieren */
   nbuf += tsize;
   buf += tsize;
   size -= tsize;
E 2
  }
I 2
 /* Sonderbehandlung fuer DATA */
 if ( state == DATA ) return 1;
 /* Sonderbehandlung fuer Labels */
 if ( nbuf || (abuf != size) ) tapeerror("valid label");
 /* Labeldaten kopieren */
 memmove(buf,buffer,size);
 /* Wert aktualisieren */
 nbuf = abuf;
E 2
 /* Alles in Ordnung */
 return 1;
}

/*
  Ende einer Datei erreicht.
*/
static tapeeof()
{
I 2
D 6
 int newtape = 0,res = -1;
E 6
I 6
 static char fullname[256];
 int newtape = 0,res = -1,n;
E 6
 struct mtop skipper;

E 2
 /* Zulaessige Situationen */
 switch (state)
  {
   case VOL1 : tapeerror("VOL1");
D 2
   case VOL2 : tapeerror("VOL2");
   case HDR1 : tapeerror("HDR1");
E 2
I 2
   case VOL2 :
   case HDR1 : newtape = 1;
     	       break;
E 2
   case HDR2 : tapeerror("HDR2");
   case HDR3 : 
D 2
   case HDR4 : if ( info )
     		{
		 fprintf(stderr,"\t\tFILE %s;%d\n",filename,version);
		 fprintf(stderr,"\t\tCREATOR %s\n",creator);
		 fprintf(stderr,"\t\tCREATED %s",ctime(&created));
		}
   case EOFA : state = DATA;
     	       break;
   case DATA : tapebuffer(80);
E 2
I 2
   case HDR4 : 
D 6
   case EOFA : filen++;
	       fprintf(stderr,"\tFILE %s;%d\n",filename,version);
	       fprintf(stderr,"\tCREATOR %s\n",creator);
	       fprintf(stderr,"\tCREATED %s",ctime(&created));
	       if ( skip )
E 6
I 6
   case EOFA : sprintf(fullname,"%s;%d",filename,version);
     	       filen++;
	       printf("\tFILE %s\n",fullname);
	       printf("\tCREATOR %s\n",creator);
	       printf("\tCREATED %s",ctime(&created));
	       if ( skipon = (skip || !match(fullname)) )
E 6
	        {
D 6
		 fprintf(stderr,"Skipping file number %d\n",filen);
E 6
I 6
		 printf("Skipping file number %d\n",filen);
E 6
		 skipper.mt_op = MTFSF;
		 skipper.mt_count = 1;
		 if ( (res = ioctl(tfd,MTIOCTOP,&skipper)) == -1 ) perror("Skipping file");
	        }
I 6
	       else if ( filemode == MODE_POSITION )
	        {
		 printf("Positioned before data of file number %d\n",filen);
		 /* Tape hier stehenlassen */
		 dorew = 0;
		 tapedone();
	        }
E 6
	       else
D 6
	        fprintf(stderr,"Processing file number %d\n",filen);
E 6
I 6
	        printf("Processing file number %d\n",filen);
E 6
	       tapebuffer(bsize,offset);
     	       nevents = nbytes = 0.0;
	       state = DATA;
     	       if ( res == -1 ) break;
     	       /* Datenteil wurde uebersprungen */
   case DATA : tapebuffer(80,0);
E 2
     	       state = EOF1;
     	       break;
   case EOF1 : tapeerror("EOF1 or EOV1");
   case EOF2 : tapeerror("EOF2");
D 2
   case EOV2 : tapeerror("EOV2");
E 2
   case EOF3 : if ( need3 ) tapeerror("EOF3");
D 2
   case EOV3 : if ( need3 ) tapeerror("EOV3");
E 2
   case EOF4 : if ( need4 ) tapeerror("EOF4");
D 2
   case EOFB : state = HDR1;
E 2
I 2
   case EOFB : tapefile();
     	       state = HDR1;
E 2
     	       break;
I 2
   case EOV2 : tapeerror("EOV2");
   case EOV3 : if ( need3 ) tapeerror("EOV3");
E 2
   case EOV4 : if ( need4 ) tapeerror("EOV4");
D 2
   case EOFC : state = VOL1;
E 2
I 2
   case EOFC : tapefile();
     	       newtape = 1;
E 2
	       break;
  }
 /* Tape neu oeffnen */
D 2
 tapeopen(0);
E 2
I 2
 tapeopen(newtape);
E 2
}

/*
I 6
  Nachsehen, ob der Dateiname in der Liste der zu bearbeitenden ist.
*/
static match(name)
char *name;
{
 int n;

 /* Nur bei FILENAME= und POSITION= von Bedeutung */
 if ( filemode == MODE_FILES ) return 1;
 /* Vergleichen */
 for ( n = nfiles ; n-- && !match_wildcard(name,files[n]) ; );
 /* Ergebnis melden */
 return (n >= 0);
}

/*
E 6
I 2
  Datei am Ende angekommen.
*/
static tapefile()
{
 /* Informationen ausgeben */
D 6
 fprintf(stderr,"\t%.0f Event(s) with %.0f Byte(s) ",nevents,nbytes);
 if ( !skip ) 
  fprintf(stderr,"processed\n\t%.0f Byte(s) transferred\n",nbytes+8*nevents);
E 6
I 6
 printf("\t%.0f Event(s) with %.0f Byte(s) ",nevents,nbytes);
 if ( !skipon ) 
  printf("processed\n\t%.0f Byte(s) transferred\n",nbytes+8*nevents);
E 6
 else
D 6
  fprintf(stderr,"skipped\n");
E 6
I 6
  puts("skipped");
E 6
 /* Zaehler aktualisieren */
 if ( skip )
  skip--;
D 5
 else if ( !count-- )
E 5
I 5
D 6
 else if ( !--count )
E 6
I 6
 else if ( !skipon && !--count )
E 6
E 5
  {
D 6
   fprintf(stderr,"All files processed\n");
E 6
I 6
   puts("All files processed");
E 6
   tapedone();
  }
}

/*
E 2
  Tape nicht in Ordnung
*/
static tapeerror(what)
char *what;
{
D 6
 fprintf(stderr,"Tape corrupted, %s missing\n",what);
E 6
I 6
 printf("Tape corrupted, %s missing\n",what);
E 6
 exit(EIO);
}

/*
  Label erwartet
*/
static label(id,what,err)
char *id,*what;
int err;
{  
 char buf[5];
 int res;

 /* Als C-String */
 memmove(buf,what,4);
 buf[4] = '\0';
 /* Vergleichen */
 if ( !(res = !memcmp(id,what,4)) && err ) tapeerror(buf);
D 2
 if ( res && info ) fprintf(stderr,"\tLABEL %s\n",buf);
E 2
I 2
D 6
 if ( res && err ) fprintf(stderr,"\tLABEL %s\n",buf);
E 6
I 6
 if ( res && err ) printf("\tLABEL %s\n",buf);
E 6
E 2
 /* Ergebnis melden */
 return res;
}

/*
  Labels bearbeiten
*/
static processVOL1(vol1)
char *vol1;
{
 /* Volumename */
 memmove(volume,vol1+4,6);
D 2
 volume[6] = '\0';
 if ( info ) fprintf(stderr,"\t\tVOLUME %s\n",volume);
E 2
I 2
 volume[6] = ' ';
 *strchr(volume,' ') = '\0';
D 6
 fprintf(stderr,"\t\tVOLUME %s\n",volume);
E 6
I 6
 printf("\t\tVOLUME %s\n",volume);
E 6
E 2
}

static processHDR1(hdr1)
char *hdr1;
{
 struct tm tcreated;
 int v1,v2;

 /* Erster Teil des Dateinamens */
 memmove(filename,hdr1+4,17);
 filename[17] = ' ';
 *strchr(filename,' ') = '\0';
 /* Versionsnummer */
D 2
 if ( ((v1 = decode(hdr1+35,4)) < 0) || ((v2 = decode(hdr1+39,2)) < 0) )
E 2
I 2
 if ( ((v1 = decode(hdr1+35,4)) <= 0) || ((v2 = decode(hdr1+39,2)) < 0) )
E 2
  tapeerror("file version number");
 version = ((v1-1)*100+v2)+1;
 /* Erzeugungszeitpunkt */
 if ( ((v1 = decode(hdr1+42,2)) < 0) || ((v2 = decode(hdr1+44,3)) < 0) )
  tapeerror("file creation date");
 tcreated.tm_sec = tcreated.tm_min = tcreated.tm_hour = tcreated.tm_yday = 0;
 tcreated.tm_mon = tcreated.tm_wday = tcreated.tm_isdst = 0;
 tcreated.tm_year = v1;
 tcreated.tm_mday = v2;
 if ( (created = mktime(&tcreated)) <= 0) tapeerror("legal file creation date");
 /* Erzeuger */
 memmove(creator,hdr1+60,13);
 creator[13] = ' ';
 *strchr(creator,' ') = '\0';
}

static processHDR2(hdr2)
char *hdr2;
{
I 2
 /* Format */
 if ( hdr2[4] == 'D' )
D 6
  fixed = 0;
E 6
I 6
  {
   fixed = 0;
   if ( output&OUTPUT_DYNAMIC ) output = DYNAMIC_VARIABLE;
  }
E 6
 else if ( hdr2[4] == 'F' )
D 6
  fixed = 1;
E 6
I 6
  {
   fixed = 1;
   if ( output&OUTPUT_DYNAMIC ) output = DYNAMIC_FIXED;
  }
E 6
 else
  tapeerror("file format");
D 6
 fprintf(stderr,"\t\tFORMAT %s\n",fixed ? "FIXED" : "VARIABLE");
E 6
I 6
 printf("\t\tFORMAT %s\n",fixed ? "FIXED" : "VARIABLE");
E 6
 /* Blocksize */
 if ( (bsize = decode(hdr2+5,5)) <= 0 ) tapeerror("blocksize");
D 6
 fprintf(stderr,"\t\tBLOCKSIZE %d\n",bsize);
E 6
I 6
 printf("\t\tBLOCKSIZE %d\n",bsize);
E 6
 /* Recordsize */
 if ( (rsize = decode(hdr2+10,5)) <= 0 ) tapeerror("maximum record size");
D 6
 fprintf(stderr,"\t\tMAXIMUM RECORDSIZE %d\n",rsize);
E 6
I 6
 printf("\t\tMAXIMUM RECORDSIZE %d\n",rsize);
E 6
 /* Offset */
 if ( (offset = decode(hdr2+50,2)) < 0 ) tapeerror("offset");
D 6
 fprintf(stderr,"\t\tOFFSET %d\n",offset);
E 6
I 6
 printf("\t\tOFFSET %d\n",offset);
E 6
E 2
}

static processHDR4(hdr4)
char *hdr4;
{
 int len = strlen(filename);

 /* Zweiter Teil des Dateinamens */
 memmove(filename+len,hdr4+4,76);
 filename[len+76] = ' ';
 *strchr(filename,' ') = '\0'; 
I 2
}

static processEOX1(eox1)
char *eox1;
{
 int blocks;

 /* Zahl der Bloecke */
 if ( (blocks = decode(eox1+54,6)) < 0 ) tapeerror("block count");
D 6
 fprintf(stderr,"\t\tBLOCKCOUNT %d\n",blocks);
E 6
I 6
 printf("\t\tBLOCKCOUNT %d\n",blocks);
E 6
}

/*
  Daten in den Ausgabekanal schreiben und Green Hills FORTRAN 77 Datenstrom
  fuer unformatierte Dateien erzeugen.
*/
static owrite(new,len)
char *new;
int len;
{
 static char buf[40000];
 static int nbuf = 0;
 int tsize;

 /* Buffer entleeren */
 if ( !new )
  {
   if ( nbuf && (write(ofd,buf,nbuf) != nbuf) ) perror("Could not write to output file");
   return;
  }
 /* Daten in den Buffer kopieren */
 while ( len > 0 )
  {  
   /* Minimum ermitteln */
   if ( (tsize = (sizeof(buf)-nbuf)) > len ) tsize = len;
   /* Daten kopieren */
   memmove(buf+nbuf,new,tsize);
   /* Buffer schreiben */
   if ( (nbuf += tsize) == sizeof(buf) )
    {
     nbuf = 0;
     if ( write(ofd,buf,sizeof(buf)) != sizeof(buf) ) PERROR("Could not write to output file");
    }
   /* Werte aktualisieren */
   new += tsize;
   len -= tsize;
  }
E 2
}
E 1
