h34151
s 00000/00000/01322
d D 5.1 91/08/14 09:06:45 jochen 7 6
c New version to be compatible with versions of queue manager
e
s 00014/00008/01308
d D 4.5 91/03/29 10:46:53 jochen 6 5
c Handling of too large events corrected
e
s 00050/00056/01266
d D 4.4 91/03/29 09:46:51 jochen 5 4
c Second exchange used for Eventbuilder replies
e
s 00097/00094/01225
d D 4.3 91/03/28 18:08:03 jochen 4 3
c Second exchange for control purpose created
e
s 00004/00002/01315
d D 4.2 91/03/28 17:04:49 jochen 3 2
c SAMPLE ALL handling and pointer error corrected
e
s 01245/00001/00072
d D 4.1 91/03/28 16:11:04 jochen 2 1
c Implementation completed
e
s 00073/00000/00000
d D 1.1 91/03/25 14:01:35 jochen 1 0
c SCCS managed version created
e
u
U
t
T
I 2
/* %W% 91/03/25 SOS MHS event single ended input converter */

#ifdef SCCSIDS
static char sccsid_sos_in_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

E 2
I 1
#include <errno.h>
I 2
#include <fcntl.h>
E 2
#include <stdio.h>
I 2
#include <limits.h>
#include <unistd.h>
E 2

I 2
#include <sys/uio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/signal.h>

E 2
#include <saphir/vaxmhs_data.h>

/*
I 2
  Verwaltungsstruktur.
*/
typedef struct client
	{
	 struct client	*next;		/* Verkettung				*/
	 int		fd;		/* UNIX Datenkanal 			*/
	 int		unit;		/* Unitnummer				*/
	 int		samp;		/* SAMPLEALL statt SIMPLE		*/
	 int		mask;		/* Triggermaske				*/
	 int		value;		/* Triggerwert				*/
	 int		emask;		/* Fehlermaske				*/
	 int		qmask;		/* Equipmentmaske			*/
	 int		usize;		/* Eventgroesse				*/
	 int		size;		/* Buffergroesse			*/
	 int		wbuf;		/* Bytes im Buffer			*/
	 int		rbuf;		/* Bereits geschriebene Bytes		*/
	 char		*buf;		/* Buffer fuer ein Event		*/
	 int		book;		/* SAMPLE ALL Wert des EVENTBUILDERs	*/
	 double		lost;		/* Verlorene Events			*/
	 double		events;		/* Eventzaehler				*/
	 double		bytes;		/* Datenzaehler				*/
	 int		active;		/* Soll bearbeitet werden 		*/
	 int		blocking;	/* Angehalten wegen diesem Kanal	*/
	} USER;

struct einfo
       {
	MAILBOX		*box;		/* Adresse der Mail			*/
	int		off;		/* Offset in MBLEN			*/
	int		len;		/* Groesse in Bytes			*/
       };

/*
  Globale Variablen.
*/
static int Xstatus = 0,Xtout = 0,Xready = 0,Xmissed = 0,Xelen = 0,Xnoready = 0,Xnosend = 0;
static int Xnostop = 0,Xequi = 0,Xstopped = 0,Xsaphir = 0,Xlen = 0,Xtot = 0;
static int Xstop = 0,Xnouse = 0;
static double Xevents = 0.0;

D 4
static int breset = -1,bnumber = -1,evdef[4] = { 0, 0, 0, 0 },booked = 0,evb[4];
E 4
I 4
static int breset = -1,bnumber = -1,evdef[4] = { -1, 0, 0, 0 },booked = 0,evb[4];
E 4
static int logname[4] = { -1, 0, 0, 0},search = 0,stopped = 0,WaitFor;
static short WaitNum;
static USER *chans;

/*
  Globale Routinen.
*/
static exitter();

/*
  Externe Routinen.
*/
char *calloc(),*strchr(),*translate_vms();

/*
  MACROs.
*/
#define NOSTR			((char *)0)

#define MALLOC(t,n)		((t *)calloc(n,sizeof(t)))
#define EVBsend(c)		EVB(c,(int *)0,NOSTR)

/*
  Dieses Programm hat die Aufgabe, SAPHIR Events zu empfangen und zu verteilen.
  Es hat zwei Arten von Parametern:
  a) BRIDGE=n oder NOBRIDGE
     Nummer der zu oeffnenden SOS Bridge
  b) unit:mode:mask:value:errors:equipments:size:events
     Beschreibt einen ueber FOR<unit> zu oeffnenden Ausgabekanal fuer Events,
     die Parameter sind wie bei EVENT$ALLOCATE bzw. EVENT$READ zu verstehen:
     1. mode = SIMPLE|SAMPLEALL
     2. mask = Triggermaske als Zahl oder Triggerliste
     3. value = Triggerwert als Zahl oder Triggerliste
     4. errors = Fehlermaske als Zahl oder Fehlerliste
     5. equipments = Equipmentmaske als Zahl oder Equipmentliste
     6. size = Maximale Eventgroesse in Worten
     7. events = Events im Buffer
  Die Ausgabe erfolgt im Rahmen eines Paralleljobs als FORTRAN Records. Der
  Konverter definiert einen logischen SOS-Namen, unter dem der die folgenden 
  Befehle entgegennimmt:
  a) SOS_IN$EXIT(MBCODE=0)
     Konverter sauber beenden
  b) SOS_IN$SUSPEND(MBCODE=1)
     Alle SAMPLEALL-Buchungen loeschen und keine Events mehr entgegennehmen
  c) SOS_IN$RESUME(MBCODE=2)
     SAMPLEALL-Buchungen wieder vornehmen und Events empfangen und verteilen
*/
main(argc,argv)
int argc;
char **argv;
{ 
D 4
 int lad = 2,max,leave,null = 0,opt,tlen,blk,now;
E 4
I 4
 int lad = 2,max,leave,null = 0,opt,tlen,blk,now,name[2],mb,efd,lfd,nblk = 0,nowait = 1;
E 4
 struct timeval restart = { 1, 0 },*tout;
 fd_set reader,writer;
I 4
 short code;
E 4
 USER *cur;

 /* Parameter auswerten */
 if ( argc < 2 )
  {
   fprintf(stderr,"USAGE: %s dummy_file_name {parameter}\n",*argv);
   exit(EINVAL);
  }
 for ( argv++ ; *++argv ; )
  if ( !strcmp(*argv,"NOBRIDGE") )
   bnumber = 0;
  else if ( !memcmp(*argv,"BRIDGE=",7) )
   {
    if ( number((*argv)+7,10,&bnumber) || (bnumber < 3) || (bnumber > 15) )
     {
      fprintf(stderr,"BRIDGE number must be between 3 and 15\n");
      exit(EINVAL);
     }
   }
  else 
   adduser(*argv);

 /* Standardkanal oeffnen */
 if ( !chans ) adduser("10:SIMPLE:0x0:0x0:0xffffffff:0xffff:5000:10");

 /* Standardbridge auswaehlen */
 if ( bnumber == -1 ) bnumber = 7;

 /* UNIXMHS initialisieren */
 VMEINI();

 /* EVENTBUILDER suchen */
 VMEGET(evb,"EVENTBUILDER",&null,&opt,&errno);
 if ( errno ) MHSerror("searching EVENTBUILDER");

 /* Exithandler installieren */
 atexit(exitter);

 /* Bridge oeffnen */
 if ( (breset = bridge(bnumber,1)) == -1 ) MHSerror("opening bridge");
 if ( !breset ) fprintf(stderr,"Bridge has been opened\n");
 
I 4
 /* Eindeutigen logischen Namen berechnen */
 name[0] = gethostid();
 name[1] = getpid();

 /* Logischen Namen definieren */
 VMEDEF(logname,name,&null,&errno);
 if ( errno ) MHSerror("defining logical name");

E 4
 /* Eventempfang vorbereiten */
 VMEDEF(evdef,"EVENT   ",&lad,&errno);
 if ( errno ) MHSerror("defining logical address EVENT");

D 4
 /* Logischen Namen definieren */
 define(*evdef);
E 4
I 4
 /* Kanalnummern auslesen */
 lfd = vaxmhs_data.xids[*logname];
 efd = vaxmhs_data.xids[*evdef];
E 4

 /* Alle SAMPLEALL-Buchungen durchfuehren */
 bookall(1);

 /* Uhrzeit ausgeben */
 time(&now);
 fprintf(stderr,"Converter startet at %s",ctime(&now));

 /* Alle Kanaele ueberwachen */
 for ( ; ; )
  {
   /* EVENTBUILDER suchen */
   if ( search )
    {
     /* Logischen Namen suchen */
     VMEGET(evb,"EVENTBUILDER",&null,&opt,&errno);
     if ( errno ) MHSerror("searching EVENTBUILDER");
     /* SAMPLE ALL Buchungen vergessen */
     for ( cur = chans ; cur ; cur = cur->next ) cur->book = -1;
     /* Eventuell neue Buchungen vornehmen */
     if ( booked ) bookall(1);
     /* Einmal reicht eigentlich */
     search = 0;
    }

D 4
   /* Zu kontrollierende Kanaele ermitteln */
E 4
I 4
   /* Zu kontrollierende Lesekanaele ermitteln */
E 4
   FD_ZERO(&reader);
D 4
   FD_SET(max = vaxmhs_data.xids[*evdef],&reader);
E 4
I 4
D 5
   FD_SET(efd,&reader);
E 5
I 5
   if ( booked ) FD_SET(efd,&reader);
E 5
   FD_SET(lfd,&reader);
   if ( (max = efd) < lfd ) max = lfd;

   /* Zu kontrollierende Schreibkanaele ermitteln */
E 4
   FD_ZERO(&writer);
   for ( blk = 0, leave = 1, cur = chans ; cur ; cur = cur->next )
    if ( cur->fd != -1 )
     {
      /* Eintrag vermerken */
      leave = 0;
      blk += cur->blocking;
      /* Buffer noch gefuellt */
      if ( cur->rbuf != cur->wbuf )
       {
        FD_SET(cur->fd,&writer);
        if ( cur->fd > max ) max = cur->fd;
       }
     }
I 4

E 4
   /* Aufhoeren, wenn alle Kanaele bearbeitet sind */
   if ( leave ) break;
I 4

E 4
   /* Eventuell blockierte Messung starten */
   tout = (!blk && stopped) ? &restart : (struct timeval *)0; 
I 4

E 4
   /* Datenuebertragung abwarten */
   if ( select(max+1,&reader,&writer,(fd_set *)0,tout) == -1 )
    {
     perror("select");
     exit(errno);
    }
I 4

E 4
   /* TCP Kanaele */
   for ( blk = 0, cur = chans ; cur ; cur = cur->next )
    if ( cur->fd != -1 )
     {
      /* Bereit zur Datenuebertragung */
      if ( FD_ISSET(cur->fd,&writer) )
       for ( tlen = -1 ; tlen == -1 ; )
	{
	 /* Restdaten schreiben */
	 switch (tlen = write(cur->fd,cur->buf+cur->rbuf,cur->wbuf-cur->rbuf))
	  {
	   case  0 : /* Fehler */
		     errno = ENXIO;
	   case -1 : /* Spaeter noch einmal versuchen */
		     if ( errno != EAGAIN )
		      {
		       /* Fehler anzeigen */
		       fprintf(stderr,"Unit FOR%03d ",cur->unit);
		       perror("write");
		       /* Kanal schliessen */
		       close(cur->fd);
		       cur->fd = -1;
		       /* Blockiert ab jetzt nicht mehr */
		       cur->blocking = 0;
		      }
		     /* Naechsten Kanal bearbeiten */
		     tlen = 0;
		     continue;
	  }
	 /* Zeiger veraendern und eventuell weitermachen */
	 if ( (cur->rbuf += tlen) != cur->wbuf ) 
	  tlen = -1;
	 else
	  cur->blocking = 0;
        }
      /* Blockierende Kanaele zaehlen */
      blk += cur->blocking;
     }
I 4

E 4
   /* Eventuell Messung starten */
   if ( !blk && stopped ) EVBsend(EVB$START);
I 4

E 4
   /* MHS Nachrichten */
D 4
   if ( FD_ISSET(vaxmhs_data.xids[*evdef],&reader) ) dispatch(-1);
E 4
I 4
   if ( FD_ISSET(lfd,&reader) && ((errno = IREQX(logname,&mb,&nowait,&null)) != -128) )
    {
     /* Fehler auswerten */
     if ( errno ) MHSerror("reading control message");
     /* Funktionscode auswerten */
     SWORD(&vaxmhs_data.vd_boxes[mb].mbcode,&code);
D 5
     /* Befehle an den Konverter selbst */
     switch (code)
      {
       case 0  : /* SOS_IN$EXIT */
		 reply(mb);
		 fprintf(stderr,"Converter terminated\n");
		 /* Buffer entleeren */
		 for ( cur = chans ; cur ; cur = cur->next )
		  if ( (cur->fd != -1) && (cur->rbuf != cur->wbuf) )
E 5
I 5
     if ( !(vaxmhs_data.vd_boxes[mb].mbstatus&RYBIT) )
      /* Befehle an den Konverter selbst */
      switch (code)
       {
	case 0  : /* SOS_IN$EXIT */
		  reply(mb);
		  fprintf(stderr,"Converter terminated\n");
		  /* Buffer entleeren */
		  for ( cur = chans ; cur ; cur = cur->next )
		   if ( (cur->fd != -1) && (cur->rbuf != cur->wbuf) )
		    {
		     /* Kanal auf blockierend stellen */
		     ioctl(cur->fd,FIONBIO,&nblk);
		     /* Daten schreiben */
		     write(cur->fd,cur->buf+cur->rbuf,cur->wbuf-cur->rbuf);
		    }
		  /* Aufhoeren */
		  exit(0);
	case 1  : /* SOS_IN$SUSPEND */
		  if ( booked ) 
E 5
		   {
D 5
		    /* Kanal auf blockierend stellen */
		    ioctl(cur->fd,FIONBIO,&nblk);
		    /* Daten schreiben */
		    write(cur->fd,cur->buf+cur->rbuf,cur->wbuf-cur->rbuf);
E 5
I 5
		    time(&now);
		    bookall(0);
		    fprintf(stderr,"Converter suspended at %s",ctime(&now));
E 5
		   }
D 5
		 /* Aufhoeren */
		 exit(0);
       case 1  : /* SOS_IN$SUSPEND */
		 if ( booked ) 
		  {
		   time(&now);
		   bookall(0);
		   fprintf(stderr,"Converter suspended at %s",ctime(&now));
		  }
       default : /* Mail beantworten */
		 reply(mb);
		 break;
       case 2  : /* SOS_IN$RESUME */
		 reply(mb);
		 /* Normal weitermachen */
		 if ( !booked ) 
		  {
		   time(&now);
		   fprintf(stderr,"Converter resumed at %s",ctime(&now));
		   bookall(1);
		  }
      }
E 5
I 5
	default : /* Mail beantworten */
		  reply(mb);
		  break;
	case 2  : /* SOS_IN$RESUME */
		  reply(mb);
		  /* Normal weitermachen */
		  if ( !booked ) 
		   {
		    time(&now);
		    fprintf(stderr,"Converter resumed at %s",ctime(&now));
		    bookall(1);
		   }
		  break;
       }
     /* Antwort auf einen Befehl an den Eventbuilder */
     else if ( vaxmhs_data.vd_boxes[mb].mbnum == WaitNum )
      if ( WaitFor == EVB$STOP )
       if ( !code )
        stopped = 1;
       else
        Xnostop++;
      else if ( (WaitFor == EVB$START) && !code )
       stopped = 0;
     /* Mail freigeben */
     IADDMB(&mb);
E 5
    }

   /* Events */
   if ( FD_ISSET(efd,&reader) ) dispatch(-1);
E 4
  }
 /* Alles in Ordnung */
 fprintf(stderr,"Converter terminated normally\n");
 exit(0);
}

/*
  Fehler bei Benutzung von SOS.
*/
static MHSerror(msg)
char *msg;
{
 /* Fehler ausgeben */
 fprintf(stderr,"MHS-Error %d while %s\n",errno,msg);
 /* Aufhoeren */
 exit(EIO);
}

/* 
  Fehler bei der Zerlegung eines Parameters.
*/
static PARerror(msg)
{
 /* Fehler ausgeben */
 fprintf(stderr,"Parameter-Error: %s\n",msg);
 /* Aufhoeren */
 exit(EINVAL);
}

/*
  Kein Speicher zu bekommen.
*/
static nomem()
{
 /* Fehler ausgeben */
 fprintf(stderr,"Out of memory\n");
 /* Aufhoeren */
 exit(ENOMEM);
}

/*
  Systemzeit auslesen.
*/
static double systime()
{
 struct timeval tod;

 /* Uhrzeit auslesen */
 gettimeofday(&tod,(struct timezone *)0);
 /* Ergebnis melden */
 return (tod.tv_sec+1.0E-6*tod.tv_usec);
}

/*
  Zahl von Text in die interne Darstellung umwandeln.
*/
static number(str,base,nump)
char *str;
int base;
int *nump;
{
 char *more;

 /* Zahl einlesen */
 errno = 0;
 if ( (((*nump = strtoul(str,&more,base)) == -1) && errno) || !more || *more || (more == str) )
  return -1;
 /* Erfolg melden */
 return 0;
}

/*
  Neuen Eventverbraucher eintragen.
  	unit:mode:mask:value:emask:qmask:size:events
	unit	%d
	mode	SIMPLE|SAMPLEALL
	mask	<list 0:31>
	value	<list 0:31>
	emask	<list 0:31>
	qmask	<list 1:16>
	size	%d
	events	%d
	list	0x%x|(%d.in range. {,%d.in range.})
*/
static adduser(str)
char *str;
{
 char *un = str,*mo,*ma,*va,*em,*qm,*si,*ev,*log,name[8];
 int nblk = 1,nev;
 USER *user,*chk;

 /* Speicher allokatieren */
 if ( !(user = MALLOC(USER,1)) ) nomem();
 /* Zerlegen */
 if ( !(mo = strchr(un,':')) ) PARerror("event mode missing");
 *mo++ = '\0';
 if ( !(ma = strchr(mo,':')) ) PARerror("trigger mask missing");
 *ma++ = '\0';
 if ( !(va = strchr(ma,':')) ) PARerror("trigger value missing");
 *va++ = '\0';
 if ( !(em = strchr(va,':')) ) PARerror("error mask missing");
 *em++ = '\0';
 if ( !(qm = strchr(em,':')) ) PARerror("equipment mask missing");
 *qm++ = '\0';
 if ( !(si = strchr(qm,':')) ) PARerror("size missing");
 *si++ = '\0';
 if ( !(ev = strchr(si,':')) ) PARerror("number of events missing");
 *ev++ = '\0';
 /* Zahlen umwandeln */
 if ( number(un,10,&user->unit) || (user->unit <= 0) || (user->unit > 999) ) 
  PARerror("invalid unit number");
 if ( number(si,10,&user->usize) || (user->usize < (HDR/2)) || (user->usize >= 0x8000) ) 
  PARerror("invalid size"); 
 if ( number(ev,10,&nev) || (nev < 1) || (nev >= 100) )
  PARerror("invalid number of events");
 /* Zeichenketten umwandeln */
 if ( !strcmp(mo,"SIMPLE") )
  user->samp = 0;
 else if ( !strcmp(mo,"SAMPLEALL") )
  user->samp = 1;
 else
  PARerror("invalid mode");
 /* Masken umwandeln */
 if ( mask(ma,0,31,&user->mask) ) PARerror("invalid trigger mask");
 if ( mask(va,0,31,&user->value) ) PARerror("invalid trigger value");
 if ( mask(em,0,31,&user->emask) ) PARerror("invalid error mask");
 if ( mask(qm,1,16,&user->qmask) ) PARerror("invalid equipment mask");
 /* Speicher allokatieren */
 if ( !(user->buf = MALLOC(char,user->size = nev*(2*user->usize+8))) ) nomem();
 /* Unitnummer ueberpruefen */
 for ( chk = chans ; chk ; chk = chk->next )
  if ( chk->unit == user->unit )
   {
    fprintf(stderr,"Unit %d used twice\n",user->unit);
    exit(EINVAL);
   }
 /* Logischen Namen umsetzen */
 sprintf(name,"FOR%03d",user->unit);
 if ( !(log = translate_vms(name)) || (log == (char *)-1) ) PARerror("invalid logical name");
 /* Initialisierung beenden */
 user->events = user->bytes = user->lost = 0.0;
 user->rbuf = user->wbuf = user->blocking = 0;
 user->book = -1;
 /* Verketten */
 user->next = chans;
 chans = user;
 /* Anzeigen */
 fprintf(stderr,"Eventchannel %s(%s) %s\n",name,log,user->samp ? "SAMPLE ALL" : "SIMPLE");
 viewmask("Trigger mask ",user->mask,0);
 viewmask("Trigger value",user->value,0);
 viewmask("Error mask   ",user->emask,0);
 viewmask("Equipments   ",user->qmask,1);
 fprintf(stderr,"\tBuffer size   = %d\n\n",user->usize);
 /* Datei oeffnen */
 if ( (user->fd = creat(log,0744)) == -1 )
  {
   perror("Open output channel");
   exit(errno);
  }
 /* Entblocken */
 if ( ioctl(user->fd,FIONBIO,&nblk) == -1 )
  {
   perror("Unblocking output channel");
   exit(errno);
  }
}

/*
  Masken umwandeln.
*/
static mask(str,min,max,maskp)
char *str;
int min,max,*maskp;
{
 char *next = str;
 int val;

 /* 0x%x */
 if ( !memcmp(str,"0x",2) || !memcmp(str,"0X",2) ) return number(str,16,maskp);
 /* Liste abarbeiten */
 for ( *maskp = 0 ; str = next ; )
  {
   /* Naechstes Element */
   if ( (next = strchr(str,',')) ) *next++ = '\0';
   /* Zahl einlesen */
   if ( number(str,10,&val) || (val < min) || (val > max) ) return -1;
   /* Einsetzen */
   *maskp |= 1<<(val-min);
  }
 /* Alles in Ordung */
 return 0;
}

/*
  Maske anzeigen.
*/
static viewmask(name,mask,off)
char *name;
int mask,off;
{
 int lp;

 /* Name ausgeben */
 fprintf(stderr,"\t%s = ",name);
 /* Bits ausgeben */
 for ( lp = 1 ; lp && mask ; lp += lp, off++ )
  if ( mask&lp )
   {
    fprintf(stderr,"%d",off);
    if ( mask &= ~lp ) fprintf(stderr,",");
   }
 /* Fertig */
 fprintf(stderr,"\n");
}

/*
  Nach getaner Arbeit aufraeumen.
*/
static exitter()
{
 USER *cur,*turn,*nxt;
 int now;

 /* Uhrzeit ausgeben */
 time(&now);
 fprintf(stderr,"Converter terminated at %s",ctime(&now));
I 4
 /* Liste drehen und Kanaele schliessen */
 for ( nxt = chans, turn = 0 ; cur = nxt ; turn = cur )
  {
   /* Reihenfolge aendern */
   nxt = cur->next;
   cur->next = turn;
   /* Kanal schliessen */
   if ( cur->fd != -1 ) close(cur->fd);
   cur->fd = -1;
  }
 chans = turn;
E 4
I 3
 /* SAMPLEALL Buchungen loeschen */
 bookall(-1);
E 3
 /* Logische Adresse freigeben */
D 4
 if ( *evdef ) 
E 4
I 4
 if ( *evdef != -1 ) 
E 4
  {
   VMEDLOG(evdef,&errno);
   if ( errno ) fprintf(stderr,"Could not delete logical address\n");
   if ( errno = IDELETEX(evdef) ) fprintf(stderr,"Could not delete exchange\n");
  }
 /* Logischen Namen loeschen */
D 4
 if ( logname[0] != -1 ) VMEDEL(logname+1,logname+3,&errno);
E 4
I 4
 if ( *logname != -1 ) 
  {
   VMEDEL(logname+1,logname+3,&errno);
   if ( errno ) fprintf(stderr,"Could not delete logical name\n");
   if ( errno = IDELETEX(logname) ) fprintf(stderr,"Could not delete exchange\n");
  }
E 4
D 3
 /* SAMPLEALL Buchungen loeschen */
 bookall(-1);
E 3
 /* Bridge in den urspruenglichen Zustand versetzen */
 bridge(bnumber,breset);
 /* Statistik ausgeben */
 fprintf(stderr,"\nOverall statistics:\n");
 fprintf(stderr,"\t%.0f SAPHIR event%s\n",Xevents,(Xevents == 1.0) ? "" : "s");
 statist(Xnouse,"Not useful event");
 statist(Xstop,"Stopped event");
 statist(Xsaphir,"Illegal MBCODE event");
 statist(Xlen,"Illegal MBLEN event");
 statist(Xtot,"Illegal MBRES event");
 statist(Xstatus,"Illegal RD/WR bit event");
 statist(Xready,"Illegal ER bit event");
 statist(Xelen,"Illegal length event");
 statist(Xmissed,"Missing data part");
 statist(Xequi,"Equipment error");
 statist(Xtout,"Event timeout");
 statist(Xnoready,"No SAMPLEALL answer mail");
 statist(Xnosend,"No SAMPLEALL answer send");
 statist(Xstopped,"RUN stop");
 statist(Xnostop,"EVB$STOP reject");
 /* Kanalstatistik */
D 4
 for ( nxt = chans, turn = 0 ; cur = nxt ; turn = cur )
E 4
I 4
 for ( cur = chans ; cur ; cur = cur->next )
E 4
  {
D 4
   /* Reihenfolge aendern */
   nxt = cur->next;
   cur->next = turn;
  }
 for ( cur = chans = turn ; cur ; cur = cur->next )
  {
E 4
   /* Kopfzeile */
   fprintf(stderr,"\nChannel statistics:\n");
   /* Statistik */
   fprintf(stderr,"\tEvents processed: %.0f (%.0f lost)\n",cur->events,cur->lost);
   fprintf(stderr,"\tBytes in events:  %.0f\n",cur->bytes);
  }
}

/*
  Statistik ausgeben.
*/
static statist(val,msg)
int val;
char *msg;
{
 if ( val ) fprintf(stderr,"\t%d %s%s\n",val,msg,(val == 1) ? "" : "s");
}

/*
E 2
  Bridge mit der angegebenen Nummer fuer Events in diesen ETHERNET-Zweig
  oeffnen oder schliessen. Das Ergebnis wird wie folgt gemeldet:
  	-1 : Fehler, Fehlercode in 'errno'
	 0 : Bridge war geschlossen
	 1 : Bridge war offen
  Der Parameter 'opn' bestimmt, was zu tun ist:
  	-1 : nur nachsehen
	 0 : Bridge schliessen
	 1 : Bridge oeffnen
*/
static bridge(num,opn)
int num,opn;
{
 int list[4],null = 0,flags,pref = 0x88005650,old;
 short id;

I 2
 /* Nicht, wenn 'num' Null ist */
 if ( !num ) return 0;
E 2
 /* Logische Adresse ermitteln */
 VMELOG(list,"BRIDGE  ",&null,&flags,&errno);
 if ( errno ) return -1;
 /* Nummer einsetzen */
 if ( (num >= 3) && (num <= 15) )
  {
   /* Persoenliche Nummer */
   id = 0x6f00+(num<<4);
   /* Adresse zusammensetzen */
   SLONG(&pref,list);
   SWORD(&id,list+1);
  }
 /* Alte Informationen einlesen */
 if ( (old = b_action(list,0,0)) == -1 ) return -1;
 /* Bridge beeinflussen */
 if ( (opn != -1) && (b_action(list,opn&1,(~opn)&1) == -1) ) return -1;
 /* Alten Wert melden */
 return old;
}

static b_action(accl,on,off)
int *accl;
{
 short code = 49,len = 6,old;
 int mb,wait = 500;
 MAILBOX *mbox;

 /* Mail holen */
D 2
 if ( errno = ICALCMB(&mb,accl) ) return 0;
E 2
I 2
 if ( errno = ICALCMB(&mb,accl) ) return -1;
E 2
 /* Mailparameter aufsetzen */
 mbox = vaxmhs_data.vd_boxes+mb;
 SWORD(&code,&mbox->mbcode);
 mbox->mbstatus |= WRBIT|ERBIT;
 SWORD(&len,&mbox->mblen);
 /* Bridgeparameter einsetzen, es wird immer die jenseitige Bridge beeinflusst */
 mbox->mbdata[0] = 0;
 mbox->mbdata[1] = 0;
 mbox->mbdata[2] = on;
 mbox->mbdata[3] = off;
 mbox->mbdata[4] = 0;
 mbox->mbdata[5] = 0;
 /* Mail abschicken */
 SNDMAIL(&mb,&errno,&wait);
 if ( errno ) return -1;
 /* Informationen auslesen */
 old = vaxmhs_data.vd_boxes[mb].mbdata[51]&1;
 /* Antwortmail beseitigen */
 IADDMB(&mb);
 /* Alles in Ordnung */
 return old;
I 2
}

/*
  Alle SAMPLEALL Buchungen vornehmen oder eleminieren.
*/
static bookall(book)
int book;
{
 int barr[4],fid;
 USER *cur;

 /* Vermerken */
 booked = book;
 /* Alle Kanaele */
 for ( cur = chans ; cur ; cur = cur->next )
  if ( cur->samp )
   {
    /* Buchung loeschen */
    if ( ((fid = cur->book) != -1) )
     {
      cur->book = -1;
      if ( EVB(EVB$RELEASE,&fid,NOSTR) && (book != -1) ) MHSerror("unbooking SAMPLEALL");
     }
    /* Buchung vornehmen */
    if ( book == 1 )
     {
      /* Parameter aufsetzen */
      SLONG(&cur->mask,barr+0);
      SLONG(&cur->value,barr+1);
      SLONG(&cur->emask,barr+2);
      SLONG(&cur->qmask,barr+3);
      /* Und buchen */
      if ( EVB(EVB$BOOK,&cur->book,barr,sizeof(barr)) ) MHSerror("booking SAMPLEALL");
     }
   }
}

/* 
  Befehl an den EVENTBUILDER schicken.
*/
static EVB(code,fid,addr,len)
int code,*fid,len;
char *addr;
{
 short scode = code,slen;
 int mb,time = 200;

 /* Mail holen */
 if ( errno = ICALCMB(&mb,evb) ) return errno;
 /* Mail fuellen */
 SWORD(&scode,&vaxmhs_data.vd_boxes[mb].mbcode);
 vaxmhs_data.vd_boxes[mb].mbstatus |= ERBIT;
 if ( addr )
  {
   /* Daten eintragen */
   slen = len;
   SWORD(&slen,&vaxmhs_data.vd_boxes[mb].mblen);
   bcopy(addr,vaxmhs_data.vd_boxes[mb].mbdata,len);
   vaxmhs_data.vd_boxes[mb].mbstatus |= WRBIT;
  }
 /* Mail abschicken und Antwort abwarten */
 if ( !fid ) 
  {
   /* Antwortexchange aufsetzen */
D 5
   vaxmhs_data.vd_boxes[mb].mbsxid = *evdef;
E 5
I 5
   vaxmhs_data.vd_boxes[mb].mbsxid = *logname;
E 5
   /* Nummer der Mail merken */
   WaitFor = code;
   WaitNum = vaxmhs_data.vd_boxes[mb].mbnum;
   /* Mail abschicken */
   if ( errno = ISENDMB(&mb) ) IADDMB(&mb);
   /* Ergebnis melden */
   return errno;
  }
 /* Kennung eintragen */
 vaxmhs_data.vd_boxes[mb].mbfid = *fid;
 SNDMAIL(&mb,&errno,&time);
 if ( errno ) return errno;
 /* Antwort auswerten */
 *fid = vaxmhs_data.vd_boxes[mb].mbfid;
 /* Mail freigeben */
 IADDMB(&mb);
 /* Erfolg melden */
 return 0;
}

D 4
/* 
  Logischen Namen definieren.
*/
static define(xid)
int xid;
{
 unsigned short code = IOC$DEFNAME,len = 14,opt = 0;
 struct mailbox *mbox;
 int mb,ticks = 1000;

 /* Mail holen */
 if ( errno = IIOCMB(&mb) ) MHSerror("defining logical name");
 mbox = vaxmhs_data.vd_boxes+mb;
 /* Der Name setzt sich zusammen aus der TCP/IP-Adresse des lokalen Knotens und */
 /* der aktuellen Prozessnummer. Beide werden binaer kodiert.			*/
 logname[1] = gethostid();
 logname[2] = getpid();
 /* Mail fuellen */
 SWORD(&code,&mbox->mbcode);
 QUAD(logname+1,mbox->mbdata+0);
 LONG(&xid,mbox->mbdata+8);
 SWORD(&opt,mbox->mbdata+12);
 SWORD(&len,&mbox->mblen);
 /* Mail abschicken und Antwort abwarten */
 SNDMAIL(&mb,&errno,&ticks); 
 if ( errno ) MHSerror("contacting IOC");
 /* Parameter auslesen */
 SWORD(vaxmhs_data.vd_boxes[mb].mbdata,&opt);
 logname[0] = xid;
 logname[3] = opt;
 /* Mail freigeben */
 IADDMB(&mb);
}

E 4
/*
  Bearbeiten eines Events oder einer Mail.
*/
static dispatch(mb)
int mb;
{
 static int sfid,acteq,sum,len,idle = 1,actanz = 0,skip = 0,found;
 static MAILBOX *actev = 0,*last;
 static double timer,now,delta;
 static unsigned char kexp[2];
D 4
 int mix,rix,mres,mfid,fail,ix,rbox,null = 0,ok = EVB$OK,nblk = 0,snow;
E 4
I 4
 int mix,rix,mres,mfid,fail,ix,rbox,null = 0,ok = EVB$OK,snow;
E 4
 struct EventHeader *cur;
 unsigned char mexp[2];
 short mcode,mlen;
 MAILBOX *mbox;
 USER *scan;

 /* Mail auslesen */
 if ( (mb == -1) && IREQX(evdef,&mb,&null,&null) ) MHSerror("reading event");
 mbox = vaxmhs_data.vd_boxes+mb;

 /* Allgemeine Parameter auslesen */
 WORD(&mbox->mbexpd,mexp);
 SWORD(&mbox->mbcode,&mcode);
 SWORD(&mbox->mblen,&mlen);
 SLONG(&mbox->mbres,&mres);
 LONG(&mbox->mbfid,&mfid);
 if ( !mexp[0] && !mexp[1] ) mexp[0] = mexp[1] = 1;

 /* Laenge in der richtigen Bytereihenfolge festhalten */
 mbox->mblen = mlen;

D 5
 /* Antwort auf einen Befehl an den Eventbuilder */
 if ( mbox->mbstatus&RYBIT )
  {
   /* Parameter testen */
   if ( mbox->mbnum == WaitNum )
    if ( WaitFor == EVB$STOP )
     if ( !mcode )
      stopped = 1;
     else
      Xnostop++;
    else if ( (WaitFor == EVB$START) && !mcode )
     stopped = 0;
   /* Mail freigeben und fertig */
   IADDMB(&mb);
   return;
  }

E 5
D 4
 /* Befehle an den Konverter selbst */
 switch (mcode)
  {
   case 0 : /* SOS_IN$EXIT */
     	    reply(&mb);
     	    fprintf(stderr,"Converter terminated by SOS_IN$EXIT command\n");
	    /* Buffer entleeren */
	    for ( scan = chans ; scan ; scan = scan->next )
	     if ( (scan->fd != -1) && (scan->rbuf != scan->wbuf) )
	      {
	       /* Kanal auf blockierend stellen */
	       ioctl(scan->fd,FIONBIO,&nblk);
	       /* Daten schreiben */
	       write(scan->fd,scan->buf+scan->rbuf,scan->wbuf-scan->rbuf);
	      }
	    /* Aufhoeren */
	    exit(0);
   case 1 : /* SOS_IN$SUSPEND */
     	    if ( booked ) 
	     {
	      time(&snow);
	      bookall(0);
	      fprintf(stderr,"Converter suspended by SOS_IN$SUSPEND command: %s",ctime(&snow));
	     }
	    /* Mail beantworten */
     	    reply(&mb);
	    return;
   case 2 : /* SOS_IN$RESUME */
     	    reply(&mb);
	    /* Normal weitermachen */
     	    if ( !booked ) 
	     {
	      time(&snow);
	      fprintf(stderr,"Converter resumed by SOS_IN$RESUME command: %s",ctime(&snow));
	      bookall(1);
	     }
	    return;
  }

E 4
 /* Events werden ignoriert */
 if ( !booked )
  {
   /* Eventblock eleminieren */
   IADDMB(&mb);
   /* Rest des Events ueberspringen */
   idle = skip = 1;
   sfid = mfid;
   /* Fertig */
   return;
  }

 /* Das muss jetzt ein Event sein */
 fail = 0;
 if ( idle )
  /* Eventcode */
  if ( mcode != EVENT$SAPHIR )
   Xsaphir++;
  /* Eventlaenge muss gerade sein und im legalen Bereich liegen */
  else if ( (mlen < 2) || (mlen > MAILMAX) || (mlen&1) )
   Xlen++;
  /* Events sind immer Schreibdaten */
  else if ( (mbox->mbstatus&RDBIT) || !(mbox->mbstatus&WRBIT) )
   Xstatus++;
  /* Antworten koennen nur auf den letzten Datenblock eines Events verlangt werden */
  else if ( (mexp[0] != mexp[1]) && (mbox->mbstatus&ERBIT) )
   Xready++;
  /* Eventgesamtgroesse muss im legalen Bereich liegen */
  else if ( (mres < HDR) || (mres >= 0x8000) || !mexp[1] || (mexp[1] > (VD_MAXBOX-5)) )
   Xtot++;
  /* Eventblock soll uebersprungen werden */
  else if ( skip && (mfid == sfid) )
   {
    if ( mexp[0] == mexp[1] ) skip = 0;
   }
  else
   {

    /* Das muss der Anfang eines Events sein (sonst ist 'idle' ungleich Null) */
    skip = 0;
    Xevents += 1.0;
    /* Blockzaehler */
    if ( mexp[0] != 1 )
     {
      Xmissed++;
      fail = 2;
     }
    else
     {
      /* Eventheader validieren */
      cur = (struct EventHeader *)mbox->mbdata;
      /* EVENTBUILDER nachsynchronisieren */
      if ( cur->everr&(1<<ER$RESYNC) ) search = 1;
      /* Messung ist eigenlich angehalten */
      if ( !(cur->everr&(1<<ER$RUN)) && stopped )
       {
        Xstop++;
	fail = 3;
       }
      else
       {
	/* Altes Event freigeben, falls vorhanden  */
	if ( actev ) freeevent(actev-vaxmhs_data.vd_boxes);
	actev = 0;
	
	/* Laengen im Header ueberpruefen */
	if ( (cur->evhdr < (HDR>>1)) || (mlen < HDR) ||
	     (cur->evhdr > cur->evlen) || (cur->evlen >= 0x4000) )
	 {
	  Xlen++;
	  fail = 3;
	 }
	/* Gesamtlaenge */
	else if ( mres != (len = ((int)cur->evlen)<<1) )
	 {
	  Xelen++;
	  fail = 3;	   
	 }
	else
	 {
	  /* Equipmentmaske ermitteln */
	  for ( acteq = 0, ix = 16 ; ix-- ; )
	   if ( cur->evptr[ix] ) 
	    acteq |= 1<<ix;
	  /* Feststellen, ob prinzipiell Interesse an dem Event besteht */
	  for ( scan = chans ; scan ; scan = scan->next )
	   if ( (((cur->evtrg&scan->mask) == scan->value) && (acteq&scan->qmask)) || 
		(cur->everr&scan->emask) )
	    break;
	  /* Event kann ignoriert werden */
	  if ( !scan )
	   {
	    Xnouse++;
	    fail = 3;
	   }
	  else
	   {

	    /* Vorbereiten zur Komplettierung des Events */
	    kexp[0] = mexp[0];
	    kexp[1] = actanz = mexp[1];
	    sfid = mfid;
	    sum = mlen;
	    last = actev = mbox;
	    actev->mblink = -1;
	    /* Aktuelle Uhrzeit ermitteln */
	    timer = systime();
	    idle = 0;
	    /* Mail darf nicht mehr freigegeben werden */
	    mb = -1;
	   }
	 }
       }
     }
   }
 else 
  {
   /* Naechster Teil des Events */
   delta = (now = systime())-timer;
   /* Eventteile duerfen nicht mehr als 150 Millisekunden auseinanderliegen */
   if ( delta > 0.15 )
    {
     Xtout++;
     fail = 5;
    }
   /* Eventblock muss passen */
   else if ( (mcode != EVENT$SAPHIR) || (mfid != sfid) ||
	     (mexp[0] != kexp[0]) || (mexp[1] != kexp[1]) )
    {
     Xmissed++;
     fail = 5;
    }
   else
    {
     /* Eventblocks verketten */
     last->mblink = mbox-vaxmhs_data.vd_boxes;
     last = mbox;
     last->mblink = -1;
     /* Mail darf nicht mehr freigegeben werden */
     mb = -1;

     /* Laenge */
     if ( (mlen < 2) || (mlen > MAILMAX) || (mlen&1) )
      {
       Xlen++;
       fail = 4;
      }
     /* Schreibdaten */
     else if ( (mbox->mbstatus&RDBIT) || !(mbox->mbstatus&WRBIT) )
      {
       Xstatus++;
       fail = 4;
      }
     /* Gesamtlaenge */
     else if ( mres != len )
      {
       Xtot++;
       fail = 4;
      }
     /* Antwort erwartet */
     else if ( (kexp[0] != actanz) && (mbox->mbstatus&ERBIT) )
      {
       Xready++;
       fail = 4;
      }
     else
      {
       /* Eventblock ist in Ordung */
       sum += mlen;
       timer = now;
      }
    }  
  }
 
 /* Letzten Eventblock gesondert bearbeiten */
 if ( (kexp[0]++ >= actanz) && !fail && !idle )
  /* Gesamtlaenge stimmt nicht */
  if ( sum != len )
   {
    Xtot++;
    fail = 4;
   }
  else
   {
I 3
    /* Eventzeiger restaurieren */
    cur = (struct EventHeader *)actev->mbdata;
E 3
    /* Feststellen, ob prinzipiell Interesse an dem Event besteht */
    for ( found = 0, scan = chans ; scan ; scan = scan->next )
     {
      /* Nicht verwendbar */
      scan->active = scan->blocking = 0;
      /* Passt das Event */
      if ( (((cur->evtrg&scan->mask) == scan->value) && (acteq&scan->qmask)) || 
           (cur->everr&scan->emask) )
       if ( scan->samp )
D 6
        {
E 6
I 6
	{
E 6
	 /* Zaehlen */
	 if ( found >= 0 ) found = -1;
D 6
	 /* Eventuell Messung anhalten */
	 if ( (scan->rbuf == scan->wbuf) && (mres <= 2*scan->usize) )
	  scan->active = 1;
	 else
E 6
I 6
	 /* Event darf nicht zu gross sein */
	 if ( mres > 2*scan->usize )
	  scan->lost += 1.0;
         else
E 6
	  {
D 6
	   /* Blockiert die Auslese */
	   scan->blocking = 1;
	   found = -2;
E 6
I 6
	   /* Event darf nicht verloren gehen */
	   scan->active = 1;
	   /* Eventuell Messung anhalten */
	   if ( scan->rbuf != scan->wbuf )
	    {
	     /* Blockiert die Auslese */
	     scan->blocking = 1;
	     found = -2;
	    }
E 6
	  }
        }
       /* Aufnahmebereit */
       else if ( (scan->rbuf == scan->wbuf) && (mres <= 2*scan->size) )
	{
	 /* Bearbeiten */
	 scan->active = 1;
	 /* Eventuell zaehlen */
	 if ( !found ) found = 1;
        }
     }

    /* Antwort abschicken */
    if ( (mbox->mbstatus&ERBIT) && (found < 0) )
     {
      /* Antwortmail holen */
      mix = mbox-vaxmhs_data.vd_boxes;
      mcode = ok;
      if ( !IREADYMB(&rbox,&mix,&ok) )
       {
	/* Korrekten Code eintragen */
        if ( found == -2 ) mcode = EVB$STOP;
	SWORD(&mcode,&vaxmhs_data.vd_boxes[rbox].mbcode);
	/* Antwortmail abschicken */
	if ( ISENDMB(&rbox) )
	 {
	  IADDMB(&rbox);
	  Xnosend++;
	 }
        /* Zustand vermerken */
	else if ( found == -2 )
	 stopped = 1;
       }
      else
       Xnoready++;
     }
    
    /* Explizit anhalten */
    if ( (found == -2) && EVBsend(EVB$STOP) ) Xnostop++;
    if ( stopped ) Xstopped++;

    /* In den Urzustand */
    idle = 1;
    skip = 0;

    /* Event an alle Kanaele verteilen */
    if ( found ) newevent(actev,acteq);

    /* Altes Event freigeben */
    freeevent(actev-vaxmhs_data.vd_boxes);
    actev = 0;
   }

 /* Event erneut bearbeiten */
 if ( fail >= 4 )
  {
   /* Altes Event freigeben */
   freeevent(actev-vaxmhs_data.vd_boxes);
   actev = 0;
   /* Ueberspringen vorbereiten */
   idle = 1;
   skip = 1;
   /* Erneut bearbeiten */
   if ( fail == 5 ) 
    {
     /* Neues Event bearbeiten */
     dispatch(mb);
     /* Mail darf nicht mehr freigegeben werdem */
     mb = -1;
    }
  }
 
 /* Aktuellen Eventblock wegwerfen */
 else if ( (fail >= 2) && (mexp[0] != mexp[1]) )
  {
   skip = 1;
   sfid = mfid;
  } 

 /* Mail freigeben */
 if ( mb != -1 ) IADDMB(&mb);
}

/*
  Nachricht beantworten.
*/
D 4
static reply(mp)
int *mp;
E 4
I 4
static reply(mb)
int mb;
E 4
{
 int rb,code = 0;

 /* Antwortmail holen */
D 4
 if ( (vaxmhs_data.vd_boxes[*mp].mbstatus&ERBIT) && !IREADYMB(&rb,mp,&code) && ISENDMB(&rb) )
E 4
I 4
 if ( (vaxmhs_data.vd_boxes[mb].mbstatus&ERBIT) && !IREADYMB(&rb,&mb,&code) && ISENDMB(&rb) )
E 4
  IADDMB(&rb);
D 5
 /* Mail freigeben */
D 4
 IADDMB(mp);
E 4
I 4
 IADDMB(&mb);
E 5
E 4
}

/*
  Liste von Mails freigeben.
*/
static freeevent(mb)
int mb;
{
 int mix = mb;

 /* Bis zum Ende der Liste */
 while ( (mb = mix) != -1 )
  {
   /* Zeiger merken */
   mix = vaxmhs_data.vd_boxes[mb].mblink;
   /* Mail freigeben */
   IADDMB(&mb);
  }
}

/*
  Die folgende Routine verteilt ein Event an alle Kanaele, deren 'active' Eintrag nicht
  Null ist. Dazu wird das Event zuerst auf Konsistenz ueberprueft und dann je nach
  Wunsch der Benutzer verteilt.
*/
static newevent(mbox,emask)
MAILBOX *mbox;
int emask;
{
 int tlen,ix,cmp,off,elen,len,alen,len0;
 struct einfo equip[16],*cur;
 struct EventHeader *ev,*nev;
 unsigned short *ep;
 short efield[2];
 MAILBOX *sbox;
 USER *scan;

 /* Adresse des Headers ermitteln */
 ev = (struct EventHeader *)mbox->mbdata;
 /* Nach Equipments zerlegen */
 tlen = ((int)ev->evhdr)<<1;
 for ( ix = 0, cur = equip, ep = ev->evptr ; ix++ < 16 ; cur++ )
  {
   /* Equipment vorhanden */
   if ( !(cmp = *ep++) ) continue;
   /* Index muss im legalen Bereich liegen */
   if ( (cmp <= ev->evhdr) || (cmp > ev->evlen-3) )
    {
     Xtot++;
     return;
    }
   /* Startmail ermitteln */
   cmp = (cmp-1)*2;
   for ( sbox = mbox, off = 0 ; cmp >= (off+sbox->mblen) ; )
    {
     /* Offset aktualisieren */
     off += sbox->mblen;
     /* Naechste Mail */
     sbox = vaxmhs_data.vd_boxes+sbox->mblink;
    }
   /* Anfang des Equipmentkopfes auslesen */
   ecopy(sbox,cmp-off,efield,sizeof(efield));
   /* Equipmentkopf auswerten */
   elen = efield[0];
   if ( (elen < 4) || (elen > ev->evlen) )
    {
     Xequi++;
     return;
    }
   /* Konsistenz ueberpruefen */
   elen <<= 1;
   if ( (elen+cmp) > (((int)ev->evlen)<<1) )
    {
     Xtot++;
     return;
    }
   /* Equipmentnummer ueberpruefen */
   if ( efield[1] != ix )
    {
     Xequi++;
     return;
    }
   /* Verwaltungsstruktur aufsetzen */
   cur->box = sbox;
   cur->off = cmp-off;
   cur->len = elen;
   /* Gesamtlaenge ermitteln */
   tlen += elen;
  }
 /* Gesamtlaenge ueberpruefen */
 if ( tlen != (((int)ev->evlen)<<1) )
  {
   Xtot++;
   return;
  }
 /* Events weitergeben */
 for ( scan = chans ; scan ; scan = scan->next )
  if ( scan->active )
   {
    /* Event bis auf Widerruf als verloren ansehen */
    scan->lost += 1.0;
    /* Buffer loeschen */
    if ( scan->rbuf == scan->wbuf ) scan->rbuf = scan->wbuf = 0;
    /* Platz im Buffer ermitteln */
    if ( (len = scan->size-scan->wbuf-(len0 = 4)) < 0 ) continue;
    /* Zaehler initialisieren */
    nev = (struct EventHeader *)(scan->buf+scan->wbuf+len0);
    /* Header uebertragen */
    alen = ((int)ev->evhdr)<<1;
    if ( (len -= alen) < 0 ) continue;
    ecopy(mbox,0,nev,alen);
    len0 += alen;
    /* Alle Equipments durchgehen */
    for ( ix = 16, cur = equip+15, ep = nev->evptr+16 ; ix-- ; cur-- )
     if ( emask&scan->qmask&(1<<ix) )
      {
       /* Index festhalten */
       *--ep = (len0>>1)-1;
       /* Laenge bereitstellen */
       if ( (len -= (alen = cur->len)) < 0 ) 
	{
	 ix = 100;
	 break;
        }
       /* Daten kopieren */
       ecopy(cur->box,cur->off,scan->buf+scan->wbuf+len0,alen);
       /* Zaehler aktualisieren */
       len0 += alen;
      }
     else
      *--ep = 0;
    /* Event komplettieren */
    if ( (ix == 100) || ((len -= 4) < 0) ) continue;
    len0 -= 4;
    bcopy(&len0,scan->buf+scan->wbuf,4);
    bcopy(&len0,scan->buf+scan->wbuf+4+len0,4);
    nev->evlen = len0>>1;
    /* Buffer aktualisieren */
    scan->wbuf += len0+8;
    scan->lost -= 1.0;
    scan->events += 1.0;
    scan->bytes += len0;
    /* Buffer soweit es geht abschicken */
    for ( tlen = -1 ; tlen == -1 ; )
     {
      /* Daten schreiben */
      switch (tlen = write(scan->fd,scan->buf+scan->rbuf,scan->wbuf-scan->rbuf))
       {
	case  0 : /* Fehler */
	          errno = ENXIO;
	case -1 : /* Spaeter noch einmal versuchen */
	          if ( errno != EAGAIN )
	           {
	            /* Fehler anzeigen */
	            fprintf(stderr,"Unit FOR%03d ",scan->unit);
	            perror("write");
	            /* Kanal schliessen */
	            close(scan->fd);
	            scan->fd = -1;
	           }
	          /* Naechsten Kanal bearbeiten */
	          tlen = 0;
		  continue;
       }
      /* Zeiger veraendern und eventuell weitermachen */
      if ( (scan->rbuf += tlen) != scan->wbuf ) 
       tlen = -1;
      else
       scan->blocking = 0;
     }
   } 
}

/*
  Datenblock aus einer Mailliste zusammenstellen.
*/
static ecopy(box0,off,dst,len)
MAILBOX *box0;
int off,len;
char *dst;
{
 int tlen;

 /* Alle Bytes bearbeiten */
 while ( len )
  {
   /* Maximale Zahl von Bytes am Stueck */
   if ( (tlen = (box0->mblen-off)) > len ) tlen = len;
   /* Kopieren */
   bcopy(box0->mbdata+off,dst,tlen);
   /* Naechsten Durchgang vorbereiten */
   off = 0;
   box0 = vaxmhs_data.vd_boxes+box0->mblink;
   dst += tlen;
   len -= tlen;
  }
E 2
}
E 1
