h42045
s 00000/00000/00053
d D 5.1 91/08/14 09:06:40 jochen 9 8
c New version to be compatible with versions of queue manager
e
s 00001/00001/00052
d D 4.5 91/06/05 08:32:19 jochen 8 7
c Null records are now allowed
e
s 00001/00001/00052
d D 4.4 91/05/28 16:33:28 jochen 7 6
c Buffer size enlarged to 100 KBytes
e
s 00001/00001/00052
d D 4.3 91/04/29 08:55:37 jochen 6 5
c Buffer handling for events greater than EVENTBUFFER corrected
e
s 00001/00001/00052
d D 4.2 91/04/16 17:07:24 jochen 5 4
c Buffer size enlarged to 100KByte - perhaps error in definitions.h
e
s 00000/00000/00053
d D 4.1 91/02/28 12:08:19 jochen 4 3
c Using RPC numbers reserved by SUN
e
s 00000/00000/00053
d D 3.3 91/02/28 12:07:27 jochen 3 2
c Implementation completed
e
s 00020/00019/00033
d D 3.2 91/02/09 08:52:15 jochen 2 1
c History based version
e
s 00052/00000/00000
d D 3.1 91/02/08 14:49:32 jochen 1 0
c SCCS version of converter for queuemanager version 3 created
e
u
U
t
T
I 1
/* %W% 91/02/08 HSTORE data stream converter for UNIX parallel batch queue manager */

#ifdef SCCSIDS
static char sccsid_hstore_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  CONVERTER: HSTORE to HFETCH

  Basis: FORTRAN (ghf77) Records
  	 len:4
	 bytes:len
	 len:4

D 2
  Struktur: Header mit 0:4,0:4,0:4,0:4 als Endkennung
E 2
I 2
  Struktur: Header (16 Bytes)
E 2
  	    Histogramm

*/

#define USERDATA	long head[4],len1,len2; mark_t mark;
D 5
#define BUFFERSIZE	40000
E 5
I 5
D 6
#define BUFFERSIZE	100000
E 6
I 6
D 7
#define BUFFERSIZE	40000
E 7
I 7
#define BUFFERSIZE	100000
E 7
E 6
E 5

#include <saphir/converter/definitions.h>

ROUTINE()
     ACTION()
        /* Schleifenanfang */
        MARK(&USER.mark);
D 2
	  /* Header enthaelt 16 Bytes */
E 2
I 2
	  /* 16 Bytes Header einlesen */
E 2
	  READ(&USER.len1,sizeof(USER.len1));
	  if ( USER.len1 != sizeof(USER.head) ) return CONVERTER_CORRUPTED;
D 2
	  WRITE(&USER.len1,sizeof(USER.len1));
E 2
	  READ(USER.head,sizeof(USER.head));
D 2
	  WRITE(USER.head,sizeof(USER.head));
E 2
	  READ(&USER.len2,sizeof(USER.len2));
D 2
	  WRITE(&USER.len1,sizeof(USER.len1));
E 2
	  if ( USER.len1 != USER.len2 ) return CONVERTER_CORRUPTED;
D 2
	  /* Fertig */
	  IF ( !USER.head[0] && !USER.head[1] && !USER.head[2] && !USER.head[3] ) 
	    NEXTEVENT();
	  ENDIF
	  /* Histogramm einlesen */
	  READ(&USER.len1,sizeof(USER.len1));
	  if ( USER.len1 <= 0 ) return CONVERTER_CORRUPTED;
	  WRITE(&USER.len1,sizeof(USER.len1));
	  COPY(USER.len1);
	  READ(&USER.len2,sizeof(USER.len2));
	  WRITE(&USER.len1,sizeof(USER.len1));
	  if ( USER.len1 != USER.len2 ) return CONVERTER_CORRUPTED;
        /* Das Ganze von vorne */
        RESET(&USER.mark);
E 2
I 2
     	  /* Bei einer Endkennung (erste vier Bytes 0) naechstes Histogramm nehmen */
     	  IF ( !USER.head[0] )
     	    RESET(&USER.mark);
          ENDIF
     	/* Daten weitergeben */
	WRITE(&USER.len1,sizeof(USER.len1));
	WRITE(USER.head,sizeof(USER.head));
	WRITE(&USER.len1,sizeof(USER.len1));
	/* Histogramm einlesen */
	READ(&USER.len1,sizeof(USER.len1));
D 8
	if ( USER.len1 <= 0 ) return CONVERTER_CORRUPTED;
E 8
I 8
	if ( USER.len1 < 0 ) return CONVERTER_CORRUPTED;
E 8
	WRITE(&USER.len1,sizeof(USER.len1));
	COPY(USER.len1);
	READ(&USER.len2,sizeof(USER.len2));
	WRITE(&USER.len1,sizeof(USER.len1));
	if ( USER.len1 != USER.len2 ) return CONVERTER_CORRUPTED;
        /* Das war es */
        NEXTEVENT();
E 2
ENDROUTINE()
E 1
