h62523
s 00058/00014/01436
d D 5.1 91/08/14 09:55:56 jochen 13 12
c Added 'udata' for INPUT/OUTPUT ; added mutliple input files
e
s 00001/00001/01449
d D 4.9 91/07/24 09:12:54 jochen 12 11
c Killing of output channels enhanced
e
s 00038/00002/01412
d D 4.8 91/07/19 17:05:41 jochen 11 10
c Flushing mechanisms added
e
s 00047/00004/01367
d D 4.7 91/06/12 17:10:46 jochen 10 9
c Support for output block padding added
e
s 00006/00001/01365
d D 4.6 91/06/05 18:05:36 jochen 9 8
c open no longer delayed
e
s 00023/00008/01343
d D 4.5 91/05/02 09:22:11 jochen 8 7
c Handling of crashing input channels enhanced
e
s 00003/00001/01348
d D 4.4 91/04/29 08:55:40 jochen 7 6
c Buffer handling for events greater than EVENTBUFFER corrected
e
s 00004/00000/01345
d D 4.3 91/03/09 16:12:43 jochen 6 5
c SIGPIPE ignored
e
s 00015/00015/01330
d D 4.2 91/03/07 09:43:41 jochen 5 4
c Using double in convinfo
e
s 00000/00000/01345
d D 4.1 91/02/28 12:08:12 jochen 4 3
c Using RPC numbers reserved by SUN
e
s 00009/00008/01336
d D 3.3 91/02/28 12:07:19 jochen 3 2
c Implementation completed
e
s 00001/00001/01343
d D 3.2 91/02/16 15:09:39 jochen 2 1
c RPC transfer data of type double checked against low bound 0.01
e
s 01344/00000/00000
d D 3.1 91/02/08 14:49:24 jochen 1 0
c SCCS version of converter for queuemanager version 3 created
e
u
U
t
T
I 1
/* %W% 91/02/08 Converter support for UNIX parallel batch queue manager */

#ifdef SCCSIDS
static char sccsid_definitions_h[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  Rahmenprogramm zur Programmierung von Konvertierprogrammen fuer die Parallelqueue.
*/
#include <math.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <limits.h>
#include <unistd.h>

#include <rpc/rpc.h>

#include <sys/uio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/times.h>
I 6
#include <sys/signal.h>
E 6
#include <sys/socket.h>
I 6
#include <sys/resource.h>
E 6
#include <sys/dg_sys_info.h>

#include <netinet/in.h>

#define GENERIC

#include <saphir/converter/sexec.h>
#include <saphir/converter/pipehead.h>


/*
  Alles bisher nicht vom Benutzer definierte MACRO-Definitionen nachholen.
*/
#ifndef BUFFERSIZE
#define BUFFERSIZE		(16*1024)
#endif

#ifndef TRANSFEROUTPUT
#define TRANSFEROUTPUT		BUFFERSIZE
#endif

#ifndef TRANSFERINPUT
#define TRANSFERINPUT		TRANSFEROUTPUT
#endif

#ifndef EVENTBUFFER
#define EVENTBUFFER		TRANSFEROUTPUT
#endif

I 10
#ifndef PAD
#define PAD(buf,len,done)	-1
#endif

E 10
#ifndef USERDATA
#define USERDATA		int nop;
#endif

#ifndef MAXNESTING
#define MAXNESTING		10
#endif

/*
  Vorwaertsdefinitionen.
*/
typedef struct channel_control chan;
typedef struct converter_control cdes;
typedef struct main_channel mchan;


/*
  Kontrollstruktur eines Kanals.
*/
struct buffer
       {
	char			*buf;	/* Datenbereich				*/
	int			size;	/* Allokatierte Groesse			*/
	int			rbuf;	/* Ab hier stehen Daten			*/
	int			wbuf;	/* Hier koennen Daten hin		*/
       };

struct channel_control
       {
	chan    		*next;	/* Naechstes Element			*/
	struct sockaddr_in	peer; 	/* Partner				*/
	int			fd;	/* Zugehoeriger Descriptor		*/
	int			delete;	/* Bei naechster Gelegenheit loeschen	*/
	double			created;/* Uhrzeit der Erzeugung		*/
	double			idleT;	/* Gesamtzeit Warten auf I/O		*/
D 5
	int			bytes;  /* Bisher uebertragenen Bytes		*/
	int			events;	/* Bisher uebertragenen Ereignisse	*/
E 5
I 5
	double			bytes;  /* Bisher uebertragenen Bytes		*/
	double			events;	/* Bisher uebertragenen Ereignisse	*/
E 5
	int			errors; /* Ignorierte Fehler			*/
	cdes			*inp;	/* Inputroutine 			*/
I 8
	int			clean;  /* 'iobuf' ist unzerstoert		*/
I 10
	int			padded; /* Daten komplett ?			*/
E 10
E 8
	struct buffer		iobuf;	/* Input/Output Buffer			*/
	struct buffer		evbuf;	/* Buffer fuer ein Event		*/
I 13
	char			*udata; /* Spielbereich fuer den Benutzer	*/
E 13
       };


/*
  Fuer den Benutzer sichtbare Kontrollstruktur.
*/
typedef struct mark_t
        {
	 int			state[MAXNESTING];
        } mark_t;

struct converter_control
       {
	char		*fbuf;		/* Speicheradresse      		*/
	int		flen;		/* Laenge des Speichers 		*/
	mark_t		state;		/* Aktueller Zustand    		*/
I 11
	int		flush;		/* Buffer nach jedem Event entleeren    */
E 11
	chan		*cinp;		/* Eigener Kanal			*/
	chan		*cout;		/* Zugehoeriger Ausgabekanal		*/
	int		action;		/* Was ist gerade zu tun		*/
	int		flags;		/* Operationsflags			*/
	char		*buf;		/* Temporaere Speicheradresse		*/
	int		rlen;		/* Noch zu uebertragen			*/
	struct {
		USERDATA
	       } 	user;		/* Benutzerdaten        		*/
       };

#define fERROR			(1<<0)
#define fEOF			(1<<1)
I 11
#define fFLUSH			(1<<2)
E 11


/*
  Verwaltungsstruktur eines primaeren Kanals.
*/
struct main_channel
       {
	int			fd;	/* Dateidescriptor			*/
	char			*name;	/* Dateiname				*/
	int			max;	/* Maximale Zahl von Kanaelen		*/
	int			anz;	/* Aktuelle Zahl von Kanaelen		*/
	int			done;	/* Waren schon mal Kanaele offen	*/
	chan			*prim;	/* Primaere Kanal			*/
	struct sockaddr_in	tcp;	/* TCP Informationen			*/
I 13
	int			index;	/* Index der laufende Nummer der Datei	*/
E 13
       };


/*
  Interne Konverterkonstanten.
*/
#define CONVERTER_OPEN		0
#define CONVERTER_CLOSE		1
#define CONVERTER_ACTION	2

#define CONVERTER_COUNT		3
#define CONVERTER_READ		4
#define CONVERTER_WRITE		5
#define CONVERTER_COPY		6
#define CONVERTER_DONE		7
#define CONVERTER_OK		8
#define CONVERTER_RESET		9

#define CONVERTER_CORRUPTED	-1
#define CONVERTER_MAXNESTING	-2
#define CONVERTER_NONESTING	-3

#define ERROR			0
#define NOERROR			1
#define ENDOFFILE		2
#define NOENDOFFILE		3
I 11
#define FLUSHENDOFFILE		4
#define NOFLUSHENDOFFILE	5
E 11


/*
  MACROs zum Erzeugen des Konvertierers.
*/
static int converter();
#define USER 			fd->user

#define ROUTINE()		static int converter(fd,act) cdes *fd; int act;\
				{ int state = fd->state.state[0], nest = 0; { 

#define OPEN()		        } if ( act == CONVERTER_OPEN ) { 

#define CLOSE()			} if ( act == CONVERTER_CLOSE ) {

#define ACTION()	        } if ( act == CONVERTER_ACTION ) {\
				  if ( !state ) {

#define READ(buf,len)		} if ( !state-- ) {\
				  fd->state.state[nest]++; fd->fbuf = (char *)(buf);\
				  if ( (fd->flen = (len)) < 0 ) return CONVERTER_CORRUPTED;\
			          return CONVERTER_READ;\
				} if ( !state ) {

#define WRITE(buf,len)		} if ( !state-- ) {\
  			          fd->state.state[nest]++; fd->fbuf = (char *)(buf);\
				  if ( (fd->flen = (len)) < 0 ) return CONVERTER_CORRUPTED;\
				  return CONVERTER_WRITE;\
				} if ( !state ) {

#define COPY(len)		} if ( !state-- ) {\
  			          fd->state.state[nest]++;\
				  if ( (fd->flen = (len)) < 0 ) return CONVERTER_CORRUPTED;\
			          return CONVERTER_COPY;\
				} if ( !state ) {

I 10
#define ATTACH()		WRITE((char *)0,0)

E 10
#define MARK(mp)		{ *(mp) = fd->state; }

#define RESET(mp)		} if ( !state-- ) {\
				  fd->state = *(mp);\
				  return CONVERTER_RESET;\
				} if ( 0 ) { 

#define IF(e)			} if ( !state-- ) {\
				  fd->state.state[nest]++; state = 0;\
				  if ( nest == (MAXNESTING-1) ) return CONVERTER_MAXNESTING;\
				  fd->state.state[nest+1] = 0;\
				  if ( !(e) ) { fd->state.state[nest]++; state = 1; }\
				} if ( !state-- ) {\
				  state = fd->state.state[++nest];\
				  if ( !state ) {
						
#define ELSE			} if ( !nest ) return CONVERTER_NONESTING;\
				  fd->state.state[--nest] += 2; state = 1;\
				} if ( !state-- ) {\
				  state = fd->state.state[++nest];\
				  if ( !state ) {

#define ENDIF			} if ( !nest ) return CONVERTER_NONESTING;\
				  fd->state.state[--nest]++; state = 0;\
				} if ( !state ) {

I 11
#define GETFLUSH()		fd->flush

#define FLUSHON()		{ fd->flush = 1; }

#define FLUSHOFF()		{ fd->flush = 0; }

E 11
#define NEXTEVENT()		} if ( !state-- ) {\
			 	  fd->state.state[nest]++;\
				  return CONVERTER_COUNT;\
				} if ( 0 ) { 

#define SETMODE(m)		{ if ( (m) == ERROR ) fd->flags |= fERROR; else\
				  if ( (m) == NOERROR ) fd->flags &= ~fERROR; else\
				  if ( (m) == ENDOFFILE ) fd->flags |= fEOF; else\
				  if ( (m) == NOENDOFFILE ) fd->flags &= ~fEOF; else\
I 11
				  if ( (m) == FLUSHENDOFFILE ) fd->flags |= fFLUSH; else\
				  if ( (m) == NOFLUSHENDOFFILE ) fd->flags &= ~fFLUSH; else\
E 11
				  return CONVERTER_CORRUPTED; }

#define NOMEM()			nomem()

I 10
#define INPUT(el)		fd->cinp->el

#define OUTPUT(el)		fd->cout->el

E 10
#define ENDROUTINE()		} } return CONVERTER_OK; }


/*
  Andere Hilfsmacros.
*/
#define PERROR(m)		{ perror(m); exit(1); }
#define MALLOC(t,n)		((t *)calloc(n,sizeof(t)))

#define PARAMETER(n)		(((n) >= 1) && ((n) <= margc) ? margv[n] : (char *)0)

#define ACTION_KILL		0
#define ACTION_AGAIN		1

#define KILLIT(msg)		{ printf(msg); return ACTION_KILL; }
#define QUEUEIT(ch,chp)		{ enqueue(ch,chp);return ACTION_AGAIN; }
#define QUEUEID(ch,chp)		{ enqueue(ch,chp);(ch)->idleT-=sysnow();return ACTION_AGAIN; }

#define advance(b,el,del)	{ if ( ((b).el += (del)) == (b).size ) (b).el = 0; }

#define iserror(ret,fd)		(((ret)&&((fd)->flags&fERROR))||(!(ret)&&((fd)->flags&fEOF)))

#define rdpos(b)		((b).buf+(b).rbuf)
#define wrpos(b)		((b).buf+(b).wbuf)

#define match_sin(a,b)		(((a)->sin_family == (b)->sin_family) &&\
				 ((a)->sin_port == (b)->sin_port) &&\
        			 ((a)->sin_addr.s_addr == (b)->sin_addr.s_addr))


/*
  Globale Variablen.
*/
static chan *frel = 0,*idle = 0,**fend = &frel,**iend = &idle,*opnl,**oend = &opnl;
static chan *wpend = 0,*rpend = 0,**wend = &wpend,**rend = &rpend;
static int margc,pfd = -1,reqID = -1,nconv,aconv = 0;
static converterchan *clist = 0;
static char **margv;
static mchan in,out;

static double sysnow();
static chan *crechan();
static cdes *crecdes();

D 13
extern char *calloc(),*malloc();
E 13
I 13
extern char *calloc(),*malloc(),*strchr();
E 13


/*
  Das Konvertierhauptprogramm.

  Aufruf: KONVERTER pipechannel requestID INinfo OUTinfo P1 P2 .. PN
*/
main(argc,argv)
int argc;
char **argv;
{
 double last = sysnow()-30.0,now;
 fd_set reads,writes;
 chan *new,*act,*cur;
 struct timeval tout;
 struct stat st;
 int len,rest;

I 6
 /* Vor Signalen bei geschlossenen Kanaelen schuetzen */
 signal(SIGPIPE,SIG_IGN);
E 6
 /* Globale Variable fuellen */
 if ( (margc = argc-5) < 0 ) 
  {
   printf("USAGE: %s <fd> <ID> <IN info> <OUT info> {<parameter>}\n",argv[0]);
   exit(1);
  }
 margv = argv+4;
 /* Parameter auswerten */
 if ( fstat(pfd = atoi(argv[1]),&st) == -1 )
  {
   printf("Channel fd=%s not usable\n",argv[1]);
   exit(1);
  }
 reqID = atoi(argv[2]);
 getinfo(argv[3],&in);
 getinfo(argv[4],&out);
I 13
 /* Kontrollabfrage */
 if ( out.name && strchr(out.name,',') )
  {
   printf("Multiple output filenames not allowed\n");
   exit(1);
  }
E 13
 /* Kanaele oeffnen */
 openinfo(&in,O_RDONLY);
 if ( !in.max ) 
  {
   /* Verketten */
   in.anz = in.done = 1;
   enqueue(new = in.prim = crechan(TRANSFERINPUT,0),&oend);
   /* Initialisierung beenden */
   new->fd = in.fd;
   /* Konverterroutine erzeugen */
   (new->inp = crecdes())->cinp = new;
  }
 openinfo(&out,O_WRONLY|O_CREAT|O_TRUNC);
 if ( out.name )
  {
   /* Verketten */
   out.anz = out.done = 1;
   enqueue(new = out.prim = crechan(TRANSFEROUTPUT,EVENTBUFFER),&fend);
   new->idleT -= sysnow();
   /* Initialisierung beenden */
   new->fd = out.fd;
  }
 /* Parameter anzeigen */
 printf("Converter %s started: fd=%d reqID=%08X\n",argv[0],pfd,reqID);
 showinfo("IN",&in);
 showinfo("OUT",&out);
 /* Die ewige Schleife */
 for ( ; ; )
  {
   /* Bitfelder aufsetzen */
   FD_ZERO(&reads);
   FD_ZERO(&writes);
   /* Eingabe wird im Binaermode fuer Kontrollaufgaben genutzt */
   FD_SET(0,&reads);
   /* Eingabekanal */
   if ( in.max ) FD_SET(in.fd,&reads);
   /* Ausgabekanal */
   if ( out.max ) FD_SET(out.fd,&reads);
   /* Warten auf Eingabedaten */
   for ( cur = rpend ; cur ; cur = cur->next ) FD_SET(cur->fd,&reads);
   /* Warten auf Ausgabe moeglich */
   for ( cur = wpend ; cur ; cur = cur->next ) FD_SET(cur->fd,&writes);
   /* Wartezeit ermitteln */
   if ( ((now = sysnow())-last) > 29.99 )
    {
     /* Zeit ist abgelaufen */
     periodic();
     last = now;
    }
   /* In die entsprechende Struktur fuellen */
   if ( opnl )
    tout.tv_sec = tout.tv_usec = 0;
   else
    {
     now = 30.0-(now-last);
     if ( (tout.tv_usec = 1.0E6*(now-(tout.tv_sec = floor(now)))) == 1000000 )
      {
       tout.tv_sec++;
       tout.tv_usec = 0;
      }
    }
   /* Warten */
   switch (select(FD_SETSIZE,&reads,&writes,(fd_set *)0,&tout))
    {
     case -1 : PERROR("Select() failed");
     case  0 : /* Zeit ist abgelaufen */
       	       if ( tout.tv_sec || tout.tv_usec )
		{
		 /* Ausfuehren */
		 periodic();
       	         last = sysnow();
	        }
       	       else
		/* Wartende Kanaele bearbeiten */
		waitings();
       	       continue;
    }
   /* Auf jeden Fall die Warteliste leeren (nur beim ersten Durchlauf relevant) */
   waitings();
   /* Kontrollaufgaben erledigen */
   if ( FD_ISSET(0,&reads) ) control();
   /* TCP-Verbindungen aufbauen (INPUT) */
   checknew(0,&in,&reads);
   /* TCP-Verbindungen aufbauen (OUTPUT) */
   checknew(1,&out,&reads);
   /* Hinausgehende Daten bearbeiten */
   for ( cur = wpend, wpend = 0, wend = &wpend ; act = cur ; )
    {
     /* Naechsten Schleifendurchlauf vorbereiten */
     cur = act->next;
     /* Bei Fehler aufhoeren */
     if ( !FD_ISSET(act->fd,&writes) )
      {
       /* Spaeter nochmal versuchen */
       enqueue(act,&wend);
       continue;
      }
     /* Daten schreiben */
     if ( rest = rdrest(&act->iobuf) )
      switch (len = write(act->fd,rdpos(act->iobuf),rest))
       {
        case -1 : /* Spaeter nochmal probieren */
	  	  if ( errno == EAGAIN )
	 	   {
		    enqueue(act,&wend);
		    continue;
		   }
		  /* Schreibfehler */
        case  0 : /* Merkwuerdig, 0 sollte nur bei 'read' auftreten */
		  /* Fehler auswerten */
		  printf("\nOutput channel lost: write error\n");
		  if ( deleted(act) ) continue;
		  break;
        default : /* Informationen aktualisieren */
	  	  act->bytes += len;
		  advance(act->iobuf,rbuf,len);
       }
     /* Eventuell nochmal probieren */
     if ( (act->iobuf.wbuf != act->iobuf.rbuf) || 
	  (rdrest(&act->evbuf) && (!evflush(act) || (act->delete == 2))) )
      {
       /* Soviele Eventdaten wie moeglich uebernehmen */
D 7
       if ( act->iobuf.wbuf == act->iobuf.rbuf ) evflush(act);
E 7
I 7
       evflush(act);
E 7
       /* Selben Eintrag noch einmal bearbeiten */
       cur = act;
       continue;
      }
     /* Routine aufrufen */
     if ( act->inp )
      {
       if ( call_converter(act->inp) == ACTION_KILL ) kill_converter(act->inp);
       continue;  
      }
     /* Loeschen oder in die Liste freier Ausgabekanaele */
     if ( act->delete )
      {
       if ( act->delete == 2 ) printf("\nOutput channel terminated normally\n");
       delchan(act,1);
      }
     else 
      {
       enqueue(act,&fend);
       act->idleT -= sysnow();
      }
    }
   /* Hereinkommende Daten bearbeiten */
   for ( cur = rpend, rpend = 0, rend = &rpend ; act = cur ; )
    {
     /* Naechsten Aufruf vorbereiten */
     cur = act->next;
     act->iobuf.rbuf = 0;
     /* Datenbereitschaft abfragen */
     if ( !FD_ISSET(act->fd,&reads) )
      {
       /* Spaeter noch einmal probieren */
       enqueue(act,&rend);
       continue;
      }
     /* Daten einlesen */
     switch (act->iobuf.wbuf = read(act->fd,rdpos(act->iobuf),act->iobuf.size-1))
      {
       case -1 : /* Spaeter nochmal probieren */
	 	 if ( errno == EAGAIN )
	 	  {
		   enqueue(act,&rend);
		   continue;
		  }
		 /* Lesefehler */
       case  0 : /* Ende der Datei */
I 13
	 	 if ( in.name && !act->iobuf.wbuf && *(in.name+in.index) )
		  {
		   /* Datei ist beendet, jetzt kommt die naechste */
		   close(act->fd);
		   /* Neu oeffnen */
		   openinfo(&in,O_RDONLY);
		   /* Und dasselbe noch einmal */
		   cur = act;
		   continue;
		  }
	 	 /* Allgemeine Fehler */
E 13
	 	 if ( !in.name || iserror(act->iobuf.wbuf,act->inp) )
		  {
	   	   /* Fehler melden */
		   if ( !act->iobuf.wbuf )
		    printf("\nInput channel closed: end of file\n");
		   else
		    {
		     fflush(stdout);
		     perror("\nInput channel closed");
		    }
I 11
		   /* Eventuell Ausgabekanal sauber schliessen */
		   if ( !act->iobuf.wbuf && act->inp->cout && (act->inp->flags&fFLUSH) )
		    {
		     chan *out = act->inp->cout;

		     /* Verbindung loesen - siehe auch CONVERTER_COUNT */
		     act->inp->cout = 0;
		     out->inp = 0;
		     /* Events zaehlen */
		     act->events += 1.0;
		     out->events += 1.0;
		     /* Weitere Bearbeitung erfolgt asynchron */
		     if ( out->delete == 1 )
		      delchan(out,1);
		     /* Eventbuffer entleeren */
		     else if ( evflush(out) && !out->delete && !act->inp->flush )
		      {
		       enqueue(out,&fend);
		       out->idleT -= sysnow();
		      }
		     else
		      enqueue(out,&wend);
		    }
E 11
		   /* Entfernen */
	           kill_converter(act->inp);
		  }
		 else
		  {
		   /* Warnung ausgeben */
		   if ( !act->iobuf.wbuf )
		    printf("\nInput end of file ignored\n");
		   else
		    {
		     fflush(stdout);
		     perror("\nInput error ignored");
		    }
		   act->errors++;
		   /* Fehler beim Lesen aus einer Datei wurde ignoriert, Datei neu oeffnen */
		   if ( !act->iobuf.wbuf )
		    {
		     /* Datei schliessen */
		     close(act->fd);
		     /* Datei neu oeffnen */
		     if ( (act->fd = open(in.name,O_RDONLY|O_NDELAY)) == -1 )
		      {
		       /* So geht es nicht */
		       printf("Input file %s could not be reopened\n",in.name);
		       /* Aufhoeren mit diesem Kanal */
		       kill_converter(act->inp);
		       continue;
		      }
		    }
		   /* Fehler ignorieren */
		   cur = act;
		  }
	 	 continue;
      }
     /* Zaehler aktualisieren */
     act->bytes += act->iobuf.wbuf;
     /* Routine aufrufen */
     if ( call_converter(act->inp) == ACTION_KILL ) kill_converter(act->inp);
    }
   /* Verbindungen herstellen */
   if ( idle && frel )
    for ( cur = idle, idle = 0, iend = &idle ; act = cur ; )
     {
      /* Naechsten Durchlauf vorbereiten */
      cur = act->next;
      /* Eventuell direkt neu verketten */
      if ( !frel )
       enqueue(act,&iend);
      else
       {
        /* Statistik aktualisieren */
	act->idleT += sysnow();
        /* Routine aufrufen */
        if ( call_converter(act->inp) == ACTION_KILL ) kill_converter(act->inp);
       }
     }
   /* Wartende Kanaele bearbeiten */
   waitings();
   /* Eventuell aufhoeren */
   if ( ((in.done && !in.anz) || (out.done && !out.anz)) && !rpend && !wpend )
    {
     /* Wartende Ausgabekanaele schliessen und Statistik ausgeben */
     for ( cur = frel, frel = 0, fend = &frel ; act = cur ; )
      {
       /* Naechsten Durchlauf vorbereiten */
       cur = act->next;
       /* Statistik beenden */
       act->idleT += sysnow();
       /* Eventuell neu verketten */
       if ( rdrest(&act->iobuf) )
	/* Und rausschreiben */
	enqueue(act,&wend);
       else
        /* Loeschen */
        delchan(act,1);
      }
     /* Spaeter noch einmal nachsehen, wenn alle Buffer geleert sind */
     if ( wpend ) continue;
     /* Wartende Eingabekanaele schliessen und Statistik ausgeben */
     for ( cur = idle ; act = cur ; )
      {
       /* Naechsten Durchlauf vorbereiten */
       cur = act->next;
       /* Statistik beenden */
       act->idleT += sysnow();
       /* Loeschen */
       delchan(act,0);
      }
     /* Konverter beenden */
     printf("\nConverter terminated normally\n");
     exit(0);
    }
  }
}

/* 
  Informationsparameter auswerten
*/
static getinfo(info,desc)
char *info;
mchan *desc;
{
 /* Initialisieren */
 desc->anz = desc->done = 0;
 desc->prim = 0;
 /* Parameter auswerten */
 switch (*info++)
  {
   case 'F' : /* Angeschlossen ist eine Datei */
     	      if ( !*(desc->name = info) )
	       {
		printf("Illegal empty filename\n");
		exit(1);
	       }
D 13
	      desc->max = 0;
E 13
I 13
	      desc->max = desc->index = 0;
E 13
	      return;
   case 'P' : /* Angeschlossen ist ein Programm */
     	      if ( (desc->max = atoi(info)) < 1 )
	       {
	        printf("Illegal number %s\n",info);
		exit(1);
	       }
	      desc->name = 0;
	      return;
   case 'N' : /* Nichts ist angeschlossen */
     	      desc->name = 0;
	      desc->max = 0;
I 13
	      desc->index = -1;
E 13
	      return;
   default  : /* Nanu */
     	      printf("Illegal info %s, legal are F<file>, P<number> or N\n",info-1);
	      exit(1);
  }
}

/*
  Verbindungskanal aufbauen.
*/
static openinfo(desc,flags)
mchan *desc;
int flags;
{
 int len = sizeof(desc->tcp),nblk = 1;

 /* Programmkanal */
 if ( !desc->name )
  {
   /* Kein Kanal */
   if ( !desc->max ) return (desc->fd = -1);
   /* TCP-Kanal aufbauen */
   if ( (desc->fd = socket(AF_INET,SOCK_STREAM,0)) == -1 ) PERROR("Creating TCP socket");
   /* TCP-Verbindung herstellen */
   desc->tcp.sin_family = AF_INET;
   desc->tcp.sin_addr.s_addr = htonl(INADDR_ANY);
   desc->tcp.sin_port = htons(0);
   if ( bind(desc->fd,&desc->tcp,len) == -1 ) PERROR("Binding TCP socket");
   /* Eigene Adresse auslesen */
   if ( getsockname(desc->fd,&desc->tcp,&len) == -1 ) PERROR("Reading TCP port");
   desc->tcp.sin_addr.s_addr = gethostid();
   /* Kanal auf nicht blockierend stellen */
   if ( ioctl(desc->fd,FIONBIO,&nblk) == -1 ) PERROR("Could not unblock TCP socket");
   /* Die Ohren aufsperren */
   if ( listen(desc->fd,5) == -1 ) PERROR("Listening to TCP port");
  }
 /* Normale Datei */
D 9
 else if ( (desc->fd = open(desc->name,flags|O_NDELAY,0744)) == -1 )
E 9
I 9
D 13
 else if ( (desc->fd = open(desc->name,flags,0744)) == -1 )
E 9
  {
   printf("Could not open file %s\n",desc->name);
   exit(1);
  } 
I 9
 else if ( fcntl(desc->fd,F_SETFL,O_NDELAY) == -1 )
  {
   printf("Could not unblock file %s\n",desc->name);
   exit(1);
E 13
I 13
 else
  { 
   char *next;

   /* Naechsten Dateinamen suchen */
   if ( next = strchr(desc->name+desc->index,',') ) *next = '\0';
   /* Datei oeffnen und preparieren */
   if ( (desc->fd = open(desc->name+desc->index,flags,0744)) == -1 )
    {
     printf("Could not open file %s\n",desc->name+desc->index);
     exit(1);
    } 
   else if ( fcntl(desc->fd,F_SETFL,O_NDELAY) == -1 )
    {
     printf("Could not unblock file %s\n",desc->name+desc->index);
     exit(1);
    }
   /* Zaehler fuer die naechste Datei aufsetzen */
   if ( next )
    {
     /* Aufsetzen */
     *next++ = ',';
     desc->index = next-desc->name;
     /* Testen auf Leerstring */
     if ( !*(desc->name+desc->index) )
      {
       printf("Illegal empty filename\n");
       exit(1);
      }
    }
   else
    desc->index += strlen(desc->name+desc->index);
E 13
  }
E 9
 /* Fertig */
 return desc->fd;
}

/*
  Situation anzeigen.
*/
showinfo(pref,desc)
char *pref;
mchan *desc;
{
 if ( desc->name )
D 13
  printf("\t%sfile[%d]=%s\n",pref,desc->fd,desc->name); 
E 13
I 13
  printf("\t%sfile(s)[%d]=%s\n",pref,desc->fd,desc->name); 
E 13
 else if ( desc->max ) 
  printf("\t%smax[%d]=%d@%d\n",pref,desc->fd,desc->max,ntohs(desc->tcp.sin_port));
 else
  printf("\tno%s\n",pref);
}

/*
  Aktuelle Systemzeit auslesen
*/
static double sysnow()
{
 struct timeval tod;

 /* Uhrzeit auslesen */
 gettimeofday(&tod,(struct timezone *)0);
 /* Ergebnis melden */
 return (tod.tv_sec+1.0E-6*tod.tv_usec);
}

/* 
  Speicherbereich fuer einen Kanal erzeugen und initialisieren.
*/
static chan *crechan(size,esize)
int size,esize;
{
 chan *nc;

 /* Speicher erzeugen */
 if ( !(nc = MALLOC(chan,1)) || 
      !(nc->iobuf.buf = MALLOC(char,size)) ||
      !(nc->evbuf.buf = MALLOC(char,esize)) )
  nomem();
 /* Speicher initialisieren */
 nc->next = 0;
 nc->fd = -1;
 nc->iobuf.size = size;
 nc->evbuf.size = esize;
D 8
 nc->delete = nc->iobuf.rbuf = nc->iobuf.wbuf = nc->evbuf.rbuf = nc->evbuf.wbuf = 0;
E 8
I 8
 nc->delete = nc->clean = 0;
D 10
 nc->iobuf.rbuf = nc->iobuf.wbuf = nc->evbuf.rbuf = nc->evbuf.wbuf = 0;
E 10
E 8
I 5
 nc->bytes = nc->events = nc->idleT = 0.0;
I 10
 nc->iobuf.rbuf = nc->iobuf.wbuf = nc->evbuf.rbuf = nc->evbuf.wbuf = 0;
E 10
E 5
 nc->peer.sin_family = AF_INET;
 nc->peer.sin_addr.s_addr = htonl(INADDR_ANY);
 nc->peer.sin_port = htons(0);
I 10
 nc->errors = nc->padded =0;
E 10
D 5
 nc->inp = 0;
 nc->idleT = 0.0;
 nc->bytes = nc->events = nc->errors = 0;
E 5
 nc->created = sysnow();
I 5
D 10
 nc->errors = 0;
E 10
 nc->inp = 0;
I 13
 nc->udata = 0;
E 13
E 5
 /* Ergebnis melden */
 return nc;
}

/*
  Speicher freigeben.
*/
static delchan(oc,mode)
chan *oc;
int mode;
{
 static char *msg[][2] = { { "In", "Out" }, { "from", "to" } };
 mchan *desc = (mode == 1) ? &out : &in;
 time_t snow = time((time_t *)0),work;
 double now = sysnow(),dt;

 /* Statistik ausgeben */
 if ( mode != -1 )
  {
I 10
   /* Das war eventuell noch nicht der letzte Streich */
   if ( !mode || !oc->events || (oc->delete == 1) )
    oc->padded = 1;
   else if ( padbuffer(oc) )
    {
     /* Schauen wir uns das spaeter noch einmal an */
     enqueue(oc,&wend);
     return;
    }
E 10
   /* Kanalzaehler aktualisieren */
   desc->anz--;
   /* Ueberschrift */
   printf("\n%sput channel ",msg[0][mode]);
   if ( desc->name )
D 13
    printf("%s file %s\n",msg[1][mode],desc->name);
E 13
I 13
    printf("%s file(s) %s\n",msg[1][mode],desc->name);
E 13
   else if ( desc->max )
    printf("%s TCP/IP %s,%d\n",
	   msg[1][mode],inet_ntoa(oc->peer.sin_addr),ntohs(oc->peer.sin_port));
   else
    printf("\n");
   /* Zeiten */
   work = snow-(dt = now-oc->created);
   printf("\tCreated %s",ctime(&work));
   printf("\tDeleted %s",ctime(&snow));
   if ( dt > 0.01 ) printf("\tWaiting for connection:%8.2f%%\n",oc->idleT*100.0/dt);
   /* Fehler */
   if ( oc->errors ) printf("\tNumber of errors or end-of-files ignored: %d\n",oc->errors);
   /* Daten */
D 5
   printf("\t%d Event(s) with %d byte(s)\n",oc->events,oc->bytes);
E 5
I 5
   printf("\t%.0f Event(s) with %.0f byte(s)\n",oc->events,oc->bytes);
E 5
   /* Eventgroesse */
D 5
   if ( oc->events ) printf("\t\tByte(s)/event:%11d\n",oc->bytes/oc->events);
E 5
I 5
   if ( oc->events ) printf("\t\tByte(s)/event:%15.0f\n",oc->bytes/oc->events);
E 5
   /* Raten */
   if ( dt > 0.01 )
    {
D 5
     printf("\t\tEvent(s)/sec:%12d\n",(int)(oc->events/dt+0.5));
     printf("\t\tByte(s)/sec: %12d\n",(int)(oc->bytes/dt+0.5));
E 5
I 5
     printf("\t\tEvent(s)/sec:%16.0f\n",oc->events/dt);
     printf("\t\tByte(s)/sec: %16.0f\n",oc->bytes/dt);
E 5
    }
  }
 /* Datei schliessen */
 if ( oc->fd != -1 ) close(oc->fd);
 /* Alle Speicherteile freigeben */
 free(oc->iobuf.buf);
 free(oc->evbuf.buf);
 free(oc);
}

/*
  Kanal loeschen oder zum Loeschen vorbereiten.
*/
static deleted(oc)
chan *oc;
{
I 10
 /* Zum Loeschen markieren */
 oc->delete = 1;
E 10
 /* Kann entfernt werden */
 if ( !oc->inp )
  {
I 10
   /* Nicht mehr auffuellen, nur loeschen */
E 10
   delchan(oc,1);
   return 1;
  }
D 10
 /* Zum Loeschen markieren */
 oc->delete = 1;
E 10
I 10
 /* Buffer eleminieren */
E 10
D 8
 oc->iobuf.wbuf = oc->iobuf.rbuf = oc->evbuf.wbuf = oc->evbuf.rbuf = 0;
E 8
I 8
 oc->iobuf.wbuf = oc->iobuf.rbuf = oc->evbuf.wbuf = oc->evbuf.rbuf = oc->clean = 0;
E 8
 return 0;
}

/*
  Speicher fuer eine Konverterkontrollstruktur erzeugen und initialisieren.
*/
static cdes *crecdes()
{
 cdes *nf;

 /* Speicher reservieren */
 if ( !(nf = MALLOC(cdes,1)) ) nomem();
 /* Speicher initialisieren */
 nf->fbuf = 0;
 nf->flags = fERROR|fEOF;
D 11
 nf->flen = nf->state.state[0] = 0;
E 11
I 11
 nf->flen = nf->state.state[0] = nf->flush = 0;
E 11
 nf->cinp = nf->cout = 0;
 nf->action = CONVERTER_RESET;
 /* Benutzerbereich initialisieren */
 if ( converter(nf,CONVERTER_OPEN) != CONVERTER_OK )
  {
   /* Schwerer Fehler */
   printf("\nConverter could not initialize, aborted\n");
   exit(4);
  }
 /* Ergebnis melden */
 return nf;
}

/*
  Speicher fuer eine Konverterkontrollstruktur zerstoeren.
*/
static delcdes(of)
cdes *of;
{
 /* Benutzerbereich loeschen */
 converter(of,CONVERTER_CLOSE);
 /* Speicher freigeben */
 free(of);
}

/*
  Schwerer Fehler: kein Speicher mehr vorhanden.
*/
static nomem()
{
 printf("\nOut of memory, converter aborted\n");
 exit(2);
}

/*
  Wartende Kanaele bearbeiten.
*/
static waitings()
{
 chan *act,*cur;

 /* Auf die ganz harte Tour */
 while ( cur = opnl )
  /* Liste durchgehen */
  for ( opnl = 0, oend = &opnl ; act = cur ; )
   {
    /* Naechsten Durchlauf vorbereiten */
    cur = act->next;
    /* Konverter aufrufen */
    if ( call_converter(act->inp) == ACTION_KILL ) kill_converter(act->inp);
   }
}

/*
  Neuen TCP-Kanal oeffnen.
*/
static checknew(out,desc,reads)
int out;
mchan *desc;
fd_set *reads;
{
 int len,nblk = 1;
 chan *new;

 /* Geht das denn */
 if ( desc->name || !FD_ISSET(desc->fd,reads) ) return;
 /* Kanalstruktur erzeugen */
 if ( out ) 
  new = crechan(TRANSFEROUTPUT,EVENTBUFFER);
 else
  new = crechan(TRANSFERINPUT,0);
 /* Verbindung einlesen */
 len = sizeof(new->peer);
 if ( (new->fd = accept(desc->fd,&new->peer,&len)) == -1 )
  {
   delchan(new,-1);
   return;
  }
 /* Verbindung vorbereiten */
 if ( (desc->anz == desc->max) || (ioctl(new->fd,FIONBIO,&nblk) == -1) )
  {
   /* Das war wohl nichts */
   delchan(new,-1);
   return;
  }
 desc->anz++;
 desc->done = 1;
 /* Ausgabekanaele spaeter bearbeiten */ 
 if ( out )
  {
   enqueue(new,&fend);
   new->idleT -= sysnow();
  }
 else
  {
   /* Initialisierung beenden */
   (new->inp = crecdes())->cinp = new;
   /* Neue Verbindung verketten */
   enqueue(new,&oend);
  }
}

/*
  Konverteroperation durchfuehren. Um unnoetige Locks der Eingangskanaele zu verhindern
  sollte der Eventbuffer der Ausgangskanaele so dimensioniert sein, dass er zumindest
  ein komplettes Event aufnehmen kann.
*/
static call_converter(fd)
cdes *fd;
{
 int rest,rest2;

 for ( ; ; )
  {
   /* Transferaktionen beenden */
   if ( fd->action == CONVERTER_READ )
    {
     /* Nachsehen, ob es einen Eingabekanal ueberhaupt gibt */
     if ( !in.name && !in.max ) KILLIT("\nConverter killed: no input channel\n");
     /* Nachsehen, ob Daten vorhanden sind */
     if ( !(rest = rdrest(&fd->cinp->iobuf)) ) QUEUEIT(fd->cinp,&rend);
     if ( rest > fd->rlen ) rest = fd->rlen;
     /* Daten kopieren */
     memmove(fd->buf,rdpos(fd->cinp->iobuf),rest);
     advance(fd->cinp->iobuf,rbuf,rest);
     /* Informationen uebertragen */
     fd->buf += rest;
     if ( fd->rlen -= rest ) continue;
    }
   else if ( fd->action == CONVERTER_WRITE )
    {
     /* Ausgabekanaele muessen existieren */
     if ( !out.name && !out.max ) KILLIT("\nConverter killed: no output channel\n");
     /* Verbindung herstellen */
     if ( !lookup(fd) ) QUEUEID(fd->cinp,&iend);
     /* Nur durchfuehren, wenn noch kein schwerer Fehler aufgetreten ist */
     if ( fd->cout->delete != 1 ) 
      {
       /* Buffergroesse ermitteln, eventuell Buffer entleeren */
       while ( !(rest = wrrest(&fd->cout->evbuf)) )
	if ( !evflush(fd->cout) ) 
	 QUEUEIT(fd->cout,&wend);
       if ( rest > fd->rlen ) rest = fd->rlen;
       /* Daten einfach kopieren */
       memmove(wrpos(fd->cout->evbuf),fd->buf,rest);
       advance(fd->cout->evbuf,wbuf,rest);
       /* Informationen uebertragen */
       fd->buf += rest;
       if ( fd->rlen -= rest ) continue;
      }
    }
   else if ( fd->action == CONVERTER_COPY )
    {
     /* Kanaele muessen existieren */
     if ( (!in.name && !in.max) || (!out.name && !out.max) )
      KILLIT("\nConverter killed: no input and/or no output channel\n");
     /* Verbindung herstellen */
     if ( !lookup(fd) ) QUEUEID(fd->cinp,&iend);
     /* Eventuell nur lesen */
     if ( fd->cout->delete == 1 )
      {
       /* Nachsehen, ob Daten vorhanden sind */
       if ( !(rest = rdrest(&fd->cinp->iobuf)) ) QUEUEIT(fd->cinp,&rend);
       if ( rest > fd->rlen ) rest = fd->rlen;
       /* Vorgeben, die Daten zu kopieren */
       advance(fd->cinp->iobuf,rbuf,rest);
      }
     else
      {
       /* Platz im Schreibbuffer ermitteln */
       while ( !(rest = wrrest(&fd->cout->evbuf)) )
	if ( !evflush(fd->cout) ) 
	 QUEUEIT(fd->cout,&wend);
       /* Platz im Lesebuffer ermitteln */
       if ( !(rest2 = rdrest(&fd->cinp->iobuf)) ) QUEUEIT(fd->cinp,&rend);
       /* Zaehler korrigieren */
       if ( rest > rest2 ) rest = rest2;
       if ( rest > fd->rlen ) rest = fd->rlen;
       /* Daten kopieren */
       memmove(wrpos(fd->cout->evbuf),rdpos(fd->cinp->iobuf),rest);
       advance(fd->cinp->iobuf,rbuf,rest);
       advance(fd->cout->evbuf,wbuf,rest);
      }
     /* Informationen eintragen */
     if ( fd->rlen -= rest ) continue;
    }
   /* Neu Aktion starten */
   switch (fd->action = converter(fd,CONVERTER_ACTION))
    {
     case CONVERTER_READ      :
     case CONVERTER_WRITE     :
     case CONVERTER_COPY      : /* Daten in temporaere Variablen kopieren */
				fd->buf = fd->fbuf;
				fd->rlen = fd->flen;
     case CONVERTER_RESET     : /* Routine erneut aufrufen */
       				break;
     case CONVERTER_COUNT     : /* Ereignisse mitzaehlen */
D 5
				fd->cinp->events++;
E 5
I 5
				fd->cinp->events += 1.0;
E 5
				/* Dito fuer die Ausgabeseite */
				if ( fd->cout ) 
				 {
D 5
				  fd->cout->events++;
E 5
I 5
				  fd->cout->events += 1.0;
E 5
				  /* Ausgabe hat jetzt erst einmal zu tun */
				  fd->cout->inp = 0;
				  /* Weitere Bearbeitung erfolgt asynchron */
				  if ( fd->cout->delete == 1 )
				   delchan(fd->cout,1);
				  /* Eventbuffer entleeren */
D 11
				  else if ( evflush(fd->cout) && !fd->cout->delete )
E 11
I 11
				  else if ( evflush(fd->cout) && 
					    !fd->cout->delete && !fd->flush )
E 11
				   {
				    enqueue(fd->cout,&fend);
				    fd->cout->idleT -= sysnow();
				   }
				  else
				   enqueue(fd->cout,&wend);
				  /* Verbindung freigeben */
				  fd->cout = 0;
				 }
				/* Naechstes Event bearbeiten */
				fd->state.state[0] = 0;
				fd->action = CONVERTER_RESET;
				/* Anderen Kanaelen eine Chance geben */
				enqueue(fd->cinp,&oend);
				return ACTION_AGAIN;
     case CONVERTER_DONE      : /* Konverter sauber beenden */
       				KILLIT("\nConverter killed: normal termination\n");
     case CONVERTER_CORRUPTED : /* Daten nicht in Ordnung */
       				KILLIT("\nConverter killed: data corrupted\n");
     case CONVERTER_MAXNESTING: /* Zu tief verschachtelte IFs */
       				printf("\nConverter killed: too deeply nested IFs\n");
				exit(4);
     case CONVERTER_NONESTING : /* ENDIF oder ELSE ohne IF */
       				printf("\nConverter killed: ELSE/ENDIF used without IF\n");
				exit(4);
     default		      : /* Konverterprogramm ist nicht in Ordnung */
       			        printf("\nFatal converter error, converter aborted\n");
			        exit(4);
    }
  }
}

/*
  Verbindung einer Inputkonverterroutine mit einem Ausgangskanal.
*/
static lookup(fd)
cdes *fd;
{
 /* Hat schon eine Verbindung */
 if ( fd->cout ) return 1;
 /* Kann keine bekommen, muss in die Warteschlange */
 if ( !frel ) return 0;
 /* Erstes Element holen */
 if ( !(frel = (fd->cout = frel)->next) ) fend = &frel;
I 7
 /* Kanal sperren */
 fd->cout->inp = fd;
E 7
 /* Statistik aktualisieren */
 fd->cout->idleT += sysnow();
I 8
 fd->cout->clean = 1;
E 8
 /* Erfolg melden */
 return 1;
}

/*
  Entfernen eines Kontrollblocks aus der allgemeinen Verwaltung.
*/
static kill_converter(fd)
cdes *fd;
{
 /* Eingabekanal */
 if ( fd->cinp ) delchan(fd->cinp,0);
 /* Ausgabekanal */
 if ( fd->cout ) 
D 8
  if ( (fd->cout->delete != 1) && rdrest(&fd->cout->iobuf) )
E 8
I 8
D 12
  if ( (fd->cout->delete == 1) || !rdrest(&fd->cout->iobuf) )
E 12
I 12
  if ( (fd->cout->delete == 1) && !rdrest(&fd->cout->iobuf) )
E 12
   /* Sofort loeschen */
   delchan(fd->cout,1);
  else
E 8
   {
    /* Buffer leerschreiben */
D 8
    if ( !fd->cout->delete ) fd->cout->delete = 1;
E 8
I 8
    if ( !fd->cout->delete && !fd->cout->clean ) fd->cout->delete = 1;
E 8
    fd->cout->inp = 0;
    enqueue(fd->cout,&wend);
    /* Eventbuffer nicht mehr beruecksichtigen */
    fd->cout->evbuf.rbuf = fd->cout->evbuf.wbuf = 0;
   }
D 8
  else
   /* Sofort loeschen */
   delchan(fd->cout,1);
E 8
 /* Und der Kontrollblock */
 delcdes(fd);
}

/*
  Platz im Buffer von der aktuellen Schreibposition an.
*/
static wrrest(b)
struct buffer *b;
{
 int len;

 /* Buffer ist leer */
 if ( b->wbuf == b->rbuf ) b->rbuf = b->wbuf = 0;
 /* Groesse ermitteln */
 if ( (len = b->rbuf-b->wbuf-1) < 0 ) len += b->size;
 if ( (b->wbuf+len) > b->size ) len = b->size-b->wbuf;
 /* Laenge melden */
 return len;
}

/*
  Daten im Buffer ermitteln.
*/
static rdrest(b)
struct buffer *b;
{
 int len;

 /* Groesse ermitteln */
 if ( (len = b->wbuf-b->rbuf) < 0 ) len += b->size;
 if ( (b->rbuf+len) > b->size ) len = b->size-b->rbuf;
 /* Ergebnis melden */
 return len;
}

/*
  Daten aus dem Eventbuffer in den Schreibbuffer kopieren.
*/
static evflush(oc)
chan *oc;
{
 int iorest,evrest;

 /* Bis zum bitteren Ende */
 while ( evrest = rdrest(&oc->evbuf) )
  {
   /* Geht das denn noch */
   if ( !(iorest = wrrest(&oc->iobuf)) ) return 0;
   /* Kopieren */
   if ( evrest > iorest ) evrest = iorest;
   memmove(wrpos(oc->iobuf),rdpos(oc->evbuf),evrest);
   advance(oc->iobuf,wbuf,evrest);
   advance(oc->evbuf,rbuf,evrest);
I 8
   /* 'iobuf' ist jetzt nicht mehr sauber */
   oc->clean = 0;
E 8
  }
 /* Buffer ist leer */
 return 1;
}

/*
  Kanalkontrollblock an eine Liste anhaengen.
*/
static enqueue(cc,lppp)
chan *cc,***lppp;
{
 /* Anhaengen */
 **lppp = cc;
 *lppp = &cc->next;
 /* Liste abschliessen */
 cc->next = 0;
}

/*
  Kontrollaufgaben erledigen.
*/
static control()
{
I 8
 int done = 0,ix,len,abort = 0;
E 8
 struct sockaddr_in whom;
I 3
D 8
 int done = 0,ix,len;
E 8
E 3
 chan *cur,*act;
I 8
 short port;
E 8
D 3
 int done = 0;
E 3

 /* Block einlesen */
D 3
 if ( read(0,&whom,sizeof(whom)) != sizeof(whom) )
  {
   /* Fehler ausgeben */
   printf("\nControl channel crashed, converter aborted\n");
   exit(3);
  }
E 3
I 3
 for ( ix = 0 ; ix < sizeof(whom) ; ix += len )
  if ( (len = read(0,((char *)&whom)+ix,sizeof(whom)-ix)) <= 0 )
   {
    /* Fehler ausgeben */
    printf("\nControl channel crashed, converter aborted\n");
    exit(3);
   }
E 3
 /* Das geht nur bei TCP Ausgabekanaelen */
 if ( !out.max || !out.anz ) return;
I 8
 /* Ohne Ruecksichten schliessen */
 if ( (port = ntohs(whom.sin_port)) < 0 )
  {
   abort = 1;
   port = -port;
   whom.sin_port = htons(port);
  }
E 8
 /* Gerade benutzte Kanaele absuchen */
 for ( cur = wpend ; cur ; cur = cur->next )
  if ( match_sin(&cur->peer,&whom) )
   {
    if ( !cur->delete ) cur->delete = 2;
I 8
    cur->clean = 0;
E 8
    return;
   }
 /* Dasselbe fuer alle Verbindungen */
 for ( cur = rpend ; cur ; cur = cur->next )
  if ( (act = cur->inp->cout) && match_sin(&act->peer,&whom) )
   {
    if ( !act->delete ) act->delete = 2;
I 8
    cur->clean = 0;
E 8
    return;
   }
 /* Gerade unbenutzte Kanaele absuchen */
 for ( cur = frel, frel = 0, fend = &frel ; act = cur ; )
  {
   /* Naechsten Durchlauf vorbereiten */
   cur = act->next;
   /* Nachsehen, ob das der Kandidat ist */
   if ( !done && match_sin(&act->peer,&whom) )
    {
     /* Demnaechst eleminieren */
     act->delete = 2;
     act->idleT += sysnow();
     enqueue(act,&wend);
     /* Rest wieder einsortieren */
     done = 1;
    }
   else
    /* Erneut einsortieren */
    enqueue(act,&fend);
  }
}

/*
  Periodische Aktionen.
*/
static periodic()
{
 struct pipehead header;
 double now = sysnow();
 struct iovec io[2];
 chan *cur;
 int ilen;

 /* Liste leeren */
 nconv = 0;
 /* Eingabekanaele bearbeiten */
 if ( addheader(&in) )
  {
   /* Auf Verbindung wartende Kanaele */
   for ( cur = idle ; cur ; cur = cur->next )
    {
     cur->idleT += now;
     addchan(cur);
     cur->idleT -= now;
    }
   /* Auf Daten wartende Kanaele */
   for ( cur = rpend ; cur ; cur = cur->next ) addchan(cur);
   for ( cur = wpend ; cur ; cur = cur->next )
    if ( cur->inp )
     addchan(cur->inp->cinp);
   /* Inaktive Kanaele */
   for ( cur = opnl ; cur ; cur = cur->next ) addchan(cur);
  }
 /* Ausgabekanaele bearbeiten */
 if ( addheader(&out) )
  {
   /* Auf Verbindung wartende Kanaele */
   for ( cur = frel ; cur ; cur = cur->next )
    {
     cur->idleT += now;
     addchan(cur);
     cur->idleT -= now;
    }
   /* Auf Daten wartende Kanaele */
   for ( cur = wpend ; cur ; cur = cur->next ) addchan(cur);
   for ( cur = rpend ; cur ; cur = cur->next )
    if ( cur->inp->cout )
     addchan(cur->inp->cout);
  }
 /* Nachricht komplettieren */
D 3
 header.pid = CONVERTERPID;
E 3
I 3
 header.kind = nkCONVERTER;
E 3
 header.mpid = getpid();
 header.reqID = reqID;
 header.items = nconv;
 /* Daten abschicken */
 io[0].iov_base = (char *)&header;
 io[0].iov_len = sizeof(header);
 io[1].iov_base = (char *)clist;
 io[1].iov_len = nconv*sizeof(clist[0]);
 if ( (ilen = io[0].iov_len+io[1].iov_len) > fpathconf(pfd,_PC_PIPE_BUF) )
  printf("Packet length exceeds PIPE_BUF, please reconfigure\n");
 else if ( writev(pfd,io,2) != ilen )
  printf("Could not write to information pipe\n");
}

/*
  Primaeren Konverterkanal eintragen.
*/
static addheader(desc)
mchan *desc;
{
 double now = sysnow();

 /* Normaler TCP/IP Kanal */
 if ( desc->max )
  {
D 5
   addconv(ntohl(desc->tcp.sin_addr.s_addr),ntohs(desc->tcp.sin_port),desc->anz,desc->max,now);
E 5
I 5
   addconv(ntohl(desc->tcp.sin_addr.s_addr),ntohs(desc->tcp.sin_port),
	   (double)(desc->anz),(double)(desc->max),now);
E 5
   return 1;
  }
 /* Der eigentliche Header */
D 5
 addconv(desc->name ? IPfile : IPnone,0,1,1,now);
E 5
I 5
D 13
 addconv(desc->name ? IPfile : IPnone,0,1.0,1.0,now);
E 13
I 13
 addconv(desc->name ? IPfile : IPnone,desc->index,1.0,1.0,now);
E 13
E 5
 /* Kanaldaten */
 addchan(desc->prim);
 /* Keine weiteren Aktionen */
 return 0;
}

/*
  Kanaldaten in die Liste eintragen.
*/
static addchan(c)
chan *c;
{
 addconv(ntohl(c->peer.sin_addr.s_addr),ntohs(c->peer.sin_port),c->events,c->bytes,c->idleT);
}

/*
  Konverterkanal in die Liste einbringen.
*/
static addconv(addr,port,events,bytes,clock)
long addr;
unsigned short port;
D 5
int events,bytes;
double clock;
E 5
I 5
double events,bytes,clock;
E 5
{
 converterchan *cur;

 /* Platz schaffen */
 if ( nconv == aconv )
  {
   /* Speicher reservieren */
   if ( !(cur = MALLOC(converterchan,aconv+10)) ) nomem();
   /* Eventuell alte Daten kopieren */
   if ( aconv )
    {
     memmove(cur,clist,aconv*sizeof(cur[0]));
     free(clist);
    }
   /* Zaehler und Zeiger aktualisieren */
   aconv += 10;
   clist = cur;
  }
 /* Eintragen */
 cur = clist+nconv++;
 cur->IPaddr = addr;
 cur->IPport = port;
 cur->events = events;
 cur->bytes = bytes;
D 2
 cur->idleT = clock;
E 2
I 2
 cur->idleT = (clock > 0.01) ? clock : 0.0;
I 10
}

/*
  Daten anhaengen.
*/
static padbuffer(c)
chan *c;
{
 /* Haben wir schon mal gemacht */
 if ( c->padded ) return 0;
 c->padded = 1;
 /* Dann mal los */
 c->iobuf.rbuf = c->evbuf.rbuf = c->evbuf.wbuf = 0;
 if ( (c->iobuf.wbuf = PAD(c->iobuf.buf,c->iobuf.size,c->bytes)) <= 0 )
  {
   c->iobuf.wbuf = 0;
   return 0;
  }
 /* Dass gehoert noch dazu */
 printf("\nOutput channel will be padded with %d bytes\n",c->iobuf.wbuf);
 return 1;
E 10
E 2
}
E 1
