h31150
s 00081/00012/03184
d D 5.4 91/08/16 11:01:39 jochen 6 5
c THRESHOLD added ; default directory and suffices modified
e
s 00009/00001/03187
d D 5.3 91/08/13 11:18:50 jochen 5 4
c Widget shutdown corrected
e
s 00023/00013/03165
d D 5.2 91/08/13 10:32:36 jochen 4 3
c Output redirection to Motif Text Widget added
e
s 00000/00011/03178
d D 5.1 91/08/12 17:41:52 jochen 3 2
c Xqueue included in QMan; SET MODE command added
e
s 02230/00621/00959
d D 1.2 91/08/12 16:22:05 jochen 2 1
c Edit only version completed
e
s 01580/00000/00000
d D 1.1 91/07/22 11:51:31 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/*
  %W% 91/07/22 X11/Motif parallel queue user interface for UNIX and VMS
*/

#ifdef SCCSIDS
static char sccs_quex11_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  Allgemeines.
*/
#define DEF
I 2
D 3
#define NO_SUPPORT_CODE
E 3
E 2
#include "quex11.h"

/*
  X11/Motif
*/
#include <X11/StringDefs.h>
I 2
#include <X11/cursorfont.h>
E 2

#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/MwmUtil.h>
I 2
#include <Xm/SelectioB.h>
E 2

#include <Mrm/MrmPublic.h>

/*
  Definitionen fuer X11.
*/
#define QMANCLASS		"QMan"
#define ERRORCLASS		"QManError"

/*
  Fehlerdefinitionen.
*/
#define TErrQMan		"QMan"
#define NErrUil			"noUil"
#define NErrNoWidgets		"noWidgets"

/*
  Translations.
*/
static int drawSelect(),drawUnselect(),drawMove(),noOperation();
static int callAddCallback();

static XtActionsRec actionMap[] =
       {
	{ "drawSelect"		,(XtActionProc)drawSelect   	},
	{ "drawUnselect"	,(XtActionProc)drawUnselect 	},
	{ "drawMove"		,(XtActionProc)drawMove	    	},
	{ "callAddCallback"	,(XtActionProc)callAddCallback	},
	{ "noOperation"		,(XtActionProc)noOperation  	},
       };

/*
  Mrm/Uil Einbindung.
*/
typedef struct cldBox
	{
D 2
	 Widget		Selector;
	 Widget		CPUTIME;
	 Widget		PRIORITY;
	 Widget		DATASIZE;
	 Widget		MEMORYSIZE;
	 Widget		STACKSIZE;
E 2
I 2
	 Widget		Selector;		/* Muss der erste Eintrag sein	*/
	 Widget		CPUTIME[2];
	 Widget		PRIORITY[2];
	 Widget		DATASIZE[2];
	 Widget		MEMORYSIZE[2];
	 Widget		STACKSIZE[2];
E 2
	 Widget		KEEP;
	 Widget		RMSFILE;
D 2
	 Widget		CLI;
E 2
I 2
	 Widget		CLI[2];
E 2
	 Widget		cliCSH;
	 Widget		cliSH;
	 Widget		cliDCL;
D 2
	 Widget		NAME;
	 Widget		PRINTER;
	 Widget		LOGFILE;
	 Widget		QUEUE;
	 Widget		PARAMETERS;
E 2
I 2
	 Widget		NAME[2];
	 Widget		PRINTER[2];
	 Widget		LOGFILE[2];
	 Widget		QUEUE[2];
	 Widget		PARAMETERS[2];
E 2
	 Widget		CONVERTER;
D 2
	 Widget		INPUT;
	 Widget		INPUTbutton;
E 2
I 2
	 Widget		INPUT[2];
E 2
	 Widget		inputFILE;
	 Widget		inputPROGRAM;
	 Widget		inputFile;
	 Widget		inputProgram;
D 2
	 Widget		inputLists[6];
E 2
I 2
	 Widget		inputLists[2][3];
E 2
#define ixNames		0
#define ixUnits		1
#define ixChannels	2
D 2
#define ixTNames	3
#define ixTUnits	4
#define ixTChannels	5
#define inputNames      inputLists[ixNames]
#define	inputUnits	inputLists[ixUnits]
#define inputChannels	inputLists[ixChannels]
#define inputTNames     inputLists[ixTNames]
#define	inputTUnits	inputLists[ixTUnits]
#define inputTChannels	inputLists[ixTChannels]
E 2
I 2
#define inputNames      inputLists[0][ixNames]
#define	inputUnits	inputLists[0][ixUnits]
#define inputChannels	inputLists[0][ixChannels]
#define inputTNames     inputLists[1][ixNames]
#define	inputTUnits	inputLists[1][ixUnits]
#define inputTChannels	inputLists[1][ixChannels]
E 2
	 Widget		inputFileList;
D 2
	 Widget		OUTPUT;
	 Widget		OUTPUTbutton;
E 2
I 2
	 Widget		OUTPUT[2];
E 2
	 Widget		outputFILE;
	 Widget		outputPROGRAM;
	 Widget		outputFile;
	 Widget		outputProgram;
D 2
	 Widget		outputLists[6];
#define outputNames     outputLists[ixNames]
#define	outputUnits	outputLists[ixUnits]
#define outputChannels	outputLists[ixChannels]
#define outputTNames    outputLists[ixTNames]
#define	outputTUnits	outputLists[ixTUnits]
#define outputTChannels	outputLists[ixTChannels]
E 2
I 2
	 Widget		outputLists[2][3];
#define outputNames     outputLists[0][ixNames]
#define	outputUnits	outputLists[0][ixUnits]
#define outputChannels	outputLists[0][ixChannels]
#define outputTNames    outputLists[1][ixNames]
#define	outputTUnits	outputLists[1][ixUnits]
#define outputTChannels	outputLists[1][ixChannels]
E 2
	 Widget		outputFileList;
	} cldBox;

D 2
static int storeWidget(),popupWidget(),popdownWidget();
E 2
I 2
static int storeWidget(),storeDualWidget(),popupWidget(),popdownWidget();
static int configureDialog(),soundBell();
E 2
static int popupFileSelector(),saveCurrent(),exitXqueue();
static int drawExposeCallback(),fileSelectionCallback(),saveCallback(),toggleCallback();
static int executeCommand(),setupCallback(),programCallback(),filenameCallback();
static int multipleCallback(),addCallback(),deleteCallback(),completeCallback();
I 2
static int setSelections();
static int redrawCallback(),boxCallback(),undoSetup(),cutCallback(),undoCallback();
D 6
static int checkCallback();
E 6
I 6
static int checkCallback(),thresholdCallback();
E 6
E 2

static Widget mainWindow;
D 2
static Widget fileSelector,noFileBox,saveFileBox;
E 2
I 2
static Widget fileSelector,noFileBox,saveFileBox,boxSelector,undoSelector;
E 2
D 6
static Widget commandDialog,setupDialog,authorHelp;
E 6
I 6
static Widget commandDialog,setupDialog,thresholdSelector,authorHelp;
E 6

static Widget drawArea,textArea;
static Widget save_button,save_as_button;
D 6
static Widget verify_button,debug_button,version_button;
E 6
I 6
static Widget verify_button,debug_button,version_button,threshold_button;
E 6
static Widget outputMenu,noisy_button,silent_button,hostName,queueName,setupFile;
I 6
static Widget createThreshold,deleteThreshold;
E 6

static cldBox proBox = { 0 },priBox = { 0 },conBox = { 0 };

static String uilFiles[] = { "QMan.uid" };

static MrmRegisterArg uilNames[] =
       {
	/* Callbacks */
	{ "noOperation"			,(caddr_t)noOperation		 },
	{ "storeWidget"			,(caddr_t)storeWidget		 },
I 2
	{ "storeDualWidget"		,(caddr_t)storeDualWidget	 },
E 2
	{ "popupWidget"			,(caddr_t)popupWidget		 },
	{ "popdownWidget"		,(caddr_t)popdownWidget		 },
I 2
	{ "configureDialog"		,(caddr_t)configureDialog	 },
	{ "soundBell"			,(caddr_t)soundBell		 },
E 2
	{ "popupFileSelector"   	,(caddr_t)popupFileSelector	 },
	{ "saveCurrent"			,(caddr_t)saveCurrent		 },
	{ "exitXqueue"			,(caddr_t)exitXqueue		 },
	{ "drawExposeCallback"		,(caddr_t)drawExposeCallback	 },
	{ "fileSelectionCallback"	,(caddr_t)fileSelectionCallback	 },
	{ "saveCallback"		,(caddr_t)saveCallback		 },
	{ "toggleCallback"		,(caddr_t)toggleCallback	 },
	{ "executeCommand"		,(caddr_t)executeCommand	 },
	{ "setupCallback"		,(caddr_t)setupCallback		 },
	{ "programCallback"		,(caddr_t)programCallback	 },
	{ "filenameCallback"		,(caddr_t)filenameCallback	 },
	{ "multipleCallback"		,(caddr_t)multipleCallback	 },
	{ "addCallback"			,(caddr_t)addCallback	 	 },
	{ "deleteCallback"		,(caddr_t)deleteCallback	 },
	{ "completeCallback"		,(caddr_t)completeCallback	 },
I 2
	{ "setSelections"		,(caddr_t)setSelections	 	 },
	{ "redrawCallback"		,(caddr_t)redrawCallback	 },
	{ "boxCallback"			,(caddr_t)boxCallback		 },
	{ "undoSetup"			,(caddr_t)undoSetup		 },
	{ "cutCallback"			,(caddr_t)cutCallback		 },
	{ "undoCallback"		,(caddr_t)undoCallback		 },
	{ "checkCallback"		,(caddr_t)checkCallback		 },
I 6
	{ "thresholdCallback"		,(caddr_t)thresholdCallback	 },
E 6
E 2
	/* Variablen */	
	{ "drawWidth"			,(caddr_t)10000			 },
	{ "drawHeight"			,(caddr_t)10000			 },
	{ "monadicDirectory"		,(caddr_t)0			 },
	{ "dyadicDirectory"		,(caddr_t)0			 },
	/* Widgets */ 
	{ "mainWindow"			,(caddr_t)&mainWindow		 },
	{ "fileSelector"		,(caddr_t)&fileSelector		 },
	{ "noFileBox"			,(caddr_t)&noFileBox		 },
	{ "saveFileBox"			,(caddr_t)&saveFileBox		 },
I 2
	{ "boxSelector"			,(caddr_t)&boxSelector		 },
	{ "undoSelector"		,(caddr_t)&undoSelector		 },
E 2
	{ "programSelector"		,(caddr_t)&proBox.Selector	 },
	{ "primarySelector"		,(caddr_t)&priBox.Selector	 },
	{ "converterSelector"		,(caddr_t)&conBox.Selector	 },
	{ "commandDialog"		,(caddr_t)&commandDialog	 },
	{ "setupDialog"			,(caddr_t)&setupDialog		 },
I 6
	{ "thresholdSelector"		,(caddr_t)&thresholdSelector	 },
E 6
	{ "authorHelp"			,(caddr_t)&authorHelp		 },
	{ "drawArea"			,(caddr_t)&drawArea		 },
	{ "textArea"			,(caddr_t)&textArea		 },
	{ "save_button"			,(caddr_t)&save_button		 },
	{ "save_as_button"		,(caddr_t)&save_as_button	 },
	{ "verify_button"		,(caddr_t)&verify_button	 },
	{ "debug_button"		,(caddr_t)&debug_button		 },
	{ "version_button"		,(caddr_t)&version_button	 },
I 6
	{ "threshold_button"		,(caddr_t)&threshold_button	 },
E 6
	{ "outputMenu"			,(caddr_t)&outputMenu		 },
	{ "noisy_button"		,(caddr_t)&noisy_button		 },
	{ "silent_button"		,(caddr_t)&silent_button	 },
	{ "hostName"			,(caddr_t)&hostName		 },
	{ "queueName"			,(caddr_t)&queueName		 },
	{ "setupFile"			,(caddr_t)&setupFile		 },
I 6
	{ "createThreshold"		,(caddr_t)&createThreshold	 },
	{ "deleteThreshold"		,(caddr_t)&deleteThreshold	 },
E 6
D 2
	{ "programCPUTIME"		,(caddr_t)&proBox.CPUTIME	 },
	{ "programPRIORITY"		,(caddr_t)&proBox.PRIORITY	 },
        { "programDATASIZE"		,(caddr_t)&proBox.DATASIZE	 },
	{ "programMEMORYSIZE"		,(caddr_t)&proBox.MEMORYSIZE	 },
	{ "programSTACKSIZE"		,(caddr_t)&proBox.STACKSIZE	 },
E 2
I 2
	{ "programCPUTIME"		,(caddr_t)proBox.CPUTIME	 },
	{ "programPRIORITY"		,(caddr_t)proBox.PRIORITY	 },
        { "programDATASIZE"		,(caddr_t)proBox.DATASIZE	 },
	{ "programMEMORYSIZE"		,(caddr_t)proBox.MEMORYSIZE	 },
	{ "programSTACKSIZE"		,(caddr_t)proBox.STACKSIZE	 },
E 2
	{ "programKEEP"			,(caddr_t)&proBox.KEEP		 },
	{ "programRMSFILE"		,(caddr_t)&proBox.RMSFILE	 },
D 2
	{ "programCLI"			,(caddr_t)&proBox.CLI		 },
E 2
I 2
	{ "programCLI"			,(caddr_t)proBox.CLI		 },
E 2
	{ "programcliCSH"		,(caddr_t)&proBox.cliCSH	 },
	{ "programcliSH"		,(caddr_t)&proBox.cliSH		 },
	{ "programcliDCL"		,(caddr_t)&proBox.cliDCL	 },
D 2
	{ "programNAME"			,(caddr_t)&proBox.NAME		 },
	{ "programPRINTER"		,(caddr_t)&proBox.PRINTER	 },
	{ "programLOGFILE"		,(caddr_t)&proBox.LOGFILE	 },
	{ "programQUEUE"		,(caddr_t)&proBox.QUEUE		 },
	{ "programPARAMETERS"		,(caddr_t)&proBox.PARAMETERS	 },
	{ "primaryCPUTIME"		,(caddr_t)&priBox.CPUTIME	 },
	{ "primaryPRIORITY"		,(caddr_t)&priBox.PRIORITY	 },
        { "primaryDATASIZE"		,(caddr_t)&priBox.DATASIZE	 },
	{ "primaryMEMORYSIZE"		,(caddr_t)&priBox.MEMORYSIZE	 },
	{ "primarySTACKSIZE"		,(caddr_t)&priBox.STACKSIZE	 },
E 2
I 2
	{ "programNAME"			,(caddr_t)proBox.NAME		 },
	{ "programPRINTER"		,(caddr_t)proBox.PRINTER	 },
	{ "programLOGFILE"		,(caddr_t)proBox.LOGFILE	 },
	{ "programQUEUE"		,(caddr_t)proBox.QUEUE		 },
	{ "programPARAMETERS"		,(caddr_t)proBox.PARAMETERS	 },
	{ "primaryCPUTIME"		,(caddr_t)priBox.CPUTIME	 },
	{ "primaryPRIORITY"		,(caddr_t)priBox.PRIORITY	 },
        { "primaryDATASIZE"		,(caddr_t)priBox.DATASIZE	 },
	{ "primaryMEMORYSIZE"		,(caddr_t)priBox.MEMORYSIZE	 },
	{ "primarySTACKSIZE"		,(caddr_t)priBox.STACKSIZE	 },
E 2
	{ "primaryKEEP"			,(caddr_t)&priBox.KEEP		 },
D 2
	{ "primaryNAME"			,(caddr_t)&priBox.NAME		 },
	{ "primaryPRINTER"		,(caddr_t)&priBox.PRINTER	 },
	{ "primaryLOGFILE"		,(caddr_t)&priBox.LOGFILE	 },
	{ "primaryQUEUE"		,(caddr_t)&priBox.QUEUE		 },
	{ "primaryPARAMETERS"		,(caddr_t)&priBox.PARAMETERS	 },
E 2
I 2
	{ "primaryNAME"			,(caddr_t)priBox.NAME		 },
	{ "primaryPRINTER"		,(caddr_t)priBox.PRINTER	 },
	{ "primaryLOGFILE"		,(caddr_t)priBox.LOGFILE	 },
	{ "primaryQUEUE"		,(caddr_t)priBox.QUEUE		 },
	{ "primaryPARAMETERS"		,(caddr_t)priBox.PARAMETERS	 },
E 2
	{ "primaryCONVERTER"		,(caddr_t)&priBox.CONVERTER	 },
D 2
	{ "converterCPUTIME"		,(caddr_t)&conBox.CPUTIME	 },
	{ "converterPRIORITY"		,(caddr_t)&conBox.PRIORITY	 },
        { "converterDATASIZE"		,(caddr_t)&conBox.DATASIZE	 },
	{ "converterMEMORYSIZE"		,(caddr_t)&conBox.MEMORYSIZE	 },
	{ "converterSTACKSIZE"		,(caddr_t)&conBox.STACKSIZE	 },
E 2
I 2
	{ "converterCPUTIME"		,(caddr_t)conBox.CPUTIME	 },
	{ "converterPRIORITY"		,(caddr_t)conBox.PRIORITY	 },
        { "converterDATASIZE"		,(caddr_t)conBox.DATASIZE	 },
	{ "converterMEMORYSIZE"		,(caddr_t)conBox.MEMORYSIZE	 },
	{ "converterSTACKSIZE"		,(caddr_t)conBox.STACKSIZE	 },
E 2
	{ "converterKEEP"		,(caddr_t)&conBox.KEEP		 },
	{ "converterRMSFILE"		,(caddr_t)&conBox.RMSFILE	 },
D 2
	{ "converterCLI"		,(caddr_t)&conBox.CLI		 },
E 2
I 2
	{ "converterCLI"		,(caddr_t)conBox.CLI		 },
E 2
	{ "convertercliCSH"		,(caddr_t)&conBox.cliCSH	 },
	{ "convertercliSH"		,(caddr_t)&conBox.cliSH		 },
	{ "convertercliDCL"		,(caddr_t)&conBox.cliDCL	 },
D 2
	{ "converterNAME"		,(caddr_t)&conBox.NAME		 },
	{ "converterPRINTER"		,(caddr_t)&conBox.PRINTER	 },
	{ "converterLOGFILE"		,(caddr_t)&conBox.LOGFILE	 },
	{ "converterQUEUE"		,(caddr_t)&conBox.QUEUE		 },
	{ "converterPARAMETERS"		,(caddr_t)&conBox.PARAMETERS	 },
	{ "converterCONVERTER"		,(caddr_t)&conBox.CONVERTER	 },
	{ "converterINPUT"		,(caddr_t)&conBox.INPUT		 },
	{ "converterINPUT_BUTTON"	,(caddr_t)&conBox.INPUTbutton	 },
E 2
I 2
	{ "converterNAME"		,(caddr_t)conBox.NAME		 },
	{ "converterPRINTER"		,(caddr_t)conBox.PRINTER	 },
	{ "converterLOGFILE"		,(caddr_t)conBox.LOGFILE	 },
	{ "converterQUEUE"		,(caddr_t)conBox.QUEUE		 },
	{ "converterPARAMETERS"		,(caddr_t)conBox.PARAMETERS	 },
	{ "converterINPUT"		,(caddr_t)conBox.INPUT		 },
	{ "converterINPUT_BUTTON"	,(caddr_t)(conBox.INPUT+1)	 },
E 2
	{ "converterinputFILE"		,(caddr_t)&conBox.inputFILE	 },
	{ "converterinputPROGRAM"	,(caddr_t)&conBox.inputPROGRAM	 },
	{ "converterinputFile"		,(caddr_t)&conBox.inputFile	 },
	{ "converterinputProgram"	,(caddr_t)&conBox.inputProgram	 },
	{ "converterinputNames"		,(caddr_t)&conBox.inputNames	 },
	{ "converterinputTNames"	,(caddr_t)&conBox.inputTNames	 },
	{ "converterinputUnits"		,(caddr_t)&conBox.inputUnits	 },
	{ "converterinputTUnits"	,(caddr_t)&conBox.inputTUnits	 },
	{ "converterinputChannels"	,(caddr_t)&conBox.inputChannels	 },
	{ "converterinputTChannels"	,(caddr_t)&conBox.inputTChannels },
	{ "converterinputFileList"	,(caddr_t)&conBox.inputFileList	 },
D 2
	{ "converterOUTPUT"		,(caddr_t)&conBox.OUTPUT	 },
	{ "converterOUTPUT_BUTTON"	,(caddr_t)&conBox.OUTPUTbutton	 },
E 2
I 2
	{ "converterOUTPUT"		,(caddr_t)conBox.OUTPUT	 	 },
	{ "converterOUTPUT_BUTTON"	,(caddr_t)(conBox.OUTPUT+1)	 },
E 2
	{ "converteroutputFILE"		,(caddr_t)&conBox.outputFILE	 },
	{ "converteroutputPROGRAM"	,(caddr_t)&conBox.outputPROGRAM	 },
	{ "converteroutputFile"		,(caddr_t)&conBox.outputFile	 },
	{ "converteroutputProgram"	,(caddr_t)&conBox.outputProgram	 },
	{ "converteroutputNames"	,(caddr_t)&conBox.outputNames	 },
	{ "converteroutputTNames"	,(caddr_t)&conBox.outputTNames	 },
	{ "converteroutputUnits"	,(caddr_t)&conBox.outputUnits	 },
	{ "converteroutputTUnits"	,(caddr_t)&conBox.outputTUnits	 },
	{ "converteroutputChannels"	,(caddr_t)&conBox.outputChannels },
	{ "converteroutputTChannels"	,(caddr_t)&conBox.outputTChannels},
	{ "converteroutputFileList"	,(caddr_t)&conBox.outputFileList }
       };

/*
I 2
  Dynamische Strings - sie werden aus dem UID File gelesen.
*/
static XmString nonumMsg,illnumMsg,illFileMsg,noconnMsg,illNameMsg,inUseMsg;
static String noMemory,noloadMsg,modMsg,usingFile,checkingFile,noputString;
static XmString boxSelectMsg,boxDeleteMsg;

static MrmRegisterArg readOut[] =
       {
	{ "nofileMsg"			,(caddr_t)&nofileMsg		},
	{ "badfileMsg"			,(caddr_t)&badfileMsg		},
	{ "noopenMsg"			,(caddr_t)&noopenMsg		},
	{ "noplaceMsg"			,(caddr_t)&noplaceMsg		},
	{ "noloadMsg"			,(caddr_t)&noloadMsg		},
	{ "modMsg"			,(caddr_t)&modMsg		},
	{ "usingFile"			,(caddr_t)&usingFile		},
	{ "checkingFile"		,(caddr_t)&checkingFile		},
	{ "saveData"			,(caddr_t)&saveData		},
	{ "openFile"			,(caddr_t)&openFile		},
	{ "createVerb"			,(caddr_t)&createVerb		},
	{ "openVerb"			,(caddr_t)&openVerb		},
	{ "syntaxMsg"			,(caddr_t)&syntaxMsg		},
	{ "tableMsg"			,(caddr_t)&tableMsg		},
	{ "doneMsg"			,(caddr_t)&doneMsg		},
	{ "successMsg"			,(caddr_t)&successMsg		},
	{ "errorSummary"		,(caddr_t)&errorSummary		},
	{ "beVerbose"			,(caddr_t)&beVerbose		},
	{ "translateFile"		,(caddr_t)&translateFile	},
	{ "translateLogfile"		,(caddr_t)&translateLogfile	},
	{ "createLogfile"		,(caddr_t)&createLogfile	},
	{ "translatePrinter"		,(caddr_t)&translatePrinter	},
	{ "translateQueue"		,(caddr_t)&translateQueue	},
	{ "checkValue"			,(caddr_t)&checkValue		},
	{ "translateFileChannel"	,(caddr_t)&translateFileChannel	},
	{ "translatePrimaryFile"	,(caddr_t)&translatePrimaryFile	},
	{ "translateDirectory"		,(caddr_t)&translateDirectory	},
	{ "noSuchDirectory"		,(caddr_t)&noSuchDirectory	},
	{ "noFilename"			,(caddr_t)&noFilename		},
	{ "noParameters"		,(caddr_t)&noParameters		},
	{ "noPrinter"			,(caddr_t)&noPrinter		},
	{ "noQueue"			,(caddr_t)&noQueue		},
	{ "noPrimaryFile"		,(caddr_t)&noPrimaryFile	},
	{ "noCLI"			,(caddr_t)&noCLI		},
	{ "noDirectory"			,(caddr_t)&noDirectory		},
	{ "pointerMismatch"		,(caddr_t)&pointerMismatch	},
	{ "noMemory"			,(caddr_t)&noMemory		},
	{ "noPrograms"			,(caddr_t)&noPrograms		},
	{ "noUnits"			,(caddr_t)&noUnits		},
	{ "numUnits"			,(caddr_t)&numUnits		},
	{ "invalidUnit"			,(caddr_t)&invalidUnit		},
	{ "noMaxChannels"		,(caddr_t)&noMaxChannels	},
	{ "numMaxChannels"		,(caddr_t)&numMaxChannels	},
	{ "invalidMaxChannel"		,(caddr_t)&invalidMaxChannel	},
	{ "noFiles"			,(caddr_t)&noFiles		},
	{ "maxSyntax"			,(caddr_t)&maxSyntax		},
I 6
	{ "illThreshold"		,(caddr_t)&illThreshold		},
	{ "multipleOutput"		,(caddr_t)&multipleOutput	},
E 6
	{ "noputString"			,(caddr_t)&noputString		},
	{ "nonumMsg"			,(caddr_t)&nonumMsg		},
	{ "illnumMsg"			,(caddr_t)&illnumMsg		},
	{ "illFileMsg"			,(caddr_t)&illFileMsg		},
	{ "noconnMsg"			,(caddr_t)&noconnMsg		},
	{ "illNameMsg"			,(caddr_t)&illNameMsg		},
	{ "inUseMsg"			,(caddr_t)&inUseMsg		},
	{ "boxSelectMsg"		,(caddr_t)&boxSelectMsg		},
	{ "boxDeleteMsg"		,(caddr_t)&boxDeleteMsg		},
	{ "pdlNoElements"		,(caddr_t)&pdlNoElements	},
	{ "pdlDupChannel"		,(caddr_t)&pdlDupChannel	},
	{ "pdlNoProgram"		,(caddr_t)&pdlNoProgram		},
	{ "pdlDupProgram"		,(caddr_t)&pdlDupProgram	},
	{ "pdlNotConnected"		,(caddr_t)&pdlNotConnected	},
	{ "pdlNotValid"			,(caddr_t)&pdlNotValid		},
	{ "pdlOk"			,(caddr_t)&pdlOk		},
	{ "copyMsg"			,(caddr_t)&copyMsg		},
	{ "noCopyMsg"			,(caddr_t)&noCopyMsg		},
	{ "pdlIntro"			,(caddr_t)&pdlIntro		},
	{ "noWriteMsg"			,(caddr_t)&noWriteMsg		}
       };

/*
E 2
  Zusaetzliche Resources.
*/
static XtResource addResources[] =
       {
	{ 
	 "drawWidth", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,drawWidth),
	 XmRString, "10000"
	},
	{ 
	 "drawHeight", XmCHeight, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,drawHeight),
	 XmRString, "10000"
	},
	{ 
	 "lineWidth", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,lineWidth),
	 XmRString, "3"
	},
	{ 
	 "boxWidth", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,boxWidth),
	 XmRString, "200"
	},
	{ 
	 "boxHeight", XmCHeight, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,boxHeight),
	 XmRString, "70"
	},
	{ 
	 "leftMargin", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,leftMargin),
	 XmRString, "10"
	},
	{ 
	 "topMargin", XmCHeight, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,topMargin),
	 XmRString, "10"
	},
	{ 
	 "gapWidth", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,gapWidth),
	 XmRString, "100"
	},
	{ 
	 "gapHeight", XmCHeight, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,gapHeight),
	 XmRString, "50"
	},
	{ 
	 "arrowLength", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,arrowLength),
	 XmRString, "14"
	},
	{ 
	 "dotRadius", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,dotRadius),
	 XmRString, "5"
	},
	{ 
I 2
	 "hitDistance", XmCWidth, XmRDimension, sizeof(Dimension),
	 XtOffset(AppStruct *,hitDistance),
	 XmRString, "10"
	},
	{ 
E 2
	 "maxLines", XmCLength, XmRInt, sizeof(int),
	 XtOffset(AppStruct *,maxLines),
	 XmRString, "256"
	},
	{ 
	 "maxSyntaxErrors", XmCLength, XmRInt, sizeof(int),
	 XtOffset(AppStruct *,maxSyntaxErrors),
	 XmRString, "20"
	},
I 2
	{
	 "doubleClickInterval", XmCDoubleClickInterval, XmRInt, sizeof(int),
	 XtOffset(AppStruct *,clickInterval),
	 XmRString, "1500"
	},
	{
	 "moveThreshold", XmCLength, XmRInt, sizeof(int),
	 XtOffset(AppStruct *,moveThreshold),
	 XmRString, "10"
	},
E 2
	{ 
	 "verifyFlag", XmCBoolean, XmRBoolean, sizeof(Boolean),
	 XtOffset(AppStruct *,verifyFlag),
	 XmRString, "True"
	},
	{ 
	 "debugFlag", XmCBoolean, XmRBoolean, sizeof(Boolean),
	 XtOffset(AppStruct *,debugFlag),
	 XmRString, "False"
	},
	{ 
	 "versionFlag", XmCBoolean, XmRBoolean, sizeof(Boolean),
	 XtOffset(AppStruct *,versionFlag),
	 XmRString, "True"
	},
I 6
	{ 
	 "thresholdFlag", XmCBoolean, XmRBoolean, sizeof(Boolean),
	 XtOffset(AppStruct *,thresholdFlag),
	 XmRString, "False"
	},
E 6
	{
	 "logSuffix", XmCString, XmRString, sizeof(String),
	 XtOffset(AppStruct *,logSuffix),
	 XmRString, ".log"
	},
	{
I 2
	 "backupSuffix", XmCString, XmRString, sizeof(String),
	 XtOffset(AppStruct *,backupSuffix),
	 XmRString, "~"
	},
	{
E 2
	 "tmpDir", XmCString, XmRString, sizeof(String),
	 XtOffset(AppStruct *,tmpDir),
	 XmRString, "/tmp"
	},
	{
	 "monadicDirectory", XmCString, XmRString, sizeof(String),
	 XtOffset(AppStruct *,conv1Dir),
	 XmRString, "boss$root:[usr.converter.monadic]"
	},
	{
	 "dyadicDirectory", XmCString, XmRString, sizeof(String),
	 XtOffset(AppStruct *,conv2Dir),
	 XmRString, "boss$root:[usr.converter.dyadic]"
	},
	{
	 "largeFont", XtCFont, XtRFont, sizeof(Font),
	 XtOffset(AppStruct *,largeFont),
	 XmRString, "-*-*-medium-r-*-*-20-*-*-*-*-*-*-*"
	},
	{
	 "smallFont", XtCFont, XtRFont, sizeof(Font),
	 XtOffset(AppStruct *,smallFont),
	 XmRString, "-*-*-medium-r-*-*-15-*-*-*-*-*-*-*"
	}
       };

/*
  Defaultwerte.
*/
static String resources[] =
       {
	"QMan.allowShellResize: true",
        "QMan*cascadePixmap: menu16",
	NULL
       };

/*
I 2
  Verwaltungsstrukturen.
*/
typedef struct hit_t
	{
	 int			alloc;
	 int			used;
	 box_t			**from;
	 box_t			**to;
	 Time			when;
	} hit_t;

/*
E 2
  Macros
*/
#define fullWidth		(2*app.leftMargin+app.boxWidth+app.gapWidth)	
#define fullHeight		(2*app.topMargin+app.boxHeight+app.gapHeight)
D 2
#define BoxCol(num)		(num/maxRow)
#define BoxRow(num)		(num%maxRow)
#define BoxX(num)		(BoxCol(num)*fullWidth+app.leftMargin)
#define BoxY(num)		(BoxRow(num)*fullHeight+app.topMargin)
E 2
I 2
#define BoxX(c)			((c)*fullWidth+app.leftMargin)
#define BoxY(r)			((r)*fullHeight+app.topMargin)
E 2

#define queueManager()		getTextValue(hostName)
#define parallelQueue()		getTextValue(queueName)
#define paramFile()		getTextValue(setupFile)

I 2
#define set_cursor(w,c)		XDefineCursor(XtDisplay(w),XtWindow(w),c)
#define busyCursor(w)		set_cursor(w,busy)
#define normalCursor(w)		set_cursor(w,None)

#define get_boolean(tb)		XmToggleButtonGadgetGetState(tb)
#define set_boolean(tb,v)	XmToggleButtonGadgetSetState(tb,(v) ? True : False,False)

#define set_integer(tf,v)	set_strint(tf,(char *)(v),1)
#define set_string(tf,s)	set_strint(tf,s,0)
#define set_selector(fs,n)	setSelector(fs,n)
#define set_monadic		set_selector

#define newstr(s)		XmStringCreate(s,XmSTRING_DEFAULT_CHARSET)

#define Bell()	       		XBell(XtDisplay(top),100)

#define PAINT_SAVE		0
#define PAINT_RESTORE		1
#define PAINT_MOVE		2

E 2
/*
  Variablen.
*/
static Widget top = NULL;

I 2
static int terminateNormally,curhit = 0,moveX,moveY,startX,startY,offX,offY,noPaint;
static pdl_buf munit = { 0, 0, NULL, 0, 0, 0 };
I 4
static String openAction,QManCommand = NULL;
E 4
static hit_t hit[2] = { 0 },common = { 0 };
E 2
static XFontStruct *smallFont,*largeFont;
static Dimension drawWidth,drawHeight;
D 2
static int terminateNormally;
static XtAppContext context;
E 2
I 2
static pdl_unit *curUnit = NULL;
static Pixmap backing,frame;
E 2
static GC gc20 = 0,gc15 = 0;
I 2
static XtAppContext context;
E 2
static MrmHierarchy mrmInfo;
D 2
static XRectangle fullRect;
E 2
I 2
static box_t *moving = NULL;
static XmString boxAction;
E 2
D 4
static String openAction;
E 4
static XGCValues gc_val;
I 2
static jmp_buf errjmp;
static Cursor busy;
E 2

/*
D 2
  Dynamische Strings aus der Uil-Datei.
E 2
I 2
  Hilfsprogramme.
E 2
*/
D 2
static String noMemory,noloadMsg,modMsg,usingFile;
E 2
I 2
static char *get_cli(),*get_string(),*get_selector(),*get_monadic(),*get_vms();
static pdl_channel **get_chans();
static String getTextValue();
static char **get_params();
E 2

I 2
/**********************************************************************

  Initialisierung.

**********************************************************************/

E 2
/*
  Initialisierung.
*/
D 4
Xqueue(argc,argv)
int argc;
String argv[];
E 4
I 4
char *Xqueue(kill)
int kill;
E 4
{
 XEvent cur;

 /* Initialisieren oder nur anzeigen */
 if ( top )
  XtMapWidget(top);
 else
  {
I 4
   int argc = 0;
E 4
   String dir;

   /* Top Level Shell */
D 4
   top = XtAppInitialize(NULL,QMANCLASS,NULL,0,&argc,argv,resources,NULL,0);
E 4
I 4
   top = XtAppInitialize(NULL,QMANCLASS,NULL,0,&argc,(char **)0,resources,NULL,0);
E 4
   context = XtWidgetToApplicationContext(top);
   /* Actionroutinen */
   XtAppAddActions(context,actionMap,XtNumber(actionMap));
   /* Interne Resourcen */
   XtGetApplicationResources(top,&app,addResources,XtNumber(addResources),NULL,0);
   /* Dynamische Parameter setzen */
   setParameter("drawWidth",app.drawWidth);
   setParameter("drawHeight",app.drawHeight);
   if ( !(dir = translate_vms(app.conv1Dir)) || (dir == NOQUAL) ) dir = ".";
D 2
   setParameter("monadicDirectory",XmStringCreate(dir,XmSTRING_DEFAULT_CHARSET));
E 2
I 2
   setParameter("monadicDirectory",newstr(dir1 = strdup(dir)));
E 2
   if ( !(dir = translate_vms(app.conv2Dir)) || (dir == NOQUAL) ) dir = ".";
D 2
   setParameter("dyadicDirectory",XmStringCreate(dir,XmSTRING_DEFAULT_CHARSET));
E 2
I 2
   setParameter("dyadicDirectory",newstr(dir2 = strdup(dir)));
E 2
   /* Widget Baum */
   createWidgets(top);
D 6
   /* Restliche Initializierung */
E 6
I 6
   /* Restliche Initialisierung */
E 6
   free_ctrl(&unit);
I 2
   free_ctrl(&history);
   place_pdl(&unit,0);
E 2
D 6
   setToggleButtons();
E 6
D 2
   /* Alles erzeugen */
E 2
I 2
   /* Alles notwendige erzeugen */
E 2
   XtRealizeWidget(top);
I 2
   XtRealizeWidget(proBox.Selector);
   XtRealizeWidget(proBox.CLI[1]);
   XtRealizeWidget(priBox.Selector);
   XtRealizeWidget(conBox.Selector);
   XtRealizeWidget(conBox.INPUT[1]);
   XtRealizeWidget(conBox.inputFile);
   XtRealizeWidget(conBox.inputProgram);
   XtRealizeWidget(conBox.OUTPUT[1]);
   XtRealizeWidget(conBox.outputFile);
   XtRealizeWidget(conBox.outputProgram);
   XtRealizeWidget(boxSelector);
   XtRealizeWidget(undoSelector);
E 2
   /* Datei aufsetzen */
   setCurrentFile(NULL);
   /* Parameterdatei laden */
   setupCallback(setupDialog,"load",NULL);
I 6
   /* Schwellen initialisiern */
   thresholdCallback(thresholdSelector,NULL,NULL);
   tostart = unit.tostart;
   tostop = unit.tostop;
   /* Buttons herrichten */
   setToggleButtons();
E 6
  }
 /* Programm abarbeiten */
D 4
 for ( terminateNormally = 0 ; terminateNormally != 2 ; )
E 4
I 4
 if ( QManCommand ) 
E 4
  {
D 4
   XtAppNextEvent(context,&cur);
   XtDispatchEvent(&cur);
E 4
I 4
   XtFree(QManCommand);
   QManCommand = NULL;
E 4
  }
I 4
 terminateNormally = 0;
 if ( !kill )
  while ( (terminateNormally != 2) && !QManCommand )
   {
    XtAppNextEvent(context,&cur);
    XtDispatchEvent(&cur);
   }
E 4
 /* Fenster wegzaubern */
D 4
 XtUnmapWidget(top);
E 4
I 4
D 5
 if ( !QManCommand ) XtUnmapWidget(top);
E 5
I 5
 if ( !QManCommand ) 
  {
   XtUnmapWidget(top);
   XtUnmanageChild(conBox.Selector);
   XtUnmanageChild(conBox.inputFile);
   XtUnmanageChild(conBox.inputProgram);
   XtUnmanageChild(conBox.outputFile);
   XtUnmanageChild(conBox.outputProgram);
  }
E 5
E 4
 /* Events abarbeiten */
 while ( XtAppPending(context) )
  {
   XtAppNextEvent(context,&cur);
   XtDispatchEvent(&cur);
  }
I 4
 /* Ergebnis */
 return QManCommand;
E 4
}

/*
  Dynamischen Parameter in die Uil-Interfacetabelle eintragen.
*/
static setParameter(name,value)
String name;
caddr_t value;
{
 MrmRegisterArg *cur = uilNames;
 int n = XtNumber(uilNames);

 /* Suchen */
 for ( ; n-- ; cur++ )
  if ( !strcmp(cur->name,name) )
   {
    /* Wert setzen */
    cur->value = value;
    return 1;
   }
 /* Nicht da */
 return 0;
}

/*
  Erzeugen aller Widgets relativ zum Toplevel Widget.
*/
static createWidgets(top)
Widget top;
{
 Display *disp = XtDisplay(top);
 MrmCode code;
 Widget main;
 Arg par[2];
I 2
 int n;
E 2

 /* Mrm/Uil initialisieren */
 MrmInitialize();
 /* Uil-Datei oeffnen */
 if ( MrmOpenHierarchy(XtNumber(uilFiles),uilFiles,NULL,&mrmInfo) != MrmSUCCESS )
  XtErrorMsg(NErrUil,TErrQMan,ERRORCLASS,"can't open UID file",NULL,NULL);
 /* Namen anmelden */
 MrmRegisterNamesInHierarchy(mrmInfo,uilNames,XtNumber(uilNames));
 /* Alle Widget einlesen */
 if ( MrmFetchInterfaceModule(mrmInfo,QMANCLASS,top,&main) != MrmSUCCESS )
  XtErrorMsg(NErrNoWidgets,TErrQMan,ERRORCLASS,"can't fetch widgets from UIL file",NULL,NULL);
 /* Dynamische Strings */
D 2
 MrmFetchLiteral(mrmInfo,"nofileMsg",disp,&nofileMsg,&code);
 MrmFetchLiteral(mrmInfo,"badfileMsg",disp,&badfileMsg,&code);
 MrmFetchLiteral(mrmInfo,"noopenMsg",disp,&noopenMsg,&code);
 MrmFetchLiteral(mrmInfo,"noloadMsg",disp,&noloadMsg,&code);
 MrmFetchLiteral(mrmInfo,"modMsg",disp,&modMsg,&code);
 MrmFetchLiteral(mrmInfo,"usingFile",disp,&usingFile,&code);
 MrmFetchLiteral(mrmInfo,"saveData",disp,&saveData,&code);
 MrmFetchLiteral(mrmInfo,"openFile",disp,&openFile,&code);
 MrmFetchLiteral(mrmInfo,"createVerb",disp,&createVerb,&code);
 MrmFetchLiteral(mrmInfo,"openVerb",disp,&openVerb,&code);
 MrmFetchLiteral(mrmInfo,"syntaxMsg",disp,&syntaxMsg,&code);
 MrmFetchLiteral(mrmInfo,"tableMsg",disp,&tableMsg,&code);
 MrmFetchLiteral(mrmInfo,"doneMsg",disp,&doneMsg,&code);
 MrmFetchLiteral(mrmInfo,"successMsg",disp,&successMsg,&code);
 MrmFetchLiteral(mrmInfo,"errorSummary",disp,&errorSummary,&code);
 MrmFetchLiteral(mrmInfo,"beVerbose",disp,&beVerbose,&code);
 MrmFetchLiteral(mrmInfo,"translateFile",disp,&translateFile,&code);
 MrmFetchLiteral(mrmInfo,"translateLogfile",disp,&translateLogfile,&code);
 MrmFetchLiteral(mrmInfo,"createLogfile",disp,&createLogfile,&code);
 MrmFetchLiteral(mrmInfo,"translatePrinter",disp,&translatePrinter,&code);
 MrmFetchLiteral(mrmInfo,"translateQueue",disp,&translateQueue,&code);
 MrmFetchLiteral(mrmInfo,"checkValue",disp,&checkValue,&code);
 MrmFetchLiteral(mrmInfo,"translateFileChannel",disp,&translateFileChannel,&code);
 MrmFetchLiteral(mrmInfo,"translatePrimaryFile",disp,&translatePrimaryFile,&code);
 MrmFetchLiteral(mrmInfo,"translateDirectory",disp,&translateDirectory,&code);
 MrmFetchLiteral(mrmInfo,"noSuchDirectory",disp,&noSuchDirectory,&code);
 MrmFetchLiteral(mrmInfo,"noFilename",disp,&noFilename,&code);
 MrmFetchLiteral(mrmInfo,"noParameters",disp,&noParameters,&code);
 MrmFetchLiteral(mrmInfo,"noPrinter",disp,&noPrinter,&code);
 MrmFetchLiteral(mrmInfo,"noQueue",disp,&noQueue,&code);
 MrmFetchLiteral(mrmInfo,"noPrimaryFile",disp,&noPrimaryFile,&code);
 MrmFetchLiteral(mrmInfo,"noCLI",disp,&noCLI,&code);
 MrmFetchLiteral(mrmInfo,"noDirectory",disp,&noDirectory,&code);
 MrmFetchLiteral(mrmInfo,"pointerMismatch",disp,&pointerMismatch,&code);
 MrmFetchLiteral(mrmInfo,"noMemory",disp,&noMemory,&code);
 MrmFetchLiteral(mrmInfo,"noPrograms",disp,&noPrograms,&code);
 MrmFetchLiteral(mrmInfo,"noUnits",disp,&noUnits,&code);
 MrmFetchLiteral(mrmInfo,"numUnits",disp,&numUnits,&code);
 MrmFetchLiteral(mrmInfo,"invalidUnit",disp,&invalidUnit,&code);
 MrmFetchLiteral(mrmInfo,"noMaxChannels",disp,&noMaxChannels,&code);
 MrmFetchLiteral(mrmInfo,"numMaxChannels",disp,&numMaxChannels,&code);
 MrmFetchLiteral(mrmInfo,"invalidMaxChannel",disp,&invalidMaxChannel,&code);
 MrmFetchLiteral(mrmInfo,"noFiles",disp,&noFiles,&code);
 MrmFetchLiteral(mrmInfo,"maxSyntax",disp,&maxSyntax,&code); 
E 2
I 2
 for ( n = XtNumber(readOut) ; n-- ; )
  MrmFetchLiteral(mrmInfo,readOut[n].name,disp,readOut[n].value,&code);
E 2
 /* Uil-Datei schliessen */
 MrmCloseHierarchy(mrmInfo);
 /* Hauptfenster aktivieren */
 XtManageChild(mainWindow);
 /* Parameter des Malbereichs auslesen */
 XtSetArg(par[0],XmNwidth,&drawWidth);
 XtSetArg(par[1],XmNheight,&drawHeight);
 XtGetValues(drawArea,par,2);
 fullRect.x = fullRect.y = 0;
 fullRect.width = drawWidth;
 fullRect.height = drawHeight;
 maxCol = (drawWidth+app.gapWidth)/fullWidth;
 maxRow = (drawHeight+app.gapHeight)/fullHeight;
 /* Messagedialoge anpassen */
 XtUnmanageChild(XmMessageBoxGetChild(noFileBox,XmDIALOG_CANCEL_BUTTON));
 XtUnmanageChild(XmMessageBoxGetChild(noFileBox,XmDIALOG_HELP_BUTTON));
 /* Erklaerungsdialog anpassen */
 XtUnmanageChild(XmMessageBoxGetChild(authorHelp,XmDIALOG_CANCEL_BUTTON));
 XtUnmanageChild(XmMessageBoxGetChild(authorHelp,XmDIALOG_HELP_BUTTON));
 /* Parameterdialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(setupDialog,XmDIALOG_LIST_LABEL));
 XtUnmanageChild(XtParent(XmSelectionBoxGetChild(setupDialog,XmDIALOG_LIST)));
 XtUnmanageChild(XmSelectionBoxGetChild(setupDialog,XmDIALOG_SELECTION_LABEL));
 XtUnmanageChild(XmSelectionBoxGetChild(setupDialog,XmDIALOG_TEXT));
D 6
 XtManageChild(XmSelectionBoxGetChild(setupDialog,XmDIALOG_APPLY_BUTTON));
E 6
 /* QMan Dialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(commandDialog,XmDIALOG_LIST_LABEL));
 XtUnmanageChild(XtParent(XmSelectionBoxGetChild(commandDialog,XmDIALOG_LIST)));
 XtUnmanageChild(XmSelectionBoxGetChild(commandDialog,XmDIALOG_SELECTION_LABEL));
 XtUnmanageChild(XmSelectionBoxGetChild(commandDialog,XmDIALOG_TEXT));
 XtUnmanageChild(XmSelectionBoxGetChild(commandDialog,XmDIALOG_APPLY_BUTTON));
 XtUnmanageChild(XmSelectionBoxGetChild(commandDialog,XmDIALOG_OK_BUTTON));
 /* PROGRAM/PRIMARY_FILE Dialog anpassen */
 XtUnmanageChild(XmFileSelectionBoxGetChild(priBox.CONVERTER,XmDIALOG_OK_BUTTON));
 XtUnmanageChild(XmFileSelectionBoxGetChild(priBox.CONVERTER,XmDIALOG_CANCEL_BUTTON));
 /* CONVERTER/INPUT=(PROGRAMS=...) Dialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.inputProgram,XmDIALOG_LIST_LABEL));
 XtUnmanageChild(XtParent(XmSelectionBoxGetChild(conBox.inputProgram,XmDIALOG_LIST)));
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.inputProgram,XmDIALOG_SELECTION_LABEL));
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.inputProgram,XmDIALOG_TEXT));
 /* CONVERTER/OUTPUT=(PROGRAMS=...) Dialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.outputProgram,XmDIALOG_LIST_LABEL));
 XtUnmanageChild(XtParent(XmSelectionBoxGetChild(conBox.outputProgram,XmDIALOG_LIST)));
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.outputProgram,XmDIALOG_SELECTION_LABEL));
 XtUnmanageChild(XmSelectionBoxGetChild(conBox.outputProgram,XmDIALOG_TEXT));
D 2
 /* Motif Dekorationen */
 XtSetArg(par[0],XmNmwmDecorations,MWM_DECOR_BORDER);
 XtSetValues(XtParent(noFileBox),par,1);
 XtSetValues(XtParent(saveFileBox),par,1);
 XtSetArg(par[0],XmNmwmDecorations,MWM_DECOR_BORDER|MWM_DECOR_TITLE);
 XtSetValues(XtParent(fileSelector),par,1);
 XtSetValues(XtParent(commandDialog),par,1);
 XtSetValues(XtParent(setupDialog),par,1);
 XtSetValues(XtParent(authorHelp),par,1);
 XtSetValues(XtParent(proBox.Selector),par,1);
 XtSetValues(XtParent(priBox.Selector),par,1);
 XtSetValues(XtParent(conBox.Selector),par,1);
 XtSetValues(XtParent(conBox.inputFile),par,1);
 XtSetValues(XtParent(conBox.inputProgram),par,1);
 XtSetValues(XtParent(conBox.outputFile),par,1);
 XtSetValues(XtParent(conBox.outputProgram),par,1);
E 2
I 2
 /* Boxdialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(boxSelector,XmDIALOG_APPLY_BUTTON));
 XmTextSetEditable(XmSelectionBoxGetChild(boxSelector,XmDIALOG_TEXT),False);
 /* Historydialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(undoSelector,XmDIALOG_APPLY_BUTTON));
 XmTextSetEditable(XmSelectionBoxGetChild(undoSelector,XmDIALOG_TEXT),False);
I 6
 /* Schwellendialog anpassen */
 XtUnmanageChild(XmSelectionBoxGetChild(thresholdSelector,XmDIALOG_LIST_LABEL));
 XtUnmanageChild(XtParent(XmSelectionBoxGetChild(thresholdSelector,XmDIALOG_LIST)));
 XtUnmanageChild(XmSelectionBoxGetChild(thresholdSelector,XmDIALOG_SELECTION_LABEL));
 XtUnmanageChild(XmSelectionBoxGetChild(thresholdSelector,XmDIALOG_TEXT));
 XtUnmanageChild(XmSelectionBoxGetChild(thresholdSelector,XmDIALOG_APPLY_BUTTON));
E 6
E 2
}

/*
  Widget abspeichern.
*/
static storeWidget(w,wp,info)
D 2
Widget w,*wp;
E 2
I 2
Widget w,wp[2];
E 2
caddr_t info;
{
 /* Speichern */
D 2
 *wp = w;
E 2
I 2
 wp[0] = w;
E 2
}

/*
I 2
  Untergeordnetes Widget abspeichern.
*/
static storeDualWidget(w,wp,info)
Widget w,wp[2];
caddr_t info;
{
 /* Speichern */
 wp[1] = w;
}

/*
E 2
  Widget anzeigen.
*/
static popupWidget(w,wp,info)
Widget w,*wp;
caddr_t info;
{
D 2
 /* Anzeigen */
 XtManageChild(*wp);
E 2
I 2
 Widget it = *wp;

 /* Geht nicht immer */
 if ( (it != noFileBox) && (it != conBox.Selector) && XtIsManaged(conBox.Selector) &&
      (it != conBox.inputFile) && (it != conBox.inputProgram) &&
      (it != conBox.outputFile) && (it != conBox.outputProgram) )
  Bell();
 else
  /* Anzeigen */
  XtManageChild(it);
E 2
}

/*
  Widget verschwinden lassen.
*/
static popdownWidget(w,wp,info)
Widget w,*wp;
caddr_t info;
{
 /* Anzeigen */
 XtUnmanageChild(*wp);
}

/*
D 2
  Callback, der nichts tut (zum Beispiel die Eingabe von ENTER ignoriert).
E 2
I 2
  Dialogparameter setzen.
E 2
*/
D 2
static noOperation()
E 2
I 2
static configureDialog(w,titlep,info)
Widget w;
int *titlep;
caddr_t info;
E 2
{
I 2
 Arg par;

 /* Parameter setzen */
 XtSetArg(par,XmNmwmDecorations,MWM_DECOR_BORDER|(*titlep ? MWM_DECOR_TITLE :0));
 XtSetValues(XtParent(w),&par,1);
E 2
D 3
}

/*
I 2
  Dummy, wird spaeter von aussen erledigt.
*/
main(argc,argv)
int argc;
String argv[];
{
 Xqueue(argc,argv);
E 3
}

/***********************************************************************

  Arbeiten mit dem Zeichenbereich

***********************************************************************/

/*
E 2
  Graphikbereich wurde sichtbar.
*/
static drawExposeCallback(w,tag,info)
Widget w;
caddr_t tag;
XmDrawingAreaCallbackStruct *info;
{
 Display *disp = XtDisplay(drawArea);
 XRectangle clip;
 Arg req[2];

 /* Graphikkontext ermitteln */
 InitGC(drawArea);
 /* Rechteck festlegen */
 clip.x = info->event->xexpose.x;
 clip.y = info->event->xexpose.y;
 clip.width = info->event->xexpose.width;
 clip.height = info->event->xexpose.height;
 XSetClipRectangles(disp,gc20,0,0,&clip,1,Unsorted);
 XSetClipRectangles(disp,gc15,0,0,&clip,1,Unsorted);
 /* Neu zeichnen */
 RefreshRectangle(clip);
 /* Volle Groesse herstellen */
 XSetClipMask(disp,gc20,None);
 XSetClipMask(disp,gc15,None);
}

/*
D 2
  Hier ist Bewegung.
E 2
I 2
  Graphikkontex initialisieren.
E 2
*/
I 2
static InitGC(w)
Widget w;
{
 unsigned long mask = GCBackground|GCForeground|GCFont|GCLineStyle|GCLineWidth|GCFillStyle; 
 Display *disp = XtDisplay(drawArea);
 Drawable win = XtWindow(drawArea);
 Arg req[2];
 int dep;

 /* Haben wir schon */
 if ( gc20 ) return;
 /* Initialisieren */
 XtSetArg(req[0],XmNbackground,&gc_val.background);
 XtSetArg(req[1],XmNforeground,&gc_val.foreground);
 XtGetValues(w,req,2);
 gc_val.line_style = LineSolid;
 gc_val.line_width = app.lineWidth;
 gc_val.fill_style = FillSolid;
 gc_val.font = app.largeFont;
 gc20 = XCreateGC(disp,win,mask,&gc_val);
 gc_val.font = app.smallFont;
 gc15 = XCreateGC(disp,win,mask,&gc_val);
 largeFont = XQueryFont(disp,app.largeFont);
 smallFont = XQueryFont(disp,app.smallFont);
 /* Hintergrundspeicher */
 dep = DefaultDepth(disp,XScreenNumberOfScreen(XtScreen(drawArea)));
 backing = XCreatePixmap(disp,win,app.boxWidth,app.boxHeight,dep);
 XCopyArea(disp,win,backing,gc15,0,0,app.boxWidth,app.boxHeight,0,0);
 /* Rahmen */
 frame = XCreatePixmap(disp,win,app.boxWidth,app.boxHeight,dep);
 XSetForeground(disp,gc15,gc_val.background);
 XFillRectangle(disp,frame,gc15,0,0,app.boxWidth,app.boxHeight);
 XSetForeground(disp,gc15,gc_val.foreground);
 XDrawRectangle(disp,frame,gc15,0,0,app.boxWidth,app.boxHeight);
 /* Cursor */
 busy = XCreateFontCursor(disp,XC_watch);
}

/*
  Neu berechnen und Zeichnen von allem.
*/
static redrawCallback(butt,newplacep,info)
Widget butt;
int *newplacep;
XmRowColumnCallbackStruct *info;
{
 /* Berechnen */
 place_pdl(&unit,*newplacep);
 /* Zeichnen */
 RefreshRectangle(fullRect);
}

/*
  Neu Zeichnen eines Teil des Feldes.
*/
RefreshRectangle(rect)
XRectangle rect;
{
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 int n,*rowp,*colp;
 pdl_unit *curu;
 box_t *curb;
 char *name;

 /* Bildschirm loeschen */
 XClearArea(disp,draw,rect.x,rect.y,rect.width,rect.height,False);
 /* Informationen anzeigen */
 for ( n = nbox ; n-- ; )
  {
   /* Ueber was reden wir hier denn */
   curb = boxes[n];
   curu = curb->unit;
   colp = &curu->col;
   rowp = &curu->row;
   /* Malen und Informationen uebernehmen */
   switch (curu->kind)
    {
     case PDL_JOB    : viewBox(rect,curb,curu->name,NULL,0);
       		       break;
     case PDL_CONV_1 : viewBox(rect,curb,curu->name,curu->primaryfile,0);
       		       break;
     case PDL_CONV_2 : if ( curu->input && (curu->input[0]->box == curb) )
       			{
       		         name = curu->input[0]->name;
       		         colp = &curu->input[0]->col;
			 rowp = &curu->input[0]->row;
		        }
		       else if ( curu->output && (curu->output[0]->box == curb) )
			{
       		         name = curu->output[0]->name;
       		         colp = &curu->output[0]->col;
			 rowp = &curu->output[0]->row;
		        }
       		       else
			name = noputString;
		       viewBox(rect,curb,name,NULL,1);
       		       break;
    }
   /* Veraenderung vermerken */
   historyPosition(colp,rowp,curb);
  }
}

/*
  Position einer Box veraendern.
*/
static historyPosition(colp,rowp,box)
int *colp,*rowp;
box_t *box;
{
 /* Ist das noetig */
 if ( (*colp == box->optx) && (*rowp == box->opty) ) return;
 /* Aendern */
 *colp = box->optx;
 *rowp = box->opty;
 /* Es hat sich was veraendert */
 if ( modified ) return;
 modified = 1;
 setCurrentFile(currentFile);
}

/*
  Box und Verbindungen darstellen.
*/
static viewBox(rect,box,name,opt,file)
XRectangle rect;
box_t *box;
char *name,*opt;
int file;
{ 
 box_t *curb;
 int n;

 /* Die Box */
 viewProgram(rect,box->optx,box->opty,name,opt,file);
 /* Alle Ausgangskanaele einzeichnen */
 for ( n = box->output.used ; n-- ; )
  if ( (curb = box->output.clist[n]) != box )
   viewConverter(rect,box->optx,box->opty,curb->optx,curb->opty);
}

/*
  Programmbox darstellen.
*/
static viewProgram(rect,col,row,name,opt,file)
XRectangle rect;
int col,row,file;
String name,opt;
{
 int x = BoxX(col),y = BoxY(row),dir,asc,desc,width,height,nheight,oheight;
 int offX = 2*app.lineWidth,offY = 2*app.lineWidth;
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 XCharStruct ov15,ov20;
 XRectangle clip;

 /* Rahmen */
 XSetForeground(disp,gc20,gc_val.background);
 XFillRectangle(disp,draw,gc20,x,y,app.boxWidth,app.boxHeight);
 XSetForeground(disp,gc20,gc_val.foreground);
 XDrawRectangle(disp,draw,gc20,x,y,app.boxWidth,app.boxHeight);
 /* Clipping berechnen */
 clip.x = x+offX;
 clip.y = y+offY;
 clip.width = width = app.boxWidth-2*offX;
 clip.height = height = app.boxHeight-2*offY;
 if ( opt )
  {
   /* - Zusaetzlicher Text */
   XTextExtents(smallFont,opt,strlen(opt),&dir,&asc,&desc,&ov15);
   /* - Platz reservieren */
   oheight = ov15.ascent+ov15.descent;
   offY += oheight+app.lineWidth;
   XDrawLine(disp,draw,gc20,x,y+offY,x+app.boxWidth,y+offY);
   height -= offY;
   offY += 2*app.lineWidth;
  }
 /* Schnittmenge mit dem Rechteck */
 if ( (clip.x+clip.width < rect.x) || (clip.x > rect.x+rect.width) ||
      (clip.y+clip.height < rect.y) || (clip.y > rect.y+rect.height) )
  return;
 if ( clip.x < rect.x )
  {
   clip.width -= rect.x-clip.x;
   clip.x = rect.x;
  }
 else if ( clip.x+clip.width > rect.x+rect.width )
  clip.width = rect.x+rect.width-clip.x;
 if ( clip.y < rect.y )
  {
   clip.height -= rect.y-clip.y;
   clip.y = rect.y;
  }
 else if ( clip.y+clip.height > rect.y+rect.height )
  clip.height = rect.y+rect.height-clip.y;
 if ( (clip.width <= 0) || (clip.height <= 0) ) return;
 /* Clipping setzen */ 
 XSetClipRectangles(disp,gc20,0,0,&clip,1,Unsorted);
 XSetClipRectangles(disp,gc15,0,0,&clip,1,Unsorted);
 /* Programmname */
 if ( height > 0 )
  {
   XTextExtents(largeFont,name,strlen(name),&dir,&asc,&desc,&ov20);
   nheight = ov20.ascent+ov20.descent;
   if ( ov20.width < width ) 
    offX += (width-ov20.width)/2;
   else if ( file )
    offX -= ov20.width-width;
   if ( nheight < height ) offY += (height-nheight)/2;
   XDrawString(disp,draw,gc20,x+offX,y+offY+nheight,name,strlen(name));
  }
 /* Kommentar */
 if ( opt ) 
  {
   if ( ov15.width > width ) x -= ov15.width-width;
   XDrawString(disp,draw,gc15,x+2*app.lineWidth,y+2*app.lineWidth+oheight,opt,strlen(opt));
  }
 /* Clipping entfernen */
 XSetClipRectangles(disp,gc20,0,0,&rect,1,Unsorted);
 XSetClipRectangles(disp,gc15,0,0,&rect,1,Unsorted);
}

/*
  Konverterlinie darstellen.
*/
static viewConverter(rect,fromC,fromR,toC,toR)
XRectangle rect;
int fromC,fromR,toC,toR;
{
 int fromX = BoxX(fromC),fromY = BoxY(fromR),toX = BoxX(toC),toY = BoxY(toR);
 int dC = toC-fromC,dR = toR-fromR,adC,adR,dX,dY,xC,yC,sign = 1;
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 int dia = 2*app.dotRadius;
 double lx,ly,l;

 /* Nulljob */
 if ( (fromC == toC) && (fromR == toR) ) return;
 /* Seite ermitteln */
 if ( (adC = dC) < 0 ) 
  {
   sign = -1;
   adC = -adC;
  }
 if ( (adR = dR) < 0 ) 
  adR = -adR;
 else
  sign = -sign;
 viewCoordinates(dC,dR,adC,adR,&fromX,&fromY);
 viewCoordinates(-dC,-dR,adC,adR,&toX,&toY);
 /* Zeichnen */
 XDrawLine(disp,draw,gc20,fromX,fromY,toX,toY);
 XFillArc(disp,draw,gc20,fromX-app.dotRadius,fromY-app.dotRadius,dia,dia,0,360*64);
 /* Pfeile */
 lx = toX-fromX;
 ly = toY-fromY;
 l = sqrt(lx*lx+ly*ly);
 xC = toX-0.8660254*app.arrowLength*lx/l;
 yC = toY-0.8660254*app.arrowLength*ly/l;
 if ( toY == fromY )
  {
   dX = 0;
   dY = app.arrowLength/2;
  }
 else
  {
   dX = app.arrowLength/sqrt(1+(lx*lx/(ly*ly)))/2;
   dY = sqrt(app.arrowLength*app.arrowLength-4*((double)dX)*dX)/2;
  }
 XDrawLine(disp,draw,gc20,xC-dX,yC-sign*dY,toX,toY);
 XDrawLine(disp,draw,gc20,xC+dX,yC+sign*dY,toX,toY);
}

/*
  Koordinaten korrigieren.
*/
static viewCoordinates(dC,dR,adC,adR,px,py)
int dC,dR,adC,adR,*px,*py;
{
 if ( (dC > 0) && (dC >= adR) )
  {
   *px += app.boxWidth;
   *py += app.boxHeight/2;
  }
 else if ( (dC < 0) && (-dC >= adR) )
  *py += app.boxHeight/2;
 else if ( (dR < 0) && (-dR >= adC) )
  *px += app.boxWidth/2;
 else if ( (dR > 0) && (dR >= adC) )
  {
   *px += app.boxWidth/2;
   *py += app.boxHeight;
  }
}

/***********************************************************************

  Arbeiten mit der Maus im Zeichenbereich.

***********************************************************************/

/*
  Anklicken eines Punktes in dem Zeichenbereich.
*/
E 2
static drawSelect(draw,event,param,npar)
Widget draw;
XEvent *event;
String param[];
Cardinal *npar;
{
I 2
 /* Nur fuer Aktivierung zustaending */
 if ( (event->type != ButtonPress) || (event->xbutton.button != 1) ) return;
 /* Position ermitteln */
 getHits(hit+curhit,event->xbutton.x,event->xbutton.y);
 /* Parameter aufsetzen */
 moving = NULL;
 moveX = event->xbutton.x;
 moveY = event->xbutton.y; 
E 2
}

I 2
/*
  Loslassen der Maus in dem Zeichenbereich.
*/
E 2
static drawUnselect(draw,event,param,npar)
Widget draw;
XEvent *event;
String param[];
Cardinal *npar;
{
I 2
 int use,n,m;
   
 /* Nur fuer Deaktivierung zustaendig */
 if ( (event->type != ButtonRelease) || (event->xbutton.button != 1) ) return;
 /* Uhrzeit vermerken */
 hit[curhit].when = event->xbutton.time;
 /* Auswerten */
 if ( moving )
  {
   /* Loeschen */
   paintBox(moveX-offX,moveY-offY,PAINT_RESTORE);
   /* Neue Position ermitteln */
   if ( !noPaint )
    {
     int newX,newY;

     /* Ausrechnen */
     newX = event->xbutton.x;
     newY = event->xbutton.y;
     if ( (newX >= 0) && (newX < drawWidth) && (newY >= 0) && (newY < drawHeight) )
      {
       int col = newX/fullWidth,row = newY/fullHeight;
  
       /* Nachsehen, ob die neue Position moeglich ist */
       if ( (col < maxCol) && (row < maxRow) && ((col != moving->optx) || (row != moving->opty)) )
	/* Fertig */
	if ( !can_place(col,row) ) 
	 Error(inUseMsg);
	else
	 {
	  /* Wurde veraendert */
	  addToHistory(moving->unit,1,HISTORY_MODIFY);
	  /* Neu zeichnen */
	  moving->optx = col;
	  moving->opty = row;
	  RefreshRectangle(fullRect);
	 }
      }
    }
   /* Doppelklick nicht erlaubt */
   curhit = 0;
  }
 else 
  {
   /* Angeklickt ist die Schnittmenge der aktuellen Situation mit hit[curhit] */
   getHits(&common,event->xbutton.x,event->xbutton.y);
   /* Durchgehen */
   for ( use = n = 0 ; n < hit[curhit].used ; n++ )
    {
     /* In 'common' suchen */
     for ( m = common.used ; m-- ; )
      if ( (common.from[m] == hit[curhit].from[n]) && (common.to[m] == hit[curhit].to[n]) )
       break;
     /* Gefunden */
     if ( m >= 0 )
      {
       hit[curhit].from[use] = common.from[m];
       hit[curhit].to[use++] = common.to[m];
      }
    }
   /* Zusammensetzen und nach Doppelklicks suchen */
   if ( !(hit[curhit].used = use) )
    curhit = 0;
   else if ( !curhit )
    curhit = 1;
   else if ( (hit[1].when-hit[0].when) > app.clickInterval )
    curhit = 0;
   else
    {
     /* Doppelklicks suchen */
     common.used = 0;
     for ( n = hit[0].used ; n-- ; )
      for ( m = hit[1].used ; m-- ; )
       if ( (hit[0].from[n] == hit[1].from[m]) && (hit[0].to[n] == hit[1].to[m]) )
        addHit(&common,hit[0].from[n],hit[0].to[n]);
     /* Nichts gefunden */
     if ( !common.used )
      {
       hit_t tmp;

       /* Kleines Vertauschen und Warten auf den naechsten Klick */
       tmp = hit[0];
       hit[0] = hit[1];
       hit[1] = tmp;
      }
     else
      {
       Widget *lists;
       box_t *act;

       /* Von vorne anfangen */
       curhit = 0;
       /* Situation abfragen */
       if ( XtIsManaged(conBox.inputProgram) )
	lists = &conBox.inputNames;
       else if ( XtIsManaged(conBox.outputProgram) )
	lists = &conBox.outputNames;
       else
	{
         if ( !XtIsManaged(conBox.Selector) )
	  {
	   /* Alle Eintraege suchen und Dialog oeffnen */
	   openBoxSelector(boxSelectMsg,&common);
          }
	 /* Fertig */
	 return;
        }
       /* Namen der echten Boxen (nicht PDL_CONV_2) ermitteln und uebertragen */
       for ( n = common.used ; n-- ; )
	if ( !common.to[n] && ((act = common.from[n])->unit->kind != PDL_CONV_2) )
	 addProgramItems(lists,act->unit->name);
      }
    }
  }
E 2
}

I 2
/*
  Nachsehen, ob eine Zeichenposition frei ist.
*/
static can_place(x,y)
int x,y;
{
 box_t *act;
 int n;

 /* Alle Boxen */
 for ( n = nbox ; n-- ; )
  if ( ((act = boxes[n])->optx == x) && (act->opty == y) )
   return 0;
 /* Geht */
 return 1;
}

/*
  Bewegung im Zeichenbereich.
*/
E 2
static drawMove(draw,event,param,npar)
Widget draw;
XEvent *event;
String param[];
Cardinal *npar;
{
I 2
 /* Nur fuer Bewegung zustaendig */
 if ( event->type != MotionNotify ) return;
 /* Schwelle beachten */
 if ( !moving )
  {
   int dx = moveX-event->xmotion.x,dy = moveY-event->xmotion.y;

   /* Abstand testen */
   if ( (dx*dx+dy*dy) < app.moveThreshold*app.moveThreshold ) return;
  }
 /* Altes loeschen */
 if ( !moving ) 
  {
   int n;

   /* Box suchen */
   for ( n = hit[curhit].used ; n-- && hit[curhit].to[n] ; );
   if ( n < 0 ) return;
   /* Und merken */
   moving = hit[curhit].from[n];
   startX = BoxX(moving->optx);
   startY = BoxY(moving->opty);
   offX = moveX-startX;
   offY = moveY-startY;
   /* Nicht neu malen, wenn Konverterselektor aktiv */
   noPaint = XtIsManaged(conBox.Selector);
  }
 else
  paintBox(moveX-offX,moveY-offY,PAINT_RESTORE);
 /* Neues zeichnen */
 moveX = event->xmotion.x;
 moveY = event->xmotion.y;
 paintBox(moveX-offX,moveY-offY,PAINT_SAVE);
 paintBox(moveX-offX,moveY-offY,PAINT_MOVE);
E 2
}

/*
D 2
  Datei ausgewaehlt.
E 2
I 2
  Bewegte Bereich zeichnen.
E 2
*/
D 2
static fileSelectionCallback(sel,tag,info)
Widget sel;
caddr_t tag;
XmFileSelectionBoxCallbackStruct *info;
E 2
I 2
static paintBox(x,y,code)
int x,y,code;
E 2
{
D 2
 String name = NULL,old;
E 2
I 2
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 Drawable src,dst;
 int sx,sy,dx,dy;
E 2

D 2
 /* String zerlegen */
 if ( !XmStringGetLtoR(info->value,XmSTRING_DEFAULT_CHARSET,&name) ) return;
 /* Selektieren */
 if ( !strcmp(openAction,"save") )
E 2
I 2
 /* Wird nicht neu gemalt */
 if ( noPaint ) return;
 /* Was ist zu tun */
 if ( code == PAINT_SAVE )
E 2
  {
D 2
   /* Alter Name */
   old = currentFile;
   /* Name aendern */
   setCurrentFile(name);
   /* Abspeichern */
   if ( !saveCurrent() )
E 2
I 2
   src = draw;
   dst = backing;
   sx = x;
   sy = y;
   dx = 0;
   dy = 0;
  }
 else
  {
   src = (code == PAINT_MOVE) ? frame : backing;
   dst = draw;
   sx = 0;
   sy = 0;
   dx = x;
   dy = y;
  }
 /* Tue es */
 XCopyArea(disp,src,dst,gc15,sx,sy,app.boxWidth,app.boxHeight,dx,dy);
}

/*
  Treffer aus der Mausposition ermitteln.
*/
static getHits(hitl,xb,yb)
hit_t *hitl;
int xb,yb;
{ 
 int n,m,x,y,fromX,fromY,toX,toY,dC,dR,adC,adR,tmp;
 box_t *curb,*tarb;

 /* Alle Boxen */
 for ( hitl->used = 0, n = nbox ; n-- ; )
  {
   /* Aktuelle Box */
   curb = boxes[n];
   /* Treffer auf die Box selbst */
   x = BoxX(curb->optx);
   y = BoxY(curb->opty);
   if ( (xb >= x) && (xb <= x+app.boxWidth) && (yb >= y) && (yb <= y+app.boxHeight) )
E 2
    {
D 2
     /* Alten Namen beibehalten */
     setCurrentFile(old);
     showCurrentFile();
E 2
I 2
     /* Die ganze Box */
     addHit(hitl,curb,NULL);
     /* Und alle Selbstverbindungen */
     for ( m = curb->output.used ; m-- ; )
      if ( (tarb = curb->output.clist[m]) == curb )
       addHit(hitl,curb,tarb);
     /* Keine weiteren Verbindungen von dieser Box aus betrachten */
     continue;
E 2
    }
I 2
   /* Alle Ausgangsverbindungen */
   for ( m = curb->output.used ; m-- ; )
    if ( (tarb = curb->output.clist[m]) != curb )
     {
      /* Parameter */
      fromX = x;
      fromY = y;
      toX = BoxX(tarb->optx);
      toY = BoxY(tarb->opty);
      if ( (adC = dC = tarb->optx-curb->optx) < 0 ) adC = -adC;
      if ( (adR = dR = tarb->opty-curb->opty) < 0 ) adR = -adR;
      /* Koordinaten der Linie */
      viewCoordinates(dC,dR,adC,adR,&fromX,&fromY);
      viewCoordinates(-dC,-dR,adC,adR,&toX,&toY);
      /* Haben wir die Linie (fromX,fromY)->(toX,toY) getroffen */
      if ( (fromX > toX) || ((fromX == toX) && (fromY > toY)) )
       {
	/* Vertauschen */
	tmp = fromX;
	fromX = toX;
	toX = tmp;
	tmp = fromY;
	fromY = toY;
	toY = tmp;
       }
      if ( fromX == toX )
       {
        /* Treffer moeglich */
        if ( (yb < fromY) || (yb > toY) ) continue;
        /* Zweite Koordinate ueberpruefen */
        if ( (adR = xb-fromX) < 0 ) adR = -adR;
       }
      else
       {
        /* Treffer moeglich */
        if ( (xb < fromX) || (xb > toX) ) continue;
        /* Zweite Koordinate ueberpruefen */
        tmp = fromY+(xb-fromX)*(toY-fromY)/(toX-fromX);
        if ( (adR = yb-tmp) < 0 ) adR = -adR;
       }
      /* Treffer */
      if ( adR <= app.hitDistance ) addHit(hitl,curb,tarb);
     }
E 2
  }
D 2
 else
  openCurrent(name,!strcmp(openAction,"new"));
E 2
I 2
 /* Anzahl melden */
 return hitl->used;
}

addHit(hitl,from,to)
hit_t *hitl;
box_t *from,*to;
{
 box_t **nf,**nt;

 /* Feld erweitern */
 if ( hitl->used == hitl->alloc )
  {
   /* Speicher allokatieren */
   checkmem(nf = MALLOC(box_t *,hitl->alloc+10));
   checkmem(nt = MALLOC(box_t *,hitl->alloc+10));
   /* Alte Bereiche kopieren */
   if ( hitl->alloc )
    {
     MEMMOVE(nf,hitl->from,hitl->alloc);
     free(hitl->from);
     MEMMOVE(nt,hitl->to,hitl->alloc);
     free(hitl->to);
    }
   /* Neue Bereiche uebernehmen */
   hitl->alloc += 10;
   hitl->from = nf;
   hitl->to = nt;
  }
 /* Eintragen */
 hitl->from[hitl->used] = from;
 hitl->to[hitl->used++] = to;
}

/***********************************************************************
  
  Arbeiten mit Listen von Elementen aus dem Malbereich.

***********************************************************************/

/*
  Dialog fuer Boxenliste oeffnen.
*/
static openBoxSelector(tit,hits)
XmString tit;
hit_t *hits;
{
 Widget list  = XmSelectionBoxGetChild(boxSelector,XmDIALOG_LIST);
 Arg par;
 int n;

E 2
 /* Speicher freigeben */
D 2
 XtFree(name);
E 2
I 2
 munit.used = 0;
 /* Title aufsetzen */
 XtSetArg(par,XmNdialogTitle,boxAction = tit);
 XtSetValues(boxSelector,&par,1);
 /* Box loeschen */
 XmListSetPos(list,1);
 XmListDeleteAllItems(list);
 /* Alles durchgehen */
 for ( n = hits->used ; n-- ; )
  if ( !hits->to[n] )
   /* Einbauen in die Liste */
   addToList(list,unitKind(hits->from[n]->unit),hits->from[n]->unit);
  else
   {
    pdl_unit *from = hits->from[n]->unit,*to = hits->to[n]->unit;
    
    /* Eine Seite ist ein CONVERTER -> fertig */
    if ( from->kind == PDL_CONV_2 )
     addToList(list,"CONVERTER",from);
    else if ( to->kind == PDL_CONV_2 )
     addToList(list,"CONVERTER",to);
    else
     {
      pdl_channel **ins,**outs;
      pdl_unit *conv;
      int m;

      /* Alle Konverter nach dem Namen absuchen */
      for ( m = unit.used ; m-- ; )
       if ( ((conv = unit.plist[m])->kind == PDL_CONV_2) &&
	    (ins = conv->input) && (ins[0]->kind == PDL_PROGRAM) &&
	    (outs = conv->output) && (outs[0]->kind == PDL_PROGRAM) )
	{
	 /* Namen suchen */
	 while ( *ins && strcmp(ins[0]->name,from->name) ) ins++;
	 if ( *ins ) 
	  {
	   while ( *outs && strcmp(outs[0]->name,to->name) ) outs++;
	   if ( *outs ) addToList(list,"CONVERTER",conv);
	  }
	}
     }
   }
 /* Aufrufen */
 if ( munit.used )
  if ( (tit == boxSelectMsg) && (munit.used == 1) )
   fillSelector(munit.plist[0]);
  else
   XtManageChild(boxSelector);
E 2
}

/*
D 2
  Datei sichern.
E 2
I 2
  Einbauen eines Elementes in ein Listwidget.
E 2
*/
D 2
static saveCallback(dialog,tag,info)
E 2
I 2
static addToList(list,pref,unit)
Widget list;
char *pref;
pdl_unit *unit;
{
 static char full[256];
 XmString item;
 Arg par;

 /* Zusammensetzen */
 strcpy(full,pref);
 strcat(full," ");
 strcat(full,unit->name);
 /* Erzeugen */
 checkmem(item = newstr(full));
 /* Testen */
 if ( XmListItemExists(list,item) )
  /* Nicht beruecksichtigen */
  XmStringFree(item);
 else
  {
   /* Einbauen */
   XmListAddItemUnselected(list,item,0);
   /* Ersten Eintrag in der Liste auswaehlen */
   if ( !munit.used ) XmListSelectPos(list,0,True);
   /* In die Liste eintragen */
   if ( munit.used == munit.alloc ) free_pdl(&munit,alloc_pdl(&munit));
   munit.plist[munit.used++] = unit;
  }
}

/*
  Da hat doch einer den Dialog fuer die Boxen beendet.
*/
static boxCallback(dialog,tag,info)
E 2
Widget dialog;
caddr_t tag;
D 2
XmAnyCallbackStruct *info;
E 2
I 2
XmSelectionBoxCallbackStruct *info;
E 2
{
D 2
 /* Selektieren */
E 2
I 2
 int *pos,posn;

 /* Auslesen */
E 2
 if ( info->reason == XmCR_OK )
I 2
  if ( XmListGetMatchPos(XmSelectionBoxGetChild(dialog,XmDIALOG_LIST),info->value,&pos,&posn) )
   {
    /* Auswerten */
    if ( (posn == 1) && pos )
     if ( boxAction == boxSelectMsg )
      fillSelector(munit.plist[pos[0]-1]);
     else
      {
       int curhist = history.used;

       /* Loeschen */
       if ( !deleteHistory(munit.plist[pos[0]-1]) )
	{
	 /* Aufraeumen und Fehler melden */
	 backupHistory(curhist);
	 Error(noconnMsg);
        }
       /* Neu zeichnen */
       place_pdl(&unit,0);
       RefreshRectangle(fullRect);
      }
    /* Speicher freigeben */
    XtFree(pos);
   }
 /* Dialog schliessen */
 XtUnmanageChild(dialog);
}

/*
  Loeschen von Elementen.
*/
static cutCallback(butt,tag,info)
Widget butt;
caddr_t tag;
XmRowColumnCallbackStruct *info;
{
 /* Nachsehen, ob etwas in der Liste steht */
 if ( !curhit || !hit[0].used ) 
E 2
  {
D 2
   /* Sichern */
   if ( !saveCurrent() ) return;
   /* Requester aufrufen */
   if ( !terminateNormally ) XtManageChild(fileSelector);
E 2
I 2
   Bell();
   return;
E 2
  }
D 2
 else if ( info->reason == XmCR_CANCEL )
E 2
I 2
 /* Box oeffnen, Doppelklick gilt ab jetzt nicht mehr */
 openBoxSelector(boxDeleteMsg,hit+(curhit = 0));
}

/***********************************************************************

  Manipulation der UNDO Liste.

***********************************************************************/

/*
  Aufsetzen des Historyselektors.
*/
static undoSetup(butt,tag,info)
Widget butt;
caddr_t tag;
XmRowColumnCallbackStruct *info;
{
 Widget list = XmSelectionBoxGetChild(undoSelector,XmDIALOG_LIST);
 int n;

 /* Ist das denn leer ? */
 if ( !history.used )
E 2
  {
D 2
   /* Vermerken */
   modified = 0;
   /* Requester aufrufen */
   if ( !terminateNormally ) XtManageChild(fileSelector);
E 2
I 2
   /* Nun ja, vielleicht naechstes Mal */
   Bell();
   return;
E 2
  }
I 2
 /* Items einfuellen */
 XmListSetPos(list,1);
 XmListDeleteAllItems(list);
 /* Nun die Liste durchgehen */
 for ( n = 0 ; n < history.used ; n++ )
  {
   XmString item;

   /* Item erzeugen */
   checkmem(item = newstr(history.plist[n]->history));
   /* Anhaengen */
   XmListAddItemUnselected(list,item,0);
   /* Selektieren */
   if ( history.plist[n]->history[0] == HISTORY_MARK ) XmListSelectPos(list,0,True);
  }
 /* Dialog oeffnen */
 XtManageChild(undoSelector);
}

/*
  Letzte Aktion rueckgaengig machen.
*/
static undoCallback(w,morep,info)
Widget w;
int *morep;
XmSelectionBoxCallbackStruct *info;
{
 Widget list = XmSelectionBoxGetChild(undoSelector,XmDIALOG_LIST);
 int n = -1,*pos,posn;

 if ( !*morep )
  /* Legalen Eintrag suchen */
  for ( n = history.used ; n-- && (history.plist[n]->history[0] != HISTORY_MARK) ; );
 else if ( info->reason != XmCR_OK )
  {
   /* Dialog beenden */
   XtUnmanageChild(w);
   return;
  }
 else if ( XmListGetMatchPos(list,info->value,&pos,&posn) )
  {
   /* Eintrag muss global sein */
   if ( (posn == 1) && pos )
    if ( history.plist[pos[0]-1]->history[0] != HISTORY_NONE )
     {
      /* Position festhalten */
      n = pos[0]-1;
      /* Dialog beenden */
      XtUnmanageChild(w);
     }
    else
     {
      /* Dem Benutzer zeigen, was er darf */
      while ( (--(pos[0]) > 0) && (history.plist[pos[0]-1]->history[0] == HISTORY_NONE) );
      if ( pos[0] > 0 )
       {
	/* Selektion aendern */
	XmListDeselectAllItems(list);
	XmListSelectPos(list,pos[0],True);
       }
     }
   /* Speicher freigeben */
   XtFree(pos);
  }
 if ( n < 0 )
  {
   /* Liste ist leer oder Selektion illegal */
   Bell();
   return;
  }
 /* Aktion rueckgaengig machen und neu zeichnen */
 backupHistory(n);
 place_pdl(&unit,0);
 RefreshRectangle(fullRect);
}

/***********************************************************************

  Umsetzen von Eingaben in die PDL Elemente

***********************************************************************/

/*
  Je nach Wunsch Selector mit den Daten einer UNIT fuellen und oeffnen.
*/
static fillSelector(unit)
pdl_unit *unit;
{
 cldBox *cur;
 char *tmp;

 /* Jetzt tun wir was */
 busyCursor(mainWindow);
 /* Welche Art von Box */
 switch (unit->kind)
  {
   case PDL_JOB    : cur = &proBox;
		     break;
   case PDL_CONV_1 : cur = &priBox;
		     break;
   case PDL_CONV_2 : cur = &conBox;
     		     break;
  }
 /* Werte einsetzen */
 set_integer(cur->CPUTIME,unit->cputime);
 set_integer(cur->DATASIZE,unit->datasize);
 set_integer(cur->MEMORYSIZE,unit->memorysize);
 set_integer(cur->PRIORITY,unit->priority);
 set_integer(cur->STACKSIZE,unit->stacksize);
 set_boolean(cur->KEEP,unit->keep);
 if ( cur-> RMSFILE ) set_boolean(cur->RMSFILE,unit->rmsfile);
 if ( cur->CONVERTER )
  {
   set_selector(cur->Selector,unit->primaryfile);
   set_monadic(cur->CONVERTER,unit->filename);
  }
E 2
 else
  {
D 2
   /* Fenster entfernen */
   XtUnmanageChild(dialog);
   /* Nicht aufhoeren */
   terminateNormally = 0;
E 2
I 2
   set_selector(cur->Selector,unit->filename);
   if ( cur->CLI[0] ) set_cli(cur->CLI,cur->cliCSH,cur->cliSH,cur->cliDCL,unit->shell);
E 2
  }
D 2
 /* Aufhoeren */
 if ( terminateNormally ) terminateNormally = 2;
E 2
I 2
 set_string(cur->PRINTER,unit->printer);
 set_string(cur->QUEUE,unit->queue);
 set_params(cur->PARAMETERS,unit->params);
 if ( cur->INPUT[0] )
  set_chans(cur->INPUT,unit->input,
	    cur->inputFILE,cur->inputPROGRAM,cur->inputFileList,cur->inputLists);
 if ( cur->OUTPUT[0] )
  set_chans(cur->OUTPUT,unit->output,
	    cur->outputFILE,cur->outputPROGRAM,cur->outputFileList,cur->outputLists);
 /* Jobname */
 checkmem(tmp = fileToName(unit->filename));
 strupper(tmp);
 set_string(cur->NAME,!strcmp(unit->name,tmp) ? NOQUAL : unit->name);
 free(tmp);
 /* Logdatei und Jobname */
 set_string(cur->LOGFILE,setLogfile(unit));
 /* Fertig */
 normalCursor(mainWindow);
 /* Dialog anzeigen */
 XtManageChild(cur->Selector);
 /* Und noch merken, was los war */
 curUnit = unit;
E 2
}

/*
  Schalter umgelegt.
*/
static toggleCallback(button,valuep,info)
Widget button,*valuep;
XmToggleButtonCallbackStruct *info;
{
 /* Wert auslesen und Textfeld umschalten */
 XtSetSensitive(*valuep,info->set ? True : False);
 /* PARAMETERS hat auch einen Vater */
D 2
 if ( (*valuep == proBox.PARAMETERS) || 
      (*valuep == priBox.PARAMETERS) || 
      (*valuep == conBox.PARAMETERS) )
E 2
I 2
 if ( (valuep == proBox.PARAMETERS) || 
      (valuep == priBox.PARAMETERS) || 
      (valuep == conBox.PARAMETERS) )
E 2
  XtSetSensitive(XtParent(*valuep),info->set ? True : False);
 /* PRINTER beeinflusst KEEP */
D 2
 else if ( *valuep == proBox.PRINTER ) 
E 2
I 2
 else if ( valuep == proBox.PRINTER ) 
E 2
  XmToggleButtonSetState(proBox.KEEP,info->set ? False : True);
D 2
 else if ( *valuep == priBox.PRINTER ) 
E 2
I 2
 else if ( valuep == priBox.PRINTER ) 
E 2
  XmToggleButtonSetState(priBox.KEEP,info->set ? False : True);
D 2
 else if ( *valuep == conBox.PRINTER ) 
E 2
I 2
 else if ( valuep == conBox.PRINTER ) 
E 2
  XmToggleButtonSetState(conBox.KEEP,info->set ? False : True);
}

/*
D 2
  Fehlermeldung aufsetzen.
E 2
I 2
  PROGRAM Spezifikation abgeschlossen.
E 2
*/
D 2
PopupErrorDialog(msg)
XmString msg;
E 2
I 2
static programCallback(dialog,dialogp,info)
Widget dialog,*dialogp;
XmFileSelectionBoxCallbackStruct *info;
E 2
{
D 2
 Arg par;

 /* Parameter aendern */
 XtSetArg(par,XmNmessageString,msg);
 XtSetValues(noFileBox,&par,1);
 /* Anzeigen */
 XtManageChild(noFileBox);
}

/*
  Titel des Hauptfensters setzen.
*/
setCurrentFile(name)
String name;
{
 int len = -1;
 String tmp;
 Arg par;
 
 /* Speicher freigeben */
 if ( currentFile ) free(currentFile);
 /* Aufsetzen */
 if ( !(currentFile = name) )
E 2
I 2
 /* Name einsetzen und nur weiter, wenn der OK-Knopf angeklickt wurde */
 setVMSName(dialog,info->value);
 if ( !info->event || (info->event->type != ButtonRelease) ) return;
 /* Auswerten */
 if ( info->reason == XmCR_OK ) 
E 2
  {
D 2
   /* Leerer Name */
   tmp = noloadMsg;
   modified = 0;
   /* Kein SAVE mehr erlaubt */
   XtSetSensitive(save_button,False);
   XtSetSensitive(save_as_button,False);
  }
 else 
  {
   /* Speicher reservieren */
   checkmem(currentFile = strdup(currentFile));
   /* Name aufbauen */
   if ( !modified || !*modMsg )
    tmp = currentFile;
E 2
I 2
   cldBox *cur = (cldBox *)dialogp;
   int curhist = history.used;
   pdl_unit *new;
  
   /* PROGRAM Struktur erzeugen und Parameter ueberpruefen */
   new = alloc_pdl(&unit);
   busyCursor(dialog);
   if ( setjmp(&errjmp) )
    {
     /* Historyliste aufraeumen */
     backupHistory(curhist);
     /* Da war ein Fehler */
     normalCursor(dialog);
     if ( new ) free_pdl(&unit,new);
     /* Probieren wir es halt noch einmal */
     return;
    }
E 2
   else
    {
D 2
     len = strlen(currentFile)+1+strlen(modMsg)+1;
     checkmem(tmp = MALLOC(char,len));
     strcpy(tmp,currentFile);
     strcat(tmp," ");
     strcat(tmp,modMsg);
E 2
I 2
     /* Alle Parameter uebernehmen */
     new->cputime = get_integer(cur->CPUTIME,-1,1,50*366*24*60*60);
     new->datasize = get_integer(cur->DATASIZE,-1,10,1024*1024);
     new->memorysize = get_integer(cur->MEMORYSIZE,-1,10,1024*1024);
     new->priority = get_integer(cur->PRIORITY,-1,0,255);
     new->stacksize = get_integer(cur->STACKSIZE,-1,10,1024*1024);
     new->keep = get_boolean(cur->KEEP);
     if ( cur->RMSFILE ) new->rmsfile = get_boolean(cur->RMSFILE);
     if ( cur->CONVERTER )
      {
       new->filename = get_monadic(cur->CONVERTER);
       new->primaryfile = get_selector(info->value);
      }
     else
      {
       new->filename = get_selector(info->value);
       if ( cur->CLI[0] ) new->shell = get_cli(cur->CLI,cur->cliCSH,cur->cliSH,cur->cliDCL);
      }
     new->name = get_string(cur->NAME);
     new->printer = get_string(cur->PRINTER);
     new->logfile = get_string(cur->LOGFILE);
     new->queue = get_string(cur->QUEUE);
     new->params = get_params(cur->PARAMETERS);
     if ( cur->INPUT[0] ) 
      new->input = get_chans(cur->INPUT,cur->inputFILE,cur->inputFileList,cur->inputLists);
     if ( cur->OUTPUT[0] ) 
      new->output = get_chans(cur->OUTPUT,cur->outputFILE,cur->outputFileList,cur->outputLists);
     /* Weiter verfahren je nach Art des neuen Elementes */
     new->kind = ((cur == &proBox) ? PDL_JOB : ((cur == &priBox) ? PDL_CONV_1 : PDL_CONV_2));
     /* Nicht angegebene Parameter einsetzen */
     if ( (new->name == NOQUAL) || !new->name ) 
      checkmem(new->name = fileToName(new->filename));
     new->col = new->row = -1;
     if ( (new->kind == PDL_CONV_2) && !new->input && !new->output )
      {
       Error(noconnMsg);
       longjmp(&errjmp,1);
      }
     /* Name verifizieren */
     if ( !*new->name )
      {
       Error(illNameMsg);
       longjmp(&errjmp,1);
      }
     /* Nun die Aenderungen aufnehmen */
     if ( curUnit )
      {
       /* Aenderungen uebernehmen */
       modifyHistory(curUnit,new);
       /* Temporaere Struktur entfernen */
       free_pdl(&unit,new);
       new = NULL;
      }
     else
      /* Neues eintragen */
      addToHistory(new,1,HISTORY_CREATE);
     /* Neu aufbauen */
     normalCursor(dialog);
     busyCursor(mainWindow);
     if ( !place_pdl(&unit,0) )
      {
       /* Fehler bearbeiten */
       Error(noplaceMsg);
       longjmp(&errjmp,1);
      }
     /* Neu zeichnen */
     RefreshRectangle(fullRect);
     normalCursor(mainWindow);
E 2
    }
D 2
   /* SAVE wieder erlauben */
   XtSetSensitive(save_button,True);
   XtSetSensitive(save_as_button,True);
E 2
  }
D 2
 /* Aendern */
 XtSetArg(par,XmNtitle,tmp);
 XtSetValues(top,&par,1);
 /* Eleminieren */
 if ( len >= 0 ) free(tmp);
E 2
I 2
 /* Fertig */
 curUnit = NULL;
 XtUnmanageChild(dialog);
E 2
}

/*
D 2
  Aktuelle Datei anzeigen.
E 2
I 2
  Auslesen einer Zahl aus einem TextField Widget.
E 2
*/
D 2
showCurrentFile()
E 2
I 2
static get_integer(tf,def,min,max)
Widget tf[2];
int def,min,max;
E 2
{
D 2
 /* Anzeigen */
 if ( !currentFile ) return;
 mputs("");
 mprintf(usingFile,currentFile);
E 2
I 2
 char *str;
 int res;

 /* Auslesen */
 if ( ((str = get_string(tf)) == NOQUAL) || !str ) return def;
 /* Umwandeln */
D 6
 if ( isNumber(str,&res,min,max,(XmString *)NULL) ) return res;
E 6
I 6
 if ( isNumber(str,&res,min,max,(XmString *)NULL,1) ) return res;
E 6
 /* Fehler bearbeiten */
 longjmp(&errjmp,1);
E 2
}

/*
D 2
  Togglebuttons setzen.
E 2
I 2
  Nummer umwandeln.
E 2
*/
D 2
setToggleButtons()
E 2
I 2
D 6
static isNumber(str,resp,min,max,err)
E 6
I 6
static isNumber(str,resp,min,max,err,freeit)
E 6
char *str;
D 6
int *resp,min,max;
E 6
I 6
int *resp,min,max,freeit;
E 6
XmString *err;
E 2
{
D 2
 /* Alle */
 XmToggleButtonGadgetSetState(verify_button,unit.verify,False);
 XmToggleButtonGadgetSetState(debug_button,unit.debug,False);
 XmToggleButtonGadgetSetState(version_button,unit.version,False);
E 2
I 2
 char *more,last;

 /* Umwandeln */
 errno = 0;
 *resp = strtoul(str,&more,0);
 last = *more;
D 6
 XtFree(str);
E 6
I 6
 if ( freeit ) XtFree(str);
E 6
 /* Fehler ermitteln */
 if ( ((*resp == -1) && errno) || !more || last || (more == str) )
  if ( err )
   *err = nonumMsg;
  else
   Error(nonumMsg);
 else if ( (*resp < min) || (*resp > max) )
  if ( err )
   *err = illnumMsg;
  else
   Error(illnumMsg);
 else
  return 1;
 /* Fehler */
 return 0;
E 2
}

/*
D 2
  Outputmode auslesen.
E 2
I 2
  Auslesen einer Zeichenkette aus einem TextField Widget.
E 2
*/
D 2
modeVerbose()
E 2
I 2
static char *get_string(tf)
Widget tf[2];
E 2
{
D 2
 Widget butt;
E 2
I 2
 char *res;

 /* Nicht vorhanden */
 if ( !get_boolean(tf[1]) ) return NOQUAL;
 /* Wert ermitteln */
 if ( !(res = XmTextFieldGetString(tf[0])) ) return NOQUAL;
 if ( *res ) return res;
 /* Default einsetzen */
 XtFree(res);
 return NOSTR;
}

/*
  Auswerten des CLI Menus.
*/
static char *get_cli(cm,csh,sh,dcl)
Widget cm[2],csh,sh,dcl;
{
 Widget active;
 char *it;
E 2
 Arg req;

I 2
 /* Nicht vorhanden */
 if ( !get_boolean(cm[1]) ) return NOQUAL;
E 2
 /* Auslesen */
D 2
 XtSetArg(req,XmNmenuHistory,&butt);
 XtGetValues(outputMenu,&req,1);
 /* Melden */
 return (!butt || (butt == noisy_button));
E 2
I 2
 XtSetArg(req,XmNmenuHistory,&active);
 XtGetValues(cm[0],&req,1);
 /* Auswerten */
 it = ((active == csh) ? "CSH" : ((active == sh) ? "SH" : "DCL"));
 /* Speicher reservieren und Ergebnis melden */
 checkmem(it = strdup(it));
 return it;
E 2
}

/*
D 2
  Dateiname auslesen.
E 2
I 2
  Auslesen des Textes einer FileSelectionBox.
E 2
*/
D 2
static String getTextValue(w)
Widget w;
{ 
 static String tmp = NULL;
E 2
I 2
static char *get_selector(xms)
XmString xms;
{
 char *res = NULL;
E 2

D 2
 /* Alten Speicher freigeben */
 if ( tmp ) XtFree(tmp);
 /* Neues Feld einlesen */
 return (tmp = XmTextFieldGetString(w));
E 2
I 2
 /* Name auslesen */
 if ( !XmStringGetLtoR(xms,XmSTRING_DEFAULT_CHARSET,&res) || !res)
  {
   /* Fehler anzeigen und aufhoeren */
   Error(illFileMsg);
   longjmp(&errjmp,1);
  }
 /* Fertig */
 return get_vms(res);
E 2
}

I 2
static char *get_monadic(fs)
Widget fs;
{
 char *res;

 /* Name auslesen */
 if ( !(res = XmTextGetString(XmFileSelectionBoxGetChild(fs,XmDIALOG_TEXT))) )
  {
   /* Fehler anzeigen und aufhoeren */
   Error(illFileMsg);
   longjmp(&errjmp,1);
  }
 /* Fertig */
 return get_vms(res);
}

E 2
/*
D 2
  Datei einlesen.
E 2
I 2
  Dateiname eventuell umwandeln.
E 2
*/
D 2
static popupFileSelector(butt,what,info)
Widget butt;
String what;
XmRowColumnCallbackStruct *info;
E 2
I 2
static char *get_vms(name)
char *name;
E 2
{
D 2
 int issave = !strcmp(what,"save");
E 2
I 2
 char *tra;
E 2

D 2
 /* Speichern nur, wenn Datei vorhanden */
 if ( issave && !currentFile ) return;
 /* Merken */
 openAction = what;
 /* Eventuell Dialog anwerfen */
 XtManageChild((!issave && modified) ? saveFileBox : fileSelector);
E 2
I 2
 /* Umwandeln, falls noetig */
 if ( (*name != '/') && (tra = translate_vms(name)) && (tra != NOQUAL) )
  {
   /* Speicher reservieren */
   XtFree(name);
   checkmem(name = strdup(tra));
  }
 /* Darf kein Leerstring sein */
 if ( !*name )
  {
   /* Fehler anzeigen und aufhoeren */
   Error(illFileMsg);
   longjmp(&errjmp,1);
  }
 /* Ergebnis melden */
 return name;
E 2
}

/*
D 2
  Befehls des QMan ausfuehren.
E 2
I 2
  Auslesen einer Liste von Parametern als Zeilen eines Text Widgets.
E 2
*/
D 2
static executeCommand(comm,tag,info)
Widget comm;
caddr_t tag;
XmCommandCallbackStruct *info;
E 2
I 2
static char **get_params(pt)
Widget pt[0];
E 2
{
D 2
 String line = NULL;
E 2
I 2
 char *res,*scan,*cur,**arr;
 int n,m;
E 2

D 2
 /* Wert auslesen */
 if ( !XmStringGetLtoR(info->value,XmSTRING_DEFAULT_CHARSET,&line) )  return;
 /* Befehl ausfuehren */
 printf("QMan <%s>\n",line);
E 2
I 2
 /* Nicht vorhanden */
 if ( !get_boolean(pt[1]) ) return (char **)NOQUAL;
 /* Wert ermitteln */
 if ( !(res = XmTextGetString(pt[0])) || !*res ) 
  {
   if ( res ) XtFree(res);
   return (char **)NOQUAL;
  }
 /* Zeilen zaehlen */
 for ( n = 0, scan = res ; *scan ; )
  if ( *scan++ == '\n' )
   n++;
 /* Speicher reservieren */
 checkmem(arr = MALLOC(char *,n+2));
 /* Zeilen aufsetzen */
 for ( m = 0, scan = cur = res ; *scan ; )
  if ( *scan++ == '\n' )
   {
    /* Zeile abschliessen und uebernehmen */
    scan[-1] = '\0';
    checkmem(arr[m++] = strdup(cur));
    /* Naechste Zeile */
    cur = scan;
   }
 /* Letzte Zeile */
 if ( *cur ) checkmem(arr[m++] = strdup(cur));
 /* Trenner */
 arr[m] = NULL;
E 2
 /* Speicher freigeben */
D 2
 XtFree(line);
E 2
I 2
 XtFree(res);
 /* Fertig */
 return arr;
E 2
}

/*
D 2
  Defaultparameter abspeichern.
E 2
I 2
  Kanalliste erstellen.
E 2
*/
D 2
static setupCallback(dialog,action,info)
Widget dialog;
String action;
XmSelectionBoxCallbackStruct *info;
E 2
I 2
static pdl_channel **get_chans(iom,file,flist,plists)
Widget iom[2],file,flist,plists[2][3];
E 2
{
D 2
 static char xbuf[256];
 String name;
 FILE *f;
E 2
I 2
 pdl_channel **nc = NULL,*cur;
 XmString fail = NULL;
 XmStringTable names;
 Widget active;
 Arg req[2];
 int cnt,n;
E 2

D 2
 /* Dateiname ermitteln */
 if ( *(name = paramFile()) == '~' )
E 2
I 2
 /* NOxxx */
 if ( !XtIsSensitive(iom[0]) ) return nc;
 /* Art des Kanals */
 XtSetArg(req[0],XmNmenuHistory,&active);
 XtGetValues(iom[0],req,1);
 /* Liste */
 XtSetArg(req[0],XmNitemCount,&cnt);
 XtSetArg(req[1],XmNitems,&names);
 if ( active == file )
E 2
  {
D 2
   struct passwd *usr;
   String uname;
   
   /* Ende des Namens */
   strcpy(xbuf,name+1);
   for ( uname = xbuf ; *uname && (*uname != '/') ; uname++ );
   *uname++ = '\0';
   /* HOME ermitteln */
   usr = xbuf[0] ? getpwnam(xbuf) : getpwuid(getuid());
   if ( !usr )
E 2
I 2
   char *res,*tra;

   /* FILENAMES */
   XtGetValues(flist,req,2);
   /* Speicher reservieren */
   checkmem(nc = MALLOC(pdl_channel *,cnt+1));
   /* Informationen uebertragen */
   for ( n = cnt ; n-- > 0 ; )
E 2
    {
D 2
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
E 2
I 2
     /* Feld allokatieren */
     checkmem(cur = (nc[n] = SALLOC(pdl_channel)));
     /* Feld initialisieren */
     cur->kind = PDL_FILE;
     cur->col = cur->row = -1;
     /* Name uebertragen */
     res = NULL;
     if ( !XmStringGetLtoR(names[n],XmSTRING_DEFAULT_CHARSET,&res) || !res )
      {
       /* Aufhoeren */
       fail = illFileMsg;
       break;
      }
     /* Umwandeln, falls noetig */
     if ( (*res != '/') && (tra = translate_vms(res)) && (tra != NOQUAL) )
      {
       /* Speicher reservieren */
       XtFree(res);
       checkmem(res = strdup(tra));
      }
     /* Name uebernehmen */
     cur->name = res;
E 2
    }
D 2
   else
    {
     /* Dateiname zusammensetzen */
     strcpy(xbuf,usr->pw_dir);
     strcat(xbuf,name+(uname-xbuf));
     /* Veraenderten Namen benutzen */
     name = xbuf;
    }
E 2
  }
D 2
 /* Was ist zu tun */
 if ( !strcmp(action,"load") )
E 2
I 2
 else
E 2
  {
D 2
   unsigned char len;
   Boolean mode;
   Arg set;
E 2
I 2
   XmStringTable units,channels;
   char *name,*unit,*channel;
   int ucnt,ccnt;
E 2

D 2
   /* Laden */
   if ( !(f = fopen(name,"r")) )
E 2
I 2
   /* PROGRAMS */
   XtGetValues(plists[0][ixNames],req,2);
   XtSetArg(req[0],XmNitemCount,&ucnt);
   XtSetArg(req[1],XmNitems,&units);
   XtGetValues(plists[0][ixUnits],req,2);
   XtSetArg(req[0],XmNitemCount,&ccnt);
   XtSetArg(req[1],XmNitems,&channels);
   XtGetValues(plists[0][ixChannels],req,2);
   /* Speicher reservieren */
   checkmem(nc = MALLOC(pdl_channel *,cnt+1));
   for ( n = cnt ; n-- > 0 ; )
E 2
    {
D 2
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
E 2
I 2
     /* Feld allokatieren */
     checkmem(cur = (nc[n] = SALLOC(pdl_channel)));
     /* Feld initialisieren */
     cur->kind = PDL_PROGRAM;
     cur->col = cur->row = -1;
     /* Werte auslesen */
     name = unit = channel = NULL;
     if ( !XmStringGetLtoR(names[n],XmSTRING_DEFAULT_CHARSET,&name) || !name )
      {
       /* Fehler */
       fail = illNameMsg;
       break;
      }
     if ( (n >= ucnt) || !XmStringGetLtoR(units[n],XmSTRING_DEFAULT_CHARSET,&unit) ) 
      unit = NULL;
     if ( (n >= ccnt) || !XmStringGetLtoR(channels[n],XmSTRING_DEFAULT_CHARSET,&channel) ) 
      channel = NULL;
     /* Umsetzen */
     cur->name = name;
     if ( !unit )
      cur->unit = 10;
D 6
     else if ( !isNumber(unit,&cur->unit,1,999,&fail) )
E 6
I 6
     else if ( !isNumber(unit,&cur->unit,1,999,&fail,1) )
E 6
      {
       /* Fehler */
       if ( channel ) XtFree(channel);
       break;
      }
     if ( !channel )
      cur->max = 255;
D 6
     else if ( !isNumber(channel,&cur->max,1,255,&fail) )
E 6
I 6
     else if ( !isNumber(channel,&cur->max,1,255,&fail,1) )
E 6
      break;
E 2
    }
D 2
   /* Ausgabemodus */
   fread(&mode,sizeof(mode),1,f);
   XtSetArg(set,XmNmenuHistory,mode ? noisy_button : silent_button);
   XtSetValues(outputMenu,&set,1);
   /* Hostname */
   fread(&len,sizeof(len),1,f);
   fread(xbuf,1,len,f);
   xbuf[len] = '\0';
   XmTextFieldSetString(hostName,xbuf);
   /* Queuename */
   fread(&len,sizeof(len),1,f);
   fread(xbuf,1,len,f);
   xbuf[len] = '\0';
   XmTextFieldSetString(queueName,xbuf);
   /* Datei schliessen */
   fclose(f);
E 2
  }
D 2
 else 
E 2
I 2
 /* Fehler bearbeiten */
 if ( fail )
E 2
  {
D 2
   Boolean mode = modeVerbose();
   unsigned char len;
E 2
I 2
   /* Aufraeumen */
   free_channels(nc);
   /* Fehler anzeigen und aufhoeren */
   Error(fail);
   longjmp(&errjmp,1);
  }
 /* Ergebnis melden */
 return nc;
}
E 2

D 2
   /* Speichern */
   if ( !(f = fopen(name,"w")) )
    {
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
    }
   /* Ausgabemodus */
   fwrite(&mode,sizeof(mode),1,f);
   /* Hostname */
   len = strlen(queueManager());
   fwrite(&len,sizeof(len),1,f);
   fwrite(queueManager(),1,len,f);
   /* Queuename */
   len = strlen(parallelQueue());
   fwrite(&len,sizeof(len),1,f);
   fwrite(parallelQueue(),1,len,f);
   /* Fertig */
   fclose(f);
E 2
I 2
/*
  Einsetzen einer Zahl oder eines Textes in ein TextField Widget.
*/
static set_strint(tf,item,conv)
Widget tf[2];
char *item;
int conv;
{
 static char buf[20];
 int valid;

 /* Zahl oder Zeichenkette */
 if ( !conv )
  /* Text uebernehmen */
  valid = (item && (item != NOQUAL));
 else if ( valid = (((int)item) != -1) )
  {
   /* Zahl in Text umwandeln */
   sprintf(buf,"%d",(int)item);
   item = buf;
E 2
  }
I 2
 /* In das Widget eintragen */
 XtSetSensitive(tf[0],valid);
 XmTextFieldSetString(tf[0],valid ? item : "");
 /* Button setzen */
 set_boolean(tf[1],valid);
E 2
}

/*
D 2
  PROGRAM Spezifikation abgeschlossen.
E 2
I 2
  Setzen des CLI Menus.
E 2
*/
D 2
static programCallback(dialog,tag,info)
Widget dialog;
caddr_t tag;
XmFileSelectionBoxCallbackStruct *info;
E 2
I 2
static set_cli(cm,csh,sh,dcl,shell)
Widget cm[2],csh,sh,dcl;
char *shell;
E 2
{
D 2
 /* Name einsetzen */
 setVMSName(dialog,info->value);
 /* Nur, wenn der OK-Knopf angeklickt wurde */
 if ( !info->event || (info->event->type != ButtonRelease) ) return;
 /* Auswerten */
 if ( info->reason == XmCR_OK ) 
E 2
I 2
 Widget active = csh;
 int valid;
 Arg req;

 /* Aufsetzen */
 if ( valid = (shell && (shell != NOQUAL)) )
  if ( !strcmp(shell,"SH") )
   active = sh;
  else if ( !strcmp(shell,"DCL") )
   active = dcl;
 if ( valid ) valid = (active != csh);
 /* Menu fuellen */
 XtSetArg(req,XmNmenuHistory,active);
 XtSetValues(cm[0],&req,1);
 XtSetSensitive(cm[0],valid);
 /* Button */
 set_boolean(cm[1],valid);
}

/*
  Setzen einer Liste von Parametern.
*/
static set_params(pt,arr)
Widget pt[2];
char **arr;
{
 int valid,len;

 /* Leeren */
 XmTextSetString(pt[0],"");
 /* Mal sehen, was zu tun ist */
 if ( valid = (arr && (arr != (char **)NOQUAL) && *arr) )
  /* Eintragen jeder Zeile */
  for ( len = 0 ; *arr ; )
   {
    XmTextInsert(pt[0],len,*arr);
    len += strlen(*arr++);
    XmTextInsert(pt[0],len++,"\n");
   }
 /* Rest setzen */
 XtSetSensitive(pt[0],valid);
 XtSetSensitive(XtParent(pt[0]),valid);
 /* Button */
 set_boolean(pt[1],valid);
}

/*
  Kanalliste erzeugen.
*/
static set_chans(iom,list,fmenu,pmenu,flist,plists)
Widget iom[2],fmenu,pmenu,flist,plists[2][3];
pdl_channel **list;
{
 static char buf[20];
 Widget active = pmenu;
 int valid,n,m;
 XmString item;
 Arg par;

 /* Aufrauemen */
 XmListSetPos(flist,1);
 XmListDeleteAllItems(flist);
 for ( n = 3 ; n-- ; )
E 2
  {
D 2
   /* PROGRAM Struktur erzeugen und Parameter ueberpruefen */
E 2
I 2
   XmListSetPos(plists[0][n],1);
   XmListDeleteAllItems(plists[0][n]);
E 2
  }
D 2
 /* Fertig */
 XtUnmanageChild(dialog);
E 2
I 2
 /* Sind Kanaele vorhanden */
 if ( valid = ((list != 0) && *list) )
  if ( (*list)->kind == PDL_FILE )
   {
    /* Dateiliste */
    active = fmenu;
    /* Uebertragen */
    for ( ; *list ; list++ ) 
     {
      /* String erzeugen */
      checkmem(item = newstr((*list)->name));
      /* Und eintragen */
      XmListAddItemUnselected(flist,item,0);
     }
   }
  else
   /* Programmliste */
   for ( ; *list ; list++ )
    {
     /* Unit */
     sprintf(buf,"%d",(*list)->unit);
     XmTextFieldSetString(plists[1][1],buf);	
     /* Kanaele */
     sprintf(buf,"%d",(*list)->max);
     XmTextFieldSetString(plists[1][2],buf);	
     /* Sauber eintragen */
     addProgramItems(plists,(*list)->name);
    }
 /* Fertig machen */
 XtSetArg(par,XmNmenuHistory,active);
 XtSetValues(iom[0],&par,1);
 XtSetSensitive(iom[0],valid);
 /* Button */
 set_boolean(iom[1],valid);
E 2
}

/*
  Dateiname in CONVERTER/INPUT=(FILENAMES=...) selektieren oder Selektionen loeschen.
*/
static filenameCallback(dialog,listp,info)
Widget dialog,*listp;
XmFileSelectionBoxCallbackStruct *info;
{
 int *sel,selcnt;
 cldBox *thisBox;

 /* Datei neu selektieren oder Dialog schliessen */
 if ( info->reason == XmCR_OK )
  {
   /* Name einsetzen */
   setVMSName(dialog,info->value);
   /* Wurde nicht OK angeklickt, Selektion an die Liste anhaengen */
   if ( !info->event || (info->event->type != ButtonRelease) ) 
    {
I 2
     char *name = NULL,*dir;
     XmString item;

     /* Name auslesen */
     if ( XmStringGetLtoR(info->value,XmSTRING_DEFAULT_CHARSET,&name) && name )
      {
       /* Jetzt tun wir mal was */
       busyCursor(dialog);
       /* Name umwandeln */
       if ( (*name != '/') && (dir = translate_vms(name)) && (dir != NOQUAL) )
        checkmem(item = newstr(dir));
       else
        checkmem(item = newstr(name));
       /* Speicher freigeben */
       XtFree(name);
       /* Fertig */
       normalCursor(dialog);
      }
     else
      checkmem(item = XmStringCopy(info->value));
E 2
     /* Dateiname anhaengen */
D 2
     XmListAddItemUnselected(*listp,info->value,0);
E 2
I 2
     XmListAddItemUnselected(*listp,item,0);
E 2
     /* Selektieren */
     XmListDeselectAllItems(*listp);
D 2
     XmListSelectPos(*listp,0,True);
E 2
I 2
     XmListSelectPos(*listp,0,False);
E 2
    }
D 2
   /* Es wurde OK angeklickt, Dialog schliessen */
E 2
   else
    {
I 2
     /* Es wurde OK angeklickt, Dialog schliessen */
E 2
     Widget *toggle;
     int count;
     Arg req;

     /* Eventuell Button abschalten */
     XtSetArg(req,XmNitemCount,&count);
     XtGetValues(*listp,&req,1);
     if ( !count ) 
      {
       XtSetArg(req,XmNuserData,&toggle);
       XtGetValues(dialog,&req,1);
       XmToggleButtonGadgetSetState(*toggle,False,True);
      }
     /* Dialog schliessen */
     XtUnmanageChild(dialog);
    }
  }
 /* Selektionen entfernen */
 else if ( (info->reason == XmCR_CANCEL) && XmListGetSelectedPos(*listp,&sel,&selcnt) )
D 2
  {
   /* Selectionen entfernen */
   while ( selcnt-- > 0 ) XmListDeletePos(*listp,sel[selcnt]);
   /* Speicher freigeben */
   XtFree(sel);
  }
E 2
I 2
  /* Selectionen entfernen */
  while ( selcnt-- > 0 ) XmListDeletePos(*listp,sel[selcnt]);
E 2
}

/*
  Selektionen CONVERTER/INPUT=(PROGRAMS=...) abschliessen.
*/
static completeCallback(dialog,listp,info)
Widget dialog,*listp;
XmSelectionBoxCallbackStruct *info;
{
 Widget *toggle;
 int count;
 Arg req;

 /* Eventuell Button abschalten */
 XtSetArg(req,XmNitemCount,&count);
 XtGetValues(*listp,&req,1);
 if ( !count ) 
  {
   XtSetArg(req,XmNuserData,&toggle);
   XtGetValues(dialog,&req,1);
   XmToggleButtonGadgetSetState(*toggle,False,True);
  }
 /* Dialog schliessen */
 XtUnmanageChild(dialog);
}

/*
I 2
  Selektionen loeschen.
*/
static setSelections(butt,lists,info)
Widget butt,lists[2][3];
XmListCallbackStruct *info;
{
 int count,n;
 Arg req;

 /* Eventuell Button abschalten */
 XtSetArg(req,XmNitemCount,&count);
 XtGetValues(lists[0][ixNames],&req,1);
 /* Alle Selektionen setzen */
 XmListDeselectAllItems(lists[0][ixNames]);
 XmListDeselectAllItems(lists[0][ixUnits]);
 XmListDeselectAllItems(lists[0][ixChannels]);
 for ( n = count ; n ; n-- )
  {
   XmListSelectPos(lists[0][ixNames],n,False);
   XmListSelectPos(lists[0][ixUnits],n,False);
   XmListSelectPos(lists[0][ixChannels],n,False);
  }
}

/*
E 2
  Selektionen in CONVERTER/INPUT=(PROGRAMS=...) uebertragen.
*/
static multipleCallback(list,lists,info)
D 2
Widget list,lists[3];
E 2
I 2
Widget list,lists[2][3];
E 2
XmListCallbackStruct *info;
{
 int n,ix;

 /* Selektionen weitergeben */
 for ( ix = 3 ; ix-- ; )
D 2
  if ( lists[ix] != list )
E 2
I 2
  if ( lists[0][ix] != list )
E 2
   {
    /* Alte Selektionen entfernen */
D 2
    XmListDeselectAllItems(lists[ix]);
E 2
I 2
    XmListDeselectAllItems(lists[0][ix]);
E 2
    /* Alle Selektionen uebernehmen */
    for ( n = info->selected_item_count ; n-- > 0 ; )
D 2
     XmListSelectPos(lists[ix],info->selected_item_positions[n],False);
E 2
I 2
     XmListSelectPos(lists[0][ix],info->selected_item_positions[n],False);
E 2
   }
}

/*
  'addCallback' aus einer Aktionsroutine aus aufrufen.
*/
static callAddCallback(textf,event,param,npar)
Widget textf;
XEvent *event;
String param[];
Cardinal *npar;
{
 /* Aufrufen */
 if ( *npar >= 1 )
  if ( !strcmp(param[0],"input") )
   addCallback(conBox.inputProgram,conBox.inputLists,NULL);
  else if ( !strcmp(param[0],"output") )
   addCallback(conBox.outputProgram,conBox.outputLists,NULL);
}

/*
  Selektion fuer CONVERTER/INPUT=(PROGRAMS=...) erzeugen.
*/
static addCallback(dialog,lists,info)
Widget dialog,lists[2][3];
XmSelectionBoxCallbackStruct *info;
{
I 2
 /* Aus den Listen auslesen */
 addProgramItems(lists,NULL);
}

static addProgramItems(lists,name)
Widget lists[2][3];
char *name;
{
E 2
 static String defval[] = { "", "10", "255" };
 int ix;

 /* Texte auslesen und uebertragen */
 for ( ix = 3 ; ix-- ; )
  {
   XmString item;
   String val;

   /* Auslesen */
D 2
   checkmem(val = XmTextFieldGetString(lists[1][ix]));
E 2
I 2
   if ( (ix == ixNames) && name )
    checkmem(val = strdup(name));
   else
    checkmem(val = XmTextFieldGetString(lists[1][ix]));
E 2
   /* In ein Item umwandeln */
D 2
   checkmem(item = XmStringCreate(val,XmSTRING_DEFAULT_CHARSET));
E 2
I 2
   checkmem(item = newstr(val));
   XtFree(val);
E 2
   XmListAddItemUnselected(lists[0][ix],item,0);
   /* Selektieren */
   XmListDeselectAllItems(lists[0][ix]);
   XmListSelectPos(lists[0][ix],0,False);
D 2
   /* Speicher freigeben */
   XmStringFree(item);
   XtFree(val);
E 2
   /* Defaultwerte neu setzen */
   XmTextFieldSetString(lists[1][ix],defval[ix]);
  } 
}

/*
  Selektionen in CONVERTER/INPUT=(PROGRAMS=...) entfernen.
*/
static deleteCallback(dialog,lists,info)
D 2
Widget dialog,lists[3];
E 2
I 2
Widget dialog,lists[2][3];
E 2
XmSelectionBoxCallbackStruct *info;
{
 int *sel,selcnt,ix;
 Arg req[2];

 /* Alle Listen */
 for ( ix = 3 ; ix-- ; )
D 2
  if ( XmListGetSelectedPos(lists[ix],&sel,&selcnt) )
   {
    /* Selektionen entfernen */
    while ( selcnt-- > 0 ) XmListDeletePos(lists[ix],sel[selcnt]);
    /* Speicher freigeben */
    XtFree(sel);
   }
E 2
I 2
  if ( XmListGetSelectedPos(lists[0][ix],&sel,&selcnt) )
   /* Selektionen entfernen */
   while ( selcnt-- > 0 ) XmListDeletePos(lists[0][ix],sel[selcnt]);
E 2
}

I 2
/***********************************************************************

  Behandlung der gesamten PDL Datei.

***********************************************************************/

E 2
/*
D 2
  Dateiname uebertragen.
E 2
I 2
  Datei ausgewaehlt.
E 2
*/
D 2
static setVMSName(selbox,xmname)
Widget selbox;
XmString xmname;
E 2
I 2
static fileSelectionCallback(sel,tag,info)
Widget sel;
caddr_t tag;
XmFileSelectionBoxCallbackStruct *info;
E 2
{
D 2
 String name = NULL,dir;
 
 /* Name auslesen */
 if ( !XmStringGetLtoR(xmname,XmSTRING_DEFAULT_CHARSET,&name) ) return;
 /* Name umwandeln */
 if ( (*name != '/') && (dir = translate_vms(name)) && (dir != NOQUAL) )
  {
   XmString mdir,mfile;
   String file;
   Arg par[2];
E 2
I 2
 String name = NULL,old;
E 2

D 2
   /* Speicher neu allokatieren */
   XtFree(name);
   checkmem(name = XtNewString(dir));
   /* Name zerlegen */
   for ( file = name+strlen(name) ; (file-- > name) && (*file != '/') ; );
   if ( file < name )
E 2
I 2
 /* String zerlegen */
 if ( !XmStringGetLtoR(info->value,XmSTRING_DEFAULT_CHARSET,&name) || !name ) return;
 /* Selektieren */
 if ( !strcmp(openAction,"save") )
  {
   /* Alter Name */
   old = currentFile;
   /* Name aendern */
   setCurrentFile(name);
   /* Abspeichern */
   if ( !saveCurrent() )
E 2
    {
D 2
     dir = "";
     file = name;
E 2
I 2
     /* Alten Namen beibehalten */
     setCurrentFile(old);
     showCurrentFile();
E 2
    }
D 2
   else
    {
     dir = name;
     *file++ = '\0';
    }
   /* Speicher allokatieren */
   checkmem(mdir = XmStringCreate(dir,XmSTRING_DEFAULT_CHARSET));
   checkmem(mfile = XmStringCreate(file,XmSTRING_DEFAULT_CHARSET));
   /* Namen an das Widget uebertragen */
   XtSetArg(par[0],XmNdirectory,mdir);
   XtSetArg(par[1],XmNtextString,mfile);
   XtSetValues(selbox,par,2);
   /* Speicher freigeben */
   XmStringFree(mdir);
   XmStringFree(mfile);
E 2
  }
I 2
 else
  {
   /* Einlesen */
   busyCursor(sel);
   openCurrent(name,!strcmp(openAction,"new"));
   normalCursor(sel);
  }
E 2
 /* Speicher freigeben */
 XtFree(name);
}

/*
D 2
  Programm beenden.
E 2
I 2
  Datei sichern.
E 2
*/
D 2
static exitXqueue(butt,tag,info)
Widget butt;
E 2
I 2
static saveCallback(dialog,tag,info)
Widget dialog;
E 2
caddr_t tag;
D 2
XmRowColumnCallbackStruct *info;
E 2
I 2
XmAnyCallbackStruct *info;
E 2
{
D 2
 /* Sichern */
 if ( modified )
E 2
I 2
 /* Selektieren */
 if ( info->reason == XmCR_OK )
E 2
  {
D 2
   terminateNormally = 1;
   XtManageChild(saveFileBox);
E 2
I 2
   int ok;

   /* Sichern */
   busyCursor(dialog);
   ok = saveCurrent();
   normalCursor(dialog);
   if ( !ok ) return;
   /* Requester aufrufen */
   if ( !terminateNormally ) XtManageChild(fileSelector);
E 2
  }
I 2
 else if ( info->reason == XmCR_CANCEL )
  {
   /* Vermerken */
   modified = 0;
   /* Requester aufrufen */
   if ( !terminateNormally ) XtManageChild(fileSelector);
  }
E 2
 else
D 2
  terminateNormally = 2;
E 2
I 2
  {
   /* Fenster entfernen */
   XtUnmanageChild(dialog);
   /* Nicht aufhoeren */
   terminateNormally = 0;
  }
 /* Aufhoeren */
 if ( terminateNormally ) terminateNormally = 2;
E 2
}

/*
D 2
  Graphikkontex initialisieren.
E 2
I 2
  Datei einlesen.
E 2
*/
D 2
static InitGC(w)
Widget w;
E 2
I 2
static popupFileSelector(butt,what,info)
Widget butt;
String what;
XmRowColumnCallbackStruct *info;
E 2
{
D 2
 unsigned long mask = GCBackground|GCForeground|GCFont|GCLineStyle|GCLineWidth|GCFillStyle; 
 Display *disp = XtDisplay(drawArea);
 Drawable win = XtWindow(drawArea);
 Arg req[2];
E 2
I 2
 int issave = !strcmp(what,"save");
E 2

D 2
 /* Heben wir schon */
 if ( gc20 ) return;
 /* Initialisieren */
 XtSetArg(req[0],XmNbackground,&gc_val.background);
 XtSetArg(req[1],XmNforeground,&gc_val.foreground);
 XtGetValues(w,req,2);
 gc_val.line_style = LineSolid;
 gc_val.line_width = app.lineWidth;
 gc_val.fill_style = FillSolid;
 gc_val.font = app.largeFont;
 gc20 = XCreateGC(disp,win,mask,&gc_val);
 gc_val.font = app.smallFont;
 gc15 = XCreateGC(disp,win,mask,&gc_val);
 largeFont = XQueryFont(disp,app.largeFont);
 smallFont = XQueryFont(disp,app.smallFont);
E 2
I 2
 /* Speichern nur, wenn Datei vorhanden */
 if ( issave && !currentFile ) return;
 /* Merken */
 openAction = what;
 /* Eventuell Dialog anwerfen */
 XtManageChild((!issave && modified) ? saveFileBox : fileSelector);
E 2
}
I 2

E 2
/*
D 2
  Neu Zeichnen eines Teil des Feldes.
E 2
I 2
  Titel des Hauptfensters setzen.
E 2
*/
D 2
static RefreshRectangle(rect)
XRectangle rect;
E 2
I 2
setCurrentFile(name)
String name;
E 2
{
I 2
 int len = -1;
 String tmp;
 Arg par;
 
 /* Speicher freigeben */
 if ( currentFile ) free(currentFile);
 /* Aufsetzen */
 if ( !(currentFile = name) )
  {
   /* Leerer Name */
   tmp = noloadMsg;
   modified = 0;
   /* Kein SAVE mehr erlaubt */
   XtSetSensitive(save_button,False);
   XtSetSensitive(save_as_button,False);
  }
 else 
  {
   /* Speicher reservieren */
   checkmem(currentFile = strdup(currentFile));
   /* Name aufbauen */
   if ( !modified || !*modMsg )
    tmp = currentFile;
   else
    {
     len = strlen(currentFile)+1+strlen(modMsg)+1;
     checkmem(tmp = MALLOC(char,len));
     strcpy(tmp,currentFile);
     strcat(tmp," ");
     strcat(tmp,modMsg);
    }
   /* SAVE wieder erlauben */
   XtSetSensitive(save_button,True);
   XtSetSensitive(save_as_button,True);
  }
 /* Aendern */
 XtSetArg(par,XmNtitle,tmp);
 XtSetValues(top,&par,1);
E 2
}

/*
D 2
  Programmbox darstellen.
E 2
I 2
  Aktuelle Datei anzeigen.
E 2
*/
D 2
static viewProgram(rect,num,name,opt)
XRectangle rect;
int num;
String name,opt;
E 2
I 2
showCurrentFile()
E 2
{
D 2
 int x = BoxX(num),y = BoxY(num),dir,asc,desc,width,height,nheight,oheight,y15;
 int offX = 2*app.lineWidth,offY = 2*app.lineWidth;
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 XCharStruct ov15,ov20;
 XRectangle clip;
E 2
I 2
 /* Anzeigen */
 if ( !currentFile ) return;
 mputs("");
 mprintf(usingFile,currentFile);
}
E 2

D 2
 /* Rahmen */
 XSetForeground(disp,gc20,gc_val.background);
 XFillRectangle(disp,draw,gc20,x,y,app.boxWidth,app.boxHeight);
 XSetForeground(disp,gc20,gc_val.foreground);
 XDrawRectangle(disp,draw,gc20,x,y,app.boxWidth,app.boxHeight);
 /* Clipping berechnen */
 clip.x = x+offX;
 clip.y = y+offY;
 clip.width = width = app.boxWidth-2*offX;
 clip.height = height = app.boxHeight-2*offY;
 if ( opt )
  {
   /* - Zusaetzlicher Text */
   XTextExtents(smallFont,opt,strlen(opt),&dir,&asc,&desc,&ov15);
   /* - Platz reservieren */
   oheight = ov15.ascent+ov15.descent;
   offY += oheight+app.lineWidth;
   XDrawLine(disp,draw,gc20,x,y+offY,x+app.boxWidth,y+offY);
   height -= offY;
   offY += 2*app.lineWidth;
  }
 /* Schnittmenge mit dem Rechteck */
 if ( (clip.x+clip.width < rect.x) || (clip.x > rect.x+rect.width) ||
      (clip.y+clip.height < rect.y) || (clip.y > rect.y+rect.height) )
  return;
 if ( clip.x < rect.x )
  {
   clip.width -= rect.x-clip.x;
   clip.x = rect.x;
  }
 else if ( clip.x+clip.width > rect.x+rect.width )
  clip.width = rect.x+rect.width-clip.x;
 if ( clip.y < rect.y )
  {
   clip.height -= rect.y-clip.y;
   clip.y = rect.y;
  }
 else if ( clip.y+clip.height > rect.y+rect.height )
  clip.height = rect.y+rect.height-clip.y;
 if ( (clip.width <= 0) || (clip.height <= 0) ) return;
 /* Clipping setzen */ 
 XSetClipRectangles(disp,gc20,0,0,&clip,1,Unsorted);
 XSetClipRectangles(disp,gc15,0,0,&clip,1,Unsorted);
 /* Programmname */
 if ( height > 0 )
  {
   XTextExtents(largeFont,name,strlen(name),&dir,&asc,&desc,&ov20);
   nheight = ov20.ascent+ov20.descent;
   if ( ov20.width < width ) offX += (width-ov20.width)/2;
   if ( nheight < height ) offY += (height-nheight)/2;
   XDrawString(disp,draw,gc20,x+offX,y+offY+nheight,name,strlen(name));
  }
 /* Kommentar */
 if ( opt ) 
  XDrawString(disp,draw,gc15,x+2*app.lineWidth,y+2*app.lineWidth+oheight,opt,strlen(opt));
 /* Clipping entfernen */
 XSetClipRectangles(disp,gc20,0,0,&rect,1,Unsorted);
 XSetClipRectangles(disp,gc15,0,0,&rect,1,Unsorted);
E 2
I 2
/*
  Togglebuttons setzen.
*/
setToggleButtons()
{
I 6
 static char num[20];

E 6
 /* Alle */
 XmToggleButtonGadgetSetState(verify_button,unit.verify,False);
 XmToggleButtonGadgetSetState(debug_button,unit.debug,False);
 XmToggleButtonGadgetSetState(version_button,unit.version,False);
I 6
 XmToggleButtonGadgetSetState(threshold_button,unit.threshold,False);
 /* Und die Werte */
 sprintf(num,"%d",(int)(100*unit.tostart));
 XmTextFieldSetString(createThreshold,num);
 sprintf(num,"%d",(int)(100*unit.tostop));
 XmTextFieldSetString(deleteThreshold,num);
E 6
E 2
}

/*
D 2
  Konverterlinie darstellen.
E 2
I 2
  Elemente im Speicher auf Konsistenz ueberpruefen.
E 2
*/
D 2
static viewConverter(rect,from,to)
XRectangle rect;
int from,to;
E 2
I 2
static checkCallback(butt,tag,info)
Widget butt;
caddr_t tag;
XmRowColumnCallbackStruct *info;
{ 
 /* Anzeigen */
 mputs("");
 if ( currentFile ) mprintf(checkingFile,currentFile);
 /* Aufrufen der eigentlichen Routine */
 check_pdl();
I 6
}

/*
  Neue Schwellen einlesen.
*/
static thresholdCallback(dialog,tag,info)
Widget dialog;
caddr_t tag;
XmSelectionBoxCallbackStruct *info;
{
 double start,stop;
 int create,delete;
 char *txt;

 /* Auslesen der Zahlwerte */
 if ( !(txt = getTextValue(createThreshold)) ||
      !isNumber(txt,&create,0,100,(XmString *)0,0) ||
      !(txt = getTextValue(deleteThreshold)) ||
      !isNumber(txt,&delete,0,100,(XmString *)0,0) )
  return;
 /* Bereich */
 if ( create > delete )
  Error(illnumMsg);
 else
  {
   /* Abspeichern */
   start = create/100.0;
   stop = delete/100.0;
   if ( (unit.tostart != start) || (unit.tostop != stop) )
    {
     /* In die Variablen */
     unit.tostart = start;
     unit.tostop = stop;
     /* Jetzt wurde etwas veraendert */
     modified = 1;
     setCurrentFile(currentFile);
    }
  }
E 6
}

/***********************************************************************
  
  Befehl fuer den QMan eingeben

***********************************************************************/

/*
  Befehls des QMan ausfuehren.
*/
static executeCommand(comm,tag,info)
Widget comm;
caddr_t tag;
XmCommandCallbackStruct *info;
E 2
{
D 2
 int fromC = BoxCol(from),fromR = BoxRow(from),toC = BoxCol(to),toR = BoxRow(to);
 int fromX = BoxX(from),fromY = BoxY(from),toX = BoxX(to),toY = BoxY(to);
 int dC = toC-fromC,dR = toR-fromR,adC,adR,dX,dY,xC,yC,sign = 1;
 Display *disp = XtDisplay(drawArea);
 Window draw = XtWindow(drawArea);
 int dia = 2*app.dotRadius;
 double lx,ly,l;
E 2
I 2
 String line = NULL;
E 2

D 2
 /* Nulljob */
 if ( from == to ) return;
 /* Seite ermitteln */
 if ( (adC = dC) < 0 ) 
E 2
I 2
 /* Wert auslesen */
 if ( !XmStringGetLtoR(info->value,XmSTRING_DEFAULT_CHARSET,&line) || !line )  return;
D 4
 /* Befehl ausfuehren */
 printf("QMan <%s>\n",line);
 /* Speicher freigeben */
 XtFree(line);
E 4
I 4
 /* Befehl anzeigen */
 mputs(" ");
 mprintf("QMan %s:",line);
 /* Befehl ausfuehren lassen */
 QManCommand = line;
E 4
}

/***********************************************************************

  Programmparameter einstellen.

***********************************************************************/

/*
  Defaultparameter abspeichern.
*/
static setupCallback(dialog,action,info)
Widget dialog;
String action;
XmSelectionBoxCallbackStruct *info;
{
 static char xbuf[256];
 String name;
 FILE *f;

 /* Dateiname ermitteln */
 if ( *(name = paramFile()) == '~' )
E 2
  {
D 2
   sign = -1;
   adC = -adC;
E 2
I 2
   struct passwd *usr;
   String uname;
   
   /* Ende des Namens */
   strcpy(xbuf,name+1);
   for ( uname = xbuf ; *uname && (*uname != '/') ; uname++ );
   *uname++ = '\0';
   /* HOME ermitteln */
   usr = xbuf[0] ? getpwnam(xbuf) : getpwuid(getuid());
   if ( !usr )
    {
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
    }
   else
    {
     /* Dateiname zusammensetzen */
     strcpy(xbuf,usr->pw_dir);
     strcat(xbuf,name+(uname-xbuf));
     /* Veraenderten Namen benutzen */
     name = xbuf;
    }
E 2
  }
D 2
 if ( (adR = dR) < 0 ) 
  adR = -adR;
 else
  sign = -sign;
 viewCoordinates(dC,dR,adC,adR,&fromX,&fromY);
 viewCoordinates(-dC,-dR,adC,adR,&toX,&toY);
 /* Zeichnen */
 XDrawLine(disp,draw,gc20,fromX,fromY,toX,toY);
 XFillArc(disp,draw,gc20,fromX-app.dotRadius,fromY-app.dotRadius,dia,dia,0,360*64);
 /* Pfeile */
 lx = toX-fromX;
 ly = toY-fromY;
 l = sqrt(lx*lx+ly*ly);
 xC = toX-0.8660254*app.arrowLength*lx/l;
 yC = toY-0.8660254*app.arrowLength*ly/l;
 if ( toY == fromY )
E 2
I 2
 /* Was ist zu tun */
 if ( !strcmp(action,"load") )
E 2
  {
D 2
   dX = 0;
   dY = app.arrowLength/2;
E 2
I 2
   unsigned char len;
   Boolean mode;
   Arg set;

   /* Laden */
   if ( !(f = fopen(name,"r")) )
    {
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
    }
   /* Ausgabemodus */
   fread(&mode,sizeof(mode),1,f);
   XtSetArg(set,XmNmenuHistory,mode ? noisy_button : silent_button);
   XtSetValues(outputMenu,&set,1);
   /* Hostname */
   fread(&len,sizeof(len),1,f);
   fread(xbuf,1,len,f);
   xbuf[len] = '\0';
   XmTextFieldSetString(hostName,xbuf);
   /* Queuename */
   fread(&len,sizeof(len),1,f);
   fread(xbuf,1,len,f);
   xbuf[len] = '\0';
   XmTextFieldSetString(queueName,xbuf);
   /* Datei schliessen */
   fclose(f);
E 2
  }
D 2
 else
E 2
I 2
 else 
E 2
  {
D 2
   dX = app.arrowLength/sqrt(1+(lx*lx/(ly*ly)))/2;
   dY = sqrt(app.arrowLength*app.arrowLength-4*((double)dX)*dX)/2;
E 2
I 2
   Boolean mode = modeVerbose();
   unsigned char len;

   /* Speichern */
   if ( !(f = fopen(name,"w")) )
    {
     /* Fehler anzeigen */
     if ( info ) Error(nofileMsg);
     return;
    }
   /* Ausgabemodus */
   fwrite(&mode,sizeof(mode),1,f);
   /* Hostname */
   len = strlen(queueManager());
   fwrite(&len,sizeof(len),1,f);
   fwrite(queueManager(),1,len,f);
   /* Queuename */
   len = strlen(parallelQueue());
   fwrite(&len,sizeof(len),1,f);
   fwrite(parallelQueue(),1,len,f);
   /* Fertig */
   fclose(f);
E 2
  }
D 2
 XDrawLine(disp,draw,gc20,xC-dX,yC-sign*dY,toX,toY);
 XDrawLine(disp,draw,gc20,xC+dX,yC+sign*dY,toX,toY);
E 2
}

I 2
/***********************************************************************

  Arbeiten mit VMS Dateispezifikationen.

***********************************************************************/

E 2
/*
D 2
  Koordinaten korrigieren.
E 2
I 2
  Dateiname uebertragen.
E 2
*/
D 2
static viewCoordinates(dC,dR,adC,adR,px,py)
int dC,dR,adC,adR,*px,*py;
E 2
I 2
static setVMSName(selbox,xmname)
Widget selbox;
XmString xmname;
E 2
{
D 2
 if ( (dC > 0) && (dC >= adR) )
E 2
I 2
 String name = NULL,dir;

 /* Name auslesen */
 if ( !XmStringGetLtoR(xmname,XmSTRING_DEFAULT_CHARSET,&name) || !name ) return 0;
 /* Beschaeftigt */
 busyCursor(selbox);
 /* Name umwandeln */
 if ( (*name != '/') && (dir = translate_vms(name)) && (dir != NOQUAL) )
  setSelector(selbox,dir);
 /* Speicher freigeben */
 XtFree(name);
 /* Normal */
 normalCursor(selbox);
 /* Ergebnis melden */
 return 1;
}

/***********************************************************************

  Allgemeine Befehle.

***********************************************************************/

/*
  Callback, der nichts tut (zum Beispiel die Eingabe von ENTER ignoriert).
*/
static noOperation()
{
}

/*
  Programm beenden.
*/
static exitXqueue(butt,tag,info)
Widget butt;
caddr_t tag;
XmRowColumnCallbackStruct *info;
{
 /* Sichern */
 if ( modified )
E 2
  {
D 2
   *px += app.boxWidth;
   *py += app.boxHeight/2;
E 2
I 2
   terminateNormally = 1;
   XtManageChild(saveFileBox);
E 2
  }
D 2
 else if ( (dC < 0) && (-dC >= adR) )
  *py += app.boxHeight/2;
 else if ( (dR < 0) && (-dR >= adC) )
  *px += app.boxWidth/2;
 else if ( (dR > 0) && (dR >= adC) )
  {
   *px += app.boxWidth/2;
   *py += app.boxHeight;
  }
E 2
I 2
 else
  terminateNormally = 2;
E 2
}

I 2
/***********************************************************************

  Nachrichten in das TextWidget schreiben.

***********************************************************************/

E 2
/*
  Nachrichtenfeld erweitern.
*/
static addMessage(msg)
String msg;
{
 static int lines = 0;
 String curval,newval;
 int len = 0;

 /* Alten Wert auslesen */
 curval = XmTextGetString(textArea);
 /* Erste Zeile elemnieren */
 if ( curval )
  {
   /* Anfang eventuell eleminieren */
   if ( lines >= app.maxLines )
    {
     /* Zeile eleminieren */
     while ( *curval && (*curval++ != '\n') );
     /* Wert veraendern */
     lines--;
     XmTextSetString(textArea,curval);
    }
   /* Laenge */
   len = strlen(curval);
   /* Speicher freigeben */
   XtFree(curval);
  }
 /* Wert eintragen */
 XmTextInsert(textArea,len,msg);
 len += strlen(msg);
 XmTextInsert(textArea,len++,"\n");
 /* Zeilen zaehlen */
 lines++;
 /* Einfuegeposition */
 XmTextSetInsertionPosition(textArea,len-1);
}

/*
  Zeile in das Nachrichtenfenster schreiben.
*/
mprintf(va_alist)
va_dcl
{
 static char line[1024];
 va_list args;
 String fmt;
  
 /* Bearbeitung der variablen Liste starten */
 va_start(args);
 /* Format einlesen */
 fmt = va_arg(args,String);
 /* Zeichenkette zusammensetzen */
 vsprintf(line,fmt,args);
 /* Bearbeitung der variablen Liste beenden */
 va_end(args);
 /* Widget beschreiben */
 addMessage(line);
}

I 2
/***********************************************************************

  Utilities.

***********************************************************************/

E 2
/*
  Kein Speicher mehr.
*/
checkmem(ptr)
void *ptr;
{
 /* Mal sehen, ob der Speicher da ist */
 if ( ptr ) return;
 /* Ausgeben und aufhoeren */
 fprintf(stderr,"%s\n",noMemory);
 exit(2);
}

/*
D 2
  Dummy, wird spaeter von aussen erledigt.
E 2
I 2
  Umwandeln in Grossbuchstaben.
E 2
*/
D 2
main(argc,argv)
int argc;
String argv[];
E 2
I 2
strchange(s,from,to)
char *s,from,to;
E 2
{
D 2
 Xqueue(argc,argv);
E 2
I 2
 char hlp = from+('Z'-'A'),del = to-from;

 /* Alle Zeichen */
 for ( ; *s ; s++ )
  if ( (*s >= from) && (*s <= hlp) )
   *s += del;
E 2
}
I 2

/*
  Da ist was schiefgegangen - gib' Laut.
*/
static soundBell(w,tag,info)
Widget w;
caddr_t tag,info;
{
 Bell();
}

/*
  Fehlermeldung aufsetzen.
*/
PopupErrorDialog(msg)
XmString msg;
{
 Arg par;

 /* Parameter aendern */
 XtSetArg(par,XmNmessageString,msg);
 XtSetValues(noFileBox,&par,1);
 /* Anzeigen */
 XtManageChild(noFileBox);
}

/*
  Outputmode auslesen.
*/
modeVerbose()
{
 Widget butt;
 Arg req;

 /* Auslesen */
 XtSetArg(req,XmNmenuHistory,&butt);
 XtGetValues(outputMenu,&req,1);
 /* Melden */
 return (!butt || (butt == noisy_button));
}

/*
  Dateiname auslesen.
*/
static String getTextValue(w)
Widget w;
{ 
 static String tmp = NULL;

 /* Alten Speicher freigeben */
 if ( tmp ) XtFree(tmp);
 /* Neues Feld einlesen */
 return (tmp = XmTextFieldGetString(w));
}

/*
  FileSelectionBox aufsetzen.
*/
static setSelector(selbox,fname)
Widget selbox;
char *fname;
{
 XmString mdir,mfile;
 String file;
 char keep;
 Arg par;

 /* Speicher allokatieren */
 checkmem(mfile = newstr(fname));
 if ( !(file = strrchr(fname,'/')) ) file = fname-1;
 keep = file[1];
 file[1] = '\0';
 checkmem(mdir = newstr(fname));
 file[1] = keep;
 /* Namen an das Widget uebertragen */
 XmFileSelectionDoSearch(selbox,mdir);
 XtSetArg(par,XmNdirSpec,mfile);
 XtSetValues(selbox,&par,1);
 /* Speicher freigeben */
 XmStringFree(mdir);
}

E 2
E 1
