h17722
s 00093/00024/02178
d D 5.2 91/08/16 11:01:32 jochen 4 3
c THRESHOLD added ; default directory and suffices modified
e
s 00000/00000/02202
d D 5.1 91/08/12 17:41:48 jochen 3 2
c Xqueue included in QMan; SET MODE command added
e
s 01407/00179/00795
d D 1.2 91/08/12 16:21:57 jochen 2 1
c Edit only version completed
e
s 00974/00000/00000
d D 1.1 91/07/22 11:52:13 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/*
  %W% 91/07/22 X11/Motif parallel queue user interface for UNIX and VMS
*/

#ifdef SCCSIDS
static char sccs_quepdl_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  Allgemeines.
*/
#include "quex11.h"

#include <saphir/CLI.h>

/*
  Verwaltungsstrukturen.
*/
typedef struct optimizers
	{
	 int			displacement;
	 int			orientation;
	 int			rectification;
	} optimizers;

typedef char stdBuffer[256];

/*
  Macros
*/
#define PRESENT(n)		cli$present_(n,strlen(n))
#define VALUE(n,o,r)		cli$get_value_(n,o,r,strlen(n),sizeof(o)-1)
#define CVALUE(n)		VALUE(n,cldbuf,&cldlen)

#define STDBUFSIZE		sizeof(stdBuffer)

#define OFFSET(t,f)		((int)&(((t)0)->f))

I 2
#define merge(i,o)		{ create_child(&(i)->output,o); create_child(&(o)->input,i); }

#define TOLEFT			0
#define TORIGHT			1
#define TOTOP			2
#define TOBOTTOM		3

#define save_number(f,v,e)	{ if ( (v) != -1 ) fprintf(f,"  /%s=%d -\n",e,v); }

#ifdef vms
#define DESCRIPT_PAR
#else
#define DESCRIPT_PAR		,rlen,plen
#define lib$get_input		lib$get_input_
#define cli$dcl_parse		cli$dcl_parse_
#define cli$dispatch		cli$dispatch_
#endif

E 2
/*
  Lokale Variablen.
*/
I 2
static int lineno,readErrors,cldlen,abox = 0,olevel;
E 2
static pdl_buf nunit = { 0, 0, NULL, 0, 0, 0 };
D 2
static int lineno,readErrors,cldlen;
E 2
I 2
static child_t blist = { 0, 0, NULL };
static optimizers bestfit;
E 2
static stdBuffer cldbuf;

/*
  Externe Variablen.
*/
extern char parallelcld_[];

/* 
  Routinen.
*/
D 2
static pdl_unit *alloc_pdl(),*create_unit();
E 2
I 2
static box_t *create_box(),*find_program();
E 2
static pdl_channel **create_channel();
I 2
static pdl_unit *create_unit();
static char *gen_vms();
E 2

I 2

/***********************************************************************

  Bearbeiten der PDL Datei als Ganzes.

***********************************************************************/

E 2
/*
I 2
  Abspeichern der Informationen als PDL Datei.
*/
saveCurrent()
{
 static char buf[1024];
 FILE *out,*copy,*src,*dst;
 pdl_unit *cur;
 int n;

 /* Haben wir so einen */
 if ( !currentFile ) return 1;
 /* Aktion anzeigen */
 mputs("");
 mprintf(saveData,currentFile);
 /* Datei umkopieren */
 if ( src = fopen(currentFile,"r") )
  {
   /* Ausgabedatei */
   sprintf(buf,"%s%s",currentFile,app.backupSuffix);
   if ( dst = fopen(buf,"w") )
    {
     /* Kopieren */
     mprintf(copyMsg,currentFile,app.backupSuffix);
     while ( ((n = fread(buf,1,sizeof(buf),src)) > 0) && (n == fwrite(buf,1,n,dst)) );
     if ( ferror(src) || ferror(dst) ) mprintf(noCopyMsg);
     /* Fertig */
     fclose(dst);
    }
   else
    mprintf(noCopyMsg);
   /* Fertig */
   fclose(src);
  }
 /* Hier passiert was */
 if ( !(out = fopen(currentFile,"w")) )
  {
   Error(noWriteMsg);
   return;
  }
 /* Parameter ausgeben */
 fputs(pdlIntro,out);
 if ( unit.verify ) fputs("SET VERIFY\n",out);
 if ( unit.debug ) fputs("SET DEBUG\n",out);
 if ( unit.version ) fputs("SHOW VERSION\n",out);
I 4
 if ( unit.tostart != tostart ) fprintf(out,"SET THRESHOLD=(CREATE:%d)\n",(int)(100*unit.tostart));
 if ( unit.tostop != tostop ) fprintf(out,"SET THRESHOLD=(DELETE:%d)\n",(int)(100*unit.tostop));
 if ( unit.threshold ) fputs("SHOW THRESHOLD\n",out);
E 4
 /* Alle Elemente durchgehen */
 fprintf(out,"-\n");
 for ( n = 0 ; n < unit.used ; )
  {
   char **spp,*def;
   int needxy;

   /* - Kopfzeile */
   fseek(out,-2,1);
   switch ((cur = unit.plist[n++])->kind)
    {
     case PDL_JOB    : def = currentFile;
       		       break;
     case PDL_CONV_1 : def = dir1;
       		       break;
     case PDL_CONV_2 : def = dir2;
		       break;
    }
   fprintf(out,"\n\n%s",unitKind(cur));
   if ( cur->kind == PDL_CONV_1 ) fprintf(out,"=%s",gen_vms(cur->primaryfile,NOSTR));
   fprintf(out," %s -\n",gen_vms(cur->filename,def));
   /* -- CLI */
   save_string(out,cur->shell,"CLI","CSH",1);
   /* -- RMS_FILE */
   if ( cur->rmsfile ) fprintf(out,"  /RMS_FILE -\n");
   /* - Name und Position */
   /* -- NAME */
   save_string(out,cur->name,"NAME","",1);
   /* - Kanaele */
   if ( cur->kind == PDL_CONV_2 )
    {
     /* -- INPUT */
     needxy = save_channels(out,cur->input,"INPUT");
     /* -- OUTPUT */
     needxy |= save_channels(out,cur->output,"OUTPUT");
    }
   else
    needxy = 1;
   /* - Position */
   if ( needxy ) fprintf(out,"  /ROW=%d -\n  /COLUMN=%d -\n",cur->row,cur->col);
   /* - Queuezeile */
   /* -- QUEUE */
   save_string(out,cur->queue,"QUEUE","BOSSQUEUE$BATCH",1);
   /* -- PRINTER */
   save_string(out,cur->printer,"PRINTER","BOSSQUEUE$PRINTER",0);
   if ( cur->keep ) fprintf(out,"  /KEEP -\n");
   /* -- LOG_FILE */
   save_logfile(out,setLogfile(cur));
   /* - Parameterzeile */
   /* -- PARAMETERS */
   if ( (spp = cur->params) && (spp != (char **)NOQUAL) && *spp )
    {
     fprintf(out,"  /PARAMETERS=( -\n");
     while ( spp[1] ) fprintf(out,"    \"%s\", -\n",*spp++);
     fprintf(out,"    \"%s\") -\n",*spp);
    }
   /* - Konfigurationszeile */
   /* -- CPUTIME */
   save_number(out,cur->cputime,"CPUTIME");
   /* -- PRIORITY */
   save_number(out,cur->priority,"PRIORITY");
   /* -- DATASIZE */
   save_number(out,cur->datasize,"DATASIZE");
   /* -- MEMORYSIZE */
   save_number(out,cur->memorysize,"MEMORYSIZE");
   /* -- STACKSIZE */
   save_number(out,cur->stacksize,"STACKSIZE");
  }
 fseek(out,-2,1);
 fprintf(out,"\n\n");
 /* Schliessen der Datei */ 
 fclose(out);
 /* Das war es */
 if ( !modified ) return 1;
 /* Veraenderte Situation anzeigen */
 modified = 0;
 setCurrentFile(currentFile);
 /* Hat geklappt */
 return 1;
}

/*
  String in die Datei schreiben.
*/
static save_string(out,str,name,def,restrict)
FILE *out;
char *str,*name,*def;
int restrict;
{
 static char buf[1024];

 /* Nicht vorhanden */
 if ( str == NOQUAL )
  {
   if ( !restrict ) fprintf(out,"  /NO%s -\n",name);
  }
 else if ( !str || !*str )
  {
   if ( !restrict ) fprintf(out,"  /%s -\n",name);
  }
 else if ( !*str || !strcmp(str,def) )
  {
   if ( !restrict ) fprintf(out,"  /%s -\n",name);
  }
 else
  {
   /* Alles gross geschrieben ? */
   strcpy(buf,str);
   strupper(buf);
   if ( !strcmp(buf,str) )
    fprintf(out,"  /%s=%s -\n",name,str);
   else
    fprintf(out,"  /%s=\"%s\" -\n",name,str);
  }
}

/*
  Dateiname umsetzen und rausschreiben.
*/
static save_logfile(out,str)
FILE *out;
char *str;
{
 /* Nicht vorhanden */
 if ( str == NOQUAL )
  fprintf(out,"  /NOLOG_FILE -\n");
 /* Kein Name */
 else if ( !str || !*str )
  fprintf(out,"  /LOG_FILE -\n");
 /* Volle Spezifikation */
 else
  fprintf(out,"  /LOG_FILE=%s -\n",gen_vms(str,NOSTR));
}

/*
  Kanalliste ausgeben.
*/
static save_channels(out,chanl,name)
FILE *out;
pdl_channel **chanl;
char *name;
{
 static char buf[1024];
 pdl_channel *cur;
 int n;

 /* Nichts gefunden */
 if ( !chanl || !*chanl ) return 1;
 /* Liste durchgehen */
 fprintf(out,"  /%s=(",name);
 if ( (cur = *chanl)->kind == PDL_FILE )
  {
   /* Dateinamen */
   fprintf(out,"ROW=%d,COLUMN=%d, -\n    FILENAMES=( -\n",cur->row,cur->col);
   do
    fprintf(out,"      %s, -\n",gen_vms(cur->name));
   while ( cur = *++chanl);
  }
 else
  {
   /* Programmnamen */
   fprintf(out,"-\n    PROGRAMS=( -\n");
   for ( n = 0 ; cur = chanl[n++] ; )
    {
     /* Grossschreibung beachten */
     strcpy(buf,cur->name);
     strupper(buf);
     if ( !strcmp(buf,cur->name) )
      fprintf(out,"      %s, -\n",cur->name);
     else
      fprintf(out,"      \"%s\", -\n",cur->name);
    }
   /* Kanalnummern */
   fseek(out,-4,1);
   fprintf(out,"), -\n    UNITS=( -\n");
   for ( n = 0 ; cur = chanl[n++] ; ) fprintf(out,"      %d, -\n",cur->unit);
   /* Kanalzahlen */
   fseek(out,-4,1);
   fprintf(out,"), -\n    MAXCHANNELS=( -\n");
   for ( n = 0 ; cur = chanl[n++] ; ) fprintf(out,"      %d, -\n",cur->max);
  }
 /* Abschliessen */
 fseek(out,-4,1);
 fprintf(out,")) -\n");
 return 0;
}

/*
  Neue Datei oeffnen.
*/
openCurrent(name,new)
char *name;
int new;
{
 pdl_buf tmp;

 /* Initialisieren */
 free_ctrl(&nunit);
D 4
 nunit.verify = nunit.debug = nunit.version = 0;
E 4
I 4
 nunit.verify = nunit.debug = nunit.version = nunit.threshold = 0;
 nunit.tostart = tostart;
 nunit.tostop = tostop;
E 4
 /* Aktion anzeigen */
 mputs("");
 mprintf(openFile,new ? createVerb : openVerb,name);
 /* Neue Datei anlegen */
 if ( new )
  {
   /* Liste loeschen */
   free_ctrl(&unit);
   free_ctrl(&history);
   place_pdl(&unit,0);
   /* Bildschirm loeschen */
   RefreshRectangle(fullRect);
   /* Name festhalten */
   setCurrentFile(name);
   return;
  }
 /* Alte Datei suchen */
 if ( access(name,F_OK) == -1 )
  {
   showCurrentFile();
   Error(nofileMsg);
   return;
  }
 /* Einlesen, validieren und platzieren */
 if ( !read_pdl(name) || !place_pdl(&nunit,0) )
  {
   free_ctrl(&nunit);
   showCurrentFile();
   place_pdl(&unit,0);
   return;
  }
 /* Datei uebernehmen */
 free_ctrl(&unit);
 free_ctrl(&history);
 tmp = unit;
 unit = nunit;
 nunit = tmp;
 /* Name uebernehmen */
 setCurrentFile(name);
 /* Flags uebernehmen */
 setToggleButtons();
 /* Neue Datei aufmalen */
 RefreshRectangle(fullRect);
}

/*
  Testen, ob die Elemente im Speicher den Anforderungen an eine PDL-Datei
  genuegen.
*/
check_pdl()
{
 pdl_unit *cur;
 int n,m;

 /* Als Ganzes leer */
 if ( !unit.used )
  {
   mprintf(pdlNoElements);
   return;
  }
 /* Alle Elemente durchgehen */
 for ( n = unit.used ; n-- ; )
  if ( (cur = unit.plist[n])->kind != PDL_CONV_2 )
   {
    /* Doppelte Namen */
    for ( m = n ; m-- ; )
     if ( (unit.plist[m]->kind != PDL_CONV_2) && !strcmp(unit.plist[m]->name,cur->name) )
      {
       mprintf(pdlDupProgram,cur->name);
       return;
      }
    /* Kanaele ermitteln */
    if ( !chp_units(cur) ) return;
   }
  else if ( (cur->input && (cur->input[0]->kind == PDL_PROGRAM)) ||
	    (cur->output && (cur->output[0]->kind == PDL_PROGRAM)) )
   {
    /* Nachsehen, ob alle Programme existieren */
    if ( !chp_channels(cur,cur->input) || !chp_channels(cur,cur->output) ) return;
   }
  else if ( unit.used != 1 )
   {
    /* Nur Konvertierjobs duerfen Konverter ohne einen Programmkanal haben */
    mprintf(pdlNotValid,cur->name);
    return;
   }
 /* In Ordung */
 mprintf(pdlOk);
}

/*
  Kanalliste durchgehen.
*/
static chp_channels(con,chanl)
pdl_unit *con;
pdl_channel **chanl;
{
 pdl_channel *cur;

 /* Nur bei Programmlisten */
 if ( !chanl || (chanl[0]->kind != PDL_PROGRAM) ) return 1;
 /* Also los */
 while ( cur = *chanl++ )
  if ( !find_program(&unit,cur->name) )
   {
    mprintf(pdlNoProgram,cur->name,con->name);
    return 0;
   }
 /* In Ordung */
 return 1;
}

/*
  Kanalliste eines Programms ueberpruefen.
*/
static chp_units(pro)
pdl_unit *pro;
{
 static int *ulist,aun = 0;
 pdl_channel **act,**run,*chan;
 int nun = 0,n,m,*nlist;
 pdl_unit *cur;

 /* Absuchen aller Konverter */
 for ( n = unit.used ; n-- ; )
  if ( (cur = unit.plist[n])->kind == PDL_CONV_2 )
   {
    /* Kanalliste abarbeiten */
    if ( (act = cur->input) || (act = cur->output) )
     for ( ; ; )
      {
       /* Diese Liste abarbeiten */
       if ( (run = act)[0]->kind == PDL_PROGRAM )
	while ( chan = *run++ )
	 if ( !strcmp(pro->name,chan->name) )
	  {
	   /* Nachsehen, ob es die Kanalnummer schon gibt */
	   for ( m = nun ; m-- ; )
	    if ( ulist[m] == chan->unit )
	     {
	      mprintf(pdlDupChannel,chan->unit,pro->name);
	      return 0;
	     }
	   /* Platz in der Liste schaffen */
	   if ( nun == aun )
	    {
	     /* Speicher reservieren */
	     checkmem(nlist = MALLOC(int,aun+10));
	     /* Kopieren */
	     if ( aun )
	      {
	       MEMMOVE(nlist,ulist,aun);
	       free(ulist);
	      }
	     /* Neue Werte uebernehmen */
	     aun += 10;
	     ulist = nlist;
	    }
	   /* Nummer eintragen */
	   ulist[nun++] = chan->unit;
	  }
       /* Naechste Liste abarbeiten */
       if ( (act == cur->output) || !(act = cur->output) ) break;
      }
   }
 /* Auswerten */
 if ( nun ) return 1;
 mprintf(pdlNotConnected,pro->name);
 return 0;
}

/***********************************************************************

  Hilfsprogramme.

***********************************************************************/

/*
  Name in einen Logfile umsetzen.
*/
char *nameToLogfile(name,jbuf)
char *name,*jbuf;
{
 static stdBuffer buf,lbuf;

 /* Jobname mit ersetzter Endung */
 strcpy(buf,name);
 strcat(buf,app.logSuffix);
 if ( !makefile(buf,jbuf,lbuf,STDBUFSIZE) )  
  {
   /* Fehler auswerten */
   readErrors++;
   mprintf(createLogfile,lbuf);
   /* Sauber enden */
   *lbuf = '\0';
  }
 /* Ergebnis melden */
 return strdup(lbuf);
}

/*
  Logfile mit Hilfe des Dateinamens zurechtstutzen.
*/
char *setLogfile(unit)
pdl_unit *unit;
{
 char *tmp,*log,*pos1,*pos2;

 /* Umwandeln des Namens in Grossschreibung */
 checkmem(tmp = strdup(unit->name));
 strlower(tmp);
 /* Zusammenhang ermitteln */
 if ( !(log = unit->logfile) ||
      ((log != NOQUAL) 	        		 &&
       (pos2 = strrchr(log = unit->logfile,'.')) && !strcmp(pos2,app.logSuffix)  &&
       (pos1 = strrchr(log,'/')) 		 && (pos1++ < pos2) 	         && 
       (strlen(tmp) == (pos2-pos1)) 		 && !strncmp(pos1,tmp,pos2-pos1) &&
        (fileOnDir(unit->filename,log,pos1-log)  || fileOnDir(currentFile,log,pos1-log))) )
  log = "";
 /* Freigeben des Speichers */
 free(tmp);
 /* Ergebnis melden */
 return log;
}

/*
  Nachsehen, ob ein Verzeichnis und ein Dateiname konsistent sind.
*/
static fileOnDir(file,dir,dlen)
char *file,*dir;
int dlen;
{
 /* Leerer Dateiname passt immer */
 if ( !file ) return 1;
 /* Mal vergleichen */
 return (!strncmp(file,dir,dlen) && !strchr(file+dlen,'/'));
}

/*
  VAX/VMS-Dateiname erzeugen.
*/
static char *gen_vms(uname,defpref)
char *uname,*defpref;
{
 static char result[1024],real[MAXPATHLEN+1];
 char *lst;
 int rix,len;
  
 /* Erst einmal sehen, ob wir uns eine Scheibe abschneiden koennen */
 if ( defpref && (lst = strrchr(uname,'/')) && fileOnDir(defpref,uname,lst-uname+1) ) 
  uname = lst+1;
 /* Umwandeln */
 strcpy(real,uname);
 /* Absoluter Name */
 if ( *(uname = real) == '/' )
  {
   uname++;
   strcpy(result,ROOTNAME);
   rix = sizeof(ROOTNAME)-1;
  } 
 else
  rix = 0;
 /* Aufraeumen fuer VAX/VMS UCX */
 while ( lst = strstr(uname,".dir") ) memmove(lst,lst+4,strlen(lst+4)+1);
 /* Name */
 if ( strchr(uname,'/') ) 
  {
   result[rix++] = '[';
   if ( rix == 1 ) result[rix++] = '.';
  }
 strcpy(result+rix,uname);
 /* Umwandeln */
 for ( uname = result+rix, lst = 0 ; *uname ; uname++ )
  if ( *uname == '/' )
   *(lst = uname) = '.';
 if ( lst ) *lst = ']';
 /* Fertig */
 return result;
}


/*
  Box eines Programms mit Namen suchen.
*/
static box_t *find_program(ctrl,name)
pdl_buf *ctrl;
char *name;
{
 int n;

 /* Suchen */
 for ( n = ctrl->used ; n-- ; )
  if ( (ctrl->plist[n]->kind != PDL_CONV_2) && !strcmp(ctrl->plist[n]->name,name) )
   return ctrl->plist[n]->box;
 /* War wohl nichts */
 return NULL;
}

/*
  Art eines Elementes ermitteln.
*/
char *unitKind(unit)
pdl_unit *unit;
{
 switch (unit->kind)
  {
   case PDL_JOB    : return "PROGRAM";   
   case PDL_CONV_1 : return "PROGRAM/PRIMARY_FILE";   
   case PDL_CONV_2 : return "CONVERTER"; 
   default         : return "UNDEFINED";
  }
}

/***********************************************************************

  Speicherverwaltung.

***********************************************************************/

/*
E 2
  Neuen Eintrag reservieren.
*/
D 2
static pdl_unit *alloc_pdl(ctrl)
E 2
I 2
pdl_unit *alloc_pdl(ctrl)
E 2
pdl_buf *ctrl;
{
I 2
 static int id = 0;
E 2
 pdl_unit *new,**nlist;

 /* Reservieren */
 checkmem(new = SALLOC(pdl_unit));
 /* Muessen wir erst noch etwas Platz schaffen ? */
 if ( ctrl->used == ctrl->alloc )
  {
   /* Speicher reservieren */
   checkmem(nlist = MALLOC(pdl_unit *,ctrl->alloc+10));
   /* Speicher kopieren */
   if ( ctrl->alloc )
    {
     MEMMOVE(nlist,ctrl->plist,ctrl->alloc);
     free(ctrl->plist);
    }
   /* Parameter aendern */
   ctrl->alloc += 10;
   ctrl->plist = nlist;
  }
 /* Reservieren */
 ctrl->plist[ctrl->used++] = new;
I 2
 new->id = ++id;
E 2
 /* Fertig */
 return new;
}

/*
I 2
  Neuen Eintrag erzeugen und Informationen aus einem alten uebernehmen.
*/
pdl_unit *dup_pdl(old,ctrl)
pdl_unit *old;
pdl_buf *ctrl;
{
 pdl_unit *new;
 int id;

 /* Speicher reservieren */
 new = alloc_pdl(ctrl);
 /* Alles bis auf die eindeutige Nummer kopieren */
 id = new->id;
 *new = *old;
 new->id = id;
 /* Zeichenketten */
 dup_char(&new->filename);
 dup_char(&new->shell);
 dup_char(&new->logfile);
 dup_char(&new->name);
 dup_char(&new->primaryfile);
 dup_char(&new->printer);
 dup_char(&new->queue);
 /* Liste von Zeichenketten */
 dup_narray(&new->params);
 /* Kanaele */
 dup_channels(&new->input);
 dup_channels(&new->output);
 /* Niemals die History */
 new->history = NOSTR;
 /* Ergebnis melden */
 return new;
}

/*
  Zeichenkette kopieren.
*/
static dup_char(namep)
char **namep;
{
 /* Falls noetig */
 if ( *namep && (*namep != NOQUAL) ) checkmem(*namep = strdup(*namep));
}

/*
  Liste von Namen kopieren.
*/
static dup_narray(arrp)
char ***arrp;
{
 char **arr = *arrp;
 int n = 0;

 /* Nichts zu tun */
 if ( !arr || (arr == (char **)NOQUAL) ) return;
 /* Groesse bestimmen */
 while ( arr[n++] );
 /* Speicher kopieren */
 checkmem(*arrp = MALLOC(char *,n));
 for ( n-- ; n-- ; )
  {
   (*arrp)[n] = arr[n];
   dup_char((*arrp)+n);
  }
}

/* 
  Liste von Kanaelen kopieren.
*/
static dup_channels(arrp)
pdl_channel ***arrp;
{
 pdl_channel **arr;
 int n = 0;

 /* Nichts zu tun */
 if ( !(arr = *arrp) ) return;
 /* Groesse bestimmen */
 while ( arr[n++] );
 /* Speicher kopieren */
 checkmem(*arrp = MALLOC(pdl_channel *,n));
 for ( n-- ; n-- ; )
  {
   checkmem((*arrp)[n] = SALLOC(pdl_channel));
   *((*arrp)[n]) = *(arr[n]);
   dup_char(&(*arrp)[n]->name);
  }
}

/*
E 2
  Eintrag freigeben.
*/
D 2
static free_pdl(ctrl,old)
E 2
I 2
free_pdl(ctrl,old)
E 2
pdl_buf *ctrl;
pdl_unit *old;
{ 
 char **spp;
 int n;

 /* Suchen */
 for ( n = ctrl->used ; n-- && (ctrl->plist[n] != old) ; );
 if ( n < 0 )
  {
   /* Nanu */
   fprintf(stderr,"%s\n",pointerMismatch);
   exit(2);
  }
 /* Speicher freigeben */
 free_char(old->filename);
 free_char(old->shell);
 free_channels(old->input);
 free_char(old->logfile);
 free_char(old->name);
 free_channels(old->output);
 if ( old->params && (old->params != (char **)NOQUAL) )
  {
   for ( spp = old->params ; *spp ; free_char(*spp++) );
   free(old->params);
  }
 free_char(old->printer);
 free_char(old->queue);
I 2
 free_char(old->history);
E 2
 free(old);
 /* Entfernen */
 MEMMOVE(ctrl->plist+n,ctrl->plist+n+1,--ctrl->used-n);
}

/*
  Kanalliste freigeben.
*/
D 2
static free_channels(chanl)
E 2
I 2
free_channels(chanl)
E 2
pdl_channel **chanl;
{
 pdl_channel *chan;
 int n;

 /* Bedingt */
 if ( !chanl || (chanl == (pdl_channel **)NOQUAL) ) return;
 /* Liste durchgehen */
 for ( n = 0 ; chan = chanl[n++] ; )
  if ( chan && (chan != (pdl_channel *)NOQUAL) )
   {
    free_char(chan->name);
    free(chan);
   }
 /* Liste freigeben */
 free(chanl);
}

/*
  Zeichenkette freigeben.
*/
static free_char(str)
char *str;
{ 
 /* Nur bedingt */
 if ( str && (str != NOQUAL) ) free(str);
}

/*
  Ganze Strukturliste freigeben.
*/
free_ctrl(ctrl)
pdl_buf *ctrl;
{
 /* Alle mit moeglichst wenig Aufwand */
 while ( ctrl->used ) free_pdl(ctrl,ctrl->plist[ctrl->used-1]);
 /* Parameter initialisieren */
 ctrl->verify = app.verifyFlag;
 ctrl->debug = app.debugFlag;
 ctrl->version = app.versionFlag;
I 4
 ctrl->threshold = app.thresholdFlag;
E 4
}

D 2
/*
  Abspeichern der Informationen als PDL Datei.
*/
saveCurrent()
{
 /* Haben wir so einen */
 if ( !currentFile ) return 1;
 /* Aktion anzeigen */
 mputs("");
 mprintf(saveData,currentFile);
 /* Hier passiert was */
 /* Das war es */
 if ( !modified ) return 1;
 /* Veraenderte Situation anzeigen */
 modified = 0;
 setCurrentFile(currentFile);
 /* Hat geklappt */
 return 1;
}
E 2
I 2
/***********************************************************************
E 2

D 2
/*
  Neue Datei oeffnen.
*/
openCurrent(name,new)
char *name;
int new;
{
 pdl_buf tmp;
E 2
I 2
  CLD Unterstuetzung.
E 2

D 2
 /* Initialisieren */
 free_ctrl(&nunit);
 nunit.verify = nunit.debug = nunit.version = 0;
 /* Aktion anzeigen */
 mputs("");
 mprintf(openFile,new ? createVerb : openVerb,name);
 /* Neue Datei anlegen */
 if ( new )
  {
   /* Liste loeschen */
   free_ctrl(&unit);
   /* Name festhalten */
   setCurrentFile(name);
   return;
  }
 /* Alte Datei suchen */
 if ( access(name,F_OK) == -1 )
  {
   showCurrentFile();
   Error(nofileMsg);
   return;
  }
 /* Einlesen, validieren und platzieren */
 if ( !read_pdl(name) || !place_pdl() )
  {
   free_ctrl(&nunit);
   showCurrentFile();
   return;
  }
 /* Datei uebernehmen */
 free_ctrl(&unit);
 tmp = unit;
 unit = nunit;
 nunit = tmp;
 /* Name uebernehmen */
 setCurrentFile(name);
 /* Flags uebernehmen */
 setToggleButtons();
}
E 2
I 2
***********************************************************************/
E 2

/*
  Einlesen einer PDL Datei.
*/
D 2
#ifdef vms
#define DESCRIPT_PAR
#else
#define DESCRIPT_PAR		,rlen,plen
#define lib$get_input		lib$get_input_
#define cli$dcl_parse		cli$dcl_parse_
#define cli$dispatch		cli$dispatch_
#endif

E 2
static read_pdl(pdlname)
char *pdlname;
{
 static stdBuffer curdir;
 static int dcl_input();
 int sfd,res,serr;
I 4
 char *dend;
E 4

 /* Eingabekanal festhalten */
 setbuf(stdin,NULL);
 if ( (sfd = dup(0)) == -1 )
  {
   /* Fehler anzeigen */
   Error(noopenMsg);
   return 0;
  }
 close(0);
 /* Eingabekanal umlenken */
 if ( open(pdlname,O_RDONLY) == -1 )
  {
   /* Fehler melden */
   readErrors = 1;
   Error(noopenMsg);
  }
 else
  {
   /* Aktuelle Datei merken */
   if ( !getcwd(curdir,STDBUFSIZE) ) strcpy(curdir,app.tmpDir);
D 4
   chdir(app.tmpDir);
E 4
I 4
   /* Arbeitsverzeichnis ermitteln */
   if ( dend = strrchr(pdlname,'/') )
    {
     char keep = *++dend;
     
     /* Verzeichnis wechseln */
     *dend = '\0';
     chdir(pdlname);
     *dend = keep;
    }
E 4
   /* Einlesen */
   readErrors = lineno = serr = 0;
   while ( ((res = cli$dcl_parse(NOSTR,parallelcld_,NOSTR,dcl_input,NOSTR)) != CLI$_EOF) &&
	   (serr <= app.maxSyntaxErrors) )
    if ( !(res&1) )
     {
      /* Illegale Zeile */
      serr++;
      readErrors++;
      mprintf(syntaxMsg,lineno);
     }
    else if ( !(cli$dispatch(0)&1) )
     {
      /* Keine Routine */
      serr++;
      readErrors++;
      mprintf(tableMsg,lineno);
     }
   /* Fertig */
   mprintf(doneMsg,lineno-1,!readErrors ? successMsg : "");
   if ( readErrors ) mprintf(errorSummary,readErrors);
   if ( serr > app.maxSyntaxErrors ) mputs(maxSyntax);
   /* Datei schliessen */
   close(0);
   /* Fehler anzeigen */
   if ( readErrors ) Error(badfileMsg);
   /* Zurueck auf die alte Directory */
   chdir(curdir);
  }
 /* Aufraeumen */
 dup2(sfd,0);
 close(sfd);
 /* Erfolg gehabt */
 return !readErrors;
}

/*
  Einlesen und Zeilen zaehlen.
*/
static dcl_input(res,pro,len DESCRIPT_PAR)
char *res,*pro;
int *len DESCRIPT_PAR;
{ 
 int code;

 /* Zaehlen */
 lineno++;
 /* Aufrufen */
 code = lib$get_input(res,pro,len DESCRIPT_PAR);
 /* Eventuell ausgeben */
 if ( (code&1) && len && modeVerbose() )
  {
   char keep;

   /* - String aufbauen */
   keep = res[*len];
   res[*len] = '\0';
   /* - Ausgeben */
   mprintf(beVerbose,lineno,res);
   /* - Korrigieren */
   res[*len] = keep;
  }
 /* Fertig */
 return code;
}

/*
  CLD Hilfsroutinen.
*/
static string(elem)
char *elem;
{
 /* Auslesen */
 if ( !(CVALUE(elem)&1) ) return 0;
 /* Umsetzen in das C-Format */
 cldbuf[cldlen] = '\0';
 /* Fertig */
 return 1;
}

static number(elem,nump,def,min,max)
char *elem;
int *nump,def,min,max;
{
 /* Defaultwert */
 *nump = def;
 /* Parameter einlesen */
 if ( !string(elem) ) return 1;
 /* Wert auslesen */
 return (((*nump = atoi(cldbuf)) >= min) && (*nump <= max));
}

/*
  Auswertung allgemeiner Parameter.
  	  P1
	  /CPUTIME=sekunden
	  /DATASIZE=kilobytes
	  /KEEP
	  /LOG_FILE=filename
	  /MEMORYSIZE=kilobytes
	  /NAME=name
	  /PARAMETERS=LIST(string)
	  /PRINTER=printername
	  /PRIORITY=prio
	  /STACKSIZE=kilobytes
 	  /QUEUE=name
*/
D 4
static pdl_unit *create_unit(defdir,nolog,kind)
E 4
I 4
static pdl_unit *create_unit(defdir,kind)
E 4
char *defdir;
D 4
int nolog,kind;
E 4
I 4
int kind;
E 4
{ 
D 4
 static stdBuffer jbuf,buf,lbuf;
D 2
 int log,npar,apar,res;
 char *jp0,*jp1,**newp;
E 2
I 2
 int log,npar,apar,res,loc;
E 4
I 4
 static stdBuffer jbuf,buf,lbuf,pbuf;
 int log,npar,apar,res,loc,deflog = !defdir;
E 4
E 2
 pdl_unit *new;
I 2
 char **newp;
E 2

 /* Speicher reservieren */
 new = alloc_pdl(&nunit);
 /* CPUTIME */
 new->cputime = create_number("CPUTIME",-1,1,50*366*24*60*60);
 /* DATASIZE */
 new->datasize = create_number("DATASIZE",-1,10,1024*1024);
 /* MEMORYSIZE */
 new->memorysize = create_number("MEMORYSIZE",-1,10,1024*1024);
 /* PRIORITY */
 new->priority = create_number("PRIORITY",-1,0,255);
 /* STACKSIZE */
 new->stacksize = create_number("STACKSIZE",-1,10,1024*1024);
 /* Statische Initialisierung */
 new->kind = kind;
D 2
 new->location = -1;
E 2
I 2
 new->col = new->row = -1;
I 4
 /* CLI */
 if ( !defdir )
  {
   if ( !string("CLI") )
    {
     readErrors++;
     mputs(noCLI);
    }
   else
    {
     checkmem(new->shell = strdup(cldbuf));
     /* Defaultendung einsetzen */
     *(defdir = pbuf) = '.';
     if ( !strcmp("DCL",cldbuf) )
      strcpy(defdir+1,"COM");
     else
      strcpy(defdir+1,cldbuf);
    }
  }
E 4
E 2
 /* P1 */ 
 if ( !string("P1") )
  {
   readErrors++;
   mputs(noFilename);
  }
 else
  {
   /* UNIX Notation ermitteln */
   strcpy(jbuf,cldbuf);
   if ( !makefile(cldbuf,defdir,buf,STDBUFSIZE) )
    {
     readErrors++;
     mprintf(translateFile,cldbuf);
    }
   else
    checkmem(new->filename = strdup(buf));
  }
 /* NAME */
 if ( string("NAME") )
  checkmem(new->name = strdup(cldbuf));
 else if ( new->filename )
D 2
  {
   /* - Name aus dem Dateinamen ermitteln */
   jp0 = new->filename+strlen(new->filename);
   /* Anfang suchen */
   while ( (jp0-- > new->filename) && (*jp0 != '/') && (*jp0 != ']') && (*jp0 != ':') );
   /* Ende suchen und in Grossbuchstaben umwandeln */
   for ( jp1 = buf ; *++jp0 && (*jp0 != '.') && (*jp0 != ';') ; )
    if ( (*jp0 >= 'a') && (*jp0 <= 'z') )
     *jp1++ = *jp0+('A'-'a');
    else
     *jp1++ = *jp0;
   *jp1++ = '\0';
   /* Uebernehmen */
   checkmem(new->name = strdup(buf));
  }
E 2
I 2
  /* - Name aus dem Dateinamen ermitteln */
  checkmem(new->name = fileToName(new->filename));
E 2
 /* LOG_FILE */
 if ( (log = PRESENT("LOG_FILE")) == CLI$_NEGATED )
  new->logfile = NOQUAL;
 else if ( string("LOG_FILE") )
  /* UNIX Name ermitteln */
  if ( !makefile(cldbuf,app.logSuffix,buf,STDBUFSIZE) )
   {
    readErrors++;
    mprintf(translateLogfile,cldbuf);     
   }
  else
   checkmem(new->logfile = strdup(buf));
D 4
 else if ( (log != CLI$_PRESENT) && nolog )
E 4
I 4
 else if ( (log != CLI$_PRESENT) && !deflog )
E 4
  new->logfile = NOQUAL;
 else if ( new->name )
D 2
  {
   /* Jobname mit ersetzter Endung */
   strcpy(buf,new->name);
   strcat(buf,app.logSuffix);
   if ( !makefile(buf,jbuf,lbuf,STDBUFSIZE) )
    {
     readErrors++;
     mprintf(createLogfile,lbuf);     
    }
   else
    checkmem(new->logfile = strdup(lbuf));
  }
E 2
I 2
  checkmem(new->logfile = nameToLogfile(new->name,jbuf));
E 2
 /* PARAMETERS */
 npar = apar = 0;
 do
  {
   /* - Speicher reservieren */
   if ( npar >= apar-1 )
    {
     /* -- Neues Feld */
     checkmem(newp = MALLOC(char *,apar+2));
     /* -- Altes uebernehmen */
     if ( apar )
      {
       MEMMOVE(newp,new->params,apar);
       free(new->params);
      }
     /* -- Informationen uebernehmen */
     apar += 2;
     new->params = newp;
    }
   /* - Naechsten Parameter einlesen */
   if ( (res = CVALUE("PARAMETERS")) == CLI$_ABSENT ) break;
   if ( (res != CLI$_COMMA) && (res != CLI$_NORMAL) )
    {
     readErrors++;
     mputs(noParameters);
    }
   else
    {
     /* - Parameter uebernehmen */
     cldbuf[cldlen] = '\0';
     checkmem(new->params[npar++] = strdup(cldbuf));
    }
  }
 while ( res == CLI$_COMMA );
 /* PRINTER */
 if ( PRESENT("PRINTER") == CLI$_NEGATED )
  {
   new->printer = NOQUAL;
   new->keep = 1;
  }
 else if ( !string("PRINTER") )
  {
   readErrors++;
   mputs(noPrinter);
  }
 else if ( !makelogical(cldbuf,buf,STDBUFSIZE) )
  {
   readErrors++;
   mprintf(translatePrinter,cldbuf);
  }
 else
  {
   checkmem(new->printer = strdup(buf));
   new->keep = 0;
  }
 /* KEEP */
 if ( (res = PRESENT("KEEP")) == CLI$_PRESENT )
  new->keep = 1;
 else if ( res == CLI$_NEGATED )
  new->keep = 0;
 /* QUEUE */
 if ( !string("QUEUE") )
  {
   readErrors++;
   mputs(noQueue);
  }
 else if ( !makelogical(cldbuf,buf,STDBUFSIZE) )
  {
   readErrors++;
   mprintf(translateQueue,cldbuf);
  }
 else
  checkmem(new->queue = strdup(buf));
I 2
 /* COLUMN */
 new->col = create_number("COLUMN",-1,0,INT_MAX);
 /* ROW */
 new->row = create_number("ROW",-1,0,INT_MAX);
 loc = new->col*maxRow+new->row;
 if ( (new->col == -1) || (new->row == -1) || (loc < 0) || (loc >= maxBox) ) 
  new->col = new->row = -1;
E 2
 /* Ergebnis melden */
 return new;
}

static create_number(elem,def,min,max)
char *elem;
int def,min,max;
{
 int num;

 /* Einlesen */
 if ( number(elem,&num,def,min,max) ) return num;
 /* Fehler */
 readErrors++;
 mprintf(checkValue,elem);
 /* Ergebnis melden */
 return def;
}

/*
  Auswertung einer Kanaldefinition:
  a) NOxxxx
  b) xxxx=(FILENAMES=(filename[,...])[,ROW=NUMBER][,COLUMN=NUMBER])
  c) xxxx=(PROGRAMS=(programname[,...])[,UNITS=(NUMBER[,...])][,MAXCHANNELS=(NUMBER[,...])])
*/
static pdl_channel **create_channel(elem)
char *elem;
{
 static stdBuffer buf;
 static char key[32];
 int len = strlen(elem),nchan = 0,res,row,col,loc;
 pdl_channel **chanl,**nc,*chan;

 /* NOelem */
D 2
 if ( PRESENT(elem) == CLI$_NEGATED ) return (pdl_channel **)NOQUAL;
E 2
I 2
 if ( PRESENT(elem) == CLI$_NEGATED ) return NULL;
E 2
 /* elem=(FILENAMES=filename) */
 strcpy(key,elem);
 strcpy(key+len,".FILENAMES");
 if ( PRESENT(key) == CLI$_PRESENT )
  {
   /* Schleife ueber alle Dateinamen */
   do
    {
     /* Name ermitteln */
     if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
      {
       readErrors++;
       mputs(noFiles);
       break;
      }
     /* Name sauber abschliessen */
     cldbuf[cldlen] = '\0';
     /* Feld erweitern */
     checkmem(nc = MALLOC(pdl_channel *,nchan+2));
     /* Alte Liste kopieren */
     if ( nchan )
      {
       MEMMOVE(nc,chanl,nchan);
       free(chanl);
      }
     /* Liste aufsetzen */
     chanl = nc;
     /* Neues Element erzeugen */
     checkmem(chanl[nchan++] = chan = SALLOC(pdl_channel));
     /* Und fuellen */
     chan->kind = PDL_FILE;
D 2
     chan->location = -1;
E 2
I 2
     chan->col = chan->row = -1;
E 2
     if ( !makefile(cldbuf,NOSTR,buf,STDBUFSIZE) )
      {
       readErrors++;
       mprintf(translateFileChannel,cldbuf);
      }
     else
      checkmem(chan->name = strdup(buf));
    }
   while ( res != CLI$_NORMAL );
D 2
   if ( !chanl ) return;
E 2
I 2
   if ( !chanl ) return NULL;
E 2
   /* COLUMN */
   strcpy(key+len,".COLUMN");
   col = create_number(key,-1,0,INT_MAX);
   /* ROW */
   strcpy(key+len,".ROW");
   row = create_number(key,-1,0,INT_MAX);
   /* Echte Position ermitteln */
   loc = col*maxRow+row;
D 2
   if ( (row == -1) || (col == -1) || (loc < 0) || (loc >= maxBox) ) loc = -1;
E 2
I 2
   if ( (row == -1) || (col == -1) || (loc < 0) || (loc >= maxBox) ) col = row = -1;
E 2
   /* Zusammensetzen */
D 2
   for ( nc = chanl ; chan = *nc++ ; chan->location = loc );
E 2
I 2
   for ( nc = chanl ; chan = *nc++ ; chan->col = col, chan->row = row );
E 2
   /* Ergebnis melden */
   return chanl;
  }
 /* elem=(PROGRAMS=name[,...]) */
 strcpy(key+len,".PROGRAMS");
 /* Schleife ueber alle Programme */
 do
  {
   /* Name ermitteln */
   if ( ((res = CVALUE(key)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
    {
     readErrors++;
     mputs(noPrograms);
     break;
    }
   /* Name sauber abschliessen */
   cldbuf[cldlen] = '\0';
   /* Feld erweitern */
   checkmem(nc = MALLOC(pdl_channel *,nchan+2));
   /* Alte Liste kopieren */
   if ( nchan )
    {
     MEMMOVE(nc,chanl,nchan);
     free(chanl);
    }
   /* Liste aufsetzen */
   chanl = nc;
   /* Neues Element erzeugen */
   checkmem(chanl[nchan++] = chan = SALLOC(pdl_channel));
   /* Und fuellen */
   chan->kind = PDL_PROGRAM;
D 2
   chan->location = -1;
E 2
I 2
   chan->col = chan->row = -1;
E 2
   checkmem(chan->name = strdup(cldbuf));
   chan->unit = 10;
   chan->max = 255;
  }
 while ( res != CLI$_NORMAL );
D 2
 if ( !chanl ) return;
E 2
I 2
 if ( !chanl ) return NULL;
E 2
 /* UNITS=(NUMBER[,...]) */
 strcpy(key+len,".UNITS");
 create_integer(key,chanl,OFFSET(pdl_channel *,unit),1,999,noUnits,numUnits,invalidUnit);
 /* MAXCHANNELS=(NUMBER[,...]) */
 strcpy(key+len,".MAXCHANNELS");
 create_integer(key,chanl,OFFSET(pdl_channel *,max),1,255,
		noMaxChannels,numMaxChannels,invalidMaxChannel);
 /* Fertig */
 return chanl;
}

static create_integer(elem,list,intoff,min,max,nomsg,nummsg,invmsg)
char *elem;
pdl_channel **list;
int intoff,min,max;
char *nomsg,*nummsg,*invmsg;
{
 pdl_channel **nc,*chan;
 int res,val;

 /* NOelem */
 if ( PRESENT(elem) != CLI$_PRESENT ) return;
 for ( nc = list ; chan = *nc++ ; )
  {
   /* Zahl auslesen und auf Konsistenz ueberpruefen */
   if ( ((res = CVALUE(elem)) != CLI$_NORMAL) && (res != CLI$_COMMA) )
    {
     readErrors++;
     mputs(nomsg);
     return;
    }
   /* Listenlaenge ueberpruefen */
   if ( (res == CLI$_NORMAL) != !*nc )
    {
     readErrors++;
     mputs(nummsg);
     return;
    }
   /* Auswerten */
   cldbuf[cldlen] = '\0';
   if ( ((val = atoi(cldbuf)) < min) || (val > max) )
    {
     readErrors++;
     mprintf(invmsg,cldbuf);
    }
   /* Datum uebernehmen */
   *(int *)(((char *)chan)+intoff) = val;
  }
}

/*
 Auswertung einer CLD-Konverterinstruktion:
  	CONVERTER p1
	* /CPUTIME=sekunden
	* /DATASIZE=kilobytes
	  /INPUT=programconnection
	* /KEEP
	* /LOG_FILE=filename
	* /MEMORYSIZE=kilobytes
	* /NAME=convertername
	  /OUTPUT=programconnection
	* /PARAMETERS=LIST(string)
	* /PRINTER=printername
	* /PRIORITY=prio
 	* /QUEUE=name
	* /STACKSIZE=kilobytes
*/
pj_converter_()
{
 pdl_unit *newu;

 /* Einlesen */
D 4
 newu = create_unit(app.conv2Dir,1,PDL_CONV_2);
E 4
I 4
 newu = create_unit(app.conv2Dir,PDL_CONV_2);
E 4
D 2
 /* Auszufuehrende Datei */
 if ( newu->filename ) checkmem(newu->shell = strdup(newu->filename));
E 2
 /* Kanaele */
 newu->input = create_channel("INPUT");
 newu->output = create_channel("OUTPUT");
I 4
 /* Sicherheitsueberpruefung */
 if ( newu->output && (newu->output[0]->kind == PDL_FILE) && newu->output[1] )
  {
   readErrors++;
   mputs(multipleOutput);
  }
E 4
}

/*
 Auswertung einer CLD-Programminstruktion:
  	PROGRAM p1
	  /CLI=shellname
	  /COLUMN=column
	* /CPUTIME=sekunden
	* /DATASIZE=kilobytes
	* /KEEP
	* /LOG_FILE=filename
	* /MEMORYSIZE=kilobytes
	* /NAME=programname
	* /PARAMETERS=LIST(string)
          /PRIMARY_FILE=filename
	* /PRINTER=printername
	* /PRIORITY=prio
 	* /QUEUE=name
	  /RMS_FILE
	  /ROW=row
	* /STACKSIZE=kilobytes
*/
pj_program_()
{
 static stdBuffer buf;
D 2
 int prim,row,col;
E 2
 pdl_unit *newu;
I 2
 int prim;
E 2

 /* PRIMARY_FILE */
 prim = (PRESENT("PRIMARY_FILE") == CLI$_PRESENT);
 /* Struktur aufsetzen */
D 4
 newu = create_unit(prim ? app.conv1Dir : NOSTR,prim,prim ? PDL_CONV_1 : PDL_JOB);
E 4
I 4
 newu = create_unit(prim ? app.conv1Dir : NOSTR,prim ? PDL_CONV_1 : PDL_JOB);
E 4
 /* PRIMARY_FILE */
 if ( prim )
D 2
  {
   /* Name der Datei */
   if ( !string("PRIMARY_FILE") )
    {
     readErrors++;
     mputs(noPrimaryFile);
    }
   else if ( !makefile(cldbuf,NOSTR,buf,STDBUFSIZE) )
    {
     readErrors++;
     mprintf(translatePrimaryFile,cldbuf);
    }
   else
    checkmem(newu->primaryfile = strdup(buf));
   /* Vertauschen */
   newu->shell = newu->filename;
   checkmem(newu->filename = strdup(newu->primaryfile));
  }
E 2
I 2
  /* Name der Datei */
  if ( !string("PRIMARY_FILE") )
   {
    readErrors++;
    mputs(noPrimaryFile);
   }
  else if ( !makefile(cldbuf,NOSTR,buf,STDBUFSIZE) )
   {
    readErrors++;
    mprintf(translatePrimaryFile,cldbuf);
   }
  else
   checkmem(newu->primaryfile = strdup(buf));
E 2
D 4
 else
  {
   /* CLI */
   if ( !string("CLI") )
    {
     readErrors++;
     mputs(noCLI);
    }
   else
    checkmem(newu->shell = strdup(cldbuf));
   /* RMS_FILE */
   if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) newu->rmsfile = 1;
  }
E 4
I 4
 /* RMS_FILE */
 else if ( PRESENT("RMS_FILE") == CLI$_PRESENT ) 
  newu->rmsfile = 1;
E 4
D 2
 /* COLUMN */
 col = create_number("COLUMN",-1,0,INT_MAX);
 /* ROW */
 row = create_number("ROW",-1,0,INT_MAX);
 newu->location = col*maxRow+row;
 if ( (col == -1) || (row == -1) || (newu->location < 0) || (newu->location >= maxBox) ) 
  newu->location = -1;
E 2
}

/*
  Defaultdirectory setzen:
  	SET DEFAULT P2
*/
pj_set_default_()
{
 static stdBuffer buf;

 /* Einlesen */
 if ( !string("P2") )
  {
   readErrors++;
   mputs(noDirectory);
  }
 /* Umwandeln */
 else if ( !makefile(cldbuf,NOSTR,buf,STDBUFSIZE) )
  {
   readErrors++;
   mprintf(translateDirectory,cldbuf);
  }
 /* Anwenden */
 else if ( chdir(buf) == -1 )
  {
   readErrors++;
   mprintf(noSuchDirectory,buf);
  }
}

/*
  Listoption an oder abschalten:
  	SET [NO]VERIFY
*/
pj_set_verify_()
{
 /* Flag setzen */
 switch (PRESENT("VERIFY"))
  {
   case CLI$_NEGATED : nunit.verify = 0;
		       break;
   case CLI$_PRESENT : nunit.verify = 1;
		       break;
  }
}

/*
  Debugoption an oder abschalten:
  	SET [NO]DEBUG
*/
pj_set_debug_()
{
 /* Flag setzen */
 switch (PRESENT("DEBUG"))
  {
   case CLI$_NEGATED : nunit.debug = 0;
		       break;
   case CLI$_PRESENT : nunit.debug = 1;
		       break;
  }
}

/*
I 4
  Schwellen zum Starten und Stoppen setzen.
  	SET THRESHOLD=(CREATE=NUMBER,DELETE=NUMBER)
*/
pj_set_threshold_()
{
 double create = nunit.tostart,delete = nunit.tostop;
 int num;
 
 /* CREATE */
 if ( (num = create_number("CREATE",-1,0,100)) != -1 ) create = num/100.0;
 /* DELETE */
 if ( (num = create_number("DELETE",-1,0,100)) != -1 ) delete = num/100.0;
 /* Einsetzen */
 if ( !readErrors && (create > delete) ) 
  {
   readErrors++;
   mputs(illThreshold);
  }
 else
  {
   /* Werte merken */
   nunit.tostart = create;
   nunit.tostop = delete;
   nunit.threshold = 1;
  }
}

/*
E 4
  Keine Aktion starten
*/
pj_nothing_()
{
}

/*
  SCCS Versionsnummer ausgeben:
D 4
  	[SHOW] VERSION
E 4
I 4
  	SHOW VERSION
E 4
*/
D 4
pj_version_()
E 4
I 4
pj_show_version_()
E 4
{
 /* Flag setzen */
 nunit.version = 1;
I 4
}

/*
  Aktuelles Verhaeltnis ausgeben:
  	SHOW THRESHOLD
*/
pj_show_threshold_()
{
 /* Ausgeben */
 nunit.threshold = 1;
E 4
}

I 2
/***********************************************************************

 Aufbau des Malbereichs.

***********************************************************************/

E 2
/*
  Verteilen der einzelnen Elemente auf den Malbereich:
  PROGRAM		eine Box
  PROGRAM/PRIMARY_FILE	eine Box
  CONVETER		mindestens eine Linie
    /NOxxPUT		eine Box
    /xxPUT=FILENAMES	eine Box
    /xxPUT=PROGRAMS	keine Box
*/
D 2
static place_pdl()
E 2
I 2
place_pdl(ctrl,overwrite)
pdl_buf *ctrl;
int overwrite;
E 2
{
D 2
 pdl_channel **chp,*ch;
E 2
I 2
 int n,ok,swidth,sx,sy,minc,maxc,minr,maxr,width,height;
 pdl_channel **chp,*ch,**inp,*in,**outp,*out;
 box_t *inbox,*outbox,*minb,*curb;
 optimizers cur;
E 2
 pdl_unit *un;
D 2
 int n;
E 2

D 2
 /* Ist das notwendig ? */
 for ( n = nunit.used ; n-- ; )
E 2
I 2
 /* Geruest leeren */
 nbox = blist.used = 0;
 /* Geruest ermitteln */
 for ( n = ctrl->used, ok = !overwrite ; n-- ; )
  if ( (un = ctrl->plist[n])->kind != PDL_CONV_2 )
   un->box = create_box(un,un->col,un->row,&ok);
 for ( n = ctrl->used ; n-- ; )
  if ( (un = ctrl->plist[n])->kind == PDL_CONV_2 )
   {
    /* Eingangskanaele */
    if ( !(chp = un->input) )
     un->box = inbox = create_box(un,un->col,un->row,&ok);
    else if ( (*chp)->kind == PDL_FILE )
     chp[0]->box = inbox = create_box(un,chp[0]->col,chp[0]->row,&ok);
    else
     inbox = 0;
    /* Ausgangskanaele */
    if ( !(chp = un->output) )
     un->box = outbox = create_box(un,un->col,un->row,&ok);
    else if ( (*chp)->kind == PDL_FILE )
     chp[0]->box = outbox = create_box(un,chp[0]->col,chp[0]->row,&ok);
    else
     outbox = 0;
    /* Jede Kombination (NONE|FILE,PROGRAM) x (NONE|FILE,PROGRAM) auswerten */
    if ( !inbox && !outbox )
     {
      for ( inp = un->input ; in = *inp++ ; )
       if ( inbox = find_program(ctrl,in->name) )
	for ( outp = un->output ; out = *outp++ ; )
	 if ( outbox = find_program(ctrl,out->name) )
	  merge(inbox,outbox);
     }
    else if ( !inbox )
     {
      for ( chp = un->input ; ch = *chp++ ; )
       if ( inbox = find_program(ctrl,ch->name) )
	merge(inbox,outbox);
     }
    else if ( !outbox )
     {
      for ( chp = un->output ; ch = *chp++ ; )
       if ( outbox = find_program(ctrl,ch->name) )
        merge(inbox,outbox);
     }
    else
     merge(inbox,outbox);
   } 
 /* Das war es eventuell schon */
 if ( ok )
E 2
  {
D 2
   /* Hauptknoten */
   un = nunit.plist[n];
   if ( un->kind == PDL_CONV_2 ) 
    { 
     /* Eingangskanaele */
     for ( chp = un->input ; (ch = *chp++) && (ch->location != -1) ; );
     if ( ch ) break;
     /* Ausgangskanaele */
     for ( chp = un->output ; (ch = *chp++) && (ch->location != -1) ; );
     if ( ch ) break;
E 2
I 2
   int m;

   /* Mal sehen, ob zwei Positionen gleich sind */
   for ( n = nbox ; n-- ; )
    {
     /* Alle anderen Boxen */
     for ( m = n ; m-- ; )
      if ( (boxes[m]->optx == boxes[n]->optx) && (boxes[m]->opty == boxes[n]->opty) )
       break;
     /* Doppeltreffer */
     if ( m >= 0 ) break;
E 2
    }
D 2
   else if ( un->location == -1 ) 
    break;
E 2
I 2
   if ( n < 0 ) return 1;
E 2
  }
D 2
 /* Das war es */
 if ( n < 0 ) return 1;
 /* Alles egalisieren, d.h. keine Vorgaben */
 for ( n = nunit.used ; n-- ; )
E 2
I 2
 /* Optimierung durchfuehren */
 for ( olevel = 0 ; ; olevel++ )
E 2
  {
D 2
   /* Hauptknoten */
   un = nunit.plist[n];
   un->pos[CURRENT_PLACE].set = un->pos[OPTIMUM_PLACE].set = 0;
   /* Verzweigungen */
   if ( un->kind == PDL_CONV_2 )
E 2
I 2
   /* Noch nicht bearbeitete Boxen, anfangen mit dem mit den wenigsten Eingaengen */
   for ( n = nbox, minb = NULL ; n-- ; )
    if ( !boxes[n]->opt )
     {
      boxes[n]->level = olevel;
      if ( !minb || (boxes[n]->input.used < minb->input.used) ) minb = boxes[n];
     }
   /* Fertig ? */
   if ( !minb ) break;
   /* Optimieren */
   bestfit.displacement = bestfit.orientation = bestfit.rectification = INT_MAX;
   cur.displacement = cur.orientation = cur.rectification = blist.used = 0;
   place(minb,0,0,cur);
  }
 /* Alle Stufen einbauen */
 swidth = sx = sy = 0;
 while ( olevel-- )
  {
   /* Breite der Optimierungsstufe berechnen */
   minc = maxc = minr = maxr = 0;
   for ( n = nbox ; n-- ; )
    if ( (curb = boxes[n])->level == olevel )
     {
      if ( curb->optx < minc )
       minc = curb->optx;
      else if ( curb->optx > maxc )
       maxc = curb->optx;
      if ( curb->opty < minr )
       minr = curb->opty;
      else if ( curb->opty > maxr )
       maxr = curb->opty;
     }
   /* Positionieren */
   width = maxc-minc+1;
   height = maxr-minr+1;
   if ( (sy+height) >= maxRow )
E 2
    {
D 2
     /* Eingangskanaele */
     for ( chp = un->input ; ch = *chp++ ; )
      ch->pos[CURRENT_PLACE].set = ch->pos[OPTIMUM_PLACE].set = 0;
     /* Ausgangskanaele */
     for ( chp = un->output ; ch = *chp++ ; )
      ch->pos[CURRENT_PLACE].set = ch->pos[OPTIMUM_PLACE].set = 0;
E 2
I 2
     /* Neue Spalte anfangen */
     sy = 0;
     sx = swidth;
E 2
    }
D 2
  } 
E 2
I 2
   if ( (height >= maxRow) || ((sx+width) >= maxCol) )
    {
     /* Das geht leider nicht */
     Error(noplaceMsg); 
     return 0;
    }
   /* Offsets aendern */
   for ( n = nbox ; n-- ; )
    if ( (curb = boxes[n])->level == olevel )
     {
      curb->optx += sx-minc;
      curb->opty += sy-minr;
     }
   /* Maximale Ausdehnung vermerken */
   sy += height;
   if ( (sx+width) > swidth ) swidth = sx+width;
  }
 /* Alles in Ordung */
 return 1;
E 2
}

/*
I 2
  Eintrag in die Liste der Boxen.
*/
static box_t *create_box(unit,col,row,valid)
pdl_unit *unit;
int col,row,*valid;
{
 box_t *new,**newl;

 /* Feld erweitern */
 if ( nbox == abox )
  {
   /* Speicher reservieren */
   checkmem(newl = MALLOC(box_t *,abox+10));
   /* Alte Werte uebernehmen */
   if ( abox )
    {
     MEMMOVE(newl,boxes,abox);
     free(boxes);
    }
   /* Neue Werte uebernehmen */
   abox += 10;
   boxes = newl;
  }
 /* Initialisieren */
 if ( !(new = boxes[nbox++]) ) checkmem(new = boxes[nbox-1] = SALLOC(box_t));
 new->input.used = new->output.used = new->used = new->opt = 0;
 new->unit = unit;
 new->parent = NULL;
 /* Umrechnen */
 if ( *valid && (*valid = ((col != -1) && (row != -1))) )
  {
   new->optx = col;
   new->opty = row;
  }
 /* Melden */
 return new; 
}

/*
  Eintrag in eine Verbindungsliste.
*/
static create_child(list,box)
child_t *list;
box_t *box;
{
 box_t **newl;

 /* NOPs gelten nicht */
 if ( !box ) return;
 /* Liste erweitern */
 if ( list->used == list->alloc )
  {
   /* Speicher reservieren */
   checkmem(newl = MALLOC(box_t *,list->alloc+10));
   /* Alte Werte kopieren */
   if ( list->alloc )
    {
     MEMMOVE(newl,list->clist,list->alloc);
     free(list->clist);
    }
   /* Neue Werte uebernehmen */
   list->alloc += 10;
   list->clist = newl;
  }
 /* Eintrag vornehmen */
 list->clist[list->used++] = box; 
}

/*
E 2
  Relation zur Optimierung.
*/
static optcmp(o1,o2)
optimizers *o1,*o2;
{
 int del;

 if ( del = (o1->displacement-o2->displacement) ) return del;
 if ( del = (o1->orientation-o2->orientation) ) return del;
 return (o1->rectification-o2->rectification);
}

/*
  Knoten positionieren und fuer Kinder rekursiv aufrufen.
*/
D 2
static place(act,pos,cur,list)
E 2
I 2
static place(act,xpos,ypos,cur)
box_t *act;
int xpos,ypos;
optimizers cur;
E 2
{
I 2
 int n,m,disp,ang,ori,list = blist.used,ilist,x,y,d1,d2,vals[4];
 box_t *curb,*minb,*recb;
 optimizers tmp;

 /* Wert eintragen */
 act->x = xpos;
 act->y = ypos;
 /* Aktuelle Wertung ermitteln */
 for ( n = nbox ; n-- ; )
  if ( (curb = boxes[n])->used )
   for ( m = curb->output.used ; m-- ; )
    if ( (curb->output.clist[m] == act) && (weight(&cur,curb,act) == -1) )
     return;
 for ( m = act->output.used ; m-- ; )
  if ( (curb = act->output.clist[m]) != act )
   if ( curb->used )
    {
     if ( weight(&cur,act,curb) == -1 ) return;
    }
   else if ( !curb->parent )
    {
     create_child(&blist,curb);
     curb->parent = act;
    }
 /* Knoten ist jetzt zugeordnet */
 act->used = 1;
 /* Eingabekanaele hinzufuegen */
 for ( m = act->input.used, ilist = blist.used ; m-- ; )
  if ( !(curb = act->input.clist[m])->used && !curb->parent )
   {
    create_child(&blist,curb);
    curb->parent = act;
   }
 /* Letzte Optimierungsstufe berechnen */
 for ( cur.rectification = 0, n = nbox ; n-- ; )
  if ( (curb = boxes[n])->used )
   {
    /* Zaehler */
    for ( m = 4 ; m-- ; vals[m] = 0 );
    /* Eingangskanaele */
    for ( m = curb->input.used ; m-- && (recb = curb->input.clist[m]) ; )
     if ( recb != curb )
      vals[rectif(curb,recb)]++;
    if ( m >= 0 ) continue;
    /* Ausgangskanaele */
    for ( m = curb->output.used ; m-- && (recb = curb->output.clist[m]) ; )
     if ( recb != curb )
      vals[rectif(curb,recb)]++;
    if ( m >= 0 ) continue;
    /* Wert ermitteln */
    if ( ((!vals[TOLEFT]) != (!vals[TORIGHT])) || ((!vals[TOTOP]) != (!vals[TOBOTTOM])) )
     cur.rectification++;
   }
 /* Nachsehen, ob das noch moeglich ist */
 if ( optcmp(&cur,&bestfit) < 0 )
  {
   /* Noch nicht behandelte Boxen suchen */
   if ( list != blist.used )
    n = -1;
   else
    for ( n = 0 ; (n < blist.used) && blist.clist[n]->used ; n++ );
   /* Optimierung durchfuehren */
   if ( n == blist.used )
    {
     /* Optimale Anordung gefunden */
     bestfit = cur;
     /* Beste Position vermerken */
     for ( n = nbox ; n-- ; )
      if ( boxes[n]->used && (boxes[n]->level == olevel) )
       {
	boxes[n]->opt = 1;
	boxes[n]->optx = boxes[n]->x;
	boxes[n]->opty = boxes[n]->y;
       }
    }
   else
    {
     /* Ein Kind suchen */
     minb = blist.clist[(n == -1) ? list : n];
     xpos = minb->parent->x;
     ypos = minb->parent->y;
     /* Alle Platzierungen durchgehen */
     for ( tmp = cur, disp = 0 ; ; disp++ )
      {
       /* Geht das denn noch */
       tmp.displacement += disp;
       if ( optcmp(&tmp,&bestfit) >= 0 ) break;
       /* Offsets */
       d1 = !disp ? 1 : disp;
       if ( (d2 = disp-1) <= 0 ) d2 = disp;
       /* Alle Orientierungen durchgehen */
       for ( ori = 4 ; ori > 0 ; ori-- )
	if ( (disp != 1) || !(ori&2) )
         for ( ang = 2 ; ang-- ; )
	  if ( disp || ang )
	   {
	    /* Position ermitteln */
	    switch (ori)
	     {
	      case 4 : x = xpos+d1; y = ypos+(2*ang-1)*d2; break;
	      case 3 : x = xpos+(2*ang-1)*d2; y = ypos+d1; break;
	      case 2 : x = xpos+(2*ang-1)*d2; y = ypos-d1; break;
	      case 1 : x = xpos-d1; y = ypos+(2*ang-1)*d2; break;
	     }
	    /* Ist diese Prosition schon besetzt */
	    for ( n = nbox ; n-- ; )
	     if ( (curb = boxes[n])->used && (curb->level == olevel) &&
		  (curb->x == x) && (curb->y == y) )
	      break;
	    /* Und setzen */
	    if ( n < 0 ) 
	     {
	      place(minb,x,y,cur);
	      /* Aufhoeren, wenn es das war */
	      if ( optcmp(&tmp,&bestfit) >= 0 ) ang = ori = 0;
	     }
	   }
       /* Wert korrigieren */
       tmp.displacement -= disp;
      }
    }
  }
 /* Liste freigeben */
 while ( blist.used > list ) blist.clist[--blist.used]->parent = NULL;
 /* Knoten ist jetzt frei */
 act->used = 0;
}

/*
  Neue Wichtung berechnen.
*/
static weight(cur,from,to)
optimizers *cur;
box_t *from,*to;
{
 int dC,adC,dR,adR;

 /* Parameter berechnen */
 if ( (adC = dC = to->x-from->x) < 0 ) adC = -adC;
 if ( (adR = dR = to->y-from->y) < 0 ) adR = -adR;
 /* - displacement */
 if ( (adC != 1) && (adR != 1) ) return -1;
 cur->displacement += adC*adR;
 /* - orientation */
 if ( dR > 0 )
  if ( dC > 0 )
   cur->orientation += 1;
  else if ( dC < 0 )
   cur->orientation += 3;
  else
   cur->orientation += 2;
 else if ( dR < 0 )
  if ( dC > 0 )
   cur->orientation += 4;
  else if ( dC < 0 )
   cur->orientation += 6;
  else
   cur->orientation += 5;
 else if ( dC < 0 )
  cur->orientation += 7;
 /* Fertig */
 return 0;
}

/*
  Ausrichtung primaer gerade.
*/
static rectif(from,to)
box_t *from,*to;
{
 int dC,adC,dR,adR;

 /* Parameter berechnen */
 if ( (adC = dC = to->x-from->x) < 0 ) adC = -adC;
 if ( (adR = dR = to->y-from->y) < 0 ) adR = -adR;
 /* - rectification */
 return (adC > adR) ? ((dC < 0) ? TOLEFT : TORIGHT) : ((dR < 0) ? TOTOP : TOBOTTOM);
}

/***********************************************************************

  Verwaltung der UNDO Liste.

***********************************************************************/

/*
  Eintrag in die Historyliste vornehmen.
*/
addToHistory(old,mark,kind)
pdl_unit *old;
int mark;
char kind;
{
 static int nhist = 0;
 static char outbuf[1024];
 pdl_unit *unit;

 /* Was wird veraendert */
 unit = dup_pdl(old,&history);
 unit->mark = mark;
 unit->reason = old->id;
 /* Formatieren */
 sprintf(outbuf,"%c%c[%05d] %s %s",
	 	mark ? HISTORY_MARK : HISTORY_NONE,kind,++nhist,unitKind(unit),unit->name);
 /* Text aufsetzen */
 checkmem(unit->history = strdup(outbuf));
 /* Jetzt haben wir etwas veraendert */
 if ( modified ) return;
 /* Veraenderte Situation anzeigen */
 modified = 1;
 setCurrentFile(currentFile);
}

/*
  Veraenderungen bei einem Element eintragen.
*/
modifyHistory(old,new)
pdl_unit *old,*new;
{
 char *oldname;

 /* Alten Namen sichern */
 checkmem(oldname = strdup(old->name));
 /* Alte Werte sicherstellen */
 addToHistory(old,1,HISTORY_MODIFY);
 /* Alle Werte bearbeiten */
 if ( check_number(&old->cputime,new->cputime)		&
      check_number(&old->priority,new->priority)	&
      check_number(&old->datasize,new->datasize)	&
      check_number(&old->memorysize,new->memorysize)	&
      check_number(&old->stacksize,new->stacksize)	&
      check_number(&old->keep,new->keep)		&
      check_number(&old->rmsfile,new->rmsfile)		&
      check_string(&old->filename,new->filename)	&
      check_string(&old->shell,new->shell)		&
      check_string(&old->primaryfile,new->primaryfile)	&
      check_string(&old->name,new->name)		&
      check_string(&old->printer,new->printer)		&
      check_string(&old->logfile,new->logfile)		&
      check_string(&old->queue,new->queue)		&
      check_array(&old->params,new->params)		&
      check_channels(&old->input,new->input)		&
      check_channels(&old->output,new->output) )
  free_pdl(&history,history.plist[history.used-1]);
 else if ( strcmp(oldname,old->name) && (old->kind != PDL_CONV_2) )
  nameChanged(oldname,old->name,0);
 /* Speicher freigeben */
 free(oldname);
}

/*
  Zahl auf Veraenderung ueberpruefen.
*/
static check_number(oldp,new)
int *oldp,new;
{
 /* Nichts veraendert */
 if ( *oldp == new ) return 1;
 /* Wert uebernehmen */
 *oldp = new;
 /* Geaendert */
 return 0;
}

/*
  Zeichenkette auf Veraenderung ueberpruefen.
*/
static check_string(oldp,new)
char **oldp,*new;
{
 /* Veraenderung mitprotokollieren */
 if ( !*oldp || (*oldp == NOQUAL) )
  {
   if ( (!new || (new == NOQUAL)) && (*oldp == new) ) return 1;
  }
 else if ( new && (new != NOQUAL) && !strcmp(*oldp,new) )
  return 1;
 /* Wert uebernehmen */
 free_char(*oldp);
 *oldp = new;
 dup_char(oldp);
 /* Geaendert */
 return 0;
}

/*
  Parameterliste auf Veraenderung ueberpruefen.
*/
static check_array(oldp,new)
char ***oldp,**new;
{
 /* Veraenderung mitprotokollieren */
 if ( !*oldp || (*oldp == (char **)NOQUAL) )
  {
   if ( (!new || (new == (char **)NOQUAL)) && (*oldp == new) ) return 1;
  }
 else if ( new && (new != (char **)NOQUAL) )
  {
   int n;

   /* Alle Parameter untersuchen */
   for ( n = 0 ; (*oldp)[n] && new[n] && !strcmp((*oldp)[n],new[n]) ; n++ );
   if ( !(*oldp)[n] && !new[n] ) return 1;
  }
 /* Wert uebernehmen */
 if ( *oldp && (*oldp != (char **)NOQUAL) )
  {
   char **spp;

   for ( spp = *oldp ; *spp ; free_char(*spp++) );
   free(*oldp);
  }
 *oldp = new;
 dup_narray(oldp);
 /* Geaendert */
 return 0;
}

/*
  Kanalliste auf Veraenderung ueberpruefen.
*/
static check_channels(oldp,new)
pdl_channel ***oldp,**new;
{
 int n;

 /* Veraenderung mitprotokollieren */
 if ( !*oldp && !new ) return 1;
 if ( *oldp && new )
  {
   int n;
   
   /* Alle Kanaele durchgehen */
   for ( n = 0 ; (*oldp)[n] && new[n] ; n++ )
    {
     pdl_channel *oc = (*oldp)[n],*nc = new[n];

     if ( (oc->kind != nc->kind) || strcmp(oc->name,nc->name) ||
	  ((oc->kind == PDL_PROGRAM) && ((oc->unit != nc->unit) || (oc->max != nc->max))) )
      break;
    }
   if ( !(*oldp)[n] && !new[n] ) return 1;
  }
 /* Wert uebernehmen */
 free_channels(*oldp);
 *oldp = new;
 dup_channels(oldp);
 /* Geaendert */
 return 0;
}

/*
  Die Aenderung eines Programmnamens hat Folgen fuer die Kanaele der Konverter.
*/
static nameChanged(from,to,deleted)
char *from,*to;
int deleted;
{
 pdl_unit *cur;
 int n;

 /* Alle Elemente durchgehen */
 for ( n = unit.used ; n-- ; )
  if ( (cur = unit.plist[n])->kind == PDL_CONV_2 )
   {
    /* Werte sichern */
    addToHistory(cur,0,HISTORY_MODIFY);
    /* Listen absuchen */
    if ( cross_check_channels(&cur->input,from,to,deleted)  &
         cross_check_channels(&cur->output,from,to,deleted) )
     free_pdl(&history,history.plist[history.used-1]);
    else if ( !cur->input && !cur->output )
     return 0;
   }
 /* Alles in Ordung */
 return 1;
}

/*
  Nachsehen, ob in einer Kanalliste ein bestimmte Referenze vorkommt.
*/
static cross_check_channels(chanl,old,new,deleted)
pdl_channel ***chanl;
char *old,*new;
int deleted;
{
 int src,dst,ok = 1;
 pdl_channel *cur;

 /* Typ feststellen */
 if ( !*chanl || !(*chanl)[0] || ((*chanl)[0]->kind != PDL_PROGRAM) ) return 1;
 /* Alles durchgehen */
 for ( src = dst = 0 ; cur = (*chanl)[src++] ; )
  if ( strcmp(cur->name,old) )
   (*chanl)[dst++] = cur;
  else
   {
    /* Da ist was geaendert worden */
    ok = 0;
    /* Den Namen brauchen wir sicher nicht mehr */
    free_char(cur->name);
    if ( deleted )
     free(cur);
    else
     {
      /* Neu einrichten */
      cur->name = new;
      dup_char(&cur->name);
      (*chanl)[dst++] = cur;
     }
   }
 /* Abschliessen */
 if ( dst )
  (*chanl)[dst] = NULL;
 else
  {
   free(*chanl);
   *chanl = NULL;
  }
 return ok;
}

/*
  Loeschen eines Elementes.
*/
deleteHistory(pdl)
pdl_unit *pdl;
{
 /* Erst einmal retten */
 addToHistory(pdl,1,HISTORY_DELETE);
 /* Elemninieren */
 free_pdl(&unit,pdl);
 /* Und last not least die Konverter saeubern */
 if ( history.plist[history.used-1]->kind == PDL_CONV_2 ) return 1;
 return nameChanged(history.plist[history.used-1]->name,NOSTR,1);
}

/*
  Veraenderungen rueckgaengig machen.
*/
backupHistory(upto)
int upto;
{
 pdl_unit *cur;
 int n;

 /* Alle Aktionen durchgehen */
 while ( history.used > upto )
  {
   /* Aktuelles Element */
   cur = history.plist[history.used-1];
   /* Auswerten */
   switch (cur->history[1])
    {
     case HISTORY_CREATE : for ( n = unit.used ; n-- && (unit.plist[n]->id != cur->reason) ; );
       			   if ( n >= 0 ) free_pdl(&unit,unit.plist[n]);
       			   free_pdl(&history,cur);
			   break;
     case HISTORY_MODIFY : for ( n = unit.used ; n-- && (unit.plist[n]->id != cur->reason) ; );
       			   if ( n >= 0 )
			    free_pdl(&unit,unit.plist[n]);
       			   else
			    {
       			     free_pdl(&history,cur);
			     break;
			    }
     case HISTORY_DELETE : free_pdl(&unit,alloc_pdl(&unit));
       			   unit.plist[unit.used++] = cur;
       			   cur->id = cur->reason;
       			   history.used--;
			   break;
    }
  }
E 2
}
E 1
