h44704
s 00055/00009/01480
d D 5.2 91/08/13 10:32:30 jochen 15 14
c Output redirection to Motif Text Widget added
e
s 00013/00000/01476
d D 5.1 91/08/12 17:41:43 jochen 14 13
c Xqueue included in QMan; SET MODE command added
e
s 00002/00002/01474
d D 4.9 91/06/18 09:44:48 jochen 13 12
c $ENTRY now local symbol
e
s 00011/00005/01465
d D 4.8 91/05/25 11:13:03 jochen 12 11
c $ENTRY symbol added
e
s 00002/00002/01468
d D 4.7 91/05/25 10:52:28 jochen 11 10
c SUBMIT /DELETE positional for common use with DCL
e
s 00003/00000/01467
d D 4.6 91/05/03 09:17:33 jochen 10 9
c SUBMIT/IDENTIFY added
e
s 00012/00010/01455
d D 4.5 91/04/02 12:39:11 jochen 9 8
c /USER option enhanced in SHOW commands
e
s 00003/00000/01462
d D 4.4 91/03/15 11:43:29 jochen 8 7
c SET ENTRY/[NO]SUSPEND added
e
s 00010/00002/01452
d D 4.3 91/02/28 13:17:15 jochen 7 6
c SHOW QUEUE|ENTRY /PARALLEL Qualifier added
e
s 00012/00009/01442
d D 4.2 91/02/27 15:16:51 jochen 6 5
c SHOW JOB/USER added, Queuenames no longer converted to uppercase
e
s 00000/00000/01451
d D 4.1 91/02/25 17:38:44 jochen 5 4
c Using new RPC-Numbers from SUN, RPC version of GEN/EXEC-Queues now 1
e
s 00658/00207/00793
d D 3.3 91/02/25 17:31:41 jochen 4 3
c New release and support for parallel queues completed
e
s 00011/00000/00989
d D 3.2 91/01/15 16:33:38 jochen 3 2
c VERSION command added
e
s 00000/00000/00989
d D 3.1 91/01/15 16:13:04 jochen 2 1
c adapted to GEN-Queue version 3
e
s 00989/00000/00000
d D 2.1 91/01/03 10:06:12 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
C %W% 91/01/02 Batch queue user interface for UNIX and VMS
C
C %Z%%M% %I% %E% %U% Jochen Manns, 1991
C

C
C BOSS Queue-Manager
C
C	Part I : CLD-Parser
C
I 4
C       Die Aufgabe des CLD-Parsers ist es, ueber CDU die Befehlsparameter einzulesen
C       und in ein fuer C-Programme verwertbares Format zu bringen. So wird vor allem
C       die Uebergabe von Zeichenkettendeskriptoren von FORTRAN an C vermieden, die
C       unter UNIX und VAX/VMS verschieden gehandhabt werden. Dadurch ist der ausfueh-
C       rende Teil 'queexec.c' mit wenigen VAX/VMS-Switches kodierbar und daher einfacher
C       zu erstellen, erweitern und warten.
C
E 4

	PROGRAM QueueManager
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'
D 4

	INTEGER LIB$GET_INPUT
	EXTERNAL LIB$GET_INPUT

E 4
I 4
C Lokale Variablen
I 15
	INTEGER RES,FLEN,EXITAFTER
E 15
E 4
        CHARACTER*256 FOREIGN
D 15
	INTEGER RES,FLEN
E 15
I 15
        LOGICAL MOTCALL
E 15
D 4

	EXTERNAL queueCLD,queueECPT

E 4
I 4
C CLD-Tabelle
	EXTERNAL queueCLD
C Exceptionhandler fuer VAX/VMS
        EXTERNAL queueECPT
I 15
C Kontrollschnittstelle zu Motif
        COMMON /motif/ motcommand,motcommandlen
        CHARACTER*256 motcommand
        INTEGER motcommandlen
C Initialisieren
        EXITAFTER = 0
        MOTCALL = .FALSE.
        motcommandlen = -1
E 15
C Exceptionshandler installieren (VAX/VMS)
E 4
	CALL LIB$ESTABLISH(queueECPT)
D 4

E 4
I 4
C Falls der QMan mit Parameter aufgerufen wurde, werden diese als Befehlszeile inter-
C pretiert und ausgefuehrt. Nach diesem Befehl endet der QMan.
E 4
        IF (LIB$GET_FOREIGN(FOREIGN,,FLEN,)) THEN
         IF (FLEN.NE.0) THEN
D 4
	  RES = CLI$DCL_PARSE(FOREIGN(:FLEN),queueCLD,
E 4
I 4
C - Zeile parsen, falls sie nicht Laenge 0 hat
	  RES = cli$dcl_parse(FOREIGN(:FLEN),queueCLD,
E 4
     $           	      LIB$GET_INPUT,LIB$GET_INPUT,)
	  IF (RES) THEN
D 4
	   CALL CLI$DISPATCH()
	  ELSEIF (RES.EQ.CLI$_EOF) THEN
E 4
I 4
C - Falls kein Fehler aufgetreten ist, Befehl durchfuehren
	   CALL cli$dispatch()
	  ELSEIF (RES.EQ.cli$_eof) THEN
C - Hmm, das sollte eigentlich nicht auftreten
E 4
	   CALL QM_QUIT()
	  ELSE
I 4
C - Syntaxfehler
E 4
	   CALL syntax()
	  ENDIF
I 4
C - QMan beenden
E 4
D 15
          GOTO 9999
E 15
I 15
          EXITAFTER = 1
          MOTCALL = .TRUE.
          IF (motcommandlen.LT.0) GOTO 9999
E 15
         ENDIF
        ENDIF
D 4

E 4
I 4
C Solange der Benutzer Befehle eingibt, werden diese ausgefuehrt. Ein Ende kann durch
C den entsprechenden Befehl (EXIT) oder CTRL-Z ausgeloest werden. Beim Einlesen von
C Befehlen aus einer Pipe oder einer Datei ist das Dateiende mit CTRL-Z gleichzusetzen.
E 4
	DO WHILE (.TRUE.)
D 4
	 RES = CLI$DCL_PARSE(,queueCLD,LIB$GET_INPUT,LIB$GET_INPUT,'QueMan> ')
E 4
I 4
C - Zeile parsen
D 15
	 RES = cli$dcl_parse(,queueCLD,LIB$GET_INPUT,LIB$GET_INPUT,'QueMan> ')
E 15
I 15
         IF (motcommandlen.GE.0) THEN
	  RES = cli$dcl_parse(motcommand(:motcommandlen),queueCLD,,,)
         ELSEIF (EXITAFTER.NE.0) THEN
          GOTO 9999
         ELSE
          MOTCALL = .FALSE.
	  RES = cli$dcl_parse(,queueCLD,LIB$GET_INPUT,LIB$GET_INPUT,'QueMan> ')
         ENDIF
E 15
E 4
	 IF (RES) THEN
D 4
	  CALL CLI$DISPATCH()
	 ELSEIF (RES.EQ.CLI$_EOF) THEN
E 4
I 4
C - Falls kein Fehler aufgetreten ist, Befehl durchfuehren
	  CALL cli$dispatch()
	 ELSEIF (RES.EQ.cli$_eof) THEN
C - Ende der Pipe oder Datei erreicht oder CTRL-Z eingegeben
E 4
	  CALL QM_QUIT()
	 ELSE
I 4
C - Syntaxfehler
E 4
	  CALL syntax()
	 ENDIF
I 15
C - Zurueck ins X11
         IF (motcommandlen.GE.0) THEN
	  IF (MOTCALL) THEN
           motcommandlen = -1
	   CALL EQM_motif(%ref(motcommand),motcommandlen,0)
          ELSE
           MOTCALL = .TRUE.
          ENDIF
         ENDIF
E 15
	ENDDO
D 4

E 4
I 4
C Der QMan wurde sauber beendet
E 4
9999    END

C
D 4
C Syntaxfehler
E 4
I 4
C Syntaxfehler anzeigen. Wird so sooft gebraucht, dass sich eine eigene Routine lohnt.
E 4
C
	SUBROUTINE syntax()
D 4
	INCLUDE 'QM.INC'
E 4
I 4
C Keine globalen Variablen
        IMPLICIT NONE
C Fehler melden 
E 4
	CALL error('syntax error')
	END

C
D 4
C Andere Fehler
E 4
I 4
C Fehlertext anzeigen.
E 4
C
	SUBROUTINE error(mess)
D 4
	INCLUDE 'QM.INC'
E 4
I 4
C Keine globalen Variablen
        IMPLICIT NONE
C Parameter	
E 4
	CHARACTER*(*) mess
I 15
C Lokale Variablen
        CHARACTER*1024 buf
E 15
I 4
C Text ausgeben
E 4
D 15
	TYPE *,'QueMan: ',mess
	TYPE *
E 15
I 15
        buf = 'QueMan: '//mess
        CALL f77_print(%ref(buf),8+LEN(mess))
        CALL f77_print(%ref(' '),1)
E 15
	END

C
D 4
C Text von C aus ausgeben
E 4
I 4
C Text von C aus ausgeben. Da sich die Ausgabestrategien von C im Hinblick auf Linefeeds 
C und Carriagecontrols vor allem unter UNIX erheblich unterscheiden, werden alle C-Ausgaben
C ueber die C-Routine 'f77printf' nach 'f77_print' umgeleitet und von FORTRAN aus vorge-
C nommen. Der Zeilenbuffer kann natuerlich bei Bedarf vergroessert werden.
E 4
C
        SUBROUTINE f77_print(mess,mlen)
I 4
C Keine globalen Variablen
E 4
        IMPLICIT NONE
I 15
C Kontrollschnittstelle zu Motif
        COMMON /motif/ motcommand,motcommandlen
        CHARACTER*256 motcommand
        INTEGER motcommandlen
E 15
I 4
C Parameter
E 4
        BYTE mess(1)
        INTEGER mlen
I 4
C Lokale Variablen
        CHARACTER*1024 buf
E 4
        INTEGER i
I 15
C Direkt ans Motif
        IF (motcommandlen.GE.0) THEN
          CALL m77_puts(mess,mlen)
          RETURN
        ENDIF
E 15
D 4
        TYPE 1000,(mess(i),i=1,mlen)
 1000   FORMAT (' ',1024A1)
E 4
I 4
C Sauber umkopieren. Das dauert zwar etwas laenger ist aber 'hoch'kompatibel
        DO i = 1,mlen
         buf(i:i) = char(mess(i))
        ENDDO
C Zeile als Einheit ausgeben.
        TYPE *,buf(1:mlen)
E 4
        END

C
D 4
C QUIT
E 4
I 4
C EXIT
C LOGOUT
C QUIT 
E 4
C
	SUBROUTINE QM_quit()
I 4
D 6
C Globale Variablen
E 4
	INCLUDE 'QM.INC'
E 6
I 6
C Keine globale Variablen
        IMPLICIT NONE
E 6
D 4

E 4
I 4
C Routine ausfuehren. Man koennte diese Routine natuerlich auch direkt in die
C entsprechende C-Routine umlenken, aber das waere bei spaeteren Erweiterungen
C mit Qualifiern etwas unhandlich
E 4
	CALL EQM_quit()
D 4

E 4
	END

C
D 4
C SUBMIT filename
C	/AFTER=datetime
C	/CLI=file
C	/CPUTIME=integer
C	/DATASIZE=integer
E 4
I 4
C SUBMIT P1(FILE)
C	/AFTER=DATETIME
C	/CLI=STRING
C	/CPUTIME=NUMBER
C	/DATASIZE=NUMBER
C       /DELETE
E 4
C       /HOLD
D 4
C       /HOST=name
C	/LOG_FILE[=file]
C	/MEMORYSIZE=integer
C	/NAME=name
E 4
I 4
C       /HOST=STRING
I 10
C       /IDENTIFY
E 10
C       /KEEP
C	/LOG_FILE[=FILE]
C	/MEMORYSIZE=NUMBER
C	/NAME=STRING
E 4
C	/NOTIFY
C	/PARAMETERS=list(STRING)
D 4
C	/PRIORITY=integer
C	/QUEUE=name
E 4
I 4
C       /PRINTER=STRING
C	/PRIORITY=NUMBER
C	/QUEUE=STRING
E 4
C	/RESTART
C       /RMS_FILE
D 4
C	/STACKSIZE=integer
C	/USER=name
E 4
I 4
C	/STACKSIZE=NUMBER
C	/USER=STRING
E 4
C
	SUBROUTINE QM_submit()
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'	
I 4
C Letzte Jobnummer fuer SYNCHRONIZE merken
E 4
        COMMON /LASTENTRY/ lastentry
        INTEGER lastentry
D 4
C Lokale Parameter
E 4
I 4
C Lokale Variablen
E 4
	CHARACTER*132 jobname,user
        RECORD /submit/ args
I 4
C Unterprogramme
E 4
D 12
	INTEGER setsubmit,getstring
E 12
I 12
	INTEGER setsubmit,getstring,index
E 12
D 4
C Allgemeine Qualifier
E 4
I 4
C Allgemeine Qualifier einlesen
E 4
        IF (setsubmit(args).NE.0) RETURN
        args.requeueptr = 0
D 4
C filename
E 4
I 4
C P1(FILE)
E 4
        args.jobptr = getstring('P1',jobname)
D 4
C /USER=username
E 4
I 4
C /USER=STRING
E 4
        args.userptr = getstring('USER',user)
D 4
C Durchfuehren
E 4
I 4
C Befehl ausfuehren
E 4
        CALL submiterror(args,1)
I 4
C Jobnummer merken
E 4
        lastentry = args.entry
I 12
D 13
C Jobnummer in dem globalen Symbol $ENTRY abspeichern
E 13
I 13
C Jobnummer in dem lokalen Symbol $ENTRY abspeichern
E 13
        WRITE (jobname,'(I,1H#)') lastentry
D 13
        CALL lib$set_symbol('$ENTRY',jobname(:index(jobname,'#')-1),2)
E 13
I 13
        CALL lib$set_symbol('$ENTRY',jobname(:index(jobname,'#')-1),1)
E 13
E 12
D 4
C Fertig
E 4
        END

D 4

E 4
I 4
C
C Hilfsroutine zum Fuellen einer SUBMIT-Struktur.
C
E 4
        INTEGER FUNCTION setsubmit(args)
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'
C Parameter	
D 4
        RECORD /SUBMIT/ args
C Interne Variablen
E 4
I 4
        RECORD /submit/ args
C Lokale Variablen
E 4
	CHARACTER*132 parglob(MAX_PAR),logname,cli
D 4
        CHARACTER*132 name,queue,after,host
E 4
I 4
        CHARACTER*132 name,queue,after,host,printer
E 4
        INTEGER i,res
I 4
C Unterprogramme
E 4
	INTEGER setparams,getnumber,getstring,getflag
I 4
C Variablen statisch machen, damit sie auch nach Ende der Routine noch legale Werte enthalten
E 4
        SAVE parglob,logname,cli,name,queue,after,host
D 4
C Erst einmal das Schlimmste annehmen
E 4
I 4
        SAVE printer
C Fehlercode setzen
E 4
        setsubmit = 1
D 4
C /PARAMETERS=list
E 4
I 4
C /PARAMETERS=list(STRING)
C - Falls der Qualifier PARAMETERS angegeben ist, werden die Parameter eingelesen und
C   in ein Feld eingetragen. Durch die Eigenschaften von FORTRAN wurde die Groesse des
C   Feldes statisch gewaehlt (aus Gewohnheit von VAX/VMS her zu acht Parametern), obwohl
C   die GEN-Queue Jobs mit beliebiger Anzahl von Parametern ausfuehren kann.
E 4
        IF (cli$present('PARAMETERS').EQ.cli$_present) THEN
I 4
C -- Parameter in ein lokales Feld einlesen
E 4
	 args.nparptr = setparams(parglob)
	 IF (args.nparptr.LT.0) RETURN
I 4
C -- Parameter in die Interfacestruktur fuer C eintragen
E 4
         DO i = 1,args.nparptr
          args.parptr(i) = %loc(parglob(i))
         ENDDO
        ELSE
I 4
C - Keine Parameter angegeben
E 4
         args.nparptr = -1
        ENDIF
C /AFTER=DATETIME
        args.timeptr = getstring('AFTER',after)
D 4
C /CLI=cli
E 4
I 4
C /CLI=STRING
E 4
        args.cliptr = getstring('CLI',cli)
D 4
C /HOST=hostname
E 4
I 4
C /HOST=STRING
E 4
        args.hostptr = getstring('HOST',host)
D 4
C /LOG_FILE[=filename]
E 4
I 4
C /LOG_FILE[=FILE]
E 4
        IF (cli$present('LOG_FILE').EQ.cli$_negated) THEN
         args.logptr = -1
	ELSE
         args.logptr = getstring('LOG_FILE',logname)
        ENDIF
D 4
C /NAME=name
E 4
I 4
C /NAME=STRING
E 4
        args.nameptr = getstring('NAME',name)
D 4
C /QUEUE=queuename
E 4
I 4
C /QUEUE=STRING
E 4
        args.queueptr = getstring('QUEUE',queue)
C /CPU=NUMBER
D 4
        IF (getnumber('CPUTIME',args.cpu,-1,0,100*365*3600).EQ.0) RETURN
E 4
I 4
        IF (getnumber('CPUTIME',args.cpu,-1,0,50*365*24*3600).EQ.0) RETURN
E 4
C /DATASIZE=NUMBER
        IF (getnumber('DATASIZE',args.datasize,-1,10,1024*1024).EQ.0) RETURN
C /MEMORYSIZE=NUMBER
        IF (getnumber('MEMORYSIZE',args.memorysize,-1,10,1024*1024).EQ.0) RETURN
C /PRIORITY=NUMBER
        IF (getnumber('PRIORITY',args.prio,-1,0,255).EQ.0) RETURN
C /STACKSIZE=NUMBER
        IF (getnumber('STACKSIZE',args.stacksize,-1,10,1024*1024).EQ.0) RETURN
C /NOTIFY
        args.notify = getflag('NOTIFY')
C /RESTART
        args.restart = getflag('RESTART')
C /HOLD
        IF (cli$present('HOLD').EQ.cli$_present) THEN
         args.hold = 1
        ELSE
         args.hold = 0
        ENDIF
C /RMS_FILE
I 4
C - RMS_FILE wird in 'queexec.c' noch fuer UNIX und VAX/VMS gesondert ausgewertet. Daher
C   ist es notwendig, auch das Fehlen der Option (hier durch -1 in der Interfacestruktur
C   angezeigt) zu vermerken.
E 4
        res = cli$present('RMS_FILE')
        IF (res.EQ.cli$_present) THEN
         args.rmsfile = 1
        ELSEIF (res.EQ.cli$_negated) THEN
         args.rmsfile = 0
        ELSE
         args.rmsfile = -1
        ENDIF
D 4
C Alles in Ordnung
E 4
I 4
C /DELETE
        args.delete = getflag('DELETE')
C /KEEP
        args.keep = getflag('KEEP')
C /PRINTER=STRING
C - Es ist zu beachten, dass auch die Option /NOPRINTER zulaessig ist
        args.printer = getflag('PRINTER')
        IF (cli$present('PRINTER').EQ.cli$_negated) THEN
         args.prtptr = -1
        ELSE
         args.prtptr = getstring('PRINTER',printer)
        ENDIF
I 8
C /SUSPEND
        args.suspend = getflag('SUSPEND')
I 10
C /IDENTIFY
        args.identify = getflag('IDENTIFY')
E 10
E 8
C Alles in Ordnung, kein Fehler aufgetreten
E 4
        setsubmit = 0
        END

D 4

E 4
I 4
C
C Einlesen der Parameterliste in ein Feld von Zeichenketten. Die Routine liest bis zu
C MAX_PAR Parameter ein, fuellt sie in die Feldelemente und terminiert die Zeichenketten
C fuer C mit einer 0. Als Ergebnis wird die Zahl der Parameter oder -1 im Falle eines
C Fehlers geliefert.
C
E 4
	INTEGER FUNCTION setparams(pararr)
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'
C Parameter
	CHARACTER*132 pararr(MAX_PAR)
C Lokale Variablen
	INTEGER res,ix,rlen
D 4
C Umwandeln in C-Konvention
E 4
I 4
C Umwandeln aller Parameter in C-Konvention
E 4
	DO ix = 1,MAX_PAR
D 4
	 pararr(ix) = CHAR(0)
E 4
I 4
	 pararr(ix) = char(0)
E 4
	ENDDO
C Alle Parameter einlesen
	ix = 1
1000	IF (ix.GT.MAX_PAR) THEN
I 4
C - Maximale Zahl von Parameter ueberschritten
E 4
	 CALL error('maximum number of parameters exceeded')
	 setparams = -1
	 RETURN
	ENDIF
D 4
C Naechsten Parameter ermitteln
	res = CLI$GET_VALUE('PARAMETERS',pararr(ix)(1:131),rlen)
	IF (res.OR.res.EQ.CLI$_COMMA) THEN
C Parameter in die C-Konvention umrechnen
	 pararr(ix)(rlen+1:) = CHAR(0)
E 4
I 4
C - Naechsten Parameter ermitteln
	res = cli$get_value('PARAMETERS',pararr(ix)(1:131),rlen)
	IF (res.OR.res.EQ.cli$_comma) THEN
C - Parameter in die C-Konvention umsetzen durch Abschliessen mit einer 0
	 pararr(ix)(rlen+1:) = char(0)
E 4
	 ix = ix+1
D 4
C Eventuell weitermachen
	 IF (res.EQ.CLI$_COMMA) GOTO 1000
	ELSEIF (res.NE.CLI$_ABSENT) THEN
C Unerwartete Fehler
E 4
I 4
C - Weitermachen, falls weitere Parameter folgen
	 IF (res.EQ.cli$_comma) GOTO 1000
	ELSEIF (res.NE.cli$_absent) THEN
C - Unerwartete Fehler
E 4
	 CALL error('invalid parameter encountered')
	 ix = 0
	ENDIF
C Zahl der Parameter melden 
	setparams = ix-1
	END

D 4

E 4
I 4
C
C Aufrufen der C-Routine zum Durchfueheren der Befehle, die die gleiche Interfacestruktur
C wie SUBMIT benuzten.
C
E 4
        INTEGER FUNCTION submiterror(args,sub)
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
        INCLUDE 'QM.INC'
C Parameter
D 4
        RECORD /SUBMIT/ args
E 4
I 4
        RECORD /submit/ args
E 4
        INTEGER sub
C Lokale Variablen
        CHARACTER*132 MESS
        INTEGER res
        INTEGER EQM_submit,INDEX
D 4
C Befehl ausfuehren und Fehler ausgeben
E 4
I 4
C Befehl ausfuehren
E 4
        res = EQM_submit(args,%ref(mess),sub)
I 4
C Fehler spaeter melden
E 4
        submiterror = res
D 4
	GOTO (9999,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010) res+1
E 4
I 4
C Fehler auswerten
	GOTO (9999,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011) res+1
E 4
	 CALL syntax()
	GOTO 9999	
 1001	 CALL error('invalid jobname')
	GOTO 9999
 1002    CALL error('invalid LOG_FILE or quoted jobname')
        GOTO 9999
 1003    CALL error('invalid CLI')
        GOTO 9999
 1004    CALL error('invalid QUEUE')
        GOTO 9999
 1005    CALL error('invalid time')
        GOTO 9999
 1006    CALL error('invalid NAME')
        GOTO 9999
 1007    CALL error('invalid USER')
        GOTO 9999
 1008    CALL error('invalid HOST')
        GOTO 9999
 1009    CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
 1010    CALL error('invalid REQUEUE')
        GOTO 9999
D 4
C Fertig
E 4
I 4
 1011    CALL error('invalid PRINTER')
        GOTO 9999
E 4
 9999   END

D 4

E 4
I 4
C
C Da alle CDU-Parameter als Zeichenketten vorliegen, ist die folgende Routine, die
C den Wert eines Parameters oder Qualifiers ermittelt, eine der wichtigsten Routinen
C in dem CLD-Teil von QMan. Die Routine liefert 0, falls kein Wert vorhanden ist,
C ansonsten die Adresse des aktuellen Bufferparameters, in den die Zeichenkette
C mit der C-Endkennung 0 geschrieben wurde.
C
E 4
        INTEGER FUNCTION getstring(name,res)
I 4
C Globale Variablen
E 4
        INCLUDE 'QM.INC'
        CHARACTER*(*) name,res
I 4
C Lokale Variablen
E 4
        INTEGER rlen
        INTEGER LEN
I 4
C Wert des Parameters oder Qualifiers ermitteln
E 4
        IF (.NOT.cli$get_value(name,res(:LEN(res)-1),rlen)) THEN
I 4
C - Kein Wert zu erhalten
E 4
         getstring = 0
D 4
        ELSE        
         res(rlen+1:rlen+1) = CHAR(0)
E 4
I 4
        ELSE
C - Zeichenkette in das C-Format umwandeln und Erfolg melden
         res(rlen+1:rlen+1) = char(0)
E 4
         getstring = %loc(res)
        ENDIF
        END

D 4

E 4
I 4
C
C Manche der Parameter oder Qualifier haben als Werte Zahlen. Da diese Zahlen
C im allgemeine sowohl einen Defaultwert als auch Grenzwerte haben, wurde die
C folgende Routine erstellt, um Zahlwerte einzulesen, Defaultwerte einzusetzen
C oder wirklich vorhandene Werte auf Konsistenz zu ueberpruefen
C
E 4
        INTEGER FUNCTION getnumber(name,num,def,min,max)
I 4
C Globale Variablen
E 4
        INCLUDE 'QM.INC'
        CHARACTER*(*) name
        INTEGER num,def,min,max
I 4
C Lokale Variablen
E 4
        CHARACTER*80 nbuf
        INTEGER nlen
I 4
C Fehlerbedingung loeschen
E 4
        getnumber = 1
I 4
C Defaultwert einsetzen. Der Defaultwert wird NICHT gegen die Grenzen getestet
E 4
        num = def
I 4
C Wert als Zeichenkette einlesen
E 4
        IF (cli$get_value(name,nbuf,nlen)) THEN
I 4
C - Zeichenkette in eine Zahl umwandeln
E 4
	 READ (nbuf(:nlen),'(I)',ERR=5000,END=5000) num
I 4
C - Zahl auf ihre Bereichsgrenzen ueberpruefen
E 4
         IF (num.LT.min.OR.num.GT.max) THEN
I 4
C - Bei jeder Art von Fehler diesen melden
E 4
 5000     WRITE (nbuf,5001,ERR=5002) name
 5001     FORMAT ('invalid value for ',A,'#')
 5002     CALL error(nbuf(:index(nbuf,'#')-1))
I 4
C - Fehlercode setzen
E 4
          getnumber = 0
	 ENDIF
	ENDIF
        END

D 4
        
E 4
I 4
C
C Die folgende Routine prueft, ob ein Parameter oder Qualifier in positiver oder
C negativer Form vorhanden ist und liefert dafuer die Resultate +1 bzw. -1. Ist
C der Parameter oder Qualifier nicht angegeben, so erhaelt das aufrufende Programm
C eine 0.
C
E 4
        INTEGER FUNCTION getflag(name)
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
        INCLUDE 'QM.INC'
C Parameter
        CHARACTER*(*) name
I 4
C Lokale Variablen
E 4
        INTEGER res
D 4
C Ausfuehren
E 4
I 4
C Existenz des Parameters oder Qualifiers ermitteln
E 4
        res = cli$present(name)
I 4
C - positiv (/name)
E 4
D 11
        IF (res.EQ.cli$_present) THEN
E 11
I 11
        IF (res.EQ.cli$_present.OR.res.EQ.cli$_locpres) THEN
E 11
         getflag = 1
I 4
C - negativ (/NOname)
E 4
D 11
        ELSEIF (res.EQ.cli$_negated) THEN
E 11
I 11
        ELSEIF (res.EQ.cli$_negated.OR.res.EQ.cli$_locneg) THEN
E 11
         getflag = -1
I 4
C - nicht vorhanden
E 4
        ELSE
         getflag = 0
        ENDIF
D 4
C Fertig
E 4
        END


C
D 4
C DELETE/ENTRY=list(NUMBER) queuename
C       /HOST=name
E 4
I 4
C DELETE/ENTRY=list(NUMBER) P1(STRING)
C       /HOST=STRING
E 4
C       /LOG
C
	SUBROUTINE QM_delete_entry()
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'	
D 4

        RECORD /submit/ args

E 4
I 4
C Lokale Variablen
E 4
        CHARACTER*132 queue,host,num,mess
        INTEGER res,rlen,nnum,kres
D 4

E 4
I 4
        RECORD /submit/ args
C Unterprogramme
E 4
        INTEGER EQM_kill,getstring
D 4

E 4
I 4
C P1(STRING)
E 4
        args.queueptr = getstring('P1',queue)
I 4
C /HOST=STRING
E 4
        args.hostptr = getstring('HOST',host)
D 4

E 4
I 4
C /LOG
C - Hier wird das 'notify'-Element der Interfacestruktur etwas zweckentfremdet
E 4
        IF (cli$present('LOG').EQ.cli$_negated) THEN
         args.notify = 0
        ELSE
         args.notify = 1
        ENDIF
D 4

E 4
I 4
C /ENTRY=list(NUMBER)
C - Da es sich um eine CLD-Syntaxaenderung handelt, muss der Qualifier vorhanden sein
E 4
        IF (cli$present('ENTRY').NE.cli$_present) THEN
         CALL syntax()
         RETURN
        ENDIF
I 4
C Wert des naechsten Elementes als Zeichenkette einlesen
E 4
 1000   res = cli$get_value('ENTRY',num(1:131),rlen)
I 4
C - Legaler Wert gefunden
E 4
	IF (res.OR.res.EQ.cli$_comma) THEN
I 4
C - Zeichenkette in eine Zahl umwandeln
E 4
	 READ (num(:rlen),'(I)',ERR=5000,END=5000) args.entry
I 4
C - Befehl durchfuehren
E 4
         kres = EQM_kill(args,%ref(mess))
I 4
C - /NOLOG verhindert die Ausgabe von Fehlermeldungen
E 4
         IF (args.notify.EQ.0) kres = 0
I 4
C - Fehlercode auswerten
E 4
	 GOTO (9998,1001,1002,1003) kres+1
	  CALL syntax()
	 GOTO 9999	
 1001     CALL error('invalid QUEUE')
         GOTO 9999
 1002     CALL error('invalid HOST')
         GOTO 9999
 1003     CALL error(mess(:INDEX(mess,char(0))-1))
D 4
         GOTO 9999	
E 4
I 4
         GOTO 9999
C - Element ist in irgendeiner Form fehlerhaft
E 4
 5000     CALL error('invalid ENTRY')
         RETURN
I 4
C - Naeschstes Element bearbeiten, falls vorhanden
E 4
 9998    IF (res.EQ.cli$_comma) GOTO 1000
I 4
C - Liste der Elemente ist beendet
E 4
	ELSEIF (res.NE.cli$_absent) THEN
	 GOTO 5000
        ENDIF
D 4

E 4
 9999	END


C
D 4
C Verbotene Kombinationen
E 4
I 4
C Verbotene Kombinationen auswerten, z.B. CREATE ohne syntaxaendernden Qualifier
E 4
C
D 4

E 4
        SUBROUTINE QM_NOTHING()
I 4
C Keine globalen Variablen
E 4
        IMPLICIT NONE
I 4
C Syntaxfehler anzeigen
E 4
        CALL SYNTAX()
        END


C
D 4
C SHOW QUEUE quename
E 4
I 4
C SHOW QUEUE P2(STRING)
E 4
C     	/ALL_JOBS
C	/BRIEF
C       /BY_JOB_STATUS=list(JOB_STATUS)
C	/FILES
C	/FULL
C	/GENERIC
D 4
C       /HOST=name
E 4
I 4
C       /HOST=STRING
E 4
D 7
C	/SUMMARY
E 7
D 4
C	/OUTPUT=file
E 4
I 4
C	/OUTPUT[=FILE]
I 7
C       /PARALLEL
C	/SUMMARY
E 7
E 4
C
	SUBROUTINE QM_show_queue()
D 4

E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'	
D 4

E 4
I 4
C Lokale Variablen
E 4
        CHARACTER*132 mess,queue
        RECORD /show/ args
D 4

E 4
I 4
C Unterprogramme
E 4
        INTEGER EQM_show_queue,getstring
D 4

E 4
I 4
C Allgemeine Qualifier auswerten
E 4
        CALL showgeneral(args)
D 4

E 4
I 4
C P2(STRING)
E 4
        args.queueptr = getstring('P2',queue)
I 4
C Initialisierung
E 4
D 6
        args.userptr = -2
E 6
I 6
        args.userptr = -1
E 6
D 4

E 4
I 4
C /SUMMARY
E 4
        IF (cli$present('SUMMARY').EQ.cli$_present) THEN
         args.summary = 1
        ELSE
         args.summary = 0
        ENDIF
D 4

E 4
I 4
C Befehl durchfuehren und Fehlercode auswerten
E 4
	GOTO (9999,1001,1002,1003) EQM_show_queue(args,%ref(mess))+1
	 CALL syntax()
	GOTO 9999	
 1001	 CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
 1002    CALL error('invalid HOST')
        GOTO 9999
 1003    CALL error('invalid OUTPUT')
        GOTO 9999
D 4

E 4
 9999	END
D 4

        
E 4
I 4
       
C
C Allgemeine Parameter und Qualifier fuer die Befehle auswerten, die die gleiche
C Interfacestruktur wie SHOW QUEUE verwenden/
C
E 4
        SUBROUTINE showgeneral(args)
I 4
C Globale Variablen
E 4
        INCLUDE 'QM.INC'
        RECORD /show/ args
I 4
C Lokale Variablen
E 4
        CHARACTER*132 host,output
I 4
C Lokale Variablen sichern, damit sie auch nach Ende der Routine noch legale Werte
C beinhalten
E 4
        SAVE host,output
I 4
C Unterprogramme
E 4
        INTEGER getstring
I 4
C /HOST=STRING
E 4
        args.hostptr = getstring('HOST',host)
I 4
C /OUTPUT[=FILE]
C - /NOOUPUT muss explizit vermerkt werden
E 4
        IF (cli$present('OUTPUT').EQ.cli$_negated) THEN
         args.outputptr = -1
        ELSE
         args.outputptr = getstring('OUTPUT',output)
        ENDIF
I 4
C /FULL
E 4
        IF (cli$present('FULL').EQ.cli$_present) THEN
         args.mode = -1
I 4
C /FILES
E 4
        ELSEIF (cli$present('FILES').EQ.cli$_present) THEN
         args.mode = 1
        ELSE
I 4
C /BRIEF
C - was auch der Defaultwert ist
E 4
         args.mode = 0
        ENDIF
D 4
        IF (cli$present('GENERIC').EQ.cli$_present) THEN
E 4
I 4
C /GENERIC
C - die Abfrage wurde nicht auf CLI$_PRESENT gemacht, da /GENERIC ein Defaultqualifier ist
        IF (cli$present('GENERIC')) THEN
E 4
         args.generic = 1
        ELSE
         args.generic = 0
        ENDIF
I 7
C - /PARALLEL
        IF (cli$present('PARALLEL').EQ.cli$_negated) THEN
         args.parallel = 0
        ELSE
         args.parallel = 1
        ENDIF
I 9
C Auswahl der Jobs
        args.byjob = 0
E 9
E 7
I 4
C /ALL_JOBS
E 4
D 9
        IF (cli$present('ALL_JOBS').EQ.cli$_present.OR.
     $      cli$present('BY_JOB_STATUS').NE.cli$_present) THEN
         args.byjob = -1
        ELSE
E 9
I 9
        IF (cli$present('ALL_JOBS').EQ.cli$_present) args.byjob = args.byjob.OR.128
E 9
I 4
C /BY_JOB_STATUS=list(JOB_STATUS)
I 9
        IF (cli$present('BY_JOB_STATUS').NE.cli$_present) THEN
         args.byjob = args.byjob.OR.31
        ELSE
E 9
C - hier sind mehrere Optionen moeglich
E 4
D 9
         args.byjob = 0
E 9
I 4
C PENDING
E 4
D 9
         IF (cli$present('PENDING').EQ.cli$_present) args.byjob = 1
E 9
I 9
         IF (cli$present('PENDING').EQ.cli$_present) args.byjob = args.byjob.OR.1
E 9
I 4
C EXECUTING
E 4
D 9
         IF (cli$present('EXECUTING').EQ.cli$_present) args.byjob = args.byjob+2
E 9
I 9
         IF (cli$present('EXECUTING').EQ.cli$_present) args.byjob = args.byjob.OR.2
E 9
I 4
C HOLDING
E 4
D 9
         IF (cli$present('HOLDING').EQ.cli$_present) args.byjob = args.byjob+4
E 9
I 9
         IF (cli$present('HOLDING').EQ.cli$_present) args.byjob = args.byjob.OR.4
E 9
I 4
C TIMED_RELEASE
E 4
D 9
         IF (cli$present('TIMED_RELEASE').EQ.cli$_present) args.byjob = args.byjob+8
E 9
I 9
         IF (cli$present('TIMED_RELEASE').EQ.cli$_present) args.byjob = args.byjob.OR.8
E 9
I 4
C RETAINED
E 4
D 9
         IF (cli$present('RETAINED').EQ.cli$_present) args.byjob = args.byjob+16
E 9
I 9
         IF (cli$present('RETAINED').EQ.cli$_present) args.byjob = args.byjob.OR.16
E 9
        ENDIF
I 4
C Der Aufruf der C-Routine bekommt als Statusinformation mitgeteilt, ob es sich
C um einen initialen oder einen Folgeaufruf handelt. Letztere kann zum Beispiel
C bei SHOW ENTRY auftreten.
E 4
        args.firstcall = 1
        END


C
D 4
C SHOW QUEUE list(NUMBER)
E 4
I 4
C SHOW ENTRY P2(list(NUMBER))
E 4
C	/BRIEF
C       /BY_JOB_STATUS=list(JOB_STATUS)
C	/FILES
C	/FULL
C	/GENERIC
D 4
C       /HOST=name
C	/USER=name
C	/OUTPUT=file
E 4
I 4
C       /HOST=STRING
D 7
C	/USER=STRING
E 7
C	/OUTPUT[=FILE]
I 7
C       /PARALLEL
C	/USER=STRING
E 7
E 4
C
	SUBROUTINE QM_show_entry()
D 4

E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'	
D 4

E 4
I 4
C Lokale Variablen
E 4
        CHARACTER*132 mess,user,num
        RECORD /show/ args
        INTEGER res,rlen
D 4

E 4
I 4
C Unterprogramme
E 4
        INTEGER EQM_show_queue,getstring
D 4

E 4
I 4
C Allegemeine Qualifier einlesen
E 4
        CALL showgeneral(args)
D 4

E 4
I 4
C /USER=STRING
E 4
        args.userptr = getstring('USER',user)
I 9
        args.byjob = args.byjob.OR.128
E 9
I 4
C Die Option /SUMMARY gibt es nur fuer SHOW QUEUE
E 4
        args.summary = -1
D 4
        
E 4
I 4
C Naechsten Parameter einlesen
E 4
 1000   res = cli$get_value('P2',num(1:131),rlen)
I 4
C - Parameter wurde als Zeichenkette erfolgreich eingelesen
E 4
	IF (res.OR.res.EQ.cli$_comma.OR.res.EQ.cli$_concat) THEN
I 4
C - Da optinal auch ein '*' als Wert moeglich ist, erhaelt die ausfuehrende C-Routine
C   die Zeichenkette selbst und nicht den umgesetzen Wert. Damit ist ein Pattermatching
C   auf Basis der Zeichenkette moeglich
E 4
         args.queueptr = %loc(num)
I 4
C - Umwandeln in einen C-String
E 4
         num(rlen+1:rlen+1) = char(0)
I 4
C - Befehl ausfuehren und Fehler auswerten
E 4
	 GOTO (9998,1001,1002,1003) EQM_show_queue(args,%ref(mess))+1
	  CALL syntax()
	 GOTO 9999	
 1001	  CALL error(mess(:INDEX(mess,char(0))-1))
         GOTO 9999
 1002     CALL error('invalid HOST')
         GOTO 9999
 1003     CALL error('invalid OUTPUT')
         GOTO 9999
 5000     CALL error('invalid ENTRY')
         RETURN
I 4
C - Die naechsten Aufrufe sind Folgeaufrufe
E 4
 9998    args.firstcall = 0
I 4
C - Nachsehen, ob weitere Parameter vorhanden sind
E 4
         IF (res.EQ.cli$_comma.OR.res.EQ.cli$_concat) GOTO 1000
I 4
C - Ende der Liste ist erreicht
E 4
	ELSEIF (res.NE.cli$_absent) THEN
	 GOTO 5000
        ENDIF
D 4

E 4
 9999	END


C
D 4
C SYNCHRONIZE jobname
C     	/HOST=name
E 4
I 4
C SYNCHRONIZE P1(STRING)
C     	/HOST=STRING
E 4
C       /ENTRY=NUMBER
D 4
C       /QUEUE=queuename
E 4
I 4
C       /QUEUE=STRING
E 4
C
	SUBROUTINE QM_synchronize()
D 4
C Allgemeine Variablen
E 4
I 4
C Globale Variablen
E 4
	INCLUDE 'QM.INC'	
        COMMON /LASTENTRY/ lastentry
        INTEGER lastentry
C Lokale Variablen
D 12
        CHARACTER*132 queue,host,name,num,mess
E 12
I 12
        CHARACTER*132 queue,host,name,num,mess,ent
E 12
        RECORD /synchronize/ args
D 12
        INTEGER rlen,nnum
        INTEGER EQM_synchronize,getstring
E 12
I 12
        INTEGER rlen,nnum,elen
C Routinen
        INTEGER EQM_synchronize,getstring,lib$get_symbol
E 12
D 4
C /HOST=name
E 4
I 4
C /HOST=STRING
E 4
        args.hostptr = getstring('HOST',host)
D 4
C /QUEUE=quename
E 4
I 4
C /QUEUE=STRING
E 4
        args.queueptr = getstring('QUEUE',queue)
C /ENTRY=NUMBER
        IF (cli$get_value('ENTRY',num,rlen)) THEN
I 4
C - Umwandeln in eine Zahl. Das 'nameptr' Element der Interfacestruktur wird auf 0
C   gesetzt und zeigt an, dass eben KEIN Jobname, sondern die Jobnummer angegeben 
C   wurde
E 4
	 READ (num(:rlen),'(I)',ERR=5000,END=5000) args.entry
         args.nameptr = 0
        ELSEIF (cli$present('P1').EQ.cli$_present) THEN
D 4
C /NAME=name
E 4
I 4
C P1(STRING)
C - Geht nur, wenn /ENTRY nicht verwendet wurde
E 4
         args.entry = 0
         args.nameptr = getstring('P1',name)
        ELSE
C SYNCHRONIZE letzter gestarteter Job
D 12
         args.entry = lastentry
E 12
I 12
         IF (lib$get_symbol('$ENTRY',ent,elen,))
     $    READ (ent(:elen),'(I)',ERR=3000,END=3000) lastentry
 3000    args.entry = lastentry
E 12
         args.nameptr = 0
        ENDIF
C Befehl ausfuehren und Fehler anzeigen
        GOTO (9999,1001,1002,1003,1004) EQM_synchronize(args,%ref(mess))+1
         CALL syntax()
        GOTO 9999	
 1001    CALL error('invalid QUEUE')
        GOTO 9999
 1002    CALL error('invalid HOST')
        GOTO 9999
 1003    CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999	
 1004    CALL error('invalid Jobname')
        GOTO 9999
 5000    CALL error('invalid ENTRY')
        GOTO 9999
D 4
C Fertig
E 4
 9999	END


C
D 4
C SET ENTRY list(NUMBER)
C	/AFTER=datetime
C	/CLI=file
C	/CPUTIME=integer
C	/DATASIZE=integer
E 4
I 4
C SET ENTRY P2(list(NUMBER))
C	/AFTER=DATETIME
C	/CLI=STRING
C	/CPUTIME=NUMBER
C	/DATASIZE=NUMBER
C       /DELETE
E 4
C       /HOLD
D 4
C       /HOST=name
C	/LOG_FILE=file
C	/MEMORYSIZE=integer
C	/NAME=name
E 4
I 4
C       /HOST=STRING
C       /KEEP
C	/LOG_FILE=STRING
C	/MEMORYSIZE=NUMBER
C	/NAME=STRING
E 4
C	/NOTIFY
C	/PARAMETERS=list(STRING)
D 4
C	/PRIORITY=integer
C	/QUEUE=queuename
E 4
I 4
C       /PRINTER=STRING
C	/PRIORITY=NUMBER
C	/QUEUE=STRING
E 4
C       /RELEASE
D 4
C	/REQUEUE=queuename
E 4
I 4
C	/REQUEUE=STRING
E 4
C	/RESTART
C       /RMS_FILE
D 4
C	/STACKSIZE=integer
E 4
I 4
C	/STACKSIZE=NUMBER
I 8
C       /SUSPEND
E 8
E 4
C
	SUBROUTINE QM_set_entry()
D 4
C Allgemeine Parameter
E 4
I 4
C Globale Parameter
E 4
	INCLUDE 'QM.INC'	
D 4
C Lokale Parameter
E 4
I 4
C Lokale Variablen
E 4
        CHARACTER*132 requeue,num
        INTEGER rlen,res,kres
D 4
        RECORD /SUBMIT/ args
E 4
I 4
        RECORD /submit/ args
E 4
	INTEGER setsubmit,getstring,submiterror
D 4
C Allgemeine Qualifier
E 4
I 4
C Allgemeine Qualifier auswerten
E 4
        IF (setsubmit(args).NE.0) RETURN
I 4
C Initialisierung
E 4
        args.jobptr = 0
C /RELEASE
        IF (cli$present('RELEASE').EQ.cli$_present) args.hold = -1
D 4
C /REQUEUE=quename
E 4
I 4
C /REQUEUE=STRING
E 4
        args.requeueptr = getstring('REQUEUE',requeue)
C list(NUMBER)
I 4
C - Es muss mindestens ein Parameter angegeben werden
E 4
        IF (cli$present('P2').NE.cli$_present) THEN
         CALL syntax()
         RETURN
        ENDIF
D 4
C Alle Eintraege auslesen
E 4
I 4
C - Naechsten Eintrag als Zeichenkette auslesen
E 4
 1000   res = cli$get_value('P2',num(1:131),rlen)
D 4
	IF (res.OR.res.EQ.cli$_comma) THEN
E 4
I 4
C - Falls das gelungen ist:
	IF (res.OR.res.EQ.cli$_comma.OR.res.EQ.cli$_concat) THEN
C - Umwandeln in eine Zahl
E 4
	 READ (num(:rlen),'(I)',ERR=5000,END=5000) args.entry
I 4
C - Ausfuehren des Befehls
E 4
         kres = submiterror(args,0)
D 4
         IF (res.EQ.cli$_comma) GOTO 1000
E 4
I 4
C - Auch bei Fehlern weitermachen, falls noch weitere Eintraege vorhanden sind
         IF (res.EQ.cli$_comma.OR.res.EQ.cli$_concat) GOTO 1000
C - Ende der Liste erreicht
E 4
	ELSEIF (res.NE.cli$_absent) THEN
 5000    CALL error('invalid ENTRY')
        ENDIF
D 4
C Fertig
E 4
 9999   END

C
D 4
C INITIALIZE queuename
E 4
I 4
C INITIALIZE/QUEUE P1(STRING)
E 4
C     /ALGORITHM=NUMBER
C     /BASE_PRIORITY=NUMBER
C     /BATCH
C     /CPUMAXIMUM=NUMBER
C     /DATA_DEFAULT=NUMBER
C     /DATA_MAXIMUM=NUMBER
C     /FAULT_LIMIT=NUMBER
D 4
C     /HOST=name
E 4
I 4
C     /HOST=STRING
E 4
C     /JOB_LIMIT=NUMBER
C     /MEMORY_DEFAULT=NUMBER
C     /MEMORY_MAXIMUM=NUMBER
C     /MIN_IDLE=NUMBER
D 4
C     /QUEUE
E 4
I 4
C     /PARALLELSHELL=FILE
E 4
C     /STACK_DEFAULT=NUMBER
C     /STACK_MAXIMUM=NUMBER
C     /START
C
        SUBROUTINE QM_init()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /queue/ args
I 4
C Unterprogramme
E 4
        INTEGER setinit
D 4
C Parameter einlesen
E 4
I 4
C Allgemeine Parameter einlesen
E 4
        IF (setinit('P1',args).EQ.0) RETURN
C /START
        IF (cli$present('START').EQ.cli$_present) THEN
         args.start = 1
        ELSE
         args.start = 0
        ENDIF
C Befehl ausfuehren
        CALL goinit(args,1,1)
D 4
C Fertig
E 4
        END

D 4

E 4
I 4
C
C Allgemeine Parameter un Qualifier fuer die Befehle auslesen, die die gleiche Interface-
C struktur wie INITIALIZE/QUEUE benutzen.
C
E 4
        INTEGER FUNCTION setinit(qnam,args)
C Globale Variablen
        INCLUDE 'QM.INC'
C Parameter
        CHARACTER*(*) qnam
        RECORD /queue/ args
C Lokale Variablen
D 4
        CHARACTER*132 queue,host,requeue
        SAVE queue,host,requeue
E 4
I 4
        CHARACTER*132 queue,host,requeue,pdl
C Lokale Variablen sichern um deren Werte nach Ende der Routine zu behalten
        SAVE queue,host,requeue,pdl
C Unterprogramme
E 4
        INTEGER getstring,getnumber
D 4
C Mit dem schlimmsten rechnen
E 4
I 4
C Fehlercode setzen
E 4
        setinit = 0
D 4
C queuename
E 4
I 4
C Pi(STRING)
E 4
        args.queueptr = getstring(qnam,queue)
D 4
C /HOST=name
E 4
I 4
C /HOST=STRING
E 4
        args.hostptr = getstring('HOST',host)
C /ALGORITHM=NUMBER
        IF (getnumber('ALGORITHM',args.algo,-1,1,INT_MAX).EQ.0) RETURN
C /BASE_PRIORITY=NUMBER
        IF (getnumber('BASE_PRIORITY',args.prio,-1,0,INT_MAX).EQ.0) RETURN
C /CPUMAXIMUM=NUMBER
        IF (getnumber('CPUMAXIMUM',args.cpu,-1,1,INT_MAX).EQ.0) RETURN
C /DATA_DEFAULT=NUMBER
        IF (getnumber('DATA_DEFAULT',args.datadef,-1,1,INT_MAX).EQ.0) RETURN
C /DATA_MAXIMUM=NUMBER
        IF (getnumber('DATA_MAXIMUM',args.datamax,-1,1,INT_MAX).EQ.0) RETURN
C /FAULT_LIMIT=NUMBER
        IF (getnumber('FAULT_LIMIT',args.faults,-1,0,INT_MAX).EQ.0) RETURN
C /JOB_LIMIT=NUMBER
        IF (getnumber('JOB_LIMIT',args.jobs,-1,1,INT_MAX).EQ.0) RETURN
C /MEMORY_DEFAULT=NUMBER
        IF (getnumber('MEMORY_DEFAULT',args.memdef,-1,1,INT_MAX).EQ.0) RETURN
C /MEMORY_MAXIMUM=NUMBER
        IF (getnumber('MEMORY_MAXIMUM',args.memmax,-1,1,INT_MAX).EQ.0) RETURN
C /MIN_IDLE=NUMBER
        IF (getnumber('MIN_IDLE',args.minidle,-1,0,INT_MAX).EQ.0) RETURN
C /STACK_DEFAULT=NUMBER
        IF (getnumber('STACK_DEFAULT',args.stackdef,-1,1,INT_MAX).EQ.0) RETURN
C /STACK_MAXIMUM=NUMBER
        IF (getnumber('STACK_MAXIMUM',args.stackmax,-1,1,INT_MAX).EQ.0) RETURN
C /HOLD
        IF (cli$present('HOLD').EQ.cli$_present) THEN
         args.hold = 1
        ELSE
         args.hold = 0
        ENDIF
C /NEXT
        IF (cli$present('NEXT').EQ.cli$_present) THEN
         args.next = 1
C /RESET
I 4
C - kann nie zusammen mit /NEXT auftreten
E 4
        ELSEIF (cli$present('RESET').EQ.cli$_present) THEN
         args.next = -1
        ELSE
         args.next = 0
        ENDIF
C /PRIORITY=NUMBER
        IF (getnumber('PRIORITY',args.jprio,-1,0,INT_MAX).EQ.0) RETURN
D 4
C /REQUEUE=queuename
E 4
I 4
C /REQUEUE=STRING
E 4
        IF (cli$present('REQUEUE').EQ.cli$_present) THEN
         args.requeueptr = getstring('REQUEUE',requeue)
I 4
C - hat auch einen Einfluss auf die Bearbeitung
E 4
         args.next = -2
        ELSE
         args.requeueptr = 0
        ENDIF
D 4
C Fertig
E 4
I 4
C /PARALLELSHELL=FILE
        IF (cli$present('PARALLELSHELL').EQ.cli$_negated) THEN
         args.parptr = -1
        ELSE
         args.parptr = getstring('PARALLELSHELL',pdl)
        ENDIF
C Kein Fehler ist aufgetreten
E 4
        setinit = 1
        END

D 4

E 4
I 4
C
C Befehle, die die Interfacestruktur von INITIALIZE/QUEUE benutzen, ausfuehern und
C Fehler anzeigen.
C
E 4
        SUBROUTINE goinit(args,mode,log)
C Globale Variablen
        INCLUDE 'QM.INC'
C Parameter
        RECORD /queue/ args
        INTEGER mode,log
C Lokale Variablen
        CHARACTER*132 mess
        INTEGER kres
I 4
C Unterprogramme
E 4
        INTEGER eqm_control
C Befehl durchfuehren
        kres = eqm_control(args,%ref(mess),mode)
I 4
C /NOLOG verhinder, dass Fehler angezeigt werden
E 4
        IF (log.EQ.0) RETURN
C Fehler anzeigen
D 4
        GOTO (9999,1001,1002,1003) kres+1
E 4
I 4
        GOTO (9999,1001,1002,1003,1004) kres+1
E 4
         CALL SYNTAX()
        GOTO 9999
 1001    CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
 1002    CALL error('invalid QUEUE')
        GOTO 9999
 1003    CALL error('invalid HOST')
        GOTO 9999
D 4
C Ferig
E 4
I 4
 1004    CALL error('invalid PARALLELSHELL')
        GOTO 9999
E 4
 9999   END


C
D 4
C SET QUEUE queuename
E 4
I 4
C SET QUEUE P2(STRING)
E 4
C     /ALGORITHM=NUMBER
C     /BASE_PRIORITY=NUMBER
C     /CPUMAXIMUM=NUMBER
C     /DATA_DEFAULT=NUMBER
C     /DATA_MAXIMUM=NUMBER
C     /FAULT_LIMIT=NUMBER
D 4
C     /HOST=name
E 4
I 4
C     /HOST=STRING
E 4
C     /JOB_LIMIT=NUMBER
C     /MEMORY_DEFAULT=NUMBER
C     /MEMORY_MAXIMUM=NUMBER
C     /MIN_IDLE=NUMBER
I 4
C     /PARALLELSHELL=FILE
E 4
C     /STACK_DEFAULT=NUMBER
C     /STACK_MAXIMUM=NUMBER
C
        SUBROUTINE QM_set_queue()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /queue/ args
I 4
C Unterprogramme
E 4
        INTEGER setinit
D 4
C Parameter einlesen
E 4
I 4
C P2(STRING)
E 4
        IF (setinit('P2',args).EQ.0) RETURN
I 4
C Initialisierung
E 4
        args.start = 0
C Befehl ausfuehren
        CALL goinit(args,0,1)
D 4
C Fertig
E 4
        END


C
D 4
C START/QUEUE queuename
E 4
I 4
C START/QUEUE P1(STRING)
E 4
C     /ALGORITHM=NUMBER
C     /BASE_PRIORITY=NUMBER
C     /BATCH
C     /CPUMAXIMUM=NUMBER
C     /DATA_DEFAULT=NUMBER
C     /DATA_MAXIMUM=NUMBER
C     /FAULT_LIMIT=NUMBER
D 4
C     /HOST=name
E 4
I 4
C     /HOST=STRING
E 4
C     /JOB_LIMIT=NUMBER
C     /MEMORY_DEFAULT=NUMBER
C     /MEMORY_MAXIMUM=NUMBER
C     /MIN_IDLE=NUMBER
I 4
C     /PARALLELSHELL=FILE
E 4
C     /STACK_DEFAULT=NUMBER
C     /STACK_MAXIMUM=NUMBER
C
        SUBROUTINE QM_start_queue()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /queue/ args
        INTEGER setinit
D 4
C Parameter einlesen
E 4
I 4
C P1(STRING)
E 4
        IF (setinit('P1',args).EQ.0) RETURN
I 4
C Initialisieren
E 4
        args.start = 1
C Befehl ausfuehren
        CALL goinit(args,0,1)
D 4
C Fertig
E 4
        END


C
D 4
C DELETE/QUEUE queuename
C     /HOST=name
E 4
I 4
C DELETE/QUEUE P1(STRING)
C     /HOST=STRING
E 4
C     /LOG
C
        SUBROUTINE QM_delete_queue()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /queue/ args
        INTEGER logging
I 4
C Unterprogramme
E 4
        INTEGER setinit
D 4
C Parameter einlesen
E 4
I 4
C P1(STRING)
E 4
        IF (setinit('P1',args).EQ.0) RETURN
I 4
C Initialisieren
E 4
        args.start = 0
C /LOG
        IF (cli$present('LOG').EQ.cli$_negated) THEN
         logging = 0
        ELSE
         logging = 1
        ENDIF
C Befehl ausfuehren
        CALL goinit(args,-1,logging)
D 4
C Fertig
E 4
        END


C
D 4
C STOP/QUEUE queuename
E 4
I 4
C STOP/QUEUE P1(STRING)
E 4
C     /HOLD
D 4
C     /HOST=name
E 4
I 4
C     /HOST=STRING
E 4
C     /NEXT
C     /PRIORITY=NUMBER
D 4
C     /REQUEUE=queuename
E 4
I 4
C     /REQUEUE=STRING
E 4
C     /RESET
C
        SUBROUTINE QM_stop_queue()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /queue/ args
I 4
C Unterprogramme
E 4
        INTEGER setinit
D 4
C Bei /ENTRY= andere Aktionen
E 4
I 4
C /ENTRY bedeutet eine ganz andere Aktion mit einer anderen Interfacestruktur
E 4
        IF (cli$present('ENTRY').EQ.cli$_present) THEN
         CALL QM_stop_entry()
        ELSE
D 4
C Parameter einlesen
E 4
I 4
C P1(STRING)
E 4
         IF (setinit('P1',args).EQ.0) RETURN
         args.start = -1
C Befehl ausfuehren
         CALL goinit(args,0,1)
        ENDIF
D 4
C Fertig
E 4
        END

C
D 4
C STOP/QUEUE queuename
E 4
I 4
C STOP/QUEUE P1(STRING)
E 4
C     /ENTRY=list(NUMBER)
C     /HOLD
D 4
C     /HOST=name
E 4
I 4
C     /HOST=STRING
E 4
C     /PRIORITY=NUMBER
D 4
C     /REQUEUE=queuename
E 4
I 4
C     /REQUEUE=STRING
E 4
C
        SUBROUTINE QM_stop_entry()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /submit/ args
        CHARACTER*132 num,requeue
        INTEGER res,kres,rlen
I 4
C Unterprogramme
E 4
        INTEGER setsubmit,getstring,submiterror
D 4
C Ohne /REQUEUE ist das dasselbe wie DELETE/ENTRY
E 4
I 4
C Mit /REQUEUE ist das dasselbe wie ein erweitertes DELETE/ENTRY
E 4
        IF (cli$present('REQUEUE').EQ.cli$_present) THEN
I 4
C - Allgemeine Qualifier einlesen
E 4
         IF (setsubmit(args).NE.0) RETURN
         args.jobptr = 0
D 4
C /REQUEUE=queuename
E 4
I 4
C - /REQUEUE=STRING
E 4
         args.requeueptr = getstring('REQUEUE',requeue)
D 4
C list(NUMBER)
E 4
I 4
C - /ENTRY=list(NUMBER)
C -- Dieser Qualifier muss vorhanden sein
E 4
         IF (cli$present('ENTRY').NE.cli$_present) THEN
          CALL syntax()
          RETURN
         ENDIF
D 4
C Alle Eintraege auslesen
E 4
I 4
C - Naechstes Element ermitteln
E 4
 1000    res = cli$get_value('ENTRY',num(1:131),rlen)
I 4
C - Zeichenkette erhalten
E 4
	 IF (res.OR.res.EQ.cli$_comma) THEN
I 4
C - Umwandeln in eine Zahl
E 4
	  READ (num(:rlen),'(I)',ERR=5000,END=5000) args.entry
I 4
C - Befehl ausfuehren, Fehler ignorieren
E 4
          kres = submiterror(args,-1)
I 4
C - Weitermachen, falls noch Elemente vorhanden sind
E 4
          IF (res.EQ.cli$_comma) GOTO 1000
I 4
C - Ende der Liste ist erreicht
E 4
	 ELSEIF (res.NE.cli$_absent) THEN
 5000     CALL error('invalid ENTRY')
         ENDIF
        ELSE
I 4
C Ohne /REQUEUE ist STOP/QUEUE/ENTRY genau dasselbe wie DELETE/ENTRY
E 4
         CALL QM_delete_entry()
        ENDIF
D 4
C Fertig
E 4
 9999   END


C
C START/QUEUE/MANAGER
D 4
C     /HOST=hostname
E 4
I 4
C     /HOST=STRING
E 4
C     /NEW_VERSION
C
        SUBROUTINE QM_start_queue_manager()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        CHARACTER*132 host,mess
        INTEGER code,hostptr
I 4
C Unterprogramme
E 4
        INTEGER getstring,EQM_manager
D 4
C /HOST=hostname
E 4
I 4
C /HOST=STRING
E 4
        hostptr = getstring('HOST',host)
C /NEW_VERSION
        IF (cli$present('NEW_VERSION').EQ.cli$_present) THEN
         code = 0
        ELSE
         code = 1
        ENDIF
D 4
C Ausfuehren
E 4
I 4
C Ausfuehren des Befehls und Ausgabe etwaiger Fehlermeldungen
E 4
	GOTO (9999,1001,1002) EQM_manager(hostptr,code,mess)+1
	 CALL syntax()
	GOTO 9999	
 1001    CALL error('invalid HOST')
        GOTO 9999
 1002    CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
D 4
C Fertig
E 4
 9999   END


C
C STOP/QUEUE/MANAGER
D 4
C     /HOST=hostname
E 4
I 4
C     /HOST=STRING
E 4
C
        SUBROUTINE QM_stop_queue_manager()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        CHARACTER*132 host,mess
        INTEGER hostptr
I 4
C Unterprogramme
E 4
        INTEGER getstring,EQM_manager
D 4
C /HOST=hostname
E 4
I 4
C /HOST=STRING
E 4
        hostptr = getstring('HOST',host)
D 4
C Ausfuehren
E 4
I 4
C Befehl ausfuehren und Fehler melden
E 4
	GOTO (9999,1001,1002) EQM_manager(hostptr,-1,mess)+1
	 CALL syntax()
	GOTO 9999	
 1001    CALL error('invalid HOST')
        GOTO 9999
 1002    CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
D 4
C Fertig
E 4
 9999   END

I 3

C
I 4
C SHOW JOB P2(list(STRING))
C       /BRIEF
I 6
C       /ENTRY=list(NUMBER)
E 6
C       /FULL
C       /HOST=STRING
C	/OUTPUT[=FILE]
C       /PARALLEL
D 6
C       /ENTRY=list(NUMBER)
E 6
I 6
C       /USER=STRING
E 6
C
        SUBROUTINE QM_show_job()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
D 6
        CHARACTER*132 output,num,mess,host
E 6
I 6
        CHARACTER*132 output,num,mess,host,user
E 6
        RECORD /show/ args
        INTEGER res,rlen
C Unterprogramme
        INTEGER EQM_show_job,getstring,showjob
C Initialisieren
        args.firstcall = 1
        args.mode = 0
C /FULL
        IF (cli$present('FULL').EQ.cli$_present) args.mode = args.mode.OR.4
C /HOST=STRING
        args.hostptr = getstring('HOST',host)
C /OUTPUT[=FILE]
C - /NOOUTPUT muss gesondert behandelt werden
        IF (cli$present('OUTPUT').EQ.cli$_negated) THEN
         args.outputptr = -1
        ELSE
         args.outputptr = getstring('OUTPUT',output)
        ENDIF
C /PARALLEL
        IF (cli$present('PARALLEL').EQ.cli$_present) args.mode = args.mode.OR.2
I 6
C /USER=STRING
        args.userptr = getstring('USER',user)
E 6
C /ENTRY=list(NUMBER)
C - Nachsehen, ob eine Liste von Zahlen angegeben ist
        IF (cli$present('ENTRY').EQ.cli$_present) THEN
C - Naechste Zahl als Zeichenkette auslesen
 1000    res = cli$get_value('ENTRY',num(1:131),rlen)
         IF (res.OR.res.EQ.cli$_comma) THEN
C - Da auch hier '*' als Pattern moeglich ist, erhaelt die C-Routine die nicht in eine
C   Zahl umgesetzte Zeichenkette direkt
          num(rlen+1:rlen+1) = char(0)
C - Befehl ausfueheren
          IF (showjob(args,num).EQ.0) GOTO 9999
C - Weitermachen, falls noch Elemente vorhanden sind
          IF (res.EQ.cli$_comma) GOTO 1000
C - Die Liste ist zueende
         ELSEIF (res.NE.cli$_absent) THEN
          CALL error('invalid ENTRY')
         ENDIF
        ELSE
C P2(list(STRING))
C - P2 und /ENTRY schliessen sich aus
         args.mode = args.mode.OR.1
C - Naechsten Jobnamen als Zeichenkette ermitteln
 2000    res = cli$get_value('P2',num(1:131),rlen)
         IF (res.OR.res.EQ.cli$_comma.OR.res.EQ.cli$_concat) THEN
C - In die Interfacestruktur eintragen
          num(rlen+1:rlen+1) = char(0)
C - Befehl ausfuehren
          IF (showjob(args,num).EQ.0) GOTO 9999
C - Weitermachen, solange die Liste nicht abgearbeitet ist
          IF (res.EQ.cli$_comma.OR.res.EQ.cli$_concat) GOTO 2000
C - Ende der Liste
         ELSEIF (res.NE.cli$_absent) THEN
          CALL error('invalid jobname')
         ENDIF
        ENDIF
 9999   END

C
C Die folgende Routine fuehrt einen SHOW JOB Befehl aus. Der formale Parameter 'num'
C enthaelt als Zeichenkette ein Suchpattern fuer Jobnummer oder Jobname. Die Unter-
C scheidung dazwischen wird mit dem Interfaceelement 'mode' getroffen.
C
        INTEGER FUNCTION showjob(args,num)
C Globale Variablen
        INCLUDE 'QM.INC'
C Parameter
        RECORD /show/ args
        CHARACTER*132 num
C Lokale Variablen
        CHARACTER*132 mess
C Unterprogramme
        INTEGER eqm_show_job
C Fehlercode setzen
        showjob = 0
C Befehl durchfuehren
        args.queueptr = %loc(num)
C Fehler melden
        GOTO (1098,1001,1002,1003) EQM_show_job(args,%ref(mess))+1
         CALL syntax()
        GOTO 9999
 1001	 CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
 1002    CALL error('invalid HOST')
        GOTO 9999
 1003    CALL error('invalid OUTPUT')
        GOTO 9999
C Ist nicht mehr der erste Aufruf
 1098   args.firstcall = 0
C Hat alles geklappt
        showjob = 1
 9999   END
          

C
C SHOW EXECUTERS P2(list(STRING))
C       /HOST=STRING
C	/OUTPUT[=FILE]
C
        SUBROUTINE QM_show_executer()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        CHARACTER*132 output,id,mess,host
        RECORD /show/ args
        INTEGER res,rlen
C Unterprogramme
        INTEGER EQM_show_exec,getstring
C /HOST=hostname
        args.hostptr = getstring('HOST',host)
C /OUTPUT[=FILE]
C - /NOOUTPUT muss gesondert behandelt werden
        IF (cli$present('OUTPUT').EQ.cli$_negated) THEN
         args.outputptr = -1
        ELSE
         args.outputptr = getstring('OUTPUT',output)
        ENDIF
C Initialisierung
        args.firstcall = 1
C P2(list(STRING))
C - Zeichenkette auslesen
 1000   res = cli$get_value('P2',id(1:131),rlen)
        IF (res.OR.res.EQ.cli$_comma.OR.res.EQ.cli$_concat) THEN
C - Als C-String in die Interfacestruktur eintragen
         args.queueptr = %loc(id)
         id(rlen+1:rlen+1) = char(0)
C - Befehl ausfuehren und Fehler melden
         GOTO (9998,1001,1002,1003) EQM_show_exec(args,%ref(mess))+1
          CALL syntax()
         GOTO 9999
 1001	  CALL error(mess(:INDEX(mess,char(0))-1))
         GOTO 9999
 1002     CALL error('invalid HOST')
         GOTO 9999
 1003     CALL error('invalid OUTPUT')
         GOTO 9999
C - Der naechste Aufruf ist nicht mehr der erste
 9998    args.firstcall = 0
C - Weitermachen, wenn noch Listenelemente vorhanden sind
         IF (res.EQ.cli$_comma.OR.res.EQ.cli$_concat) GOTO 1000
C - Ende der Liste erreicht
        ELSEIF (res.NE.cli$_absent) THEN
         CALL error('invalid executer name')
        ENDIF
 9999   END


C
C CREATE/STARTUP
C       /ALL
C	/EXECUTERS=list(STRING)
C       /HOST=STRING
C
        SUBROUTINE QM_create_startup()
C Globale Variablen
        INCLUDE 'QM.INC'
C Lokale Variablen
        RECORD /show/ args
        CHARACTER*132 host,exec
        INTEGER res,rlen
C Unterprogramme
        INTEGER startup,getstring
C Initialisieren
        args.firstcall = 1
        args.queueptr = 0
C /HOST=hostname
        args.hostptr = getstring('HOST',host)
C /EXECUTERS=list(STRING)
C - Dieser Qualifier muss nicht vorhanden sein
        IF (cli$present('EXECUTERS').EQ.cli$_present) THEN
C - Zeichenkette ermitteln
 1000    res = cli$get_value('EXECUTERS',exec(1:131),rlen)
         IF (res.OR.res.EQ.cli$_comma) THEN
C - Als C-String in die Interfacestruktur eintragen
          exec(rlen+1:rlen+1) = char(0)
          args.queueptr = %loc(exec)
C - Befehl ausfuehren
          IF (startup(args).EQ.0) GOTO 9999
C - Weitermachen, solange noch Elemente vorhanden sind
          IF (res.EQ.cli$_comma) GOTO 1000
C - Ende der Liste erreicht
         ELSEIF (res.NE.cli$_absent) THEN
          CALL error('invalid value for EXECUTERS')
         ENDIF
C Erst einmal den Befehl fuer die GEN-Queue abschicken
        ELSEIF (startup(args).EQ.1) THEN
C /ALL
C - bedeutet, dass zusaetzlich zur GEN-Queue alle bekannten EXEC-Queues ebenfalls ange-
C   sprochen sind. Dafuer wird einfach das Wildcardpattern '*' verwendet.
         IF (cli$present('ALL').EQ.cli$_present) THEN
C - C-String aufbauen und eintragen
          exec = '*'//char(0)
          args.queueptr = %loc(exec)
C - Befehl ausfuehren
	  CALL startup(args)
         ENDIF
        ENDIF
 9999   END

C
C CREATE/STARTUP Befehl ausfuehren und Fehler melden
C
        INTEGER FUNCTION startup(args)
C Globale Variablen
        INCLUDE 'QM.INC'
C Parameter
        RECORD /show/ args
C Lokale Variablen
        CHARACTER*132 mess
C Unterprogramme
        INTEGER eqm_startup
C Fehlercode setzen
        startup = 0
C Befehl ausfuehren und etwaige Fehler auswerten
        GOTO (9998,1001,1002,1003) EQM_startup(args,%ref(mess))+1
         CALL syntax()
        GOTO 9999
 1001	 CALL error(mess(:INDEX(mess,char(0))-1))
        GOTO 9999
 1002    CALL error('invalid HOST')
        GOTO 9999
 1003    CALL error('invalid EXECUTER')
        GOTO 9999
C Hat alles geklappt
 9998   startup = 1
C Jetzt ist alles initialisiert
        args.firstcall = 0
 9999   END


C
E 4
C VERSION
C
        SUBROUTINE QM_version()
D 6
C Globale Variablen
        INCLUDE 'QM.INC'
D 4
C Version ausgeben
E 4
I 4
C SCCS Versionsnummer ausgeben
E 4
        CALL error('VMS/UNIX QueueManager Version %I% by Jochen Manns (%E% %U%)')
E 6
I 6
C Keine globale Variablen
        IMPLICIT NONE
C SCCS Versionsnummer des C-Teils ausgeben
        CALL EQM_version()
E 6
D 4
C Fertig
E 4
        END
I 4

I 14

C
D 15
C SET MODE TERMINAL|MOTIF
E 15
I 15
C SET MODE (TERMINAL|MOTIF)
E 15
C
        SUBROUTINE QM_set_mode
C Globale Variable
        INCLUDE 'QM.INC'
D 15
C Hier macht nur SET MODE MOTIF Sinn
        IF (cli$present('MOTIF').EQ.cli$_present) THEN
         CALL EQM_motif()
E 15
I 15
C Kontrollschnittstelle
        COMMON /motif/ motcommand,motcommandlen
        CHARACTER*256 motcommand
        INTEGER motcommandlen
C SET MODE TERMINAL
        IF (cli$present('TERMINAL').EQ.cli$_present.AND.motcommandlen.GE.0) THEN
         CALL EQM_motif(%ref(motcommand),motcommandlen,1)
C SET MODE MOTIF
        ELSEIF (cli$present('MOTIF').EQ.cli$_present.AND.motcommandlen.LT.0) THEN
         CALL EQM_motif(%ref(motcommand),motcommandlen,0)
E 15
        ENDIF
C Fertig
        END
E 14
E 4
E 3
E 1
