h03092
s 00002/00002/02270
d D 5.5 91/08/16 17:44:05 jochen 25 24
c Parameter name modified for use with VMS
e
s 00019/00010/02253
d D 5.4 91/08/16 17:27:22 jochen 24 23
c SHOW QUEUE|ENTRY /[NO]GENERIC interpretation modified
e
s 00030/00021/02233
d D 5.3 91/08/16 11:01:03 jochen 23 22
c SHOW QUEUE output modified ; default sufficies added
e
s 00057/00010/02197
d D 5.2 91/08/13 10:32:22 jochen 22 21
c Output redirection to Motif Text Widget added
e
s 00028/00000/02179
d D 5.1 91/08/12 17:41:36 jochen 21 20
c Xqueue included in QMan; SET MODE command added
e
s 00005/00003/02174
d D 4.15 91/05/28 11:31:24 jochen 20 19
c RMS_FILE modified, sleep(2) added to SHOW EXECUTERS
e
s 00001/00001/02176
d D 4.14 91/05/03 09:30:40 jochen 19 18
c NONOTIFY is default
e
s 00003/00002/02174
d D 4.13 91/05/03 09:17:26 jochen 18 17
c SUBMIT/IDENTIFY added
e
s 00023/00022/02153
d D 4.12 91/04/30 08:50:02 jochen 17 16
c /LOG now uses /NAME
e
s 00010/00002/02165
d D 4.11 91/04/02 14:07:41 jochen 16 15
c PARAMETERS handling in SHOWs modified
e
s 00058/00007/02109
d D 4.10 91/04/02 12:39:26 jochen 15 14
c /USER option handling modified
e
s 00022/00014/02094
d D 4.9 91/03/15 11:31:21 jochen 14 13
c SET ENTRY/[NO]SUSPEND supported
e
s 00002/00002/02106
d D 4.8 91/03/09 11:07:49 jochen 13 12
c Using RPC/UDP/IP for SHOW EXECUTERS/JOB
e
s 00005/00003/02103
d D 4.7 91/03/05 15:11:59 jochen 12 11
c Output for hints modified
e
s 00002/00002/02104
d D 4.6 91/03/01 13:50:26 jochen 11 10
c SHOW JOB output extended with EXECs name
e
s 00003/00000/02103
d D 4.5 91/02/28 13:17:21 jochen 10 9
c SHOW QUEUE|ENTRY /PARALLEL Qualifier added
e
s 00001/00000/02102
d D 4.4 91/02/27 15:17:55 jochen 9 8
c VERSION command output corrected
e
s 00033/00019/02069
d D 4.3 91/02/27 15:16:40 jochen 8 7
c SHOW JOB/USER added, Queuenames no longer converted to uppercase
e
s 00003/00000/02085
d D 4.2 91/02/26 11:55:36 jochen 7 6
c INADDR_NULL added for VAX UCX
e
s 00000/00000/02085
d D 4.1 91/02/26 11:29:21 jochen 6 5
c Using SUN reserved RPC number, GEN-Queue back to RPC version 1
e
s 01170/00351/00915
d D 3.4 91/02/26 11:26:02 jochen 5 4
c New version completed and support for parallel queues added
e
s 00001/00001/01265
d D 3.3 91/02/08 15:47:20 jochen 4 3
c SCCS variable renamed for common use
e
s 00002/00002/01264
d D 3.2 91/02/08 15:46:07 jochen 3 2
c Filter renamed to converter
e
s 00018/00009/01248
d D 3.1 91/01/15 16:12:39 jochen 2 1
c adapted to GEN-Queue version 3
e
s 01257/00000/00000
d D 2.1 91/01/03 10:06:10 jochen 1 0
c SCCS based version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue user interface for UNIX and VMS */

#ifdef SCCSIDS
D 2
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991"
E 2
I 2
D 4
static char sccsid[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
I 4
static char sccsid_queexec_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
E 4
E 2
#endif

/*
  Queue Manager

	Part II : Executers
I 5

	Dieser Quelltext enthaelt die Umsetzung der von 'queparse.f' erhaltenen
	Interfacestrukturen in RPC-Strukturen fuer die GEN-Queue und die Aus-
	fuehrung des entsprechenden Befehls.
E 5
*/
#include <errno.h>
I 5
#include <netdb.h>
E 5
#include <stdio.h>
#include <limits.h>
#include <varargs.h>

#ifdef DGUX
I 5
/* 
  FORTRAN-Programme des Green Hills FORTRAN Compilers enden alle mit einem Underscore.
  Die hier verwendeten Definitionen erlauben eine Nutzung der C-Routinen von FORTRAN
  aus bei hoher Kompatibilitaet der C-Quelltexte unter UNIX und VAX/VMS.
*/
E 5
#define eqm_quit	eqm_quit_
I 8
#define eqm_version	eqm_version_
E 8
#define eqm_submit	eqm_submit_
#define eqm_kill	eqm_kill_
#define eqm_show_queue	eqm_show_queue_
I 5
#define eqm_show_job	eqm_show_job_
#define eqm_show_exec	eqm_show_exec_
#define eqm_startup	eqm_startup_
E 5
#define eqm_synchronize eqm_synchronize_
#define eqm_control	eqm_control_
#define eqm_manager	eqm_manager_
I 21
#define eqm_motif	eqm_motif_
E 21

#define f77_print	f77_print_
I 22
#define m77_puts	m77_puts_
E 22
#define queueECPT	queueecpt_
#endif

I 5
/*
  Unterschiede zwischen UNIX und VAX/VMS: Definitionen
*/
E 5
#ifdef vms
I 5
/* VAX/VMS spezifische INCLUDE-Dateien */
E 5
#include file
#include ssdef
#include jpidef

I 5
/* INCLUDE-Dateien an speziellen Positionen */
E 5
#include <sunrpc$dir:[rpc]rpc.h>

#include "sgen.h"
I 5
#include "[-.library]support.h"
E 5

I 5
/* Fehlercodes */
E 5
#define NOERROR		SS$_NORMAL
I 5

/* Devicenamen */
E 5
#define NULLDEVICE	"NL:"

I 7
/* Illegale TCP/IP-Adresse */
#define INADDR_NULL	0xffffffff

E 7
I 5
/* Parameterstruktur fuer Systemaufrufe */
E 5
struct item_list_3
       {
	short blen;
	short code;
	char  *addr;
	short *rlen;
       };

I 5
/* UCXRPC Utilities zum Umsetzen von Benutzernamen */
E 5
extern struct ProxyEntry *getUNIXuser(),*getVMSuser();
#else
I 5
/* UNIX spezifische INCLUDE-Dateien */
E 5
#include <pwd.h>
#include <fcntl.h>

#include <rpc/rpc.h>

I 15
#include <sys/signal.h>
E 15
I 5
#include <sys/socket.h>

E 5
#include <saphir/vmsdef.h>

I 5
/* Interface zur GEN-Queue */
E 5
#include "../generic/sgen.h"
I 5
/* Gemeinsame Konstanten und Routinen mit '../parallel/parallel.c' */
#include "../library/support.h"
E 5

I 5
/* Fehlercode */
E 5
#define NOERROR		0
I 5
/* Devices */
E 5
#define NULLDEVICE	"/dev/null"

I 5
/* Routine zum ermitteln der aktuellen Defaultdirectory */
E 5
extern char *getcwd();
#endif

I 5
/* 
  Die folgenden Definitionen sind UNIX und VAX/VMS gemeinsam.
*/
/* Oft benutzter Zeiger */
E 5
D 24
#define NOSTR		((char *)0)
E 24
I 24
#define NOSTR			((char *)0)
E 24
D 5
#define INET_NTOA(i)	inet_ntoa(*(struct in_addr *)&(i))
E 5
I 5

/* Rueckgabewerte von 'fillinfo' */
D 24
#define FILL_NOHOST	1
#define FILL_NOINFO	2
E 24
I 24
#define FILL_NOHOST		1
#define FILL_NOINFO		2
E 24

/* Oft benutzte Umsetzung logischer Namen fuer /HOST oder einen Queuenamen */
E 5
D 24
#define newhost(s,r)	{if ( !makelogical(s,host,sizeof(host)) ) return r;}
#define newqueue(s,r)   {if ( !makelogical(s,qbuf,sizeof(qbuf)) ) return r;}
E 24
I 24
#define newhost(s,r)		{if ( !makelogical(s,host,sizeof(host)) ) return r;}
#define newqueue(s,r)   	{if ( !makelogical(s,qbuf,sizeof(qbuf)) ) return r;}
E 24

I 24
/* Genericjobs */
#define isGeneric(j)		(!strchr((j)->genReq.queue,'_'))
#define matchGeneric(j,a)	((!isGeneric(j)) == (!(a)->generic))

E 24
D 5
#define Qinfo		qinfo
#define Kind		info.kind
#define Jinfo		info.jkinfo_u.jinfo
#define Kinfo		info.jkinfo_u.kinfo
#define execReq		request.Jinfo
#define execSig		request.Kinfo
#define genReq		request.qinfo
#define jgen		Jgen.genptr_u.ptr
#define jexec		Jexec.execptr_u.ptr
#define jobID		execReq.requestID


E 5
I 5
/* Die Interfacestrukturen muessen mit denen in QM.INC uebereinstimmen */
E 5
struct QMsubmit
       {
D 5
	char 		*jobptr;
	char		*timeptr;
	char		*cliptr;
	int		cpu;
	int		datasize;
	char		*hostptr;
	char		*logptr;
	int		memorysize;
	char		*nameptr;
	int		notify;
	int		rmsfile;
	int		prio;
	char 		*queueptr;
	char 		*requeueptr;
	int		restart;
	int		stacksize;
	char		*userptr;
	int		hold;
	int		entry;
	int		nparptr;
	char		*parptr[1];	/* Dynamisch: parptr[nparptr] */
E 5
I 5
	char 		*jobptr;	/* P1				*/
	char		*timeptr;	/* /AFTER			*/
	char		*cliptr;	/* /CLI				*/
	int		cpu;		/* /CPUTIME			*/
	int		datasize;	/* /DATASIZE			*/
	char		*hostptr;	/* /HOST			*/
	char		*logptr;	/* /LOG_FILE			*/
	int		memorysize;	/* /MEMORYSIZE			*/
	char		*nameptr;	/* /NAME			*/
	int		notify;		/* /NOTIFY			*/
	int		rmsfile;	/* /RMS_FILE			*/
	int		prio;		/* /PRIORITY			*/
	char 		*queueptr;	/* /QUEUE			*/
	char 		*requeueptr;	/* /REQUEUE			*/
	int		restart;	/* /RESTART			*/
	int		stacksize;	/* /STACKSIZE			*/
	char		*userptr;	/* /USER			*/
	int		hold;		/* /HOLD			*/
	int		entry;		/* ENTRY		        */
	int		delete;		/* /DELETE			*/
	int		keep;		/* /KEEP			*/
	int		printer;	/* /PRINTER			*/
	char		*prtptr;	/* /PRINTER			*/
I 14
D 18
	int		suspend;	/* /[NO]SUSPEND			*/
E 18
I 18
	int		suspend;	/* /SUSPEND			*/
	int		identify;	/* /IDENTIFY			*/
E 18
E 14
	int		nparptr;	/* /PARAMETER			*/
	char		*parptr[1];	/* /PARAMETER			*/
E 5
       };

struct QMshow
       {
D 5
	char		*queueptr;
	char		*hostptr;
	char		*outputptr;
	char		*userptr;
	int		mode;
	int		byjob;
	int		generic;
	int		summary;
	int		firstcall;
E 5
I 5
	char		*queueptr;	/* P1				*/
	char		*hostptr;	/* /HOST			*/
	char		*outputptr;	/* /OUTPUT			*/
	char		*userptr;	/* /USER			*/
	int		mode;		/* /FULL/BRIEF			*/
	int		byjob;		/* /BY_JOB_STATUS		*/
	int		generic;	/* /GENERIC			*/
	int		summary;	/* /SUMMARY			*/
	int		firstcall;	/* 'fillinfo' nur einmal !	*/
I 10
	int		parallel;	/* /PARALLEL			*/
E 10
E 5
       };

struct QMsynchronize
       {
D 5
	char		*nameptr;
	int		entry;
	char		*queueptr;
	char		*hostptr;
E 5
I 5
	char		*nameptr;	/* P1				*/
	int		entry;		/* /ENTRY			*/
	char		*queueptr;	/* /QUEUE			*/
	char		*hostptr;	/* /HOST			*/
E 5
       };

struct QMcontrol
       {
D 5
	char 		*queueptr;
	char		*requeueptr;
	char 		*hostptr;
	int		algo;
	int		prio;
	int		cpu;
	int		datadef;
	int		datamax;
	int		faults;
	int		jobs;
	int		memdef;
	int		memmax;
	int		minidle;
	int		stackdef;
	int		stackmax;
	int		start;
	int		hold;
	int		jprio;
	int		next;
E 5
I 5
	char 		*queueptr;	/* /QUEUE			*/
	char		*requeueptr;	/* /REQUEUE			*/
	char 		*hostptr;	/* /HOST			*/
	int		algo;		/* /ALGORITHM			*/
	int		prio;		/* /BASE_PRIORITY		*/
	int		cpu;		/* /CPUMAXIMUM			*/
	int		datadef;	/* /DATA_DEFAULT		*/
	int		datamax;	/* /DATA_MAXIMUM		*/
	int		faults;		/* /FAULT_LIMIT			*/
	int		jobs;		/* /JOB_LIMIT			*/
	int		memdef;		/* /MEMORY_DEFAULT		*/
	int		memmax;		/* /MEMORY_MAXIMUM		*/
	int		minidle;	/* /MIN_IDLE			*/
	int		stackdef;	/* /STACK_DEFAULT		*/
	int		stackmax;	/* /STACK_MAXIMUM		*/
	int		start;		/* /START			*/
	int		hold;		/* /HOLD			*/
	int		jprio;		/* /PRIORITY			*/
	int		next;		/* /NEXT			*/
	char		*parptr;	/* /PARALLELSHELL		*/
E 5
       };

D 5
static int outdone,needheader,shown,outf = -1;
static char host[64] = "",qbuf[132];
E 5
I 5
/*
  Globale Variablen. Manche der Variablen sind nur aus Bequemlichkeit angebracht
  um die Uebergabe diverser aktueller Parameter zu vermeiden.
*/
D 22
static int outdone,needheader,shown,outf = -1,eprog = -1,evers = -1;
E 22
I 22
static int outdone,needheader,shown,outf = -1,eprog = -1,evers = -1,MotifRunning = 0;
E 22
static char qbuf[132],host[256] = "";
static masterctrl *info = 0;
E 5
static CLIENT *gen = 0;

I 21
D 22
int MotifRunning = 0;

E 22
E 21
I 5
/*
  Lokale Unterprogramme, deren Kontext eine Vordefinition erfordern.
*/
static void se_show(),sj_jobs(),ds_dump();
static char *action(),*IPname();
E 5
static execctrl *findexec();
static genctrl *findgen();
D 5
static char *action();
E 5
I 5
static long IPaddr();
E 5

I 15
D 22
int eqm_quit();

E 22
E 15
D 5
extern char *translate_vms_default(),*translate_vms(),*ctime();
E 5
I 5
/*
  Externe Unterprogramme zum Arbeiten mit VAX/VMS Zeitformaten, TCP/IP-Adressen und
  UNIX-Zeitformaten.
*/
E 5
extern struct timeval *translate_datetime();
I 5
extern struct in_addr inet_addr();
extern char *ctime();
E 5


/*
D 5
  Uebersetzungsteile.
E 5
I 5
  Unterschiede zwischen UNIX und VAX/VMS: Hilfsprogramme
E 5
*/
#ifdef vms
I 5
/*
  Eintragen des Benutzernamens und der TCP/IP-Adresse des Notificationhosts in die
  RPC-Struktur. Als Folge der Benutzung von 'getUNIXuser' koennen nur solche Benutzer
  den QMan verwenden, die in der UCX PROXY-Liste fuer das NFS eingetragen sind. Das
  ist notwendig, da der QMan fuer die GEN-Queue die UNIX-Benutzerkennung des VAX/VMS-
  Benutzers kennen muss.
*/
E 5
static makeuser(sub,user)
submit *sub;
char *user;
{
 static char lname[64],hname[64];
 struct ProxyEntry *me;
 char ch,*sc;

D 5
 /* Unter wem soll der Job laufen */
E 5
I 5
 /* Eventuell den eigenen Benutzernamen ermitteln */
E 5
 if ( !*user && !getmyname(user) ) return 0;
D 5
 /* Umwandeln in Grossschreibung */
E 5
I 5
 /* Umwandeln in Grossschreibung zum suchen */
E 5
 for ( sc = user ; ch = *sc++ ; )
  if ( (ch >= 'a') && (ch <= 'z') )
   sc[-1] += 'A'-'a';
D 5
 /* Benuzter suchen */
E 5
I 5
 /* Benuzter ind der NFS PROXY-Datei suchen suchen */
E 5
 if ( !(me = getUNIXuser(user,host)) ) return 0;
D 5
 /* Informationen uebertragen */
E 5
I 5
 /* Benutzerkennung uebertragen */
E 5
 sub->Jinfo.uid = me->uid;
 sub->Jinfo.gid = me->gid;
D 5
 /* Wo kommt die Antwort hin */
E 5
I 5
 /* Notificationhost ueber einen logischen Namen ermitteln. Ist der logischen Name */
 /* nicht definiert, so wird der lokale Host verwendet.				   */
E 5
 if ( !makelogical("BOSSQUEUE$NOTIFY",hname,sizeof(hname)) ) gethostname(hname,sizeof(hname));
D 5
 /* Namen uebertragen */
E 5
I 5
 /* Benutzernamein den Buffer kopieren */
E 5
 memmove(lname,me->user,sizeof(me->user));
 lname[sizeof(me->user)] = '\0';
D 5
 /* Informationen einsetzen */
 sub->Qinfo.host = hname;
E 5
I 5
 /* Informationen in die RPC-Struktur einsetzen */
E 5
 sub->Qinfo.user = lname;
D 5
 /* Fertig */
E 5
I 5
 sub->Qinfo.host = IPaddr(hname);
 /* Erfolg melden */
E 5
 return 1;
}

D 5
static getusername(ubuf,uid,gid,host)
char *ubuf,*host;
E 5
I 5
/*
  Diese Routine uebernimmt die Umsetzung von UNIX-Benutzerkennungen in VAX/VMS-Benutzernamen.
  Sollte der Benutzer nicht in der UCX NFS PROXY-Datei definiert sein, wird ein Leerstring
  zureuckgegeben. Die Routine wird vor allem in den SHOW-Befehlen verwendet.
*/
static getusername(ubuf,uid,gid,hname)
char *ubuf,*hname;
E 5
int uid,gid;
{
 struct ProxyEntry *usr;

D 5
 if ( usr = getVMSuser(gid,uid,host) ) 
E 5
I 5
 /* Benutzer in der PROXY-Datei suchen */
 if ( usr = getVMSuser(gid,uid,hname) ) 
E 5
  {
I 5
   /* Und in den bereitgestellten Buffer kopieren */
E 5
   memmove(ubuf,usr->user,sizeof(usr->user));
   ubuf[sizeof(usr->user)] = '\0';
  }
 else
I 5
  /* Falls Benutzer nicht bekannt, Leerstring liefern */
E 5
  *ubuf = '\0';
}

D 5
static makeauth()
E 5
I 5
/*
  Da die GEN-Queue eine UNIX-Authorisierung mit den ihr bekannten Benutzerkennung erwartet,
  muss zum Anhaengen der Authorisierungsstruktur unter VAX/VMS erst die Umsetzung in die
  UNIX-Identifier ueber die PROXY-Datei erfolgen.
*/
static makeauth(gen)
CLIENT *gen;
E 5
{
 static char lname[32],hname[32];
 struct ProxyEntry *me;
 short len;

D 5
 /* Eigenen Namen ermitteln */
E 5
I 5
 /* Eigenen Benuzternamen ermitteln */
E 5
 if ( !getmyname(lname) ) return;
D 5
 /* Eigene Maschine ermitteln */
E 5
I 5
 /* Name der lokalen Maschine ermitteln */
E 5
 gethostname(hname,sizeof(hname));
D 5
 /* Umsetzen */
E 5
I 5
 /* Aktuellen Benutzer umsetzen */
E 5
 if ( !(me = getUNIXuser(lname,host)) ) return;
 /* UNIX-Authorisierung fuer den Handle aufsetzen */
 auth_destroy(gen->cl_auth);
 gen->cl_auth = authunix_create(hname,me->uid,me->gid,0,0);
}

I 5
/*
  Ermitteln des eigenen Benutzernamens unter VAX/VMS.
*/
E 5
static getmyname(name)
char *name;
{
 struct item_list_3 jpi[2];
 short len;

D 5
 /* Eigenen Namen ermitteln */
E 5
I 5
 /* Systemaufruf zum Abfragen der Prozessinformationen */
E 5
 jpi[0].blen = 12;
 jpi[0].code = JPI$_USERNAME;
 jpi[0].addr = name;
 jpi[0].rlen = &len;
 jpi[1].blen = jpi[1].code = 0;
 if ( !(sys$getjpiw(0,0,0,jpi,0,0,0)&1) ) return 0;
D 5
 /* Sauber abschliessen */
E 5
I 5
 /* Name ins C-Format konvertieren, dabei Leerzeichen am rechten Ende eleminieren */
E 5
 while ( len && (name[len-1] == ' ') ) len--;
 name[len] = '\0';
D 5
 /* Hat geklappt */
E 5
I 5
 /* Erfolg melden */
E 5
 return 1;
}
I 21

/*
  Motif Schnittstelle (noch ???) nicht unterstuetzt.
*/
static Xqueue(argc,argv)
int argc;
char **argv;
{
 /* Das gibt es nicht */
 f77printf("Motif/X11 interface not supported under VAX/VMS");
 f77printf(" ");
}
I 22

D 25
m77_puts(mess,len)
char *mess;
E 25
I 25
m77_puts(msg,len)
char *msg;
E 25
int len;
{
 /* Das geht nie */
 return;
}

E 22
E 21
#else
I 5
/*
  Eintragen des Benutzernamens und der TCP/IP-Adresse des Notificationhosts in die
  RPC-Struktur. Die UNIX-Version der Routine geht davon aus, dass die Benutzerkennungen
  auf der lokalen Maschine mit denen auf dem Rechner, der die GEN-Queue abarbeitet
  uebereinstimmen.
*/
E 5
static makeuser(sub,user)
submit *sub;
char *user;
{
 static char lname[64],hname[64];
 struct passwd *me;
 char ch,*sc;

D 5
 /* Unter wem soll der Job laufen */
E 5
I 5
 /* Falls keine /USER-Option angegeben ist, laeuft der Job unter dem aktuellen Benutzer */
E 5
 if ( !*user )
  {
   sub->Jinfo.uid = getuid();
   sub->Jinfo.gid = getgid();
  }
 else
  {
D 5
   /* Umwandeln in Kleinschreibung */
E 5
I 5
   /* Ansonsten muss der Benuzter in der passwd-Datei validiert werden */
   /* - Umwandeln des Namens in Kleinbuchstaben zum suchen */
E 5
   for ( sc = user ; ch = *sc++ ; )
    if ( (ch >= 'A') && (ch <= 'Z') )
     sc[-1] += 'a'-'A';
D 5
   /* Benuzter suchen */
E 5
I 5
   /* - Benuzter validieren */
E 5
   if ( !(me = getpwnam(user)) ) return 0;
D 5
   /* Informationen uebertragen */
E 5
I 5
   /* - Benutzerkennungen uebertragen */
E 5
   sub->Jinfo.uid = me->pw_uid;
   sub->Jinfo.gid = me->pw_gid;
  }
D 5
 /* Wer bin ich */
E 5
I 5
 /* Name des lokalen Rechners ermitteln, der auch als Notificationserver dienen muss */
E 5
 gethostname(hname,sizeof(hname));
I 5
 /* Echten Benutzernamen fuer den Notificationserver ermitteln */
E 5
 if ( me = getpwuid(sub->Jinfo.uid) )
  strncpy(lname,me->pw_name,sizeof(lname)-1);
 else
  *lname = '\0';
D 5
 /* Informationen einsetzen */
 sub->Qinfo.host = hname;
E 5
I 5
 /* RPC-Strukturelemente fuellen */
 sub->Qinfo.host = IPaddr(hname);
E 5
 sub->Qinfo.user = lname;
D 5
 /* Fertig */
E 5
I 5
 /* Erfolg melden */
E 5
 return 1;
}

D 5
static getusername(ubuf,uid,gid,host)
char *ubuf,*host;
E 5
I 5
/*
I 15
  Eigenen Namen ermitteln.
*/
static getmyname(name)
char *name;
{
 struct passwd *me;

 /* Benutzer suchen */
 if ( !(me = getpwuid(getuid())) ) return 0;
 /* Name kopieren */
 strcpy(name,me->pw_name);
 /* Erfolg melden */
 return 1;
}

/*
E 15
  Umsetzen einer Benuzterkennung in einen Benutzernamen ueber die passwd-Datei. Man beachte,
  dass fuer UNIX ausschliesslich die Benutzerkennung 'uid' fuer diese Umsetzung verwendet
  wird. Ist der Benutzer nicht bekannt, so meldet die Routine dies mit einem Leerstring.
*/
static getusername(ubuf,uid,gid,hname)
char *ubuf,*hname;
E 5
int uid,gid;
{
 struct passwd *usr;

I 5
 /* Benuzter in der Datei suchen */
E 5
 if ( usr = getpwuid(uid) )
I 5
  /* Name uebermitteln */
E 5
  strcpy(ubuf,usr->pw_name);
 else
I 5
  /* Unbekannte Benutzer liefern einen Leerstring */
E 5
  *ubuf = '\0';
}

D 5
static makeauth()
{
 /* UNIX-Authorisierung fuer den Handle aufsetzen */
 auth_destroy(gen->cl_auth);
 gen->cl_auth = authunix_create_default();
}

E 5
I 5
/*
  Dummyroutine fuer UNIX, mit der es dem CLD-Teil 'queparse.f' gestattet wird, unter
  VAX/VMS einen Exceptionhandler zu installieren.
*/
E 5
lib$establish_(rout)
int (*rout)();
{
I 22
 static int eqm_quitalways();

E 22
I 15
 /* Exithanddler fuer Interrupts installieren */
D 22
 signal(SIGINT,eqm_quit);
E 22
I 22
 signal(SIGINT,eqm_quitalways);
E 22
E 15
I 5
 /* Erfolg melden */
E 5
 return SS$_NORMAL;
}
I 22

static int eqm_quitalways()
{
 /* Das muss immer gehen */
 MotifRunning = 0;
 return eqm_quit();
}

/*
  FORTRAN Motif Schnittstelle.
*/
m77_puts(msg,mlen)
char *msg;
int *mlen;
{
 static char out[1024];

 /* Umkopieren */
 memmove(out,msg,*mlen);
 out[*mlen] = '\0';
 /* Ausgeben */
 mprintf("%s",out);
}
E 22
#endif

D 5
static makefile(fname,def,res,rlen)
char *fname,*def,*res;
int rlen;
{
 int len1,len2;

 /* Name umwandeln */
 if ( !(fname = translate_vms_default(fname,def)) || (fname == (char *)-1) ) return 0;
#ifndef vms
 /* Arbeitsdirectory suchen, falls noetig */
 if ( *fname == '/' )
#endif
  *res = '\0';
#ifndef vms
 else if ( !getwd(res) )
  return 0;
#endif
 /* Laengen ermitteln */
 len1 = strlen(res);
 len2 = strlen(fname);
#ifdef vms
 if ( len2 && (fname[len2-1] == ';') ) fname[--len2] = '\0';
#else
 if ( len1 && (res[len1-1] != '/') ) res[len1++] = '/';
#endif
 /* Konsistenztest */
 if ( (len1+len2+1) > rlen ) return 0;
 /* Ergebnis zusammenstellen und Erfolg melden */
 strcpy(res+len1,fname);
 return 1;
}

static makelogical(lstr,buf,bsize)
char *lstr,*buf;
int bsize;
{
 /* Leerstrings beachten */
 if ( !lstr )
  {
   *buf = '\0';
   return 1;
  }
 /* Logischen Name umwandeln */
 if ( !(lstr = translate_vms(lstr)) || (lstr == (char *)-1) || (strlen(lstr) >= bsize) )
  return 0;
 /* Kopieren und Erfolg melden */
 strcpy(buf,lstr);
 return 1;
}

E 5
I 5
/*
  Umsetzen einer Zeitangabe im VAX/VMS-Datetime-Format in Sekunden seit dem 1. Januar 1970
  fuer die Nutzung unter UNIX. Dazu wird die BOSSLIB-Routine 'translate_datetime' verwendet,
  die unter VAX und UNIX zur Verfuegung steht.
*/
E 5
static maketime(tstr,secs)
char *tstr;
long *secs;
{
 struct timeval *tv;

D 5
 /* Defaultwert ermitteln */
E 5
I 5
 /* Keine Zeitangabe liefert eine 0*/
E 5
 *secs = 0;
 if ( !tstr ) return 1;
D 5
 /* Text umwandeln */
E 5
I 5
 /* Texteingabe in ein (Sekunden,Mikrosekunden)-Paar umrechnen */
E 5
 if ( !(tv = translate_datetime(tstr)) ) return 0;
D 5
 /* Uhrzeit auslesen */
E 5
I 5
 /* Nach Rundung der Mikrosekunden die Sekunden auslesen */
E 5
 *secs = tv->tv_sec;
 if ( tv->tv_usec >= 500000 ) (*secs)++;
I 5
 /* Erfolg melden */
E 5
 return 1;
}

I 5
/*
  Umkopieren eines Parameters oder Qualifiers in einen Buffer. Fehlende Parameter werden
  ueber die Angabe eines Nullstrings in einen Leerstring umgesetzt, bei allen anderen
  Eingaben erfolgt ein Test auf die Groesse des Buffers.
*/
E 5
static makename(nstr,buf,bsize)
char *nstr,*buf;
int bsize;
{
D 5
 /* Leerstrings bearbeiten */
E 5
I 5
 /* Kein Eingabeparameter fuehrt zu einem Leersting */
E 5
 if ( !nstr )
  *buf = '\0';
I 5
 /* Die Eingabe darf nicht laenger sein als der Buffer gross ist */
E 5
 else if ( strlen(nstr) >= bsize )
  return 0;
I 5
 /* Zeichenkette kopieren */
E 5
 else
  strcpy(buf,nstr);
D 5
 /* Ergebnis melden */
E 5
I 5
 /* Erfolg melden */
E 5
 return 1;
}

I 5
/*
  /OUTPUT Qualifier auswerten und eventuell Datei oeffnen. Ein /NOOUTPUT fuehrt zum Oeffnen
  des globalen Filedescriptors 'outf' auf das Nulldevice. Ansonsten wird bei expliziter
  Angabe eines Dateinamens 'outf' auf diese Datei geoeffnet.
*/
static makeoutput(out)
char *out;
{
 static char fbuf[256];

 /* Ausgabe auf 'stdout' schalten */
 outf = -1;
 /* Wurde der Qualifier explizit angegeben */
 if ( out )
  {
   /* /NOOUTPUT bearbeiten */
   if ( out == (char *)-1 )
    strcpy(fbuf,NULLDEVICE);
   /* /OUTPUT=FILE bearbeiten, Defaultsuffix ist .LIS */
   else if ( !makefile(out,".lis",fbuf,sizeof(fbuf)) )
    return 0;
   /* Datei oeffnen und Fehler melden */
   if ( (outf = creat(fbuf,0744)) == -1 ) return 0;
  }
#ifdef vms
 /* Eventuell Leerzeile vorweg ausgeben */
 f77printf(" ");
#endif
 /* Erfolg melden */
 return 1;
}

/*
  Unter UNIX ist die folgende Routine Dummy, unter VAX/VMS wird sie als Exceptionhandler
  installiert und verhindert, dass die CLD-Library bei Syntaxfehlern Warnungen mit
  Tracebacks ausgibt.
*/
E 5
queueECPT(sig,mech)
int *sig,*mech;
{
#ifdef vms
I 5
 /* Ignorieren Exceptions der CLD-Library */
E 5
 return ((sig[1]&0x0fff0000) == 0x00030000) ? SS$_CONTINUE : SS$_RESIGNAL;
#endif
}

I 5
/*
  RPC-Handle fuer die GEN-Queue erzeugen, falls noetig. Dabei wird die globale Variable
  'gen' verwendet.
*/
E 5
static createHandle()
{
I 5
 /* Gibt es den Handle schon, dann nichts unternehmen */
 if ( gen ) return 1;
E 5
 /* Handle erzeugen */
D 5
 if ( !gen && !(gen = clnt_create(host,GENPROG,GENVERS,"tcp")) ) return 0;
 /* Handle initialisieren */
 makeauth();
E 5
I 5
 if ( !(gen = clnt_create(host,GENPROG,GENVERS,"tcp")) ) return 0;
 /* Authorisierungsstruktur des Handles initialisieren */
 makeauth(gen);
E 5
 /* Erfolg melden */
 return 1;
}

I 5
/*
  Kennung fuer naechten Befehl ermitteln. Um Uebertragungsprobleme und doppelte Ausfuehrungen
  von Befehlen in den Griff zu bekommen, benoetigt jede Anfrage an die GEN-Queue ein absolut
  eideutige Kennung. Diese kann nur von der GEN-Queue selbst vergeben werden.
*/
E 5
static ID newconnection(msg)
char *msg;
{
 static char oldhost[sizeof(host)] = "";
 static ID one = 1;
 ID *uID = &one;

D 5
 /* Nur neuen Handle falls neuer Host */
E 5
I 5
 /* Nur dann einen neuen Handle erzeugen, falls neuer Host fuer die GEN-Queue angegeben ist */
E 5
 if ( strcmp(oldhost,host) )
  {
D 5
   /* Host vermerken */
E 5
I 5
   /* Neuen Host vermerken */
E 5
   strcpy(oldhost,host);
D 5
   /* RPC-Handle zerstoeren falls existent */ 
E 5
I 5
   /* RPC-Handle zerstoeren, falls existent */ 
E 5
   if ( gen )
    {
     clnt_destroy(gen);
     gen = 0;
    }
  }
 /* Eindeutige Kennung ermitteln */
 while ( msg )
D 2
  if ( !(uID = (ID *)action(msg,genuniqueid_2,(void *)0)) )
E 2
I 2
D 5
  if ( !(uID = (ID *)action(msg,genuniqueid_3,(void *)0)) )
E 5
I 5
  /* - GEN-Queue Interfaceroutine aufrufen */
  if ( !(uID = (ID *)action(msg,genuniqueid_1,(void *)0)) )
E 5
E 2
   {
I 5
    /* Uebertragungsfehler melden */
E 5
    sprintf(msg,"could not contact Queuemanager on host '%s'",host);
    return 0;
   }
I 5
  /* - Die Kennung 0 darf im QMan niemals verwendet werden */
E 5
  else if ( *uID )
   msg = 0;
D 5
 /* Ergebnis melden */
E 5
I 5
 /* Erfolg melden */
E 5
 return *uID;
}

I 5
/*
  RPC-Befehl an die GEN-Queue ausfuehren. Diese Interfaceroutine erleichtert die
  Benutzung von RPC erheblich, da sie alle notwendigen Aufgaben vom Erzeugen des
  Handles ueber ein automatisches Retry bis zur Befehlsausfuehrung uebernimmt.
*/
E 5
static char *action(msg,func,in)
char *msg,*(*func)(),*in;
{
 int retry = 4,zero = 0;
 char *res;

D 5
 /* Mehrmals versuchen */
E 5
I 5
 /* Bis zu vier mal probieren */
E 5
 while ( retry-- )
  {
   /* Handle ermitteln */
   if ( !createHandle() ) break;
D 5
   /* Befehl durchfuehren */
E 5
I 5
   /* Befehl durchfuehren und Erfolg melden */
E 5
   if ( res = (*func)(in,gen) ) return res;
D 5
   /* Handle zerstoeren */
E 5
I 5
   /* Bei Fehlern Handle zerstoeren und eventuell erneut probieren */
E 5
   clnt_destroy(gen);
   gen = 0;
  }
D 5
 /* Misserfolg melden */
E 5
I 5
 /* Misserfolg nach der vorgegebenen Anzahl von Retries melden */
E 5
 sprintf(msg,"lost connection to Queuemanger '%s'\n",host);
 return 0;
}

I 5
/*
  RPC-Handle fuer eine EXEC-Queue erzeugen, EXEC-Queue ansprechen und 
  Ergebnis liefern. Diese Routine entsricht in etwa 'action' fuer die
  GEN-Queue, nur wird der RPC-Handle jedesmal explizit neu erzeugt.
  Das ist sinnvoll, da der QMan im allgemeinen keine feste Verbindung
  zu den EXEC-Queues benoetigt.
*/
execdo(addr,code,inp,in,outp,out)
long addr;
int code;
xdrproc_t inp,outp;
char *in,*out;
{
D 13
 static struct timeval total = { 20,0 };
E 13
I 13
D 23
 static struct timeval total = { 20, 0 },wait = { 10, 0 };
E 23
I 23
 static struct timeval total = { 5, 0 },wait = { 5, 0 };
E 23
E 13
 struct sockaddr_in rem;
 int sock,res;
 CLIENT *cl;

 /* Adresse des Partners aufsetzen */
 rem.sin_family = AF_INET;
 rem.sin_addr.s_addr = addr;
 rem.sin_port = htons(0);
 /* TCP/IP-Handle erzeugen */
 sock = RPC_ANYSOCK;
D 13
 if ( !(cl = clnttcp_create(&rem,eprog,evers,&sock,0,0)) ) return 0;
E 13
I 13
 if ( !(cl = clntudp_create(&rem,eprog,evers,wait,&sock)) ) return 0;
E 13
 /* Authorisierungsstruktur aufsetzen */
 makeauth(cl);
 /* Befehl ausfuehren */
 res = (clnt_call(cl,code,inp,in,outp,out,total) == RPC_SUCCESS);
 /* Handle vernichten */
 clnt_destroy(cl);
 /* Ergebnis melden */
 return res;
}

/*
  TCP/IP-Adresse aus einem Hostnamen ermitteln. Sollte der Host nicht gefunden werden
  und handelt es sich nicht um eine direkt angegebene IP-Adresse, so wird die Adresse
  des lokalen Hosts uebergeben. Diese Routine wird nur benoetigt um die TCP/IP-Adresse
  des Notificationservers zu ermitteln.
*/
static long IPaddr(name)
char *name;
{
 struct sockaddr_in me;
 struct hostent *hent;
 long tmp;

 /* Host suchen */
 if ( hent = gethostbyname(name) )
  {
   /* TCP/IP-Adresse im Hostformat melden */
   memmove(&tmp,hent->h_addr,hent->h_length);
   return ntohl(tmp);
  }
 /* Vielleicht ist es eine richtige Adresse */
 me.sin_addr = inet_addr(name);
 /* Falls nicht, Adresse des lokalen Hosts uebernehmen */
 if ( me.sin_addr.s_addr == INADDR_NULL ) get_myaddress(&me);
 /* Ergebnis im Hostformat */
 return ntohl(me.sin_addr.s_addr);
}

/*
  Umwandeln einer TCP/IP-Adresse im binaeren Hostformat in den Namen eines
  TCP/IP-Knotens. Ist der Name nicht ermittelbar und auch nicht in eine
  direkte Nummer umzusetzen, so liefert diese Routine NOSTR.
*/
static char *IPname(addr)
long addr;
{
 struct hostent *hent;

 /* Umwandeln ins Netzwerkformat */
 addr = htonl(addr);
 /* Name suchen und bei Erfolg Adresse melden */
 if ( hent = gethostbyaddr(&addr,sizeof(addr),AF_INET) ) return hent->h_name;
 /* Name in eine direkte Nummer umwandeln */
 return INET_NTOA(addr);
}

/*
  Vergleich einer EXEC-Queue mit einem Namens- oder Adresspattern. Der
  Vergleich wird in drei Stufen durchgefuehrt:
  a) passt das Pattern auf den Namen der EXEC-Queue
  b) passt das Pattern auf den lokalen Namen der EXEC-Queue
  c) passt das Pattern auf die TCP/IP-Adresse der EXEC-Queue
*/
static match_exec(exe,patt)
execctrl *exe;
char *patt;
{
 long addr = ntohl(exe->status.IPaddr);

 /* Vergleichen in der angegebenen Reihenfolge */
 return (match_wildcard(exe->status.name,patt) ||
         match_wildcard(IPname(addr),patt) ||
         match_wildcard(INET_NTOA(exe->status.IPaddr),patt));
}

/*
I 8
  Vergelich eines Benutzernamens mit einem Pattern. Dabei wird beruecksichtigt, dass
  der /USER-Qualifier 'patt' unter Umstaenden nicht explizit angegeben ist.
*/
static match_user(usr,patt)
char *usr,*patt;
{
 return (!patt || (patt == (char *)-1) || match_wildcard(usr,patt));
}

/*
E 8
  C-Ausgabe mit dem FORTRAN Hauptprogramm synchronisieren. Siehe die Bemerkungen in
  der Routine 'f77_print' in 'queparse.f'.
*/
E 5
static f77printf(va_alist)
va_dcl
{
 static char line[1024];
 va_list args;
 char *fmt;
 int len;
 
 /* Bearbeitung der variablen Liste starten */
 va_start(args);
 /* Format einlesen */
 fmt = va_arg(args,char *);
 /* Zeichenkette zusammensetzen */
 vsprintf(line,fmt,args);
 /* Bearbeitung der variablen Liste beenden */
 va_end(args);
 /* Laenge ermitteln */
 len = strlen(line);
D 5
 if ( outf < 0 )
  /* Ergebnis rausschreiben und Benutzung von FORTRAN */
E 5
I 5
 if ( outf == -1 )
  /* Ergebnis auf 'stdout' herausschreiben und Benutzung von FORTRAN */
E 5
  f77_print(line,&len);
 else
  {
   /* Ergebnis in eine Datei schreiben */
   line[len++] = '\n';
I 5
   /* Eventuelle Signalhandler beachten */
E 5
   while ( (write(outf,line,len) == -1) && (errno == EINTR) );
  }
 /* Ausgabe vermerken */
 outdone = 1;
}

/*
D 5
  Suche eine bestimmte EXEC-Queue in einer Liste.
E 5
I 5
  Suche eine bestimmte EXEC-Queue in einer Liste. Neben ihrer Nummer traegt jede
  Queueinformation in einer 'masterctrl'-Struktur eine weitere eindeutige Kennung,
  die hier zur Suche verwendet wird. Tatsaechlich ist diese Kennung die Zeiger-
  adresse der jeweiligen Queuestruktur in der GEN-Queue. Die vorliegenden Routinen
  dienen in 'fillinfo' zur Restauration der Rueckwaertszeiger in den 'jobctrl'-
  Strukturen.
E 5
*/
static struct execctrl *findexec(exe,addr)
execctrl *exe;
int addr;
{
I 5
 /* Alle EXEC-Queues der angegebenen Liste durchgehen */
E 5
 for ( ; exe && (exe->execaddr != addr) ; exe = exe->next );
I 5
 /* Ergebnis melden */
E 5
 return exe;
}

/*
D 5
  Suche eine bestimme GEN-Queue in einer Liste.
E 5
I 5
  Suche eine bestimme GEN-Queue in einer Liste. Ansonsten arbeitet diese Routine
  genau wie 'findexec'.
E 5
*/
static struct genctrl *findgen(gen,addr)
genctrl *gen;
int addr;
{
I 5
 /* Alle angegeben GEN-Queues durchsuchen */
E 5
 for ( ; gen && (gen->genaddr != addr) ; gen = gen->next );
I 5
 /* Ergebnis melden */
E 5
 return gen;
}

/*
D 8
  LOGOUT
  QUIT
  EXIT

E 8
  Verlassen des QUEMAN-Programms.
*/
eqm_quit()
D 5
{
E 5
I 5
{ 
 /* Erfolg in einem fuer die jeweilige Maschine korrekten Format melden */
I 22
 if ( MotifRunning )
  {
   f77printf("You mush finish Motif/X11 session before leaving");
   f77printf(" ");
   return;
  }
E 22
E 5
 exit(NOERROR);
}

/*
I 8
  SCCS Versionsnummer des QMan ausgeben.
*/
eqm_version()
{
 f77printf("VMS/UNIX QueueManager Version %I% by Jochen Manns (%E% %U%)");
I 9
 f77printf(" ");
E 9
}

/*
E 8
D 5
  Starten oder Aendern eines Jobs in der auf der mit HOST(BOSSBATCH$HOST) laufenden
  GEN-Queue.
E 5
I 5
  Starten oder Aendern eines Jobs. Fuer Befehle wie SET ENTRY wird eine Maske
  aufgestellt, die alle vom Benutzer explizit angegebenen Qualifier durch je
  ein Bit kennzeichnet.
E 5
*/ 
eqm_submit(args,msg,sub)
struct QMsubmit *args;
char *msg;
int *sub;
{
D 5
 static char jbuf[256],lbuf[256],cbuf[64],nbuf[128],ubuf[64],rbuf[64];
E 5
I 5
 static char jbuf[256],lbuf[256],cbuf[64],nbuf[128],ubuf[64],rbuf[64],pbuf[64];
I 23
 char *suff = NOSTR,*nptr;
E 23
E 5
 submit genctrl;
D 23
 char *jp0,*jp1;
E 23
 long secs = 0;
 int mask = 0;
 text *mptr;

D 5
 /* Qualifier RMS_FILE mit maschinenabhaengigem Default versehen */
E 5
I 5
 /* Qualifier RMS_FILE mit maschinenabhaengigem Default versehen. Der Default ist */
 /* unter VAX/VMS /RMS_FILE, unter UNIX /NORMS_FILE. 				  */
E 5
 if ( args->rmsfile >= 0 )
  mask |= ufRMSFILE;
 else
#ifdef vms
D 20
  args->rmsfile = 1;
E 20
I 20
  args->rmsfile = RMS_RMSFILE;
E 20
#else
  args->rmsfile = 0;
#endif
I 23
 /* Name des Kommandointerpreters umsetzen */
 if ( !makename(args->cliptr,cbuf,sizeof(cbuf)) ) return 3;
 /* - Defaultendung */
 if ( *cbuf ) 
  {
   /* -- Aus dem Namen des Interpreters ermitteln */
   *(suff = pbuf) = '.';
   if ( !strcmp(cbuf,"DCL") )
    strcpy(suff+1,"COM");
   else
    strcpy(suff+1,cbuf);
  }
E 23
D 5
 /* Scriptdatei umwandeln */
E 5
I 5
 /* Bearbeiten der Kommandodatei */
 /* - Keine Datei angegeben: das geht natuerlich nicht bei SUBMIT */
E 5
 if ( !args->jobptr )
  jbuf[0] = '\0';
I 5
 /* - Dateiname unter Nutzung logischer Namen umsetzen */
E 5
D 23
 else if ( !makefile(args->jobptr,NOSTR,jbuf,sizeof(jbuf)) )
E 23
I 23
 else if ( !makefile(args->jobptr,suff,jbuf,sizeof(jbuf)) )
E 23
  return 1;
D 5
 /* Logdatei umwandeln */
E 5
I 5
D 17
 /* Logdatei bearbeiten */
 /* - /NOLOG_FILE verhindert das Erzeugen einer Datei */
E 5
 if ( args->logptr == (char *)-1 )
  {
   lbuf[0] = '\0';
   mask |= ufLOGFILE;
  }
I 5
 /* - /LOG_FILE=FILE fuehrt zu einer Umsetzung des Dateinames mit Defaultsuffix .LOG */
E 5
 else if ( args->logptr )
  if ( !makefile(args->logptr,".log",lbuf,sizeof(lbuf)) )
   return 2;
  else
   mask |= ufLOGFILE;
I 5
 /* - /LOG_FILE ohne Parameter */
E 5
 else if ( !args->jobptr )
  lbuf[0] = '\0';
 else
  {
I 5
   /* -- Logdatei setzt sich aus dem Namen der Kommandodatei mit Suffix .LOG zusammen */
E 5
   strcpy(lbuf,".log");
   if ( !makefile(lbuf,args->jobptr,lbuf,sizeof(lbuf)) ) return 2;
  }
E 17
D 5
 /* Logische Namen umsetzen */
E 5
I 5
 /* Name der Druckerqueue bearbeiten */
 /* - Maskenparameter setzen, da eventuell Defaultwerte veraendert werden */
 if ( args->keep ) mask |= ufDELLOG;
 if ( args->printer ) mask |= ufPRINT;
 /* - /NOPRINTER bearbeiten */
 if ( (args->prtptr == (char *)-1) )
  {
   /* -- Fuer /NOPRINTER ist /KEEP der Default */
   pbuf[0] = '\0';
   if ( !args->keep ) args->keep = 1;
  }
 /* - Logischen Namen umsetzen */
 else if ( !makelogical(args->prtptr,pbuf,sizeof(pbuf)) )
  return 11;
 /* - Fuer /PRINTER[=STRING] ist /NOKEEP der Default */
 else if ( !args->keep )
  args->keep = -1;
 /* Logische Namen des GEN-Hosts und der Queuenamen umsetzen */
E 5
 newhost(args->hostptr,8);
 newqueue(args->queueptr,4);
D 5
 if ( !makelogical(args->cliptr,cbuf,sizeof(cbuf)) ) return 3;
E 5
 if ( !makelogical(args->requeueptr,rbuf,sizeof(rbuf)) ) return 10;
D 5
 /* Uhrzeit ermitteln */
E 5
I 5
 /* Uhrzeit vom VAX/VMS-Format in Sekunden seit dem 1.Januar 1970 fuer UNIX umrechnen */
E 5
 if ( !maketime(args->timeptr,&secs) ) return 5;
D 5
 /* Jobname umsetzen */
E 5
I 5
D 23
 /* Name des Kommandointerpreters umsetzen */
 if ( !makename(args->cliptr,cbuf,sizeof(cbuf)) ) return 3;
E 23
 /* Jobname ermitteln */
 /* - Falls /NAME=STRING angegeben ist, diesen Namen uebernehmen */
E 5
 if ( args->nameptr )
  if ( !makename(args->nameptr,nbuf,sizeof(nbuf)) )
   return 6;
  else
   mask |= ufNAME;
I 5
 /* - Falls keine Kommandodatei angegeben ist, auch keinen Namen setzen */
E 5
D 23
 else if ( !args->jobptr )
E 23
I 23
 /* - sonst Jobname aus dem Namen der auszufuehrenden Datei ermitteln   */
 else if ( !args->jobptr || !(nptr = fileToName(jbuf)) )
E 23
  nbuf[0] = '\0';
 else
  {
D 5
   /* Aus dem Namen der auszufuehrenden Datei ermitteln */
E 5
I 5
D 23
   /* - Jobname aus dem Namen der auszufuehrenden Datei ermitteln */
   /* -- Ende der Directoryspezifikation suchen */
E 5
   jp0 = jbuf+strlen(jbuf);
D 5
   while ( jp0-- > jbuf )
    if ( (*jp0 == ':') || (*jp0 == ']') || (*jp0 == '/') )
     break;
E 5
I 5
   while ( (jp0-- > jbuf) && (*jp0 != ':') && (*jp0 != ']') && (*jp0 != '/') );
   /* -- Anfang des Dateisuffix suchen und den eigentlichen Namen in Grossbuchstaben */
   /*    umsetzen und in den Buffer fuer den Jobnamen kopieren.			     */
E 5
   for ( jp1 = nbuf ; *++jp0 && (*jp0 != '.') && (*jp0 != ';') ; )
    if ( (*jp0 >= 'a') && (*jp0 <= 'z') )
     *jp1++ = *jp0+'A'-'a';
    else
     *jp1++ = *jp0;
I 5
   /* -- C-String abschliessen */
E 5
   *jp1++ = '\0';
E 23
I 23
   /* -- Ergebnis uebernehmen */
   strcpy(nbuf,nptr);
   free(nptr);
E 23
I 17
  }
 /* Logdatei bearbeiten */
 /* - /NOLOG_FILE verhindert das Erzeugen einer Datei */
 if ( args->logptr == (char *)-1 )
  {
   lbuf[0] = '\0';
   mask |= ufLOGFILE;
  }
 /* - /LOG_FILE=FILE fuehrt zu einer Umsetzung des Dateinames mit Defaultsuffix .LOG */
 else if ( args->logptr )
  if ( !makefile(args->logptr,".log",lbuf,sizeof(lbuf)) )
   return 2;
  else
   mask |= ufLOGFILE;
 /* - /LOG_FILE ohne Parameter */
 else if ( !args->jobptr )
  lbuf[0] = '\0';
 else
  {
   /* -- Logdatei setzt sich aus dem Namen des Jobs und Suffix .LOG zusammen */
   strcpy(lbuf,nbuf);
   strcat(lbuf,".log");
   if ( !makefile(lbuf,args->jobptr,lbuf,sizeof(lbuf)) ) return 2;
E 17
  }
D 5
 /* Generelle Namen umsetzen */
E 5
I 5
 /* Benutzername in einen Buffer kopieren */
E 5
 if ( !makename(args->userptr,ubuf,sizeof(ubuf)) ) return 7;
 /* Maske vervollstaendigen */
D 14
 if ( args->timeptr ) mask |= ufAFTER;
 if ( args->cliptr ) mask |= ufCLI;
 if ( args->cpu != -1 ) mask |= ufCPUTIME;
 if ( args->hold ) mask |= ufHOLD;
 if ( args->notify ) mask |= ufNOTIFY;
 if ( args->nparptr >= 0 ) mask |= ufPARAMETERS;
 if ( args->prio != -1 ) mask |= ufPRIORITY;
 if ( args->requeueptr ) mask |= ufREQUEUE;
 if ( args->restart ) mask |= ufRESTART;
 if ( args->stacksize != -1 ) mask |= ufSTACK;
 if ( args->datasize != -1 ) mask |= ufDATA;
 if ( args->memorysize != -1 ) mask |= ufMEMORY;
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
E 5
I 5
 if ( args->delete ) mask |= ufDELCOM;
 if ( args->printer ) mask |= ufPRINT;
E 14
I 14
 if ( args->suspend == 1 )
  mask = ufSUSPEND;
 else if ( args->suspend == -1 )
  mask = ufRESUME;
 else
  {
   if ( args->timeptr ) mask |= ufAFTER;
   if ( args->cliptr ) mask |= ufCLI;
   if ( args->cpu != -1 ) mask |= ufCPUTIME;
   if ( args->hold ) mask |= ufHOLD;
   if ( args->notify ) mask |= ufNOTIFY;
   if ( args->nparptr >= 0 ) mask |= ufPARAMETERS;
   if ( args->prio != -1 ) mask |= ufPRIORITY;
   if ( args->requeueptr ) mask |= ufREQUEUE;
   if ( args->restart ) mask |= ufRESTART;
   if ( args->stacksize != -1 ) mask |= ufSTACK;
   if ( args->datasize != -1 ) mask |= ufDATA;
   if ( args->memorysize != -1 ) mask |= ufMEMORY;
   if ( args->delete ) mask |= ufDELCOM;
   if ( args->printer ) mask |= ufPRINT;
  }
E 14
 /* Verbindung mit dem Queuemanager aufnehmen und eindeutige Kennung erfragen */
E 5
 if ( !(genctrl.Qinfo.requestID = newconnection(msg)) ) return 9;
D 5
 /* Allgemeine Struktureintraege fuellen */
E 5
I 5
 /* Allgemeine RPC-Struktureintraege fuellen */
E 5
 genctrl.Qinfo.queue = qbuf;
 genctrl.Qinfo.requeue = rbuf;
 genctrl.name = nbuf;
 genctrl.restart = (args->restart == 1) ? 1 : 0;
 genctrl.hold = args->hold;
 genctrl.at = secs;
I 5
 genctrl.leader = 0;
 genctrl.hosts.hints_len = 0;
 genctrl.hosts.hints_val = 0;
 genctrl.nopend = 0;
E 5
 genctrl.Jinfo.requestID = args->entry;
 genctrl.Jinfo.nice = args->prio;
 genctrl.Jinfo.cpu = args->cpu;
 genctrl.Jinfo.data = args->datasize;
 genctrl.Jinfo.stack = args->stacksize;
 genctrl.Jinfo.memory = args->memorysize;
D 20
 genctrl.Jinfo.rmsfile = args->rmsfile;
E 20
I 20
 genctrl.Jinfo.rmsfile = args->rmsfile ? RMS_RMSFILE : 0;
E 20
 genctrl.Jinfo.shell = cbuf;
 genctrl.Jinfo.script = jbuf;
 genctrl.Jinfo.param.param_len = (args->nparptr >= 0) ? args->nparptr : 0;
 genctrl.Jinfo.param.param_val = args->parptr;
 genctrl.Jinfo.log = lbuf;
I 5
 genctrl.Jinfo.kind = skNORMAL;
 genctrl.Jinfo.delcom = (args->delete == 1) ? 1 : 0;
 genctrl.Jinfo.dellog = (args->keep == -1) ? 1 : 0;
 genctrl.Jinfo.print = pbuf;
E 5
 /* Benutzerrelevante Informationen fuellen */
 if ( !makeuser(&genctrl,ubuf) ) return 7;
I 5
 /* /NONOTIFY bearbeiten */
E 5
D 19
 if ( args->notify < 0 ) *genctrl.Qinfo.user = '\0';
E 19
I 19
 if ( args->notify <= 0 ) *genctrl.Qinfo.user = '\0';
E 19
 /* Befehlsart aufsetzen */
 if ( *sub == 1 )
I 5
  /* SUBMIT */
E 5
  genctrl.Kind = sSUBMIT;
 else
  {
I 5
   /* SET ENTRY, STOP/ENTRY */
E 5
   genctrl.Kind = !*sub ? sMODIFY : sSTOP;
   genctrl.uflags = mask;
  }
D 5
 /* Befehl ausfuehren */
D 2
 if ( !(mptr = (text *)action(msg,genjobaction_2,&genctrl)) ) return 9;
E 2
I 2
 if ( !(mptr = (text *)action(msg,genjobaction_3,&genctrl)) ) return 9;
E 2
 /* Daten kopieren und Speicher freigeben */
E 5
I 5
 /* Befehl ausfuehren und Misserfolg melden */
 if ( !(mptr = (text *)action(msg,genjobaction_1,&genctrl)) ) return 9;
 /* Antworststring kopieren und Speicher freigeben */
E 5
 strcpy(msg,*mptr);
 free(*mptr);
I 5
 /* Misserfolg melden */
E 5
 if ( !*msg ) return 0;
D 5
 /* Jobnummer ermitteln */
E 5
I 5
 /* Jobnummer fuer spaeteres SYNCHRONIZE ermitteln */
E 5
 if ( !*sub || memcmp("Job ",msg,4) || ((args->entry = atoi(msg+4)) <= 0) )
  args->entry = -1;
D 5
 /* Fehler melden */
E 5
I 5
 /* Ergebnis melden */
E 5
D 18
 return 9;
E 18
I 18
 return ((args->identify != -1) || memcmp("Job ",msg,4)) ? 9 : 0;
E 18
}

/*
D 5
  Entfernen eines Jobs aus einer Queue.
E 5
I 5
  Entfernen eines Jobs aus einer Queue. Die einzige wesentliche Information ist
  hier die Jobnummer.
E 5
*/ 
eqm_kill(args,msg)
struct QMsubmit *args;
char *msg;
{
 submit genctrl;
 text *mptr;

D 5
 /* Logische Namen umsetzen */
E 5
I 5
 /* Logische Namen fuer den GEN-Host und die Queue umsetzen */
E 5
 newhost(args->hostptr,2);
 newqueue(args->queueptr,1);
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
E 5
I 5
 /* Verbindung mit dem Queuemanager aufnehmen und eindeutige Kennung erfragen */
E 5
 if ( !(genctrl.Qinfo.requestID = newconnection(msg)) ) return 3;
 /* Allgemeine Struktureintraege fuellen */
I 5
 genctrl.Qinfo.user = genctrl.Qinfo.requeue = genctrl.name = "";
 genctrl.Qinfo.host = INADDR_ANY;
 genctrl.hosts.hints_len = 0;
 genctrl.hosts.hints_val = 0;
E 5
 genctrl.Qinfo.queue = qbuf;
D 5
 genctrl.Qinfo.host = genctrl.Qinfo.user = genctrl.Qinfo.requeue = genctrl.name = "";
E 5
 genctrl.Kind = sCANCEL;
D 5
 /* Jobnummer uebertragen */
E 5
I 5
 /* Relevante Jobnummer uebertragen */
E 5
 genctrl.Kinfo.requestID = args->entry;
D 5
 /* Befehl ausfuehren */
D 2
 if ( !(mptr = (text *)action(msg,genjobaction_2,&genctrl)) ) return 3;
E 2
I 2
 if ( !(mptr = (text *)action(msg,genjobaction_3,&genctrl)) ) return 3;
E 2
 /* Daten kopieren und Speicher freigeben */
E 5
I 5
 /* Befehl ausfuehren und Misserfolg melden */
 if ( !(mptr = (text *)action(msg,genjobaction_1,&genctrl)) ) return 3;
 /* Antwortstring kopieren und Speicher freigeben */
E 5
 strcpy(msg,*mptr);
 free(*mptr);
D 5
 if ( !*msg ) return 0;
 /* Fehler melden */
 return 3;
E 5
I 5
 /* Ergebnis melden */
 return (!*msg ? 0 : 3);
E 5
}

/*
D 5
  Anzeigen der informationen von Jobs und Queues.
E 5
I 5
  Anzeigen der informationen von Jobs und Queues. Die folgende Routine wird sowohl
  von SHOW QUEUE als auch von SHOW ENTRY verwendet, obwohl die Aufgaben der Befehle
  etwas unterschiedlich sind.
E 5
*/
eqm_show_queue(args,msg)
struct QMshow *args;
char *msg;
{
D 5
 static char nbuf[256],fbuf[256];
 static masterctrl *info = 0;
E 5
I 5
D 15
 static char nbuf[256];
E 15
I 15
 static char nbuf[256],ubuf[32];
E 15
E 5
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;

D 5
 /* Speicher unbedingt wieder freigeben */
 if ( args->firstcall && info )
  {
   xdr_free(xdr_masterctrl,info); 
   info = 0;
  }
 /* Logische Namen umsetzen */
 newhost(args->hostptr,2);
E 5
I 5
 /* Logischen Name fuer die Queue umsetzen, falls er kein Wildcardpattern enthaelt */
E 5
 if ( args->summary == -1 )
  strcpy(qbuf,"*");
 else if ( strchr(args->queueptr,'*') || strchr(args->queueptr,'%') ||
	   !makelogical(args->queueptr,qbuf,sizeof(qbuf)) )
  strcpy(qbuf,args->queueptr);
I 15
 /* Default fuer Benutzername ermitteln */
 if ( (!args->userptr || !(args->byjob&128)) && getmyname(ubuf) ) args->userptr = ubuf;
E 15
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
 if ( !newconnection(msg) ) return 1;
 /* Befehl ausfuehren */
 if ( args->firstcall )
E 5
I 5
 /* Alle Informationen der GEN-Queue auslesen und Misserfolg melden */
 switch (fillinfo(args->hostptr,args->firstcall,msg))
E 5
  {
D 2
   if ( !(info = (masterctrl *)action(msg,geninfo_2,(void *)0)) ) return 1;
E 2
I 2
D 5
   if ( !(info = (masterctrl *)action(msg,geninfo_3,(void *)0)) ) return 1;
E 2
   /* Informationen vervollstaendigen */
E 5
I 5
   case FILL_NOHOST : return 2;
   case FILL_NOINFO : return 1;
  }
 /* Ausgabedateinamen umsetzen und Misserfolg melden */
 if ( !makeoutput(args->outputptr) ) return 3;
 /* Alle GEN-Queues absuchen */
 for ( outdone = 0, needheader = 1, gen = info->gens ; gen ; gen = gen->next )
  {
   /* GEN-Queue mit dem Suchpattern vergleichen und eventuell bearbeiten */
D 23
   if ( match_wildcard(gen->name,qbuf) ) showgen(gen,info->name,args);
E 23
I 23
D 24
   if ( match_wildcard(gen->name,qbuf) && args->generic ) showgen(gen,info->name,args);
E 24
I 24
   if ( args->generic && match_wildcard(gen->name,qbuf) ) showgen(gen,info->name,args);
E 24
E 23
   /* Alle EXEC-Queues absuchen */
   if ( !args->generic )
    for ( exe = info->execs ; exe ; exe = exe->next )
     /* Vollen Namen der spezifischen Queue errechnen */
     if ( strlen(gen->name)+1+strlen(exe->status.name)+1 < sizeof(nbuf) )
      {
       /* - Name zusammensetzen */
       strcpy(nbuf,gen->name);
       strcat(nbuf,"_");
       strcat(nbuf,exe->status.name);
       /* - EXEC-Queue bearbeiten, falls das Suchpattern passt */
       if ( match_wildcard(nbuf,qbuf) ) showexec(gen,exe,info->name,args);
      }
  }
#ifndef vms
 /* Eventuell Leerzeile anschliessen */
 if ( outdone ) f77printf(" ");
#endif
 /* Ausgabedatei schliessen */
 close(outf);
 outf = -1;
 /* Erfolg oder Misserfolg melden */
 if ( outdone ) return 0;
 sprintf(msg,"no such %s '%s'\n",(args->summary >= 0) ? "queue" : "entry",args->queueptr);
 return 1;
}

/*
  Informationsblock der GEN-Queue auslesen und nicht uebertragene Rueckwaertszeiger
  der Jobkontrollstrukturen korrekt zuordnen. Dazu wird zuerst ein etwaiger Speicher
  aus vergangenen Zugriffen freigegeben und dann die Verbindung mit der GEN-Queue
  validiert. Man beachte, dass eine GEN-Queue im gestoppten Zustand zwar alle Infor-
  mationen liefert, diese aber nicht ausgegeben werden.
*/
static fillinfo(hostptr,first,msg)
char *hostptr,*msg;
int first;
{
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;
 
 /* Logischen Name des GEN-Hosts umsetzen */
 newhost(hostptr,FILL_NOHOST);
 /* Speicher vorheriger Aufrufe unbedingt wieder freigeben */
 if ( first && info )
  {
   xdr_free(xdr_masterctrl,info); 
   info = 0;
  }
 /* Verbindung zum Queuemanager verifizieren */
 if ( !newconnection(msg) ) return FILL_NOINFO;
 /* Aktionen nur beim ersten Aufruf durchfuehren */
 if ( first )
  {
   /* Informationen anfordern und Misserfolg melden */
   if ( !(info = (masterctrl *)action(msg,geninfo_1,(void *)0)) ) return FILL_NOINFO;
   /* Informationen auch der Rueckwaertszeiger vervollstaendigen */
E 5
   for ( gen = info->gens ; gen ; gen = gen->next )
    {
I 5
     /* - Wartende Jobs durchgehen */
E 5
     for ( job = gen->Pjobs ; job ; job = job->next )
      {
       job->jexec = findexec(info->execs,job->Jexec.execptr_u.hptr);
       job->jgen = findgen(info->gens,job->Jgen.genptr_u.hptr);
      }
I 5
     /* - Laufende Jobs durchgehen */
E 5
     for ( job = gen->Rjobs ; job ; job = job->next )
      {
       job->jexec = findexec(info->execs,job->Jexec.execptr_u.hptr);
       job->jgen = findgen(info->gens,job->Jgen.genptr_u.hptr);
      }
    }
I 5
   /* - In den RPC-Warteschlangen stehende Jobs durchgehen */
E 5
   for ( exe = info->execs ; exe ; exe = exe->next )
    {
     for ( job = exe->Ejobs ; job ; job = job->next )
      {
       job->jexec = findexec(info->execs,job->Jexec.execptr_u.hptr);
       job->jgen = findgen(info->gens,job->Jgen.genptr_u.hptr);
      }
D 5
     /* IPaddr wird eventuell ueber RPC/XDR geswappt, darf aber nicht */
E 5
I 5
     /* TCP/IP-Adresse ins Netzwerkformat fuer 'inet_ntoa' umwandeln */
E 5
     exe->status.IPaddr = htonl(exe->status.IPaddr);
    }
I 5
   /* Informationen ueber die EXEC-Queues fuer 'execdo' uebernehmen */
   eprog = info->EXECprog;
   evers = info->EXECvers;
E 5
  }
 /* Nachsehen, ob der Manager gestoppt ist */
 if ( info->stopped )
  {
I 5
   /* Fehler melden */
E 5
   strcpy(msg,"Queue manager is stopped");
D 5
   return 1;
E 5
I 5
   return FILL_NOINFO;
E 5
  }
D 5
 /* Dateinamen umsetzen */
 if ( args->outputptr )
  {
   /* /NOOUTPUT und /OUTPUT=filename unterscheiden */
   if ( args->outputptr == (char *)-1 )
    strcpy(fbuf,NULLDEVICE);
   else if ( !makefile(args->outputptr,".lis",fbuf,sizeof(fbuf)) )
    return 3;
   /* Datei oeffnen */
   outf = creat(fbuf,0755);
  }
#ifdef vms
 /* Eventuell Leerzeile vorweg */
 f77printf(" ");
#endif
 /* Alle GEN-Queues absuchen */
 for ( outdone = 0, needheader = 1, gen = info->gens ; gen ; gen = gen->next )
  {
   /* GEN-Queue bearbeiten */
   if ( match_wildcard(gen->name,qbuf) ) showgen(gen,info->name,args);
   /* Alle EXEC-Queues absuchen */
   if ( !args->generic )
    for ( exe = info->execs ; exe ; exe = exe->next )
     if ( strlen(gen->name)+1+strlen(exe->status.name)+1 < sizeof(nbuf) )
      {
       strcpy(nbuf,gen->name);
       strcat(nbuf,"_");
       strcat(nbuf,exe->status.name);
       if ( match_wildcard(nbuf,qbuf) ) showexec(gen,exe,info->name,args);
      }
  }
#ifndef vms
 /* Eventuell Leerzeile anschliessen */
 if ( outdone ) f77printf(" ");
#endif
 /* Ausgabedatei schliessen */
 close(outf);
 outf = -1;
 /* Erfolg oder Misserfolg melden */
 if ( outdone ) return 0;
 sprintf(msg,"no such %s '%s'\n",(args->summary >= 0) ? "queue" : "entry",args->queueptr);
 return 1;
E 5
I 5
 /* Erfolg melden */
 return 0;
E 5
}

/* 
  Ausgabe aller Informationen ueber eine GEN-Queue und den ihr zugeordneten
  Jobs. Zuerst werden (fuer SHOW QUEUE) die Informationen, die die Queue
  selbst betreffen ausgegeben. Danach folgt die Liste aller Jobs bzw. eine
  Zusammenfassung (SHOW QUEUE/SUMMARY).
*/
static showgen(gen,name,args)
genctrl *gen;
char *name;
struct QMshow *args;
D 24
{
 int total[4];
E 24
I 24
{ 
 execctrl *exe;
E 24
 jobctrl *job;
I 24
 int total[4];
E 24
 char *state;

D 5
 /* Nur bei SHOW QUEUE alles ausgeben */
E 5
I 5
 /* Nur bei SHOW QUEUE wirklich alles ausgeben */
E 5
 if ( args->summary >= 0 )
  {
D 5
   /* Zustand ermitteln */
E 5
I 5
   /* - Zustand ermitteln */
E 5
   switch (gen->state)
    {
     case qNORMAL  : state = ""; break;
     case qSTOPPED : state = " stopped"; break;
     default       : state = " stalled"; break;
    }
D 5
   /* Kopfzeile ausgeben */
E 5
I 5
   /* - Kopfzeile ausgeben */
E 5
   f77printf("Generic batch queue %s%s",gen->name,state);
D 5
   /* Volle Information ausgeben, falls gewuenscht */
E 5
I 5
   /* - Volle Information ausgeben, falls gewuenscht */
E 5
   if ( args->mode == -1 )
    {
I 5
     /* -- Name des Rechners, auf dem die GEN-Queue laeuft. Das ist der Name, den diese */
     /*    Maschine sich selbst gibt.							*/
E 5
     f77printf("\t/HOST=%s",name);
I 5
     /* -- Queueparameter */
E 5
     f77printf("\t/BASE_PRIORITY=%d",gen->prio);
     showval(gen->cpu,"CPUMAXIMUM");
     f77printf("\t/ALGORITHM=%d",gen->algo);
     if ( gen->jobs != INT_MAX ) f77printf("\t/JOB_LIMIT=%d",gen->jobs);
     if ( gen->faults != INT_MAX ) f77printf("\t/FAULT_LIMIT=%d",gen->faults);
     f77printf("\t/MIN_IDLE=%d",gen->minidle);
     showval(gen->stack.max,"STACK_MAXIMUM");
     showval(gen->stack.def,"STACK_DEFAULT");
     showval(gen->data.max,"DATA_MAXIMUM");
     showval(gen->data.def,"DATA_DEFAULT");
     showval(gen->mem.max,"MEMORY_MAXIMUM");
     showval(gen->mem.def,"MEMORY_DEFAULT");
I 5
     if ( *gen->pdl ) f77printf("\t/PARALLELSHELL=%s",gen->pdl);
E 5
    }
D 5
   /* Kopfzeile beenden */
E 5
I 5
   /* - Kopfzeile beenden */
E 5
   f77printf(" ");
  }
D 5
 /* Kopfzeile nur bei Bedarf ausgeben */
E 5
I 5
 /* Kopfzeile der Jobs nur bei Bedarf ausgeben */
E 5
 if ( args->summary >= 0 ) needheader = 1;
D 5
 /* Zusammenfassung vorbereiten */
E 5
I 5
 /* Zusammenfassung vorbereiten, indem die Zaehler geloescht werden */
E 5
 memset(total,0,sizeof(total));
D 5
 /* Felder durchgehen */
E 5
I 5
D 24
 /* Alle Jobs dieser GEN-Queueu durchgehen */
E 24
I 24
 /* Alle Jobs dieser GEN-Queue durchgehen */
E 24
E 5
 for ( job = gen->Rjobs ; job ; job = job->next ) showjob(job,args,total,name);
 for ( job = gen->Pjobs ; job ; job = job->next ) showjob(job,args,total,name);
I 24
 for ( exe = info->execs ; exe ; exe = exe->next )
  for ( job = exe->Ejobs ; job ; job = job->next ) 
   if ( job->jgen == gen ) 
    showjob(job,args,total,name);
E 24
D 5
 /* Abschluss ausgeben */
E 5
I 5
 /* Abschlusszeile ausgeben */
E 5
 if ( args->summary > 0 )
  showsummary(total);
 else if ( !args->summary && !needheader )
  f77printf(" ");
}

/*
  Ausgabe aller Informationen zu einem Job. Nachdem der Job auf die Auswahl ueber
  den BY_JOB_STATUS Qualifier ueberprueft ist, werden alle Informationen in den
  diversen lokalen Zeichenketten gesammelt und dann ausgegeben.
*/
static showjob(job,args,total,hname)
jobctrl *job;
struct QMshow *args;
int *total;
char *hname;
{
 static char jbuf[128],nbuf[128],ubuf[32],smode[64],ts[64];
D 5
 int n,adder,jmode;
E 5
I 5
 static char *hkind[] = { "PRIMARY", "INPUT", "OUTPUT" };
D 12
 int n,adder,jmode,act,off;
E 12
I 12
 int n,adder,jmode,act,off,done;
I 15
 jobctrl *pjob;
 execctrl *exe;
 genctrl *gen;
E 15
E 12
 char *hnam;
E 5

 /* Nur echte Jobs beruecksichtigen */
D 24
 if ( job->request.Kind != sSUBMIT ) return;
E 24
I 24
 if ( (job->request.Kind != sSUBMIT) || !matchGeneric(job,args) ) return;
E 24
I 10
 /* /NOPARALLEL bearbeiten */
 if ( !args->parallel && job->request.leader ) return;
E 10
 /* Zustand des Jobs ermitteln */
 if ( job->state == jNORMAL )
  if ( job->pid > 0 )
   {
I 5
    /* - Laeuft auf einer EXEC-Queue */
E 5
    adder = 1;
    sprintf(smode,"executing on %s",job->jexec->status.name);
   }
  else
   {
I 5
    /* - Wartet in einer EXEC- oder einer GEN-Queue */
E 5
    adder = 0;
    strcpy(smode,"pending");
   }
I 5
 else if ( job->state == jPENDINGABORT )
  {
   /* - Wird demnaechst eleminiert */
   adder = 1;
   strcpy(smode,"aborting");
  }
E 5
 else if ( job->state == jPENDING )
  if ( job->request.hold == 1 )
   {
I 5
    /* - Bedinungslos angehalten */
E 5
    adder = 2;
    strcpy(smode,"holding");
   }
  else if ( !job->request.hold && job->request.at )
   {
I 5
    /* - Startet spaeter einmal bei einer festgesetzen Uhrzeit */
E 5
    adder = 2;
    sprintf(smode,"holding until %s",ctime(&job->request.at));
    smode[strlen(smode)-1] = '\0';
   }
  else
   {
I 5
    /* - Wartet in einer normalen Warteschlange */
E 5
    adder = 0;
    if ( job->jexec )
     sprintf(smode,"pending on %s",job->jexec->status.name);
    else
     strcpy(smode,"pending");
   }
 else
  {
I 5
   /* - Befindet sich in einem Zwischenzustand */
E 5
   adder = 1;
   if ( *job->genReq.requeue )
    strcpy(smode,"restarting");
   else
    strcpy(smode,"aborting");
  }
I 5
 /* Maske fuer den vergleich mit /BY_JOB_STATUS ermitteln */
E 5
 jmode = 1<<adder;
D 5
 if ( (job->request.hold == -1) && job->request.at ) jmode |= 8;
E 5
I 5
 if ( (job->request.hold == -1) && job->request.at ) jmode |= 8; 
 /* Nur ausgewaehle Jobs weiter beruecksichtigen */
E 5
 if ( !(jmode&args->byjob) ) return;
 /* SHOW ENTRY bearbeiten */
 if ( args->summary == -1 )
  {
D 5
   /* Jobnummer in einen Text umsetzen und vergleichen */
E 5
I 5
   /* - Jobnummer in einen Text umsetzen und mit Pattern vergleichen */
E 5
   sprintf(jbuf,"%d",job->jobID);
I 5
   /* - Soll NICHT ausgegeben werden */
E 5
   if ( !match_wildcard(jbuf,args->queueptr) ) return;
  }
 /* Informationen der Kopfzeile zusammenstellen */
I 5
 /* - Fehler initialisieren */
E 5
 memset(jbuf,' ',sizeof(jbuf));
 memset(ubuf,' ',sizeof(ubuf));
 memset(nbuf,' ',sizeof(nbuf));
 /* - Benutzer, an den die NOTIFY Nachricht geht */
D 5
 if ( *job->genReq.user )
  sprintf(nbuf,"%s@%s",job->genReq.user,job->genReq.host);
E 5
I 5
 if ( *job->genReq.user && (hnam = IPname(job->genReq.host)) )
  sprintf(nbuf,"%s@%s",job->genReq.user,hnam);
E 5
 else
  nbuf[0] = '\0';
 /* - Name des Jobs */
 strcpy(jbuf,job->request.name);
 /* - Benuzter, zu dem der Job gehoert */
 getusername(ubuf,job->execReq.uid,job->execReq.gid,hname);
D 5
 /* /USER Qualifier beachten */
E 5
I 5
 /* /USER Qualifier beachten, d.h. Benuztername mit dem Pattern vergleichen */
E 5
D 8
 if ( (args->summary == -1) && args->userptr && (args->userptr != (char *)-1) )
  if ( !match_wildcard(ubuf,args->userptr) )
   return;
E 8
I 8
D 15
 if ( (args->summary == -1) && !match_user(ubuf,args->userptr) ) return;
E 15
I 15
 if ( !match_user(ubuf,args->userptr) ) return;
E 15
E 8
 /* Parameter auf die Laengen der Ausgabefelder trimmen */
 jbuf[strlen(jbuf)] = nbuf[strlen(nbuf)] = ubuf[strlen(ubuf)] = ' ';
 jbuf[16] = ubuf[12] = nbuf[20] = '\0';
 /* Nur Zusammenfassung ermitteln */
 if ( args->summary > 0 )
  {
I 5
   /* Lediglich die Zaehler korrigieren */
E 5
   total[adder]++;
   return;
  }
 /* Ueberschrift nur ein einziges Mal ausgeben */
 if ( needheader )
  {
   f77printf("  Jobname         Username      Entry  Notify              Status");
   f77printf("  -------         --------      -----  ------              ------");
   needheader = 0;
  }
 /* Kopfzeile des Jobs ausgeben */
 f77printf("  %s%s%7d  %s%s",jbuf,ubuf,job->jobID,nbuf,smode);
 /* Erweiterte Informationen ausgeben */
 if ( args->mode )
  {
I 5
   /* - /FULL und /FILES unterscheiden */
E 5
   if ( args->mode == -1 )
    {
D 5
     /* Zeit der Uebertragung des Auftrags */
E 5
I 5
     /* -- Zeit der Uebertragung des Auftrags */
E 5
     strcpy(ts,ctime(&job->submit));
     ts[strlen(ts)-1] = '\0';
     f77printf("\t/SUBMITTED=%s",ts);
D 5
     /* Zeit des Starts in einer EXEC-Queue */
     if ( job->state != jPENDING )
E 5
I 5
     /* -- Laufende Jobs */
     if ( job->pid > 0 )
E 5
      {
I 5
       /* --- Zeit des Starts in einer EXEC-Queue */
E 5
       strcpy(ts,ctime(&job->dispatch));
       ts[strlen(ts)-1] = '\0';
       f77printf("\t/STARTED=%s",ts);
I 5
       /* -- Prozesskennung in der EXEC-Queue */
       f77printf("\t/PROCESS_ID=%d",job->pid);
E 5
      }
D 5
     /* Prozesskennung in der EXEC-Queue */
     if ( job->pid > 0 ) f77printf("\t/PROCESS_ID=%d",job->pid);
I 2
     /* Art des Jobs */
E 5
I 5
     /* -- Art des Jobs */
E 5
D 15
     if ( job->execReq.kind == skPARALLEL )
      f77printf("\t/PARALLEL_PROCESS");
D 3
     else if ( job->execReq.kind == skFILTER )
      f77printf("\t/PARALLEL_FILTER");
E 3
I 3
     else if ( job->execReq.kind == skCONVERTER )
      f77printf("\t/PARALLEL_CONVERTER");
E 15
I 15
     if ( job->leader )
      f77printf("\t/PARALLEL_IDENTIFIER=%d",job->leader);
E 15
E 3
E 2
D 5
     /* Requeuename */
E 5
I 5
     else if ( job->request.leader )
D 15
      f77printf("\t/PARALLEL");
E 15
I 15
      {
       if ( job->execReq.kind == skPARALLEL )
        f77printf("\t/PARALLEL_PROGRAM");
       else if ( job->execReq.kind == skCONVERTER )
        f77printf("\t/PARALLEL_CONVERTER");
       else
        f77printf("\t/PARALLEL_PROCESS");
       /* Parallelkontrolljob suchen */
       for ( pjob = 0, gen = info->gens ; !pjob && gen ; gen = gen->next )
	{
	 for ( pjob = gen->Rjobs ; pjob ; pjob = pjob->next )
	  if ( pjob->leader == job->request.leader )
	   break;
	 if ( !pjob )
	  for ( pjob = gen->Pjobs ; pjob ; pjob = pjob->next )
	   if ( pjob->leader == job->request.leader )
	    break;
	}
       for ( exe = info->execs ; !pjob && exe ; exe = exe->next )
	for ( pjob = exe->Ejobs ; pjob ; pjob = pjob->next )
	 if ( pjob->leader == job->request.leader )
	  break;
       /* Informationen ausgeben */
       if ( pjob ) f77printf("\t/PARALLEL_CONTROL_JOB=%d",pjob->jobID);
      }
E 15
     /* -- Liste der Hinweise in Paralleljobs */
     if ( job->request.hosts.hints_len )
      {
       /* --- Pseudoqualifier */
       f77printf("\t/HINTS=(");
       /* --- Alle Hinweise durchgehen */
D 12
       for ( act = n = 0 ; n < job->request.hosts.hints_len ; n++ )
E 12
I 12
       for ( act = n = done = 0 ; n < job->request.hosts.hints_len ; n++ )
E 12
	/* ---- Trennung zwischen PRIMARY, INPUT und OUTPUT beachten */
	if ( job->request.hosts.hints_val[n] != IPnone )
	 {
	  /* ---- Nur ausgeben, wenn der Name ermittelt werden kann */
	  if ( hnam = IPname(job->request.hosts.hints_val[n]) )
D 12
	   f77printf(n ? "\t\t%s %s," : "\t\t%s %s)",hkind[act],hnam); 
E 12
I 12
	   f77printf("\t\t%s %s,",hkind[act],hnam); 
E 12
	 }
        /* ---- Naechste Art von Hinweisen */
	else if ( act != (sizeof(hkind)/sizeof(hkind[0])) )
	 act++;
I 12
       /* --- Abschliessen */
       f77printf("\t\tEND_OF_HINTS)");
E 12
      }
     /* -- Requeuename */
E 5
     if ( *job->genReq.requeue ) f77printf("\t/REQUEUE=%s",job->genReq.requeue);
D 5
     /* Generelle Jobparameter */
E 5
I 5
     /* -- Generelle Jobparameter */
E 5
     f77printf("\t/PRIORITY=%d",job->execReq.nice);
     showval(job->execReq.cpu,"CPULIMIT");
     showval(job->execReq.data,"DATASIZE");
     showval(job->execReq.stack,"STACKSIZE");
     showval(job->execReq.memory,"MEMORYSIZE");
     if ( job->request.restart ) f77printf("\t/RESTART");
D 5
     /* VAX/VMS RMS Datei */
E 5
I 5
     if ( job->execReq.delcom ) f77printf("\t/DELETE");
     /* -- /NOPRINTER gesondert behandeln */
     if ( *job->execReq.print )
      {
       f77printf("\t/PRINTER=%s",job->execReq.print);
       if ( !job->execReq.dellog ) f77printf("\t/KEEP");
      }
     else if ( job->execReq.dellog )
      f77printf("\t/NOKEEP");
     /* -- VAX/VMS RMS Datei */
E 5
D 20
     if ( job->execReq.rmsfile ) f77printf("\t/RMS_FILE");
E 20
I 20
     if ( job->execReq.rmsfile&RMS_RMSFILE ) f77printf("\t/RMS_FILE");
E 20
D 5
     /* Commandline Interpreter */
     f77printf("\t/CLI=%s",job->execReq.shell);
     /* Alle Parameter zu diesem Job */
     if ( n = job->execReq.param.param_len )
E 5
I 5
     /* -- Name des Komanndointerpreters */
     if ( job->leader )
E 5
      {
I 5
       /* --- Parallelcontrolljob, erster Parameter ist intern */
       off = 1;
       f77printf("\t/PARALLELSHELL=%s",job->execReq.shell);
      }
     else
      {
       /* --- Normaler Job */
D 16
       off = 0;
E 16
       f77printf("\t/CLI=%s",job->execReq.shell);
I 16
       /* --- Parallelkonverter */
       if ( job->execReq.kind == skCONVERTER )
	off = 2;
       /* --- Parallelprogramm */
       else if ( job->execReq.kind == skPARALLEL )
	off = 1;
       /* --- Normales Programm */
       else
        off = 0;
E 16
      }
     /* -- Alle Parameter zu diesem Job */
     if ( (n = job->execReq.param.param_len-off) > 0 )
      {
       /* --- Qualifier */
E 5
D 16
       f77printf("\t/PARAMETER=(");
E 16
I 16
       f77printf("\t/PARAMETERS=(");
E 16
I 5
       /* --- Alle Parameter ausgeben */
E 5
       while ( n-- )
	f77printf(n ? "\t\t\t\"%s\"," : "\t\t\t\"%s\")",
		  job->execReq.param.param_val[job->execReq.param.param_len-1-n]);
      }
D 5
     /* Die Logdatei */
E 5
I 5
     /* --- Logdatei ausgeben, /NOLOF_FILE beachten */
E 5
     if ( *job->execReq.log ) f77printf("\t/LOG_FILE=%s",job->execReq.log);
    }
D 5
   /* Zuletzt der Name der auszufuehrenden Datei */
E 5
I 5
   /* - Zuletzt der Name der auszufuehrenden Datei */
E 5
   f77printf("\tFile: %s",job->execReq.script);
  }
 /* Queueinformationen bei SHOW ENTRY ausgeben */
 if ( args->summary == -1 )
  if ( job->jexec )
   f77printf("\tOn queue %s_%s",job->jgen->name,job->jexec->status.name);
  else
   f77printf("\tOn generic queue %s",job->jgen->name);
}  

/*
  Ausgabe eines Wertes mit der Umsetzung -1 -> UNLIMITED(INFINITE).
*/
static showval(val,msg)
int val;
char *msg;
{
I 5
 /* Einfach vergleichen */
E 5
 if ( val == -1 )
  f77printf("\t/%s=UNLIMITED",msg);
 else
  f77printf("\t/%s=%d",msg,val);
}

/*
D 5
  Zusammenfassung der Jobs in einer Queue ausgeben.
E 5
I 5
  Zusammenfassung der Jobs in einer Queue ausgeben. Dabei werden im wesentlichen die
  einzelnen Zaehler ausgegeben.
E 5
*/
static showsummary(total)
int *total;
{
 static char *state[] = { "pend", "execut", "hold", "abort" };
 int n;

D 5
 /* Ueberhaupt keine Jobs */
E 5
I 5
 /* Ueberhaupt keine Jobs gefunden */
E 5
 if ( !total[0] && !total[1] && !total[2] && !total[3] )
  f77printf("\tNo jobs found");
 else
I 5
  /* Zaehler ausgeben */
E 5
  for ( n = 0 ; n < sizeof(state)/sizeof(state[0]) ; n++ )
   if ( total[n] )
    f77printf("\t%d job(s) %sing",total[n],state[n]);
 /* Fusszeile ausgeben */
 f77printf(" ");
}

/*
  Ausgabe der Informationen zu einer EXEC-Queue. Wie bei der GEN-Queue erfolgt zuerst
  die allgemeine Ausgabe und dann die Liste der laufenden Jobs.
*/
static showexec(gen,exe,name,args)
genctrl *gen;
execctrl *exe;
char *name;
struct QMshow *args;
{
 static char ts[64];
 int total[4];
 jobctrl *job;
 char *state;

 /* Nur bei SHOW QUEUE alles ausgeben */
 if ( args->summary >= 0 )
  {
D 5
   /* Zustand ermitteln */
E 5
I 5
   /* - Zustand ermitteln */
E 5
   if ( exe->retry <= 0 )
    state = " stalled";
   else
    switch (exe->state)
     {
      case qNORMAL  : state = ""; break;
      case qSTOPPED : state = " stopped"; break;
      default       : state = " stalled"; break;
     }
D 5
   /* Kopfzeile ausgeben */
E 5
I 5
   /* - Kopfzeile ausgeben */
E 5
   f77printf("Batch queue %s_%s%s, on %s",
	     gen->name,exe->status.name,state,INET_NTOA(exe->status.IPaddr));
D 5
   /* Volle Information ausgeben, falls gewuenscht */
E 5
I 5
   /* - Volle Information ausgeben, falls gewuenscht */
E 5
   if ( args->mode == -1 )
    { 
D 5
     /* Laufende Jobs */
E 5
I 5
     /* -- Laufende Jobs */
E 5
     f77printf("\t/JOB_COUNT=%d",exe->jobs);
D 5
     /* Zeitpunkt der letzten Informationsermittelung */
E 5
I 5
     /* -- Zeitpunkt der letzten Informationsermittelung */
E 5
     if ( exe->stamp )
      {
       strcpy(ts,ctime(&exe->stamp));
       ts[strlen(ts)-1] = '\0';
       f77printf("\t/COLLECTION_TIME=%s",ts);
     }
D 5
     /* Zuletzt ermittelte Informationen */
     if ( exe->status.perf != 0.0 ) f77printf("\t/PERFORMANCE_FACTOR=%f",exe->status.perf);
     f77printf("\t/LAST_IDLE_RATIO=%f",exe->status.idle);
     f77printf("\t/LAST_FAULT_FREQUENCY=%f",exe->status.faults);
I 2
     /* IP port des TCP Prozesses */
     if ( exe->status.EaterPort != -1 ) f77printf("\t/EATER_PORT=%d",exe->status.EaterPort);
     /* Prozesskennung einer TCP Performance Messung */
     if ( exe->status.trans != -1 ) f77printf("\t/TRANSFER_PID=%d",exe->status.trans);
E 5
I 5
     /* -- Zuletzt ermittelte Informationen */
     showstatus(&exe->status);
E 5
E 2
    }
I 5
   /* - Trennzeile ausgeben */
E 5
   f77printf(" ");
  }
 /* Kopfzeilen exakt einmal ausgeben */
 if ( args->summary >= 0 ) needheader = 1;
D 5
 /* Vorbereitung fuer /SUMMARY treffen */
E 5
I 5
 /* Vorbereitung fuer /SUMMARY treffen und Zaehler loeschen */
E 5
 memset(total,0,sizeof(total));
 /* Alle Jobs ausgeben */
D 23
 for ( job = exe->Ejobs ; job ; job = job->next ) showjob(job,args,total,name);
E 23
I 23
 for ( job = gen->Rjobs ; job ; job = job->next )
  if ( job->jexec == exe )
   showjob(job,args,total,name);
 for ( job = gen->Pjobs ; job ; job = job->next )
  if ( job->jexec == exe )
   showjob(job,args,total,name);
 for ( job = exe->Ejobs ; job ; job = job->next ) 
  if ( job->jgen == gen )
   showjob(job,args,total,name);
E 23
D 5
 /* Fusszeile ausgeben */
E 5
I 5
 /* Fusszeile oder Zusammenfassung ausgeben */
E 5
 if ( args->summary > 0 )
  showsummary(total);
 else if ( !args->summary && !needheader )
  f77printf(" ");
}

/*
D 5
  Synchronisieren mit einem Job.
E 5
I 5
  Synchronisieren mit einem Job. Der Job kann durch Name oder Nummer spezifiziert werden.
  Die Aufgabe der Jobsuche uebernimmt die GEN-Queue selbst. SYNCHRONIZE bedeutet einfach,
  dass der Jobstatus in der GEN-Queue abgefragt wird. Dieser Vorgang wird alle fuenf
  Sekunden wiederholt, bis der Job verschwunden ist.
E 5
*/ 
eqm_synchronize(args,msg)
struct QMsynchronize *args;
char *msg;
{
 static char nbuf[256];
 syncctrl sync;
 Jstate *res;

D 5
 /* Logische Namen umsetzen */
E 5
I 5
 /* Logische Namen fuer GEN-Host und Queue umsetzen */
E 5
 newhost(args->hostptr,2);
 newqueue(args->queueptr,1);
 /* Jobname umsetzen */
 if ( !makename(args->nameptr,nbuf,sizeof(nbuf)) ) return 4;
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
E 5
I 5
 /* Verbindung mit dem Queuemanager aufnehmen und eindeutige Kennung erfragen */
E 5
 if ( !newconnection(msg) ) return 3;
D 5
 /* Allgemeine Struktureintraege fuellen */
E 5
I 5
 /* RPC-Struktureintraege fuellen */
E 5
 sync.queue = qbuf;
 sync.name = nbuf;
 sync.jID = args->entry;
D 5
 /* Befehl ausfuehren */
D 2
 if ( !(res = (Jstate *)action(msg,gensynchronize_2,&sync)) ) return 3;
E 2
I 2
 if ( !(res = (Jstate *)action(msg,gensynchronize_3,&sync)) ) return 3;
E 2
 /* Job muss existieren */
E 5
I 5
 /* Befehl ausfuehren und Misserfolg melden */
 if ( !(res = (Jstate *)action(msg,gensynchronize_1,&sync)) ) return 3;
 /* Job muss zumindest jetzt existieren */
E 5
 if ( *res == jNONE )
  {
   /* Fehler melden */
   if ( *nbuf )
    sprintf(msg,"No job '%s' found",nbuf);
   else
    sprintf(msg,"No job %d found",args->entry);
   return 3;
  }
 /* Jobende abwarten */
 while ( *res != jNONE )
  {
D 5
   /* Warten */
E 5
I 5
   /* - Nicht zu schnell aufeinander abfragen  */
E 5
   sleep(5);
D 5
   /* Nochmal probieren */
D 2
   if ( !(res = (Jstate *)action(msg,gensynchronize_2,&sync)) ) return 3;
E 2
I 2
   if ( !(res = (Jstate *)action(msg,gensynchronize_3,&sync)) ) return 3;
E 5
I 5
   /* - Jobstate abfragen und Misserfolg melden */
   if ( !(res = (Jstate *)action(msg,gensynchronize_1,&sync)) ) return 3;
E 5
E 2
  }
 /* Erfolg melden */
 return 0;
}

/*
D 5
  Beeinflussung einer Queue.
E 5
I 5
  Beeinflussung einer Queue. Alle Queuebefehle laufen ueber diesen Einsprungpunkt.
  Wie bei der SUBMIT-Gruppe wird auch hier eine Maske erstellt, die die vom Benutzer
  explizit angegebenen Qualifier und Parameter durch Bits kennzeichnet, so dass z.B.
  bei einem SET QUEUE Befehl die GEN-Queue weiss, welche der Queueparameter zu modifi-
  zieren sind.
E 5
*/
eqm_control(args,msg,mode)
struct QMcontrol *args;
char *msg;
int *mode;
{
D 5
 static char rbuf[64];
E 5
I 5
 static char rbuf[64],pbuf[64];
E 5
 control ctrl;
 text *mptr;
 char *cvt;

D 5
 /* Logische Namen umsetzen */
E 5
I 5
 /* Logische Namen fur GEN-Host und Queues umsetzen */
E 5
 newhost(args->hostptr,3);
 newqueue(args->queueptr,2);
 if ( !makelogical(args->requeueptr,rbuf,sizeof(rbuf)) ) return 4;
I 8
 /* Maske initialisieren */
 ctrl.iflags = 0;
E 8
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
E 5
I 5
 /* Verbindung mit dem Queuemanager aufnehmen und eindeutige Kennung erfragen */
E 5
 if ( !(ctrl.requestID = newconnection(msg)) ) return 1;
D 5
 /* Allgemeine Eintraege fuellen */
E 5
I 5
 /* Allgemeine Eintraege der RPC-Struktur fuellen */
E 5
 if ( *mode > 0 )
  ctrl.kind = cINIT;
 else if ( !*mode )
  ctrl.kind = cMODIFY;
 else
  ctrl.kind = cDELETE;
 ctrl.next = args->next;
 ctrl.requeue = rbuf;
 ctrl.hold = args->hold;
 ctrl.prio = args->jprio;
 ctrl.gen.next = 0;
 ctrl.gen.Pjobs = ctrl.gen.Rjobs = 0;
D 5
 /* Status und Text uebertragen */
E 5
I 5
 /* Parallelinterpreter aufsetzen */
 pbuf[0] = '\0';
 if ( args->parptr )
  {
   ctrl.iflags |= ifPDL;
   /* - /NOPARALLELSHELL bearbeiten */
   if ( args->parptr != (char *)-1 )
    /* - Bei /PARALLELSHELL=FILE Dateiname mit Default BOSS$USER:[BIN] umsetzen */
    if ( !makefile(args->parptr,"boss$usr:[bin]",pbuf,sizeof(pbuf)) )
     return 4;
  }
 ctrl.gen.pdl = pbuf;
D 8
 /* Status und Text uebertragen und Queuename in Grossschreibung umwandeln */
E 8
I 8
 /* Status und Text uebertragen */
E 8
E 5
 ctrl.gen.state = qSTOPPED;
D 8
 for ( ctrl.gen.name = cvt = qbuf ; *cvt ; cvt++ )
  if ( (*cvt >= 'a') && (*cvt <= 'z') )
   *cvt += 'A'-'a';
E 8
I 8
 ctrl.gen.name = qbuf;
E 8
D 5
 /* Queueparameter eintragen */
E 5
I 5
 /* Maske erstellen */
E 5
D 8
 ctrl.iflags = 0;
E 8
 if ( (ctrl.gen.algo = args->algo) != -1 ) ctrl.iflags |= ifALGORITHM;
 if ( (ctrl.gen.prio = args->prio) != -1 ) ctrl.iflags |= ifPRIORITY;
 if ( (ctrl.gen.cpu = args->cpu) != -1 ) ctrl.iflags |= ifCPUMAXIMUM;
 if ( (ctrl.gen.data.def = args->datadef) != -1 ) ctrl.iflags |= ifDATADEF;
 if ( (ctrl.gen.data.max = args->datamax) != -1 ) ctrl.iflags |= ifDATAMAX;
 if ( (ctrl.gen.faults = args->faults) != -1 ) ctrl.iflags |= ifFAULTLIMIT;
 if ( (ctrl.gen.jobs = args->jobs) != -1 ) ctrl.iflags |= ifJOBLIMIT;
 if ( (ctrl.gen.mem.def = args->memdef) != -1 ) ctrl.iflags |= ifMEMORYDEF;
 if ( (ctrl.gen.mem.max = args->memmax) != -1 ) ctrl.iflags |= ifMEMORYMAX;
 if ( (ctrl.gen.minidle = args->minidle) != -1 ) ctrl.iflags |= ifMINIDLE;
 if ( (ctrl.gen.stack.def = args->stackdef) != -1 ) ctrl.iflags |= ifSTACKDEF;
 if ( (ctrl.gen.stack.max = args->stackmax) != -1 ) ctrl.iflags |= ifSTACKMAX;
 if ( args->start > 0 )
  ctrl.iflags |= ifSTART;
 else if ( args->start < 0 )
  ctrl.iflags |= ifSTOP;
D 5
 /* Befehl ausfuehren */
D 2
 if ( !(mptr = (text *)action(msg,genqueueaction_2,&ctrl)) ) return 1;
E 2
I 2
 if ( !(mptr = (text *)action(msg,genqueueaction_3,&ctrl)) ) return 1;
E 2
 /* Daten kopieren und Speicher freigeben */
E 5
I 5
 /* Befehl ausfuehren und Misserfolg melden */
 if ( !(mptr = (text *)action(msg,genqueueaction_1,&ctrl)) ) return 1;
 /* Antworkstring kopieren und Speicher freigeben */
E 5
 strcpy(msg,*mptr);
 free(*mptr);
D 5
 if ( !*msg ) return 0;
E 5
 /* Ergebnis melden */
D 5
 return 1;
E 5
I 5
 return (!*msg ? 0 : 1);
E 5
}

/*
D 5
  Befehl an den Queuemanager selbst.
E 5
I 5
  Befehl an den Queuemanager selbst abschicken. Der Queuemanager, auch GEN-Queue
  genannt, kann als Ganzes gesperrt werden.
E 5
*/
eqm_manager(hostptr,code,msg)
char **hostptr,*msg;
int *code;
{
 qmCommand cmd;
 text *mptr;

D 5
 /* Logischen Namen umsetzen */
E 5
I 5
 /* Logischen Namen des GEN-Hosts umsetzen */
E 5
 newhost(*hostptr,1);
D 5
 /* Verbindung mit dem Queuemanager aufnehmen */
E 5
I 5
 /* Verbindung mit dem Queuemanager verifizieren */
E 5
 if ( !newconnection(msg) ) return 2;
 /* Kommando ermitteln */
 cmd = !*code ? qmNEWVERSION : ((*code == 1) ? qmSTART : qmSTOP);
D 5
 /* Befehl ausfuehren */
D 2
 if ( !(mptr = (text *)action(msg,genmanageraction_2,&cmd)) ) return 2;
E 2
I 2
 if ( !(mptr = (text *)action(msg,genmanageraction_3,&cmd)) ) return 2;
E 2
 /* Daten kopieren und Speicher freigeben */
E 5
I 5
 /* Befehl ausfuehren und Misserfolg melden */
 if ( !(mptr = (text *)action(msg,genmanageraction_1,&cmd)) ) return 2;
 /* Antwortstring kopieren und Speicher freigeben */
E 5
 strcpy(msg,*mptr);
 free(*mptr);
D 5
 if ( !*msg ) return 0;
 /* Fehler melden */
 return 2;
E 5
I 5
 /* Ergebnis melden */
 return (!*msg ? 0 : 2);
}

/*
  Anzeigen des aktuellen Jobzustandes. Dabei werden alle GEN-Queue Informationen
  wie in SHOW QUEUE ausgelesen, dann jedoch fuer jeden angesprochenen Job detaillierte
  Informationen von der zugehoerigen EXEC-Queue angefordert und angezeigt.
*/
eqm_show_job(args,msg)
struct QMshow *args;
char *msg;
{
I 15
 static char ubuf[32];
E 15
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;

I 15
 /* Benutzername durch Default ersetzen, falls noetig */
 if ( !args->userptr && getmyname(ubuf) ) args->userptr = ubuf;
E 15
 /* Verbindung mit dem Queuemanager aufnehmen, Informationen auslesen und Misserfolg melden */
 switch (fillinfo(args->hostptr,args->firstcall,msg))
  {
   case FILL_NOHOST : return 2;
   case FILL_NOINFO : return 1;
  }
 /* Dateinamen aus /OUTPUT umsetzen und Datei oeffnen */
 if ( !makeoutput(args->outputptr) ) return 3;
 /* Alle GEN-Queues nach dem spezifizieren Job absuchen */
 for ( outdone = 0, gen = info->gens ; gen ; gen = gen->next )
  {
   /* Liste von Jobs bearbeiten */
   sj_find(gen->Rjobs,args);
   sj_find(gen->Pjobs,args);
  }
 /* Alle EXEC-Queues absuchen nach dem spezifizierten Job absuchen */
 if ( allexecs(sj_jobs,args) ) return 0;
 /* Misserfolg melden */
 sprintf(msg,"no %s '%s' executing\n",(args->mode&1) ? "job" : "entry",args->queueptr);
 return 1;
}

/*
  Interface von 'allexecs' zu 'sj_find'.
*/
static void sj_jobs(exe,ctrl)
execctrl *exe;
struct QMshow *ctrl;
{
 /* Alle wegen RPC-Fehler wartende Jobs durchgehen */
 sj_find(exe->Ejobs,ctrl);
}
 
/*
  Job nach Name oder Nummer in einer Jobliste suchen und eventuell Informationen
  ausgeben.
*/
static sj_find(jl,ctrl)
jobctrl *jl;
struct QMshow *ctrl;
{
D 8
 static char nbuf[20];
E 8
I 8
 static char nbuf[20],ubuf[32];
E 8
 char *cmp;

 /* Name suchen */
 for ( ; jl ; jl = jl->next )
  {
   /* Suchvorlage aus Name oder Nummer ermitteln */
   if ( ctrl->mode&1 )
    cmp = jl->request.name;
   else
    sprintf(cmp = nbuf,"%d",jl->jobID);
D 8
   /* Vergleichen mit dem Pattern */
   if ( !match_wildcard(cmp,ctrl->queueptr) ) continue;
E 8
I 8
   /* Benutzername ermitteln */
   getusername(ubuf,jl->execReq.uid,jl->execReq.gid,info->name);
   /* Vergleichen mit den Pattern */
   if ( !match_wildcard(cmp,ctrl->queueptr) || !match_user(ubuf,ctrl->userptr) ) continue;
E 8
   /* Je nach Qualifier /PARALLEL Informationen ausgeben */
   if ( (ctrl->mode&2) && jl->leader )
    sjf_parallel(jl,ctrl);
   else
    sjf_job(jl,ctrl);
I 8
   /* Trennzeile ausgeben */
   f77printf(" ");
E 8
  }
}

/*
  Strukturinformationen eines Paralleljobs. Zu dem angegebenen Paralleljob werden
  saemtliche von diesem gestarteten Teiljobs aufgelistet.
*/
static sjf_parallel(jl,args)
jobctrl *jl;
struct QMshow *args;
{
 static int asl = 0,sjfp_cmp();
 static jobctrl **slist = 0;
 static char cstart[64];
 execctrl *exe;
 genctrl *gen;
 jobctrl *job;
 int nsl = 0;
 char *ckind;

 /* Parallelcontrolljob */
 f77printf("Job %d (%s) is parallel control job",jl->jobID,jl->request.name);
 /* Alle Teilprozesse aufsuchen */
 for ( gen = info->gens ; gen ; gen = gen->next )
  {
   /* - In der Liste der wartenden Jobs */
   for ( job = gen->Pjobs ; job ; job = job->next )
    if ( job->request.leader == jl->leader )
     sjfp_add(&slist,&nsl,&asl,job);
   /* - In der Liste der laufenden Jobs */
   for ( job = gen->Rjobs ; job ; job = job->next )
    if ( job->request.leader == jl->leader )
     sjfp_add(&slist,&nsl,&asl,job);
  }
 /* - Und in den RPC-Fehlerlisten der EXEC-Queues */
 for ( exe = info->execs ; exe ; exe = exe->next )
  for ( job = exe->Ejobs ; job ; job = job->next )
   if ( job->request.leader == jl->leader )
    sjfp_add(&slist,&nsl,&asl,job);
 /* Weitermachen, falls Teiljobs vorhanden sind */
 if ( !nsl ) return;
 /* Nach absteigender Jobnummer sortieren */
 qsort(slist,nsl,sizeof(*slist),sjfp_cmp);
 /* Und in der Reihenfolge der Jobstarts anzeigen */
 while ( nsl-- )
  {
   /* - Aktueller Job */
   jl = slist[nsl];
   /* - Art des Teiljobs */
   if ( jl->execReq.kind == skCONVERTER )
    ckind = "(CONVERTER)";
   else if ( jl->execReq.kind == skPARALLEL )
    ckind = "(PROGRAM)";
   else
    ckind = "";
   /* - Startzeitpunkt */
   strcpy(cstart,ctime(&jl->submit));
   cstart[strlen(cstart)-1] = '\0';
   /* - Anzeigen */   
   f77printf("\tJob %d (%s) %s submitted at %s",jl->jobID,jl->request.name,ckind,cstart);
  }
}

/*
  Eintrag in die Liste der Parallelteiljobs vornehmen.
*/
static sjfp_add(sl,nl,al,nj)
jobctrl ***sl,*nj;
int *nl,*al;
{
 jobctrl **nsl;

 /* Platz schaffen */
 if ( *nl == *al )
  {
   /* - Speicher reservieren */
   if ( !(nsl = MALLOC(jobctrl *,(*al)+10)) ) return;
   /* - Umkopieren */
   if ( *al )
    {
     MEMMOVE(nsl,*sl,*al);
     free(*sl);
    }
   /* - Neue Werte festhalten */
   *al += 10;
   *sl = nsl;
  }
 /* Eintrag in die Liste */
 (*sl)[(*nl)++] = nj;
}

/*
  Vergleich zweier Jobnummern zum Sortieren in absteigender Reihenfolge.
*/
static sjfp_cmp(jp1,jp2)
jobctrl **jp1,**jp2;
{
 /* Absteigend soll sortiert werden */
 return (*jp2)->jobID-(*jp1)->jobID;
}

/*
  Nach Anfrage an die zugehoerige EXEC-Queue detaillierte Informationen ueber
  einen Job ausgeben.
*/
static sjf_job(jl,args)
jobctrl *jl;
struct QMshow *args;
{
 execctrl *exe;
 procinfos pi;
 PID pid;
 int i;

 /* Nachsehen, ob eine Abfrage moeglich ist */
 if ( !(exe = jl->jexec) || ((pid = jl->pid) <= 0) )
  {
   /* - Job laeuft noch nicht (richtig) */
   f77printf("Job %d (%s) is still pending",jl->jobID,jl->request.name);
   return;
  }
 /* Kopfzeile ausgeben */
D 11
 f77printf("Job %d (%s) is executing on %s",
	   jl->jobID,jl->request.name,INET_NTOA(exe->status.IPaddr));
E 11
I 11
 f77printf("Job %d (%s) is executing on %s (%s)",
	   jl->jobID,jl->request.name,exe->status.name,INET_NTOA(exe->status.IPaddr));
E 11
 /* Informationen von der EXEC-Queue anfordern */
 pi.procinfos_len = 0;
 pi.procinfos_val = 0;
 if ( !execinfo(exe->status.IPaddr,&pid,&pi) ) return;
 /* Vaterprozess des Jobs suchen */
 for ( i = pi.procinfos_len ; i-- ; )
  if ( pi.procinfos_val[i].pid == pid )
   {
    /* Alle Jobs rekursiv ausgeben */
    sjfj_show(2,pi.procinfos_val[i].ppid,&pi,args);
    break;
   }
 /* Aufraeumen des Speichers */
 xdr_free(xdr_procinfos,&pi);
}

/*
  Alle Informationen zu Prozessen ausgeben, deren Vaterprozess durch 'pid'
  gegeben ist. Bei diesen Kindprozessen wird die Routine rekursiv aufgerufen,
  so dass letztlich alle Prozesse angezeigt werden.
*/
static sjfj_show(lev,pid,pi,args)
int lev;
PID pid;
procinfos *pi;
struct QMshow *args;
{
 static char tabs[100] = "\0",start[64];
 procinfo *cur;
 long lstart;
 char *state;
 int i;

 /* Feld initialisieren */
 if ( !*tabs ) for ( i = sizeof(tabs) ; i-- ; tabs[i] = ' ' );
 /* Naechste Schachtlungstiefe bestimmen */
 if ( (lev+4) >= sizeof(tabs) ) return;
 /* Alle Prozesse suchen, deren Vaterprozess 'pid' ist */
 for ( i = pi->procinfos_len ; i-- ; )
  {
   /* - Aktuelles Element */
   cur = pi->procinfos_val+i;
   /* - Ist das hier zu gebrauchen */
   if ( cur->ppid != pid ) continue;
   /* - Informationen anzeigen */
   tabs[lev] = '\0';
   f77printf("%sPID%6d [%.2fs] %s",tabs,cur->pid,cur->cpu,cur->cmd);
   /* - Volle Information bei /FULL ausgeben */
   if ( args->mode&4 )
    {
     /* -- Zustand des Prozesses */
     switch (cur->state)
      {
       case psSLEEPING     : state = "sleeping"; break;
       case psWAITING      : state = "waiting"; break;
       case psRUNNING      : state = "running"; break;
       case psINTERMEDIATE : state = "intermediate"; break;
       case psTERMINATED   : state = "terminated"; break;
       case psSTOPPED      : state = "stopped"; break;
       default	   	   : state = "executing";
      }
     /* -- Startzeitpunkt */
     lstart = cur->start;
     strcpy(start,ctime(&lstart));
     start[strlen(start)-1] = '\0';
     /* -- Informationen ausgeben */
     f77printf("%s--- %s, uid=%d prio=(%d,%d) size=%dp [%s]",
	       tabs,state,cur->uid,cur->prio,cur->nice,cur->size,start);
    }
   tabs[lev] = ' ';
   /* - Informationen ueber dessen Kinder anzeigen */
   if ( cur->ppid != cur->pid ) sjfj_show(lev+1,cur->pid,pi,args);
  }
}

/*
  Anzeigen aktueller Informationen der EXEC-Queues. Dies kann noetig sein, da
  die Informationen der GEN-Queue unter Umstaenden recht alt sind. Der zu
  suchende Name ist ein Wildcardpattern und passende EXEC-Queues werden ueber
  'match_exec' ermittelt.
*/
eqm_show_exec(args,msg)
struct QMshow *args;
char *msg;
{
 /* Verbindung mit dem Queuemanager aufnehmen, Informationen auslesen und Misserfolg melden */
 switch (fillinfo(args->hostptr,args->firstcall,msg))
  {
   case FILL_NOHOST : return 2;
   case FILL_NOINFO : return 1;
  }
 /* Dateinamen aus /OUTPUT umsetzen und Datei oeffnen */
 if ( !makeoutput(args->outputptr) ) return 3;
I 20
 /* Etwas warten, damit die Zaehler korrekt sind */
 sleep(2);
E 20
 /* Alle EXEC-Queues absuchen nach dem spezifizierten Namen absuchen */
 outdone = 0;
 if ( allexecs(se_show,args) ) return 0;
 /* Misserfolg melden */
 sprintf(msg,"no executer '%s' found\n",args->queueptr);
 return 1;
}

/*
  Abarbeiten aller EXEC-Queues. Fuer jede EXEC-Queue wird die angegebene Routine mit
  dem vorgeschlagenene Parameter aufgerufen.
*/
static allexecs(fc,par)
void (*fc)();
char *par;
{
 execctrl *exe;

 /* Alle EXEC-Queues durchgehen */
 for ( exe = info->execs ; exe ; exe = exe->next ) (*fc)(exe,par);
D 8
#ifndef vms
 /* Eventuell Leerzeile anschliessen */
 if ( outdone == 1 ) f77printf(" ");
#endif
E 8
 /* Ausgabedatei schliessen, falls sie explizit geoeffnet wurde */
 if ( outf != -1 )
  {
   close(outf);
   outf = -1;
  }
 /* Erfolg oder Misserfolg melden */
 return outdone;
}

/*
  Anzeigen aller (aktuellen) Informationen einer EXEC-Queue. Koennen die aktuellen
  Informationen nicht ausgelesen werden, werden die der GEN-Queue genommen.
*/
static void se_show(exe,ctrl)
execctrl *exe;
struct QMshow *ctrl;
{
 statusinfo si,*use;
 parchan *cur;
 long addr;
 double t;
 int i;

 /* Nachsehen, ob diese Queue zu gebrauchen ist */
 if ( !match_exec(exe,ctrl->queueptr) ) return;
 /* Feld initialisieren */
 si.name = 0;
 /* Informationen einlesen bzw. uebernehmen */
 if ( !execstatus(exe->status.IPaddr,use = &si) )
  use = &exe->status;
 else
  use->IPaddr = exe->status.IPaddr;
 /* Informationen ausgeben */
 f77printf("EXEC-Queue %s on %s",use->name,INET_NTOA(use->IPaddr));
 /* - Anzeigen, ob die Informationen aus der GEN-Queue stammen */
 if ( use == &exe->status ) f77printf("\t/INFORMATION=GENERIC");
 /* - Spezielle Informationen ausgeben */
 showstatus(use);
 /* - TCP/IP-Proformance zu anderen Hosts */
 for ( i = 0 ; i < exe->tcpinfo.parchans_len ; )
  {
   /* -- Aktueller Messwert */
   cur = exe->tcpinfo.parchans_val+i++;
   /* -- Ist die Zeit legal */
   if ( (t = cur->IPsecs+1.0E-6*cur->IPusecs) <= 0.0 ) continue;
   /* -- Information ausgeben */
   addr = htonl(cur->IPaddr);
   f77printf("\t/CHANNEL=(EXECUTER=%s,TRANSFERTIME=%.2fs)",INET_NTOA(addr),t);
  }
I 8
 /* Trennzeile ausgeben */
 f77printf(" ");
E 8
 /* Speicher muss freigegeben werden */
 if ( use == &si ) xdr_free(xdr_statusinfo,&si);
}

/*
  Spezielle Informationen aus dem 'statusinfo'-Block einer EXEC-Queue anzeigen.
*/
static showstatus(si)
statusinfo *si;
{
 /* Aktuelle Performanceinformationen */
 if ( si->perf != 0.0 ) f77printf("\t/PERFORMANCE_TIME=%.2fs",si->perf);
 f77printf("\t/LAST_IDLE_RATIO=%d%%",(int)(100*si->idle+0.5));
 f77printf("\t/LAST_FAULT_FREQUENCY=%.1fHz",si->faults);
 /* TCP/IP-Port des TCP Prozesses */
 if ( si->EaterPort != -1 ) f77printf("\t/EATER_PORT=%d",si->EaterPort);
 /* Prozesskennung einer TCP Performance Messung */
 if ( si->trans != -1 ) f77printf("\t/TRANSFER_PID=%d",si->trans);
}

/*
  Erzeugen der Startupdatei fuer die GEN-Queue oder ausgewaehlte EXEC-Queues.
  Diese Dateien sind fuer den Systemmanager wichtig und werden an genau definierte
  Stellen innerhalb eines Filesystems des entsprechenden UNIX-Rechners geschickt.
*/
eqm_startup(args,msg)
struct QMshow *args;
char *msg;
{
 bool_t *res;

 /* Verbindung mit dem Queuemanager aufnehmen, Informationen auslesen und Misserfolg melden */
 switch (fillinfo(args->hostptr,args->firstcall,msg))
  {
   case FILL_NOHOST : return 2;
   case FILL_NOINFO : return 1;
  }
 /* GEN-Queue bearbeiten */
 if ( !args->queueptr )
  {
   /* Befehl abschicken und Misserfolg melden */
   if ( !(res = (bool_t *)action(msg,gendumpstartup_1,(void *)0)) ) return 1;
   /* Erfolg melden */
   if ( *res == TRUE ) return 0;
   /* Fehlermeldung aufsetzen */
   strcpy(msg,"queue manager could not create startup file\n");
   return 1;
  }
 /* Alle EXEC-Queues absuchen nach dem spezifizierten Namen absuchen */
 outdone = 0;
 if ( allexecs(ds_dump,args) ) return 0;
 /* Misserfolg melden */
 sprintf(msg,"no executer '%s' found\n",args->queueptr);
 return 1;
}

/*
  Bei allen geeigneten EXEC-Queues einen Startupfile erzeugen lassen. Das Prinzip
  ist das gleiche wie bei der GEN-Queue. Der Name wird ueber 'match_exec' mit dem
  Suchpattern verglichen.
*/
static void ds_dump(exe,ctrl)
execctrl *exe;
struct QMshow *ctrl;
{
 bool_t res;

 /* Nachsehen, ob diese Queue zu gebrauchen ist */
 if ( !match_exec(exe,ctrl->queueptr) ) return;
 /* Dump erzeugen */
 execdump(exe->status.IPaddr,&res);
 /* Hat sich was getan */
 outdone = 2;
I 21
}

/*
  Motifschnittstelle aufrufen.
*/
D 22
eqm_motif()
E 22
I 22
eqm_motif(com,clen,kill)
char *com;
int *clen,*kill;
E 22
{
I 22
 char *Xqueue(),*res;

E 22
 /* Flags setzen und aufrufen */
D 22
 MotifRunning = 1;
 Xqueue(0,(char **)0);
 MotifRunning = 0;
E 22
I 22
 if ( res = Xqueue(*kill) )
  {
   strcpy(com,res);
   *clen = strlen(com);
  }
 else
  *clen = -1;
 /* Merken */
 MotifRunning = (*clen >= 0);
E 22
 /* Alles in Ordnung */
 return 1;
E 21
E 5
}
E 1
