h22821
s 00000/00000/00063
d D 5.1 91/08/12 17:41:29 jochen 3 2
c Xqueue included in QMan; SET MODE command added
e
s 00024/00002/00039
d D 4.2 91/02/25 17:31:31 jochen 2 1
c New release and support for parallel queues completed
e
s 00041/00000/00000
d D 4.1 91/02/23 14:48:39 jochen 1 0
c SCCS version created
e
u
U
t
T
I 1
/* %W% 91/01/02 Batch queue user interface for UNIX and VMS */

#ifdef SCCSIDS
static char sccsid_intexec_c[] = "%Z%%M% %I% %E% %U% Jochen Manns, 1991";
#endif

/*
  Da es nicht moeglich ist, in dem Includefile der GEN-Queue alle notwendigen
  Konstanten fuer die EXEC-Queue zu halten, muss der QMan durch diese besondere
  Schnittstelle mit den EXEC-Queues kommunizieren.
*/
#include <errno.h>
#include <stdio.h>

I 2
/*
  Variable INCLUDE-Dateien, die unter UNIX und VAX/VMS verschieden sind.
*/
#ifdef vms
#include <sunrpc$dir:[rpc]rpc.h>

#include "sexec.h"
#else
E 2
#include <rpc/rpc.h>

#include <sys/socket.h>

#include "../exec/sexec.h"
I 2
#endif
E 2

/*
D 2
  Startdatei erzeugen.
E 2
I 2
  Startdatei erzeugen. Die Fehlermeldung wird normalerweise nicht ausgewertet.
E 2
*/
execdump(IPaddr,bp)
long IPaddr;
bool_t *bp;
{
 return (execdo(IPaddr,EXECDUMPSTARTUP,xdr_void,bp,xdr_bool,bp) && (*bp == TRUE));
}

/*
D 2
  Jobinformationen auslesen.
E 2
I 2
  Jobinformationen auslesen. Man erhaelt eine Liste aller zu einer Prozessgruppe
  gehoerigen Prozesse, sofern der Hauptprozess von der EXEC-Queue verwaltet wird.
E 2
*/
execinfo(IPaddr,pp,ip)
long IPaddr;
PID *pp;
procinfos *ip;
{
 return execdo(IPaddr,EXECPROCINFO,xdr_PID,pp,xdr_procinfos,ip);
}

I 2
/*
  Queueinformationen auslesen. Den QMan interessieren im wesentlichen die staendig
  aktualisierten Informationen 'faults', 'idle' und 'perf'.
*/
execstatus(IPaddr,is)
long IPaddr;
statusinfo *is;
{
 statuscode sc = stALL;

 return execdo(IPaddr,EXECSTATUS,xdr_statuscode,&sc,xdr_statusinfo,is);
}
E 2
E 1
