#define PCB_INLINE
#include "PortIt.h"

static int CheckAbbr();
static int CheckNumber();
static int ClearOpcode();
static int GetChars();
static int GetMin();
static int MakeVersion();
static int RemChar();
static int SetClear();
static int StartSet();
static int Variable();

static int (*pcb_actions[])() =
	{
	 CheckAbbr,
	 CheckNumber,
	 ClearOpcode,
	 GetChars,
	 GetMin,
	 MakeVersion,
	 RemChar,
	 SetClear,
	 StartSet,
	 Variable,
	 0
	};


char *pcb_module[] =
	{
	 "PortIt.t",
	 (char *)0,
	 (char *)0x21,
	 (char *)10,
	 (char *)pcb_actions,
	 (char *)0
	};

#define PCB struct epcb


ClearOpcode(pcb)
PCB *pcb;
{
 pcb->pcb_Opcode = 0;
 return parse_exit;
}

CheckNumber(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_Opcode <= 0) || (pcb->pcb_Opcode > 255) )
  return parse_fail;
 return parse_exit;
}

MakeVersion(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token < 0) || (pcb->sys_pcb.pcb_token > 15) )
  return parse_fail;
 pcb->pcb_Version = (pcb->pcb_Version<<4)+pcb->sys_pcb.pcb_token;
 return parse_exit;
}

StartSet(pcb,set)
PCB *pcb;
long set;
{
 pcb->pcb_ActTable = set;
 return parse_exit;
}

GetMin(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 pcb->pcb_CharMin = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 return parse_exit;
}

GetChars(pcb,max)
register PCB *pcb;
long max;
{
 register int c0,cnt;
 register unsigned char *fill,mask;

 if ( !max )
  c0 = pcb->pcb_CharMin;
 else
  {
   c0 = pcb->pcb_CharMax;
   if ( (c0 <= 0) || (c0 > 255) ) return parse_fail;
  }
 if ( (cnt = c0-pcb->pcb_CharMin) < 0 ) return parse_fail;
 c0 = pcb->pcb_CharMin;
 pcb->pcb_CharMin = pcb->pcb_CharMax = 0;
 fill = ((unsigned char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(c0>>3);
 mask = 1<<(c0&7);
 for ( ; ; )
  {
   *fill |= mask;
   if ( !cnt-- ) return parse_exit;
   mask += mask;
   if ( !mask )
    {
     fill++;
     mask = 1;
    }  
  }
}

RemChar(pcb)
register PCB *pcb;
{
 register char *fill,bit;
 
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 bit = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 fill = ((char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(bit>>3);
 *fill &= ~(1<<(bit&7));
 return parse_exit; 
}

CheckAbbr(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token <= 0) || (pcb->sys_pcb.pcb_token > 127) )
  return parse_fail;
 return parse_exit;
}

Variable(pcb,index)
register PCB *pcb;
register long index;
{
 register long size;

 if ( !index && ((index = pcb->sys_pcb.pcb_token) < 0) ) return parse_fail;
 pcb->pcb_Command = CVariable;
 pcb->pcb_SymbolValue = pcb->pcb_Defined;
 if ( !(size = pcb->pcb_VarSize) ) size = 4;
 pcb->pcb_VarSize = size;
 pcb->pcb_VarIndex = index;
 pcb->pcb_Defined += size*index;
 return parse_exit;
}

SetClear(pcb)
register PCB *pcb;
{
 pcb->pcb_Clear = pcb->pcb_Defined;
 return parse_exit;
}

#undef PCB
