#ifndef PARSER
#define PARSER

struct pcb
       {
        char 	   *pcb_line;
	char 	   pcb_flags;
	char 	   pcb_abbr;
	long 	   pcb_token;
	char 	   *pcb_table1;
	char 	   *pcb_table2;
	int  	   pcb_debug;
	char 	   *pcb_table3;
	int  	   pcb_nclear;
	char 	   *pcb_clear;
	int  	   pcb_nactions;
	int  	   (**pcb_actions)();
	int  	   pcb_nmodules;
	struct pcb **pcb_modules;
       };

#define parse_exit	0
#define parse_fail	1
#define parse_table	2
#define parse_check	3
#define parse_abbr	4

struct descriptor
       {
	char *text;
	long len;
       };

#ifdef vms
#define PSUFFIX	        ".ptb"
#define bcopy(a,b,n)	memcpy(b,a,n)
#define	bzero(a,n)	memset(a,0,n)
#else
#define PSUFFIX	        ".t"
#ifdef MCH_AMIGA
#define bcopy(a,b,n)	movmem(a,b,n)
#define	bzero(a,n)	setmem(a,n,0)
#endif
#endif

#endif
