#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ! $?TABDIR ) then
  set TABDIR = /usr/tables
endif

if ( ! $?PORTABLE ) then
  set PORTABLE = portable
endif

if ( ($#argv >= 2) && ("$2" != "") ) then
  set DIRDEF = "$2"
else if ( ! $?DIRDEF ) then
  set DIRDEF = "saphir"
endif
if ( ($#argv >= 3) && ("$3" != "") ) then
  set INCDEF = "$3"
else if ( ! $?INCDEF ) then
  set INCDEF = "modules"
endif
  
#
# PortParser.csh create|use [(DIRDEF|"") [INCDEF]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given
  goto USAGE
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif
#
# INCDEF ist ein Unterverzeichnis in $INCDIR. Es muss immer mit einem 
# / beginnen und enden.
#
if ( "$INCDEF" == "" ) then
  set INCDEF = /
else
  set key = `echo "$INCDEF" | sed -n 's/^\(.\).*$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = /"$INCDEF"
  endif
  set key = `echo "$INCDEF" | sed -n 's/^.*\(.\)$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = "$INCDEF"/
  endif
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set LIBDIR2 = `echo "$LIBDIR1$INCDEF" | sed -n 's/^\(.*\)\/$/\1/p'`
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
cat << EOF
+++   
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++  parser module directory        =   $LIBDIR2   
+++  parser table directory         =   $TABDIR
+++
+++  directory for porting          =   $PORTABLE
+++   
EOF

#
# Befehl auswerten
#
if ( "$1" == "create" ) then
#
# Directory erzeugen
#
  if ( ! -d "$PORTABLE" ) then
    action creating directory "$PORTABLE"
    check mkdir "$PORTABLE"
  else
    action cleaning directory "$PORTABLE"
    rm -f "$PORTABLE"/*
  endif
#
# Maschinenunabhaengige Parsertabelle erzeugen
#
  action creating files for ported generator
  check make PortIt
#
# Und in der Directory sammeln
#
  action moving files for ported generator to directory "$PORTABLE"
  check mv PortIt.[chp] PortParserDef.c "$PORTABLE"
#
# Aufrauemen
#
  action cleaning up temporary files
  rm -f GenTable PortParse *.o
else if ( "$1" == "use" ) then
#
# Systemdirectories suchen
#
  if ( ! -d "$BINDIR" ) then
    error directory "$BINDIR" for executable does not exist
    exit 1
  endif
  if ( ! -d "$INCDIR" ) then
    error directory "$INCDIR" for includes does not exist
    exit 1
  endif
  if ( ! -d "$LIBDIR" ) then
    error directory "$LIBDIR" for libraries does not exist
    exit 1
  endif
#
# Systemdirectories erzeugen
#
  if ( ! -d "$LIBDIR1" ) then
    action creating project include directory "$LIBDIR1"
    check mkdir "$LIBDIR1"
  endif
  if ( ! -d "$LIBDIR2" ) then
    action creating parser module directory "$LIBDIR2"
    check mkdir "$LIBDIR2"
  endif
  if ( ! -d "$TABDIR" ) then
    action creating table directory "$TABDIR"
    check mkdir "$TABDIR"
  endif
#
# Directory muss vorhanden sein
#
  if ( ! -d "$PORTABLE" ) then
    error directory "$PORTABLE" not found
    exit 1
  else
#
# Benoetigte Files kopieren
#
    action copying files to directory "$PORTABLE"
    check cp GenTable.c GetArgs.c Parser.c getargs.h parser.h "$PORTABLE"
#
# Files erzeugen
#
    action creating ported table
    (cd "$PORTABLE" ; check cc -O -o PortParserDef PortParserDef.c)
    (cd "$PORTABLE" ; check PortParserDef)
    (cd "$PORTABLE" ; check rm -f PortParserDef.o PortParserDef)
    action creating ported objects
    (cd "$PORTABLE" ; check cc -O -DPORTIT -c GenTable.c GetArgs.c Parser.c PortIt.c)
    action creating ported generator
    (cd "$PORTABLE" ; check cc -o GenTable GenTable.o GetArgs.o Parser.o PortIt.o)
#
# Ergebnis kopieren
#
    action copying ported generator
    check mv "$PORTABLE"/GenTable gt_port
    check mv "$PORTABLE"/PortIt.t . 
#
# Aufrauemen
#
    action cleaning up directory "$PORTABLE"
    (cd "$PORTABLE" ; rm -f GenTable.[co] GetArgs.[co] Parser.[co] getargs.h \
		     	  parser.h PortIt.o)
#
# Endgueltigen Generator erzeugen
#
    action cleaning up old definitions
    rm -f ParserDef.[ch]
    action creating standalone generator
    check make GenTable GT=gt_port \
	       INCDEF="'"'"'"$INCDEF"'"'"'" \
	       DIRDEF="'"'"'"$DIRDEF"'"'"'"
#
# Installieren
#
    action copying include files to "$LIBDIR1"
    check cp getargs.h parser.h "$LIBDIR1"
    action copying executables to "$BINDIR"
    check cp GenTable "$BINDIR"/gt
    action copying objects to library "$OBJLIB"
    check ar rv "$OBJLIB" Parser.o GetArgs.o 
#
# Endgueltig aufraeumen
#
    action cleaning up
    rm -f GenTable gt_port PortIt.t *.o 
#
#
#
    action parser installation complete
  endif
else
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
***
***
***  USAGE: ${0} create|use [(DIRDEF|"") [INCDEF]]
***
***    create  will create the directory ${PORTABLE} for porting the parser to
***            other systems
***    use     will reinstall the parser on this system using the directory
***            $PORTABLE
***    DIRDEF  is the name of the project (saphir)
***    INCDEF  is the name of the module directory (modules)
***
***
EOF
  exit 1
endif

