#include <stdio.h>
#include "ParserDef.h"

#define VERSION		"Porting Parser Tables 1.0 by JMS 1990"
#define VERSION_MAGIC	0x4a02

/*
*/
extern char *optarg,*getargs_error();
extern int opterr;

#define USAGE "eingabe [ausgabe] [-?]"

FILE *src = 0,*tab = 0,*fopen();
char *outname = 0;

char *malloc(),*makename();

/*
*/
main(argc,argv)
int argc;
char **argv;
{
 char *inname = 0;
 int done = 0,len;

 while ( !done )
  switch (getargs(argc,argv,"?!IO"))
   {
    case 'I' : if ( ((len = strlen(inname = optarg)) >= 2) &&
       		    (inname[len-2] == '.') && (inname[len-1] == 't') )
    		len -= 2;
    	       break;
    case 'O' : outname = optarg;
    	       break;
    case EOF : done = 1;
               if ( inname ) break;
    case '?' : fprintf(stderr,"Aufruf: %s %s\n",*argv,USAGE);
               fail(1);
               break;
   }
 if ( opterr )
  {
   fprintf(stderr,"Fehler in Befehlszeile: %s\n",getargs_error());
   fail(2);
  }
 if ( !outname ) outname = makename(inname,len,"-t.c",4);
 if ( !(src = fopen(inname,"r")) )
  {
   fprintf(stderr,"Eingabedatei '%s' nicht gefunden\n",inname);
   fail(2);
  }
 if ( !(tab = fopen(outname,"w")) )
  {
   fprintf(stderr,"C-Datei '%s' kann nicht erzeugt werden\n",outname);
   fail(2);
  }
 puts(VERSION);
 fprintf(tab,"#include <stdio.h>\n\n");
 fprintf(tab,"struct header\n\t{\n");
 fprintf(tab,"\t short magic;\n");
 fprintf(tab,"\t long total;\n");
 fprintf(tab,"\t long debug;\n");
 fprintf(tab,"\t unsigned char version;\n");
 fprintf(tab,"\t unsigned char flags;\n");
 fprintf(tab,"\t unsigned char abbr;\n");
 fprintf(tab,"\t unsigned char tabs;\n");
 fprintf(tab,"\t unsigned short size;\n");
 fprintf(tab,"\t unsigned short clear;\n");
 fprintf(tab,"\t}\n\t header =\n\t{\n");
 genheader();
 gentabs();
 fprintf(tab,"\n\t};\n\n");
 fprintf(tab,"FILE *tab,*fopen();\n\n");
 fprintf(tab,"main()\n{\n");
 fprintf(tab," if ( !(tab = fopen(\"%s\",\"w\")) ) exit(1);\n",inname);
 fprintf(tab," header.total += sizeof(header);\n");
 fprintf(tab," header.debug += sizeof(header);\n");
 fprintf(tab," BL(&header,sizeof(header));\n");
 fprintf(tab," BL(&tabs,sizeof(tabs));\n");
 gentable();
 fprintf(tab," fclose(tab);\n}\n\n");
 fprintf(tab,"BL(c,l)\nchar *c;\nint l;\n{\n fwrite(c,1,l,tab);\n}\n\n");
 fprintf(tab,"BY(b)\nlong b;\n{\n char c=b;\n\n fwrite(&c,1,1,tab);\n}\n\n");
 fprintf(tab,"WO(w)\nlong w;\n{\n short s=w;\n\n fwrite(&s,1,2,tab);\n}\n\n");
 fail(0);
}

fail(code)
int code;
{
 if ( tab ) fclose(tab);
 if ( src ) fclose(src);
 exit(code);
}

nomem(code)
int code;
{
 fprintf(stderr,"Kein Speicher mehr vorhanden\n");
 fail(code);
}

static char *makename(head,hlen,tail,code)
char *head,*tail;
int hlen,code;
{
 char *ns;

 if ( !(ns = malloc(hlen+strlen(tail)+1)) ) nomem(code);
 strncpy(ns,head,hlen);
 strcpy(ns+hlen,tail);
 return ns;
}

/*
*/
struct header
       {
	short    magic;
	long     total;
	long     debug;
	unsigned char version;
	unsigned char flags;
	unsigned char abbr;
	unsigned char tabs;
	unsigned short size;
	unsigned short clear;
       } header;

genheader()
{
 if ( fread(&header,1,sizeof(header),src) != sizeof(header) )
  {
   fprintf(stderr,"Header konnte nicht gelesen werden\n");
   fail(1);
  }
 if ( header.magic != VERSION_MAGIC )
  {
   fprintf(stderr,"Eingabedatei ist keine Parsertabelle\n");
   fail(1);
  }
 fprintf(tab,"\t %d,%ld,%ld,%u,%u,%u,%u,%u,%u\n",
	     (int)header.magic,
	     header.total-sizeof(header),
	     header.debug-sizeof(header),
	     (int)header.version,(int)header.flags,(int)header.abbr,
	     (int)header.tabs,(int)header.size,(int)header.clear);
 fprintf(tab,"\t};\n\nchar tabs[%u][32] =\n\t{\n\t ",(int)header.tabs);
}

/*
*/
gentabs()
{
 unsigned char buf[8];
 int i,j,k;

 for ( i = header.tabs ; i-- ; )
  for ( j = 32/sizeof(buf) ; j-- ; )
   {
    if ( fread(buf,1,sizeof(buf),src) != sizeof(buf) )
     {
      fprintf(stderr,"Zeichensaetze konnten nicht gelesen werden\n");
      fail(1);
     }
    for ( k = 0 ; k < sizeof(buf) ; )
     {
      fprintf(tab,"0x%02x",buf[k++]);
      if ( (k != sizeof(buf)) || j || i ) fprintf(tab,",");
     }
    if ( j || i ) fprintf(tab,"\n\t ");
   } 
}

/*
*/
gentable()
{
 char *buf;
 int done,size = header.total-sizeof(header)-header.tabs*32;

 if ( !(buf = malloc(size)) )
  {
   fprintf(stderr,"Kein Speicher fuer die Parsertabelle\n");
   fail(1);
  }
 if ( fread(buf,1,size,src) != size )
  {
   fprintf(stderr,"Parsertabelle konnte nicht gelesen werden\n");
   fail(1);
  }
 while ( size > 0 )
  {
   done = genone(buf);
   buf += done;
   size -= done;
  }
}

static long peekl(ad)
unsigned short *ad;
{
 return (ad[0]<<16L)+ad[1];
}

#define BYTE()		{ch= *entry++;\
			fprintf(tab," BY(0x%xL);\n",(int)ch);}
#define WORD()		{sh= *((unsigned short *)entry)++;\
			fprintf(tab," WO(0x%xL);\n",(int)sh);}
#define LONG()		{WORD(); WORD();}

genone(entry)
char *entry;
{
 char one,two,*zero = entry;
 unsigned char ch;
 unsigned short sh;
 int key = 0;

 BYTE();
 one = ch;
 BYTE();
 two = ch;
 if ( one < 0 )
  two = one;
 else
  switch (one)
   {
    case fKEY    : key = 1;
    case fSUB    :
    case fMODULE : WORD();
		   break;
   } 
 WORD();
 WORD();
 if ( two&fm_action ) WORD();
 if ( two&fm_parameter ) LONG();
 if ( two&fm_maske ) LONG();
 if ( two&fm_maskadr ) WORD();
 if ( key )
  {
   do
    BYTE()
   while ( ch );
   if ( ((long )entry)&1 ) BYTE();
  } 
 return entry-zero;
}
