;
; Definitionsdatei fr den Parser selbst, d.h. die hier erzeugte Tabelle
; ist in der Lage, sich selbst und analog aufgebaute Dateien korrekt in
; eine von der Parserlibrary verstndliche Form zu bringen. Zuerst wird
; einmal eine Versionsnummer angegeben, damit nicht versehentlich neuere
; Tabellen ein Programm verwirren.
;
		Version		2.1
;
; Wir brauchen auch noch einige Definitionen ber Konstanten des Parsers.
;
		Include		"parser.h"
;
; Nun mu man dem Parser mitteilen, welche Zeichenstze fr welche Zwecke
; verwendet werden mssen.
;
		Character Sets
;
		Legal		= TAB,BLANK,'!'..'~'
		StringStart	= '0'..'9','A'..'Z','a'..'z'
		StringChars	= '0'..'9','A'..'Z','a'..'z'
		SymbolStart	= '$','A'..'Z','a'..'z','_'
		SymbolChars	= '$','0'..'9','A'..'Z','a'..'z','_'
		FileChars	= '!'..255,-''',-'"',-';',-'>',-'<'
;
; In dem hier vorkommenden Fall sind zwar eigentlich keine weiteren
; Angaben ber Konstanten des Parsers ntig, ich habe aber hier der
; Vollstndigkeit halber die weiteren Befehle aufgefhrt.
;
		Flags		=
		Abbrevation	= 
;
; Die folgenden Definitionen beschreiben die Gre und Lage einiger
; zur Synchronisation mit dem aufrufenden Programm notwendigen Daten.
;
		Definitions
;
		pcbm_blanks	= $01
		pcbm_ambg	= $02
		pcbm_case	= $04

		pcbm_tables	= 6

		pcbm_abbruni	= $ff
		pcbm_abbrany	= $fe

		pcb_chars	= 0
		pcb_strstart	= 32
		pcb_strchars	= 64
		pcb_symstart	= 96
		pcb_symchars	= 128
		pcb_filechars	= 160

		fm_action	= $01
		fm_parameter	= $02
		fm_maske	= $04
		fm_maskadr	= $08
		fm_check	= $10
		fm_pvar		= $20
		fm_mvar		= $40
		fm_onekey	= $80

		state_exit	= $ffffffff
		state_fail	= $fffffffc

		fANY		= 0
		fALPHA		= 1
		fDIGIT		= 2
		fSTRING		= 3
		fSYMBOL		= 4
		fBLANK		= 5
		fDECIMAL	= 6
		fOCTAL		= 7
		fHEX		= 8
		fKEY		= 9
		fLAMBDA		= 10
		fEOS		= 11
		fSUB		= 12
		fFILE		= 13
		fMODULE		= 14
		fBINARY		= 15
;
		long FirstChar
		long Version
		long HFlags
		long HAbbr
		long Defined
		long Clear
		long Charsets
		 SetLegal	= 1
		 SetStrStart	= 2
		 SetStrChars	= 4
		 SetSymStart	= 8
		 SetSymChars	= 16
		 SetFile	= 32
		 SetAbbr	= $10000
		 SetFlags	= $20000
		 GotClear	= $40000
		long Tables[48]
;
		Clear

		long Command
		 CState		= 1
		 CTrans		= 2
		 CHeader	= 3
		 CConst		= 4
		 CVariable	= 5
		 CCopy		= 6
		 CInclude	= 7
		long Flags
		 NameState	= 1
		long InclStart
		descriptor InclName
		long ActTable
		long CharMin
		long CharMax
		descriptor SymbolName
		long SymbolValue
		long Options
		long Opcode
		long Label
		long LabelLen
		descriptor Key
		descriptor Sub
		descriptor Module
		descriptor Action
		PZahl		= $ffffffff
		long Parameter
		long ParameterLen
		long Maske
		long MaskeLen
		descriptor Maskadr
		long VarSize
		long VarIndex

;
; Nun endlich zu den Regeln der hier definierten Sprache.
;
		Rules
;
; Anhand des ersten Zeichens wird entschieden, welcher Analyseschritt
; auszufhren ist. Das ermglicht es, diese Tabelle ber nur einen
; einzigen Einsprungpunkt zu starten. Der Benutzer selbst gibt ledig-
; lich eine 1 am Anfang an und bernimmt dann jeweils die eventuell
; vernderte Synchronisationsvariable FirstChar.
;
		State	ParserParser,NAME
		Trans	1,ParseVersion
		Trans	3,ParseInclude
		Trans	7,ParseCharsets
		Trans	15,ParseFlags
		Trans	31,ParseDefinitions
		Trans	63,ParseRules
;
; Kommentare beginnen mit einem Semikolon oder sind einfach Leerzeilen.
;
		State	Kommentar,NAME
		Trans	';',p$Exit
		Trans	p$Eos,p$Exit
;
; Zuerst erfolgt die Versionsdefinition:
;	VERSION <integer>.<integer>
;
		State	ParseVersion,NAME
		Trans	'VERSION'
		Trans	p$Lambda,Kommentar
		State
		Trans	p$Decimal,,MakeVersion
		State
		Trans	'.'
		State
		Trans	p$Decimal,Kommentar,MakeVersion,3,FirstChar
;
; Danach gibt es optional INCLUDE-Definitionen, die mit einer Zeichen-
; satzdefinition enden:
; 	INCLUDE <file> | """ <file> """ | "<" <file> ">"
;	CHARACTER SETS
;
		State	ParseInclude,NAME
		Trans	'CHARACTER',ParseSets
		Trans	'INCLUDE',,,CInclude,Command
		Trans	p$Lambda,Kommentar
		State
		Trans	'"',PInclude1,,,InclStart
		Trans	'<',PInclude2,,,InclStart
		Trans	p$File,Kommentar,,,InclName

		State	PInclude1
		Trans	p$File,,,,InclName
		State
		Trans	'"',Kommentar

		State	PInclude2
		Trans	p$File,,,,InclName
		State
		Trans	'>',Kommentar

		State	ParseSets
		Trans	'SETS',Kommentar,,7,FirstChar
;
; Zeichenstze werden aus einzelnen Zeichen oder Zeichenbereichen
; zusammengesetzt. Die Definition endet mit einem FLAGS, RULES,
; ABBREVATION oder DEFINITIONS-Statement:
;	LEGAL | STRINGSTART | STRINGCHARS |
; 		SYMBOLSTART | SYMBOLCHARS | FILECHARS = charlist
;	FLAGS = flaglist
;	ABBREVATION = abbrevation
;	DEFINITIONS
;	RULES
; Dabei ist hier:
;	charlist = [ cdef1 { "|" cdef1 } ]
;	cdef1 = cdef [ "." "." cdef ]
;	cdef = "'" <char> "'" | <integer:1..255> | "$" <hex:01..FF> |
;	       BLANK | LF | CR | TAB
;
		State	ParseCharsets,NAME
		Trans	'ABBREVATION',DefAbbr,,SetAbbr,Charsets
		Trans	'DEFINITIONS',StartDefinitions
		Trans	'FILECHARS',,StartSet,SetFile,Charsets,pcb_filechars,CHECK
		Trans	'FLAGS',DefFlags,,SetFlags,Charsets
		Trans	'LEGAL',,StartSet,SetLegal,Charsets,pcb_chars,CHECK
		Trans	'RULES',StartRules,,CHeader,Command
		Trans	'STRINGCHARS',,StartSet,SetStrChars,Charsets,pcb_strchars,CHECK
		Trans	'STRINGSTART',,StartSet,SetStrStart,Charsets,pcb_strstart,CHECK
		Trans	'SYMBOLCHARS',,StartSet,SetSymChars,Charsets,pcb_symchars,CHECK
		Trans	'SYMBOLSTART',,StartSet,SetSymStart,Charsets,pcb_symstart,CHECK
		Trans	p$Lambda,Kommentar
		State
		Trans	'='
		State	ParseChars
		Trans	!charlist
		Trans	p$Lambda,Kommentar
		State
		Trans	',',ParseChars
		Trans	p$Lambda,Kommentar	

		State	charlist
		Trans	'-',ndef
		Trans	!cdef,,GetMin
		State
		Trans	'.'
		Trans	p$Lambda,p$Exit,GetChars,,,0
		State
		Trans	'.'
		State
		Trans	!cdef,p$Exit,GetChars,,,1

		State	ndef
		Trans	!cdef,p$Exit,RemChar

		State	cdef
		Trans	'''
		Trans	'$',cdefh
		Trans	'BLANK',p$Exit,,32,CharMax
		Trans	'CR',p$Exit,,13,CharMax
		Trans	'LF',p$Exit,,10,CharMax
		Trans	'TAB',p$Exit,,9,CharMax
		Trans	p$Decimal,p$Exit,,,CharMax
		State
		Trans	p$Any,,,,CharMax
		State
		Trans	''',p$Exit
		State	cdefh
		Trans	p$Hex,p$Exit,,,CharMax

		State	StartDefinitions
		Trans	p$Lambda,Kommentar,,31,FirstChar
	
		State	StartRules
		Trans	p$Lambda,Kommentar,,63,FirstChar
;
; Hier ist ein anderer Eingang in die Definition von FLAGS oder
; ABBREVATION. Diese Routine endet beim	Auftreten eines RULES
; oder DEFINITION-Statements:
;	FLAGS = flaglist
;	ABBREVATION = abbrevation
;	DEFINITIONS
;	RULES
; Dabei ist:
;	flaglist = { fdef { "|" fdef } }
;	fdef = CASESENSITIVE | EXPLICITBLANKING
;	abbrevation = UNIQUE | ANY | <integer>!0..255!
;
		State	ParseFlags,NAME
		Trans	'ABBREVATION',DefAbbr,,SetAbbr,Charsets,,CHECK
		Trans	'DEFINITIONS',StartDefinitions
		Trans	'FLAGS',DefFlags,,SetFlags,Charsets,,CHECK
		Trans	'RULES',StartRules,,CHeader,Command
		Trans	p$Lambda,Kommentar

		State	DefFlags
		Trans	'=',,,15,FirstChar
		State	flaglist
		Trans	'CASESENSITIVE',,,pcbm_case,HFlags,,CHECK
		Trans	'EXPLICITBLANKING',,,pcbm_blanks,HFlags,,CHECK
		Trans	p$Lambda,Kommentar
		State
		Trans	'|',flaglist
		Trans	p$Lambda,Kommentar

		State	DefAbbr
		Trans	'=',,,15,FirstChar
		State
		Trans	'UNIQUE',Kommentar,,pcbm_abbruni,HAbbr
		Trans	'ANY',Kommentar,,pcbm_abbrany,HAbbr
		Trans	p$Decimal,Kommentar,CheckAbbr,,HAbbr
		Trans	p$Lambda,Kommentar
;
; Definitionen enden mit einem RULES-Statement.
;	( (['LONG' | 'DESCRIPTOR'] <symbol> ['[' <integer> ']']) |
;	  (<symbol> '=' value) )
;	RULES
; Mit:
;	value = <integer> | '$' <hex> | ''' <char> '''
;
		State	ParseDefinitions,NAME
		Trans	'CLEAR',Kommentar,SetClear,GotClear,Charsets,,CHECK
		Trans	'DESCRIPTOR',DefVariable,,8,VarSize
		Trans	'LONG',DefVariable,,4,VarSize
		Trans	'RULES',StartRules,,CHeader,Command
		Trans	p$Symbol,,,,SymbolName
		Trans	p$Lambda,Kommentar
		State
		Trans	'=',DefConst,,CConst,Command
		Trans	'[',DefVariable1
		Trans	p$Lambda,Kommentar,Variable,,,1

		State	DefVariable
		Trans	p$Symbol,,,,SymbolName
		State
		Trans	'['
		Trans	p$Lambda,Kommentar,Variable,,,1
		State	DefVariable1
		Trans	p$Decimal,,Variable,,,0
		State
		Trans	']',Kommentar

		State	DefConst
		Trans	'''
		Trans	'$',DefCh
		Trans	p$Decimal,Kommentar,,,SymbolValue
		State
		Trans	p$Any,,,,SymbolValue
		State
		Trans	''',Kommentar
		State	DefCh
		Trans	p$Hex,Kommentar,,,SymbolValue
;
; Und nun die Regeln, die mit dem Ende der Datei oder dem INLINE-
; Statement beendet werden:
;	 PLINE = [STATEDEF|TRANSDEF]
;
		State	ParseRules,NAME
		Trans	'STATE',DefState,,CState,Command
		Trans	'TRANS',DefTrans,,CTrans,Command
		Trans	'INLINE',Kommentar,,CCopy,Command
		Trans	p$Lambda,Kommentar
;
; STATDEF = 'STATE' [SYMBOL [',' 'NAME']]
;
		State	DefState
		Trans	p$Symbol,,,,Label
		Trans	p$Lambda,Kommentar

		State
		Trans	','
		Trans	p$Lambda,Kommentar

		State
		Trans	'NAME',Kommentar,,NameState,Flags
;
; TRANSDEF = 'TRANS' (KEY|ONEN|SUB|MODULE|NORM) [OPTIONS]
; NORM = 'P$ALPHA' | 'P$DIGIT' | 'P$STRING' | 'P$EOS' | 'P$SYMBOL' | 'P$FILE' | 
;	 'P$BLANK' | 'P$OCTAL' | 'P$LAMBDA' | 'P$HEX' | 'P$DECIMAL' | 'P$ANY' |
;	 'P$BINARY'
;
		State 	DefTrans
		Trans	!DTsub,,,fSUB,Opcode
		Trans	!DTmodule,,,fMODULE,Opcode
		Trans	!DTtext
		Trans	!DefNumber,,CheckNumber,fm_onekey,Options
		Trans	'P$ALPHA',,,fALPHA,Opcode
		Trans	'P$ANY',,,fANY,Opcode
		Trans	'P$BINARY',,,fBINARY,Opcode
		Trans	'P$BLANK',,,fBLANK,Opcode
		Trans	'P$DECIMAL',,,fDECIMAL,Opcode
		Trans	'P$DIGIT',,,fDIGIT,Opcode
		Trans	'P$FILE',,,fFILE,Opcode
		Trans	'P$EOS',,,fEOS,Opcode
		Trans	'P$HEX',,,fHEX,Opcode
		Trans	'P$LAMBDA',,,fLAMBDA,Opcode
		Trans	'P$OCTAL',,,fOCTAL,Opcode
		Trans	'P$STRING',,,fSTRING,Opcode
		Trans	'P$SYMBOL',,,fSYMBOL,Opcode
;
; OPTIONS = ',' [SYMBOL|'P$EXIT'|'P$FAIL'] [',' ACTION]
;
		State	DTlabel
		Trans	','
		Trans	p$Lambda,Kommentar
		State
		Trans	'P$EXIT',,,state_exit,LabelLen
		Trans	'P$FAIL',,,state_fail,LabelLen
		Trans	p$Symbol,,,,Label
		Trans	',',DTaction
		State
		Trans	','
		Trans	p$Lambda,Kommentar
;
; ACTION = [SYMBOL] [',' MASKE]
;
		State	DTaction
		Trans	',',DTmaske
		Trans	p$Symbol,,,,Action
		State
		Trans	',',,,fm_action,Options
		Trans	p$Lambda,Kommentar,,fm_action,Options
;
; MASKE = [SYMBOL|STRING] [',' MASKADR]
;
		State	DTmaske
		Trans	',',DTmaskadr
		Trans	p$Decimal,DTm1,,,Maske
		Trans	'$'
		Trans	p$Symbol,DTm2,,,Maske
		State
		Trans	p$Hex,,,,Maske
		State	DTm1
		Trans	p$Lambda,,,PZahl,MaskeLen
		State	DTm2
		Trans	',',,,fm_maske,Options
		Trans	p$Lambda,Kommentar,,fm_maske,Options
;
; MASKADR = [SYMBOL] [',' PARAMETER]
;
		State	DTmaskadr
		Trans	',',DTparameter
		Trans	p$Symbol,,,,Maskadr
		State
		Trans	',',,,fm_maskadr,Options
		Trans	p$Lambda,Kommentar,,fm_maskadr,Options
;
; PARAMETER = [SYMBOL|STRING] [',' 'CHECK']
;
		State	DTparameter
		Trans	',',DTcheck
		Trans	p$Decimal,DTp1,,,Parameter
		Trans	'$'
		Trans	p$Symbol,DTp2,,,Parameter
		State
		Trans	p$Hex,,,,Parameter
		State	DTp1
		Trans	p$Lambda,,,PZahl,ParameterLen
		State	DTp2
		Trans	',',,,fm_parameter,Options
		Trans	p$Lambda,Kommentar,,fm_parameter,Options
		State	DTcheck
		Trans	'CHECK',Kommentar,,fm_check,Options
;
; KEY = (KEY1|KEY2)
; KEY1 = ''' (ONE|KEY3)
; KEY2 = 'K' ''' KEY3
;
		State 	DTtext
		Trans	'''
		Trans	'K',DTtext1,,fKEY,Opcode
		State
		Trans	!DTone,p$Exit,,fm_onekey,Options
		Trans	p$Lambda,DTtext2,ClearOpcode,fKEY,Opcode
		State	DTtext1
		Trans	'''
;	
; KEY3 = SYMBOL '''
;
		State	DTtext2
		Trans	p$Symbol,DTone1,,,Key
;
; ONE = <char> '''
;
		State	DTone
		Trans	p$Any,,,,Opcode
		State	DTone1
		Trans	''',p$Exit
;
; SUB = '!' SYMBOL
;
		State	DTsub
		Trans	'!'
		State
		Trans	p$Symbol,p$Exit,,,Sub
;
; MODULE = '#' SYMBOL
;
		State	DTmodule
		Trans	'#'
		State
		Trans	p$Symbol,p$Exit,,,Module
;
; ONEN = (ONEI|ONEH)
; ONEI = INTEGER<1..255>
; ONEH = '$' HEX<01..FF>
;
		State	DefNumber
		Trans	'BLANK',p$Exit,,32,Opcode
		Trans	'CR',p$Exit,,13,Opcode
		Trans	'LF',p$Exit,,10,Opcode
		Trans	'TAB',p$Exit,,9,Opcode
		Trans	'$'
		Trans	p$Decimal,p$Exit,,,Opcode
		State
		Trans	p$Hex,p$Exit,,,Opcode
;
; Zuletzt noch die Hilfsprogramme. Sie erledigen die Aufgaben, die
; mit dieser einfachen Sprache nicht bearbeitbar sind.
;
		Inline

ClearOpcode(pcb)
PCB *pcb;
{
 pcb->pcb_Opcode = 0;
 return parse_exit;
}

CheckNumber(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_Opcode <= 0) || (pcb->pcb_Opcode > 255) )
  return parse_fail;
 return parse_exit;
}

MakeVersion(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token < 0) || (pcb->sys_pcb.pcb_token > 15) )
  return parse_fail;
 pcb->pcb_Version = (pcb->pcb_Version<<4)+pcb->sys_pcb.pcb_token;
 return parse_exit;
}

StartSet(pcb,set)
PCB *pcb;
long set;
{
 pcb->pcb_ActTable = set;
 return parse_exit;
}

GetMin(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 pcb->pcb_CharMin = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 return parse_exit;
}

GetChars(pcb,max)
register PCB *pcb;
long max;
{
 register int c0,cnt;
 register unsigned char *fill,mask;

 if ( !max )
  c0 = pcb->pcb_CharMin;
 else
  {
   c0 = pcb->pcb_CharMax;
   if ( (c0 <= 0) || (c0 > 255) ) return parse_fail;
  }
 if ( (cnt = c0-pcb->pcb_CharMin) < 0 ) return parse_fail;
 c0 = pcb->pcb_CharMin;
 pcb->pcb_CharMin = pcb->pcb_CharMax = 0;
 fill = ((unsigned char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(c0>>3);
 mask = 1<<(c0&7);
 for ( ; ; )
  {
   *fill |= mask;
   if ( !cnt-- ) return parse_exit;
   mask += mask;
   if ( !mask )
    {
     fill++;
     mask = 1;
    }  
  }
}

RemChar(pcb)
register PCB *pcb;
{
 register char *fill,bit;
 
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 bit = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 fill = ((char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(bit>>3);
 *fill &= ~(1<<(bit&7));
 return parse_exit; 
}

CheckAbbr(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token <= 0) || (pcb->sys_pcb.pcb_token > 127) )
  return parse_fail;
 return parse_exit;
}

Variable(pcb,index)
register PCB *pcb;
register long index;
{
 register long size;

 if ( !index && ((index = pcb->sys_pcb.pcb_token) < 0) ) return parse_fail;
 pcb->pcb_Command = CVariable;
 pcb->pcb_SymbolValue = pcb->pcb_Defined;
 if ( !(size = pcb->pcb_VarSize) ) size = 4;
 pcb->pcb_VarSize = size;
 pcb->pcb_VarIndex = index;
 pcb->pcb_Defined += size*index;
 return parse_exit;
}

SetClear(pcb)
register PCB *pcb;
{
 pcb->pcb_Clear = pcb->pcb_Defined;
 return parse_exit;
}
