#define PCB_INLINE
#include "ParserDef.h"

static int CheckAbbr();
static int CheckNumber();
static int ClearOpcode();
static int GetChars();
static int GetMin();
static int MakeVersion();
static int RemChar();
static int SetClear();
static int StartSet();
static int Variable();

static int (*pcb_actions[])() =
	{
	 CheckAbbr,
	 CheckNumber,
	 ClearOpcode,
	 GetChars,
	 GetMin,
	 MakeVersion,
	 RemChar,
	 SetClear,
	 StartSet,
	 Variable,
	 0
	};


extern short pcb_table[];

char *pcb_module[] =
	{
	 "ParserDef.t",
	 (char *)pcb_table,
	 (char *)0x21,
	 (char *)10,
	 (char *)pcb_actions,
	 (char *)0
	};

#define PCB struct epcb


ClearOpcode(pcb)
PCB *pcb;
{
 pcb->pcb_Opcode = 0;
 return parse_exit;
}

CheckNumber(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_Opcode <= 0) || (pcb->pcb_Opcode > 255) )
  return parse_fail;
 return parse_exit;
}

MakeVersion(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token < 0) || (pcb->sys_pcb.pcb_token > 15) )
  return parse_fail;
 pcb->pcb_Version = (pcb->pcb_Version<<4)+pcb->sys_pcb.pcb_token;
 return parse_exit;
}

StartSet(pcb,set)
PCB *pcb;
long set;
{
 pcb->pcb_ActTable = set;
 return parse_exit;
}

GetMin(pcb)
register PCB *pcb;
{
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 pcb->pcb_CharMin = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 return parse_exit;
}

GetChars(pcb,max)
register PCB *pcb;
long max;
{
 register int c0,cnt;
 register unsigned char *fill,mask;

 if ( !max )
  c0 = pcb->pcb_CharMin;
 else
  {
   c0 = pcb->pcb_CharMax;
   if ( (c0 <= 0) || (c0 > 255) ) return parse_fail;
  }
 if ( (cnt = c0-pcb->pcb_CharMin) < 0 ) return parse_fail;
 c0 = pcb->pcb_CharMin;
 pcb->pcb_CharMin = pcb->pcb_CharMax = 0;
 fill = ((unsigned char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(c0>>3);
 mask = 1<<(c0&7);
 for ( ; ; )
  {
   *fill |= mask;
   if ( !cnt-- ) return parse_exit;
   mask += mask;
   if ( !mask )
    {
     fill++;
     mask = 1;
    }  
  }
}

RemChar(pcb)
register PCB *pcb;
{
 register char *fill,bit;
 
 if ( (pcb->pcb_CharMax <= 0) || (pcb->pcb_CharMax > 255) )
  return parse_fail;
 bit = pcb->pcb_CharMax;
 pcb->pcb_CharMax = 0;
 fill = ((char *)pcb->pcb_Tables)+pcb->pcb_ActTable+(bit>>3);
 *fill &= ~(1<<(bit&7));
 return parse_exit; 
}

CheckAbbr(pcb)
register PCB *pcb;
{
 if ( (pcb->sys_pcb.pcb_token <= 0) || (pcb->sys_pcb.pcb_token > 127) )
  return parse_fail;
 return parse_exit;
}

Variable(pcb,index)
register PCB *pcb;
register long index;
{
 register long size;

 if ( !index && ((index = pcb->sys_pcb.pcb_token) < 0) ) return parse_fail;
 pcb->pcb_Command = CVariable;
 pcb->pcb_SymbolValue = pcb->pcb_Defined;
 if ( !(size = pcb->pcb_VarSize) ) size = 4;
 pcb->pcb_VarSize = size;
 pcb->pcb_VarIndex = index;
 pcb->pcb_Defined += size*index;
 return parse_exit;
}

SetClear(pcb)
register PCB *pcb;
{
 pcb->pcb_Clear = pcb->pcb_Defined;
 return parse_exit;
}

#undef PCB

short pcb_table[] =
	{
	 0x4a02,0x0000,0x0000,0x0b1e,0x0000,0x0b1e,0x2100,0x0006,
	 0x0158,0x00dc,
	 0x0002,0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xff7f,
	 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	 0x0000,0x0000,0x0000,0xff03,0xfeff,0xff07,0xfeff,0xff07,
	 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	 0x0000,0x0000,0x0000,0xff03,0xfeff,0xff07,0xfeff,0xff07,
	 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	 0x0000,0x0000,0x1000,0x0000,0xfeff,0xff87,0xfeff,0xff07,
	 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	 0x0000,0x0000,0x1000,0xff03,0xfeff,0xff87,0xfeff,0xff07,
	 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	 0x0000,0x0000,0x7aff,0xffa7,0xffff,0xffff,0xffff,0xffff,
	 0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	 0x8001,0x0002,0x001c,0x8003,0x0002,0x003e,0x8007,0x0002,
	 0x008b,0x800f,0x0002,0x01b5,0x801f,0x0002,0x0241,0x803f,
	 0x0002,0x02c9,0x0a00,0x0002,0xfffc,0x803b,0x0002,0xffff,
	 0x0b00,0x0002,0xffff,0x0a00,0x0002,0xfffc,0x0900,0x0003,
	 0x0006,0x000b,0x5645,0x5253,0x494f,0x4e00,0x0a00,0x0002,
	 0xffed,0x0a00,0x0002,0xfffc,0x0601,0x0003,0x0005,0x0005,
	 0x0a00,0x0002,0xfffc,0x802e,0x0002,0x0004,0x0a00,0x0002,
	 0xfffc,0x060d,0x0006,0xffda,0x0005,0x0000,0x0003,0x0000,
	 0x0a00,0x0002,0xfffc,0x0900,0x0003,0x0007,0x0040,0x4348,
	 0x4152,0x4143,0x5445,0x5200,0x090c,0x0006,0x0009,0x000e,
	 0x0000,0x0007,0x00dc,0x494e,0x434c,0x5544,0x4500,0x0a00,
	 0x0002,0xffbc,0x0a00,0x0002,0xfffc,0x8822,0x0003,0x000d,
	 0x00e4,0x883c,0x0003,0x0016,0x00e4,0x0d08,0x0003,0xffae,
	 0x00e8,0x0a00,0x0002,0xfffc,0x0d08,0x0003,0x0005,0x00e8,
	 0x0a00,0x0002,0xfffc,0x8022,0x0002,0xffa0,0x0a00,0x0002,
	 0xfffc,0x0d08,0x0003,0x0005,0x00e8,0x0a00,0x0002,0xfffc,
	 0x803e,0x0002,0xff93,0x0a00,0x0002,0xfffc,0x090c,0x0006,
	 0x0008,0xff8c,0x0000,0x0007,0x0000,0x5345,0x5453,0x0000,
	 0x0a00,0x0002,0xfffc,0x090c,0x0006,0x000b,0x0191,0x0001,
	 0x0000,0x0018,0x4142,0x4252,0x4556,0x4154,0x494f,0x4e00,
	 0x0900,0x0003,0x0008,0x010b,0x4445,0x4649,0x4e49,0x5449,
	 0x4f4e,0x5300,0x091f,0x0009,0x000d,0x0073,0x0008,0x0000,
	 0x00a0,0x0000,0x0020,0x0018,0x4649,0x4c45,0x4348,0x4152,
	 0x5300,0x090c,0x0006,0x0008,0x0135,0x0002,0x0000,0x0018,
	 0x464c,0x4147,0x5300,0x091f,0x0009,0x000b,0x005a,0x0008,
	 0x0000,0x0000,0x0000,0x0001,0x0018,0x4c45,0x4741,0x4c00,
	 0x090c,0x0006,0x0008,0x00e4,0x0000,0x0003,0x00dc,0x5255,
	 0x4c45,0x5300,0x091f,0x0009,0x000e,0x0043,0x0008,0x0000,
	 0x0040,0x0000,0x0004,0x0018,0x5354,0x5249,0x4e47,0x4348,
	 0x4152,0x5300,0x091f,0x0009,0x000e,0x0033,0x0008,0x0000,
	 0x0020,0x0000,0x0002,0x0018,0x5354,0x5249,0x4e47,0x5354,
	 0x4152,0x5400,0x091f,0x0009,0x000e,0x0023,0x0008,0x0000,
	 0x0080,0x0000,0x0010,0x0018,0x5359,0x4d42,0x4f4c,0x4348,
	 0x4152,0x5300,0x091f,0x0009,0x000e,0x0013,0x0008,0x0000,
	 0x0060,0x0000,0x0008,0x0018,0x5359,0x4d42,0x4f4c,0x5354,
	 0x4152,0x5400,0x0a00,0x0002,0xfef9,0x0a00,0x0002,0xfffc,
	 0x803d,0x0002,0x0004,0x0a00,0x0002,0xfffc,0x0c00,0x0012,
	 0x0002,0x0007,0x0a00,0x0002,0xfee9,0x0a00,0x0002,0xfffc,
	 0x802c,0x0002,0xfff4,0x0a00,0x0002,0xfee0,0x0a00,0x0002,
	 0xfffc,0x802d,0x0002,0x0025,0x0c01,0x002b,0x0003,0x0005,
	 0x0004,0x0a00,0x0002,0xfffc,0x802e,0x0002,0x000a,0x0a03,
	 0x0005,0xffff,0x0003,0x0000,0x0000,0x0a00,0x0002,0xfffc,
	 0x802e,0x0002,0x0004,0x0a00,0x0002,0xfffc,0x0c03,0x0011,
	 0x0005,0xffff,0x0003,0x0000,0x0001,0x0a00,0x0002,0xfffc,
	 0x0c01,0x0007,0x0003,0xffff,0x0006,0x0a00,0x0002,0xfffc,
	 0x8027,0x0002,0x0030,0x8024,0x0002,0x003a,0x090c,0x0006,
	 0x0008,0xffff,0x0000,0x0020,0x00f8,0x424c,0x414e,0x4b00,
	 0x090c,0x0006,0x0007,0xffff,0x0000,0x000d,0x00f8,0x4352,
	 0x0000,0x090c,0x0006,0x0007,0xffff,0x0000,0x000a,0x00f8,
	 0x4c46,0x0000,0x090c,0x0006,0x0007,0xffff,0x0000,0x0009,
	 0x00f8,0x5441,0x4200,0x0608,0x0003,0xffff,0x00f8,0x0a00,
	 0x0002,0xfffc,0x0008,0x0003,0x0005,0x00f8,0x0a00,0x0002,
	 0xfffc,0x8027,0x0002,0xffff,0x0a00,0x0002,0xfffc,0x0808,
	 0x0003,0xffff,0x00f8,0x0a00,0x0002,0xfffc,0x0a0c,0x0005,
	 0xfe65,0x0000,0x001f,0x0000,0x0a00,0x0002,0xfffc,0x0a0c,
	 0x0005,0xfe5c,0x0000,0x003f,0x0000,0x0a00,0x0002,0xfffc,
	 0x091c,0x0006,0x000b,0x0064,0x0001,0x0000,0x0018,0x4142,
	 0x4252,0x4556,0x4154,0x494f,0x4e00,0x0900,0x0003,0x0008,
	 0xffde,0x4445,0x4649,0x4e49,0x5449,0x4f4e,0x5300,0x091c,
	 0x0006,0x0008,0x0017,0x0002,0x0000,0x0018,0x464c,0x4147,
	 0x5300,0x090c,0x0006,0x0008,0xffd3,0x0000,0x0003,0x00dc,
	 0x5255,0x4c45,0x5300,0x0a00,0x0002,0xfe28,0x0a00,0x0002,
	 0xfffc,0x8c3d,0x0005,0x0007,0x0000,0x000f,0x0000,0x0a00,
	 0x0002,0xfffc,0x091c,0x0006,0x000c,0x0021,0x0000,0x0004,
	 0x0008,0x4341,0x5345,0x5345,0x4e53,0x4954,0x4956,0x4500,
	 0x091c,0x0006,0x000e,0x0013,0x0000,0x0001,0x0008,0x4558,
	 0x504c,0x4943,0x4954,0x424c,0x414e,0x4b49,0x4e47,0x0000,
	 0x0a00,0x0002,0xfdfb,0x0a00,0x0002,0xfffc,0x807c,0x0002,
	 0xffda,0x0a00,0x0002,0xfdf2,0x0a00,0x0002,0xfffc,0x8c3d,
	 0x0005,0x0007,0x0000,0x000f,0x0000,0x0a00,0x0002,0xfffc,
	 0x090c,0x0006,0x0009,0xfde2,0x0000,0x00ff,0x000c,0x554e,
	 0x4951,0x5545,0x0000,0x090c,0x0006,0x0007,0xfdd7,0x0000,
	 0x00fe,0x000c,0x414e,0x5900,0x0609,0x0004,0xfdcf,0x0000,
	 0x000c,0x0a00,0x0002,0xfdca,0x0a00,0x0002,0xfffc,0x091d,
	 0x0007,0x0009,0xfdc3,0x0007,0x0004,0x0000,0x0018,0x434c,
	 0x4541,0x5200,0x090c,0x0006,0x000b,0x003a,0x0000,0x0008,
	 0x0150,0x4445,0x5343,0x5249,0x5054,0x4f52,0x0000,0x090c,
	 0x0006,0x0008,0x002d,0x0000,0x0004,0x0150,0x4c4f,0x4e47,
	 0x0000,0x090c,0x0006,0x0008,0xff43,0x0000,0x0003,0x00dc,
	 0x5255,0x4c45,0x5300,0x0408,0x0003,0x0008,0x00fc,0x0a00,
	 0x0002,0xfd94,0x0a00,0x0002,0xfffc,0x8c3d,0x0005,0x0032,
	 0x0000,0x0004,0x00dc,0x805b,0x0002,0x001d,0x0a03,0x0005,
	 0xfd85,0x0009,0x0000,0x0001,0x0a00,0x0002,0xfffc,0x0408,
	 0x0003,0x0005,0x00fc,0x0a00,0x0002,0xfffc,0x805b,0x0002,
	 0x000a,0x0a03,0x0005,0xfd72,0x0009,0x0000,0x0001,0x0a00,
	 0x0002,0xfffc,0x0603,0x0005,0x0007,0x0009,0x0000,0x0000,
	 0x0a00,0x0002,0xfffc,0x805d,0x0002,0xfd60,0x0a00,0x0002,
	 0xfffc,0x8027,0x0002,0x000b,0x8024,0x0002,0x0015,0x0608,
	 0x0003,0xfd54,0x0104,0x0a00,0x0002,0xfffc,0x0008,0x0003,
	 0x0005,0x0104,0x0a00,0x0002,0xfffc,0x8027,0x0002,0xfd46,
	 0x0a00,0x0002,0xfffc,0x0808,0x0003,0xfd40,0x0104,0x0a00,
	 0x0002,0xfffc,0x090c,0x0006,0x0008,0x0022,0x0000,0x0001,
	 0x00dc,0x5354,0x4154,0x4500,0x090c,0x0006,0x0008,0x0038,
	 0x0000,0x0002,0x00dc,0x5452,0x414e,0x5300,0x090c,0x0006,
	 0x0009,0xfd24,0x0000,0x0006,0x00dc,0x494e,0x4c49,0x4e45,
	 0x0000,0x0a00,0x0002,0xfd1a,0x0a00,0x0002,0xfffc,0x0408,
	 0x0003,0x0008,0x0110,0x0a00,0x0002,0xfd10,0x0a00,0x0002,
	 0xfffc,0x802c,0x0002,0x0007,0x0a00,0x0002,0xfd07,0x0a00,
	 0x0002,0xfffc,0x090c,0x0006,0x0008,0xfd00,0x0000,0x0001,
	 0x00e0,0x4e41,0x4d45,0x0000,0x0a00,0x0002,0xfffc,0x0c0c,
	 0x01b5,0x0005,0x00ab,0x0000,0x000c,0x010c,0x0c0c,0x01bb,
	 0x0005,0x00a4,0x0000,0x000e,0x010c,0x0c00,0x0170,0x0002,
	 0x009d,0x0c0d,0x01bd,0x0006,0x0099,0x0001,0x0000,0x0080,
	 0x0108,0x090c,0x0006,0x0009,0x0091,0x0000,0x0001,0x010c,
	 0x5024,0x414c,0x5048,0x4100,0x090c,0x0006,0x0008,0x0086,
	 0x0000,0x0000,0x010c,0x5024,0x414e,0x5900,0x090c,0x0006,
	 0x000a,0x007c,0x0000,0x000f,0x010c,0x5024,0x4249,0x4e41,
	 0x5259,0x0000,0x090c,0x0006,0x0009,0x0070,0x0000,0x0005,
	 0x010c,0x5024,0x424c,0x414e,0x4b00,0x090c,0x0006,0x000a,
	 0x0065,0x0000,0x0006,0x010c,0x5024,0x4445,0x4349,0x4d41,
	 0x4c00,0x090c,0x0006,0x0009,0x0059,0x0000,0x0002,0x010c,
	 0x5024,0x4449,0x4749,0x5400,0x090c,0x0006,0x0009,0x004e,
	 0x0000,0x000d,0x010c,0x5024,0x4649,0x4c45,0x0000,0x090c,
	 0x0006,0x0008,0x0043,0x0000,0x000b,0x010c,0x5024,0x454f,
	 0x5300,0x090c,0x0006,0x0008,0x0039,0x0000,0x0008,0x010c,
	 0x5024,0x4845,0x5800,0x090c,0x0006,0x000a,0x002f,0x0000,
	 0x000a,0x010c,0x5024,0x4c41,0x4d42,0x4441,0x0000,0x090c,
	 0x0006,0x0009,0x0023,0x0000,0x0007,0x010c,0x5024,0x4f43,
	 0x5441,0x4c00,0x090c,0x0006,0x000a,0x0018,0x0000,0x0003,
	 0x010c,0x5024,0x5354,0x5249,0x4e47,0x0000,0x090c,0x0006,
	 0x000a,0x000c,0x0000,0x0004,0x010c,0x5024,0x5359,0x4d42,
	 0x4f4c,0x0000,0x0a00,0x0002,0xfffc,0x802c,0x0002,0x0007,
	 0x0a00,0x0002,0xfc43,0x0a00,0x0002,0xfffc,0x090c,0x0006,
	 0x0009,0x001d,0xffff,0xffff,0x0114,0x5024,0x4558,0x4954,
	 0x0000,0x090c,0x0006,0x0009,0x0012,0xffff,0xfffc,0x0114,
	 0x5024,0x4641,0x494c,0x0000,0x0408,0x0003,0x0008,0x0110,
	 0x802c,0x0002,0x000d,0x0a00,0x0002,0xfffc,0x802c,0x0002,
	 0x0007,0x0a00,0x0002,0xfc1a,0x0a00,0x0002,0xfffc,0x802c,
	 0x0002,0x0017,0x0408,0x0003,0x0005,0x0130,0x0a00,0x0002,
	 0xfffc,0x8c2c,0x0005,0x000d,0x0000,0x0001,0x0108,0x0a0c,
	 0x0005,0xfc04,0x0000,0x0001,0x0108,0x0a00,0x0002,0xfffc,
	 0x802c,0x0002,0x002e,0x0608,0x0003,0x0013,0x0140,0x8024,
	 0x0002,0x0008,0x0408,0x0003,0x0015,0x0140,0x0a00,0x0002,
	 0xfffc,0x0808,0x0003,0x0005,0x0140,0x0a00,0x0002,0xfffc,
	 0x0a0c,0x0005,0x0007,0xffff,0xffff,0x0144,0x0a00,0x0002,
	 0xfffc,0x8c2c,0x0005,0x000d,0x0000,0x0004,0x0108,0x0a0c,
	 0x0005,0xfbd4,0x0000,0x0004,0x0108,0x0a00,0x0002,0xfffc,
	 0x802c,0x0002,0x0017,0x0408,0x0003,0x0005,0x0148,0x0a00,
	 0x0002,0xfffc,0x8c2c,0x0005,0x000d,0x0000,0x0008,0x0108,
	 0x0a0c,0x0005,0xfbbb,0x0000,0x0008,0x0108,0x0a00,0x0002,
	 0xfffc,0x802c,0x0002,0x002e,0x0608,0x0003,0x0013,0x0138,
	 0x8024,0x0002,0x0008,0x0408,0x0003,0x0015,0x0138,0x0a00,
	 0x0002,0xfffc,0x0808,0x0003,0x0005,0x0138,0x0a00,0x0002,
	 0xfffc,0x0a0c,0x0005,0x0007,0xffff,0xffff,0x013c,0x0a00,
	 0x0002,0xfffc,0x8c2c,0x0005,0x000d,0x0000,0x0002,0x0108,
	 0x0a0c,0x0005,0xfb8b,0x0000,0x0002,0x0108,0x0a00,0x0002,
	 0xfffc,0x090c,0x0006,0x0008,0xfb81,0x0000,0x0010,0x0108,
	 0x4348,0x4543,0x4b00,0x0a00,0x0002,0xfffc,0x8027,0x0002,
	 0x000a,0x8c4b,0x0005,0x0018,0x0000,0x0009,0x010c,0x0a00,
	 0x0002,0xfffc,0x0c0c,0x001d,0x0005,0xffff,0x0000,0x0080,
	 0x0108,0x0a0d,0x0006,0x000e,0x0002,0x0000,0x0009,0x010c,
	 0x0a00,0x0002,0xfffc,0x8027,0x0002,0x0004,0x0a00,0x0002,
	 0xfffc,0x0408,0x0003,0x000c,0x0118,0x0a00,0x0002,0xfffc,
	 0x0008,0x0003,0x0005,0x010c,0x0a00,0x0002,0xfffc,0x8027,
	 0x0002,0xffff,0x0a00,0x0002,0xfffc,0x8021,0x0002,0x0004,
	 0x0a00,0x0002,0xfffc,0x0408,0x0003,0xffff,0x0120,0x0a00,
	 0x0002,0xfffc,0x8023,0x0002,0x0004,0x0a00,0x0002,0xfffc,
	 0x0408,0x0003,0xffff,0x0128,0x0a00,0x0002,0xfffc,0x090c,
	 0x0006,0x0008,0xffff,0x0000,0x0020,0x010c,0x424c,0x414e,
	 0x4b00,0x090c,0x0006,0x0007,0xffff,0x0000,0x000d,0x010c,
	 0x4352,0x0000,0x090c,0x0006,0x0007,0xffff,0x0000,0x000a,
	 0x010c,0x4c46,0x0000,0x090c,0x0006,0x0007,0xffff,0x0000,
	 0x0009,0x010c,0x5441,0x4200,0x8024,0x0002,0x0008,0x0608,
	 0x0003,0xffff,0x010c,0x0a00,0x0002,0xfffc,0x0808,0x0003,
	 0xffff,0x010c,0x0a00,0x0002,0xfffc
	};
