#define PCB_INLINE
#include <stdio.h>
#ifdef PORTIT
#include "PortIt.h"
#else
#include "ParserDef.h"
#endif

#ifndef MCH_AMIGA 
#define movmem(a,b,n)	memcpy(b,a,n)
#define setmem(a,n,v)	memset(a,v,n)
#endif

#ifndef TABLEDIR
#ifdef MCH_AMIGA
#define TABLEDIR	"UTables:"
#else
#ifdef vms
#define TABLEDIR        "Parser$Tables:"
#else
#define TABLEDIR	"/usr/tables/"
#endif
#endif
#endif

#define MY_MAGIC	0x4a02

struct table_header
       {
	short          th_magic;
	long           th_total;
	long           th_debug;
	unsigned char  th_version;
	unsigned char  th_flags;
	unsigned char  th_abbr;
	unsigned char  th_tabs;
	unsigned short th_size;	
	unsigned short th_clear;	
       };

struct inmem_table
       {
	char 		    *name;
	int		    users;
	struct table_header header;
 	int		    tsize;
	char		    *table;
       };

static int inmem_alloc = 0;
static struct inmem_table **inmem_tabs = 0;

char *pcb_ctab;

static struct inmem_table *alloc_inmem(size,at)
int size,*at;
{
 struct inmem_table **newt;
 char *malloc();
 int ix;

 for ( ix = 0 ; (ix < inmem_alloc) && inmem_tabs[ix] ; ix++ );
 if ( ix == inmem_alloc )
  {
   if ( !(newt = (struct inmem_table **)malloc((ix+10)*sizeof(*newt))) )
    return 0;
   if ( inmem_tabs )
    {
     movmem((char *)inmem_tabs,(char *)newt,ix*sizeof(*newt));
     free(inmem_tabs);
    }
   inmem_tabs = newt;
   inmem_alloc = ix+10;
   setmem(newt+ix,10*sizeof(*newt),0);
  }
 *at = ix;
 if ( (inmem_tabs[ix] = (struct inmem_table *)malloc(sizeof(**newt))) && 
      (inmem_tabs[ix]->tsize = size) &&
      !(inmem_tabs[ix]->table = malloc(size)) )
  {
   free(inmem_tabs[ix]);
   inmem_tabs[ix] = 0;
  }
 return inmem_tabs[ix];
}

static struct inmem_table *find_inmem(name)
char *name;
{
 int ix;

 for ( ix = inmem_alloc ; ix-- ; )
  if ( inmem_tabs[ix] && !strcmp(name,inmem_tabs[ix]->name) )
   return inmem_tabs[ix];
 return 0;
}

char *parse_error(code)
int code;
{
 static char chelp[40];

 switch (code)
  {
   case parse_exit  : return "kein Fehler";
   case parse_fail  : return "Syntaxfehler";
   case parse_table : return "Parsertabelle korrupt";
   case parse_check : return "Option mehrfach verwendet";
   case parse_abbr  : return "Abkuerzung nicht eindeutig";
   default	    : sprintf(chelp,"Parserfehler %d",code);
   		      return chelp;
  }
}

struct pcb *getpcb(modules)
char **modules;
{
 char *malloc(),*temp,*scan,*ctab = 0;
 FILE *tab = 0,*fopen();
 struct pcb *pcb = 0,*loadpcb();
 struct inmem_table *res = 0;
 int ix,size;
 
 if ( !(ctab = modules[1]) && !(res = find_inmem(modules[0])) )
  if ( !(temp = malloc(strlen(modules[0])+sizeof(PSUFFIX)-1+sizeof(TABLEDIR))) )
   tab = fopen(modules[0],"r");
  else
   {
    for ( scan = modules[0] ; *scan && (*scan != ':') && (*scan != '/') ; scan++ );
    if ( !*scan )
     {
      strcpy(temp,TABLEDIR);
      strcat(temp,modules[0]);
      if ( !(tab = fopen(temp,"r")) )
       {
        strcat(temp,PSUFFIX);
        tab = fopen(temp,"r");
       }
     }
    if ( !tab && !(tab = fopen(modules[0],"r")) )
     {
      strcpy(temp,modules[0]);
      strcat(temp,PSUFFIX);
      tab = fopen(temp,"r");
     }
    free(temp);
   }
 if ( !ctab && !tab && !res ) return 0;
 pcb = loadpcb(res,ctab ? &ctab : (char **)tab,modules,!ctab);
 if ( tab ) fclose(tab);
 if ( pcb && (pcb->pcb_nmodules = (int)modules[5]) )
  {
   size = sizeof(pcb->pcb_modules[0])*pcb->pcb_nmodules;
   if ( !(pcb->pcb_modules = (struct pcb **)malloc(size)) )
    {
     freepcb(pcb);
     return 0;
    }
   setmem(pcb->pcb_modules,size,0);
   for ( ix = 0 ; ix < pcb->pcb_nmodules ; ix++ )
    if ( !(pcb->pcb_modules[ix] = getpcb(modules[6+ix])) )
     {
      freepcb(pcb);
      return 0;
     }
  }
 pcb_ctab = ctab;
 return pcb;
}

static readh(buf,idlen,ids,tab)
char *buf,**tab;
int idlen,ids;
{
 int len = idlen*ids;

 bcopy(*tab,buf,len);
 *tab += len;
 return len;
}

static readt(buf,idlen,ids,tab)
char *buf,**tab;
int idlen,ids;
{
 int len = idlen*ids;

 *tab += len;
 return len;
}

struct pcb *loadpcb(res,tab,module,file)
struct inmem_table *res;
char **tab,**module;
int file;
{
 struct table_header temp;
 struct pcb *pcb = 0;
 char *malloc();
 int fsize,at;

 if ( !res )
  {
   if ( !file )
    {
     bcopy(*tab,&temp,sizeof(temp));
     *tab += sizeof(temp); 
    }
   else if ( fread(&temp,1,sizeof(temp),(FILE *)tab) != sizeof(temp) )
    return 0;
   fsize = temp.th_total-sizeof(temp);
   if ( !(res = alloc_inmem(file ? fsize : 0,&at)) ) return 0;
   res->name = module[0];
   res->users = 0;
   res->header = temp;
   if ( !file )
    {
     res->table = *tab;
     *tab += fsize;
    }
   else if ( fread(res->table,1,fsize,(FILE *)tab) != fsize )
    {
     inmem_tabs[at] = 0;     
     free(res->table);
     free(res);
     return 0;
    }
  }
 if ( (res->header.th_magic == MY_MAGIC) &&
      (res->header.th_version == (int)module[2]) &&
      (pcb = (struct pcb *)malloc(sizeof(*pcb)+res->header.th_size)) )
  {
   pcb->pcb_flags = res->header.th_flags;
   pcb->pcb_abbr = res->header.th_abbr;
   pcb->pcb_table1 = res->table;
   pcb->pcb_table2 = pcb->pcb_table1+32*res->header.th_tabs;
   if ( pcb->pcb_debug = (res->header.th_total-res->header.th_debug) )
    pcb->pcb_table3 = pcb->pcb_table1+res->header.th_debug-sizeof(res->header);
   else
    pcb->pcb_table3 = 0;
   setmem(pcb+1,(int)res->header.th_size,0);
   pcb->pcb_nclear = res->header.th_size-res->header.th_clear;
   pcb->pcb_clear = (char *)(pcb+1)+res->header.th_clear;
   if ( pcb->pcb_nactions = (int)module[3] )
    pcb->pcb_actions = (int (**)())module[4];
   else
    pcb->pcb_actions = 0;
  }
 else if ( !res->users )
  {
   inmem_tabs[at] = 0;
   if ( res->tsize ) free(res->table);
   free(res);
  }
 if ( pcb ) res->users++;
 return pcb;
}

freepcb(pcb)
struct pcb *pcb;
{
 struct pcb **subpcb;
 struct inmem_table *this;
 int ix;

 if ( pcb->pcb_nmodules && (subpcb = pcb->pcb_modules) )
  while ( pcb->pcb_nmodules-- && *subpcb++ ) freepcb(subpcb[-1]);
 for ( ix = inmem_alloc ; ix-- ; )
  if ( (this = inmem_tabs[ix]) && (this->table == pcb->pcb_table1) )
   break;
 if ( (ix >= 0) && !--this->users )
  {
   inmem_tabs[ix] = 0;
   if ( this->tsize ) free(this->table);
   free(this);
  }
 free(pcb);
}

parse(pcb,line)
struct pcb *pcb;
char *line;
{
 setmem(pcb->pcb_clear,pcb->pcb_nclear,0);
 pcb->pcb_line = line;
 return ParseTable(pcb,pcb->pcb_table2);
}

static long peekl(ad)
unsigned short *ad;
{
 return (ad[0]<<16L)+ad[1];
}

static ParseTable(pcb,tab)
struct pcb *pcb;
char *tab;
{
 char *line,*key,*start,flags,*more,*next,*done;
 unsigned long value,temp1,temp2;
 struct descriptor *desc;
 long result,base,*mask;
 unsigned char cur;
 struct pcb *mod;
 char opcode;
 short off;

 line = pcb->pcb_line;
 for ( ; ; )
  {
   if ( !(pcb->pcb_flags&pcbm_blanks) )
    while ( (*line == ' ') || (*line == '\t') )
     line++;
   pcb->pcb_line = line;
   result = parse_fail;
   if ( (opcode = *tab++) < 0 )
    {
     flags = opcode;
     if ( cur = *line )
      {
       if ( !(pcb->pcb_flags&pcbm_case) && (cur >= 'a') && (cur <= 'z') )
        cur += 'A'-'a';
       if ( cur == *tab )
	{
	 line++;
	 result = parse_exit;
	 pcb->pcb_token = cur;
	}
      }
     tab++;
    }
   else
    {
     flags = *tab++;
     base = 0;
     more = (start = pcb->pcb_table1+pcb_symstart)+32;
     switch (opcode)
      {
       case fANY     : start = pcb->pcb_table1+pcb_chars;
		       if ( (cur = *line) && (start[cur>>3]&(1<<(cur&7))) )
			{
			 line++;
			 result = parse_exit;
			 pcb->pcb_token = cur;
			}
		       break;
       case fALPHA   : if ( (cur = *line) && 
			    (((cur >= 'A') && (cur <= 'Z')) ||
		      	     ((cur >= 'a') && (cur <= 'z'))) )
			{
			 line++;
			 result = parse_exit;
			 pcb->pcb_token = cur;
			}
		       break;
       case fDIGIT   : if ( (cur = *line) && (cur >= '0') && (cur <= '9') )
			{
			 line++;
			 result = parse_exit;
			 pcb->pcb_token = cur;
			}
     		       break;
       case fBLANK   : while ( cur = *line )
     		        {
		         if ( (cur != 32) && (cur != 9) ) break;
		         line++;
		         result = parse_exit;
		        }
		       break;
       case fFILE    : more = (start += 128);
       case fSTRING  : start -= 64;
     		       more -= 64;
       case fSYMBOL  : pcb->pcb_token = (long)line;
		       while ((cur = *line) && (start[cur>>3]&(1<<(cur&7))))
		        {
		         line++;
		         result = parse_exit;
		         start = more;
		        }
		       break;
       case fHEX     : base += 6;
       case fDECIMAL : base += 2;
       case fOCTAL   : base += 6;
       case fBINARY  : base += 2;
     		       value = 0;
		       while ( (cur = *line) && (cur >= '0') )
		        {
		         if ( cur <= '9' )
		          cur += 0-'0';
		         else if ( cur >= 'a' )
		          cur += 10-'a';
		         else if ( cur >= 'A' )
		          cur += 10-'A';
		         if ( cur >= base ) break;
		         line++;
		         result = parse_exit;
		         temp1 = base*(value>>16);
		         temp2 = base*(unsigned short)value+cur;
		         value = (temp1<<16)+temp2;
		         if ( (temp1+(temp2>>16)) >= 0x10000 )
		          {
			   result = parse_fail;
			   break;
			  }
		        }
		       pcb->pcb_token = value;
		       break;
       case fKEY     : key = tab+(*((short *)tab))*2L;
		       pcb->pcb_token = (long)line;
     		       value = 1;
		       while ((cur = *line) && (start[cur>>3]&(1<<(cur&7))))
		        {
		         if ( !(pcb->pcb_flags&pcbm_case) &&
			      (cur >= 'a') && (cur <= 'z') )
			  cur += 'A'-'a';
		         if ( cur != *key )
		          {
		           value = 0;
		           break;
			  }
		         line++;
		         key++;
		         start = more;
		        }
		       if ( value && (pcb->pcb_token != (long)line) )
		        if ( (cur = pcb->pcb_abbr) == pcbm_abbruni )
		         {
			  next = tab;
			  tab += 2+((short *)tab)[1]*2L;
			  while ( (cur = *tab++) != fKEY )
			   {
			    if ( cur != fSUB )
			     { 
			      result = parse_exit;
			      break;
			     }
			    tab += 1+*(short *)(tab+1);
			   }
			  if ( result == parse_fail )
			   {
			    result = parse_abbr;
			    start = pcb->pcb_table1+pcb_symstart;
			    key = (char *)pcb->pcb_token;
		            tab += 1+(*((short *)(tab+1)))*2L;
			    while ( (cur = *key++) &&
				    (start[cur>>3]&(1<<(cur&7))) )
		      	     {
		              if ( !(pcb->pcb_flags&pcbm_case) &&
			           (cur >= 'a') && (cur <= 'z') )
			       cur += 'A'-'a';
		       	      if ( cur != *tab++ )
			       {
			        result = parse_exit;
			        break;
			       }
			      start = more;
			     }
			   }
			  tab = next;
			 }
			else if ( (cur == pcbm_abbrany) ||
 			          ((((long)line-pcb->pcb_token) >= cur) &&
				   (cur || !*key)) )
			 result = parse_exit;
		       tab += 2;
		       break;
       case fEOS     : if ( *line ) break;
       case fLAMBDA  : result = parse_exit;
		       break;
       case fSUB     : pcb->pcb_token = (long)line;
		       key = pcb->pcb_line;
       		       off = *((short *)tab)++;
     		       result = ParseTable(pcb,tab-2+off*2L);
		       line = pcb->pcb_line;
		       pcb->pcb_line = key;
		       break;
       case fMODULE  : pcb->pcb_token = (long)line;
       		       off = *((short *)tab)++;
		       if ( (off >= 0) && (off < pcb->pcb_nmodules) )
			{
			 result = parse(mod = pcb->pcb_modules[off],line);
			 line = mod->pcb_line;
		         break;
			}
       default	     : return parse_table;
      }
    }
   next = tab;
   done = (tab += 2);
   tab += 2;
   if ( result == parse_exit )
    if ( flags&fm_action )
     {
      key = pcb->pcb_line;
      pcb->pcb_line = line;
      off = *((short *)tab)++;
      if ( (off < 0) || (off >= pcb->pcb_nactions) ) return parse_table;
      value = (flags&fm_parameter) ? peekl(((long *)tab)++) : 0L;
      if ( flags&fm_pvar ) value += (long)(pcb+1);   
      if ( opcode != fMODULE ) mod = 0;
      result = (*pcb->pcb_actions[off])(pcb,value,mod);
      line = pcb->pcb_line;
      pcb->pcb_line = key;
     }
    else if ( flags&fm_parameter )
     tab += 4;
   if ( result != parse_exit )
    {
     if ( result != parse_fail ) return result;
     tab = next+((*((short *)next))*2L);
     line = pcb->pcb_line;
     continue;
    }
   if ( flags&fm_maske )
    {
     value = peekl(((long *)tab)++);
     if ( flags&fm_mvar ) value += sizeof(*pcb);
     if ( flags&fm_maskadr )
      {
       mask = (long *)((char *)(pcb+1)+*((short *)tab)++);
       if ( (flags&fm_check) && (*mask&value) ) return parse_check;
       *mask |= value;
      }
    }
   else if ( flags&fm_maskadr )
    {
     desc = (struct descriptor *)((char *)(pcb+1)+*((short *)tab)++);
     desc->text = (char *)pcb->pcb_token;
     switch (opcode)
      {
       case fSUB    :
       case fMODULE :
       case fSTRING :
       case fSYMBOL :
       case fKEY    :
       case fFILE   : desc->len = line-desc->text;
      }
    }
   switch (off = *((short *)done))
    {
     case state_exit : pcb->pcb_line = line;
		       return parse_exit;
     case state_fail : return parse_fail;
     default	     : tab = done+off*2L;
    }
  }
}
