#include <stdio.h>
#ifdef PORTIT
#include "PortIt.h"
#else
#include "ParserDef.h"
#endif

/*
  Projekt
*/
#ifndef DIRDEF
# define DIRDEF		"saphir"
#endif

/*
  Directories
*/
#ifdef vms
# ifndef INCDEF
#  define INCDEF	"sunrpc$dir:[saphir.modules]"
# endif
#else
# ifndef INCDEF
#  define INCDEF	"/modules/"
# endif
#endif

#define VERSION		"Parser Table Generator 2.2 by JMS 1990"
#define VERSION_MAGIC	0x4a02

/*
*/
extern char *optarg,*getargs_error();
extern int opterr;

#define USAGE "eingabe [ausgabe] [-?savcmdxtV] [-fli maxfehler listing ident]"

FILE *src = 0,*tab = 0,*inc = 0,*exe = 0,*lst = 0,*fopen();
int err,maxerr = 10,lstates = 0,lacts = 0,lvars = 0,lcons = 0,lmach = 0,verbose = 0;
int lext = 0,debugging = 0,inline = 1;
struct epcb *pcb;
char *ident = "",*outname = 0;

char *malloc(),*makename();

/*
*/
main(argc,argv)
int argc;
char **argv;
{
 char *inname = 0,*incname = 0,*listname = 0,*exename = 0;
 int done,len;
 struct epcb *getpcb();

 for ( done = 0 ; !done ; )
  switch (getargs(argc,argv,"f:l:i:savcmdxtV?!12"))
   {
    case 's' : lstates = 1;
	       break;
    case 'a' : lacts = 1;
	       break;
    case 'v' : lvars = 1;
	       break;
    case 'c' : lcons = 1;
	       break;
    case 'm' : lmach = 1;
	       break;
    case 'x' : lext = 1;
	       break;
    case 'd' : debugging = 1;
	       break;
    case 'V' : verbose = 1;
      	       break;
    case '1' : if ( ((len = strlen(inname = optarg)) >= 2) &&
       		    (inname[len-2] == '.') && (inname[len-1] == 'p') )
    		len -= 2;
    	       break;
    case '2' : outname = optarg;
    	       break;
    case 'l' : listname = optarg;
    	       break;
    case 'f' : maxerr = atoi(optarg);
    	       break;
    case 'i' : ident = optarg;
    	       break;
    case 't' : inline = 0;
	       break;
    case EOF : done = 1;
	       if ( inname ) break;
    case '?' : fprintf(stderr,"Aufruf: %s %s\n",*argv,USAGE);
    	       fail(1);
    	       break;
   }
 if ( opterr )
  {
   fprintf(stderr,"Fehler in Befehlszeile: %s\n",getargs_error());
   fail(2);
  }
 if ( !outname ) outname = makename(inname,len,PSUFFIX,sizeof(PSUFFIX)-1);
 incname = makename(inname,len,".h",2);
 exename = makename(inname,len,".c",2);
 if ( !(src = fopen(inname,"r")) )
  {
   fprintf(stderr,"Eingabedatei '%s' nicht gefunden\n",inname);
   fail(2);
  }
 if ( !inline && !(tab = fopen(outname,"w")) )
  {
   fprintf(stderr,"Tabelle '%s' kann nicht erzeugt werden\n",outname);
   fail(2);
  }
 if ( !(exe = fopen(exename,"w")) )
  {
   fprintf(stderr,"C-Datei '%s' kann nicht erzeugt werden\n",exename);
   fail(2);
  }
 if ( !(inc = fopen(incname,"w")) )
  {
   fprintf(stderr,"Headerdatei '%s' kann nicht erzeugt werden\n",incname);
   fail(2);
  }
 if ( listname ) lst = fopen(listname,"w");
 if ( !(pcb = getpcb(pcb_module)) )
  {
   fprintf(stderr,"Parsertabelle '%s' nicht gefunden\n",*pcb_module);
   fail(2);
  }
 if ( verbose ) puts(VERSION);
 if ( lst ) fprintf(lst,"\n%s\n\n",VERSION);
 fprintf(exe,"#define PCB%s_INLINE\n",ident);
 fprintf(exe,"#include \"%s\"\n\n",incname);
 compile();
 generate();
 fail(0);
}

fail(code)
int code;
{
 if ( pcb ) freepcb(pcb);
 if ( lst ) fclose(lst);
 if ( inc ) fclose(inc);
 if ( exe ) fclose(exe);
 if ( tab ) fclose(tab);
 if ( src ) fclose(src);
 exit(code);
}

nomem(code)
int code;
{
 fprintf(stderr,"Kein Speicher mehr vorhanden\n");
 fail(code);
}

static char *makename(head,hlen,tail,code)
char *head,*tail;
int hlen,code;
{
 char *ns;

 if ( !(ns = malloc(hlen+strlen(tail)+1)) ) nomem(code);
 strncpy(ns,head,hlen);
 strcpy(ns+hlen,tail);
 return ns;
}

/*
*/
struct chunk
       {
        struct chunk *next;
	long	     offset;
	int 	     size;
	char 	     *data;
       };
#define CHUNK		1024

struct ref
       {
	struct ref *next;
	short      *patch;
	long	   pos;
       };

struct defined
       {
	struct defined *next;
	char	       *name;
	long	       value;
	int	       flags;
	struct ref     *refs;
       };

struct chunk *code = 0,*last = (struct chunk *)&code;
struct defined *vars = 0,*cons = 0,*acts = 0,*states = 0,*modules = 0;
struct defined *find(),*alldef();
struct ref *tonext = 0;
long cpos = 0,dsize = 0;
int line = 0,hasstate = 0,doref = 0;

#define add_short(s)	add_item((char *)0,(int)(s))


compile()
{
 char in[256],buf[1024],*cur,*dst,keep,kbuf[2],*ns,*parse_error();
 int blen,res,i,len,incok = 0,acnt,mcnt;
 struct defined *rout,*scan,*turn();
 struct ref *what;

 pcb->pcb_FirstChar = '\001';
 for ( blen = err = 0, cur = buf, dst = in ; err <= maxerr ; )
  {
   if ( dst == in ) *dst++ = pcb->pcb_FirstChar;
   if ( (cur == buf+blen) &&
        ((blen = fread(cur = buf,1,sizeof(buf),src)) <= 0) )
    break;
   while ( (dst < in+sizeof(in)-1) && ((*dst++ = *cur++) != '\n') &&
	   (cur < buf+blen) );
   if ( dst[-1] != '\n' )
    {
     if ( dst != in+sizeof(in)-1 ) continue;
     fprintf(stderr,"%5d: Eingabezeile ist zu lang\n",line+1);
     exit(3);
    }
   dst[-1] = '\0';
   dst = in;
   line++;
   if ( lst ) fprintf(lst,"%6d: %s\n",line,in+1);
   if ( res = parse(pcb,in) )
    {
     i = pcb->sys_pcb.pcb_line-in;
     in[i+!(kbuf[0] = in[i])] = '\0';
     kbuf[1] = '\0';
     fprintf(stderr,"%5d: %s<<%s>>%s%s\n",line,in+1,
		    parse_error(res),kbuf,pcb->sys_pcb.pcb_line+1);
     if ( lst ) fprintf(lst,"%6d: %s\n",line,parse_error(res));
     err++;
     continue;
    }
   if ( pcb->pcb_Command == CCopy ) break;
   switch (pcb->pcb_Command)
    {
     case CState    : dostate((char *)pcb->pcb_Label,
			      (int)pcb->pcb_LabelLen,
			      (pcb->pcb_Flags&NameState) != 0);
     		      hasstate = 1;
      		      break;
     case CTrans    : dotrans((int)pcb->pcb_Opcode,
     			      (int)pcb->pcb_Options,
     			      pcb->pcb_Key.text,
     			      (int)pcb->pcb_Key.len,
     			      pcb->pcb_Sub.text,
     			      (int)pcb->pcb_Sub.len,
     			      pcb->pcb_Module.text,
     			      (int)pcb->pcb_Module.len,
     			      pcb->pcb_Action.text,
     			      (int)pcb->pcb_Action.len,
     			      (char *)pcb->pcb_Parameter,
     			      (int)pcb->pcb_ParameterLen,
     			      (char *)pcb->pcb_Maske,
     			      (int)pcb->pcb_MaskeLen,
     			      pcb->pcb_Maskadr.text,
     			      (int)pcb->pcb_Maskadr.len,
     			      (char *)pcb->pcb_Label,
     			      (int)pcb->pcb_LabelLen);
     		      break;
     case CHeader   : break;
     case CVariable : 
     case CConst    : if ( !incok )
		       {
			fprintf(inc,"\nstruct epcb%s\n\t{\n",ident);
			fprintf(inc,"\t struct pcb sys_pcb;\n");
			incok = 1;
		       }
		      dodefine(pcb->pcb_Command == CConst,
			       pcb->pcb_SymbolName.text,
     			       (int)pcb->pcb_SymbolName.len,
     			       (long)pcb->pcb_SymbolValue,
			       (int)pcb->pcb_VarSize,
     			       (int)pcb->pcb_VarIndex);
     		      break;
     case CInclude  : if ( !(keep = pcb->pcb_InclStart) ) keep = '\"';
		      ns = makename(pcb->pcb_InclName.text,
				    (int)pcb->pcb_InclName.len,"",3);
		      fprintf(inc,"#include %c%s",keep,ns);
		      free(ns);
		      if ( keep == '<' ) keep = '>';
		      fprintf(inc,"%c\n",keep);
		      break;
    }
  }
 if ( !hasstate )
  {
   fprintf(stderr,"Keine Zustaende gefunden\n");
   fail(3);
  }
 for ( scan = states ; scan ; scan = scan->next )
  if ( scan->value == -1 )
   {
    fprintf(stderr,"Zustand '%s' nicht definiert\n",scan->name);
    err++;
   } 
 if ( tonext )
  {
   fprintf(stderr,"Uebergang auf nicht definierten naechsten Zustand\n");
   fail(3);
  }
 for ( rout = acts, acnt = 0 ; rout ; rout = rout->next )
  {
   for ( ; what = rout->refs ; rout->refs = what->next, free(what) )
    *what->patch = acnt;
   rout->value = acnt++;
   fprintf(exe,"static int %s();\n",rout->name);
  }
 fprintf(exe,"\nstatic int (*pcb%s_actions[])() =\n\t{",ident);
 for ( rout = acts ; rout ; rout = rout->next )
  fprintf(exe,"\n\t %s,",rout->name);
 fprintf(exe,"\n\t 0\n\t};\n\n");
 for ( rout = modules, mcnt = 0 ; rout ; rout = rout->next )
  {
   for ( ; what = rout->refs ; rout->refs = what->next, free(what) )
    *what->patch = mcnt;
   rout->value = mcnt++;
#ifdef vms
   fprintf(exe,"#include \"%s%s.h\"\n",INCDEF,rout->name);
#else
   fprintf(exe,"#include <%s%s%s.h>\n",DIRDEF,INCDEF,rout->name);
#endif
  }
 if ( inline ) fprintf(exe,"\nextern short pcb%s_table[];\n",ident);
 fprintf(exe,"\nchar *pcb%s_module[] =\n\t{\n",ident);
 fprintf(exe,"\t \"%s\",\n",outname);
 if ( inline )
  fprintf(exe,"\t (char *)pcb%s_table,\n",ident);
 else
  fprintf(exe,"\t (char *)0,\n");
 fprintf(exe,"\t (char *)0x%02lx,\n",pcb->pcb_Version);
 fprintf(exe,"\t (char *)%d,\n",acnt);
 fprintf(exe,"\t (char *)pcb%s_actions,",ident);
 fprintf(exe,"\n\t (char *)%d",mcnt);
 for ( rout = modules ; rout ; rout = rout->next )
  fprintf(exe,",\n\t (char *)pcb%s_module",rout->name);
 fprintf(exe,"\n\t};\n\n");
 if ( pcb->pcb_Command == CCopy )
  {
   fprintf(exe,"#define PCB struct epcb%s\n\n",ident);
   if ( (len = buf+blen-cur) && (fwrite(cur,1,len,exe) != len) )
    {
     fprintf(stderr,"Headerdatei konnte nicht geschrieben werden\n");
     fail(4);
    }
   while ( (blen = fread(buf,1,sizeof(buf),src)) > 0 )
    if ( fwrite(buf,1,blen,exe) != blen )
     {
      fprintf(stderr,"Headerdatei konnte nicht geschrieben werden\n");
      fail(4);
     }
   fprintf(exe,"\n#undef PCB\n");
  }
 if ( blen < 0 )
  {
   fprintf(stderr,"Eingabedatei konnte nicht gelesen werden\n");
   fail(3);
  }
 if ( !incok )
  fprintf(inc,"\nstruct epcb%s\n\t{\n\t struct pcb sys_pcb;\n",ident);
 fprintf(inc,"\t};\n\n");
 fprintf(inc,"#ifndef PCB%s_INLINE\n",ident);
 if ( inline ) fprintf(inc,"extern short pcb%s_table[];\n",ident);
 fprintf(inc,"extern char *pcb%s_module[];\n#endif\n\n",ident);
 dostate((char *)0,0,0);
 if ( verbose ) printf("%d Zeile(n) uebersetzt\n",line);
 if ( err )
  {
   fprintf(stderr,"%d Fehler gefunden\n",err);
   fail(3);
  }
 if ( !(pcb->pcb_Charsets&GotClear) ) pcb->pcb_Clear = pcb->pcb_Defined;
}

static struct defined *alldef(where,name,value)
struct defined **where;
char *name;
long value;
{
 struct defined *new;

 if ( !(new = (struct defined *)malloc(sizeof(*new))) ) nomem(3);
 new->next = *where;
 new->name = name;
 new->value = value;
 *where = new;
 return new;
}

static dostate(name,nlen,debug)
char *name;
int nlen,debug;
{
 struct ref *what;
 struct defined *ds = 0;
 char *ns,lambda[24];

 if ( hasstate )
  {
   *lambda = pcb->pcb_FirstChar;
   strcpy(lambda+1,"trans p$lambda,p$fail");
   parse(pcb,lambda);
   dotrans((int)pcb->pcb_Opcode,(int)pcb->pcb_Options,
           (char *)0,0,(char *)0,0,(char *)0,0,(char *)0,0,
	   (char *)0,0,(char *)0,0,(char *)0,0,
           (char *)pcb->pcb_Label,(int)pcb->pcb_LabelLen);
  }  
 for ( ; what = tonext ; tonext = what->next, free(what) )
  *what->patch = delta((cpos-what->pos)/2);
 if ( nlen )
  {
   ns = makename(name,nlen,"",3);
   if ( ds = find(&states,ns,1) )
    {
     free(ns);
     ds->next = states;
     states = ds;
     if ( ds->value != -1 )
      {
       fprintf(stderr,"%5d: Zustand '%s' mehrfach definiert\n",line,ds->name);
       if ( lst )
        fprintf(lst,"%6d: Zustand '%s' mehrfach definiert\n",line,ds->name);
       err++;
      }
     else
      {
       for ( ; what = ds->refs ; ds->refs = what->next, free(what) )
        *what->patch = delta((cpos-what->pos)/2);
       ds->value = cpos;
      }
    }
   else
    {
     ds = alldef(&states,ns,(long)cpos);
     ds->refs = 0;
    }
  }
 if ( ds && (ds->flags = (debugging && debug)) ) dsize += 4+((nlen+2)&~1);
}

static dotrans(cod,opt,key,kl,sub,sl,mod,xl,act,al,par,pl,mas,ml,adr,dl,lab,ll)
int cod,opt,kl,sl,xl,al,pl,ml,dl,ll;
char *key,*sub,*mod,*act,*par,*mas,*adr,*lab;
{
 int size;
 char opcode[2],*ns,*op;
 struct defined *mask;

 if ( lst && lmach ) fprintf(lst,"%06lx: ",cpos);
 size = 3;
 if ( kl ) size += 2+(kl>>1);
 if ( sl ) size += 1;
 if ( xl ) size += 1;
 if ( al ) size += 1;
 if ( pl ) size += 2;
 if ( ml ) size += 2;
 if ( dl ) size += 1;
 if ( opt&fm_onekey )
  {
   opcode[0] = opt;
   opcode[1] = cod;
   op = (char *)-2;
  }
 else
  {
   opcode[0] = cod;
   opcode[1] = opt;
   op = (char *)-1; 
  }
 add_item(opcode,2);
 op += (long)(last->data+cpos-last->offset);
 if ( kl ) 
  {
   size--;
   add_short(size-1-(kl>>1));
  }
 if ( sl ) 
  {
   size--;
   resolve(sub,sl);
  }
 if ( xl ) 
  {
   size--;
   ref_act(&modules,mod,xl);
  }
 add_short(size-1);
 resolve(lab,ll);
 if ( al ) ref_act(&acts,act,al);
 if ( pl ) reference(par,pl,op,(int)fm_pvar);
 if ( ml ) reference(mas,ml,op,(int)fm_mvar);
 if ( dl )
  {
   ns = makename(adr,dl,"",3);
   if ( mask = find(&vars,ns,0) )
    add_short(mask->value);
   else
    {
     fprintf(stderr,"%5d: Variable '%s' nicht definiert\n",line,ns);
     if ( lst ) fprintf(lst,"%6d: Variable '%s' nicht definiert\n",line,ns);
     err++;
    }
   free(ns);
  }
 if ( kl ) 
  {
   add_item(key,kl);
   add_item("\0",1);
   if ( !(kl&1) ) add_item("\0",1);
  }
 if ( lst && lmach ) fprintf(lst,"\n");
}

static resolve(state,slen)
char *state;
int slen;
{
 struct defined *ds;
 struct ref **rlist;
 char *ns;

 if ( slen < 0 )
  {
   add_short(slen);
   return 0;
  }
 if ( slen )
  {
   ns = makename(state,slen,"",3);
   if ( ds = find(&states,ns,0) )
    { 
     free(ns);
     if ( ds->value != -1 )
      {
       add_short(delta((ds->value-cpos)/2));
       return 0;
      }
    }
   else
    {
     ds = alldef(&states,ns,-1L);
     ds->flags = 0;
     ds->refs = 0;
    }
   rlist = &ds->refs;
  }
 else
  rlist = &tonext;
 add_ref(rlist);
}

static ref_act(list,name,nlen)
struct defined **list;
char *name;
int nlen;
{
 char *nn;
 int cmp;
 struct defined *rout,**prev;
 struct ref *nref;

 nn = makename(name,nlen,"",3);
 for ( prev = list, cmp = 1 ; rout = *prev ; prev = &rout->next )
  if ( (cmp = strcmp(nn,rout->name)) <= 0 ) break;
 if ( !cmp )
  free(nn);
 else
  (rout = alldef(prev,nn,-1L))->refs = 0;
 add_ref(&rout->refs);
}

static add_ref(rlist)
struct ref **rlist;
{
 struct ref *newr;

 if ( !(newr = (struct ref *)malloc(sizeof(*newr))) ) nomem(3);
 doref = 1;
 add_short(0);
 doref = 0;
 newr->next = *rlist;
 newr->pos = cpos-2;
 newr->patch = (short *)(last->data+newr->pos-last->offset);
 *rlist = newr;
}

static reference(name,nlen,opp,flag)
char *name,*opp;
int nlen,flag;
{
 struct defined *look;
 char *ns;

 if ( nlen < 0 )
  add_item((char *)&name,-4);
 else
  {
   ns = makename(name,nlen,"",3);
   if ( look = find(&cons,ns,0) )
    add_item((char *)&look->value,-4);
   else if ( look = find(&vars,ns,0) )
    {
     *opp |= flag;
     add_item((char *)&look->value,-4);
    }
   else
    {
     fprintf(stderr,"%5d: Konstante '%s' nicht definiert\n",line,ns);
     if ( lst ) fprintf(lst,"%6d: Konstante '%s' nicht definiert\n",line,ns);
     err++;
    }
   free(ns);
  }
}

static delta(value)
long value;
{
 if ( (value+0x00008000)&0xffff0000 )
  {
   fprintf(stderr,"%5d: Referenzierter Zustand zu weit entfernt\n",line);
   if ( lst )
    fprintf(lst,"%6d: Referenzierter Zustand zu weit entfernt\n",line);
   err++;
  }
 return value;
}

static dodefine(isconst,name,nlen,val,size,index)
int isconst,nlen,size,index;
char *name;
long val;
{
 struct defined *nd,**list;
 char *ns;

 ns = makename(name,nlen,"",3);
 list = isconst ? &cons : &vars;
 if ( find(list,ns,0) ) 
  {
   fprintf(stderr,"%5d: Symbol '%s' mehrfach definiert\n",line,ns);
   if ( lst ) fprintf(lst,"%6d: Symbol '%s' mehrfach definiert\n",line,ns);
   err++;
  }
 nd = alldef(list,ns,(long)val);
 if ( isconst )
  fprintf(inc,"#define %s 0x%08lx\n",nd->name,nd->value);
 else
  {
   switch (size)
    {
     case 1 : fprintf(inc,"\t char");
     	      break;
     case 4 : fprintf(inc,"\t long");
     	      break;
     case 8 : fprintf(inc,"\t struct descriptor");
     	      break;
    }
   fprintf(inc," pcb_%s",nd->name);
   if ( index > 1 ) fprintf(inc,"[%d]",index);
   fprintf(inc,";\n");
  }
}

/*
*/
struct defined *find(root,name,rem)
struct defined **root;
char *name;
int rem;
{
 struct defined *list,**prev = root;

 for ( ; list = *prev ; prev = &list->next )
  if ( !strcmp(list->name,name) )
   {
    if ( rem ) *prev = list->next;
    break;
   }
 return list;
}

static alloc_chunk(size)
int size;
{
 struct chunk *nc;

 if ( !(nc = (struct chunk *)malloc(sizeof(*nc)+size)) ) nomem(3);
 nc->next = 0;
 nc->offset = cpos;
 nc->size = size;
 nc->data = (char *)(nc+1);
 last->next = nc;
 last = nc;
}

add_item(value,size)
char *value;
int size;
{
 short data;
 long val;

 if ( !value )
  {
   data = size;
   value = (char *)&data;
   size = 2;
  }
 else if ( size == -4 )
  {
   bcopy(value,&val,4);
   add_short((int)((val>>16)&0xffff));
   add_short((int)(val&0xffff));
   return;
  }
 if ( !code ) alloc_chunk(CHUNK); 
 while ( size-- )
  {
   if ( cpos-last->offset == last->size ) alloc_chunk(CHUNK);
   if ( lst && lmach )
    if ( doref )
     fprintf(lst,"**");
    else
     fprintf(lst,"%02x",(int)((unsigned char)*value));
   last->data[cpos++-last->offset] = *value++;
  }
 if ( lst && lmach ) fprintf(lst," ");
}

/*
*/
struct header
       {
	short    magic;
	long     total;
	long     debug;
	unsigned char version;
	unsigned char flags;
	unsigned char abbr;
	unsigned char tabs;
	unsigned short size;
	unsigned short clear;
       } header;

generate()
{
 struct chunk *cur;
 struct defined *scan,*turn();
 int ix;

 header.magic = VERSION_MAGIC;
 header.total = (header.debug = sizeof(header)+32*pcbm_tables+cpos)+dsize;
 header.version = pcb->pcb_Version;
 header.flags = pcb->pcb_HFlags;
 header.abbr = pcb->pcb_HAbbr;
 header.tabs = pcbm_tables;
 header.size = pcb->pcb_Defined;
 header.clear = pcb->pcb_Clear;
 tabheader();
 tabwrite((char *)&header,sizeof(header));
 for ( ix = 0 ; ix < pcbm_tables ; ix++ )
  if ( (1L<<ix)&pcb->pcb_Charsets )
   tabwrite(((char *)pcb->pcb_Tables)+32*ix,32);
  else
   tabwrite(((char *)pcb->sys_pcb.pcb_table1)+32*ix,32);
 if ( code ) last->size = cpos-last->offset;
 for ( ; cur = code ; code = cur->next, free(cur) )
  tabwrite(cur->data,cur->size);
 states = turn(states);
 if ( dsize )
  for ( scan = states ; scan ; scan = scan->next )
   if ( scan->flags )
    {
     tabwrite((char *)&scan->value,4);
     tabwrite(scan->name,((strlen(scan->name)+2)&~1));
    }
 tabtrailer();
 if ( lst )
  {
   fprintf(lst,"\n%d Zeile(n), %ld Byte(s) Code erzeugt\n",line,cpos);
   if ( lstates && (scan = states) )
    {
     fprintf(lst,"\n\t%-30sPosition\n","Zustand");
     do
      fprintf(lst,"\t%-30s%08lx (%6ld)%s\n",scan->name,scan->value,
		  scan->value,scan->flags ? "  Name eingetragen" : "");
     while ( scan = scan->next );
    }
   if ( lacts && (scan = acts) )
    {
     fprintf(lst,"\n\t%-30sIndex\n","Routine");
     do
      fprintf(lst,"\t%-30s%3ld\n",scan->name,scan->value);
     while ( scan = scan->next );
    }
   if ( lvars && (scan = turn(vars)) )
    {
     fprintf(lst,"\n\t%-30sOffset\n","Variable");
     do
      fprintf(lst,"\t%-30s%6ld%c\n",scan->name,scan->value,
		  (scan->value >= pcb->pcb_Clear) ? '*' : ' ');
     while ( scan = scan->next );
    }
   if ( lcons && (scan = turn(cons)) )
    {
     fprintf(lst,"\n\t%-30sWert\n","Konstante");
     do
      fprintf(lst,"\t%-30s%08lx (%11ld)\n",
		  scan->name,scan->value,scan->value);
     while ( scan = scan->next );
    }
   if ( lext && (scan = modules) )
    {
     fprintf(lst,"\n\t%-30sNummer\n","Modul");
     do
      fprintf(lst,"\t%-30s%3ld\n",scan->name,scan->value);
     while ( scan = scan->next );
    }
  }
}

static tabheader()
{
 if ( inline ) fprintf(exe,"\nshort pcb%s_table[] =\n\t{",ident);
}

static tabtrailer()
{
 if ( inline ) fprintf(exe,"\n\t};\n");
}

static tabwrite(data,len)
char *data;
int len;
{
 static int first = 1;
 unsigned short buf;
 int cnt;
 
 if ( inline )
  {
   if ( !first ) fprintf(exe,",");
   first = cnt = 0;
   for ( len >>= 1 ; len-- ; data += 2 )
    {
     if ( !cnt-- )
      {
       fprintf(exe,"\n\t ");
       cnt = 7;
      }
     bcopy(data,&buf,2);
     fprintf(exe,"0x%04x",(int)buf);
     if ( len ) fprintf(exe,",");
    }   
  }
 else if ( fwrite(data,1,len,tab) != len )
  {
   fprintf(stderr,"Tabelle konnte nicht geschrieben werden\n");
   fail(4);
  }
}

static struct defined *turn(list)
struct defined *list;
{
 struct defined *scan = list,*turned;

 for ( turned = 0 ; list = scan ; )
  {
   scan = list->next;
   list->next = turned;
   turned = list;
  }
 return turned;
}
