#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = "saphir"
endif
if ( ($#argv >= 2) && ("$2" != "") ) then
  set DEVLIB = "$2"
else if ( ! $?DEVLIB ) then
  set DEVLIB = "/usr/src/uts/aviion/lb/boss.a"
endif
  
#
# parallel.csh [(DIRDEF | "") [DEVLIB]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
***  
***  
***  USAGE: $0 [(DIRDEF | "") [DEVLIB]]
***  
***    DIRDEF  is the name of the project (saphir)
***    DEVLIB  is the library for the driver object code
***            (/usr/src/uts/aviion/lb/boss.a)
***  
***  
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++
+++  driver object library          =   $DEVLIB
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif

#
# Aufrauemen
#
set CLEAN="dev_parallel_driver.o"
action cleaning up
rm -f $CLEAN

#
# Headerdatei kopieren
#
action copying header files
check cp parallel.h "$LIBDIR1"

#
# Treiber erzeugen
#
action creating parallel driver 
check make
action copying object to library
check ar rv "$DEVLIB" dev_parallel_driver.o

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action parallel driver installation complete

