#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ! $?TABDIR ) then
  set TABDIR = /usr/tables
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
if ( ($#argv >= 2) && ("$2" != "") ) then
  set INCDEF = "$2"
else if ( ! $?INCDEF ) then
  set INCDEF = modules
endif
    
#
# module.csh [(DIRDEF|"") [INCDEF]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 [(DIRDEF|"") [INCDEF]]
*** 
***    DIRDEF  is the name of the project (saphir)
***    INCDEF  is the name of the module directory (modules)
*** 
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# INCDEF ist ein Unterverzeichnis in $INCDIR. Es muss immer mit einem 
# / beginnen und enden.
#
if ( "$INCDEF" == "" ) then
  set INCDEF = /
else
  set key = `echo "$INCDEF" | sed -n 's/^\(.\).*$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = /"$INCDEF"
  endif
  set key = `echo "$INCDEF" | sed -n 's/^.*\(.\)$/\1/p'`
  if ( "$key" != "/" ) then
    set INCDEF = "$INCDEF"/
  endif
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set LIBDIR2 = `echo "$LIBDIR1$INCDEF" | sed -n 's/^\(.*\)\/$/\1/p'`
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++  parser module directory        =   $LIBDIR2
+++  parser table directory         =   $TABDIR
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating project include directory "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif
if ( ! -d "$LIBDIR2" ) then
  action creating parser module directory "$LIBDIR2"
  check mkdir "$LIBDIR2"
endif
if ( ! -d "$TABDIR" ) then
  action creating table directory "$TABDIR"
  check mkdir "$TABDIR"
endif

#
# Aufrauemen
#
set CLEAN=`ls *.p | sed -n 's/^\(.*\)\.p$/\1\.\[chot]\ /p'`
action cleaning up
rm -f $CLEAN

#
# Dateien erzeugen
#
action creating objects and tables
check make all

#
# Kopieren
#
action copying header files
check cp *.h "$LIBDIR2"
action copying parser tables
check cp *.t "$TABDIR"
action copying objects
check ar rv "$OBJLIB" *.o

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action command language definition modules installation complete

