;
; $UIC   = [|< uicval >|]
;
; uicval = <octal>|* , <octal>|*
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets
;
Flags	= EXPLICITBLANKING
;
Definitions
Clear
	long tree
	long UIC[2]
;

Rules

State Initial
Trans '<',uic1
Trans '[',uic2

State uic1
Trans !uic

State
Trans '>',p$Exit,MakeTree

State uic2
Trans !uic

State
Trans ']',p$Exit,MakeTree

State uic
Trans !uicval

State
Trans ','

State
Trans !uicval,p$Exit

State uicval
Trans '*',p$Exit,UICMerge,,,1
Trans p$Octal,p$Exit,UICMerge,,,0

;
Inline

static UICMerge(pcb,val)
PCB *pcb;
long val;
{
 if ( val )
  val = 0177777;
 else
  {
   val = pcb->sys_pcb.pcb_token;
   if ( (val < 0) || (val >= 037777) ) return parse_fail;
  }
 pcb->pcb_UIC[1] = (pcb->pcb_UIC[1]<<16)+val;
 return parse_exit;
}

static MakeTree(pcb)
PCB *pcb;
{
 char temp[16],*createValue();

 sprintf(temp,"[%06lo,%06lo]",
	 (pcb->pcb_UIC[1]>>16)&0xffff,pcb->pcb_UIC[1]&0xffff);
 if ( !(pcb->pcb_tree = 
	(long)createValue(temp,strlen(temp),-1,
			  sizeof(pcb->pcb_UIC),pcb->pcb_UIC)) )
  return CDU_NOMEM;
 return parse_exit;
}
