;
; $NUMBER = '%X'<hexadecimal>
;	    '%O' <octal>
;	    '%D' <decimal>
;	    <decimal>
;	    '"' $NUMBER ['"']
;
; Innerhalb von Hochkommas knnen vor und nach $NUMBER belibig Leerzeichen
; und Tabulatoren verwendet werden.
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets
;
Flags	= EXPLICITBLANKING
;
Definitions
Clear
	long tree
	long value[2]
;

Rules
State	Initial
Trans	'"'
Trans	p$Lambda,DoNumber

State	StringStart
Trans	p$Blank,StringStart
Trans	!DoNumber

State	StringEnd
Trans	'"',p$Exit
Trans	p$Eos,p$Exit
Trans	p$Blank,StringEnd
Trans	p$Lambda,p$Fail,FreeResult

State   DoNumber
Trans	'%'
Trans	p$Lambda,DoDecimal

State
Trans	'D',DoDecimal
Trans	'X',DoHexadecimal
Trans	'O',DoOctal

State	DoDecimal
Trans	p$Decimal,p$Exit,MakeResult

State	DoHexadecimal
Trans	p$Hex,p$Exit,MakeResult

State	DoOctal
Trans	p$Octal,p$Exit,MakeResult

;
Inline

static MakeResult(pcb)
PCB *pcb;
{
 char temp[12],*createValue();

 pcb->pcb_value[1] = pcb->sys_pcb.pcb_token;
 sprintf(temp,"%lu",pcb->sys_pcb.pcb_token);
 if ( !(pcb->pcb_tree = 
	(long)createValue(temp,strlen(temp),-1,
			  sizeof(pcb->pcb_value),pcb->pcb_value)) )
  return CDU_NOMEM;
 return parse_exit;
}

static FreeResult(pcb)
PCB *pcb;
{
 if ( pcb->pcb_tree ) free(pcb->pcb_tree);
 return parse_fail;
}
