;
; $NODE = [nodename] [proxy] 
;
; nodename = <symbol>
; proxy    = '"' <symbol> ['"']
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets

SymbolStart 	    = 'A'..'Z','a'..'z','0'..'9'
SymbolChars 	    = 'A'..'Z','a'..'z','0'..'9'
;
Flags	= EXPLICITBLANKING
;
Definitions
Clear
	long tree
	long start
	long upper
;

Rules

State Initial
Trans '"'
Trans p$Lambda,Value,SetStart,1,upper

State SkipHead
Trans p$Blank,SkipHead
Trans p$Lambda,,SetStart,0,upper

State
Trans p$Symbol,,MakeTree

State SkipTail
Trans p$Blank,SkipTail
Trans p$Eos,p$Exit
Trans '"',p$Exit
Trans p$Lambda,p$Fail,FreeTree

State Value
Trans p$Symbol,p$Exit,MakeTree

;
Inline

static SetStart(pcb)
PCB *pcb;
{
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

static MakeTree(pcb)
PCB *pcb;
{
 char *start = (char *)pcb->pcb_start,*createValue();
 int len,up = pcb->pcb_upper;

 if ( (len = pcb->sys_pcb.pcb_line-start) <= 0 ) return parse_fail;
 if ( !(pcb->pcb_tree = (long)createValue(start,len,up,0)) ) return CDU_NOMEM;
 return parse_exit;
}

static FreeTree(pcb)
PCB *pcb;
{
 free(pcb->pcb_tree);
 return parse_exit;
}
