;
; $IDENT = %X<hex> | <symbol> | <|[ <uicid> [ , <uicid>] ]|>
;
; <uicid>      = <octal> | * | <symbol>
;
Version 1.1
;
Include <saphir/CLD.h>
;
Character Sets

SymbolStart = 'A'..'Z','a'..'z','0'..'9','_','$'
SymbolChars = 'A'..'Z','a'..'z','0'..'9','_','$'
;
Definitions
Clear
     long tree
     long value[4]
;
Rules

State Initial
Trans '%',hexid
Trans '[',uicid1
Trans '<',uicid2
Trans p$Symbol,p$Exit,SetIdent,,,0

State hexid
Trans 'X'

State
Trans p$Hex,p$Exit,SetIdent,,,1

State uicid1
Trans !uicid

State
Trans ']',p$Exit

State uicid2
Trans !uicid

State
Trans '>',p$Exit

State uicid
Trans !uic

State
Trans ','
Trans p$Lambda,p$Exit

State uic
Trans '*',p$Exit,SetIdent,,,2
Trans p$Octal,p$Exit,SetIdent,,,3
Trans p$Symbol,p$Exit,SetIdent,,,0

;
Inline

#define vIDENT(n) pcb->pcb_value[(n)]
#define vLEN(n)   pcb->pcb_value[(n)+2]

static SetIdent(pcb,what)
PCB *pcb;
long what;
{
 int ix = vLEN(0) ? 1 : 0;
 long uic;

 switch (what)
  {
   case 0 : vIDENT(ix) = pcb->sys_pcb.pcb_token;
            vLEN(ix) = pcb->sys_pcb.pcb_line-(char *)pcb->sys_pcb.pcb_token;
            break;
   case 1 : vIDENT(ix) = pcb->sys_pcb.pcb_token;
            vLEN(ix) = -1;
            break;
   case 2 : vIDENT(ix) = 0177777;
            vLEN(ix) = -1;
            break;
   case 3 : if ( ((uic = pcb->sys_pcb.pcb_token) < 0) || (uic > 037776) )
             return parse_fail;
            vIDENT(ix) = uic;
            vLEN(ix) = -1;
            break;
  }
 return parse_exit;
}
