;
; $EXPRESSION = <VAX DCL expression> = <ex1>
;
Version 1.0
;
Include	<saphir/CLD.h>
;
Character Sets

Legal       = 1..255
SymbolStart = 'A'..'Z','a'..'z','$','_'
SymbolChars = 'A'..'Z','a'..'z','$','_','0'..'9'
FileChars   = 1..255,-'!',-'+',-'-',-'/',-'*',-'.',-',',-'(',-')',-'"',-'[',-']',-BLANK,-TAB
;
Flags	    = EXPLICITBLANKING
Abbrevation = UNIQUE
;
Definitions
Clear
	long 	    tree
	long 	    start
	descriptor  value
	long        remember
	EXPR_OR		=	1
	EXPR_AND	=	2
	EXPR_NOT	=	3
	EXPR_NE		=	4
	EXPR_LT		=	5
	EXPR_LE		=	6
	EXPR_GT		=	7
	EXPR_GE		=	8
	EXPR_EQ		=	9
	EXPR_NES	=	10
	EXPR_LTS	=	11
	EXPR_LES	=	12
	EXPR_GTS	=	13
	EXPR_GES	=	14
	EXPR_EQS	=	15
	EXPR_SUB	=	16
	EXPR_ADD	=	17
	EXPR_DIV	=	18
	EXPR_MUL	=	19
	EXPR_NEG	=	20
	EXPR_CALL	=	21
	EXPR_MERGE	=	22
	PUSH_NULL	=	100
	PUSH_NUMBER	=	101
	PUSH_STRING	=	102
	PUSH_QUOTED	=	103
	PUSH_FUNCTION	=	104
	LEX_NULL	=	200
	LEX_CVSI	=	201
	LEX_CVTIME	=	202
	LEX_CVUI	=	203
	LEX_DIRECTORY	=	204
	LEX_EDIT	=	205
	LEX_ELEMENT	=	206
	LEX_ENVIRONMENT	=	207
	LEX_EXTRACT	=	208
	LEX_FAO		=	209
	LEX_FILE_ATTR   =	210
	LEX_GETDVI	=	211
	LEX_GETJPI	=	212
	LEX_GETQUI	=	213
	LEX_GETSYI	=	214
	LEX_IDENTIFIER	=	215
	LEX_INTEGER	=	216
	LEX_LENGTH	=	217
	LEX_LOCATE	=	218
	LEX_LOGICAL	=	219
	LEX_MESSAGE	=	220
	LEX_MODE	=	221
	LEX_PARSE	=	222
	LEX_PID		=	223
	LEX_PRIVILEGE	=	224
	LEX_PROCESS	=	225
	LEX_SEARCH	=	226
	LEX_SETPRV	=	227
	LEX_STRING	=	228
	LEX_TIME	=	229
	LEX_TRNLNM	=	230
	LEX_TYPE	=	231
	LEX_USER	=	232
	LEX_VERIFY	=	233
	ERR_EX1		=	1
	ERR_EX2		=	2
	ERR_EX3		=	3
	ERR_EX4		=	4
	ERR_EX5		=	5
	ERR_EX6		=	6
	ERR_EX7		=	7
	ERR_EX8		=	8
	ERR_EX9		=	9
	ERR_RADIX	=	10
	ERR_HEX		=	11
	ERR_OCT		=	12
	ERR_QUOTED	=	13
;	
Rules

State Initial
Trans !NoBlanks,ex1,SetStart

;
; <ex1> = <ex2> { '.OR.' <ex2> }
;
State ex1
Trans !ex2
Trans p$Lambda,p$Exit,SetError,,,ERR_EX2

State ex1l
Trans !OR
Trans p$Lambda,p$Exit,MakeTree

State
Trans !ex2,ex1l,Operation,,,EXPR_OR
Trans p$Lambda,p$Exit,SetError,,,ERR_EX2

;
; <ex2> = <ex3> { '.AND.' <ex3> }
;
State ex2
Trans !ex4
Trans p$Lambda,p$Exit,SetError,,,ERR_EX4

State ex2l
Trans !AND
Trans p$Lambda,p$Exit,MakeTree

State
Trans !ex4,ex2l,Operation,,,EXPR_AND
Trans p$Lambda,p$Exit,SetError,,,ERR_EX4

;
; <ex3>    = {'.NOT.'} <ex4>
; <ex4>    = <ex5> [ <cmp> <ex5> ]
; <cmp>    = <intcmp>|<strcmp>
; <intcmp> = '.NE.'|'.LT.'|'.LE.'|'.GT.'|'.GE.'|'.EQ.'|'.NES.'
; <strcmp> = '.LTS.'|'.LES.'|'.GTS.'|'.GES.'|'.EQS.'
;
State ex4
Trans !ex5
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State
Trans !NE,doNE
Trans !LT,doLT
Trans !LE,doLE
Trans !GT,doGT
Trans !GE,doGE
Trans !EQ,doEQ
Trans !NES,doNES
Trans !LTS,doLTS
Trans !LES,doLES
Trans !GTS,doGTS
Trans !GES,doGES
Trans !EQS,doEQS
Trans p$Lambda,p$Exit,MakeTree

State doNE
Trans !ex5,p$Exit,Operation,,,EXPR_NE
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doLT
Trans !ex5,p$Exit,Operation,,,EXPR_LT
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doLE
Trans !ex5,p$Exit,Operation,,,EXPR_LE
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doGT
Trans !ex5,p$Exit,Operation,,,EXPR_GT
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doGE
Trans !ex5,p$Exit,Operation,,,EXPR_GE
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doEQ
Trans !ex5,p$Exit,Operation,,,EXPR_EQ
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doNES
Trans !ex5,p$Exit,Operation,,,EXPR_NES
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doLTS
Trans !ex5,p$Exit,Operation,,,EXPR_LTS
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doLES
Trans !ex5,p$Exit,Operation,,,EXPR_LES
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doGTS
Trans !ex5,p$Exit,Operation,,,EXPR_GTS
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doGES
Trans !ex5,p$Exit,Operation,,,EXPR_GES
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

State doEQS
Trans !ex5,p$Exit,Operation,,,EXPR_EQS
Trans p$Lambda,p$Exit,SetError,,,ERR_EX5

;
; <ex5> = <ex6> { ('+'|'-') <ex6> }
;
State ex5
Trans !ex6
Trans p$Lambda,p$Exit,SetError,,,ERR_EX6

State ex5l
Trans !NoBlanks

State
Trans '+',doADD
Trans '-',doSUB
Trans p$Lambda,p$Exit,MakeTree

State doADD
Trans !ex6,ex5l,Operation,,,EXPR_ADD
Trans p$Lambda,p$Exit,SetError,,,ERR_EX6

State doSUB
Trans !ex6,ex5l,Operation,,,EXPR_SUB
Trans p$Lambda,p$Exit,SetError,,,ERR_EX6

;
; <ex6> = <ex7> { ('*'|'/') <ex7> }
;
State ex6
Trans !ex7
Trans p$Lambda,p$Exit,SetError,,,ERR_EX7

State ex6l
Trans !NoBlanks

State
Trans '/',doDIV
Trans '*',doMUL
Trans p$Lambda,p$Exit,MakeTree

State doDIV
Trans !ex7,ex6l,Operation,,,EXPR_DIV
Trans p$Lambda,p$Exit,SetError,,,ERR_EX7

State doMUL
Trans !ex7,ex6l,Operation,,,EXPR_MUL
Trans p$Lambda,p$Exit,SetError,,,ERR_EX7

;
; <ex7> = {('+'|'-')} <ex8>
;
; Special treatment for special precedence of .NOT. ABOVE some dyadic operators
;
State ex7
Trans !NOT,doNOT
Trans !NoBlanks

State
Trans '-'
Trans '+',ex7
Trans p$Lambda,ex8

State ex7l
Trans !NOT,doNEG
Trans !NoBlanks

State
Trans '-',ex7
Trans '+',ex7l
Trans !ex8,p$Exit,Operation,,,EXPR_NEG
Trans p$Lambda,p$Exit,SetError,,,ERR_EX8

State doNEG
Trans !doNOT,p$Exit,Operation,,,EXPR_NEG

State doNOT
Trans !NOT
Trans !ex4,p$Exit,Operation,,,EXPR_NOT
Trans p$Lambda,p$Exit,SetError,,,ERR_EX4

State 
Trans !NOT,doNOT
Trans p$Lambda,ex4

;
; <ex8>           = %X<hex>|%O<oct>|<string>|<quoted string>|<funccall>|<ex9>
; <string>	  = <any but not '.', ',', '-', '+', '*', '/', ')', etc, see FileChars>
; <quoted string> = '"' { <any but not '"'> }
; <funccall>	  = <string> '(' [ [<ex1>] { ',' [<ex1>] } ] ')'
; <ex9>		  = '(' <ex1> ')'
;
State ex8
Trans !NoBlanks

State
Trans '(',ex9
Trans '%',radix
Trans p$Decimal,p$Exit,Operation,,,PUSH_NUMBER
Trans !funcstart,p$Exit,Operation,,,EXPR_CALL
Trans p$File,string,Operation,,,PUSH_STRING
Trans '"',quoted,SetQuote

State ex9
Trans !ex1
Trans p$Lambda,p$Exit,SetError,,,ERR_EX1

State
Trans !NoBlanks

State
Trans ')',p$Exit
Trans p$Lambda,p$Exit,SetError,,,ERR_EX9

State radix
Trans 'X',hex
Trans 'O',octal
Trans p$Lambda,p$Exit,SetError,,,ERR_RADIX

State hex
Trans p$Hex,p$Exit,Operation,,,PUSH_NUMBER
Trans p$Lambda,p$Exit,SetError,,,ERR_HEX

State octal
Trans p$Octal,p$Exit,Operation,,,PUSH_NUMBER
Trans p$Lambda,p$Exit,SetError,,,ERR_OCT

State string
Trans '"',,SetQuote
Trans p$Lambda,p$Exit

State
Trans !quoted,p$Exit,Operation,,,EXPR_MERGE
Trans p$Lambda,p$Exit,SetError,,,ERR_QUOTED

State funcstart
Trans 'F$CVSI',,Operation,,,LEX_CVSI
Trans 'F$CVTIME',,Operation,,,LEX_CVTIME
Trans 'F$CVUI',,Operation,,,LEX_CVUI
Trans 'F$DIRECTORY',,Operation,,,LEX_DIRECTORY
Trans 'F$EDIT',,Operation,,,LEX_EDIT
Trans 'F$ELEMENT',,Operation,,,LEX_ELEMENT
Trans 'F$ENVIRONMENT',,Operation,,,LEX_ENVIRONMENT
Trans 'F$EXTRACT',,Operation,,,LEX_EXTRACT
Trans 'F$FAO',,Operation,,,LEX_FAO
Trans 'F$FILE_ATTRIBUTES',,Operation,,,LEX_FILE_ATTR
Trans 'F$GETDVI',,Operation,,,LEX_GETDVI
Trans 'F$GETJPI',,Operation,,,LEX_GETJPI
Trans 'F$GETQUI',,Operation,,,LEX_GETQUI
Trans 'F$GETSYI',,Operation,,,LEX_GETSYI
Trans 'F$IDENTIFIER',,Operation,,,LEX_IDENTIFIER
Trans 'F$INTEGER',,Operation,,,LEX_INTEGER
Trans 'F$LENGTH',,Operation,,,LEX_LENGTH
Trans 'F$LOCATE',,Operation,,,LEX_LOCATE
Trans 'F$LOGICAL',,Operation,,,LEX_LOGICAL
Trans 'F$MESSAGE',,Operation,,,LEX_MESSAGE
Trans 'F$MODE',,Operation,,,LEX_MODE
Trans 'F$PARSE',,Operation,,,LEX_PARSE
Trans 'F$PID',,Operation,,,LEX_PID
Trans 'F$PRIVILEGE',,Operation,,,LEX_PRIVILEGE
Trans 'F$PROCESS',,Operation,,,LEX_PROCESS
Trans 'F$SEARCH',,Operation,,,LEX_SEARCH
Trans 'F$SETPRV',,Operation,,,LEX_SETPRV
Trans 'F$STRING',,Operation,,,LEX_STRING
Trans 'F$TIME',,Operation,,,LEX_TIME
Trans 'F$TRNLNM',,Operation,,,LEX_TRNLNM
Trans 'F$TYPE',,Operation,,,LEX_TYPE
Trans 'F$USER',,Operation,,,LEX_USER
Trans 'F$VERIFY',,Operation,,,LEX_VERIFY

State
Trans !NoBlanks

State
Trans '(',,Operation,,,PUSH_FUNCTION

State funccall
Trans !NoBlanks

State 
Trans ',',funccall,Operation,,,PUSH_NULL
Trans ')',p$Exit,Operation,,,PUSH_NULL
Trans p$Lambda

State
Trans !ex1
Trans p$Lambda,p$Exit,SetError,,,ERR_EX9

State
Trans !NoBlanks

State
Trans ')',p$Exit
Trans ',',funccall
Trans p$Lambda,p$Exit,SetError,,,ERR_EX9

State quoted
Trans '"'
Trans p$Any,quoted
Trans p$Eos,p$Exit,Operation,,,PUSH_QUOTED

State
Trans '"',quoted
Trans p$File
Trans p$Lambda

State
Trans '"',quoted
Trans p$Lambda,p$Exit,Operation,,,PUSH_QUOTED

;
; Patterns
;
State OR
Trans !NoBlanks
State
Trans '.'
State
Trans 'OR'
State
Trans '.',p$Exit

State AND
Trans !NoBlanks
State
Trans '.'
State
Trans 'AND'
State
Trans '.',p$Exit

State NOT
Trans !NoBlanks
State
Trans '.'
State
Trans 'NOT'
State
Trans '.',p$Exit

State NE
Trans !NoBlanks
State
Trans '.'
State
Trans 'NE'
State
Trans '.',p$Exit

State LT
Trans !NoBlanks
State
Trans '.'
State
Trans 'LT'
State
Trans '.',p$Exit

State LE
Trans !NoBlanks
State
Trans '.'
State
Trans 'LE'
State
Trans '.',p$Exit

State GT
Trans !NoBlanks
State
Trans '.'
State
Trans 'GT'
State
Trans '.',p$Exit

State GE
Trans !NoBlanks
State
Trans '.'
State
Trans 'GE'
State
Trans '.',p$Exit

State EQ
Trans !NoBlanks
State
Trans '.'
State
Trans 'EQ'
State
Trans '.',p$Exit

State NES
Trans !NoBlanks
State
Trans '.'
State
Trans 'NES'
State
Trans '.',p$Exit

State LTS
Trans !NoBlanks
State
Trans '.'
State
Trans 'LTS'
State
Trans '.',p$Exit

State LES
Trans !NoBlanks
State
Trans '.'
State
Trans 'LES'
State
Trans '.',p$Exit

State GTS
Trans !NoBlanks
State
Trans '.'
State
Trans 'GTS'
State
Trans '.',p$Exit

State GES
Trans !NoBlanks
State
Trans '.'
State
Trans 'GES'
State
Trans '.',p$Exit

State EQS
Trans !NoBlanks
State
Trans '.'
State
Trans 'EQS'
State
Trans '.',p$Exit

;
; Keine Leerzeichen erwuenschst
;
State NoBlanks
Trans p$Blank,p$Exit
Trans p$Lambda,p$Exit

;
Inline

/*
  Anfang des Strings vermerken.
*/
static SetStart(pcb)
PCB *pcb;
{
 pcb->pcb_start = (long)pcb->sys_pcb.pcb_line;
 return parse_exit;
}

/*
  Anfang eines Strings markieren.
*/
static SetQuote(pcb)
PCB *pcb;
{
 pcb->pcb_value.text = pcb->sys_pcb.pcb_line-1;
 return parse_exit;
}

/* 
  Ergebnis zusammenbauen.
*/
static MakeTree(pcb)
PCB *pcb;
{
 char *start = (char *)pcb->pcb_start;
 int len = pcb->sys_pcb.pcb_line-start;

 /* Zeile unveraendert uebergeben */
 if ( !(pcb->pcb_tree = (long)createValue(start,len,-1,0)) ) return CDU_NOMEM;
 return parse_exit;
}

/*
  Operation ausfuehren.
*/
int (*EXPRESSIONuser)() = 0 ;

static Operation(pcb,what)
PCB *pcb;
long what;
{
 int res;

 /* Nur, falls definiert */
 if ( !EXPRESSIONuser ) return parse_exit;
 /* Spezialoperation */
 if ( what > LEX_NULL )
  {
   pcb->pcb_remember = what;
   return parse_exit;
  }
 /* Stackoperationen */
 switch (what)
  {
   case PUSH_NUMBER   : pcb->pcb_value.len = pcb->sys_pcb.pcb_token;
		        break;
   case PUSH_STRING   : pcb->pcb_value.text = (char *)pcb->sys_pcb.pcb_token;
   case PUSH_QUOTED   : pcb->pcb_value.len = pcb->sys_pcb.pcb_line-pcb->pcb_value.text;
      		        break;
   case PUSH_FUNCTION : pcb->pcb_value.len = pcb->pcb_remember;
			break;
  }
 /* Benutzerprogramm aufrufen */
 return (*EXPRESSIONuser)(pcb,what);
}

/*
  Fehlercodes umsetzen.
*/
static SetError(pcb,err)
PCB *pcb;
long err;
{
 return CDU_ILLNUM;
}