;
; $DIRECTORY = " <any> ["]
;	     = [[node][proxy]::] [dev :] [dir] 
;
;
Version 1.1
;
Include	<saphir/CLD.h>
;
Character Sets

Legal	    = 1..255,-BLANK,-TAB
SymbolStart = 'A'..'Z','a'..'z','0'..'9','%','*'
SymbolChars = 'A'..'Z','a'..'z','0'..'9','%','*'
FileChars   = 'A'..'Z','a'..'z','0'..'9','$','_','-','%','*' 
;
Flags	= EXPLICITBLANKING
;
Definitions
Clear
	long tree
	long start[6]
;
Rules

State Initial
Trans '"',DoString
Trans p$Lambda,,SetStart,,,1

State
Trans !Node
Trans p$Lambda

State
Trans !Device
Trans p$Lambda

State
Trans !Directory
Trans p$Lambda,p$Exit,MakeTree,,,0

State Directory
Trans '[',DoDir1,SetStart,,,5
Trans '<',DoDir2,SetStart,,,5
Trans p$Lambda,p$Exit,MakeTree,,,0

State DoDir1
Trans !DoDir

State
Trans ']'

State NextDir
Trans '[',DoDir1
Trans '<',DoDir2
Trans p$Lambda,p$Exit,MakeTree,,,0

State DoDir2
Trans !DoDir

State
Trans '>',NextDir

State DoDir
Trans p$File
Trans p$Lambda

State
Trans '.',DoDir
Trans p$Lambda,p$Exit

State Node
Trans p$Symbol,,SetStart,,,2
Trans p$Lambda

State
Trans '"',Proxy,SetStart,,,3
Trans p$Lambda

State EndNode
Trans ':'
Trans p$Lambda,p$Fail,ClearStart,,,2

State
Trans ':',p$Exit
Trans p$Lambda,p$Fail,ClearStart,,,2

State Proxy
Trans '"'
Trans p$Eos,p$Exit
Trans p$Any,Proxy
Trans p$Blank,Proxy
Trans p$Lambda,p$Fail,ClearStart,,,2

State
Trans '"',Proxy
Trans p$Lambda,EndNode

State Device
Trans p$File,,SetStart,,,4

State
Trans ':',p$Exit
Trans '['
Trans '<'
Trans p$Lambda,p$Exit

State
Trans p$Lambda,p$Fail,ClearStart,,,4

State DoString
Trans p$Blank,DoString
Trans p$Lambda,,SetStart,,,1

State InString
Trans '"'
Trans p$Eos,p$Exit,MakeTree,,,1
Trans p$Any,InString
Trans p$Lambda,EndString,MakeTree,,,1

State
Trans '"',InString
Trans p$Lambda,p$Exit,MakeTree,,,2

State EndString
Trans '"',p$Exit
Trans p$Eos,p$Exit
Trans p$Blank,EndString
Trans p$Lambda,p$Fail,FreeTree

;
Inline

static SetStart(pcb,ix)
PCB *pcb;
long ix;
{
 if ( (ix == 2) || (ix == 4) )
  pcb->pcb_start[ix] = (long)pcb->sys_pcb.pcb_token;
 else
  { 
   pcb->pcb_start[ix] = (long)pcb->sys_pcb.pcb_line; 
   if ( ix > 1 ) pcb->pcb_start[ix]--; 
  }
 return parse_exit;
}

static ClearStart(pcb,ix)
PCB *pcb;
long ix;
{
 pcb->pcb_start[ix] = 0;
 if ( ix == 2 ) pcb->pcb_start[3] = 0;
 return parse_exit;
}

static MakeTree(pcb,quoted)
PCB *pcb;
long quoted;
{
 char *start = (char *)pcb->pcb_start[1],*createValue();
 int len,up = quoted-1;

 len = pcb->sys_pcb.pcb_line-start;
 if ( up == 1 )
  {
   up = 0;
   len--;
  }
 if ( len <= 0 ) return parse_fail;
 if ( !(pcb->pcb_tree = 
        (long)createValue(start,len,up,sizeof(pcb->pcb_start),pcb->pcb_start)) )
  return CDU_NOMEM;
 return parse_exit;
}

static FreeTree(pcb)
PCB *pcb;
{
 free(pcb->pcb_tree);
 return parse_exit;
}
